# -*- coding: utf-8 -*-
"""
/***************************************************************************
 VTDownloaderDialog
                                 A QGIS plugin
 A plugin to download GSI Vectortiles.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-04-26
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Kanahiro Iguchi
        email                : kanahiro.iguchi@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import time

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject, QgsPoint, QgsCoordinateReferenceSystem, QgsCoordinateTransform

from . import settings
from .gsi_geojson_generator import GsiGeojsonGenerator
from .rubberband_maptool import RubberbandMapTool

class VTDownloaderDialog(QtWidgets.QDialog):
    SOURCE_LAYERS = settings.SOURCE_LAYERS

    def __init__(self, iface):
        super().__init__()
        self.iface = iface
        self.previous_map_tool = None

        self.ui = uic.loadUi(os.path.join(os.path.dirname(__file__), 'vtdownloader_dialog_base.ui'), self)
        self.ui.maxAreaPushButton.clicked.connect(self._on_maxarea_pushbutton_clicked)
        self.ui.rubberBandPushButton.clicked.connect(self._on_rubberband_pushbutton_clicked)
        self.ui.closePushButton.clicked.connect(lambda:self.close())

        self.init_sourcelayer_combobox()
        self.ui.sourcelayer_combobox.currentIndexChanged.connect(self.reset_zoomlevel_combobox_by_selected_sourcelayer)
        self.reset_zoomlevel_combobox_by_selected_sourcelayer()

    def init_sourcelayer_combobox(self):
        for layer_key in self.SOURCE_LAYERS:
            layer_category = self.SOURCE_LAYERS[layer_key]['category']
            layer_type = self.SOURCE_LAYERS[layer_key]['datatype']
            combobox_str = '%s:%s(%s)'%(layer_key, layer_category, layer_type)
            self.ui.sourcelayer_combobox.addItem(combobox_str, layer_key)

    def reset_zoomlevel_combobox_by_selected_sourcelayer(self):
        self.ui.zoomlevel_combobox.clear()

        selected_layer_key = self.ui.sourcelayer_combobox.currentData()
        minzoom = self.SOURCE_LAYERS[selected_layer_key]['minzoom']
        maxzoom = self.SOURCE_LAYERS[selected_layer_key]['maxzoom']

        for i in range(maxzoom - minzoom + 1):
            self.ui.zoomlevel_combobox.addItem(str(i + minzoom), i + minzoom)

    def get_leftbottom_lonlat(self):
        extent = self.iface.mapCanvas().extent()
        leftbottom_qgspoint = QgsPoint(extent.xMinimum(), extent.yMinimum())
        
        current_crs = QgsProject.instance().crs()
        target_crs = QgsCoordinateReferenceSystem('EPSG:4326')
        transform = QgsCoordinateTransform(current_crs, target_crs, QgsProject.instance())

        leftbottom_qgspoint.transform(transform)
        leftbottom_lonlat = [leftbottom_qgspoint.x(), leftbottom_qgspoint.y()]

        return leftbottom_lonlat

    def get_righttop_lonlat(self):
        extent = self.iface.mapCanvas().extent()
        righttop_qgspoint = QgsPoint(extent.xMaximum(), extent.yMaximum())
        
        current_crs = QgsProject.instance().crs()
        target_crs = QgsCoordinateReferenceSystem('EPSG:4326')
        transform = QgsCoordinateTransform(current_crs, target_crs, QgsProject.instance())

        righttop_qgspoint.transform(transform)
        righttop_lonlat = [righttop_qgspoint.x(), righttop_qgspoint.y()]

        return righttop_lonlat

    def _on_maxarea_pushbutton_clicked(self):
        leftbottom_lonlat = self.get_leftbottom_lonlat()
        righttop_lonlat = self.get_righttop_lonlat()
        layer_key = self.ui.sourcelayer_combobox.currentData()
        zoomlevel = self.ui.zoomlevel_combobox.currentData()

        ggg = GsiGeojsonGenerator(leftbottom_lonlat,
                                    righttop_lonlat,
                                    layer_key,
                                    zoomlevel)
        ggg.run()
        
        self.close()

    def _on_rubberband_pushbutton_clicked(self):
        QtWidgets.QMessageBox.information(None, 'GSI-VTDownloader', 'マウスドラッグで矩形を定義してください')
        rubberband_tool = RubberbandMapTool(self.iface, self._on_rubberband_defined)
        self.previous_map_tool = self.iface.mapCanvas().mapTool()
        self.iface.mapCanvas().setMapTool(rubberband_tool)
        self.close()

    def _on_rubberband_defined(self, start_qgspoint, end_qgspoint):
        current_crs = QgsProject.instance().crs()
        target_crs = QgsCoordinateReferenceSystem('EPSG:4326')
        transform = QgsCoordinateTransform(current_crs, target_crs, QgsProject.instance())

        start_qgspoint_4326 = start_qgspoint
        start_qgspoint_4326.transform(transform)
        end_qgspoint_4326 = end_qgspoint
        end_qgspoint_4326.transform(transform)
        
        start_lonlat = [start_qgspoint_4326.x(), start_qgspoint_4326.y()]
        end_lonlat = [end_qgspoint_4326.x(), end_qgspoint_4326.y()]

        layer_key = self.ui.sourcelayer_combobox.currentData()
        zoomlevel = self.ui.zoomlevel_combobox.currentData()

        ggg = GsiGeojsonGenerator(start_lonlat,
                                end_lonlat,
                                layer_key,
                                zoomlevel,
                                clipmode=True)
        ggg.run()

        self.iface.mapCanvas().setMapTool(self.previous_map_tool)
        self.close()