import psycopg2

# Función de ajuste de coordenadas que acepta conexión, esquema y cuadro de texto para el estado
def ajuste_coordenadas(conexion, esquema, status_text):
    try:
        # Crear cursor y obtener el número total de registros
        cursor = conexion.cursor()
        cursor.execute(f"SET search_path TO {esquema}, public;")
        cursor.execute("SELECT COUNT(*) FROM cca_terreno;")
        total_registros = cursor.fetchone()[0]

        # Mostrar el total de registros en el cuadro de texto
        status_text.append(f"Total de registros a procesar: {total_registros}")

        # Obtener los t_id de la tabla cca_terreno
        cursor.execute("SELECT t_id FROM cca_terreno;")
        registros = cursor.fetchall()

        # Iterar sobre los registros y ajustar coordenadas
        for i, (t_id,) in enumerate(registros, start=1):
            # Consulta para ajustar coordenadas a 3 decimales para cada t_id
            consulta_sql = f"""
                WITH puntos_redondeados AS (
                    SELECT
                        ROUND(ST_X((coordenadas).geom)::numeric, 3) AS x,
                        ROUND(ST_Y((coordenadas).geom)::numeric, 3) AS y,
                        ROUND(ST_Z((coordenadas).geom)::numeric, 3) AS z,
                        (coordenadas).path[1] AS indice_poligono,
                        (coordenadas).path[2] AS indice_anillo_interior,
                        (coordenadas).path[3] AS indice_punto
                    FROM (
                        SELECT ST_DumpPoints(geometria) AS coordenadas
                        FROM cca_terreno
                        WHERE t_id = {t_id}
                    ) AS consulta_coordenadas
                ),
                lineas AS (
                    SELECT
                        indice_poligono,
                        ST_MakeLine(ARRAY_AGG(ST_SetSRID(ST_MakePoint(x, y, z), 9377) ORDER BY indice_punto)) AS linea
                    FROM puntos_redondeados
                    GROUP BY indice_poligono, indice_anillo_interior
                ),
                poligonos AS (
                    SELECT
                        indice_poligono,
                        ST_MakePolygon(linea) AS poligono
                    FROM lineas
                )
                SELECT ST_AsText(ST_Collect(poligono)) AS multipolygon
                FROM poligonos
                GROUP BY indice_poligono;
            """

            # Ejecutar la consulta
            cursor.execute(consulta_sql)
            resultado = cursor.fetchone()

            # Actualizar el cuadro de texto con el progreso
            status_text.append(f"Polígono con t_id {t_id} ajustado a 3 decimales ({i}/{total_registros}).")

        # Marcar el proceso como completado
        status_text.append("Proceso de ajuste completado.")
        cursor.close()
        conexion.commit()

    except psycopg2.Error as e:
        status_text.append(f"Error al procesar t_id {t_id}: {e}")
        conexion.rollback()
        cursor.close()

    finally:
        conexion.close()
