import psycopg2
import fiona
from pyproj import CRS
from shapely import wkb
from shapely.geometry import mapping, MultiPolygon, Polygon
from datetime import datetime
from qgis.core import QgsVectorLayer, QgsProject, QgsFillSymbol, QgsLineSymbolLayer
from PyQt5.QtWidgets import QMessageBox
from PyQt5.QtGui import QColor

def export_to_geopackage(conexion, output_folder, esquema):
    queries = {
        'FORMAL': f"""
            SELECT 
                pd.qr_operacion, 
                pd.qr_operacion_definitivo, 
                CASE
                    WHEN cpt.ilicode='NPH' then 'FORMAL_XXXXXX'
                    WHEN cpt.ilicode='Informal' then 'INFORMAL'
                    else cpt.ilicode
                end as condicion_predio,

                ST_AsBinary(ST_SetSRID(te.geometria, 9377)) AS geometria,
                ROUND((ST_Area(ST_Transform(te.geometria, 9377))::numeric), 2) as area_levantamiento,
                UPPER(drtp.ilicode) as derecho_tipo,
                CASE 
                    WHEN interv.ilicode='Colaborativo_Declarativo' then 'METODO_DECLARATIVO_Y_COLABORATIVO'
                    WHEN interv.ilicode='Indirecto' then 'METODO_INDIRECTO'
                    WHEN interv.ilicode='Mixto' then 'MIXTO'
                    WHEN interv.ilicode='Directo' then 'METODO_DIRECTO'
                end as metodo_levantamiento, 
                CASE
                    WHEN pd.departamento='13' then 'BOLIVAR'
                    WHEN pd.departamento='15' then 'BOYACA'
                    WHEN pd.departamento='17' then 'CALDAS'
                    WHEN pd.departamento='18' then 'CAQUETA'
                    WHEN pd.departamento='19' then 'CAUCA'
                    WHEN pd.departamento='20' then 'CESAR'
                    WHEN pd.departamento='23' then 'CORDOBA'
                    WHEN pd.departamento='25' then 'CUNDINAMARCA'
                    WHEN pd.departamento='27' then 'CHOCO'
                    WHEN pd.departamento='41' then 'HUILA'
                    WHEN pd.departamento='44' then 'LA GUAJIRA'
                    WHEN pd.departamento='47' then 'MAGDALENA'
                    WHEN pd.departamento='50' then 'META'
                    WHEN pd.departamento='52' then 'NARIÑO'
                    WHEN pd.departamento='54' then 'NORTE DE SANTANDER'
                    WHEN pd.departamento='63' then 'QUINDIO'
                    WHEN pd.departamento='66' then 'RISARALDA'
                    WHEN pd.departamento='68' then 'SANTANDER'
                    WHEN pd.departamento='70' then 'SUCRE'
                    WHEN pd.departamento='73' then 'TOLIMA'
                    WHEN pd.departamento='76' then 'VALLE DEL CAUCA'
                    WHEN pd.departamento='81' then 'ARAUCA'
                    WHEN pd.departamento='85' then 'CASANARE'
                    WHEN pd.departamento='86' then 'PUTUMAYO'
                    WHEN pd.departamento='88' then 'ARCHIPIELAGO DE SAN ANDRES, PROVIDENCIA Y SANTA CATALINA'
                    WHEN pd.departamento='91' then 'AMAZONAS'
                    WHEN pd.departamento='94' then 'GUAINIA'
                    WHEN pd.departamento='95' then 'GUAVIARE'
                    WHEN pd.departamento='97' then 'VAUPES'
                    WHEN pd.departamento='99' then 'VICHADA'
                    WHEN pd.departamento='05' then 'ANTIOQUIA'
                    WHEN pd.departamento='08' then 'ATLANTICO'
                ELSE pd.departamento
                end as departamento,
                CASE 

                    WHEN CONCAT(pd.departamento, pd.municipio)='11001' then 'BOGOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13001' then 'CARTAGENA DE INDIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13006' then 'ACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13030' then 'ALTOS DEL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13042' then 'ARENAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13052' then 'ARJONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13062' then 'ARROYOHONDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13074' then 'BARRANCO DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13140' then 'CALAMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13160' then 'CANTAGALLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13188' then 'CICUCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13212' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13222' then 'CLEMENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13244' then 'EL CARMEN DE BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13248' then 'EL GUAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13268' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13300' then 'HATILLO DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13430' then 'MAGANGUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13433' then 'MAHATES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13440' then 'MARGARITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13442' then 'MARIA LA BAJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13458' then 'MONTECRISTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13468' then 'SANTA CRUZ DE MOMPOX'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13473' then 'MORALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13490' then 'NOROSI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13549' then 'PINILLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13580' then 'REGIDOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13600' then 'RIO VIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13620' then 'SAN CRISTOBAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13647' then 'SAN ESTANISLAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13650' then 'SAN FERNANDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13654' then 'SAN JACINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13655' then 'SAN JACINTO DEL CAUCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13657' then 'SAN JUAN NEPOMUCENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13667' then 'SAN MARTIN DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13670' then 'SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13673' then 'SANTA CATALINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13683' then 'SANTA ROSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13688' then 'SANTA ROSA DEL SUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13744' then 'SIMITI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13760' then 'SOPLAVIENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13780' then 'TALAIGUA NUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13810' then 'TIQUISIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13836' then 'TURBACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13838' then 'TURBANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13873' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13894' then 'ZAMBRANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15001' then 'TUNJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15022' then 'ALMEIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15047' then 'AQUITANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15051' then 'ARCABUCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15087' then 'BELEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15090' then 'BERBEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15092' then 'BETEITIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15097' then 'BOAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15104' then 'BOYACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15106' then 'BRICEÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15109' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15114' then 'BUSBANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15131' then 'CALDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15135' then 'CAMPOHERMOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15162' then 'CERINZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15172' then 'CHINAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15176' then 'CHIQUINQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15180' then 'CHISCAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15183' then 'CHITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15185' then 'CHITARAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15187' then 'CHIVATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15189' then 'CIENEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15204' then 'COMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15212' then 'COPER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15215' then 'CORRALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15218' then 'COVARACHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15223' then 'CUBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15224' then 'CUCAITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15226' then 'CUITIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15232' then 'CHIQUIZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15236' then 'CHIVOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15238' then 'DUITAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15244' then 'EL COCUY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15248' then 'EL ESPINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15272' then 'FIRAVITOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15276' then 'FLORESTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15293' then 'GACHANTIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15296' then 'GAMEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15299' then 'GARAGOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15317' then 'GUACAMAYAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15322' then 'GUATEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15325' then 'GUAYATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15332' then 'GÜICAN DE LA SIERRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15362' then 'IZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15367' then 'JENESANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15368' then 'JERICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15377' then 'LABRANZAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15380' then 'LA CAPILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15401' then 'LA VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15403' then 'LA UVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15407' then 'VILLA DE LEYVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15425' then 'MACANAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15442' then 'MARIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15455' then 'MIRAFLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15464' then 'MONGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15466' then 'MONGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15469' then 'MONIQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15476' then 'MOTAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15480' then 'MUZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15491' then 'NOBSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15494' then 'NUEVO COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15500' then 'OICATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15507' then 'OTANCHE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15511' then 'PACHAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15514' then 'PAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15516' then 'PAIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15518' then 'PAJARITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15522' then 'PANQUEBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15531' then 'PAUNA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15533' then 'PAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15537' then 'PAZ DE RIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15542' then 'PESCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15550' then 'PISBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15572' then 'PUERTO BOYACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15580' then 'QUIPAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15599' then 'RAMIRIQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15600' then 'RAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15621' then 'RONDON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15632' then 'SABOYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15638' then 'SACHICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15646' then 'SAMACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15660' then 'SAN EDUARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15664' then 'SAN JOSE DE PARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15667' then 'SAN LUIS DE GACENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15673' then 'SAN MATEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15676' then 'SAN MIGUEL DE SEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15681' then 'SAN PABLO DE BORBUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15686' then 'SANTANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15690' then 'SANTA MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15693' then 'SANTA ROSA DE VITERBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15696' then 'SANTA SOFIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15720' then 'SATIVANORTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15723' then 'SATIVASUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15740' then 'SIACHOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15753' then 'SOATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15755' then 'SOCOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15757' then 'SOCHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15759' then 'SOGAMOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15761' then 'SOMONDOCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15762' then 'SORA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15763' then 'SOTAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15764' then 'SORACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15774' then 'SUSACON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15776' then 'SUTAMARCHAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15778' then 'SUTATENZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15790' then 'TASCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15798' then 'TENZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15804' then 'TIBANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15806' then 'TIBASOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15808' then 'TINJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15810' then 'TIPACOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15814' then 'TOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15816' then 'TOGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15820' then 'TOPAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15822' then 'TOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15832' then 'TUNUNGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15835' then 'TURMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15837' then 'TUTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15839' then 'TUTAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15842' then 'UMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15861' then 'VENTAQUEMADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15879' then 'VIRACACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15897' then 'ZETAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17001' then 'MANIZALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17013' then 'AGUADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17042' then 'ANSERMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17050' then 'ARANZAZU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17088' then 'BELALCAZAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17174' then 'CHINCHINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17272' then 'FILADELFIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17380' then 'LA DORADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17388' then 'LA MERCED'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17433' then 'MANZANARES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17442' then 'MARMATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17444' then 'MARQUETALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17446' then 'MARULANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17486' then 'NEIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17495' then 'NORCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17513' then 'PACORA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17524' then 'PALESTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17541' then 'PENSILVANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17614' then 'RIOSUCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17616' then 'RISARALDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17653' then 'SALAMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17662' then 'SAMANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17665' then 'SAN JOSE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17777' then 'SUPIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17867' then 'VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17873' then 'VILLAMARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17877' then 'VITERBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18001' then 'FLORENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18029' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18094' then 'BELEN DE LOS ANDAQUIES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18150' then 'CARTAGENA DEL CHAIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18205' then 'CURILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18247' then 'EL DONCELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18256' then 'EL PAUJIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18410' then 'LA MONTAÑITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18460' then 'MILAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18479' then 'MORELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18592' then 'PUERTO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18610' then 'SAN JOSE DEL FRAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18753' then 'SAN VICENTE DEL CAGUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18756' then 'SOLANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18785' then 'SOLITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18860' then 'VALPARAISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19001' then 'POPAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19022' then 'ALMAGUER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19050' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19075' then 'BALBOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19100' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19110' then 'BUENOS AIRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19130' then 'CAJIBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19137' then 'CALDONO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19142' then 'CALOTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19212' then 'CORINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19256' then 'EL TAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19290' then 'FLORENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19300' then 'GUACHENE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19318' then 'GUAPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19355' then 'INZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19364' then 'JAMBALO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19392' then 'LA SIERRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19397' then 'LA VEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19418' then 'LOPEZ DE MICAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19450' then 'MERCADERES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19455' then 'MIRANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19473' then 'MORALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19513' then 'PADILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19517' then 'PAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19532' then 'PATIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19533' then 'PIAMONTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19548' then 'PIENDAMO - TUNIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19573' then 'PUERTO TEJADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19585' then 'PURACE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19622' then 'ROSAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19693' then 'SAN SEBASTIAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19698' then 'SANTANDER DE QUILICHAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19701' then 'SANTA ROSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19743' then 'SILVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19760' then 'SOTARA PAISPAMBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19780' then 'SUAREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19785' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19807' then 'TIMBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19809' then 'TIMBIQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19821' then 'TORIBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19824' then 'TOTORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19845' then 'VILLA RICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20001' then 'VALLEDUPAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20011' then 'AGUACHICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20013' then 'AGUSTIN CODAZZI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20032' then 'ASTREA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20045' then 'BECERRIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20060' then 'BOSCONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20175' then 'CHIMICHAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20178' then 'CHIRIGUANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20228' then 'CURUMANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20238' then 'EL COPEY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20250' then 'EL PASO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20295' then 'GAMARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20310' then 'GONZALEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20383' then 'LA GLORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20400' then 'LA JAGUA DE IBIRICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20443' then 'MANAURE BALCON DEL CESAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20517' then 'PAILITAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20550' then 'PELAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20570' then 'PUEBLO BELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20614' then 'RIO DE ORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20621' then 'LA PAZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20710' then 'SAN ALBERTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20750' then 'SAN DIEGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20770' then 'SAN MARTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20787' then 'TAMALAMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23001' then 'MONTERIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23068' then 'AYAPEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23079' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23090' then 'CANALETE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23162' then 'CERETE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23168' then 'CHIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23182' then 'CHINU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23189' then 'CIENAGA DE ORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23300' then 'COTORRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23350' then 'LA APARTADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23417' then 'LORICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23419' then 'LOS CORDOBAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23464' then 'MOMIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23466' then 'MONTELIBANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23500' then 'MOÑITOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23555' then 'PLANETA RICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23570' then 'PUEBLO NUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23574' then 'PUERTO ESCONDIDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23580' then 'PUERTO LIBERTADOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23586' then 'PURISIMA DE LA CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23660' then 'SAHAGUN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23670' then 'SAN ANDRES DE SOTAVENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23672' then 'SAN ANTERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23675' then 'SAN BERNARDO DEL VIENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23678' then 'SAN CARLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23682' then 'SAN JOSE DE URE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23686' then 'SAN PELAYO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23807' then 'TIERRALTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23815' then 'TUCHIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23855' then 'VALENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25001' then 'AGUA DE DIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25019' then 'ALBAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25035' then 'ANAPOIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25040' then 'ANOLAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25053' then 'ARBELAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25086' then 'BELTRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25095' then 'BITUIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25099' then 'BOJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25120' then 'CABRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25123' then 'CACHIPAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25126' then 'CAJICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25148' then 'CAPARRAPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25151' then 'CAQUEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25154' then 'CARMEN DE CARUPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25168' then 'CHAGUANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25175' then 'CHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25178' then 'CHIPAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25181' then 'CHOACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25183' then 'CHOCONTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25200' then 'COGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25214' then 'COTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25224' then 'CUCUNUBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25245' then 'EL COLEGIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25258' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25260' then 'EL ROSAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25269' then 'FACATATIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25279' then 'FOMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25281' then 'FOSCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25286' then 'FUNZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25288' then 'FUQUENE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25290' then 'FUSAGASUGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25293' then 'GACHALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25295' then 'GACHANCIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25297' then 'GACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25299' then 'GAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25307' then 'GIRARDOT'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25312' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25317' then 'GUACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25320' then 'GUADUAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25322' then 'GUASCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25324' then 'GUATAQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25326' then 'GUATAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25328' then 'GUAYABAL DE SIQUIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25335' then 'GUAYABETAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25339' then 'GUTIERREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25368' then 'JERUSALEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25372' then 'JUNIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25377' then 'LA CALERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25386' then 'LA MESA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25394' then 'LA PALMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25398' then 'LA PEÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25402' then 'LA VEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25407' then 'LENGUAZAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25426' then 'MACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25430' then 'MADRID'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25436' then 'MANTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25438' then 'MEDINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25473' then 'MOSQUERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25483' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25486' then 'NEMOCON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25488' then 'NILO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25489' then 'NIMAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25491' then 'NOCAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25506' then 'VENECIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25513' then 'PACHO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25518' then 'PAIME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25524' then 'PANDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25530' then 'PARATEBUENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25535' then 'PASCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25572' then 'PUERTO SALGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25580' then 'PULI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25592' then 'QUEBRADANEGRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25594' then 'QUETAME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25596' then 'QUIPILE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25599' then 'APULO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25612' then 'RICAURTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25645' then 'SAN ANTONIO DEL TEQUENDAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25649' then 'SAN BERNARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25653' then 'SAN CAYETANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25658' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25662' then 'SAN JUAN DE RIOSECO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25718' then 'SASAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25736' then 'SESQUILE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25740' then 'SIBATE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25743' then 'SILVANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25745' then 'SIMIJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25754' then 'SOACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25758' then 'SOPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25769' then 'SUBACHOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25772' then 'SUESCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25777' then 'SUPATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25779' then 'SUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25781' then 'SUTATAUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25785' then 'TABIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25793' then 'TAUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25797' then 'TENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25799' then 'TENJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25805' then 'TIBACUY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25807' then 'TIBIRITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25815' then 'TOCAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25817' then 'TOCANCIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25823' then 'TOPAIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25839' then 'UBALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25841' then 'UBAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25843' then 'VILLA DE SAN DIEGO DE UBATE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25845' then 'UNE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25851' then 'UTICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25862' then 'VERGARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25867' then 'VIANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25871' then 'VILLAGOMEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25873' then 'VILLAPINZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25875' then 'VILLETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25878' then 'VIOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25885' then 'YACOPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25898' then 'ZIPACON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25899' then 'ZIPAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27001' then 'QUIBDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27006' then 'ACANDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27025' then 'ALTO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27050' then 'ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27073' then 'BAGADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27075' then 'BAHIA SOLANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27077' then 'BAJO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27099' then 'BOJAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27135' then 'EL CANTON DEL SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27150' then 'CARMEN DEL DARIEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27160' then 'CERTEGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27205' then 'CONDOTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27245' then 'EL CARMEN DE ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27250' then 'EL LITORAL DEL SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27361' then 'ISTMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27372' then 'JURADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27413' then 'LLORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27425' then 'MEDIO ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27430' then 'MEDIO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27450' then 'MEDIO SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27491' then 'NOVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27493' then 'NUEVO BELEN DE BAJIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27495' then 'NUQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27580' then 'RIO IRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27600' then 'RIO QUITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27615' then 'RIOSUCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27660' then 'SAN JOSE DEL PALMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27745' then 'SIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27787' then 'TADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27800' then 'UNGUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27810' then 'UNION PANAMERICANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41001' then 'NEIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41006' then 'ACEVEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41013' then 'AGRADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41016' then 'AIPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41020' then 'ALGECIRAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41026' then 'ALTAMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41078' then 'BARAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41132' then 'CAMPOALEGRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41206' then 'COLOMBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41244' then 'ELIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41298' then 'GARZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41306' then 'GIGANTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41319' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41349' then 'HOBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41357' then 'IQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41359' then 'ISNOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41378' then 'LA ARGENTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41396' then 'LA PLATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41483' then 'NATAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41503' then 'OPORAPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41518' then 'PAICOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41524' then 'PALERMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41530' then 'PALESTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41548' then 'PITAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41551' then 'PITALITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41615' then 'RIVERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41660' then 'SALADOBLANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41668' then 'SAN AGUSTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41676' then 'SANTA MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41770' then 'SUAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41791' then 'TARQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41797' then 'TESALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41799' then 'TELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41801' then 'TERUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41807' then 'TIMANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41872' then 'VILLAVIEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41885' then 'YAGUARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44001' then 'RIOHACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44035' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44078' then 'BARRANCAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44090' then 'DIBULLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44098' then 'DISTRACCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44110' then 'EL MOLINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44279' then 'FONSECA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44378' then 'HATONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44420' then 'LA JAGUA DEL PILAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44430' then 'MAICAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44560' then 'MANAURE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44650' then 'SAN JUAN DEL CESAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44847' then 'URIBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44855' then 'URUMITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44874' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47001' then 'SANTA MARTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47030' then 'ALGARROBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47053' then 'ARACATACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47058' then 'ARIGUANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47161' then 'CERRO DE SAN ANTONIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47170' then 'CHIVOLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47189' then 'CIENAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47205' then 'CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47245' then 'EL BANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47258' then 'EL PIÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47268' then 'EL RETEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47288' then 'FUNDACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47318' then 'GUAMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47460' then 'NUEVA GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47541' then 'PEDRAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47545' then 'PIJIÑO DEL CARMEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47551' then 'PIVIJAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47555' then 'PLATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47570' then 'PUEBLOVIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47605' then 'REMOLINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47660' then 'SABANAS DE SAN ANGEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47675' then 'SALAMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47692' then 'SAN SEBASTIAN DE BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47703' then 'SAN ZENON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47707' then 'SANTA ANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47720' then 'SANTA BARBARA DE PINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47745' then 'SITIONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47798' then 'TENERIFE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47960' then 'ZAPAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47980' then 'ZONA BANANERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50001' then 'VILLAVICENCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50006' then 'ACACIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50110' then 'BARRANCA DE UPIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50124' then 'CABUYARO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50150' then 'CASTILLA LA NUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50223' then 'CUBARRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50226' then 'CUMARAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50245' then 'EL CALVARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50251' then 'EL CASTILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50270' then 'EL DORADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50287' then 'FUENTEDEORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50313' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50318' then 'GUAMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50325' then 'MAPIRIPAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50330' then 'MESETAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50350' then 'LA MACARENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50370' then 'URIBE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50400' then 'LEJANIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50450' then 'PUERTO CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50568' then 'PUERTO GAITAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50573' then 'PUERTO LOPEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50577' then 'PUERTO LLERAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50590' then 'PUERTO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50606' then 'RESTREPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50680' then 'SAN CARLOS DE GUAROA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50683' then 'SAN JUAN DE ARAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50686' then 'SAN JUANITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50689' then 'SAN MARTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50711' then 'VISTAHERMOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52001' then 'PASTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52019' then 'ALBAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52022' then 'ALDANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52036' then 'ANCUYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52051' then 'ARBOLEDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52079' then 'BARBACOAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52083' then 'BELEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52110' then 'BUESACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52203' then 'COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52207' then 'CONSACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52210' then 'CONTADERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52215' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52224' then 'CUASPUD CARLOSAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52227' then 'CUMBAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52233' then 'CUMBITARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52240' then 'CHACHAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52250' then 'EL CHARCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52254' then 'EL PEÑOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52256' then 'EL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52258' then 'EL TABLON DE GOMEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52260' then 'EL TAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52287' then 'FUNES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52317' then 'GUACHUCAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52320' then 'GUAITARILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52323' then 'GUALMATAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52352' then 'ILES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52354' then 'IMUES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52356' then 'IPIALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52378' then 'LA CRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52381' then 'LA FLORIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52385' then 'LA LLANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52390' then 'LA TOLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52399' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52405' then 'LEIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52411' then 'LINARES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52418' then 'LOS ANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52427' then 'MAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52435' then 'MALLAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52473' then 'MOSQUERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52480' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52490' then 'OLAYA HERRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52506' then 'OSPINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52520' then 'FRANCISCO PIZARRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52540' then 'POLICARPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52560' then 'POTOSI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52565' then 'PROVIDENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52573' then 'PUERRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52585' then 'PUPIALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52612' then 'RICAURTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52621' then 'ROBERTO PAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52678' then 'SAMANIEGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52683' then 'SANDONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52685' then 'SAN BERNARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52687' then 'SAN LORENZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52693' then 'SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52694' then 'SAN PEDRO DE CARTAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52696' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52699' then 'SANTACRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52720' then 'SAPUYES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52786' then 'TAMINANGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52788' then 'TANGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52835' then 'SAN ANDRES DE TUMACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52838' then 'TUQUERRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52885' then 'YACUANQUER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54001' then 'SAN JOSE DE CUCUTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54003' then 'ABREGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54051' then 'ARBOLEDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54099' then 'BOCHALEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54109' then 'BUCARASICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54125' then 'CACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54128' then 'CACHIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54172' then 'CHINACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54174' then 'CHITAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54206' then 'CONVENCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54223' then 'CUCUTILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54239' then 'DURANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54245' then 'EL CARMEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54250' then 'EL TARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54261' then 'EL ZULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54313' then 'GRAMALOTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54344' then 'HACARI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54347' then 'HERRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54377' then 'LABATECA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54385' then 'LA ESPERANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54398' then 'LA PLAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54405' then 'LOS PATIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54418' then 'LOURDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54480' then 'MUTISCUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54498' then 'OCAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54518' then 'PAMPLONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54520' then 'PAMPLONITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54553' then 'PUERTO SANTANDER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54599' then 'RAGONVALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54660' then 'SALAZAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54670' then 'SAN CALIXTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54673' then 'SAN CAYETANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54680' then 'SANTIAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54720' then 'SARDINATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54743' then 'SILOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54800' then 'TEORAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54810' then 'TIBU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54820' then 'TOLEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54871' then 'VILLA CARO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54874' then 'VILLA DEL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63001' then 'ARMENIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63111' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63130' then 'CALARCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63190' then 'CIRCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63212' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63272' then 'FILANDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63302' then 'GENOVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63401' then 'LA TEBAIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63470' then 'MONTENEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63548' then 'PIJAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63594' then 'QUIMBAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63690' then 'SALENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66001' then 'PEREIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66045' then 'APIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66075' then 'BALBOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66088' then 'BELEN DE UMBRIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66170' then 'DOSQUEBRADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66318' then 'GUATICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66383' then 'LA CELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66400' then 'LA VIRGINIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66440' then 'MARSELLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66456' then 'MISTRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66572' then 'PUEBLO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66594' then 'QUINCHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66682' then 'SANTA ROSA DE CABAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66687' then 'SANTUARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68001' then 'BUCARAMANGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68013' then 'AGUADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68020' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68051' then 'ARATOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68077' then 'BARBOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68079' then 'BARICHARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68081' then 'BARRANCABERMEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68092' then 'BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68101' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68121' then 'CABRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68132' then 'CALIFORNIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68147' then 'CAPITANEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68152' then 'CARCASI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68160' then 'CEPITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68162' then 'CERRITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68167' then 'CHARALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68169' then 'CHARTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68176' then 'CHIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68179' then 'CHIPATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68190' then 'CIMITARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68207' then 'CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68209' then 'CONFINES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68211' then 'CONTRATACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68217' then 'COROMORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68229' then 'CURITI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68235' then 'EL CARMEN DE CHUCURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68245' then 'EL GUACAMAYO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68250' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68255' then 'EL PLAYON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68264' then 'ENCINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68266' then 'ENCISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68271' then 'FLORIAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68276' then 'FLORIDABLANCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68296' then 'GALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68298' then 'GAMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68307' then 'GIRON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68318' then 'GUACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68320' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68322' then 'GUAPOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68324' then 'GUAVATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68327' then 'GÜEPSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68344' then 'HATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68368' then 'JESUS MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68370' then 'JORDAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68377' then 'LA BELLEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68385' then 'LANDAZURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68397' then 'LA PAZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68406' then 'LEBRIJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68418' then 'LOS SANTOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68425' then 'MACARAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68432' then 'MALAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68444' then 'MATANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68464' then 'MOGOTES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68468' then 'MOLAGAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68498' then 'OCAMONTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68500' then 'OIBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68502' then 'ONZAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68522' then 'PALMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68524' then 'PALMAS DEL SOCORRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68533' then 'PARAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68547' then 'PIEDECUESTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68549' then 'PINCHOTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68572' then 'PUENTE NACIONAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68573' then 'PUERTO PARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68575' then 'PUERTO WILCHES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68615' then 'RIONEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68655' then 'SABANA DE TORRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68669' then 'SAN ANDRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68673' then 'SAN BENITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68679' then 'SAN GIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68682' then 'SAN JOAQUIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68684' then 'SAN JOSE DE MIRANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68686' then 'SAN MIGUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68689' then 'SAN VICENTE DE CHUCURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68705' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68720' then 'SANTA HELENA DEL OPON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68745' then 'SIMACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68755' then 'SOCORRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68770' then 'SUAITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68773' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68780' then 'SURATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68820' then 'TONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68855' then 'VALLE DE SAN JOSE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68861' then 'VELEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68867' then 'VETAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68872' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68895' then 'ZAPATOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70001' then 'SINCELEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70110' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70124' then 'CAIMITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70204' then 'COLOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70215' then 'COROZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70221' then 'COVEÑAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70230' then 'CHALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70233' then 'EL ROBLE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70235' then 'GALERAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70265' then 'GUARANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70418' then 'LOS PALMITOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70429' then 'MAJAGUAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70473' then 'MORROA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70508' then 'OVEJAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70523' then 'PALMITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70670' then 'SAMPUES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70678' then 'SAN BENITO ABAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70702' then 'SAN JUAN DE BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70708' then 'SAN MARCOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70713' then 'SAN ONOFRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70717' then 'SAN PEDRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70742' then 'SAN LUIS DE SINCE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70771' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70820' then 'SANTIAGO DE TOLU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70823' then 'SAN JOSE DE TOLUVIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73001' then 'IBAGUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73024' then 'ALPUJARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73026' then 'ALVARADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73030' then 'AMBALEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73043' then 'ANZOATEGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73055' then 'ARMERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73067' then 'ATACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73124' then 'CAJAMARCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73148' then 'CARMEN DE APICALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73152' then 'CASABIANCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73168' then 'CHAPARRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73200' then 'COELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73217' then 'COYAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73226' then 'CUNDAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73236' then 'DOLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73268' then 'ESPINAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73270' then 'FALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73275' then 'FLANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73283' then 'FRESNO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73319' then 'GUAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73347' then 'HERVEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73349' then 'HONDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73352' then 'ICONONZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73408' then 'LERIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73411' then 'LIBANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73443' then 'SAN SEBASTIAN DE MARIQUITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73449' then 'MELGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73461' then 'MURILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73483' then 'NATAGAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73504' then 'ORTEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73520' then 'PALOCABILDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73547' then 'PIEDRAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73555' then 'PLANADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73563' then 'PRADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73585' then 'PURIFICACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73616' then 'RIOBLANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73622' then 'RONCESVALLES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73624' then 'ROVIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73671' then 'SALDAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73675' then 'SAN ANTONIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73678' then 'SAN LUIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73686' then 'SANTA ISABEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73770' then 'SUAREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73854' then 'VALLE DE SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73861' then 'VENADILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73870' then 'VILLAHERMOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73873' then 'VILLARRICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76001' then 'SANTIAGO DE CALI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76020' then 'ALCALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76036' then 'ANDALUCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76041' then 'ANSERMANUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76054' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76100' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76109' then 'BUENAVENTURA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76111' then 'GUADALAJARA DE BUGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76113' then 'BUGALAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76122' then 'CAICEDONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76126' then 'CALIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76130' then 'CANDELARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76147' then 'CARTAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76233' then 'DAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76243' then 'EL AGUILA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76246' then 'EL CAIRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76248' then 'EL CERRITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76250' then 'EL DOVIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76275' then 'FLORIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76306' then 'GINEBRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76318' then 'GUACARI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76364' then 'JAMUNDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76377' then 'LA CUMBRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76403' then 'LA VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76497' then 'OBANDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76520' then 'PALMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76563' then 'PRADERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76606' then 'RESTREPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76616' then 'RIOFRIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76622' then 'ROLDANILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76670' then 'SAN PEDRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76736' then 'SEVILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76823' then 'TORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76828' then 'TRUJILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76834' then 'TULUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76845' then 'ULLOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76863' then 'VERSALLES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76869' then 'VIJES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76890' then 'YOTOCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76892' then 'YUMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76895' then 'ZARZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81001' then 'ARAUCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81065' then 'ARAUQUITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81220' then 'CRAVO NORTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81300' then 'FORTUL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81591' then 'PUERTO RONDON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81736' then 'SARAVENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81794' then 'TAME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85001' then 'YOPAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85010' then 'AGUAZUL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85015' then 'CHAMEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85125' then 'HATO COROZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85136' then 'LA SALINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85139' then 'MANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85162' then 'MONTERREY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85225' then 'NUNCHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85230' then 'OROCUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85250' then 'PAZ DE ARIPORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85263' then 'PORE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85279' then 'RECETOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85300' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85315' then 'SACAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85325' then 'SAN LUIS DE PALENQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85400' then 'TAMARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85410' then 'TAURAMENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85430' then 'TRINIDAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85440' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86001' then 'MOCOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86219' then 'COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86320' then 'ORITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86568' then 'PUERTO ASIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86569' then 'PUERTO CAICEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86571' then 'PUERTO GUZMAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86573' then 'PUERTO LEGUIZAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86749' then 'SIBUNDOY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86755' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86757' then 'SAN MIGUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86760' then 'SANTIAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86865' then 'VALLE DEL GUAMUEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86885' then 'VILLAGARZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='88001' then 'SAN ANDRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='88564' then 'PROVIDENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91001' then 'LETICIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91263' then 'EL ENCANTO (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91405' then 'LA CHORRERA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91407' then 'LA PEDRERA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91430' then 'LA VICTORIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91460' then 'MIRITI - PARANA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91530' then 'PUERTO ALEGRIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91536' then 'PUERTO ARICA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91540' then 'PUERTO NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91669' then 'PUERTO SANTANDER (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91798' then 'TARAPACA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94001' then 'INIRIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94343' then 'BARRANCOMINAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94883' then 'SAN FELIPE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94884' then 'PUERTO COLOMBIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94885' then 'LA GUADALUPE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94886' then 'CACAHUAL (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94887' then 'PANA PANA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94888' then 'MORICHAL (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95001' then 'SAN JOSE DEL GUAVIARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95015' then 'CALAMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95025' then 'EL RETORNO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95200' then 'MIRAFLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97001' then 'MITU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97161' then 'CARURU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97511' then 'PACOA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97666' then 'TARAIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97777' then 'PAPUNAHUA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97889' then 'YAVARATE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99001' then 'PUERTO CARREÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99524' then 'LA PRIMAVERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99624' then 'SANTA ROSALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99773' then 'CUMARIBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05001' then 'MEDELLIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05002' then 'ABEJORRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05004' then 'ABRIAQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05021' then 'ALEJANDRIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05030' then 'AMAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05031' then 'AMALFI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05034' then 'ANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05036' then 'ANGELOPOLIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05038' then 'ANGOSTURA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05040' then 'ANORI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05042' then 'SANTA FE DE ANTIOQUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05044' then 'ANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05045' then 'APARTADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05051' then 'ARBOLETES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05055' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05059' then 'ARMENIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05079' then 'BARBOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05086' then 'BELMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05088' then 'BELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05091' then 'BETANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05093' then 'BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05101' then 'CIUDAD BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05107' then 'BRICEÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05113' then 'BURITICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05120' then 'CACERES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05125' then 'CAICEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05129' then 'CALDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05134' then 'CAMPAMENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05138' then 'CAÑASGORDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05142' then 'CARACOLI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05145' then 'CARAMANTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05147' then 'CAREPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05148' then 'EL CARMEN DE VIBORAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05150' then 'CAROLINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05154' then 'CAUCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05172' then 'CHIGORODO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05190' then 'CISNEROS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05197' then 'COCORNA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05206' then 'CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05209' then 'CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05212' then 'COPACABANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05234' then 'DABEIBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05237' then 'DONMATIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05240' then 'EBEJICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05250' then 'EL BAGRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05264' then 'ENTRERRIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05266' then 'ENVIGADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05282' then 'FREDONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05284' then 'FRONTINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05306' then 'GIRALDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05308' then 'GIRARDOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05310' then 'GOMEZ PLATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05313' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05315' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05318' then 'GUARNE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05321' then 'GUATAPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05347' then 'HELICONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05353' then 'HISPANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05360' then 'ITAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05361' then 'ITUANGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05364' then 'JARDIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05368' then 'JERICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05376' then 'LA CEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05380' then 'LA ESTRELLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05390' then 'LA PINTADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05411' then 'LIBORINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05425' then 'MACEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05440' then 'MARINILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05467' then 'MONTEBELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05475' then 'MURINDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05480' then 'MUTATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05483' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05490' then 'NECOCLI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05495' then 'NECHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05501' then 'OLAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05541' then 'PEÑOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05543' then 'PEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05576' then 'PUEBLORRICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05579' then 'PUERTO BERRIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05585' then 'PUERTO NARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05591' then 'PUERTO TRIUNFO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05604' then 'REMEDIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05607' then 'RETIRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05615' then 'RIONEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05628' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05631' then 'SABANETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05642' then 'SALGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05647' then 'SAN ANDRES DE CUERQUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05649' then 'SAN CARLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05652' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05656' then 'SAN JERONIMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05658' then 'SAN JOSE DE LA MONTAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05659' then 'SAN JUAN DE URABA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05660' then 'SAN LUIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05664' then 'SAN PEDRO DE LOS MILAGROS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05665' then 'SAN PEDRO DE URABA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05667' then 'SAN RAFAEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05670' then 'SAN ROQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05674' then 'SAN VICENTE FERRER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05679' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05686' then 'SANTA ROSA DE OSOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05690' then 'SANTO DOMINGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05697' then 'EL SANTUARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05736' then 'SEGOVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05756' then 'SONSON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05761' then 'SOPETRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05789' then 'TAMESIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05790' then 'TARAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05792' then 'TARSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05809' then 'TITIRIBI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05819' then 'TOLEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05837' then 'TURBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05842' then 'URAMITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05847' then 'URRAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05854' then 'VALDIVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05856' then 'VALPARAISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05858' then 'VEGACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05861' then 'VENECIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05873' then 'VIGIA DEL FUERTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05885' then 'YALI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05887' then 'YARUMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05890' then 'YOLOMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05893' then 'YONDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05895' then 'ZARAGOZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08001' then 'BARRANQUILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08078' then 'BARANOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08137' then 'CAMPO DE LA CRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08141' then 'CANDELARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08296' then 'GALAPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08372' then 'JUAN DE ACOSTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08421' then 'LURUACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08433' then 'MALAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08436' then 'MANATI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08520' then 'PALMAR DE VARELA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08549' then 'PIOJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08558' then 'POLONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08560' then 'PONEDERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08573' then 'PUERTO COLOMBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08606' then 'REPELON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08634' then 'SABANAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08638' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08675' then 'SANTA LUCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08685' then 'SANTO TOMAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08758' then 'SOLEDAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08770' then 'SUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08832' then 'TUBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08849' then 'USIACURI'
                    ELSE CONCAT(pd.departamento, pd.municipio)

                end as municipio, 
                UPPER(pd.vereda), UPPER(pd.uit), UPPER(pd.nombre_reconocedor), TO_CHAR(pd.fecha_visita_predial,'DD/MM/YYYY') as fecha_levantamiento,
                CONCAT(pd.departamento,pd.municipio) as divipola
                
            FROM 
                {esquema}.cca_predio pd
            JOIN 
                {esquema}.cca_condicionprediotipo cpt 
                ON pd.condicion_predio = cpt.t_id
            JOIN 
                {esquema}.cca_terreno te 
                ON pd.terreno = te.t_id
            JOIN {esquema}.cca_derecho der ON pd.t_id=der.predio
            JOIN {esquema}.cca_derechotipo drtp on der.tipo=drtp.t_id
            JOIN {esquema}.cca_metodointervenciontipo interv on pd.metodointervencion=interv.t_id

            WHERE 
                cpt.ilicode='NPH'




        """,
        'INFORMAL': f"""
            SELECT 
                pd.qr_operacion, 
                pd.qr_operacion_definitivo, 
                CASE
                    WHEN cpt.ilicode='NPH' then 'FORMAL_XXXXXX'
                    WHEN cpt.ilicode='Informal' then 'INFORMAL'
                    else cpt.ilicode
                end as condicion_predio,

                ST_AsBinary(ST_SetSRID(te.geometria, 9377)) AS geometria,
                ROUND((ST_Area(ST_Transform(te.geometria, 9377))::numeric), 2) as area_levantamiento,
                UPPER(drtp.ilicode) as derecho_tipo,
                CASE 
                    WHEN interv.ilicode='Colaborativo_Declarativo' then 'METODO_DECLARATIVO_Y_COLABORATIVO'
                    WHEN interv.ilicode='Indirecto' then 'METODO_INDIRECTO'
                    WHEN interv.ilicode='Mixto' then 'MIXTO'
                    WHEN interv.ilicode='Directo' then 'METODO_DIRECTO'
                end as metodo_levantamiento, 
                CASE
                    WHEN pd.departamento='13' then 'BOLIVAR'
                    WHEN pd.departamento='15' then 'BOYACA'
                    WHEN pd.departamento='17' then 'CALDAS'
                    WHEN pd.departamento='18' then 'CAQUETA'
                    WHEN pd.departamento='19' then 'CAUCA'
                    WHEN pd.departamento='20' then 'CESAR'
                    WHEN pd.departamento='23' then 'CORDOBA'
                    WHEN pd.departamento='25' then 'CUNDINAMARCA'
                    WHEN pd.departamento='27' then 'CHOCO'
                    WHEN pd.departamento='41' then 'HUILA'
                    WHEN pd.departamento='44' then 'LA GUAJIRA'
                    WHEN pd.departamento='47' then 'MAGDALENA'
                    WHEN pd.departamento='50' then 'META'
                    WHEN pd.departamento='52' then 'NARIÑO'
                    WHEN pd.departamento='54' then 'NORTE DE SANTANDER'
                    WHEN pd.departamento='63' then 'QUINDIO'
                    WHEN pd.departamento='66' then 'RISARALDA'
                    WHEN pd.departamento='68' then 'SANTANDER'
                    WHEN pd.departamento='70' then 'SUCRE'
                    WHEN pd.departamento='73' then 'TOLIMA'
                    WHEN pd.departamento='76' then 'VALLE DEL CAUCA'
                    WHEN pd.departamento='81' then 'ARAUCA'
                    WHEN pd.departamento='85' then 'CASANARE'
                    WHEN pd.departamento='86' then 'PUTUMAYO'
                    WHEN pd.departamento='88' then 'ARCHIPIELAGO DE SAN ANDRES, PROVIDENCIA Y SANTA CATALINA'
                    WHEN pd.departamento='91' then 'AMAZONAS'
                    WHEN pd.departamento='94' then 'GUAINIA'
                    WHEN pd.departamento='95' then 'GUAVIARE'
                    WHEN pd.departamento='97' then 'VAUPES'
                    WHEN pd.departamento='99' then 'VICHADA'
                    WHEN pd.departamento='05' then 'ANTIOQUIA'
                    WHEN pd.departamento='08' then 'ATLANTICO'
                ELSE pd.departamento
                end as departamento,
                CASE 

                    WHEN CONCAT(pd.departamento, pd.municipio)='11001' then 'BOGOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13001' then 'CARTAGENA DE INDIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13006' then 'ACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13030' then 'ALTOS DEL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13042' then 'ARENAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13052' then 'ARJONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13062' then 'ARROYOHONDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13074' then 'BARRANCO DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13140' then 'CALAMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13160' then 'CANTAGALLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13188' then 'CICUCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13212' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13222' then 'CLEMENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13244' then 'EL CARMEN DE BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13248' then 'EL GUAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13268' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13300' then 'HATILLO DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13430' then 'MAGANGUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13433' then 'MAHATES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13440' then 'MARGARITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13442' then 'MARIA LA BAJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13458' then 'MONTECRISTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13468' then 'SANTA CRUZ DE MOMPOX'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13473' then 'MORALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13490' then 'NOROSI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13549' then 'PINILLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13580' then 'REGIDOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13600' then 'RIO VIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13620' then 'SAN CRISTOBAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13647' then 'SAN ESTANISLAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13650' then 'SAN FERNANDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13654' then 'SAN JACINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13655' then 'SAN JACINTO DEL CAUCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13657' then 'SAN JUAN NEPOMUCENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13667' then 'SAN MARTIN DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13670' then 'SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13673' then 'SANTA CATALINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13683' then 'SANTA ROSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13688' then 'SANTA ROSA DEL SUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13744' then 'SIMITI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13760' then 'SOPLAVIENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13780' then 'TALAIGUA NUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13810' then 'TIQUISIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13836' then 'TURBACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13838' then 'TURBANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13873' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13894' then 'ZAMBRANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15001' then 'TUNJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15022' then 'ALMEIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15047' then 'AQUITANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15051' then 'ARCABUCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15087' then 'BELEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15090' then 'BERBEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15092' then 'BETEITIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15097' then 'BOAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15104' then 'BOYACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15106' then 'BRICEÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15109' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15114' then 'BUSBANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15131' then 'CALDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15135' then 'CAMPOHERMOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15162' then 'CERINZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15172' then 'CHINAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15176' then 'CHIQUINQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15180' then 'CHISCAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15183' then 'CHITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15185' then 'CHITARAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15187' then 'CHIVATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15189' then 'CIENEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15204' then 'COMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15212' then 'COPER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15215' then 'CORRALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15218' then 'COVARACHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15223' then 'CUBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15224' then 'CUCAITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15226' then 'CUITIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15232' then 'CHIQUIZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15236' then 'CHIVOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15238' then 'DUITAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15244' then 'EL COCUY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15248' then 'EL ESPINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15272' then 'FIRAVITOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15276' then 'FLORESTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15293' then 'GACHANTIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15296' then 'GAMEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15299' then 'GARAGOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15317' then 'GUACAMAYAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15322' then 'GUATEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15325' then 'GUAYATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15332' then 'GÜICAN DE LA SIERRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15362' then 'IZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15367' then 'JENESANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15368' then 'JERICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15377' then 'LABRANZAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15380' then 'LA CAPILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15401' then 'LA VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15403' then 'LA UVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15407' then 'VILLA DE LEYVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15425' then 'MACANAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15442' then 'MARIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15455' then 'MIRAFLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15464' then 'MONGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15466' then 'MONGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15469' then 'MONIQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15476' then 'MOTAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15480' then 'MUZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15491' then 'NOBSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15494' then 'NUEVO COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15500' then 'OICATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15507' then 'OTANCHE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15511' then 'PACHAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15514' then 'PAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15516' then 'PAIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15518' then 'PAJARITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15522' then 'PANQUEBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15531' then 'PAUNA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15533' then 'PAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15537' then 'PAZ DE RIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15542' then 'PESCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15550' then 'PISBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15572' then 'PUERTO BOYACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15580' then 'QUIPAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15599' then 'RAMIRIQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15600' then 'RAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15621' then 'RONDON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15632' then 'SABOYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15638' then 'SACHICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15646' then 'SAMACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15660' then 'SAN EDUARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15664' then 'SAN JOSE DE PARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15667' then 'SAN LUIS DE GACENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15673' then 'SAN MATEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15676' then 'SAN MIGUEL DE SEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15681' then 'SAN PABLO DE BORBUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15686' then 'SANTANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15690' then 'SANTA MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15693' then 'SANTA ROSA DE VITERBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15696' then 'SANTA SOFIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15720' then 'SATIVANORTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15723' then 'SATIVASUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15740' then 'SIACHOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15753' then 'SOATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15755' then 'SOCOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15757' then 'SOCHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15759' then 'SOGAMOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15761' then 'SOMONDOCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15762' then 'SORA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15763' then 'SOTAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15764' then 'SORACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15774' then 'SUSACON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15776' then 'SUTAMARCHAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15778' then 'SUTATENZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15790' then 'TASCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15798' then 'TENZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15804' then 'TIBANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15806' then 'TIBASOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15808' then 'TINJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15810' then 'TIPACOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15814' then 'TOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15816' then 'TOGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15820' then 'TOPAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15822' then 'TOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15832' then 'TUNUNGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15835' then 'TURMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15837' then 'TUTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15839' then 'TUTAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15842' then 'UMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15861' then 'VENTAQUEMADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15879' then 'VIRACACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15897' then 'ZETAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17001' then 'MANIZALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17013' then 'AGUADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17042' then 'ANSERMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17050' then 'ARANZAZU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17088' then 'BELALCAZAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17174' then 'CHINCHINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17272' then 'FILADELFIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17380' then 'LA DORADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17388' then 'LA MERCED'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17433' then 'MANZANARES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17442' then 'MARMATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17444' then 'MARQUETALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17446' then 'MARULANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17486' then 'NEIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17495' then 'NORCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17513' then 'PACORA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17524' then 'PALESTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17541' then 'PENSILVANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17614' then 'RIOSUCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17616' then 'RISARALDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17653' then 'SALAMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17662' then 'SAMANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17665' then 'SAN JOSE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17777' then 'SUPIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17867' then 'VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17873' then 'VILLAMARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17877' then 'VITERBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18001' then 'FLORENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18029' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18094' then 'BELEN DE LOS ANDAQUIES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18150' then 'CARTAGENA DEL CHAIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18205' then 'CURILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18247' then 'EL DONCELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18256' then 'EL PAUJIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18410' then 'LA MONTAÑITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18460' then 'MILAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18479' then 'MORELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18592' then 'PUERTO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18610' then 'SAN JOSE DEL FRAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18753' then 'SAN VICENTE DEL CAGUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18756' then 'SOLANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18785' then 'SOLITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18860' then 'VALPARAISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19001' then 'POPAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19022' then 'ALMAGUER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19050' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19075' then 'BALBOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19100' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19110' then 'BUENOS AIRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19130' then 'CAJIBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19137' then 'CALDONO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19142' then 'CALOTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19212' then 'CORINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19256' then 'EL TAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19290' then 'FLORENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19300' then 'GUACHENE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19318' then 'GUAPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19355' then 'INZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19364' then 'JAMBALO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19392' then 'LA SIERRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19397' then 'LA VEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19418' then 'LOPEZ DE MICAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19450' then 'MERCADERES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19455' then 'MIRANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19473' then 'MORALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19513' then 'PADILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19517' then 'PAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19532' then 'PATIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19533' then 'PIAMONTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19548' then 'PIENDAMO - TUNIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19573' then 'PUERTO TEJADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19585' then 'PURACE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19622' then 'ROSAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19693' then 'SAN SEBASTIAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19698' then 'SANTANDER DE QUILICHAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19701' then 'SANTA ROSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19743' then 'SILVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19760' then 'SOTARA PAISPAMBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19780' then 'SUAREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19785' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19807' then 'TIMBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19809' then 'TIMBIQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19821' then 'TORIBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19824' then 'TOTORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19845' then 'VILLA RICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20001' then 'VALLEDUPAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20011' then 'AGUACHICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20013' then 'AGUSTIN CODAZZI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20032' then 'ASTREA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20045' then 'BECERRIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20060' then 'BOSCONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20175' then 'CHIMICHAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20178' then 'CHIRIGUANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20228' then 'CURUMANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20238' then 'EL COPEY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20250' then 'EL PASO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20295' then 'GAMARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20310' then 'GONZALEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20383' then 'LA GLORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20400' then 'LA JAGUA DE IBIRICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20443' then 'MANAURE BALCON DEL CESAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20517' then 'PAILITAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20550' then 'PELAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20570' then 'PUEBLO BELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20614' then 'RIO DE ORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20621' then 'LA PAZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20710' then 'SAN ALBERTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20750' then 'SAN DIEGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20770' then 'SAN MARTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20787' then 'TAMALAMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23001' then 'MONTERIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23068' then 'AYAPEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23079' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23090' then 'CANALETE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23162' then 'CERETE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23168' then 'CHIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23182' then 'CHINU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23189' then 'CIENAGA DE ORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23300' then 'COTORRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23350' then 'LA APARTADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23417' then 'LORICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23419' then 'LOS CORDOBAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23464' then 'MOMIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23466' then 'MONTELIBANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23500' then 'MOÑITOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23555' then 'PLANETA RICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23570' then 'PUEBLO NUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23574' then 'PUERTO ESCONDIDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23580' then 'PUERTO LIBERTADOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23586' then 'PURISIMA DE LA CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23660' then 'SAHAGUN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23670' then 'SAN ANDRES DE SOTAVENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23672' then 'SAN ANTERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23675' then 'SAN BERNARDO DEL VIENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23678' then 'SAN CARLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23682' then 'SAN JOSE DE URE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23686' then 'SAN PELAYO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23807' then 'TIERRALTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23815' then 'TUCHIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23855' then 'VALENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25001' then 'AGUA DE DIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25019' then 'ALBAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25035' then 'ANAPOIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25040' then 'ANOLAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25053' then 'ARBELAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25086' then 'BELTRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25095' then 'BITUIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25099' then 'BOJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25120' then 'CABRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25123' then 'CACHIPAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25126' then 'CAJICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25148' then 'CAPARRAPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25151' then 'CAQUEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25154' then 'CARMEN DE CARUPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25168' then 'CHAGUANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25175' then 'CHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25178' then 'CHIPAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25181' then 'CHOACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25183' then 'CHOCONTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25200' then 'COGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25214' then 'COTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25224' then 'CUCUNUBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25245' then 'EL COLEGIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25258' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25260' then 'EL ROSAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25269' then 'FACATATIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25279' then 'FOMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25281' then 'FOSCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25286' then 'FUNZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25288' then 'FUQUENE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25290' then 'FUSAGASUGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25293' then 'GACHALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25295' then 'GACHANCIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25297' then 'GACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25299' then 'GAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25307' then 'GIRARDOT'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25312' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25317' then 'GUACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25320' then 'GUADUAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25322' then 'GUASCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25324' then 'GUATAQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25326' then 'GUATAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25328' then 'GUAYABAL DE SIQUIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25335' then 'GUAYABETAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25339' then 'GUTIERREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25368' then 'JERUSALEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25372' then 'JUNIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25377' then 'LA CALERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25386' then 'LA MESA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25394' then 'LA PALMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25398' then 'LA PEÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25402' then 'LA VEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25407' then 'LENGUAZAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25426' then 'MACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25430' then 'MADRID'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25436' then 'MANTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25438' then 'MEDINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25473' then 'MOSQUERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25483' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25486' then 'NEMOCON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25488' then 'NILO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25489' then 'NIMAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25491' then 'NOCAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25506' then 'VENECIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25513' then 'PACHO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25518' then 'PAIME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25524' then 'PANDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25530' then 'PARATEBUENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25535' then 'PASCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25572' then 'PUERTO SALGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25580' then 'PULI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25592' then 'QUEBRADANEGRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25594' then 'QUETAME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25596' then 'QUIPILE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25599' then 'APULO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25612' then 'RICAURTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25645' then 'SAN ANTONIO DEL TEQUENDAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25649' then 'SAN BERNARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25653' then 'SAN CAYETANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25658' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25662' then 'SAN JUAN DE RIOSECO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25718' then 'SASAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25736' then 'SESQUILE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25740' then 'SIBATE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25743' then 'SILVANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25745' then 'SIMIJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25754' then 'SOACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25758' then 'SOPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25769' then 'SUBACHOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25772' then 'SUESCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25777' then 'SUPATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25779' then 'SUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25781' then 'SUTATAUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25785' then 'TABIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25793' then 'TAUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25797' then 'TENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25799' then 'TENJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25805' then 'TIBACUY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25807' then 'TIBIRITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25815' then 'TOCAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25817' then 'TOCANCIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25823' then 'TOPAIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25839' then 'UBALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25841' then 'UBAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25843' then 'VILLA DE SAN DIEGO DE UBATE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25845' then 'UNE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25851' then 'UTICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25862' then 'VERGARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25867' then 'VIANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25871' then 'VILLAGOMEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25873' then 'VILLAPINZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25875' then 'VILLETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25878' then 'VIOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25885' then 'YACOPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25898' then 'ZIPACON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25899' then 'ZIPAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27001' then 'QUIBDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27006' then 'ACANDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27025' then 'ALTO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27050' then 'ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27073' then 'BAGADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27075' then 'BAHIA SOLANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27077' then 'BAJO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27099' then 'BOJAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27135' then 'EL CANTON DEL SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27150' then 'CARMEN DEL DARIEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27160' then 'CERTEGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27205' then 'CONDOTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27245' then 'EL CARMEN DE ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27250' then 'EL LITORAL DEL SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27361' then 'ISTMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27372' then 'JURADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27413' then 'LLORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27425' then 'MEDIO ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27430' then 'MEDIO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27450' then 'MEDIO SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27491' then 'NOVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27493' then 'NUEVO BELEN DE BAJIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27495' then 'NUQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27580' then 'RIO IRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27600' then 'RIO QUITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27615' then 'RIOSUCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27660' then 'SAN JOSE DEL PALMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27745' then 'SIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27787' then 'TADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27800' then 'UNGUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27810' then 'UNION PANAMERICANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41001' then 'NEIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41006' then 'ACEVEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41013' then 'AGRADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41016' then 'AIPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41020' then 'ALGECIRAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41026' then 'ALTAMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41078' then 'BARAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41132' then 'CAMPOALEGRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41206' then 'COLOMBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41244' then 'ELIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41298' then 'GARZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41306' then 'GIGANTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41319' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41349' then 'HOBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41357' then 'IQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41359' then 'ISNOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41378' then 'LA ARGENTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41396' then 'LA PLATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41483' then 'NATAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41503' then 'OPORAPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41518' then 'PAICOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41524' then 'PALERMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41530' then 'PALESTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41548' then 'PITAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41551' then 'PITALITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41615' then 'RIVERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41660' then 'SALADOBLANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41668' then 'SAN AGUSTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41676' then 'SANTA MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41770' then 'SUAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41791' then 'TARQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41797' then 'TESALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41799' then 'TELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41801' then 'TERUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41807' then 'TIMANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41872' then 'VILLAVIEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41885' then 'YAGUARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44001' then 'RIOHACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44035' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44078' then 'BARRANCAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44090' then 'DIBULLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44098' then 'DISTRACCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44110' then 'EL MOLINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44279' then 'FONSECA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44378' then 'HATONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44420' then 'LA JAGUA DEL PILAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44430' then 'MAICAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44560' then 'MANAURE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44650' then 'SAN JUAN DEL CESAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44847' then 'URIBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44855' then 'URUMITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44874' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47001' then 'SANTA MARTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47030' then 'ALGARROBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47053' then 'ARACATACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47058' then 'ARIGUANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47161' then 'CERRO DE SAN ANTONIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47170' then 'CHIVOLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47189' then 'CIENAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47205' then 'CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47245' then 'EL BANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47258' then 'EL PIÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47268' then 'EL RETEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47288' then 'FUNDACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47318' then 'GUAMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47460' then 'NUEVA GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47541' then 'PEDRAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47545' then 'PIJIÑO DEL CARMEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47551' then 'PIVIJAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47555' then 'PLATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47570' then 'PUEBLOVIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47605' then 'REMOLINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47660' then 'SABANAS DE SAN ANGEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47675' then 'SALAMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47692' then 'SAN SEBASTIAN DE BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47703' then 'SAN ZENON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47707' then 'SANTA ANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47720' then 'SANTA BARBARA DE PINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47745' then 'SITIONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47798' then 'TENERIFE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47960' then 'ZAPAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47980' then 'ZONA BANANERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50001' then 'VILLAVICENCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50006' then 'ACACIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50110' then 'BARRANCA DE UPIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50124' then 'CABUYARO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50150' then 'CASTILLA LA NUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50223' then 'CUBARRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50226' then 'CUMARAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50245' then 'EL CALVARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50251' then 'EL CASTILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50270' then 'EL DORADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50287' then 'FUENTEDEORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50313' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50318' then 'GUAMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50325' then 'MAPIRIPAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50330' then 'MESETAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50350' then 'LA MACARENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50370' then 'URIBE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50400' then 'LEJANIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50450' then 'PUERTO CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50568' then 'PUERTO GAITAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50573' then 'PUERTO LOPEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50577' then 'PUERTO LLERAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50590' then 'PUERTO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50606' then 'RESTREPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50680' then 'SAN CARLOS DE GUAROA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50683' then 'SAN JUAN DE ARAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50686' then 'SAN JUANITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50689' then 'SAN MARTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50711' then 'VISTAHERMOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52001' then 'PASTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52019' then 'ALBAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52022' then 'ALDANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52036' then 'ANCUYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52051' then 'ARBOLEDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52079' then 'BARBACOAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52083' then 'BELEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52110' then 'BUESACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52203' then 'COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52207' then 'CONSACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52210' then 'CONTADERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52215' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52224' then 'CUASPUD CARLOSAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52227' then 'CUMBAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52233' then 'CUMBITARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52240' then 'CHACHAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52250' then 'EL CHARCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52254' then 'EL PEÑOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52256' then 'EL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52258' then 'EL TABLON DE GOMEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52260' then 'EL TAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52287' then 'FUNES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52317' then 'GUACHUCAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52320' then 'GUAITARILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52323' then 'GUALMATAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52352' then 'ILES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52354' then 'IMUES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52356' then 'IPIALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52378' then 'LA CRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52381' then 'LA FLORIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52385' then 'LA LLANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52390' then 'LA TOLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52399' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52405' then 'LEIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52411' then 'LINARES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52418' then 'LOS ANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52427' then 'MAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52435' then 'MALLAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52473' then 'MOSQUERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52480' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52490' then 'OLAYA HERRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52506' then 'OSPINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52520' then 'FRANCISCO PIZARRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52540' then 'POLICARPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52560' then 'POTOSI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52565' then 'PROVIDENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52573' then 'PUERRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52585' then 'PUPIALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52612' then 'RICAURTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52621' then 'ROBERTO PAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52678' then 'SAMANIEGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52683' then 'SANDONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52685' then 'SAN BERNARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52687' then 'SAN LORENZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52693' then 'SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52694' then 'SAN PEDRO DE CARTAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52696' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52699' then 'SANTACRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52720' then 'SAPUYES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52786' then 'TAMINANGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52788' then 'TANGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52835' then 'SAN ANDRES DE TUMACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52838' then 'TUQUERRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52885' then 'YACUANQUER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54001' then 'SAN JOSE DE CUCUTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54003' then 'ABREGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54051' then 'ARBOLEDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54099' then 'BOCHALEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54109' then 'BUCARASICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54125' then 'CACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54128' then 'CACHIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54172' then 'CHINACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54174' then 'CHITAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54206' then 'CONVENCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54223' then 'CUCUTILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54239' then 'DURANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54245' then 'EL CARMEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54250' then 'EL TARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54261' then 'EL ZULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54313' then 'GRAMALOTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54344' then 'HACARI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54347' then 'HERRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54377' then 'LABATECA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54385' then 'LA ESPERANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54398' then 'LA PLAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54405' then 'LOS PATIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54418' then 'LOURDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54480' then 'MUTISCUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54498' then 'OCAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54518' then 'PAMPLONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54520' then 'PAMPLONITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54553' then 'PUERTO SANTANDER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54599' then 'RAGONVALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54660' then 'SALAZAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54670' then 'SAN CALIXTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54673' then 'SAN CAYETANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54680' then 'SANTIAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54720' then 'SARDINATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54743' then 'SILOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54800' then 'TEORAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54810' then 'TIBU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54820' then 'TOLEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54871' then 'VILLA CARO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54874' then 'VILLA DEL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63001' then 'ARMENIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63111' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63130' then 'CALARCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63190' then 'CIRCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63212' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63272' then 'FILANDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63302' then 'GENOVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63401' then 'LA TEBAIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63470' then 'MONTENEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63548' then 'PIJAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63594' then 'QUIMBAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63690' then 'SALENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66001' then 'PEREIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66045' then 'APIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66075' then 'BALBOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66088' then 'BELEN DE UMBRIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66170' then 'DOSQUEBRADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66318' then 'GUATICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66383' then 'LA CELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66400' then 'LA VIRGINIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66440' then 'MARSELLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66456' then 'MISTRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66572' then 'PUEBLO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66594' then 'QUINCHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66682' then 'SANTA ROSA DE CABAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66687' then 'SANTUARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68001' then 'BUCARAMANGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68013' then 'AGUADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68020' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68051' then 'ARATOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68077' then 'BARBOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68079' then 'BARICHARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68081' then 'BARRANCABERMEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68092' then 'BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68101' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68121' then 'CABRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68132' then 'CALIFORNIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68147' then 'CAPITANEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68152' then 'CARCASI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68160' then 'CEPITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68162' then 'CERRITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68167' then 'CHARALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68169' then 'CHARTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68176' then 'CHIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68179' then 'CHIPATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68190' then 'CIMITARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68207' then 'CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68209' then 'CONFINES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68211' then 'CONTRATACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68217' then 'COROMORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68229' then 'CURITI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68235' then 'EL CARMEN DE CHUCURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68245' then 'EL GUACAMAYO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68250' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68255' then 'EL PLAYON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68264' then 'ENCINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68266' then 'ENCISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68271' then 'FLORIAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68276' then 'FLORIDABLANCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68296' then 'GALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68298' then 'GAMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68307' then 'GIRON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68318' then 'GUACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68320' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68322' then 'GUAPOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68324' then 'GUAVATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68327' then 'GÜEPSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68344' then 'HATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68368' then 'JESUS MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68370' then 'JORDAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68377' then 'LA BELLEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68385' then 'LANDAZURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68397' then 'LA PAZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68406' then 'LEBRIJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68418' then 'LOS SANTOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68425' then 'MACARAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68432' then 'MALAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68444' then 'MATANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68464' then 'MOGOTES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68468' then 'MOLAGAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68498' then 'OCAMONTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68500' then 'OIBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68502' then 'ONZAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68522' then 'PALMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68524' then 'PALMAS DEL SOCORRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68533' then 'PARAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68547' then 'PIEDECUESTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68549' then 'PINCHOTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68572' then 'PUENTE NACIONAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68573' then 'PUERTO PARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68575' then 'PUERTO WILCHES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68615' then 'RIONEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68655' then 'SABANA DE TORRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68669' then 'SAN ANDRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68673' then 'SAN BENITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68679' then 'SAN GIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68682' then 'SAN JOAQUIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68684' then 'SAN JOSE DE MIRANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68686' then 'SAN MIGUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68689' then 'SAN VICENTE DE CHUCURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68705' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68720' then 'SANTA HELENA DEL OPON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68745' then 'SIMACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68755' then 'SOCORRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68770' then 'SUAITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68773' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68780' then 'SURATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68820' then 'TONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68855' then 'VALLE DE SAN JOSE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68861' then 'VELEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68867' then 'VETAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68872' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68895' then 'ZAPATOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70001' then 'SINCELEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70110' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70124' then 'CAIMITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70204' then 'COLOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70215' then 'COROZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70221' then 'COVEÑAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70230' then 'CHALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70233' then 'EL ROBLE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70235' then 'GALERAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70265' then 'GUARANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70418' then 'LOS PALMITOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70429' then 'MAJAGUAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70473' then 'MORROA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70508' then 'OVEJAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70523' then 'PALMITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70670' then 'SAMPUES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70678' then 'SAN BENITO ABAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70702' then 'SAN JUAN DE BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70708' then 'SAN MARCOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70713' then 'SAN ONOFRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70717' then 'SAN PEDRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70742' then 'SAN LUIS DE SINCE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70771' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70820' then 'SANTIAGO DE TOLU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70823' then 'SAN JOSE DE TOLUVIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73001' then 'IBAGUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73024' then 'ALPUJARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73026' then 'ALVARADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73030' then 'AMBALEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73043' then 'ANZOATEGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73055' then 'ARMERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73067' then 'ATACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73124' then 'CAJAMARCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73148' then 'CARMEN DE APICALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73152' then 'CASABIANCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73168' then 'CHAPARRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73200' then 'COELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73217' then 'COYAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73226' then 'CUNDAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73236' then 'DOLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73268' then 'ESPINAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73270' then 'FALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73275' then 'FLANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73283' then 'FRESNO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73319' then 'GUAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73347' then 'HERVEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73349' then 'HONDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73352' then 'ICONONZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73408' then 'LERIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73411' then 'LIBANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73443' then 'SAN SEBASTIAN DE MARIQUITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73449' then 'MELGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73461' then 'MURILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73483' then 'NATAGAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73504' then 'ORTEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73520' then 'PALOCABILDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73547' then 'PIEDRAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73555' then 'PLANADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73563' then 'PRADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73585' then 'PURIFICACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73616' then 'RIOBLANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73622' then 'RONCESVALLES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73624' then 'ROVIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73671' then 'SALDAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73675' then 'SAN ANTONIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73678' then 'SAN LUIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73686' then 'SANTA ISABEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73770' then 'SUAREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73854' then 'VALLE DE SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73861' then 'VENADILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73870' then 'VILLAHERMOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73873' then 'VILLARRICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76001' then 'SANTIAGO DE CALI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76020' then 'ALCALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76036' then 'ANDALUCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76041' then 'ANSERMANUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76054' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76100' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76109' then 'BUENAVENTURA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76111' then 'GUADALAJARA DE BUGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76113' then 'BUGALAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76122' then 'CAICEDONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76126' then 'CALIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76130' then 'CANDELARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76147' then 'CARTAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76233' then 'DAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76243' then 'EL AGUILA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76246' then 'EL CAIRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76248' then 'EL CERRITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76250' then 'EL DOVIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76275' then 'FLORIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76306' then 'GINEBRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76318' then 'GUACARI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76364' then 'JAMUNDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76377' then 'LA CUMBRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76403' then 'LA VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76497' then 'OBANDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76520' then 'PALMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76563' then 'PRADERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76606' then 'RESTREPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76616' then 'RIOFRIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76622' then 'ROLDANILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76670' then 'SAN PEDRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76736' then 'SEVILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76823' then 'TORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76828' then 'TRUJILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76834' then 'TULUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76845' then 'ULLOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76863' then 'VERSALLES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76869' then 'VIJES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76890' then 'YOTOCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76892' then 'YUMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76895' then 'ZARZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81001' then 'ARAUCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81065' then 'ARAUQUITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81220' then 'CRAVO NORTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81300' then 'FORTUL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81591' then 'PUERTO RONDON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81736' then 'SARAVENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81794' then 'TAME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85001' then 'YOPAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85010' then 'AGUAZUL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85015' then 'CHAMEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85125' then 'HATO COROZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85136' then 'LA SALINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85139' then 'MANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85162' then 'MONTERREY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85225' then 'NUNCHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85230' then 'OROCUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85250' then 'PAZ DE ARIPORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85263' then 'PORE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85279' then 'RECETOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85300' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85315' then 'SACAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85325' then 'SAN LUIS DE PALENQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85400' then 'TAMARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85410' then 'TAURAMENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85430' then 'TRINIDAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85440' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86001' then 'MOCOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86219' then 'COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86320' then 'ORITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86568' then 'PUERTO ASIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86569' then 'PUERTO CAICEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86571' then 'PUERTO GUZMAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86573' then 'PUERTO LEGUIZAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86749' then 'SIBUNDOY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86755' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86757' then 'SAN MIGUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86760' then 'SANTIAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86865' then 'VALLE DEL GUAMUEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86885' then 'VILLAGARZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='88001' then 'SAN ANDRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='88564' then 'PROVIDENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91001' then 'LETICIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91263' then 'EL ENCANTO (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91405' then 'LA CHORRERA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91407' then 'LA PEDRERA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91430' then 'LA VICTORIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91460' then 'MIRITI - PARANA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91530' then 'PUERTO ALEGRIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91536' then 'PUERTO ARICA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91540' then 'PUERTO NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91669' then 'PUERTO SANTANDER (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91798' then 'TARAPACA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94001' then 'INIRIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94343' then 'BARRANCOMINAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94883' then 'SAN FELIPE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94884' then 'PUERTO COLOMBIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94885' then 'LA GUADALUPE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94886' then 'CACAHUAL (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94887' then 'PANA PANA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94888' then 'MORICHAL (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95001' then 'SAN JOSE DEL GUAVIARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95015' then 'CALAMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95025' then 'EL RETORNO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95200' then 'MIRAFLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97001' then 'MITU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97161' then 'CARURU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97511' then 'PACOA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97666' then 'TARAIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97777' then 'PAPUNAHUA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97889' then 'YAVARATE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99001' then 'PUERTO CARREÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99524' then 'LA PRIMAVERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99624' then 'SANTA ROSALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99773' then 'CUMARIBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05001' then 'MEDELLIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05002' then 'ABEJORRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05004' then 'ABRIAQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05021' then 'ALEJANDRIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05030' then 'AMAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05031' then 'AMALFI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05034' then 'ANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05036' then 'ANGELOPOLIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05038' then 'ANGOSTURA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05040' then 'ANORI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05042' then 'SANTA FE DE ANTIOQUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05044' then 'ANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05045' then 'APARTADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05051' then 'ARBOLETES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05055' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05059' then 'ARMENIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05079' then 'BARBOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05086' then 'BELMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05088' then 'BELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05091' then 'BETANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05093' then 'BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05101' then 'CIUDAD BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05107' then 'BRICEÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05113' then 'BURITICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05120' then 'CACERES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05125' then 'CAICEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05129' then 'CALDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05134' then 'CAMPAMENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05138' then 'CAÑASGORDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05142' then 'CARACOLI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05145' then 'CARAMANTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05147' then 'CAREPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05148' then 'EL CARMEN DE VIBORAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05150' then 'CAROLINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05154' then 'CAUCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05172' then 'CHIGORODO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05190' then 'CISNEROS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05197' then 'COCORNA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05206' then 'CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05209' then 'CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05212' then 'COPACABANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05234' then 'DABEIBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05237' then 'DONMATIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05240' then 'EBEJICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05250' then 'EL BAGRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05264' then 'ENTRERRIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05266' then 'ENVIGADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05282' then 'FREDONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05284' then 'FRONTINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05306' then 'GIRALDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05308' then 'GIRARDOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05310' then 'GOMEZ PLATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05313' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05315' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05318' then 'GUARNE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05321' then 'GUATAPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05347' then 'HELICONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05353' then 'HISPANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05360' then 'ITAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05361' then 'ITUANGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05364' then 'JARDIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05368' then 'JERICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05376' then 'LA CEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05380' then 'LA ESTRELLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05390' then 'LA PINTADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05411' then 'LIBORINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05425' then 'MACEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05440' then 'MARINILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05467' then 'MONTEBELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05475' then 'MURINDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05480' then 'MUTATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05483' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05490' then 'NECOCLI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05495' then 'NECHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05501' then 'OLAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05541' then 'PEÑOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05543' then 'PEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05576' then 'PUEBLORRICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05579' then 'PUERTO BERRIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05585' then 'PUERTO NARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05591' then 'PUERTO TRIUNFO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05604' then 'REMEDIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05607' then 'RETIRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05615' then 'RIONEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05628' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05631' then 'SABANETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05642' then 'SALGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05647' then 'SAN ANDRES DE CUERQUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05649' then 'SAN CARLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05652' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05656' then 'SAN JERONIMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05658' then 'SAN JOSE DE LA MONTAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05659' then 'SAN JUAN DE URABA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05660' then 'SAN LUIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05664' then 'SAN PEDRO DE LOS MILAGROS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05665' then 'SAN PEDRO DE URABA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05667' then 'SAN RAFAEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05670' then 'SAN ROQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05674' then 'SAN VICENTE FERRER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05679' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05686' then 'SANTA ROSA DE OSOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05690' then 'SANTO DOMINGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05697' then 'EL SANTUARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05736' then 'SEGOVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05756' then 'SONSON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05761' then 'SOPETRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05789' then 'TAMESIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05790' then 'TARAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05792' then 'TARSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05809' then 'TITIRIBI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05819' then 'TOLEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05837' then 'TURBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05842' then 'URAMITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05847' then 'URRAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05854' then 'VALDIVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05856' then 'VALPARAISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05858' then 'VEGACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05861' then 'VENECIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05873' then 'VIGIA DEL FUERTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05885' then 'YALI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05887' then 'YARUMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05890' then 'YOLOMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05893' then 'YONDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05895' then 'ZARAGOZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08001' then 'BARRANQUILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08078' then 'BARANOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08137' then 'CAMPO DE LA CRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08141' then 'CANDELARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08296' then 'GALAPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08372' then 'JUAN DE ACOSTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08421' then 'LURUACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08433' then 'MALAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08436' then 'MANATI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08520' then 'PALMAR DE VARELA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08549' then 'PIOJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08558' then 'POLONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08560' then 'PONEDERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08573' then 'PUERTO COLOMBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08606' then 'REPELON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08634' then 'SABANAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08638' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08675' then 'SANTA LUCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08685' then 'SANTO TOMAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08758' then 'SOLEDAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08770' then 'SUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08832' then 'TUBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08849' then 'USIACURI'
                    ELSE CONCAT(pd.departamento, pd.municipio)

                end as municipio, 
                UPPER(pd.vereda), UPPER(pd.uit), UPPER(pd.nombre_reconocedor), TO_CHAR(pd.fecha_visita_predial,'DD/MM/YYYY') as fecha_levantamiento,
                CONCAT(pd.departamento,pd.municipio) as divipola
                
            FROM 
                {esquema}.cca_predio pd
            JOIN 
                {esquema}.cca_condicionprediotipo cpt 
                ON pd.condicion_predio = cpt.t_id
            JOIN 
                {esquema}.cca_terreno te 
                ON pd.terreno = te.t_id
            JOIN {esquema}.cca_derecho der ON pd.t_id=der.predio
            JOIN {esquema}.cca_derechotipo drtp on der.tipo=drtp.t_id
            JOIN {esquema}.cca_metodointervenciontipo interv on pd.metodointervencion=interv.t_id

            WHERE 
                cpt.ilicode='Informal'
        """
    }

    cursor = conexion.cursor()
    timestamp = datetime.now().strftime("%d%m%Y_%H%M%S")
    output_file = f'{output_folder}/formal_informal_{esquema}_{timestamp}.gpkg'

    formal_has_geometry = False
    informal_has_geometry = False

    for key, query in queries.items():
        cursor.execute(query)
        records = cursor.fetchall()

        # Filtrar los registros con geometría válida
        records_with_geometry = [record for record in records if record[3] is not None]

        if not records_with_geometry:
            print(f"La consulta {key} no devolvió ningún registro con geometría. La capa no se creará.")
            continue

        if key == 'FORMAL':
            formal_has_geometry = True
        elif key == 'INFORMAL':
            informal_has_geometry = True

        schema = {
            'geometry': 'Unknown',  
            'properties': {
                'QR': 'int64',
                'QR_CONTENEDOR': 'int64',
                'DTO':'str',
                'MUNI':'str',
                'VEREDA_IGAC':'str',
                'UIT':'str',
                'R_TEC_LEV':'str',
                'MET_LEV':'str',
                'AREA_M2': 'float',
                'TIPO_DERECHO':'str:11',
                'FORMAL_INFORMAL': 'str:30',
                'NATURALEZA': 'str:15',
                'F_PROG_LEV': 'str:10',
                'F_LEV': 'str:10',
                'F_REPOR': 'str:10',
                'FECH_CARGUE_TEC': 'str:10',
                'COD_DANE': 'str:5',
                'OBS': 'str:100'



            }
        }

        # Crear GPKG y escribir datos
        with fiona.open(output_file, 'w', driver='GPKG', crs=CRS.from_epsg(9377).to_wkt(), schema=schema, layer=key) as layer:
            for record in records_with_geometry:
                try:
                    geom = wkb.loads(bytes(record[3]))
                    if isinstance(geom, (Polygon, MultiPolygon)):
                        layer.write({
                            'geometry': mapping(geom),
                            'properties': {
                                'QR': record[1],
                                'QR_CONTENEDOR': record[0],
                                'DTO': record[7],
                                'MUNI': record[8],
                                'VEREDA_IGAC': record[9],
                                'UIT': record[10],
                                'R_TEC_LEV': record[11],
                                'MET_LEV': record[6],
                                'AREA_M2': float(record[4]),
                                'TIPO_DERECHO': record[5][:11] if record[5] else None,
                                'FORMAL_INFORMAL': record[2][:30] if record[2] else None, 
                                'NATURALEZA': None,
                                'F_PROG_LEV': None,
                                'F_LEV':  record[12][:10] if record[12] else None,
                                'F_REPOR': None,
                                'FECH_CARGUE_TEC': None,
                                'COD_DANE': record[13][:5] if record[13] else None,
                                'OBS': None

                                
                                
                            }
                        })
                except Exception as e:
                    print(f"Error al analizar registro {record}: {e}")
                    continue

    # Verificar si ambas capas (FORMAL e INFORMAL) tienen geometría antes de generar UNIFICADO
    if formal_has_geometry and informal_has_geometry:
        query_unificado = f"""
            SELECT 
                pd.qr_operacion, 
                pd.qr_operacion_definitivo, 
                CASE
                    WHEN cpt.ilicode='NPH' then 'FORMAL_XXXXXX'
                    WHEN cpt.ilicode='Informal' then 'INFORMAL'
                    else cpt.ilicode
                end as condicion_predio,

                ST_AsBinary(ST_SetSRID(te.geometria, 9377)) AS geometria,
                ROUND((ST_Area(ST_Transform(te.geometria, 9377))::numeric), 2) as area_levantamiento,
                UPPER(drtp.ilicode) as derecho_tipo,
                CASE 
                    WHEN interv.ilicode='Colaborativo_Declarativo' then 'METODO_DECLARATIVO_Y_COLABORATIVO'
                    WHEN interv.ilicode='Indirecto' then 'METODO_INDIRECTO'
                    WHEN interv.ilicode='Mixto' then 'MIXTO'
                    WHEN interv.ilicode='Directo' then 'METODO_DIRECTO'
                end as metodo_levantamiento, 
                CASE
                    WHEN pd.departamento='13' then 'BOLIVAR'
                    WHEN pd.departamento='15' then 'BOYACA'
                    WHEN pd.departamento='17' then 'CALDAS'
                    WHEN pd.departamento='18' then 'CAQUETA'
                    WHEN pd.departamento='19' then 'CAUCA'
                    WHEN pd.departamento='20' then 'CESAR'
                    WHEN pd.departamento='23' then 'CORDOBA'
                    WHEN pd.departamento='25' then 'CUNDINAMARCA'
                    WHEN pd.departamento='27' then 'CHOCO'
                    WHEN pd.departamento='41' then 'HUILA'
                    WHEN pd.departamento='44' then 'LA GUAJIRA'
                    WHEN pd.departamento='47' then 'MAGDALENA'
                    WHEN pd.departamento='50' then 'META'
                    WHEN pd.departamento='52' then 'NARIÑO'
                    WHEN pd.departamento='54' then 'NORTE DE SANTANDER'
                    WHEN pd.departamento='63' then 'QUINDIO'
                    WHEN pd.departamento='66' then 'RISARALDA'
                    WHEN pd.departamento='68' then 'SANTANDER'
                    WHEN pd.departamento='70' then 'SUCRE'
                    WHEN pd.departamento='73' then 'TOLIMA'
                    WHEN pd.departamento='76' then 'VALLE DEL CAUCA'
                    WHEN pd.departamento='81' then 'ARAUCA'
                    WHEN pd.departamento='85' then 'CASANARE'
                    WHEN pd.departamento='86' then 'PUTUMAYO'
                    WHEN pd.departamento='88' then 'ARCHIPIELAGO DE SAN ANDRES, PROVIDENCIA Y SANTA CATALINA'
                    WHEN pd.departamento='91' then 'AMAZONAS'
                    WHEN pd.departamento='94' then 'GUAINIA'
                    WHEN pd.departamento='95' then 'GUAVIARE'
                    WHEN pd.departamento='97' then 'VAUPES'
                    WHEN pd.departamento='99' then 'VICHADA'
                    WHEN pd.departamento='05' then 'ANTIOQUIA'
                    WHEN pd.departamento='08' then 'ATLANTICO'
                ELSE pd.departamento
                end as departamento,
                CASE 

                    WHEN CONCAT(pd.departamento, pd.municipio)='11001' then 'BOGOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13001' then 'CARTAGENA DE INDIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13006' then 'ACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13030' then 'ALTOS DEL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13042' then 'ARENAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13052' then 'ARJONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13062' then 'ARROYOHONDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13074' then 'BARRANCO DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13140' then 'CALAMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13160' then 'CANTAGALLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13188' then 'CICUCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13212' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13222' then 'CLEMENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13244' then 'EL CARMEN DE BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13248' then 'EL GUAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13268' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13300' then 'HATILLO DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13430' then 'MAGANGUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13433' then 'MAHATES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13440' then 'MARGARITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13442' then 'MARIA LA BAJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13458' then 'MONTECRISTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13468' then 'SANTA CRUZ DE MOMPOX'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13473' then 'MORALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13490' then 'NOROSI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13549' then 'PINILLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13580' then 'REGIDOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13600' then 'RIO VIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13620' then 'SAN CRISTOBAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13647' then 'SAN ESTANISLAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13650' then 'SAN FERNANDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13654' then 'SAN JACINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13655' then 'SAN JACINTO DEL CAUCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13657' then 'SAN JUAN NEPOMUCENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13667' then 'SAN MARTIN DE LOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13670' then 'SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13673' then 'SANTA CATALINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13683' then 'SANTA ROSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13688' then 'SANTA ROSA DEL SUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13744' then 'SIMITI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13760' then 'SOPLAVIENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13780' then 'TALAIGUA NUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13810' then 'TIQUISIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13836' then 'TURBACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13838' then 'TURBANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13873' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='13894' then 'ZAMBRANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15001' then 'TUNJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15022' then 'ALMEIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15047' then 'AQUITANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15051' then 'ARCABUCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15087' then 'BELEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15090' then 'BERBEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15092' then 'BETEITIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15097' then 'BOAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15104' then 'BOYACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15106' then 'BRICEÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15109' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15114' then 'BUSBANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15131' then 'CALDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15135' then 'CAMPOHERMOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15162' then 'CERINZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15172' then 'CHINAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15176' then 'CHIQUINQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15180' then 'CHISCAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15183' then 'CHITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15185' then 'CHITARAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15187' then 'CHIVATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15189' then 'CIENEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15204' then 'COMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15212' then 'COPER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15215' then 'CORRALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15218' then 'COVARACHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15223' then 'CUBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15224' then 'CUCAITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15226' then 'CUITIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15232' then 'CHIQUIZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15236' then 'CHIVOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15238' then 'DUITAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15244' then 'EL COCUY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15248' then 'EL ESPINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15272' then 'FIRAVITOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15276' then 'FLORESTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15293' then 'GACHANTIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15296' then 'GAMEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15299' then 'GARAGOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15317' then 'GUACAMAYAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15322' then 'GUATEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15325' then 'GUAYATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15332' then 'GÜICAN DE LA SIERRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15362' then 'IZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15367' then 'JENESANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15368' then 'JERICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15377' then 'LABRANZAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15380' then 'LA CAPILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15401' then 'LA VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15403' then 'LA UVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15407' then 'VILLA DE LEYVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15425' then 'MACANAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15442' then 'MARIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15455' then 'MIRAFLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15464' then 'MONGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15466' then 'MONGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15469' then 'MONIQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15476' then 'MOTAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15480' then 'MUZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15491' then 'NOBSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15494' then 'NUEVO COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15500' then 'OICATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15507' then 'OTANCHE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15511' then 'PACHAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15514' then 'PAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15516' then 'PAIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15518' then 'PAJARITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15522' then 'PANQUEBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15531' then 'PAUNA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15533' then 'PAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15537' then 'PAZ DE RIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15542' then 'PESCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15550' then 'PISBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15572' then 'PUERTO BOYACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15580' then 'QUIPAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15599' then 'RAMIRIQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15600' then 'RAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15621' then 'RONDON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15632' then 'SABOYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15638' then 'SACHICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15646' then 'SAMACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15660' then 'SAN EDUARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15664' then 'SAN JOSE DE PARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15667' then 'SAN LUIS DE GACENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15673' then 'SAN MATEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15676' then 'SAN MIGUEL DE SEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15681' then 'SAN PABLO DE BORBUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15686' then 'SANTANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15690' then 'SANTA MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15693' then 'SANTA ROSA DE VITERBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15696' then 'SANTA SOFIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15720' then 'SATIVANORTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15723' then 'SATIVASUR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15740' then 'SIACHOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15753' then 'SOATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15755' then 'SOCOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15757' then 'SOCHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15759' then 'SOGAMOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15761' then 'SOMONDOCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15762' then 'SORA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15763' then 'SOTAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15764' then 'SORACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15774' then 'SUSACON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15776' then 'SUTAMARCHAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15778' then 'SUTATENZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15790' then 'TASCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15798' then 'TENZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15804' then 'TIBANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15806' then 'TIBASOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15808' then 'TINJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15810' then 'TIPACOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15814' then 'TOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15816' then 'TOGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15820' then 'TOPAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15822' then 'TOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15832' then 'TUNUNGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15835' then 'TURMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15837' then 'TUTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15839' then 'TUTAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15842' then 'UMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15861' then 'VENTAQUEMADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15879' then 'VIRACACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='15897' then 'ZETAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17001' then 'MANIZALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17013' then 'AGUADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17042' then 'ANSERMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17050' then 'ARANZAZU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17088' then 'BELALCAZAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17174' then 'CHINCHINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17272' then 'FILADELFIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17380' then 'LA DORADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17388' then 'LA MERCED'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17433' then 'MANZANARES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17442' then 'MARMATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17444' then 'MARQUETALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17446' then 'MARULANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17486' then 'NEIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17495' then 'NORCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17513' then 'PACORA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17524' then 'PALESTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17541' then 'PENSILVANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17614' then 'RIOSUCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17616' then 'RISARALDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17653' then 'SALAMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17662' then 'SAMANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17665' then 'SAN JOSE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17777' then 'SUPIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17867' then 'VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17873' then 'VILLAMARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='17877' then 'VITERBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18001' then 'FLORENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18029' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18094' then 'BELEN DE LOS ANDAQUIES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18150' then 'CARTAGENA DEL CHAIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18205' then 'CURILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18247' then 'EL DONCELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18256' then 'EL PAUJIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18410' then 'LA MONTAÑITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18460' then 'MILAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18479' then 'MORELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18592' then 'PUERTO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18610' then 'SAN JOSE DEL FRAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18753' then 'SAN VICENTE DEL CAGUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18756' then 'SOLANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18785' then 'SOLITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='18860' then 'VALPARAISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19001' then 'POPAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19022' then 'ALMAGUER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19050' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19075' then 'BALBOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19100' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19110' then 'BUENOS AIRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19130' then 'CAJIBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19137' then 'CALDONO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19142' then 'CALOTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19212' then 'CORINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19256' then 'EL TAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19290' then 'FLORENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19300' then 'GUACHENE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19318' then 'GUAPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19355' then 'INZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19364' then 'JAMBALO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19392' then 'LA SIERRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19397' then 'LA VEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19418' then 'LOPEZ DE MICAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19450' then 'MERCADERES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19455' then 'MIRANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19473' then 'MORALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19513' then 'PADILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19517' then 'PAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19532' then 'PATIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19533' then 'PIAMONTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19548' then 'PIENDAMO - TUNIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19573' then 'PUERTO TEJADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19585' then 'PURACE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19622' then 'ROSAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19693' then 'SAN SEBASTIAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19698' then 'SANTANDER DE QUILICHAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19701' then 'SANTA ROSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19743' then 'SILVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19760' then 'SOTARA PAISPAMBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19780' then 'SUAREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19785' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19807' then 'TIMBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19809' then 'TIMBIQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19821' then 'TORIBIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19824' then 'TOTORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='19845' then 'VILLA RICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20001' then 'VALLEDUPAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20011' then 'AGUACHICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20013' then 'AGUSTIN CODAZZI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20032' then 'ASTREA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20045' then 'BECERRIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20060' then 'BOSCONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20175' then 'CHIMICHAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20178' then 'CHIRIGUANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20228' then 'CURUMANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20238' then 'EL COPEY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20250' then 'EL PASO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20295' then 'GAMARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20310' then 'GONZALEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20383' then 'LA GLORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20400' then 'LA JAGUA DE IBIRICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20443' then 'MANAURE BALCON DEL CESAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20517' then 'PAILITAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20550' then 'PELAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20570' then 'PUEBLO BELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20614' then 'RIO DE ORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20621' then 'LA PAZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20710' then 'SAN ALBERTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20750' then 'SAN DIEGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20770' then 'SAN MARTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='20787' then 'TAMALAMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23001' then 'MONTERIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23068' then 'AYAPEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23079' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23090' then 'CANALETE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23162' then 'CERETE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23168' then 'CHIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23182' then 'CHINU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23189' then 'CIENAGA DE ORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23300' then 'COTORRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23350' then 'LA APARTADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23417' then 'LORICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23419' then 'LOS CORDOBAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23464' then 'MOMIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23466' then 'MONTELIBANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23500' then 'MOÑITOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23555' then 'PLANETA RICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23570' then 'PUEBLO NUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23574' then 'PUERTO ESCONDIDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23580' then 'PUERTO LIBERTADOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23586' then 'PURISIMA DE LA CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23660' then 'SAHAGUN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23670' then 'SAN ANDRES DE SOTAVENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23672' then 'SAN ANTERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23675' then 'SAN BERNARDO DEL VIENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23678' then 'SAN CARLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23682' then 'SAN JOSE DE URE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23686' then 'SAN PELAYO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23807' then 'TIERRALTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23815' then 'TUCHIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='23855' then 'VALENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25001' then 'AGUA DE DIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25019' then 'ALBAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25035' then 'ANAPOIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25040' then 'ANOLAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25053' then 'ARBELAEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25086' then 'BELTRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25095' then 'BITUIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25099' then 'BOJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25120' then 'CABRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25123' then 'CACHIPAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25126' then 'CAJICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25148' then 'CAPARRAPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25151' then 'CAQUEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25154' then 'CARMEN DE CARUPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25168' then 'CHAGUANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25175' then 'CHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25178' then 'CHIPAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25181' then 'CHOACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25183' then 'CHOCONTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25200' then 'COGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25214' then 'COTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25224' then 'CUCUNUBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25245' then 'EL COLEGIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25258' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25260' then 'EL ROSAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25269' then 'FACATATIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25279' then 'FOMEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25281' then 'FOSCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25286' then 'FUNZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25288' then 'FUQUENE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25290' then 'FUSAGASUGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25293' then 'GACHALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25295' then 'GACHANCIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25297' then 'GACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25299' then 'GAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25307' then 'GIRARDOT'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25312' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25317' then 'GUACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25320' then 'GUADUAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25322' then 'GUASCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25324' then 'GUATAQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25326' then 'GUATAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25328' then 'GUAYABAL DE SIQUIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25335' then 'GUAYABETAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25339' then 'GUTIERREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25368' then 'JERUSALEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25372' then 'JUNIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25377' then 'LA CALERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25386' then 'LA MESA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25394' then 'LA PALMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25398' then 'LA PEÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25402' then 'LA VEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25407' then 'LENGUAZAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25426' then 'MACHETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25430' then 'MADRID'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25436' then 'MANTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25438' then 'MEDINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25473' then 'MOSQUERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25483' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25486' then 'NEMOCON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25488' then 'NILO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25489' then 'NIMAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25491' then 'NOCAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25506' then 'VENECIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25513' then 'PACHO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25518' then 'PAIME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25524' then 'PANDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25530' then 'PARATEBUENO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25535' then 'PASCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25572' then 'PUERTO SALGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25580' then 'PULI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25592' then 'QUEBRADANEGRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25594' then 'QUETAME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25596' then 'QUIPILE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25599' then 'APULO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25612' then 'RICAURTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25645' then 'SAN ANTONIO DEL TEQUENDAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25649' then 'SAN BERNARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25653' then 'SAN CAYETANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25658' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25662' then 'SAN JUAN DE RIOSECO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25718' then 'SASAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25736' then 'SESQUILE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25740' then 'SIBATE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25743' then 'SILVANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25745' then 'SIMIJACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25754' then 'SOACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25758' then 'SOPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25769' then 'SUBACHOQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25772' then 'SUESCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25777' then 'SUPATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25779' then 'SUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25781' then 'SUTATAUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25785' then 'TABIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25793' then 'TAUSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25797' then 'TENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25799' then 'TENJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25805' then 'TIBACUY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25807' then 'TIBIRITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25815' then 'TOCAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25817' then 'TOCANCIPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25823' then 'TOPAIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25839' then 'UBALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25841' then 'UBAQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25843' then 'VILLA DE SAN DIEGO DE UBATE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25845' then 'UNE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25851' then 'UTICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25862' then 'VERGARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25867' then 'VIANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25871' then 'VILLAGOMEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25873' then 'VILLAPINZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25875' then 'VILLETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25878' then 'VIOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25885' then 'YACOPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25898' then 'ZIPACON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='25899' then 'ZIPAQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27001' then 'QUIBDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27006' then 'ACANDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27025' then 'ALTO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27050' then 'ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27073' then 'BAGADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27075' then 'BAHIA SOLANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27077' then 'BAJO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27099' then 'BOJAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27135' then 'EL CANTON DEL SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27150' then 'CARMEN DEL DARIEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27160' then 'CERTEGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27205' then 'CONDOTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27245' then 'EL CARMEN DE ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27250' then 'EL LITORAL DEL SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27361' then 'ISTMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27372' then 'JURADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27413' then 'LLORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27425' then 'MEDIO ATRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27430' then 'MEDIO BAUDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27450' then 'MEDIO SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27491' then 'NOVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27493' then 'NUEVO BELEN DE BAJIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27495' then 'NUQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27580' then 'RIO IRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27600' then 'RIO QUITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27615' then 'RIOSUCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27660' then 'SAN JOSE DEL PALMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27745' then 'SIPI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27787' then 'TADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27800' then 'UNGUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='27810' then 'UNION PANAMERICANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41001' then 'NEIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41006' then 'ACEVEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41013' then 'AGRADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41016' then 'AIPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41020' then 'ALGECIRAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41026' then 'ALTAMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41078' then 'BARAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41132' then 'CAMPOALEGRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41206' then 'COLOMBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41244' then 'ELIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41298' then 'GARZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41306' then 'GIGANTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41319' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41349' then 'HOBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41357' then 'IQUIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41359' then 'ISNOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41378' then 'LA ARGENTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41396' then 'LA PLATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41483' then 'NATAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41503' then 'OPORAPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41518' then 'PAICOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41524' then 'PALERMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41530' then 'PALESTINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41548' then 'PITAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41551' then 'PITALITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41615' then 'RIVERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41660' then 'SALADOBLANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41668' then 'SAN AGUSTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41676' then 'SANTA MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41770' then 'SUAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41791' then 'TARQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41797' then 'TESALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41799' then 'TELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41801' then 'TERUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41807' then 'TIMANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41872' then 'VILLAVIEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='41885' then 'YAGUARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44001' then 'RIOHACHA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44035' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44078' then 'BARRANCAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44090' then 'DIBULLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44098' then 'DISTRACCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44110' then 'EL MOLINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44279' then 'FONSECA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44378' then 'HATONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44420' then 'LA JAGUA DEL PILAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44430' then 'MAICAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44560' then 'MANAURE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44650' then 'SAN JUAN DEL CESAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44847' then 'URIBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44855' then 'URUMITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='44874' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47001' then 'SANTA MARTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47030' then 'ALGARROBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47053' then 'ARACATACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47058' then 'ARIGUANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47161' then 'CERRO DE SAN ANTONIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47170' then 'CHIVOLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47189' then 'CIENAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47205' then 'CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47245' then 'EL BANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47258' then 'EL PIÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47268' then 'EL RETEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47288' then 'FUNDACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47318' then 'GUAMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47460' then 'NUEVA GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47541' then 'PEDRAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47545' then 'PIJIÑO DEL CARMEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47551' then 'PIVIJAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47555' then 'PLATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47570' then 'PUEBLOVIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47605' then 'REMOLINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47660' then 'SABANAS DE SAN ANGEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47675' then 'SALAMINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47692' then 'SAN SEBASTIAN DE BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47703' then 'SAN ZENON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47707' then 'SANTA ANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47720' then 'SANTA BARBARA DE PINTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47745' then 'SITIONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47798' then 'TENERIFE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47960' then 'ZAPAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='47980' then 'ZONA BANANERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50001' then 'VILLAVICENCIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50006' then 'ACACIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50110' then 'BARRANCA DE UPIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50124' then 'CABUYARO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50150' then 'CASTILLA LA NUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50223' then 'CUBARRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50226' then 'CUMARAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50245' then 'EL CALVARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50251' then 'EL CASTILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50270' then 'EL DORADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50287' then 'FUENTEDEORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50313' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50318' then 'GUAMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50325' then 'MAPIRIPAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50330' then 'MESETAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50350' then 'LA MACARENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50370' then 'URIBE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50400' then 'LEJANIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50450' then 'PUERTO CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50568' then 'PUERTO GAITAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50573' then 'PUERTO LOPEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50577' then 'PUERTO LLERAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50590' then 'PUERTO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50606' then 'RESTREPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50680' then 'SAN CARLOS DE GUAROA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50683' then 'SAN JUAN DE ARAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50686' then 'SAN JUANITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50689' then 'SAN MARTIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='50711' then 'VISTAHERMOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52001' then 'PASTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52019' then 'ALBAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52022' then 'ALDANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52036' then 'ANCUYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52051' then 'ARBOLEDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52079' then 'BARBACOAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52083' then 'BELEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52110' then 'BUESACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52203' then 'COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52207' then 'CONSACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52210' then 'CONTADERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52215' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52224' then 'CUASPUD CARLOSAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52227' then 'CUMBAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52233' then 'CUMBITARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52240' then 'CHACHAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52250' then 'EL CHARCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52254' then 'EL PEÑOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52256' then 'EL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52258' then 'EL TABLON DE GOMEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52260' then 'EL TAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52287' then 'FUNES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52317' then 'GUACHUCAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52320' then 'GUAITARILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52323' then 'GUALMATAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52352' then 'ILES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52354' then 'IMUES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52356' then 'IPIALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52378' then 'LA CRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52381' then 'LA FLORIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52385' then 'LA LLANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52390' then 'LA TOLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52399' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52405' then 'LEIVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52411' then 'LINARES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52418' then 'LOS ANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52427' then 'MAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52435' then 'MALLAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52473' then 'MOSQUERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52480' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52490' then 'OLAYA HERRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52506' then 'OSPINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52520' then 'FRANCISCO PIZARRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52540' then 'POLICARPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52560' then 'POTOSI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52565' then 'PROVIDENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52573' then 'PUERRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52585' then 'PUPIALES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52612' then 'RICAURTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52621' then 'ROBERTO PAYAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52678' then 'SAMANIEGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52683' then 'SANDONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52685' then 'SAN BERNARDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52687' then 'SAN LORENZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52693' then 'SAN PABLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52694' then 'SAN PEDRO DE CARTAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52696' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52699' then 'SANTACRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52720' then 'SAPUYES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52786' then 'TAMINANGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52788' then 'TANGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52835' then 'SAN ANDRES DE TUMACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52838' then 'TUQUERRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='52885' then 'YACUANQUER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54001' then 'SAN JOSE DE CUCUTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54003' then 'ABREGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54051' then 'ARBOLEDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54099' then 'BOCHALEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54109' then 'BUCARASICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54125' then 'CACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54128' then 'CACHIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54172' then 'CHINACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54174' then 'CHITAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54206' then 'CONVENCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54223' then 'CUCUTILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54239' then 'DURANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54245' then 'EL CARMEN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54250' then 'EL TARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54261' then 'EL ZULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54313' then 'GRAMALOTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54344' then 'HACARI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54347' then 'HERRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54377' then 'LABATECA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54385' then 'LA ESPERANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54398' then 'LA PLAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54405' then 'LOS PATIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54418' then 'LOURDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54480' then 'MUTISCUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54498' then 'OCAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54518' then 'PAMPLONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54520' then 'PAMPLONITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54553' then 'PUERTO SANTANDER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54599' then 'RAGONVALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54660' then 'SALAZAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54670' then 'SAN CALIXTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54673' then 'SAN CAYETANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54680' then 'SANTIAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54720' then 'SARDINATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54743' then 'SILOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54800' then 'TEORAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54810' then 'TIBU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54820' then 'TOLEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54871' then 'VILLA CARO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='54874' then 'VILLA DEL ROSARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63001' then 'ARMENIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63111' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63130' then 'CALARCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63190' then 'CIRCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63212' then 'CORDOBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63272' then 'FILANDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63302' then 'GENOVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63401' then 'LA TEBAIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63470' then 'MONTENEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63548' then 'PIJAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63594' then 'QUIMBAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='63690' then 'SALENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66001' then 'PEREIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66045' then 'APIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66075' then 'BALBOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66088' then 'BELEN DE UMBRIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66170' then 'DOSQUEBRADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66318' then 'GUATICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66383' then 'LA CELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66400' then 'LA VIRGINIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66440' then 'MARSELLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66456' then 'MISTRATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66572' then 'PUEBLO RICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66594' then 'QUINCHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66682' then 'SANTA ROSA DE CABAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='66687' then 'SANTUARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68001' then 'BUCARAMANGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68013' then 'AGUADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68020' then 'ALBANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68051' then 'ARATOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68077' then 'BARBOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68079' then 'BARICHARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68081' then 'BARRANCABERMEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68092' then 'BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68101' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68121' then 'CABRERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68132' then 'CALIFORNIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68147' then 'CAPITANEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68152' then 'CARCASI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68160' then 'CEPITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68162' then 'CERRITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68167' then 'CHARALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68169' then 'CHARTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68176' then 'CHIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68179' then 'CHIPATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68190' then 'CIMITARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68207' then 'CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68209' then 'CONFINES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68211' then 'CONTRATACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68217' then 'COROMORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68229' then 'CURITI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68235' then 'EL CARMEN DE CHUCURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68245' then 'EL GUACAMAYO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68250' then 'EL PEÑON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68255' then 'EL PLAYON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68264' then 'ENCINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68266' then 'ENCISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68271' then 'FLORIAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68276' then 'FLORIDABLANCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68296' then 'GALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68298' then 'GAMBITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68307' then 'GIRON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68318' then 'GUACA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68320' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68322' then 'GUAPOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68324' then 'GUAVATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68327' then 'GÜEPSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68344' then 'HATO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68368' then 'JESUS MARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68370' then 'JORDAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68377' then 'LA BELLEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68385' then 'LANDAZURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68397' then 'LA PAZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68406' then 'LEBRIJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68418' then 'LOS SANTOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68425' then 'MACARAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68432' then 'MALAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68444' then 'MATANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68464' then 'MOGOTES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68468' then 'MOLAGAVITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68498' then 'OCAMONTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68500' then 'OIBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68502' then 'ONZAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68522' then 'PALMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68524' then 'PALMAS DEL SOCORRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68533' then 'PARAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68547' then 'PIEDECUESTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68549' then 'PINCHOTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68572' then 'PUENTE NACIONAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68573' then 'PUERTO PARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68575' then 'PUERTO WILCHES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68615' then 'RIONEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68655' then 'SABANA DE TORRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68669' then 'SAN ANDRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68673' then 'SAN BENITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68679' then 'SAN GIL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68682' then 'SAN JOAQUIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68684' then 'SAN JOSE DE MIRANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68686' then 'SAN MIGUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68689' then 'SAN VICENTE DE CHUCURI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68705' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68720' then 'SANTA HELENA DEL OPON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68745' then 'SIMACOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68755' then 'SOCORRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68770' then 'SUAITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68773' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68780' then 'SURATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68820' then 'TONA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68855' then 'VALLE DE SAN JOSE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68861' then 'VELEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68867' then 'VETAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68872' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='68895' then 'ZAPATOCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70001' then 'SINCELEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70110' then 'BUENAVISTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70124' then 'CAIMITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70204' then 'COLOSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70215' then 'COROZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70221' then 'COVEÑAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70230' then 'CHALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70233' then 'EL ROBLE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70235' then 'GALERAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70265' then 'GUARANDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70418' then 'LOS PALMITOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70429' then 'MAJAGUAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70473' then 'MORROA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70508' then 'OVEJAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70523' then 'PALMITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70670' then 'SAMPUES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70678' then 'SAN BENITO ABAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70702' then 'SAN JUAN DE BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70708' then 'SAN MARCOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70713' then 'SAN ONOFRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70717' then 'SAN PEDRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70742' then 'SAN LUIS DE SINCE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70771' then 'SUCRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70820' then 'SANTIAGO DE TOLU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='70823' then 'SAN JOSE DE TOLUVIEJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73001' then 'IBAGUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73024' then 'ALPUJARRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73026' then 'ALVARADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73030' then 'AMBALEMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73043' then 'ANZOATEGUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73055' then 'ARMERO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73067' then 'ATACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73124' then 'CAJAMARCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73148' then 'CARMEN DE APICALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73152' then 'CASABIANCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73168' then 'CHAPARRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73200' then 'COELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73217' then 'COYAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73226' then 'CUNDAY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73236' then 'DOLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73268' then 'ESPINAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73270' then 'FALAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73275' then 'FLANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73283' then 'FRESNO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73319' then 'GUAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73347' then 'HERVEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73349' then 'HONDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73352' then 'ICONONZO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73408' then 'LERIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73411' then 'LIBANO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73443' then 'SAN SEBASTIAN DE MARIQUITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73449' then 'MELGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73461' then 'MURILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73483' then 'NATAGAIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73504' then 'ORTEGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73520' then 'PALOCABILDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73547' then 'PIEDRAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73555' then 'PLANADAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73563' then 'PRADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73585' then 'PURIFICACION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73616' then 'RIOBLANCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73622' then 'RONCESVALLES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73624' then 'ROVIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73671' then 'SALDAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73675' then 'SAN ANTONIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73678' then 'SAN LUIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73686' then 'SANTA ISABEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73770' then 'SUAREZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73854' then 'VALLE DE SAN JUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73861' then 'VENADILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73870' then 'VILLAHERMOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='73873' then 'VILLARRICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76001' then 'SANTIAGO DE CALI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76020' then 'ALCALA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76036' then 'ANDALUCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76041' then 'ANSERMANUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76054' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76100' then 'BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76109' then 'BUENAVENTURA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76111' then 'GUADALAJARA DE BUGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76113' then 'BUGALAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76122' then 'CAICEDONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76126' then 'CALIMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76130' then 'CANDELARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76147' then 'CARTAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76233' then 'DAGUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76243' then 'EL AGUILA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76246' then 'EL CAIRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76248' then 'EL CERRITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76250' then 'EL DOVIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76275' then 'FLORIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76306' then 'GINEBRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76318' then 'GUACARI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76364' then 'JAMUNDI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76377' then 'LA CUMBRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76403' then 'LA VICTORIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76497' then 'OBANDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76520' then 'PALMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76563' then 'PRADERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76606' then 'RESTREPO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76616' then 'RIOFRIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76622' then 'ROLDANILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76670' then 'SAN PEDRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76736' then 'SEVILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76823' then 'TORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76828' then 'TRUJILLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76834' then 'TULUA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76845' then 'ULLOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76863' then 'VERSALLES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76869' then 'VIJES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76890' then 'YOTOCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76892' then 'YUMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='76895' then 'ZARZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81001' then 'ARAUCA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81065' then 'ARAUQUITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81220' then 'CRAVO NORTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81300' then 'FORTUL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81591' then 'PUERTO RONDON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81736' then 'SARAVENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='81794' then 'TAME'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85001' then 'YOPAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85010' then 'AGUAZUL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85015' then 'CHAMEZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85125' then 'HATO COROZAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85136' then 'LA SALINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85139' then 'MANI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85162' then 'MONTERREY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85225' then 'NUNCHIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85230' then 'OROCUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85250' then 'PAZ DE ARIPORO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85263' then 'PORE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85279' then 'RECETOR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85300' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85315' then 'SACAMA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85325' then 'SAN LUIS DE PALENQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85400' then 'TAMARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85410' then 'TAURAMENA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85430' then 'TRINIDAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='85440' then 'VILLANUEVA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86001' then 'MOCOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86219' then 'COLON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86320' then 'ORITO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86568' then 'PUERTO ASIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86569' then 'PUERTO CAICEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86571' then 'PUERTO GUZMAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86573' then 'PUERTO LEGUIZAMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86749' then 'SIBUNDOY'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86755' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86757' then 'SAN MIGUEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86760' then 'SANTIAGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86865' then 'VALLE DEL GUAMUEZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='86885' then 'VILLAGARZON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='88001' then 'SAN ANDRES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='88564' then 'PROVIDENCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91001' then 'LETICIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91263' then 'EL ENCANTO (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91405' then 'LA CHORRERA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91407' then 'LA PEDRERA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91430' then 'LA VICTORIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91460' then 'MIRITI - PARANA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91530' then 'PUERTO ALEGRIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91536' then 'PUERTO ARICA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91540' then 'PUERTO NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91669' then 'PUERTO SANTANDER (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='91798' then 'TARAPACA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94001' then 'INIRIDA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94343' then 'BARRANCOMINAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94883' then 'SAN FELIPE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94884' then 'PUERTO COLOMBIA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94885' then 'LA GUADALUPE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94886' then 'CACAHUAL (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94887' then 'PANA PANA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='94888' then 'MORICHAL (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95001' then 'SAN JOSE DEL GUAVIARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95015' then 'CALAMAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95025' then 'EL RETORNO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='95200' then 'MIRAFLORES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97001' then 'MITU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97161' then 'CARURU'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97511' then 'PACOA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97666' then 'TARAIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97777' then 'PAPUNAHUA (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='97889' then 'YAVARATE (ANM)'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99001' then 'PUERTO CARREÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99524' then 'LA PRIMAVERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99624' then 'SANTA ROSALIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='99773' then 'CUMARIBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05001' then 'MEDELLIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05002' then 'ABEJORRAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05004' then 'ABRIAQUI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05021' then 'ALEJANDRIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05030' then 'AMAGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05031' then 'AMALFI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05034' then 'ANDES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05036' then 'ANGELOPOLIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05038' then 'ANGOSTURA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05040' then 'ANORI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05042' then 'SANTA FE DE ANTIOQUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05044' then 'ANZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05045' then 'APARTADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05051' then 'ARBOLETES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05055' then 'ARGELIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05059' then 'ARMENIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05079' then 'BARBOSA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05086' then 'BELMIRA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05088' then 'BELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05091' then 'BETANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05093' then 'BETULIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05101' then 'CIUDAD BOLIVAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05107' then 'BRICEÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05113' then 'BURITICA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05120' then 'CACERES'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05125' then 'CAICEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05129' then 'CALDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05134' then 'CAMPAMENTO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05138' then 'CAÑASGORDAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05142' then 'CARACOLI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05145' then 'CARAMANTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05147' then 'CAREPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05148' then 'EL CARMEN DE VIBORAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05150' then 'CAROLINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05154' then 'CAUCASIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05172' then 'CHIGORODO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05190' then 'CISNEROS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05197' then 'COCORNA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05206' then 'CONCEPCION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05209' then 'CONCORDIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05212' then 'COPACABANA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05234' then 'DABEIBA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05237' then 'DONMATIAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05240' then 'EBEJICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05250' then 'EL BAGRE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05264' then 'ENTRERRIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05266' then 'ENVIGADO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05282' then 'FREDONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05284' then 'FRONTINO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05306' then 'GIRALDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05308' then 'GIRARDOTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05310' then 'GOMEZ PLATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05313' then 'GRANADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05315' then 'GUADALUPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05318' then 'GUARNE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05321' then 'GUATAPE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05347' then 'HELICONIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05353' then 'HISPANIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05360' then 'ITAGÜI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05361' then 'ITUANGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05364' then 'JARDIN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05368' then 'JERICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05376' then 'LA CEJA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05380' then 'LA ESTRELLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05390' then 'LA PINTADA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05400' then 'LA UNION'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05411' then 'LIBORINA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05425' then 'MACEO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05440' then 'MARINILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05467' then 'MONTEBELLO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05475' then 'MURINDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05480' then 'MUTATA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05483' then 'NARIÑO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05490' then 'NECOCLI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05495' then 'NECHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05501' then 'OLAYA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05541' then 'PEÑOL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05543' then 'PEQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05576' then 'PUEBLORRICO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05579' then 'PUERTO BERRIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05585' then 'PUERTO NARE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05591' then 'PUERTO TRIUNFO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05604' then 'REMEDIOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05607' then 'RETIRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05615' then 'RIONEGRO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05628' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05631' then 'SABANETA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05642' then 'SALGAR'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05647' then 'SAN ANDRES DE CUERQUIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05649' then 'SAN CARLOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05652' then 'SAN FRANCISCO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05656' then 'SAN JERONIMO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05658' then 'SAN JOSE DE LA MONTAÑA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05659' then 'SAN JUAN DE URABA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05660' then 'SAN LUIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05664' then 'SAN PEDRO DE LOS MILAGROS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05665' then 'SAN PEDRO DE URABA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05667' then 'SAN RAFAEL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05670' then 'SAN ROQUE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05674' then 'SAN VICENTE FERRER'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05679' then 'SANTA BARBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05686' then 'SANTA ROSA DE OSOS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05690' then 'SANTO DOMINGO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05697' then 'EL SANTUARIO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05736' then 'SEGOVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05756' then 'SONSON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05761' then 'SOPETRAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05789' then 'TAMESIS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05790' then 'TARAZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05792' then 'TARSO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05809' then 'TITIRIBI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05819' then 'TOLEDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05837' then 'TURBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05842' then 'URAMITA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05847' then 'URRAO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05854' then 'VALDIVIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05856' then 'VALPARAISO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05858' then 'VEGACHI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05861' then 'VENECIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05873' then 'VIGIA DEL FUERTE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05885' then 'YALI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05887' then 'YARUMAL'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05890' then 'YOLOMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05893' then 'YONDO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='05895' then 'ZARAGOZA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08001' then 'BARRANQUILLA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08078' then 'BARANOA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08137' then 'CAMPO DE LA CRUZ'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08141' then 'CANDELARIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08296' then 'GALAPA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08372' then 'JUAN DE ACOSTA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08421' then 'LURUACO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08433' then 'MALAMBO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08436' then 'MANATI'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08520' then 'PALMAR DE VARELA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08549' then 'PIOJO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08558' then 'POLONUEVO'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08560' then 'PONEDERA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08573' then 'PUERTO COLOMBIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08606' then 'REPELON'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08634' then 'SABANAGRANDE'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08638' then 'SABANALARGA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08675' then 'SANTA LUCIA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08685' then 'SANTO TOMAS'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08758' then 'SOLEDAD'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08770' then 'SUAN'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08832' then 'TUBARA'
                    WHEN CONCAT(pd.departamento, pd.municipio)='08849' then 'USIACURI'
                    ELSE CONCAT(pd.departamento, pd.municipio)

                end as municipio, 
                UPPER(pd.vereda), UPPER(pd.uit), UPPER(pd.nombre_reconocedor), TO_CHAR(pd.fecha_visita_predial,'DD/MM/YYYY') as fecha_levantamiento,
                CONCAT(pd.departamento,pd.municipio) as divipola
                
            FROM 
                {esquema}.cca_predio pd
            JOIN 
                {esquema}.cca_condicionprediotipo cpt 
                ON pd.condicion_predio = cpt.t_id
            JOIN 
                {esquema}.cca_terreno te 
                ON pd.terreno = te.t_id
            JOIN {esquema}.cca_derecho der ON pd.t_id=der.predio
            JOIN {esquema}.cca_derechotipo drtp on der.tipo=drtp.t_id
            JOIN {esquema}.cca_metodointervenciontipo interv on pd.metodointervencion=interv.t_id

        """
        cursor.execute(query_unificado)
        records_unificado = cursor.fetchall()

        records_with_geometry_unificado = [record for record in records_unificado if record[3] is not None]

        if records_with_geometry_unificado:
            schema_unificado = {
                'geometry': 'Unknown',  
                'properties': {
                    'QR': 'int64',
                    'QR_CONTENEDOR': 'int64',
                    'DTO':'str',
                    'MUNI':'str',
                    'VEREDA_IGAC':'str',
                    'UIT':'str',
                    'R_TEC_LEV':'str',
                    'MET_LEV':'str',
                    'AREA_M2': 'float',
                    'TIPO_DERECHO':'str:11',
                    'FORMAL_INFORMAL': 'str:30',
                    'NATURALEZA': 'str:15',
                    'F_PROG_LEV': 'str:10',
                    'F_LEV': 'str:10',
                    'F_REPOR': 'str:10',
                    'FECH_CARGUE_TEC': 'str:10',
                    'COD_DANE': 'str:5',
                    'OBS': 'str:100'

                }
            }

            # Crear capa UNIFICADO en el GPKG
            with fiona.open(output_file, 'w', driver='GPKG', crs=CRS.from_epsg(9377).to_wkt(), schema=schema_unificado, layer='UNIFICADO') as layer:
                for record in records_with_geometry_unificado:
                    try:
                        geom = wkb.loads(bytes(record[3]))
                        if isinstance(geom, (Polygon, MultiPolygon)):
                            layer.write({
                                'geometry': mapping(geom),
                                'properties': {
                                    'QR': record[1],
                                    'QR_CONTENEDOR': record[0],
                                    'DTO': record[7],
                                    'MUNI': record[8],
                                    'VEREDA_IGAC': record[9],
                                    'UIT': record[10],
                                    'R_TEC_LEV': record[11],
                                    'MET_LEV': record[6],
                                    'AREA_M2': float(record[4]),
                                    'TIPO_DERECHO': record[5][:11] if record[5] else None,
                                    'FORMAL_INFORMAL': record[2][:30] if record[2] else None, 
                                    'NATURALEZA': None,
                                    'F_PROG_LEV': None,
                                    'F_LEV':  record[12][:10] if record[12] else None,
                                    'F_REPOR': None,
                                    'FECH_CARGUE_TEC': None,
                                    'COD_DANE': record[13][:5] if record[13] else None,
                                    'OBS': None
                                }
                            })
                    except Exception as e:
                        print(f"Error al analizar registro {record}: {e}")
                        continue
        else:
            print("No se generó la capa UNIFICADO porque no hay geometría válida.")
    else:
        print("No se generará la capa UNIFICADO porque FORMAL o INFORMAL no tienen geometría.")

    cursor.close()
    conexion.close()

    # Mensaje indicando que la exportación fue exitosa
    msg_box = QMessageBox()
    msg_box.setIcon(QMessageBox.Information)
    msg_box.setWindowTitle("Exportación completada")
    msg_box.setText(f"Datos exportados correctamente a {output_file}.\n¿Desea agregar las capas a QGIS?")
    msg_box.setStandardButtons(QMessageBox.Yes | QMessageBox.No)
    result = msg_box.exec_()

    if result == QMessageBox.Yes:
        agregar_gpkg_a_qgis(output_file)
    else:
        pass

def agregar_gpkg_a_qgis(gpkg_path):
    layers = fiona.listlayers(gpkg_path)
    
    for layer_name in layers:
        uri = f"{gpkg_path}|layername={layer_name}"
        vlayer = QgsVectorLayer(uri, layer_name, "ogr")
        
        if not vlayer.isValid():
            print(f"Error al cargar la capa {layer_name} desde {gpkg_path}")
            continue

        if vlayer.featureCount() == 0:
            print(f"La capa {layer_name} no contiene geometría o registros, no se añadirá a QGIS.")
            continue

        # Crear el símbolo de relleno con las propiedades especificadas
        fill_symbol = QgsFillSymbol.createSimple({
            'color': '#72b572',  # Color de relleno
            'outline_color': '#838682',  # Color del borde
            'outline_width': '0.26',  # Ancho del borde en milímetros
        })

        fill_symbol.setOpacity(0.5)

        for layer in fill_symbol.symbolLayers():
            if isinstance(layer, QgsLineSymbolLayer):
                layer.setOpacity(0.5)
                layer.setColor(QColor('#838682'))
                layer.setWidth(0.26)

        vlayer.renderer().setSymbol(fill_symbol)
        QgsProject.instance().addMapLayer(vlayer)
        print(f"Capa {layer_name} agregada con estilo desde {gpkg_path}")
