# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FragScape
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5.QtGui import QIcon
from qgis.core import QgsApplication, QgsProcessingProvider

from .FragScape_algs import (RasterizeFixAllTouch,
                             ResultsDiffAlgorithm,
                             PrepareLanduseAlgorithm,
                             PrepareFragmentationAlgorithm,
                             ApplyFragmentationAlgorithm,
                             MeffVectorGlobal,
                             MeffVectorReport)
from .FragScape_raster_algs import MeffRaster, MeffRasterReport, MeffRasterCBC

class FragScapeAlgorithmsProvider(QgsProcessingProvider):

    def __init__(self):
        self.alglist = [RasterizeFixAllTouch(),
                        ResultsDiffAlgorithm(),
                        PrepareLanduseAlgorithm(),
                        PrepareFragmentationAlgorithm(),
                        ApplyFragmentationAlgorithm(),
                        MeffVectorGlobal(),
                        MeffVectorReport(),
                        MeffRaster(),
                        MeffRasterReport(),
                        MeffRasterCBC()]
        for a in self.alglist:
            a.initAlgorithm()
        super().__init__()
        
    def unload(self):
        pass
        
    def id(self):
        return "FragScape"
        
    def name(self):
        return "FragScape"
        
    def longName(self):
        return self.name()
        
    def icon(self):
        icon_path = os.path.join(os.path.dirname(__file__), "..", "icons", "vector_grid.png")
        #icon_path = ':/plugins/FragScape/icons/vector_grid.svg'
        # print("icon_path = " + str(icon_path))
        return QIcon(icon_path)
        
    def loadAlgorithms(self):
        for a in self.alglist:
            self.addAlgorithm(a)