import os.path
import sys 
#from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QFileInfo, QFile
#from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QTableWidgetItem, QAction, QFileDialog, QApplication, QTableWidget, QMessageBox
from qgis.core import QgsProject, QgsVectorFileWriter,QgsCoordinateReferenceSystem, QgsVectorLayer

from datetime import datetime
# from .FormatConsistency_dialog import FormatConsistencyDialog
# from .FormatConsistency import FormatConsistency
import random

# classe_camadas():
class LayerInfo: 
    ano_atual = int(datetime.strftime(datetime.now(), '%Y'))
    def __init__(self, layer):
        self.name = str(layer.name())
        self.crs = str(layer.crs().description())
        self.isValid = layer.isValid()
        if layer.type()==0:
            self.encoding = str(layer.dataProvider().encoding())
            self.count = layer.featureCount()
            self.formato = str(layer.storageType())
        if layer.type()==1:
            self.encoding = 'NA'
            self.count = 0
            try:
                self.formato = str(layer.storageType())
            except AttributeError:
                self.formato = 'Raster'


    def adicionaName(self, object):
        self.name.append(self.object)
    def adicionaCRS(self, object):
        self.crs.append(self.object)
    def adicionaCount(self, object):
        self.count.append(self.object)
    def adicionaFormato(self, object):
        self.formato.append(self.object)
    def adicionaIs_Valid(self, object):
        self.is_Valid.append(self.object)

def cria_lista(lista_layers_txt):
    path_project = path_work()
    lista = list(range(len(lista_layers_txt)))
    for id, i in enumerate(lista_layers_txt):
        camada = QgsVectorLayer(path_project + i  + ".shp",  i, "ogr")
        lista[id] = camada
    return lista

# Iterate over all loaded layers
def list_layers(lista_layers):
    layer_list = [] #vazia
    layer_count = 0
    
    # Create layer list
    layers = QgsProject.instance().mapLayers().values()
    if len(layers)==0:
        try:
            layers = cria_lista(lista_layers)
        except:
            pass
    if len(layers)>0:
        for layer in layers:
            layer_count += 1
            layer_list.append(LayerInfo(layer))
    return layer_list 


def mostrar_tabela(self, layers):
    camadas_info = list_layers(layers)
    # Generate data table
    self.dlg1.tableWidget.clear()
    self.dlg1.tableWidget.setRowCount(len(layers))
    self.dlg1.tableWidget.setColumnCount(6)
    self.dlg1.tableWidget.setColumnWidth(0, 200)
    self.dlg1.tableWidget.horizontalHeader().setStretchLastSection(True)

    self.dlg1.tableWidget.setHorizontalHeaderItem(0, QTableWidgetItem("Layer"))
    self.dlg1.tableWidget.setHorizontalHeaderItem(1, QTableWidgetItem("SRC"))
    self.dlg1.tableWidget.setHorizontalHeaderItem(2, QTableWidgetItem("Encoding"))
    self.dlg1.tableWidget.setHorizontalHeaderItem(3, QTableWidgetItem("Count"))
    self.dlg1.tableWidget.setHorizontalHeaderItem(4, QTableWidgetItem("Format"))
    self.dlg1.tableWidget.setHorizontalHeaderItem(5, QTableWidgetItem("isValid"))

    #for layer in camadas_info:
    for id, layer in enumerate(camadas_info):            
        self.dlg1.tableWidget.setItem(id, 0, QTableWidgetItem(str(layer.name)))
        self.dlg1.tableWidget.setItem(id, 1, QTableWidgetItem(str(layer.crs)))
        self.dlg1.tableWidget.setItem(id, 2, QTableWidgetItem(str(layer.encoding)))
        self.dlg1.tableWidget.setItem(id, 3, QTableWidgetItem(str(layer.count)))
        self.dlg1.tableWidget.setItem(id, 4, QTableWidgetItem(str(layer.formato)))
        self.dlg1.tableWidget.setItem(id, 5, QTableWidgetItem(str(layer.isValid)))

    self.dlg1.tableWidget.move(0, 0)

def path_work():
    diretorio = 'D:/Dados/'
    base_de_dados = 'bc100_go_df_shp/'
    path_project = diretorio + base_de_dados 
    return path_project

#def select_output(self):
#    output_dir = QFileDialog.getExistingDirectory(self.dlg1, "Select folder", "")
#    self.dlg1.lineEdit.setText(output_dir)

def mensagem():
    layers = QgsProject.instance().mapLayers().values()
    info_camadas = list_layers(layers)
    N = len(info_camadas)
    randomNum = random.sample(range(N),1)[0]
    QMessageBox.warning(None, "Format Consistency", "Mostrar cama das com registros:" +
        "\nNome da camada: "+ str(info_camadas[randomNum].name) +
        "\nNúmero de feições: " + str(info_camadas[randomNum].count))

def export_csv():
    layers = QgsProject.instance().mapLayers().values()
    info_camadas = list_layers(layers)
    N = len(info_camadas)
    #randomNum = random.sample(range(N),1)[0]
    #QMessageBox.warning(None, "Format Consistency", "Exportar para CSV")
    #def save_to_file():
    dialog = QFileDialog()
    name = dialog.getSaveFileName(None, "Export result to CSV", "", "CSV file (*.csv)")
    if name[0] == "":
        return None
        
    save_file = open(name[0], 'w')
    save_file.write("%s, %s, %s, %s, %s, %s\n" % ("name", "crs", "count", "isValid", "encoding", "formato"))    
    for i in info_camadas:
        save_file.write("%s, %s, %i, %s, %s, %s\n" % (i.name, i.crs, i.count, i.isValid, i.encoding, i.formato))
        
    save_file.close()

def mostra_camadas():
    #QMessageBox.warning(None, "Format Consistency", "Cancelar")
    layers = QgsProject.instance().mapLayers().values()
    #info_camadas = list_layers(layers)
    #show_layer = "yes"
    for i in layers:
        try:
            if i.featureCount() > 0:
                QgsProject.instance().layerTreeRoot().findLayer(i).setItemVisibilityChecked(True)
                #turn = "on"

            if i.featureCount() < 0:
                QgsProject.instance().layerTreeRoot().findLayer(i).setItemVisibilityChecked(False)
                #turn = "off"
        except:
            QgsProject.instance().layerTreeRoot().findLayer(i).setItemVisibilityChecked(False)
            #turn = "off"
        
        #if turn == "off":
        #    #QgsProject.instance().layerTreeRoot().findLayer(i).setItemVisibilityChecked(False)
        #    turn = "on"
        
        #if turn == "on":
        #    #QgsProject.instance().layerTreeRoot().findLayer(i).setItemVisibilityChecked(False)
        #    turn = turn_on_off(turn)

def turn_on_off(turn):
    liga = "on"
    if turn == "on":
        liga = "on"
    if turn == "off":
        liga == "off"
    return liga


           




