# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ForestRoads
                                 A QGIS plugin
 Create a network of forest roads based on zones to access, roads to connect
 them to, and a cost matrix.
 The code of the plugin is based on the "LeastCostPath" plugin available on
 https://github.com/Gooong/LeastCostPath. We thank their team for the template.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 10-07-2019
        copyright            : (C) 2019 by Clement Hardy
        email                : clem.hardy@outlook.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script allows QGIS to load or unload the plugin when needed.
"""

__author__ = 'clem.hardy@outlook.fr'
__date__ = 'Currently in work'
__copyright__ = '(C) 2019 by Clement Hardy'

import os
import sys
import inspect

# We import the functions from QGIS necessary to feed him
# the functioning of the plugin.
from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .forestRoadNetwork_provider import forestRoadNetworkProvider

# These commands seem to get the path where the plugin is executed
# from, and add it to the list of path called sys.path where python
# will look for modules to load. Allows the loading of other modules.
# inspect.getfile(inspect.currentframe()) gets the path of the file being
# executed.
# os.path.split allows to split the path between a head (path to folder)
# and a tail (the file name). By using the item 0, we take only the head
# (Path to folder)
cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)

# Class that is fed to QGIS via the classFactory function in
# the __init__.py file. Has two functions that QGIS can call :
# one to initialize Gui, and one to unload. One adds a provider,
# the other removes it.
class forestRoadNetworkPlugin(object):

    def __init__(self):
        self.provider = forestRoadNetworkProvider()

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
