# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ForestRoads
                                 A QGIS plugin
 Create a network of forest roads based on zones to access, roads to connect
 them to, and a cost matrix.
 The code of the plugin is based on the "LeastCostPath" plugin available on
 https://github.com/Gooong/LeastCostPath. We thank their team for the template.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 10-07-2019
        copyright            : (C) 2019 by Clement Hardy
        email                : clem.hardy@outlook.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script descries the provider that QGIS uses to load or unload the
 plugin. The provider is a class that have methods to expose the algorithms,
 but also informations about the plugin.
"""

__author__ = 'clem.hardy@outlook.fr'
__date__ = 'Currently in work'
__copyright__ = '(C) 2019 by Clement Hardy'

# We import the necessary functions from QGIS
# to create the provider, and our algorithm.
from qgis.core import QgsProcessingProvider
from .forestRoadNetwork_algorithm import ForestRoadNetworkAlgorithm
from .woodFluxInNetwork_algorithm import woodFluxAlgorithm
from .RoadTypeDetermination_algorithm import roadTypeAlgorithm
from .CostRasterCreator_algorithm import CostRasterAlgorithm


class forestRoadNetworkProvider(QgsProcessingProvider):

    def __init__(self):
        # we initialize the fact that this class
        # heritates from the provider class of the QGIS
        # package
        QgsProcessingProvider.__init__(self)

        # We load the algorithms that the plugin is
        # going to use while creating the provider.
        # We initialize it at the same time.
        self.alglist = [ForestRoadNetworkAlgorithm(), woodFluxAlgorithm(), roadTypeAlgorithm(), CostRasterAlgorithm()]

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        # We use the function "addAlgorithm" from the Qgis
        # provider class to add them to our class properly,
        # in the way that QGIS wants it.
        for alg in self.alglist:
            self.addAlgorithm( alg )

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'FRNC'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Forest Road Network Plugin')

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
