from qgis.core import QgsProcessingAlgorithm
from qgis.PyQt.QtCore import QCoreApplication


class BoreholeAlgorithm(QgsProcessingAlgorithm):
    @classmethod
    def tr(cls, string):
        return QCoreApplication.translate("Processing", string)

    def createInstance(self):
        return self.__class__()

    def name(self):
        return self.__class__.__name__.lower()

    def shortHelpString(self):
        return self.tr(self.__doc__)

    @classmethod
    def group(cls):
        return "Boreholes"

    @classmethod
    def groupId(cls):
        return "boreholes"


from .markers import WellLogsToMarkers
