from qgis.core import Qgis
from qgis.utils import iface

from ...utils import QgisVectorDataFilter


def converter(old_version, new_version, filters):
    if old_version is None and new_version >= "0.5.8":
        new_filters = converter_to_0_5_8(filters)
    iface.messageBar().pushMessage(
        "Warning",
        f"Updated some layers from version {old_version} to {new_version}.\nYou won't be able to open it again with a previous version.",
        level=Qgis.Info,
    )
    return new_filters


def converter_to_0_5_8(old_filters):
    new_filters = []
    for filter in old_filters:
        data_selection = []
        for data_filter in filter.inputs:
            expression = data_filter.filter
            start = expression.find('"') + 1
            end = expression.find('"', start)
            value = expression[start:end]
            data_selection.append(
                QgisVectorDataFilter(
                    data_filter.layer.id, value, expression, data_filter.dip_fields
                )
            )
        new_filters.append(data_selection)
    return new_filters
