from forgeo.core import ItemData
from qgis import processing
from qgis.core import QgsMapLayerProxyModel, QgsProject, QgsRasterLayer
from qgis.gui import QgsMapLayerComboBox
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QHBoxLayout, QLabel, QWidget

from ..utils import input_data_type


class RasterWidget(QWidget):
    def __init__(self, item, parent=None):
        super().__init__(parent)
        self.item = item

        # Layer selection
        lbl_raster = QLabel(
            "Select layer :", alignment=Qt.AlignmentFlag.AlignCenter, height=15
        )
        self.raster_cbox = QgsMapLayerComboBox()
        self.raster_cbox.setFilters(QgsMapLayerProxyModel.RasterLayer)
        self.raster_cbox.setAllowEmptyLayer(True, self.tr("No raster selected"))

        # Reload data
        if item is not None and input_data_type(item) == "rasterData":
            layer = QgsProject.instance().mapLayer(self.item.inputs[0].layerid)
            assert isinstance(layer, QgsRasterLayer)
            self.raster_cbox.setLayer(layer)

        # Layout
        layout = QHBoxLayout()
        layout.addWidget(lbl_raster, stretch=1)
        layout.addWidget(self.raster_cbox, stretch=4)
        self.setLayout(layout)

    def clear(self):
        self.raster_cbox.setLayer(None)

    def process_selection(self, _):
        raster = self.raster_cbox.currentLayer()
        if raster is None:
            return (None, None)
        # FIXME Will not work, we need to figure out how to store raster data
        # in an ItemData
        return ItemData(), raster.id()


def _copy_raster_layer(layer, new_layer_name):  # FIXME To be removed?
    # FIXME Open question: is it still mandatory? After cancelling "force gpkg" approach
    # Answer: No, we now use ItemData. To be updated...
    # Doc: https://docs.qgis.org/3.34/en/docs/user_manual/processing_algs/gdal/rasterconversion.html#translate-convert-format
    params = {
        "DATA_TYPE": 6,  # Float32
        "INPUT": layer.source(),
        "OUTPUT": "TEMPORARY_OUTPUT",
        "TARGET_CRS": layer.crs(),
    }
    layer = processing.run("gdal:translate", params)["OUTPUT"]
    layer = QgsRasterLayer(layer)
    layer.setName(new_layer_name)
    return layer
