from qgis.core import QgsProcessingAlgorithm
from qgis.PyQt.QtCore import QCoreApplication


class SamplingAlgorithm(QgsProcessingAlgorithm):
    @classmethod
    def tr(cls, string):
        return QCoreApplication.translate("Processing", string)

    def createInstance(self):
        return self.__class__()

    def name(self):
        return self.__class__.__name__.lower()

    def shortHelpString(self):
        return self.tr(self.__doc__)

    @classmethod
    def group(cls):
        return "Sampling"

    @classmethod
    def groupId(cls):
        return "sampling"


from .sample_geomodel import SampleGeoModel
