from qgis.core import QgsProcessingAlgorithm
from qgis.PyQt.QtCore import QCoreApplication


class UtilsAlgorithm(QgsProcessingAlgorithm):
    @classmethod
    def tr(cls, string):
        return QCoreApplication.translate("Processing", string)

    def createInstance(self):
        return self.__class__()

    def name(self):
        return self.__class__.__name__.lower()

    def shortHelpString(self):
        return self.tr(self.__doc__)

    @classmethod
    def group(cls):
        return "Utils"

    @classmethod
    def groupId(cls):
        return "utils"


from .create_grid_3d import CreateGrid3d
from .spreadsheet import PandasReadSpreadsheet
