"""QGIS toolbox generation.

One has to implement QgsProcessingAlgorithm and MUST register them into the ALGORITHMS variable.
Such algorithms could be inserted/grouped into sub-groups using group/groupId attributes (defaults to root).


WARNING: Qgis register provider by name,
    if duplicated names exists only the last register loaded will be accessible.
"""

from functools import cached_property

from qgis.core import QgsProcessingProvider

from ..settings import PluginSettings
from ..utils import qicon
from .boreholes import WellLogsToMarkers
from .interfaces2pvgis import InterfacesToPvgis
from .misc import CreateGrid3d, PandasReadSpreadsheet
from .sampling import SampleGeoModel
from .slicerraster import GmRasterSlicer
from .slicervertical import GmVerticalSlicer
from .zslicer import ZSlicer

# TODO: import here the defined processing algorithms
#   & add them to the variable ALGORITHMS so they will be loaded
# from .awesomealgo import AnAwesomeAlgorithm, AnotherOne

ALGORITHMS = [
    GmRasterSlicer,
    GmVerticalSlicer,
    InterfacesToPvgis,
    ZSlicer,
    CreateGrid3d,
    SampleGeoModel,
    WellLogsToMarkers,
    CreateGrid3d,
    SampleGeoModel,
    PandasReadSpreadsheet,
]


class PluginToolbox(QgsProcessingProvider):
    @cached_property
    def settings(self):
        return PluginSettings()

    def loadAlgorithms(self, *args, **kwargs):  # noqa: ARG002
        # add algorithms here
        for Algorithm in ALGORITHMS:
            self.addAlgorithm(Algorithm())

    def id(self, *args, **kwargs):  # noqa: ARG002
        """The ID of your plugin, used for identifying the provider.

        This string should be a unique, short, character only string,
        eg "qgis" or "gdal". This string should not be localised.
        """
        return self.settings.get("name").lower().replace(" ", "-").replace("-", "_")

    def name(self, *args, **kwargs):  # noqa: ARG002
        """The human friendly name of your plugin in Processing.

        This string should be as short as possible (e.g. "Lastools", not
        "Lastools version 1.0.1 64-bit") and localised.
        """
        return self.tr(self.settings.get("name"))

    def icon(self):
        """Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return qicon()
