# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Flyfotos
                                 A QGIS plugin
 Flyfotos
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-10-05
        git sha              : $Format:%H$
        copyright            : (C) 2020 by JO Informatik
        email                : support@jo-informatik.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from .flyfotosSettings import MyPluginOptionsFactory
from .flyfotos_dialog import FlyfotosDialog
from .resources import *
from qgis.core import Qgis, QgsSettings
from qgis.PyQt.QtWidgets import QAction, QMenu, QPushButton
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from PyQt5.QtWidgets import (QProgressBar)
from PyQt5.QtCore import QTimer

# Initialize Qt resources from file resources.py
# Import the code for the dialog


class FlyFotosDK:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        # TODO - Comment out and see if we can translate our plugin on different languages!
        try:
            locale = QSettings().value('locale/userLocale')[0:2]
        except:
            locale = "da"
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'FlyFotosDK_{}.qm'.format(locale)
        )

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Add Flyfotos plugin settings under options
        self.settings = FlyfotosDialog()
        self.options_factory = MyPluginOptionsFactory()
        self.options_factory.setTitle(self.tr('FlyFotosDK'))
        self.iface.registerOptionsWidgetFactory(self.options_factory)
        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&FlyFotosDK')
        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.check_credentials_data = True
        self.user_credentials = ""
        self.progressbar_active = False

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('FlyFotosDK', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)
        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)
        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)
        self.actions.append(action)
        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = os.path.join(os.path.dirname(
            __file__), 'images/icon.png')
        self.add_action(
            icon_path,
            text=self.tr(u'FlyFotosDK'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        # Add plugin name on QGIS menubar
        self.menu = QMenu(self.iface.mainWindow().menuBar())
        self.menu.setTitle(self.tr('FlyFotosDK'))

    def show_progressbar(self):
        # Statusbar - progressbar
        self.progress = QProgressBar()
        self.progress.setMinimumSize(100, 22)
        self.progress.setMaximumSize(100, 22)
        self.progress.setRange(0, 100)
        self.progress.setValue(0)
        self.timer = QTimer()
        self.timer.start(100)
        self.timer.timeout.connect(self.handleTimer)
        self.progressMessageBar = self.iface.mainWindow().statusBar()
        self.progressMessageBar.addWidget(self.progress)

    def handleTimer(self):
        value = self.progress.value()
        if value < 95:
            value = value + 5
            self.progress.setValue(value)
        return value

    def clearMenu(self):
        # Remove plugin from menu bar
        if self.menu:
            self.menu.deleteLater()

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&FlyFotosDK'),
                action)
            self.iface.removeToolBarIcon(action)
            if self.options_factory:
                self.iface.unregisterOptionsWidgetFactory(self.options_factory)
                self.options_factory = None
            self.clearMenu()

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = FlyfotosDialog()

        self.check_user_data()

    def check_user_data(self):
        """
            Checks if the user token is empty. Initializes the plugin if token is in place.
        """
        qgis_settings = QgsSettings()
        user_data = qgis_settings.value("flyfotosdk/token", "")
        if len(str(user_data)) > 0:
            if self.check_credentials_data:
                # This is the first time credentials are checked, and they are not empty
                self.check_credentials_data = False
                if not self.progressbar_active:
                    self.progressbar_active = True
                    self.show_progressbar()
                self.dlg.init_table(user_data, True)
                self.iface.mainWindow().statusBar().removeWidget(self.progress)
                self.progressbar_active = False
                self.user_credentials = user_data
                self.dlg.exec()
            else:
                if self.user_credentials != user_data:
                    # Credentials have changed.
                    if not self.progressbar_active:
                        self.progressbar_active = True
                        self.show_progressbar()
                    self.dlg.init_table(user_data, True)
                    self.iface.mainWindow().statusBar().removeWidget(self.progress)
                    self.progressbar_active = False
                    self.user_credentials = user_data
                # Get visible layers from the view extent
                self.dlg.map_move_end()
                self.dlg.exec()
        else:
            self.show_missing_token_message()

    def show_missing_token_message(self):
        widget = self.iface.messageBar().createMessage(
            "FlyFotosDK Missing Credentials - Your Token is Empty. Please enter your token under Settings -> Options -> FlyFotosDK")
        self.iface.messageBar().pushWidget(widget, Qgis.Warning, duration=5)
