# -*- coding: utf-8 -*-

"""
PolygonSkeleton

***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

import os

from qgis.core import ( 
    QgsProcessingModelAlgorithm
)

from ..metadata import AlgorithmMetadata

class PolygonSkeleton(AlgorithmMetadata, QgsProcessingModelAlgorithm):
    """ Compute the skeleton of input polygons,
        ie. the set of inner points,
        at equal distance from the polygon boundary (including holes)
    """

    def __init__(self, *args, **kwargs):

        super().__init__(*args, **kwargs)
        self.METADATA = AlgorithmMetadata.read(__file__, type(self).__name__)
        self.fromFile(os.path.join(os.path.dirname(__file__), type(self).__name__ + '.model3'))
