# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Flutwelle
                                 A QGIS plugin  
 Flutwelle
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2026-02-10
        git sha              : $Format:%H$
        copyright            : (C) 2026 by retep relleum
        email                : retep.relleum@bluewin.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE 
USE OR OTHER DEALINGS IN THE SOFTWARE.
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication,Qt
from qgis.PyQt.QtGui import QIcon,QGuiApplication
from qgis.PyQt.QtWidgets import QAction,QDialogButtonBox


# Initialize Qt resources from file resources.py
from ..resources import *
# Import the code for the dialog
from ..Flutwelle_dialog import FlutwelleDialog
import os.path

from qgis.utils import iface

from qgis.core import *

from .Damm_Zeichnen import DammZeichnen
from .Layer import DammL, FlussL
from .Querschnitt_Zeichnen import Querschnitt
from .Querschnitt3D import Querschnitt3D


class Flutwelle:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Flutwelle_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Flutwelle')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Flutwelle', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Flutwelle/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Flutwelle'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Flutwelle'),
                action)
            self.iface.removeToolBarIcon(action)

    def buttonPressed(self):
        self.tool = DammZeichnen(iface.mapCanvas(), self.dlg)
        iface.mapCanvas().setMapTool(self.tool)
    
    def buttonPressed2(self):
        self.tool2 = Querschnitt(self.dlg)
        self.tool2.run()
        #self.__task2=QgsApplication.taskManager().addTask(self.tool2)
        root = QgsProject.instance().layerTreeRoot()
        gr=root.findGroup(self.dlg.lineEditProjetName.text() ) 
        gr.setExpanded(True)
        
    def fileChanged(self):
        self.dlg.pushButton.setEnabled(True)
        print(self.dlg.mQgsFileWidget.filePath())

    
    def check_button(self):
        h=self.dlg.spBh.value()
        b=self.dlg.spBb.value()
        bu=self.dlg.spBbu.value()
        l=self.dlg.spBl.value()
        v=self.dlg.sBv.value()
        damml=DammL('')
        flussL=FlussL('')
        qb=0
        f=0
        p1=flussL.getPoint(0)
        if self.dlg.rBd.isChecked():
            qb,f=damml.d_b(p1,h,b,l,v)
        if self.dlg.rBr.isChecked():
            qb,f=damml.r_b(p1,h,b,l,v)
        if self.dlg.rBt.isChecked():
            qb,f=damml.t_b(p1,h,b,bu,l,v)
        if self.dlg.rBs.isChecked():
            qb,f=damml.s_b(p1,h,l,v)
        if self.dlg.rBp.isChecked():
            qb,f=damml.p_b(p1,h,b,l,v)
        self.dlg.sBQb.setValue(qb)
        if l>0 and v>0 and qb>0:
            self.dlg.pushButton_2.setEnabled(True)
            self.dlg.pushButton_3.setEnabled(True)
        else:
            self.dlg.pushButton_2.setEnabled(False)
            self.dlg.pushButton_3.setEnabled(False)

    def safeTiffPath(self,path):
        s = QgsSettings()
        s.setValue("flutwelle/tiffPath", path)

    def querschnitt3D(self):
        q3d=Querschnitt3D(self.dlg.lx.value(),self.dlg.la.value(),self.dlg.q_bruecke.value(),self.dlg.mQgsFileWidget.filePath())

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        s = QgsSettings()
        fp=s.value("flutwelle/tiffPath", "default text")
        self.dlg = FlutwelleDialog(iface.mainWindow())
        self.dlg.pushButton.clicked.connect(self.buttonPressed)
        self.dlg.pushButton_2.clicked.connect(self.buttonPressed2)
        self.dlg.rBd.clicked.connect(self.check_button) 
        self.dlg.rBr.clicked.connect(self.check_button) 
        self.dlg.rBs.clicked.connect(self.check_button) 
        self.dlg.rBt.clicked.connect(self.check_button) 
        self.dlg.rBp.clicked.connect(self.check_button) 
        self.dlg.pushButton_3.clicked.connect(self.querschnitt3D) 
        self.dlg.spBh.valueChanged.connect(self.check_button) 
        self.dlg.spBb.valueChanged.connect(self.check_button) 
        self.dlg.spBbu.valueChanged.connect(self.check_button) 
        self.dlg.spBl.valueChanged.connect(self.check_button) 
        self.dlg.sBv.valueChanged.connect(self.check_button) 
        self.dlg.mQgsFileWidget.fileChanged.connect(self.fileChanged)
        self.dlg.pushButton.setEnabled(False)
        self.dlg.pushButton_2.setEnabled(False)
        self.dlg.mQgsFileWidget.setFilePath(fp)
        self.dlg.mQgsFileWidget.fileChanged.connect(self.safeTiffPath) 
        self.dlg.tabWidget.setCurrentIndex(0)
        relief = QgsProject.instance().mapLayersByName("Relief")
        if not relief :
            urlWithParams = 'url=https://wms.geo.admin.ch/&SmoothPixmapTransform=1&contextualWMSLegend=0&crs=EPSG:2056&dpiMode=7&featureCount=10&format=image/jpeg&layers=ch.swisstopo.swissalti3d-reliefschattierung&styles&tilePixelRatio=0&url=https://wms.geo.admin.ch/'
            rlayer = QgsRasterLayer(urlWithParams, 'Relief', 'wms')
            QgsProject.instance().addMapLayer(rlayer)
        landeskarte = QgsProject.instance().mapLayersByName("Landeskarte")
        if not landeskarte :
            urlWithParams = 'url=https://wms.geo.admin.ch/&SmoothPixmapTransform=1&contextualWMSLegend=0&crs=EPSG:2056&dpiMode=7&featureCount=10&format=image/jpeg&layers=ch.swisstopo.pixelkarte-grau&styles&tilePixelRatio=0&url=https://wms.geo.admin.ch/'
            rlayer = QgsRasterLayer(urlWithParams, 'Landeskarte', 'wms')
            QgsProject.instance().addMapLayer(rlayer)


        # show the dialog
        self.dlg.show()
        self.tool=False

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            pass
        else:
            QGuiApplication.setOverrideCursor(Qt.ArrowCursor)
            if self.tool:
                self.tool.cancel()


