from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
import qgis.utils
from Ui_FlowPathDown_BB import Ui_FlowPathDown_BB

import os, sys, time,  math
from osgeo import gdal, ogr
from osgeo.gdalconst import *

import numpy as np
import fnmatch



class FlowPathDown_BBDialog(QDialog, Ui_FlowPathDown_BB):

    def __init__(self, iface):
        QDialog.__init__(self)
        self.iface = iface
        self.setupUi(self)
        self.NOVALUE=-340282346638528859811704183484516925440.000000
        self.connect(self.btnOutput, SIGNAL("clicked()"), self.outFile)
        self.connect(self.buttonBox, SIGNAL("accepted()"),self.accept)
        QObject.connect(self.buttonBox, SIGNAL("rejected()"),self, SLOT("reject()"))
	QObject.connect(self.buttonBox, SIGNAL("helpRequested()"),self.call_help)

        mapCanvas = self.iface.mapCanvas()
        # init dictionaries of items:
        self.rastItems = {}
        for i in range(mapCanvas.layerCount()):
            layer = mapCanvas.layer(i)
            if ( layer.type() == layer.RasterLayer ):
		# read  layers
                provider = layer.dataProvider()
                self.cmbDEM.addItem(layer.source())
                self.cmbFlowDir.addItem(layer.source())
                self.cmbTRIGGER.addItem(layer.source())
        
        self.textEdit.clear()
        self.cmbFlowDirCoding.addItem("ESRI (1-128)")
        self.cmbFlowDirCoding.addItem("HyGrid2k2 (0-315)")
        self.cmbFlowDirCoding.addItem("TauDEM (1-8)")

    def call_help(self):
	qgis.utils.showPluginHelp()
        
    def outFile(self):
        "Display file dialog for output file"
        self.lineOutput.clear()
        outName = QFileDialog.getSaveFileName(self, "FlowPathDown_BB output file",".", "GeoTiff (*.tif)")
        if QGis.QGIS_VERSION_INT < 10900:		
		if not outName.isEmpty():
			self.lineOutput.clear()
			self.lineOutput.insert(outName)
	else:
		if outName:
			self.lineOutput.clear()
			self.lineOutput.insert(outName)	
        return outName

    def ProcessRaster(self,paramDEM,paramFLOWDIR, paramTRIGGER):
        "Register all of the GDAL drivers"
        gdal.AllRegister()
        # open the image
        paramDEM=str(paramDEM)
        paramFLOWDIR=str(paramFLOWDIR)
        paramTRIGGER=str(paramTRIGGER)

        dsDEM = gdal.Open(paramDEM,GA_ReadOnly)
        if dsDEM is None:
            QMessageBox.information(None,"Exiting gracefully","Could not open raster %s!" % paramDEM)

        dsFLOWDIR = gdal.Open(paramFLOWDIR,GA_ReadOnly)
        if dsFLOWDIR is None:
            QMessageBox.information(None,"Exiting gracefully","Could not open raster %s!" % paramFLOWDIR)

        dsTRIGGER = gdal.Open(paramTRIGGER,GA_ReadOnly)
        if dsTRIGGER is None:
            QMessageBox.information(None,"Exiting gracefully","Could not open raster %s!" % paramTRIGGER)

        # get image size
        rows  = dsDEM.RasterYSize
        cols  = dsDEM.RasterXSize
        bands = dsDEM.RasterCount
        if bands >1:
            QMessageBox.information(None,"Exiting gracefully","Raster %s has %d bands!" % (paramDEM,bands))
            
        # get georeference info
        transform = dsDEM.GetGeoTransform()
        xOrigin = transform[0]
        yOrigin = transform[3]
        pixelWidth = transform[1]
        pixelHeight = transform[5]
        
        transformFD = dsFLOWDIR.GetGeoTransform()
        transformTR = dsTRIGGER.GetGeoTransform()
        # check rasters dimensions and origins
        if (dsFLOWDIR.RasterYSize != rows or dsFLOWDIR.RasterXSize != cols or dsTRIGGER.RasterYSize != rows or dsTRIGGER.RasterXSize != cols):
            QMessageBox.critical(None,"Exiting gracefully","Rasters differs in rows and/or columns number (DEM=%sx%s)!" % (rows, cols))
 
        if (transformFD[0] != xOrigin or transformFD[3] != yOrigin or transformTR[0] != xOrigin or transformTR[3] != yOrigin):
            QMessageBox.critical(None,"Exiting gracefully","Rasters differs in origin corner (DEM=%sx%s)!" % (xOrigin, yOrigin))

        if (transformFD[1] != pixelWidth or transformFD[5] != pixelHeight or transformTR[1] != pixelWidth or transformTR[5] != pixelHeight):
            QMessageBox.critical(None,"Exiting gracefully","Rasters differs in pixel size w and H (DEM=%sx%s)!" % (pixelWidth, pixelHeight))

        # chiedo matrice dati e nodatavalue
        rasDEM = dsDEM.ReadAsArray()
        nodataDEM = dsDEM.GetRasterBand(1).GetNoDataValue()
        
        rasFLOWDIR = dsFLOWDIR.ReadAsArray()
        nodataFLOWDIR = dsFLOWDIR.GetRasterBand(1).GetNoDataValue()
        
        rasTRIGGER = dsTRIGGER.ReadAsArray()
        nodataTRIGGER = dsTRIGGER.GetRasterBand(1).GetNoDataValue()
        
        return rasDEM,rasFLOWDIR,rasTRIGGER, rows,cols,transform,nodataDEM,nodataFLOWDIR,nodataTRIGGER,pixelWidth

    def writeOutputGeoTiff(self,arrayData, transform, rows, cols, outFile):
        "Write the given array data to the file 'outfile' with the given extent."
        try:
            format = "GTiff"
            driver = gdal.GetDriverByName( format )
            metadata = driver.GetMetadata()
            if metadata.has_key(gdal.DCAP_CREATE) \
                   and metadata[gdal.DCAP_CREATE] == 'YES':
                pass
            else:
                QMessageBox.information(None,"info","Driver %s does not support Create() method." % format)
                return False
            outDataset = driver.Create(str(outFile), cols, rows, 1, gdal.GDT_Float32) 
            outRaster=outDataset.GetRasterBand(1)
            outRaster.WriteArray(arrayData)
            outRaster.SetNoDataValue(self.NOVALUE)
            outDataset.SetGeoTransform(transform)
            return True
        except:
            QMessageBox.information(None,"Exiting gracefully","I can't write %s texture file." % outFile)
            return

    def loadOutputFile(self,outFile):
        "Load map in TOC"
        fileInfo = QFileInfo(outFile)
        baseName = fileInfo.baseName()
        rlayer = QgsRasterLayer(outFile, baseName)
        if not rlayer.isValid():
            self.textEdit.append("Layer failed to load!")
        if QGis.QGIS_VERSION_INT < 10900:
        	rlayer.setDrawingStyle(QgsRasterLayer.SingleBandPseudoColor)
        	rlayer.setColorShadingAlgorithm(QgsRasterLayer.FreakOutShader)
        #else:
        	#rlayer.setDrawingStyle("SingleBandPseudoColor")	
                #rlayer.setColorShadingAlgorithm(QgsRasterLayer.FreakOutShader)
        QgsMapLayerRegistry.instance().addMapLayer(rlayer)

    
    def calcRunout(self, r, c, triggerElevation, di, dj, dd, rasFLOWDIR, rasDEM, rasDistanza, rasDeltaH, rows, cols, nodataFLOWDIR, nodataDEM, thresholdAlfa, thresholdSlope, rasOut):
       "Recursive Runout calculation function"
       if(rasFLOWDIR[r, c] != nodataFLOWDIR and rasDEM[r, c] != nodataDEM):
           #print("%d,%d,%d" % (r, c, rasFLOWDIR[r, c] ))
           rnb = r + di[rasFLOWDIR[r, c]]
           cnb = c + dj[rasFLOWDIR[r, c]]
           if (rnb >= 0 and rnb < rows and cnb >= 0 and cnb < cols): # guard against out of domain
               if (rasFLOWDIR[rnb, cnb] != nodataFLOWDIR and rasDEM[rnb, cnb] != nodataDEM): # guard against nodata
                   slope=(rasDEM[r, c]-rasDEM[rnb, cnb])/dd[rasFLOWDIR[r, c]]
                   if (slope<thresholdSlope): #
                    rasDistanza[rnb, cnb] = rasDistanza[r, c] + dd[rasFLOWDIR[r, c]]
                    rasDeltaH[rnb, cnb]=rasDeltaH[r, c]
                   else:
                    rasDistanza[rnb, cnb] = rasDistanza[r, c] 
                    rasDeltaH[rnb, cnb]=rasDeltaH[r, c] +(rasDEM[r, c]-rasDEM[rnb, cnb]) 
                       
                   #HsuL = rasDeltaH[rnb, cnb]/rasDistanza[rnb, cnb]
                   #self.textEdit.append(" rasFLOWDIR: %d, triggerElevation: %f, Elevation %f " % (rasFLOWDIR[r, c] ,triggerElevation, rasDEM[rnb, cnb] ))
                   #self.textEdit.append(" rasDistanza: %f, H/L: %f " % (rasDistanza[rnb, cnb] ,HsuL ))
               
                   if (rasDistanza[rnb, cnb] < (thresholdAlfa * rasDeltaH[rnb, cnb])):
                       rasOut[rnb, cnb] = rasOut[rnb, cnb] + 1
                       self.calcRunout(rnb, cnb, triggerElevation, di, dj, dd, rasFLOWDIR, rasDEM, rasDistanza, rasDeltaH,  rows, cols, nodataFLOWDIR, nodataDEM, thresholdAlfa, thresholdSlope, rasOut)
       

    def accept(self):
        # Called when "OK" button pressed
        paramDEM=self.cmbDEM.currentText()
        paramFLOWDIR=self.cmbFlowDir.currentText()
        paramTRIGGER=self.cmbTRIGGER.currentText()
         
        outFile=self.lineOutput.text()
        self.textEdit.append("Starting...")

        rasDEM,rasFLOWDIR,rasTRIGGER, rows,cols,transform,nodataDEM,nodataFLOWDIR,nodataTRIGGER,pixelWidth=self.ProcessRaster(paramDEM,paramFLOWDIR, paramTRIGGER)

        self.cmbFlowDirCoding.addItem("ESRI (1-128)")
        self.cmbFlowDirCoding.addItem("HyGrid2k2 (0-315)")
        self.cmbFlowDirCoding.addItem("TauDEM (1-8)")


        flowDirCoding=self.cmbFlowDirCoding.currentText()
        if (flowDirCoding=="ESRI (1-128)"):
            #row offset
            di={1:0, 2:1, 4:1, 8:1, 16:0, 32:-1, 64:-1, 128:-1} #rows indexes start from upper to bottom!!!
            #col offset
            dj={1:1, 2:1, 4:0, 8:-1, 16:-1, 32:-1, 64:0, 128:1}
        elif (flowDirCoding=="HyGrid2k2 (0-315)"):    
            #row offset
            di={0:0, 315:1, 270:1, 225:1, 180:0, 135:-1, 90:-1, 45:-1}
            #col offset
            dj={0:1, 315:1, 270:0, 225:-1, 180:-1, 135:-1, 90:0, 45:1}
        elif(flowDirCoding=="TauDEM (1-8)"):
            #row offset
            di={1:0, 8:1, 7:1, 6:1, 5:0, 4:-1, 3:-1, 2:-1}
            #col offset
            dj={1:1, 8:1, 7:0, 6:-1, 5:-1, 4:-1, 3:0, 2:1}        
        
        # distance
        dd={}
        csize=pixelWidth
        for k in di.keys():
            dd[k]=(((csize * di[k]) ** 2 + (csize * dj[k]) ** 2)) ** 0.5   # Pythagorous Theorem

        self.textEdit.append("rows:%d, columns:%d" % (rows,cols))
        rasOut=np.zeros((rows,cols), dtype=float)
        
        thresholdAlfa = float(self.doubleSpinBoxAlfa.value()) #0.4
        thresholdSlope = float(self.doubleSpinBoxSlope.value()) #0.14 (8 gradi)
        
         
        self.textEdit.append("Threshold Alpha: %f " % (thresholdAlfa))
        self.textEdit.append("Threshold Slope (%%): %f " % (thresholdSlope))
        self.textEdit.append("FlowDir coding: %s " % (flowDirCoding))
        #self.textEdit.append("Input nodata a= " + str(nodataA))
        # indeces of trigger pixels
        triggersValue = float(self.spinBoxTrigValue.value()) # to filter trigger pixels
        indices = np.where(rasTRIGGER==triggersValue)
        
        #print(indices)
        numTriggers=len(indices[1])
        self.textEdit.append("Number of trigger points: %d " % (numTriggers))
        
        self.progressBar.setRange(1,numTriggers)
        conta = 0
        RR=indices[0]
        CC=indices[1]
        # loop on triggers 
        sys.setrecursionlimit(3000) # to avoid "RuntimeError: maximum recursion depth exceeded in cmp" 
        for i in range(numTriggers):
            self.progressBar.setValue(i)
            conta +=1
            #if (conta >3):
                #break
            r=RR[i]
            c=CC[i]
            #self.textEdit.append("TRIGrow:%d, TRIGcolumn:%d" % (r,c))
            rasDistanza = np.zeros((rows,cols), dtype=float)
            rasDeltaH = np.zeros((rows,cols), dtype=float)
            self.calcRunout(r, c, rasDEM[r, c], di, dj, dd, rasFLOWDIR, rasDEM,  rasDistanza,rasDeltaH,  rows, cols, nodataFLOWDIR, nodataDEM, thresholdAlfa, thresholdSlope, rasOut)
                
        
        

        massimo = rasOut.max()
        media = rasOut.mean()
        standev = rasOut.std()
        
	# sostituisco lo 0 con NOVALUE
        rasOut[np.where(rasOut==0)]=self.NOVALUE
        
        self.textEdit.append("Summary of overlapping paths:")
        self.textEdit.append(" max: %.2f\n   mean: %.2f\n   std: %.2f" % ( massimo, media, standev))
        
        self.progressBar.setValue(numTriggers)
        
        self.writeOutputGeoTiff(rasOut,transform, rows, cols, outFile)
        self.loadOutputFile(outFile)
        self.textEdit.append("")
        self.textEdit.append(" *** SBM-T-Tools *** ")
        self.textEdit.append("")

