"""
/***************************************************************************
 FlowMapper
                                 A QGIS plugin
 This plugin generates discreet flow lines between nodes
                              -------------------
        begin                : 2011-12-04
        copyright            : (C) 2011 by Cem GULLUOGLU
        email                : cempro@gmail.com
 ***************************************************************************/
"""
import sys
import os
#from os.path import isfile
from os.path import realpath
import qgis.gui
from PyQt4 import QtCore, QtGui

# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

# Initialize Qt resources from file resources.py
import resources

# Import the code for the dialog
from flowmapperdialog import FlowMapperDialog
import flowmapperdialog
# Import script that draws flow lines (kullan)
import flowpyv07
#import flowpyInterface (iptal)

class FlowMapper:
  
    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/flowmapper/icon.png"), "Flow Mapper !", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item to QGIS
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Flow Mapper", self.action)
       
    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Flow Mapper",self.action)
        self.iface.removeToolBarIcon(self.action)

    def OutputShp(self):

        dlg = FlowMapperDialog()

        #buttona basip file browser ile output shapefile dosya adi vermek icin fonksiyon
        fd = QtGui.QFileDialog(dlg)
        global SaveShpName
        global SaveShpDirectory
        SaveShpName = fd.getSaveFileName(None, 'Shapefile(*.shp)', 'Type output shapefile name', '*.shp')
        #SaveShpDirectory = os.path.realpath(

    def InputNodes(self):

        dlg = FlowMapperDialog()

        #buttona basip file browser ile input node coord. txt dosyasini sectirmek icin fonksiyon
        fd = QtGui.QFileDialog(dlg)
        global InputNodesName
        InputNodesName = fd.getOpenFileName(None, 'Text Files(*.txt)', 'Select txt file', '*.txt')


        
    def InputMatrix(self):

        dlg = FlowMapperDialog()

        #buttona basip file browser ile flow matrix txt dosyasini sectirmek icin fonksiyon
        fd = QtGui.QFileDialog(dlg)
        global InputMatrixName
        InputMatrixName = fd.getOpenFileName(None, 'Text Files(*.txt)', 'Select txt file', '*.txt')
 
                     
    # run method that performs all the real work
    def run(self):
        # create and show the dialog
        dlg = FlowMapperDialog()

        # show the dialog
        dlg.show()

        #browse for file penceresini acmak icin SaveShp e signal yollar
        QtCore.QObject.connect(dlg.ui.BrowseShape,QtCore.SIGNAL("clicked()"), self.OutputShp)
        QtCore.QObject.connect(dlg.ui.BrowseShape,QtCore.SIGNAL("clicked()"), dlg.SetTextBrowseShape)

        QtCore.QObject.connect(dlg.ui.BrowseNodes,QtCore.SIGNAL("clicked()"), self.InputNodes)
        QtCore.QObject.connect(dlg.ui.BrowseNodes,QtCore.SIGNAL("clicked()"), dlg.SetTextBrowseNodes)
        
        QtCore.QObject.connect(dlg.ui.BrowseMatrix,QtCore.SIGNAL("clicked()"), self.InputMatrix)
        QtCore.QObject.connect(dlg.ui.BrowseMatrix,QtCore.SIGNAL("clicked()"), dlg.SetTextBrowseMatrix)
        

        result = dlg.exec_()
        # See if OK was pressed
        if result == 1:
            if dlg.ui.TwowayRadioButton.isChecked():
                FlowType = 1
            elif dlg.ui.GrossRadioButton.isChecked():
                FlowType = 2
            elif dlg.ui.NetRadioButton.isChecked():
                FlowType = 3

        #FlowType = dlg.ui.spinBoxType.value()

        SaveDirectory = os.path.realpath(SaveShpName)

            #flowpyv07.shapefilemaker(FlowType,'C:/Users/cem/.qgis/python/plugins/FlowMapper',str(OutputShpAdi)+'.shp','C:/Users/cem/.qgis/python/plugins/FlowMapper/bankinteract.txt','C:/Users/cem/.qgis/python/plugins/FlowMapper/bankpoints.txt')
        flowpyv07.shapefilemaker(FlowType,str(SaveDirectory), str(SaveShpName),str(InputMatrixName),str(InputNodesName))
        #'C:/Users/cem/.qgis/python/plugins/FlowMapper'

	# do something useful (delete the line containing pass and
        # substitute with your code
        #pass
	#execfile("flowpyInterface.py")


