from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterString
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterDistance
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingException
from qgis.core import QgsUnitTypes
from qgis.PyQt.QtCore import QCoreApplication
from qgis import processing

import os, tempfile

class ClassProjectionProcessingAlgorithm(QgsProcessingAlgorithm):
    def name(self):
        return 'classprojection'

    def displayName(self):
        return '2_' + self.tr('Projeter')

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def shortHelpString(self):
        return """<html><body><p>Cet algorithme crée une couche vecteur contenant toutes les classes de hauteurs d'eau renseignées dans "classes" à partir d'un MNT</p>
<br></body></html>"""

    def createInstance(self):
        return ClassProjectionProcessingAlgorithm()

    NUMBERS = 'NUMBERS'

    def initAlgorithm(self, config=None):        
        self.addParameter(QgsProcessingParameterRasterLayer('CPHE', 'CPHE', defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterLayer('mnt', 'MNT', defaultValue=None))
        self.addParameter(QgsProcessingParameterBoolean('loadHauteurs','Charger la couche des hauteurs'))
        self.addParameter(QgsProcessingParameterString(self.NUMBERS,'Classes (séparer les valeurs par un ";")',defaultValue='0;0.5;1;1.5;2'))
        self.addParameter(QgsProcessingParameterFeatureSink('rHauteurs', 'Raster des hauteurs', createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('output', 'Classes de Hauteur', createByDefault=True, defaultValue=None))
        param = QgsProcessingParameterDistance('tamisage', 'Tamisage :', minValue=0, defaultValue=400)
        param.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
        
        param = QgsProcessingParameterString('field','Nom du champs',defaultValue='classes')
        param.setFlags(QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
       
    def chemin(self):
        chem= tempfile.gettempdir()
        file_null = os.path.join(chem, 'null.tif')
        return file_null
		
		
    def processAlgorithm(self, parameters, context, model_feedback):
        feedback = QgsProcessingMultiStepFeedback(2, model_feedback)
        results = {}
        out = QgsProcessing.TEMPORARY_OUTPUT
        if parameters['loadHauteurs'] != 0:
            out = parameters['rHauteurs']
            
        # 1 Projection CPHE sur MNT
        alg_params = {
            'CPHE':parameters['CPHE'],
            'hmin':0,
            'mnt':parameters['mnt'],
            'output':out
            }
        
        alg = processing.run("fmt:mntprojection",alg_params, context=context, feedback=feedback, is_child_algorithm=True) 
        results['rHauteurs'] = alg['output']
        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}
            
        # 2 Vectoriser par classes
        alg_params = {
            'NUMBERS': parameters[self.NUMBERS],
            'hauteurs': alg['output'],
            'tamisage': parameters['tamisage'],
            'field': parameters['field'],
            'output': parameters['output']
        }
        alg = processing.run("fmt:classvectorisation", alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['output'] = alg['output']
        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}
        return results