from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterString
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterDistance
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsUnitTypes
import processing, os, tempfile

class floodbyclass(QgsProcessingAlgorithm):
    liste_affinage = ['affinage majorant','affinage minorant','affinage majorant puis minorant', 'affinage minorant puis majorant']
    
    def name(self):
        return 'floodbyclass'

    def displayName(self):
        return 'Création de ZIP/ZICH'


    def shortHelpString(self):
        return """<html><body><p>Cet algorithme fabrique des ZIP/ZICH à partir d'une couche vectorielle de CPHE et d'un MNT</p>
<br></body></html>"""

    def createInstance(self):
        return floodbyclass()

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('vect.cphe', 'Cotes des Plus Hautes Eau', types=[QgsProcessing.TypeVectorAnyGeometry], defaultValue='Modélisation maillé'))
        self.addParameter(QgsProcessingParameterBoolean('geometry','Cocher si la géométrie du vecteur en entrée est un polygone (mailles)', defaultValue=False))
        self.addParameter(QgsProcessingParameterField('cphe', 'Champ contenant la valeur de la CPHE', type=QgsProcessingParameterField.Numeric, parentLayerParameterName='vect.cphe', allowMultiple=False, defaultValue=None))
        self.addParameter(QgsProcessingParameterEnum('interpolation', 'Choix de la spatialisation', options=['Interpolation bilinéaire','Interpolation bicubic','Interpolation rst','En Escalier'], allowMultiple=False, usesStaticStrings=False, defaultValue=3))
        self.addParameter(QgsProcessingParameterRasterLayer('mnt', 'MNT', defaultValue=None))
        param=QgsProcessingParameterDistance('buffer', 'Taille du tampon', parentParameterName='cotes_des_plus_hautes_eau', defaultValue=10)
        param.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        self.addParameter(param)
        self.addParameter(QgsProcessingParameterEnum('affinage', 'Choix de la méthode d\'affinage', options=self.liste_affinage, allowMultiple=False, usesStaticStrings=False, defaultValue=2))
        clean = QgsProcessingParameterNumber('clean', 'Supprimer les surfaces inférieures à :',type=QgsProcessingParameterNumber.Integer, minValue=0, defaultValue=400)
        self.addParameter(clean)
        self.addParameter(QgsProcessingParameterNumber('simp', 'Tolérance de simplification finale :', type=QgsProcessingParameterNumber.Double, minValue=0, defaultValue=3))
        self.addParameter(QgsProcessingParameterNumber('lissage', 'Itération de Lissage final:', type=QgsProcessingParameterNumber.Integer, minValue=0, defaultValue=2))
        self.addParameter(QgsProcessingParameterFeatureSink('output1', 'ZIP/ZICH', createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('output2', 'ZIP/ZICH', createByDefault=True, defaultValue=None))
        
    def processAlgorithm(self, parameters, context, model_feedback):
        feedback = QgsProcessingMultiStepFeedback(4, model_feedback)
        outputs = {}
        NUMBERS ='0;0.5;1;1.5;2'
        
        # 1 Projection CPHE sur MNT
        alg_params = {
            'buffer': parameters['buffer'],
            'cotes_des_plus_hautes_eau': parameters['vect.cphe'],
            'cphe': parameters['cphe'],
            'geometry': parameters['geometry'],
            'hmin': 0,
            'interpolation': parameters['interpolation'],
            'masque': None,
            'mnt':  parameters['mnt'],
            'output': QgsProcessing.TEMPORARY_OUTPUT,
            'res_CPHE': QgsProcessing.TEMPORARY_OUTPUT
        }
        
        alg = processing.run('script:mntprojection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # 2 Vectoriser par classes
        alg_params = {
            'NUMBERS':NUMBERS,
            'RasterHeausup0': alg['output'],
            'Tamisage': parameters['clean'],
            'output': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('script:groupbyclass', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # 3 Affiner les contours
        alg_params = {
            'buffer': parameters['buffer'],
            'clean': parameters['clean'],
            'couchebrute': alg['output'],
            'lissage': parameters['lissage'],
            'meth.tampon': parameters['affinage'],  # affinage majorant
            'simp': parameters['simp'],
            'output': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('script:refinepolygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # 4 Poupées Russes
        alg_params = {
            'NUMBERS': NUMBERS,
            'affine':alg['output'],
            'z': 0,  # ZIP
            'output': parameters['output1']
        }
        outputs['ZIP'] = processing.run('script:russiandolls', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # 4 Poupées Russes
        alg_params = {
            'NUMBERS': NUMBERS,
            'affine':alg['output'],
            'z': 1,  # ZICH
            'output': parameters['output2']
        }
        outputs['ZICH'] = processing.run('script:russiandolls', alg_params, context=context, feedback=feedback, is_child_algorithm=True)       
        return outputs