from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterDistance
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsUnitTypes
from qgis.core import QgsVectorLayer
from qgis.core import QgsProcessingUtils
from qgis.core import QgsFeatureSink
from qgis.core import QgsWkbTypes

from qgis.core import QgsProcessingContext
import processing, time, threading, os, traceback
from functools import partial

import multiprocessing


class cphespatialisationtest(QgsProcessingAlgorithm):

    def name(self):
        return 'cphespatialisationtest'

    def displayName(self):
        return '1 Spatialisation CPHE_test'


    def group(self):
        return 'TEST'

    def groupId(self):
        return 'test'

    def shortHelpString(self):
        return """<html><body><p>Cet algorithme interpole une couche vectorielle contenant des données spatiales et les projète sur un Modèle Numérique de Terrain (MNT) si celui-ci est donnée en paramètre.</p>
<br></body></html>"""

    def createInstance(self):
        return cphespatialisationtest()

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('cotes_des_plus_hautes_eau', 'Cotes des Plus Hautes Eau', types=[QgsProcessing.TypeVectorAnyGeometry], defaultValue=None))
        self.addParameter(QgsProcessingParameterBoolean('geometry','Cocher si la géométrie du vecteur en entrée est un polygone (mailles)', defaultValue=False))
        self.addParameter(QgsProcessingParameterField('cphe', 'Champ contenant la valeur de la CPHE', type=QgsProcessingParameterField.Numeric, parentLayerParameterName='cotes_des_plus_hautes_eau', allowMultiple=False, defaultValue=None))
        distance = QgsProcessingParameterDistance('hmin', 'Hauteur minimale de la sortie(m)', defaultValue=0)
        distance.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        self.addParameter(distance)
        self.addParameter(QgsProcessingParameterEnum('interpolation', 'Choix de la spatialisation', options=['Interpolation bilinéaire','Interpolation bicubic','Interpolation rst','En Escalier'], allowMultiple=False, usesStaticStrings=False, defaultValue=3))
        self.addParameter(QgsProcessingParameterRasterDestination('output', 'Raster des hauteurs supérieure à la hauteur minimale', createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterDestination('res_CPHE', 'CPHE', createByDefault=False, defaultValue=None))
        param = QgsProcessingParameterDistance('buffer', 'Taille du tampon', parentParameterName='cotes_des_plus_hautes_eau', defaultValue=100)
        
        param.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
        
        param =(QgsProcessingParameterRasterLayer('mnt', 'MNT', optional=True, defaultValue=None))
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
        
        param = QgsProcessingParameterFeatureSource('masque', 'Traitement par zones', optional=True, types=[QgsProcessing.TypeVectorAnyGeometry], defaultValue=None)
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
            
        # self.addParameter(QgsProcessingParameterRasterDestination('raster_developpement', 'raster_developpement', createByDefault=False, defaultValue=None))
        # self.addParameter(QgsProcessingParameterFeatureSink('vect_developpement', 'vect_developpement', createByDefault=True, defaultValue=None))      
    
    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        
        threads = list()
       
        
        feedback = QgsProcessingMultiStepFeedback(9, model_feedback)
        
        
        
        nicenames = {
            'output': "Hauteurs",
            'res_CPHE': "CPHE",
            # 'raster_developpement' :'raster_developpement',
            # 'vect_developpement' : 'vect_developpement',
        }   
        
        
        outputs = {
            # 'file':"C:/Users/PC/Desktop/TFE/time_for_mntprojection.csv"
            } 
        
        
# Ecriture du temps que mets chaque algorithme à tourner        
        # f= open(outputs['file'],'w', encoding="utf-8")
        # f.write("L'algorithme à commencé à " + time.strftime("%H:%M:%S") + "\n"+"\n")
        # f.close
        
        
        
        
        
        # start = time.time()
        if parameters['masque'] is None:
            parameters['cotes_des_plus_hautes_eau_unitaire'] = parameters['cotes_des_plus_hautes_eau']
            parameters['mask_unitaire'] = False
            parameters['indice'] = 0
            outputs['indice'] = 0
            status, results = self.traitement_unitaire(parameters, context, feedback, outputs)
            if status=='cancel':
                return {}
        else:          
            # source = self.parameterAsSource(
                # parameters,
                # 'masque',
                # context
            # )
            
            results_assemb = {}

                        
            alg = processing.run('native:fixgeometries', 
                {
                    'INPUT': parameters['masque'],
                    'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                }, 
                context=context, feedback=feedback, is_child_algorithm=True)
            source = context.getMapLayer(alg['OUTPUT'])
            

            
            for i,f in enumerate(source.getFeatures()):
                (sink, dest_id) = QgsProcessingUtils.createFeatureSink(
                    'memory:',
                    context,
                    source.fields(),
                    source.wkbType(),
                    source.sourceCrs()
                )
                params = {p:v for p,v in parameters.items()}
                params['indice'] = i
                outs = {p:v for p,v in outputs.items()}
                outs['indice'] = i
                
                sink.addFeature(f, QgsFeatureSink.FastInsert)
                alg_params = {
                    'INPUT': params['cotes_des_plus_hautes_eau'],
                    'INTERSECT': dest_id,
                    'PREDICATE': [0], 
                    'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                }
                alg = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                # parameters['cotes_des_plus_hautes_eau_unitaire'] = alg['OUTPUT']
                # couche_extraite = context.getMapLayer(alg['OUTPUT'])
                params['cotes_des_plus_hautes_eau_unitaire'] = context.getMapLayer(alg['OUTPUT'])
                
                alg = processing.run('native:fixgeometries', 
                    {
                        'INPUT': dest_id,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }, 
                    context=context, feedback=feedback, is_child_algorithm=True)
                
                params['mask_unitaire'] = context.getMapLayer(alg['OUTPUT'])

                if context.getMapLayer(alg['OUTPUT']).featureCount()<1:
                    continue
                
                # try:
                # context = QgsProcessingContext()
                t = ReturnableThread(self.traitement_unitaire, params, context, feedback, outs)

                # t2 = multiprocessing.Process(target=self.test)

                t.start()
                # t.dest_id = dest_id
                threads.append(t)
                # t.join()
                                   
                # except Exception as e:
                
                    # f= open(outputs['file'],'a', encoding="utf-8")
                    # f.write("Erreur à " + time.strftime("%H:%M:%S") + "\n"+"\n")
                    # f.close
                    # continue 
                    
            
            
            
            for i,t in enumerate(threads):
                t.join()
                # print(i, t.result)
                # status, result = t.result
                feedback.pushInfo(f"Main    : thread {i+1} done") 
                # while not result.empty():
                    # results = result_queue.get()
                    # print(f"Layer {layer_path} result: {result}")

            feedback.pushInfo(f"Tout est fini et je peux lancer l'assemblage de mes résultats")      

            for i,t in enumerate(threads):
                status, results = t.result
                          
                if status=='cancel':
                    return {}
                    
                    
                for key,val in results.items():
                    if key not in results_assemb: results_assemb[key] = []

                    # alg_params = {
                        # 'COPY_SUBDATASETS': False,
                        # 'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
                        # 'EXTRA': '',
                        # 'INPUT': val,
                        # 'NODATA': 0,
                        # 'OPTIONS': '',
                        # 'TARGET_CRS': None,
                        # 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    # }
                    # alg = processing.run('gdal:translate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)     
                    # print('results_assemb',results_assemb)
                    # alg_params = {
                        # 'ALPHA_BAND': False,
                        # 'CROP_TO_CUTLINE': True,
                        # 'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
                        # 'EXTRA': '',
                        # 'INPUT': alg['OUTPUT'],
                        # 'KEEP_RESOLUTION': False,
                        # 'MASK': t.dest_id,
                        # 'MULTITHREADING': False,
                        # 'NODATA': None,
                        # 'OPTIONS': '',
                        # 'SET_RESOLUTION': False,
                        # 'SOURCE_CRS': None,
                        # 'TARGET_CRS': None,
                        # 'TARGET_EXTENT': None,
                        # 'X_RESOLUTION': None,
                        # 'Y_RESOLUTION': None,
                        # 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    # }
                    # alg = processing.run('gdal:cliprasterbymasklayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                    
                    results_assemb[key].append(val)  

           
            for key,liste in results_assemb.items():
                
                if len(liste)>1:
                    alg_params = {
                        '-z': False,
                        'GRASS_RASTER_FORMAT_META': '',
                        'GRASS_RASTER_FORMAT_OPT': '',
                        'GRASS_REGION_CELLSIZE_PARAMETER': 0,
                        'GRASS_REGION_PARAMETER': None,
                        'input': liste,
                        'output': parameters[key]
                    }
                    alg = processing.run('grass7:r.patch', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                    results[key] = alg['output']
                
                elif len(liste)>0:
                    alg_params = {
                        'COPY_SUBDATASETS': False,
                        'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
                        'EXTRA': '',
                        'INPUT': liste[0],
                        'NODATA': 0,
                        'OPTIONS': '',
                        'TARGET_CRS': None,
                        'OUTPUT': parameters[key]
                    }
                    alg = processing.run('gdal:translate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                    
                    results[key] = alg['OUTPUT']
                    
                else:
                    results[key] = None
            
        
        for key in results.keys():  
            details = context.layerToLoadOnCompletionDetails(results[key])
            details.name = nicenames.get(key,details.name)
            details.forceName = True    

        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Temps Total'
        # self.write_time(outputs) 
      
        # f= open(outputs['file'],'a', encoding="utf-8")
        # f.write( "\n" + "L'algorithme à fini à " + time.strftime("%H:%M:%S") +"\n" )
        # f.close
        
        results['parameters'] = parameters
        
        return results
        


## Fonction d'écriture du temps vers un fichier au format choisi dans 'output'

    # def write_time(self,outputs):
        # f = open(outputs['file'], 'a', encoding="utf-8")
        # f.write(f"{outputs['name']}, {outputs['temps']}, secondes"+"\n")
        # f.close
        # return 
        
        
        
        
    def test(self):
        time.sleep(5)
        
        
        
    def traitement_unitaire(self, parameters, context, feedback, outputs):    
        results = {}
                
        m = 1 if parameters['masque'] is None else 0
        outputs['res_output'] = [QgsProcessing.TEMPORARY_OUTPUT,parameters['output']][m]        
        outputs['res_CPHE'] = [QgsProcessing.TEMPORARY_OUTPUT,parameters['res_CPHE']][m]
        

# Pré-traitement_unitaire

        outputs['pre_traitement']=parameters['cotes_des_plus_hautes_eau_unitaire']

        # De morceaux multiples à morceaux uniques
        # start = time.time()
        alg_params = {
            'INPUT': outputs['pre_traitement'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['centroides'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        parameters['newcentroides'] = context.getMapLayer(outputs['centroides']['OUTPUT'])
        
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='DeMorceauxMultiplesMorceauxUniques'
        # self.write_time(outputs)     
        
        
        if parameters['geometry'] :
            # Centroïdes
            # start = time.time()
            alg_params = {
                'ALL_PARTS': False,
                'INPUT': outputs['DeMorceauxMultiplesMorceauxUniques']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['centroides'] = processing.run('native:centroids', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
            parameters['newcentroides'] = context.getMapLayer(outputs['centroides']['OUTPUT'])
            # end = time.time()
            # outputs["temps"] = round(end-start,2)
            # outputs['name']='Centroïdes'
            # self.write_time(outputs)    
         
        if feedback.isCanceled():
            return 'cancel', None  
            
        else : 
            # Géométrie d'emprise minimale
            # start = time.time()
            alg_params = {
                'FIELD': '',
                'INPUT': parameters['newcentroides'],
                'TYPE': 3,  # Enveloppe convexe
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['GomtrieDempriseMinimale'] = processing.run('qgis:minimumboundinggeometry', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
            outputs['pre_traitement']=context.getMapLayer(outputs['GomtrieDempriseMinimale']['OUTPUT'])
            
            # end = time.time()
            # outputs["temps"] = round(end-start,2)
            # outputs['name']='GomtrieDempriseMinimale'
            # self.write_time(outputs)    

      
        if feedback.isCanceled():
            return 'cancel', None   

#Interpolation Escalier        
        if parameters['interpolation']== 3 :
            status, res = self.interpolEscalier(parameters, context, feedback, outputs)
            
            if status=='cancel':
                return 'cancel', None
#Interpolaiton avec Rfillnull
        else :
            status,res, = self.rfillnull(parameters, context, feedback, outputs)
            
            if status=='cancel':
                return 'cancel', None
        
        

        feedback.setCurrentStep(8)        
        if feedback.isCanceled():
            return 'cancel', None
            
        if parameters['mask_unitaire']: 
        
            alg_params = {
                'ALPHA_BAND': False,
                'CROP_TO_CUTLINE': True,
                'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
                'EXTRA': '',
                'INPUT': res,
                'KEEP_RESOLUTION': False,
                'MASK': parameters['mask_unitaire'],
                'MULTITHREADING': False,
                'NODATA': None,
                'OPTIONS': '',
                'SET_RESOLUTION': False,
                'SOURCE_CRS': None,
                'TARGET_CRS': None,
                'TARGET_EXTENT': None,
                'X_RESOLUTION': None,
                'Y_RESOLUTION': None,
                'OUTPUT': outputs['res_CPHE']
            }
            alg = processing.run('gdal:cliprasterbymasklayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        else:
            alg_params = {
                'COPY_SUBDATASETS': False,
                'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
                'EXTRA': '',
                'INPUT': res,
                'NODATA': 0,
                'OPTIONS': '',
                'TARGET_CRS': None,
                'OUTPUT': outputs['res_CPHE']
            }
            alg = processing.run('gdal:translate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)     
              
        
        results['res_CPHE'] = alg['OUTPUT']    
        print(outputs['indice'], 'fin', results['res_CPHE'], parameters['mask_unitaire'] )
           
        if parameters['mnt'] is None:
            return 'ok', results
            feedback.setCurrentStep(9)
            if status=='cancel':
                return 'cancel', None
        


# Si un MNT est ajouté à l'algorithme : 
        
        else :               
            # 1.5 Projection CPHE sur MNT
            # start = time.time()
            
            print(outputs['indice'], 'avant', results['res_CPHE'] )
            
            alg_params = {
                'CPHE': results['res_CPHE'],
                'hmin': parameters['hmin'],
                'mnt': parameters['mnt'],
                'output': outputs['res_output']
            }
            outputs['ProjectionCpheSurMnt'] = processing.run('fmt:mntdifference', alg_params, context=context, feedback=feedback)    
            results['output'] = outputs['ProjectionCpheSurMnt']['output']
            
            print(outputs['indice'], 'hauteur', results['output'] )

            feedback.setCurrentStep(10)            
            if status=='cancel':
                return 'cancel', None
        
            # end = time.time()
            # outputs["temps"] = round(end-start,2)
            # outputs['name']='Projection CPHE sur MNT'
            # self.write_time(outputs)

   
        return 'ok', results      












    def rfillnull(self, parameters, context, feedback, outputs):
        status = 'ok'

        # Tampon
        # start = time.time()
        alg_params = {
            'DISSOLVE': True,
            'DISTANCE': parameters['buffer'],
            'END_CAP_STYLE': 0,  # Rond
            'INPUT': parameters['newcentroides'],
            'JOIN_STYLE': 0,  # Rond
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Tampon'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        algOutputBis = context.getMapLayer(outputs['Tampon']['OUTPUT'])
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Tampon'
        # self.write_time(outputs)
        
        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return 'cancel', None
    
        # Limite
        # start = time.time()
        alg_params = {
            'INPUT': algOutputBis,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:boundary', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        algOutput = context.getMapLayer(alg['OUTPUT'])
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Limite'
        # self.write_time(outputs)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return 'cancel', None


        # Multiligne Interpolation
        # start = time.time()
        alg_params = {
            'CLEAN': False,
            'DISTANCE': 10,
            'FIELD': parameters['cphe'],
            'INPUT': parameters['newcentroides'],
            'INPUT_LINES': algOutput,
            'JUNCTION': False,
            'TOLERANCE': parameters['buffer'],
            'ERROR': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT_LINES': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('fmt:multilineinterpolation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Multiligne interpolation'
        # self.write_time(outputs)

        feedback.setCurrentStep(3)       
        if feedback.isCanceled():
            return 'cancel', None
        
        couches=[parameters['newcentroides'],alg['OUTPUT']]
        

        # Fusionner des couches vecteur
        # start = time.time()
        alg_params = {
            'CRS': None,
            'LAYERS': couches,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
#            'OUTPUT': parameters['vect_developpement']
        }
        alg = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        algOutput = context.getMapLayer(alg['OUTPUT'])
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Fusionner des couches vecteur'
        # self.write_time(outputs)
        

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return 'cancel', None
          

        print('fusion',alg['OUTPUT'],algOutput)
        print('Tampon',outputs['Tampon']['OUTPUT'],algOutputBis)
        
        if  parameters['masque'] is None:
            algOutput =alg['OUTPUT']
            algOutputBis = outputs['Tampon']['OUTPUT']
        
        
          
        # Rasteriser (vecteur vers raster)
        # start = time.time()
        alg_params = {
            'BURN': 0,
            'DATA_TYPE': 5,  # Float32
            'EXTENT':algOutputBis,
            'EXTRA': '',
            'FIELD': parameters['cphe'],
            'HEIGHT': 1,
            'INIT': None,
            'INPUT': algOutput,
            'INVERT': False,
            'NODATA': -9999,
            'OPTIONS': '',
            'UNITS': 1,  # Unités géoréférencées
            'USE_Z': False,
            'WIDTH': 1,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
#            'OUTPUT': parameters['raster_developpement']
        }
        alg = processing.run('gdal:rasterize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Rasteriser'
        # self.write_time(outputs)
        
        # return  status,outputs['FusionnerDesCouchesVecteur']['OUTPUT'], outputs['RasteriserVecteurVersRaster']['OUTPUT']
        print('Rasterisation',alg['OUTPUT'])
        
        feedback.setCurrentStep(5)        
        if feedback.isCanceled():
            return 'cancel', None
        # print('Rasterisation',alg['OUTPUT'])    
        
        file = os.path.join(os.path.dirname(__file__), 'data', f"fillnulloutput_{parameters['indice']}.tif")
        print(file)    
        # r.fillnulls
        # start = time.time()
        alg_params = {
            'GRASS_RASTER_FORMAT_META': '',
            'GRASS_RASTER_FORMAT_OPT': '',
            'GRASS_REGION_CELLSIZE_PARAMETER': 0,
            'GRASS_REGION_PARAMETER':alg['OUTPUT'],
            'edge': 3,
            'input': alg['OUTPUT'],
            'lambda': 0.01,
            'method': parameters['interpolation'],
            'npmin': 600,
            'segmax': 300,
            'smooth': 0.1,
            'tension': 40,
            # 'output': QgsProcessing.TEMPORARY_OUTPUT
            'output': file
        }
        alg = processing.run('grass7:r.fillnulls', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='R.Fillnulls'
        # self.write_time(outputs)
        

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return 'cancel', None
          
         # Convertir
        # start = time.time()
        # alg_params = {
            # 'COPY_SUBDATASETS': False,
            # 'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
            # 'EXTRA': '',
            # 'INPUT': alg['output'],
            # 'NODATA': 0,
            # 'OPTIONS': '',
            # 'TARGET_CRS': None,
            # 'OUTPUT':outputs['res_CPHE']
        # }
        # alg = processing.run('gdal:translate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Convertir'
        # self.write_time(outputs)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return 'cancel', None
         
        return  status,alg['output']
#        return  status,outputs['Convertir']['OUTPUT'],outputs['FusionnerDesCouchesVecteur']['OUTPUT'], outputs['RasteriserVecteurVersRaster']['OUTPUT']
        









    def interpolEscalier(self, parameters, context, feedback, outputs):
        status = 'ok'                
        # Calcul de la taille de la zone pour recalculer le buffer minimal du voronoi
        # start = time.time()
        maxi = 0
        alg_params = {
            'INPUT': outputs['pre_traitement'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg2 = processing.run('native:polygonfromlayerextent', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        for f in context.getMapLayer(alg2['OUTPUT']).getFeatures():
            maxi = max(maxi, f.attribute('WIDTH'))
            maxi = max(maxi, f.attribute('HEIGHT'))
        percent = max(100*parameters['buffer']/maxi, 10)
        
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Re-calcul de la zone Tampon'
        # self.write_time(outputs)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return 'cancel', None        
        # Polygones de Voronoï
        # start = time.time()
        alg_params = {
            'BUFFER': percent,
            'INPUT': parameters['newcentroides'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('qgis:voronoipolygons', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        algOutput = context.getMapLayer(alg['OUTPUT'])
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Polygones de Voronoï'
        # self.write_time(outputs)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return 'cancel', None
            
        # Tampon
        # start = time.time()
        alg_params = {
            'DISSOLVE': True,
            'DISTANCE': parameters['buffer'],
            'END_CAP_STYLE': 0,  # Rond
            'INPUT': outputs['pre_traitement'],
            'JOIN_STYLE': 0,  # Rond
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Tampon'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        algOutputBis = context.getMapLayer(outputs['Tampon']['OUTPUT'])
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Tampon'
        # self.write_time(outputs)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return 'cancel', None

        # Intersection
        # start = time.time()
        alg_params = {
            'GRID_SIZE': None,
            'INPUT': context.getMapLayer(alg['OUTPUT']),
            'INPUT_FIELDS': None,
            'OVERLAY':  algOutputBis,
            'OVERLAY_FIELDS': None,
            'OVERLAY_FIELDS_PREFIX': None,
            'OUTPUT':  QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        algOutput = context.getMapLayer(alg['OUTPUT'])
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Intersection'
        # self.write_time(outputs)

        feedback.setCurrentStep(4)        
        if feedback.isCanceled():
            return 'cancel', None

        # Rasteriser (vecteur vers raster)
        # start = time.time()

        alg_params = {
            'BURN': 0,
            'DATA_TYPE': 5,  # Float32
            'EXTENT': algOutput,
            'EXTRA': '',
            'FIELD': parameters['cphe'],
            'HEIGHT': 1,
            'INIT': None,
            'INPUT': algOutput,
            'INVERT': False,
            'NODATA': -9999,
            'OPTIONS': '',
            'UNITS': 1,  # Unités géoréférencées
            'USE_Z': False,
            'WIDTH': 1,
            'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('gdal:rasterize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        algOutput = context.getMapLayer(alg['OUTPUT'])
        
        
        # end = time.time()
        # outputs["temps"] = round(end-start,2)
        # outputs['name']='Rasterisation'
        # self.write_time(outputs)

        feedback.setCurrentStep(5)        
        if feedback.isCanceled():
            return 'cancel', None

        return status,alg['OUTPUT']
        

class ReturnableThread(multiprocessing.Process):
    # This class is a subclass of Thread that allows the thread to return a value.
    def __init__(self, target):
        
        Process.__init__(self)
        self.target = target
        self.result = None
    
    def run(self) -> None:
        self.result = self.target()

class ReturnableThread2(threading.Thread):
    # This class is a subclass of Thread that allows the thread to return a value.
    def __init__(self, target, *args, **kwargs):
        # Thread.__init__(self)
        super().__init__()
        self.target = target
        self.args = args
        self.kwargs = kwargs
        self.result = 'error',None
    
    def run(self) -> None:
        try:
            self.result = self.target(*self.args, **self.kwargs)
        except Exception as e:
            self.result = 'error',None
            raise(e)