# -*- coding: utf-8 -*-
import sys, os
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingUtils,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterMultipleLayers,
                       QgsProcessingParameterRasterDestination)
from qgis import processing


class SafePatchProcessingAlgorithm(QgsProcessingAlgorithm):

    INPUT = 'INPUT'
    OUTPUT = 'OUTPUT'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return SafePatchProcessingAlgorithm()

    def name(self):
        return 'safepatch'

    def displayName(self):
        return self.tr('Assembler des rasters')

    def group(self):
        return self.tr('Scripts')

    def groupId(self):
        return 'scripts'

    def shortHelpString(self):
        return self.tr("Assemble les rasters en traitant le cas liste vide ou un seul élément")

    def initAlgorithm(self, config=None):
        self.addParameter(
            QgsProcessingParameterMultipleLayers(
                self.INPUT,
                self.tr("Couches source"),
                QgsProcessing.TypeRaster,
                optional=True
            )
        )
        
        self.addParameter(
            QgsProcessingParameterRasterDestination(
                self.OUTPUT, 
                self.tr("Assemble"),
                createByDefault=False, 
                defaultValue=None
            )
        )
        
        

    def processAlgorithm(self, parameters, context, feedback):
        
        print(parameters[self.INPUT])
        liste = self.parameterAsLayerList(
            parameters,
            self.INPUT,
            context
        )

        if len(liste)>1:
            alg_params = {
                '-z': False,
                'GRASS_RASTER_FORMAT_META': '',
                'GRASS_RASTER_FORMAT_OPT': '',
                'GRASS_REGION_CELLSIZE_PARAMETER': 0,
                'GRASS_REGION_PARAMETER': None,
                'input': liste,
                'output': parameters[self.OUTPUT]
            }
            alg = processing.run('grass7:r.patch', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
            results = alg['output']
        
        elif len(liste)>0:
            alg_params = {
                'COPY_SUBDATASETS': False,
                'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
                'EXTRA': '',
                'INPUT': liste[0],
                'NODATA': 0,
                'OPTIONS': '',
                'TARGET_CRS': None,
                'OUTPUT': parameters[self.OUTPUT]
            }
            alg = processing.run('gdal:translate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
            
            results = alg['OUTPUT']
            
        else:
            results = None
       

        return {self.OUTPUT: results}






