from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterString
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterDistance
try:  from qgis.core import QgsProcessingParameterArea
except: pass
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsUnitTypes, QgsProcessingParameterFeatureSource

from qgis.PyQt.QtCore import QCoreApplication
from qgis import processing





class RefinePolygonProcessingAlgorithm(QgsProcessingAlgorithm):
    liste_affinage = ['affinage majorant','affinage minorant','affinage majorant puis minorant', 'affinage minorant puis majorant']

    def name(self):
        return 'refinepolygon'
        
    def displayName(self):
        return '3_' + self.tr('Affiner')

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)    
    
    def shortHelpString(self):
        return """<html><body><p>Cet algorithme sert à appliquer une stratégie d'affinage sur une couche vectorielle</p>
<br></body></html>"""
        
    def createInstance(self):
        return RefinePolygonProcessingAlgorithm()
        
    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('vectAffiner', 'Vecteur à affiner', defaultValue=None))
        self.addParameter(QgsProcessingParameterField('champAffiner', 'Champ de regroupement', parentLayerParameterName='vectAffiner', allowMultiple=False, defaultValue=None, optional=True))
        self.addParameter(QgsProcessingParameterEnum('choixAff', 'Choix de la méthode d\'affinage', options=self.liste_affinage, allowMultiple=False, usesStaticStrings=False, defaultValue=0))
        distance = QgsProcessingParameterDistance('buffer', 'Taille du tampon d\'affinage', defaultValue=3)
        distance.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        self.addParameter(distance)
        try:
            param = QgsProcessingParameterArea('clean', 'Supprimer les surfaces inférieures à :', minValue=0, defaultValue=400)
            param.setDefaultUnit(QgsUnitTypes.AreaSquareMeters )
        except:
            param = QgsProcessingParameterNumber('clean', 'Supprimer les surfaces inférieures à (m²):', minValue=0, defaultValue=400)
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
        self.addParameter(QgsProcessingParameterNumber('simp', 'Tolérance de simplification finale :', type=QgsProcessingParameterNumber.Double, minValue=0, defaultValue=3))
        self.addParameter(QgsProcessingParameterNumber('lissage', 'Itération de Lissage final:', type=QgsProcessingParameterNumber.Integer, minValue=0, defaultValue=2))
        self.addParameter(QgsProcessingParameterFeatureSink('output', 'Classes de Hauteur', createByDefault=True, defaultValue=None))

      
    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(8, model_feedback)
        outputs = {}

        # Simplifier
        alg_params = {
            'INPUT': parameters['vectAffiner'],
            'METHOD': 0,  
            'TOLERANCE': parameters['simp'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:simplifygeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)



        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}
            
        
        ordre=[parameters['buffer'],-parameters['buffer']]
        
        if parameters['choixAff'] <2 :
            compteur = 1
        else : 
            compteur = 2
        if parameters['choixAff']==1 or parameters['choixAff']== 3:
           ordre.reverse() 

           
        for i in range(compteur):
            for j,v in enumerate(ordre):
            # Tampon
                if feedback.isCanceled():
                    return {}
                alg_params = {
                    'DISSOLVE': False,
                    'DISTANCE': v,
                    'END_CAP_STYLE': 0,  # Rond
                    'INPUT': alg['OUTPUT'],
                    'JOIN_STYLE': 0,  # Rond
                    'MITER_LIMIT': 2,
                    'SEGMENTS': 5,
                    'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                }
                alg = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                
                
                # if parameters['regroup'] and (((i,j)==(0,0) and parameters['choixAff'] in (0,2)) or ((i,j)==(1,0) and parameters['choixAff']==3)):
                if parameters['champAffiner'] and (j==0 and v>0):
                    alg_params = {
                        'FIELD': [parameters['champAffiner']],
                        'INPUT': alg['OUTPUT'],
                        'SEPARATE_DISJOINT': True,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    alg = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                
                # Simplifier
                # if parameters['simp_buffer']>0 and j==0:
                    # alg_params = {
                        # 'INPUT': alg['OUTPUT'],
                        # 'METHOD': 0,  
                        # 'TOLERANCE': parameters['simp_buffer'],
                        # 'OUTPUT':  QgsProcessing.TEMPORARY_OUTPUT
                    # }
                    # alg = processing.run('native:simplifygeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                feedback.setCurrentStep(2)

            ordre.reverse()

        # Simplifier
        if parameters['simp']>0:
            alg_params = {
                'INPUT':alg['OUTPUT'],
                'METHOD': 0,  
                'TOLERANCE': parameters['simp'],
                'OUTPUT':  QgsProcessing.TEMPORARY_OUTPUT
            }
            alg = processing.run('native:simplifygeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        alg = processing.run("native:multiparttosingleparts", {
            'INPUT': alg['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }, context=context, feedback=feedback)


        if parameters['clean']>0:
            alg = processing.run('native:extractbyexpression', {
                'INPUT': alg['OUTPUT'],
                'EXPRESSION': f"$area>{parameters['clean']}",
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }, context=context, feedback=feedback, is_child_algorithm=True)
            
        if parameters['clean']>0:
            alg = processing.run('native:deleteholes', {
                'INPUT': alg['OUTPUT'],
                'MIN_AREA': parameters['clean'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }, context=context, feedback=feedback, is_child_algorithm=True)
            

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        
        if parameters['champAffiner']:
            alg = processing.run('native:dissolve', {
                'FIELD': [parameters['champAffiner']],
                'INPUT': alg['OUTPUT'],
                'SEPARATE_DISJOINT': True,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }, context=context, feedback=feedback, is_child_algorithm=True)
        
        # alg = processing.run('native:fixgeometries', {
            # 'INPUT': alg['OUTPUT'],
            # 'METHOD': 1,  
            # 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        # }, context=context, feedback=feedback, is_child_algorithm=True)
        
        
        

        #Lisser
        if parameters['lissage']>0:
            alg_params = {
                'INPUT': alg['OUTPUT'],
                'ITERATIONS': parameters['lissage'],
                'MAX_ANGLE': 180,
                'OFFSET': 0.25,
                'OUTPUT':  QgsProcessing.TEMPORARY_OUTPUT
            }
            alg = processing.run('native:smoothgeometry', alg_params, context=context, is_child_algorithm=True)

        

        
        
        
        
        alg = processing.run('native:fixgeometries', {
            'INPUT': alg['OUTPUT'],
            'METHOD': 1,  # Structure
            'OUTPUT': parameters['output']
        }, context=context, feedback=feedback, is_child_algorithm=True)


        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}
        
        return  {'output': alg['OUTPUT']}
       