import os, configparser,time, traceback, processing, random
from functools import partial
from qgis.PyQt import QtWidgets, QtCore, QtGui

from .fmt_tools import *





class fmtConfigParam():
    
    spatialisationMethod = {
        'qgis.voronoi': {'name':'Escalier', 'indice':3},
        'vsurf.bilinear': {'name':'Bilinéaire', 'indice':1},
        'vsurf.bicubic': {'name':'Bicubique', 'indice':2},
        'vsurf.rst': {'name':'RST', 'indice':0},
        }

    def __init__(self, dock, file):  
        self.dock = dock
        self.file = os.path.join(os.path.dirname(__file__), file)
        self.config = configparser.ConfigParser(allow_no_value=True)   
        self.config.optionxform = str
        self.getDefaultparameters()  
        if not os.path.exists(self.file):        
            for section,d in self.params.items():
                for variable,value in d.items():
                    self.save(variable, value, section, write=False)
            self.write()
        self.config.read(self.file)  
        for section,d in self.params.items():
            for variable,value in d.items():
                self.get(variable, section)
        for s in ['PAINT','EXE','DATAS','REFERENCES']:
            for v in self.config.options(s):
                if v not in self.params[s]:
                    self.config.remove_option(s,v)
        self.write()
        
    def get(self, variable, section=None):
        if section is None:
            section = self.getSectionName(variable)
        if section is None:
            return
        default = self.getDefaultValue(variable, section)
        try: 
            value = self.decode(self.config.get(section, variable))
            if isinstance(default, bool):
                if value in ('false', 'False'):
                    value = False
            value = type(default)(value)
        except : 
            value = default
            self.save(variable, value, section)
        return value
  
    def save(self, variable, value, section=None, write=True):
        if section is None:
            section = self.getSectionName(variable)
        if section is None:
            return  
        if not self.config.has_section(section) and section !='':
            self.config.add_section(section)
        self.setConfig(section, variable, value)
        if section=='DATAS':
            secondSection = self.get('activeSession')
            if secondSection not in (None, ''):
                self.setConfig(secondSection, variable, value)
                
        if write:
            self.write()
        
    def setConfig(self, section, variable, value):
        try:
            self.config.set(section, variable, self.encode(value))
        except:
            pass
            
    def encode(self, value):
        return str(value)
    
    def decode(self, value):
        return value
    
    def write(self):
        f = open(self.file, "w")
        self.config.write(f)
        f.close()
    
    def getSectionName(self, variable):
        for s,d in self.params.items():
            if variable in d: return s
     
    def getSection(self, section):
        return [self.get(p, section) for p in self.config.options(section)]
    
    def getDefaultValue(self, variable, section = None):
        ori = section
        if section is None:
            section = self.getSectionName(variable)
        if section is None:
            return  
        try: return self.params[section][variable]
        except:
            print(variable, "-", section, "-", ori)
            
    
    def openParamSection(self, code):
        dlg = None
        if code=='class':
            dlg = fmtParamClassWindow(self)
        if code=='zi':
            dlg = fmtParamZiWindow(self)
        if code=='zone':
            dlg = fmtParamZoneWindow(self)
        if code=='dict':
            dlg = fmtParamDictWindow(self)
        if dlg and dlg.exec()==QtWidgets.QDialog.DialogCode.Accepted:
            # print('modifier')
            pass
        
    
    def getColorRamp(self, code):
        choice = self.get(f'{code}Choice')
        if choice=='Custom':
            c1 = self.get(f'{code}Min')
            c2 = self.get(f'{code}Max')
            colorRamp = QgsGradientColorRamp(QtGui.QColor(c1),QtGui.QColor(c2))
        else:
            style = QgsStyle().defaultStyle()
            colorRamp = style.colorRamp(choice)
        if colorRamp is None:
            style = QgsStyle().defaultStyle()
            colorRamp = style.colorRamp("Blues")
        return colorRamp
    
    def reinitialisePlugin(self):
        for s in ['EXE']:
            for v in self.params.get(s):
                self.save(v, self.getDefaultValue(v))
         
    def getDefaultparameters(self):
        self.params = {
            'DATAS':{
                'datasFile': '',
                'vectCphe' : '',
                'champCphe' : '',
                'vectDecoup' : '',
                'champDecoup' : '',
                'mnt' : '',
                'rCPHE' : '',
                'hauteurs' : '',
                'vectProjeter' : '',
                'champProjeter' : '',
                'vectAffiner' : '',
                'champAffiner' : '',
            },
            
            'EXE':{
                'activeTab' : 0 ,
                'calcHauteurs' : False,
                'hMinimDefault' : 0.0,
                'hMinimMax' : 10.0,
                'hMinimMin' : -10.0,
                'hMinimUnity': 'cm',
                'hMinimDecimals': 0,
                'useZonage' : True,
                'zoneFieldName': "fmtSpatialisation",
                'zoneFieldComment': "fmtCommentaires",
                'spatAffect' : '',
                'spatRadio' : True,
                'spatMethod' : 'qgis.voronoi',
                'bufferDefault' : 50.0,
                'bufferMax' : 99.0,
                'bufferMin' : 0.0,
                'bufferUnity': 'm',
                'bufferDecimals': 0,
                'rasterDefault' : 0.50,
                'rasterMax' : 20.0,
                'rasterMin' : 0.1,
                'rasterUnity': 'm',
                'rasterDecimals': 1,
                'tamponDefault' : 100.0,
                'tamponMax' : 200.0,
                'tamponMin' : 0.0,
                'tamponUnity': 'm',
                'tamponDecimals': 0,
                'addContour' : False,
                'intervalDefault' : 10.0,
                'intervalMax' : 100.0,
                'intervalMin' : 1.0,
                'intervalUnity': 'cm',
                'projEntryCPHE': True,
                'autoZoneSymbology': True,
                'autoClassSymbology': True,
                'autoEmpriseSymbology': True,
                'followSymbology': True,
                'classes' : '0;0.5;1;1.5;2',
                'classesDefault' : 0,
                'classesMemo' : '0;0.5;1;1.5;2',
                'classesMin' : -9.0,
                'classesMax' : 99.0,
                'classesUnity': 'm',
                'classesDecimals': 1,
                'classesFieldName' : "classes",
                'tamDefault' : 400.0,
                'tamMax' : 999.0,
                'tamMin' : 0.0,
                'tamUnity': 'm',
                'tamDecimals': 0,
                'intervalDecimals': 0,
                'delAlone': False,
                'tamponAloneDefault' : 20.0,
                'tamponAloneMax' : 99.0,
                'tamponAloneMin' : 0,
                'tamponAloneUnity': 'm',
                'tamponAloneDecimals': 1,
                'choixMeth' : 'Majorant',
                'tamponAffDefault' : 3.0,
                'tamponAffMax' : 99.0,
                'tamponAffMin' : 0,
                'tamponAffUnity': 'm',
                'tamponAffDecimals': 1,
                'simplAffDefault' : 3.0,
                'simplAffMax' : 9.0,
                'simplAffMin' : 0.0,
                'simplAffUnity': 'm',
                'simplAffDecimals': 0,
                'lissageAffDefault' : 2,
                'lissageAffMax' : 9,
                'lissageAffMin' : 0,
                'tamisageAffDefault' : 400.0,
                'tamisageAffMax' : 9999.0,
                'tamisageAffMin' : 0.0,
                'tamisageAffUnity': 'm',
                'tamisageAffDecimals': 0,
                'emboitDefault' : 0.0,
                'emboitMax' : 9.0,
                'emboitMin' : -9.0,
                'emboitUnity': 'm',
                'emboitDecimals': 1,
                'FIELD_ORDER' : 'up',
                'CUT' : 'cut',
                'RING' : True,
                'loadZI': False,
                'activeSession' : '',  
                'chainProjeter': False,
                'chainAffiner': False,
                'chainEmboiter': False,
            },
            'REFERENCES':{
                'dictCphe' : 'cphe,value',
                'dictDecoup' : 'spatialisation,fmtspatialisation,affinage',
                'dictClass' : 'classes,class',
            },
            'PAINT':{     
                'icoTab': True,
                'classRampMin': "#000000",
                'classRampMax': "#0000ff",
                'classRampChoice': "Blues",
                'classNoStroke': True,
                'empriseColor': "#0000ff",
                'empriseOpacity': 0.1,
                'empriseWidth': 1.0,
                'zoneColor_qgis.voronoi': "#ff0000",
                'zoneColor_vsurf.bilinear': "#00ff00",
                'zoneColor_vsurf.bicubic': "#0000ff",
                'zoneColor_vsurf.rst': "#ffff00",
                'zoneColor_': "#000000",
                'zoneOpacity': 0.1,
                'zoneWidth': 1.0,
            },
        }
        
        
class fmtParamWindow(QtWidgets.QDialog):
    def __init__(self, param):
        self.param = param
        super().__init__()
        self.setWindowIcon(QtGui.QIcon(os.path.join(os.path.dirname(__file__), "icon.png")))
        self.setWindowTitle(f"Paramétrage")
        l = QtWidgets.QVBoxLayout(self)
        # l.setSpacing(1)
        self.make()
        w = QtWidgets.QPushButton("Fermer")
        w.clicked.connect(self.accept)
        self.layout().addWidget(w)
        
    def make(self):
        pass
        
    def makeBloc(self, title, variable=None):
        if variable:
            w = QtWidgets.QCheckBox(f"{title} :")
            w.code = variable
        else:
            w = QtWidgets.QLabel(f"{title} :")
        font = QtGui.QFont()
        font.setBold(True)
        w.setFont(font)
        self.layout().addWidget(w)
        w2 = QtWidgets.QWidget()
        l = QtWidgets.QFormLayout(w2)
        l.setContentsMargins(20,0,0,20)
        # l.setSpacing(0)
        self.layout().addWidget(w2)
        w.bloc = w2
        if variable:
            w.setChecked(self.param.get(variable))
            w.stateChanged.connect(lambda: self.param.save(variable, w.isChecked()))
            w.stateChanged.connect(partial(self.actuBloc,w))
            self.actuBloc(w)
        return l
        
    def actuBloc(self, w):
        w.bloc.setEnabled(w.isChecked())
        

        
class fmtParamClassWindow(fmtParamWindow):
    def __init__(self, param):
        super().__init__(param)
        self.setWindowTitle(f"Classes de hauteur")
        
    def make(self):
        l = self.makeBloc("Structure")
        classesFieldName = QtWidgets.QLineEdit(self.param.get('classesFieldName'))
        classesFieldName.editingFinished.connect(lambda: self.param.save('classesFieldName', classesFieldName.text()))
        l.addRow("Champ :", classesFieldName)
        
        l = self.makeBloc("Symbologie auto", variable="autoClassSymbology")
        classRampType = QtWidgets.QComboBox()
        for k,v in {
            'Blues': "Bleu",
            'Greens': "Vert",
            'Reds': "Rouge",
            'Custom': "Personnalisé",
        }.items():
            classRampType.addItem(v,k)
        classRampType.setCurrentIndex(classRampType.findData(self.param.get('classRampChoice')))
        classRampType.currentIndexChanged.connect(lambda: self.param.save('classRampChoice', classRampType.currentData()))
        classRampType.currentIndexChanged.connect(self.actuClass)
        l.addRow("Dégradé de ", classRampType)
        
        w = QtWidgets.QWidget()
        h = QtWidgets.QHBoxLayout(w)
        h.setContentsMargins(0,0,0,0)
        l.addRow(w)
        self.classCustom = w
        for b in ('Min','Max'):
            h.addWidget(QtWidgets.QLabel(f"   {b}:"))
            w = fmtClickLabel("     ")
            w.code = b
            w.clicked.connect(partial(self.pickColor, w))
            h.addWidget(w)
            self.actuZone(w)
        
        w = QtWidgets.QWidget()
        h = QtWidgets.QHBoxLayout(w)
        h.setContentsMargins(0,0,0,0)
        l.addRow(w)
        self.classLine = w
        self.actuClass()
        classNoStroke = QtWidgets.QCheckBox("Sans bordure")
        classNoStroke.setChecked(self.param.get('classNoStroke'))
        classNoStroke.stateChanged.connect(lambda: self.param.save('classNoStroke', classNoStroke.isChecked()))
        classNoStroke.stateChanged.connect(self.actuClass)
        l.addRow(classNoStroke)
        followSymbology =  QtWidgets.QCheckBox("Suivre la symbologie précédente")
        followSymbology.setChecked(self.param.get('followSymbology'))
        followSymbology.stateChanged.connect(lambda: self.param.save('followSymbology', followSymbology.isChecked()))
        l.addRow(followSymbology)
            
    def actuClass(self):
        clearLayout(self.classLine.layout())
        self.classCustom.setVisible(self.param.get('classRampChoice')=='Custom')
        colorRamp = self.param.getColorRamp('classRamp')
        nb = max(3,len(self.param.get('classes').split(";")))
        for i in range(nb):
            w = QtWidgets.QLabel(" ")
            color = colorRamp.color(i/max(1,nb-1))
            c = color.name()
            txt = f"background-color:{c};"
            if not self.param.get('classNoStroke'):
                txt += f"border: 1px solid #000000;"
            w.setStyleSheet(txt)
            self.classLine.layout().addWidget(w)

    def actuZone(self, w):
        p = f"classRamp{w.code}"
        c = self.param.get(p)
        w.setStyleSheet(f"background-color:{c}; border: 1px solid #000000;")   
        
    def pickColor(self, w):
        wc = QtWidgets.QColorDialog()
        p = f"classRamp{w.code}"
        c = QtGui.QColor(self.param.get(p))
        wc.setCurrentColor(c)
        if wc.exec() == QtWidgets.QDialog.DialogCode.Accepted:
            self.param.save(p, wc.currentColor().name())
            self.actuZone(w)
            self.actuClass()


class fmtParamZiWindow(fmtParamWindow):
    def __init__(self, param):
        super().__init__(param)
        self.setWindowTitle(f"Emprise totale")

    def make(self):
        l = self.makeBloc("Symbologie auto", variable="autoEmpriseSymbology")
        w = fmtClickLabel("     ")
        w.clicked.connect(partial(self.pickColor, w))
        l.addRow('Couleur', w)
        self.color = w
        self.actu()
        empriseOpacity = QtWidgets.QSlider(QtCore.Qt.Orientation.Horizontal)
        empriseOpacity.setRange(0,100)
        empriseOpacity.setValue(int(self.param.get('empriseOpacity')*100))
        empriseOpacity.valueChanged.connect(lambda: self.param.save('empriseOpacity', empriseOpacity.value()/100))
        empriseOpacity.valueChanged.connect(self.actu)
        l.addRow("Opacité", empriseOpacity)
        empriseWidth = QtWidgets.QSlider(QtCore.Qt.Orientation.Horizontal)
        empriseWidth.setRange(0,30)
        empriseWidth.setValue(int(self.param.get('empriseWidth')*10))
        empriseWidth.valueChanged.connect(lambda: self.param.save('empriseWidth', empriseWidth.value()/10))
        empriseWidth.valueChanged.connect(self.actu)
        l.addRow("Trait", empriseWidth)

    def actu(self):
        p = f"empriseColor"
        o = self.param.get('empriseOpacity')
        c = self.param.get(p)
        t = int(self.param.get('empriseWidth')*2)
        of = str(hex(int(255*o))).replace('0x','')
        cf = c.replace("#",f"#{of}")
        self.color.setStyleSheet(f"background-color:{cf}; border: {t}px solid {c};")  

    def pickColor(self, w):
        wc = QtWidgets.QColorDialog()
        p = f"empriseColor"
        c = QtGui.QColor(self.param.get(p))
        wc.setCurrentColor(c)
        if wc.exec() == QtWidgets.QDialog.DialogCode.Accepted:
            self.param.save(p, wc.currentColor().name())
            self.actu()


class fmtParamZoneWindow(fmtParamWindow):
    def __init__(self, param):
        super().__init__(param)
        self.setWindowTitle(f"Zonage")
        
    def make(self):
        l = self.makeBloc("Structure")
        zoneFieldName = QtWidgets.QLineEdit(self.param.get('zoneFieldName'))
        zoneFieldName.editingFinished.connect(lambda: self.param.save('zoneFieldName', zoneFieldName.text()))
        l.addRow("Champ :", zoneFieldName)
        zoneFieldComment = QtWidgets.QLineEdit(self.param.get('zoneFieldComment'))
        zoneFieldComment.editingFinished.connect(lambda: self.param.save('zoneFieldComment', zoneFieldComment.text()))
        l.addRow("Commentaires :", zoneFieldComment)

        self.zones = {}
        l = self.makeBloc("Symbologie auto", variable="autoZoneSymbology")
        d = {k:v.get('name',k) for k,v in self.param.spatialisationMethod.items()}
        d[''] = 'Aucun'
        for k,v in d.items():
            w = fmtClickLabel("     ")
            w.code = k
            w.clicked.connect(partial(self.pickColor, w))
            l.addRow(v, w)
            self.zones[k] = w
        self.actuZones()
        zoneOpacity = QtWidgets.QSlider(QtCore.Qt.Orientation.Horizontal)
        zoneOpacity.setRange(0,100)
        zoneOpacity.setValue(int(self.param.get('zoneOpacity')*100))
        zoneOpacity.valueChanged.connect(lambda: self.param.save('zoneOpacity', zoneOpacity.value()/100))
        zoneOpacity.valueChanged.connect(self.actuZones)
        l.addRow("Opacité", zoneOpacity)
        zoneWidth = QtWidgets.QSlider(QtCore.Qt.Orientation.Horizontal)
        zoneWidth.setRange(0,30)
        zoneWidth.setValue(int(self.param.get('zoneWidth')*10))
        zoneWidth.valueChanged.connect(lambda: self.param.save('zoneWidth', zoneWidth.value()/10))
        zoneWidth.valueChanged.connect(self.actuZones)
        l.addRow("Trait", zoneWidth)
            
    def actuZone(self, w):
        p = f"zoneColor_{w.code}"
        o = self.param.get('zoneOpacity')
        c = self.param.get(p)
        t = int(self.param.get('zoneWidth')*2)
        of = str(hex(int(255*o))).replace('0x','')
        cf = c.replace("#",f"#{of}")
        w.setStyleSheet(f"background-color:{cf}; border: {t}px solid {c};")            
    def actuZones(self):
        for k,w in self.zones.items():
            self.actuZone(w)
            
    def pickColor(self, w):
        wc = QtWidgets.QColorDialog()
        p = f"zoneColor_{w.code}"
        c = QtGui.QColor(self.param.get(p))
        wc.setCurrentColor(c)
        if wc.exec() == QtWidgets.QDialog.DialogCode.Accepted:
            self.param.save(p, wc.currentColor().name())
            self.actuZone(w)
            
            
class fmtParamDictWindow(fmtParamWindow):
    def __init__(self, param):
        self.sep = ","
        super().__init__(param)
        self.setWindowTitle(f"Dictionnaires")
        self.resize(200,300)

    def make(self):
        for k in self.param.config.options('REFERENCES'):
            w = QtWidgets.QLabel(f"{self.tr(k)} :")
            self.layout().addWidget(w)
            w = QtWidgets.QListWidget()
            w.code = k
            self.layout().addWidget(w)
            w.itemClicked.connect(partial(self.edit, w))
            w.itemChanged.connect(partial(self.save, w))
            self.fill(w)
    
    def fill(self, w):
        w.blockSignals(True)
        w.clear()
        v = self.param.get(w.code)
        w.addItems(v.split(self.sep))
        w.addItem("")
        w.blockSignals(False)
    
    def edit(self, w, it):
        it.setFlags(QtCore.Qt.ItemFlag.ItemIsEditable | QtCore.Qt.ItemFlag.ItemIsEnabled)
        w.editItem(it)
    
    def save(self, w):
        l = []
        for i in range(w.count()):
            txt = w.item(i).text().strip()
            if txt!="":
                l.append(txt)
        v = self.sep.join(l)
        if self.param.get(w.code)!=v:
            self.param.save(w.code, v)
            self.fill(w)
    
    def tr(self, k):
        d = {
            'dictCphe' : 'CPHE',
            'dictDecoup' : 'Zonage',
            'dictClass' : 'Classes de hauteur',
        }
        return d.get(k,k)
