# -*- coding: utf-8 -*-
import sys, os
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingUtils,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterDistance,
                       QgsUnitTypes,
                       QgsProcessingParameterFeatureSink
                       )
from qgis import processing


class DeleteAloneProcessingAlgorithm(QgsProcessingAlgorithm):

    INPUT = 'INPUT'
    OVERLAY = 'OVERLAY'
    TOLERANCE = 'TOLERANCE'
    OUTPUT = 'OUTPUT'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return DeleteAloneProcessingAlgorithm()

    def name(self):
        return 'deletealone'

    def displayName(self):
        return self.tr('Supprimer les zones isolées')

    def group(self):
        return self.tr('Scripts')

    def groupId(self):
        return 'scripts'

    def shortHelpString(self):
        return self.tr("Supprime les polygones qui ne superposent pas la couche cible avec une tolérance donnée")

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource(self.INPUT, 'Vecteur source', defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSource(self.OVERLAY, 'Couche de superposition', defaultValue=None))
        distance = QgsProcessingParameterDistance(self.TOLERANCE, 'Tolérance', defaultValue=20)
        distance.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        self.addParameter(distance)
        self.addParameter(QgsProcessingParameterFeatureSink(self.OUTPUT, 'Vecteur nettoyé', createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, feedback):
        
        print(parameters)

        alg = processing.run('native:dissolve', {
                'FIELD': None,
                'INPUT': parameters[self.INPUT],
                'SEPARATE_DISJOINT': True,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }, context=context, feedback=feedback, is_child_algorithm=True)

        alg = processing.run("native:multiparttosingleparts", {
                'INPUT': alg['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }, context=context, feedback=feedback, is_child_algorithm=True)
            
        
        alg2 = processing.run('native:buffer', {
                'DISSOLVE': True,
                'DISTANCE': parameters[self.TOLERANCE],
                'END_CAP_STYLE': 0,  # Rond
                'INPUT': parameters[self.OVERLAY],
                'JOIN_STYLE': 0,  # Rond
                'MITER_LIMIT': 2,
                'SEGMENTS': 5,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }, context=context, feedback=feedback, is_child_algorithm=True)
        
        
        alg = processing.run('native:extractbylocation', {
                'INPUT': alg['OUTPUT'],
                'INTERSECT': alg2['OUTPUT'],
                'PREDICATE': [0], 
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }, context=context, feedback=feedback, is_child_algorithm=True)
            
        alg = processing.run('native:clip', {
                'INPUT': parameters[self.INPUT],
                'OVERLAY': alg['OUTPUT'],
                'OUTPUT': parameters[self.OUTPUT]
            }, context=context, feedback=feedback, is_child_algorithm=True)
        

        return {self.OUTPUT:alg['OUTPUT']}






