from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterString
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterNumber
try:  from qgis.core import QgsProcessingParameterArea
except: pass
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingException
from qgis.core import QgsRasterLayer
from qgis.core import QgsUnitTypes
from qgis.PyQt.QtCore import QCoreApplication
from qgis import processing

import os, tempfile

class ClassVectorisationProcessingAlgorithm(QgsProcessingAlgorithm):
    def name(self):
        return 'classvectorisation'

    def displayName(self):
        return self.tr('Vectoriser par classe')

    def tr(self, string):
        return QCoreApplication.translate('Vectorising', string)

    def shortHelpString(self):
        return """<html><body><p>Cet algorithme crée une couche vecteur contenant toutes les classes de hauteurs d'eau renseignées dans "classes" à partir d'un MNT</p>
<br></body></html>"""

    def group(self):
        return self.tr('Scripts')

    def groupId(self):
        return 'scripts'

    def createInstance(self):
        return ClassVectorisationProcessingAlgorithm()

    NUMBERS = 'NUMBERS'
    file_null = os.path.join(tempfile.gettempdir(), 'null.tif')

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterRasterLayer('hauteurs', 'Raster des hauteurs d\'eau', defaultValue=None))
        self.addParameter(QgsProcessingParameterString(self.NUMBERS,'Classes (séparer les valeurs par un ";")',defaultValue='0;0.5;1;1.5;2'))
        self.addParameter(QgsProcessingParameterFeatureSink('output', 'Classes de Hauteur', createByDefault=True, defaultValue=None))
        
        
        
        try:
            param = QgsProcessingParameterArea('tamisage', 'Tamisage :', minValue=0, defaultValue=400)
            param.setDefaultUnit(QgsUnitTypes.AreaSquareMeters )
        except:
            param = QgsProcessingParameterNumber('tamisage', 'Tamisage (m²) :', minValue=0, defaultValue=400)
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
        param = QgsProcessingParameterString('field','Nom du champs',defaultValue='classes')
        param.setFlags(QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
       
    def chemin(self):
        chem= tempfile.gettempdir()
        file_null = os.path.join(chem, 'null.tif')
        return file_null
		
		
    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        results = {}
        vectors = []
        v=0
        # L=sorted(parameters[self.NUMBERS].split(';'))


        liste = parameters[self.NUMBERS].split(';')
        # L = list(map(float, liste))
        try: L = list(map(float, liste))
        except Exception as e: raise QgsProcessingException(f"Donnée invalide pour Classes={parameters[self.NUMBERS]}: {e}")
            
        L.sort()
        
        feedback = QgsProcessingMultiStepFeedback(12, model_feedback)
        
        # calculate datas from raster hauteurs
        alg = processing.run('native:rasterlayerproperties', 
            {
                'INPUT': parameters['hauteurs']
            }, context=context, feedback=feedback, is_child_algorithm=True)
        parameters['rasterSize'] = min(alg['PIXEL_WIDTH'],alg['PIXEL_HEIGHT'])
        parameters['threshold'] = int(parameters['tamisage']/(alg['PIXEL_WIDTH']*alg['PIXEL_HEIGHT']))
        
        for i in L:
            v=v+1            
            status, layer = self.createclass(parameters, context, feedback, i,v)
            
            if status=='cancel':
                return {}
                return layer
            vectors.append(layer)
            
            feedback.setCurrentStep(11)           
            if feedback.isCanceled():
                return 'cancel', None
            
        alg = processing.run('native:mergevectorlayers', 
            {
            'LAYERS': vectors,
            'OUTPUT': parameters['output']
            }, 
            context=context, feedback=feedback, is_child_algorithm=True)
            
        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return 'cancel', None
            
        # os.remove(self.chemin())          impossible: blocage pendant l'exécution du script.       
        return {'output': alg['OUTPUT']}

    def createclass(self, parameters, context, feedback, i,v):
        
        status = 'ok'

        # Créer une couche raster constante
        alg_params = {
            'EXTENT': parameters['hauteurs'],
            'NUMBER': i,
            'OUTPUT_TYPE': 5,  # Float32
            'PIXEL_SIZE': parameters['rasterSize'],
            'TARGET_CRS': 'ProjectCrs',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:createconstantrasterlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)     
        
        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return 'cancel', None
        
        # r.mapcalc.simple1
        alg_params = {
            'GRASS_RASTER_FORMAT_META': '',
            'GRASS_RASTER_FORMAT_OPT': '',
            'GRASS_REGION_CELLSIZE_PARAMETER': 0,
            'GRASS_REGION_PARAMETER': '',
            'a': parameters['hauteurs'],
            'b': alg['OUTPUT'],
            'c': None,
            'd': None,
            'e': None,
            'expression': '(A>B)',
            'f': None,
            'output': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('grass7:r.mapcalc.simple', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return 'cancel', None
           
        # r.null
        alg_params = {
            '-c': False,
            '-f': False,
            '-i': False,
            '-n': False,
            '-r': False,
            'GRASS_RASTER_FORMAT_META': '',
            'GRASS_RASTER_FORMAT_OPT': '',
            'GRASS_REGION_CELLSIZE_PARAMETER': 0,
            'GRASS_REGION_PARAMETER': None,
            'map': alg['output'],
            'null': 0,
            'setnull': '',
            'output': self.chemin()
            # 'output': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('grass7:r.null', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return 'cancel', None
        
        # return 'temp', {'output':alg['output']}
        
        
        
         # Tamiser
        alg_params = {
            'EIGHT_CONNECTEDNESS': False,
            'EXTRA': '',
            'INPUT': self.chemin(),
            'MASK_LAYER': None,
            'NO_MASK': False,
            'THRESHOLD': parameters['threshold'],
            'OUTPUT':  QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('gdal:sieve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return 'cancel', None
            
        # r.to.vect
        alg_params = {
            '-b': False,
            '-s': True,
            '-t': False,
            '-v': False,
            '-z': False,
            'GRASS_OUTPUT_TYPE_PARAMETER': 0,  # auto
            'GRASS_REGION_CELLSIZE_PARAMETER': 0,
            'GRASS_REGION_PARAMETER': None,
            'GRASS_VECTOR_DSCO': '',
            'GRASS_VECTOR_EXPORT_NOCAT': False,
            'GRASS_VECTOR_LCO': '',
            'column': 'value',
            'input': alg['OUTPUT'],
            'type': 2,  # area
            'output': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('grass7:r.to.vect', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return 'cancel', None

        # Extraire par attribut
        alg_params = {
            'FIELD' : 'value',
            'INPUT':  alg['output'],
            'OPERATOR': 0,  # =
            'VALUE': 1,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True) 
    
        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return 'cancel', None

         # Réparer les géométries
        alg_params = {
            'INPUT': alg['OUTPUT'],
            'METHOD': 1,  # Structure
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:fixgeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return 'cancel', None

        # return 'temp', {'output':alg['OUTPUT']}  
         # Regrouper
        alg_params = {
            'FIELD': '',
            'INPUT': alg['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:collect', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return 'cancel', None
            
        # Calculatrice de champ
        alg_params = {
            'FIELD_LENGTH': 6,
            'FIELD_NAME': parameters['field'],
            'FIELD_PRECISION': 6,
            'FIELD_TYPE': 0,  # Décimal (double)
            'FORMULA': i,
            'INPUT':  alg['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return 'cancel', None
        
         # Supprimer champ(s)
        alg_params = {
            'COLUMN':['fid'],
            'INPUT': alg['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        alg = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        feedback.setCurrentStep(10)
        
        return status, alg['OUTPUT']