from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterDistance
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsUnitTypes
from qgis.core import QgsVectorLayer
from qgis.core import QgsProcessingUtils
from qgis.core import QgsFeatureSink
from qgis.core import QgsWkbTypes


from qgis.PyQt.QtCore import QCoreApplication

from qgis.core import QgsProcessingContext
import processing

class MntProjectionProcessingAlgorithm(QgsProcessingAlgorithm):

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
        
    def name(self):
        return 'mntprojection'

    def displayName(self):
        return 'Projection CPHE sur MNT'

    def group(self):
        return self.tr('Scripts')

    def groupId(self):
        return 'scripts'

    def shortHelpString(self):
        return """<html><body><p>Cet algorithme projète une couche raster contenant des données spatiales sur un Modèle Numérique de Terrain (MNT)</p>
<br></body></html>"""

    def createInstance(self):
        return MntProjectionProcessingAlgorithm()
    
    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterRasterLayer('CPHE', 'Cotes des Plus Hautes Eau', defaultValue=None))
        distance = QgsProcessingParameterDistance('hmin', 'Hauteur minimale de la sortie(m)', defaultValue=0)
        distance.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        self.addParameter(distance)
        # rasterSize = QgsProcessingParameterDistance('rasterSize', f"Taille d'une cellule Raster", defaultValue=0.5)
        # rasterSize.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        # self.addParameter(rasterSize)
        self.addParameter(QgsProcessingParameterRasterLayer('mnt', 'MNT', defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterDestination('output', 'Raster des hauteurs supérieure à la hauteur minimale', createByDefault=True, defaultValue=None))
        
    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(6, model_feedback)
        nicenames = {
            'output': "Hauteurs",
        }   
        results = {}
        outputs = {}
        
        a1 = processing.run('native:rasterlayerproperties', 
            {
                'INPUT': parameters['CPHE']
            }, context=context, feedback=feedback, is_child_algorithm=True)
        a2 = processing.run('native:rasterlayerproperties', 
            {
                'INPUT': parameters['mnt']
            }, context=context, feedback=feedback, is_child_algorithm=True)    
        rasterSize = min(a1['PIXEL_WIDTH'],a1['PIXEL_HEIGHT'],a2['PIXEL_WIDTH'],a2['PIXEL_HEIGHT'])
        
        # Créer une couche raster constante
        alg_params = {
            'EXTENT': parameters['CPHE'],
            'NUMBER': parameters['hmin'],
            'OUTPUT_TYPE': 5,  # Float32
            'PIXEL_SIZE': rasterSize,
            'TARGET_CRS': 'ProjectCrs',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        RasterConstant = processing.run('native:createconstantrasterlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)  

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return 'cancel', None     
            
         # MNT_masque
        alg_params = {
            'DATA_TYPE': 6,  # Float32
            'EXTRA': '',
            'INPUT': parameters['mnt'],
            'NODATA': None,
            'OPTIONS': '',
            'OVERCRS': False,
            'PROJWIN': parameters['CPHE'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        masque = processing.run('gdal:cliprasterbyextent', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return 'cancel', None
                    
        
        # print('in0', masque['OUTPUT'], parameters['CPHE'])
        
        # r.mapcalc.simple1
        alg_params = {
            'GRASS_RASTER_FORMAT_META': '',
            'GRASS_RASTER_FORMAT_OPT': '',
            'GRASS_REGION_CELLSIZE_PARAMETER': 0,
            'GRASS_REGION_PARAMETER':parameters['CPHE'],
            'a': parameters['CPHE'],
            'b': masque['OUTPUT'],
            'c': None,
            'd': None,
            'e': None,
            'expression': 'A-B',
            'f': None,
            'output': QgsProcessing.TEMPORARY_OUTPUT
        }
        MNTDecoup = processing.run('grass7:r.mapcalc.simple', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        # return {'output':outputs['Rmapcalcsimple1']['output']}
        
        # print('in1', MNTDecoup['output'])
        
        
        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return 'cancel', None      
        
        # r.mapcalc.simple2
        alg_params = {
            'GRASS_RASTER_FORMAT_META': '',
            'GRASS_RASTER_FORMAT_OPT': '',
            'GRASS_REGION_CELLSIZE_PARAMETER': 0,
            'GRASS_REGION_PARAMETER': None,
            'a': MNTDecoup['output'],
            'b': RasterConstant['OUTPUT'],
            'c': None,
            'd': None,
            'e': None,
            'expression': 'A>B',
            'f': None,
            'output': QgsProcessing.TEMPORARY_OUTPUT
        }
        MNTSupX = processing.run('grass7:r.mapcalc.simple', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        # return {'output':outputs['Rmapcalcsimple2']['output']} 
        # print('in2', MNTSupX['output'])
        
        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return 'cancel', None
            
        # Convertir
        alg_params = {
            'COPY_SUBDATASETS': False,
            'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
            'EXTRA': '',
            'INPUT': MNTSupX['output'],
            'NODATA': 0,
            'OPTIONS': '',
            'TARGET_CRS': None,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        reprojeter = processing.run('gdal:translate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        # return {'output':outputs['Convertir']['OUTPUT']}

        
        # print(context.getMapLayer(reprojeter['OUTPUT']))
        print('output', reprojeter['OUTPUT'])
        
        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return 'cancel', None
            
        # r.mapcalc.simple3
        alg_params = {
            'GRASS_RASTER_FORMAT_META': '',
            'GRASS_RASTER_FORMAT_OPT': '',
            'GRASS_REGION_CELLSIZE_PARAMETER': 0,
            'GRASS_REGION_PARAMETER': None,
            'a': MNTDecoup['output'],
            'b': reprojeter['OUTPUT'],
            'c': None,
            'd': None,
            'e': None,
            'expression': 'A*B',
            'f': None,
            'output': parameters['output']
        }
        hauteurs = processing.run('grass7:r.mapcalc.simple', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
             
        results['output'] = hauteurs['output']
        
        details = context.layerToLoadOnCompletionDetails(results['output'])
        details.name = nicenames.get('output',details.name)
        details.forceName = True
        
        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return 'cancel', None
        
        return results