from qgis.PyQt import QtWidgets, QtCore, QtGui
from .fmt_tools import *
import traceback

class fmtSession(QtWidgets.QWidget):
    def __init__(self, dock):
        super().__init__()
        self.dock = dock
        self.params = dock.params
        l = QtWidgets.QVBoxLayout(self)
        l.setContentsMargins(0,0,0,0)
        w = QtWidgets.QWidget()
        self.choiceWidget = w
        self.layout().addWidget(w)
        l = QtWidgets.QHBoxLayout(w)
        l.setContentsMargins(0,0,0,0)
        w = QtWidgets.QLabel("Active : ")
        w.setMaximumWidth(60)
        l.addWidget(w)
        w = QtWidgets.QComboBox()
        l.addWidget(w)
        self.comboSession = w
        self.comboSession.currentTextChanged.connect(lambda: self.setSession(self.comboSession.currentText()))
        w = fmtClickLabel()
        w.setMaximumWidth(20)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"add.png"))
        w.setPixmap(ico.pixmap(20,20))
        w.setToolTip("Ajouter") 
        l.addWidget(w) 
        w.clicked.connect(self.addclick)
        

        
        w = QtWidgets.QWidget()
        self.editWidget = w
        self.layout().addWidget(w)
        l = QtWidgets.QHBoxLayout(w)
        l.setContentsMargins(0,0,0,0)
        w = QtWidgets.QLabel("Créer : ")
        w.setMaximumWidth(60)
        l.addWidget(w)
        self.comboSession.edit = QtWidgets.QLineEdit()
        self.comboSession.edit.setPlaceholderText("Nom de la nouvelle session")
        l.addWidget(self.comboSession.edit)
        self.comboSession.edit.returnPressed.connect(self.add)
        w = fmtClickLabel()
        w.setMaximumWidth(20)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"close.png"))
        w.setPixmap(ico.pixmap(20,20))
        w.setToolTip("Annuler") 
        l.addWidget(w) 
        w.clicked.connect(self.cancel)        
                  
        
        w = QtWidgets.QWidget()
        self.layout().addWidget(w)
        l = QtWidgets.QVBoxLayout(w)
        l.setContentsMargins(0,0,0,0)  
        l.setSpacing(0)           
        self.listeSession = w
        
        self.sessionName = None
        
        self.paint()
        self.askLoad()
        
    def paint(self):
        self.comboSession.blockSignals(True)
        self.comboSession.clear()
        clearLayout(self.listeSession.layout())
        self.comboSession.addItem("", None)
        for n in sorted(self.sessionList()):
            self.comboSession.addItem(n,n)
            w = fmtEditSession(n, params=self.params, active=(n==self.sessionName))
            w.sessionChange.connect(self.setSession)
            w.sessionDelete.connect(self.delete)
            w.sessionRename.connect(self.rename)
            self.listeSession.layout().addWidget(w)
        self.showComboEdit(False)    
        if self.sessionName:
            self.comboSession.setCurrentText(self.sessionName)
            self.dock.setWindowTitle(f"{self.dock.plugin.pluginName} - {self.sessionName}")
        else:
            self.dock.setWindowTitle(self.dock.plugin.pluginName)
        self.comboSession.blockSignals(False)
        
    def setSession(self, name):
        self.params.save('activeSession', name)
        if name not in (None,""):
            self.copySession(name,'DATAS')
        else:
            for k in self.params.config.options('DATAS'):
                self.params.save(k, '', 'DATAS')
        self.loadActiveDatas()
       
    
    def addclick(self):
        self.comboSession.edit.clear()
        self.showComboEdit(True)
        self.comboSession.edit.setFocus()
    
    def showComboEdit(self, b):
        self.choiceWidget.setVisible(not b)
        self.editWidget.setVisible(b)
    
    def askLoad(self):
        has = False
        if not 'DATAS' in self.params.config.sections():
            return
        for v in self.params.getSection('DATAS'):
            if v!="":
                has = True
                break
        if has:
            self.dock.topWidget.layout().addWidget(self.getAskWidget())
        
    def getAskWidget(self):
        w = QtWidgets.QWidget()
        self.askWidget = w
        h = QtWidgets.QHBoxLayout(w)
        h.setContentsMargins(0,0,0,0)
        w = QtWidgets.QLabel("Recharger les données ?")
        h.addWidget(w)
        w = QtWidgets.QPushButton("Oui")
        h.addWidget(w)
        w.clicked.connect(self.loadActiveDatas)
        w = QtWidgets.QPushButton("Non")
        h.addWidget(w)
        w.clicked.connect(self.deleteAskWidget)
        return self.askWidget
       
    def deleteAskWidget(self):
        try: self.askWidget.parent().layout().removeWidget(self.askWidget)
        except: 
            print(traceback.format_exc())
            pass
    
    def loadActiveDatas(self):
        self.deleteAskWidget()
        self.sessionName = self.params.get('activeSession')
        self.paint()
        for w in (self.dock.coucheCPHE, 
                  self.dock.coucheDecoup, 
                  self.dock.vectProjeter, 
                  self.dock.vectAffiner, 
                  self.dock.rCPHE, 
                  self.dock.hauteurs, 
                  self.dock.mntSpat):
            # w.initValue(group=self.sessionName)
            w.initValue()
            
    def copySession(self, ori, dest):
        if not self.params.config.has_section(dest):
            self.params.config.add_section(dest)
        for k,v in self.params.config.items(ori):
            self.params.save(k, v, dest)
    
    def sessionList(self) :
        e = self.params.config.sections()
        for i in ['PAINT','EXE','DATAS','REFERENCES']:
            if i in e:
                e.remove(i)
        return e
    
    def add(self):
        self.showComboEdit(False)
        name = self.comboSession.edit.text().strip()
        if name.lower not in ("", "datas"):
            self.copySession('DATAS', name)
            self.sessionName = name
            self.params.save('activeSession', name)
            self.paint()
        
    def cancel(self):
        self.showComboEdit(False)
        

    def delete(self, name):
        self.params.config.remove_section(name)
        self.params.write()
        if self.params.get('activeSession')==name:
            self.sessionName = None
            self.params.save('activeSession', '')
        self.paint()
        
    def rename(self, old, new):
        if new.lower() not in ("", "datas", old.lower()):
            self.copySession(old, new)
            if self.params.get('activeSession')==old:
                self.sessionName = new
                self.params.save('activeSession', new)
            self.params.config.remove_section(old)
            self.params.write()
            self.paint()


     
class fmtEditSession(QtWidgets.QWidget):
    sessionDelete = QtCore.pyqtSignal(str)
    sessionRename = QtCore.pyqtSignal(str, str)
    sessionChange = QtCore.pyqtSignal(str)
    def __init__(self, name = "", params=None, active=False):
        super().__init__()
        self.params = params
        self.name = name
        self.active = active
        mainLayout = QtWidgets.QVBoxLayout(self) 
        mainLayout.setContentsMargins(0,0,0,5)
        mainLayout.setSpacing(0)    

        self.view = QtWidgets.QWidget()
        viewLayout = QtWidgets.QHBoxLayout(self.view)
        viewLayout.setContentsMargins(0,0,0,0)  
        viewLayout.setSpacing(0)      
        self.sessionImg = fmtClickLabel("", hovered=not active)
        self.sessionImg.setMaximumWidth(22)
        # self.ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"upload.png"))
        # self.sessionImg.setPixmap(self.ico.pixmap(15,15))
        self.sessionName = fmtClickLabel(self.name, hovered=not active)
        self.sessionName.enterOverflown.connect(self.hoveredEnter) 
        self.sessionImg.enterOverflown.connect(self.hoveredEnter)
        self.sessionName.leaveOverflown.connect(self.hoveredLeave)
        self.sessionImg.leaveOverflown.connect(self.hoveredLeave)
        if active:
            self.hoveredEnter(ico=QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"plug.png")))
        else:
            self.sessionImg.clicked.connect(self.uploadFunction)
            self.sessionName.clicked.connect(self.uploadFunction)
        
        rename = fmtClickLabel()            
        rename.setMaximumWidth(20)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"modify.png"))
        rename.setPixmap(ico.pixmap(20,20))
        rename.clicked.connect(partial(self.renameFunction, delete = False))
        delete = fmtClickLabel() 
        delete.setMaximumWidth(20)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"delete.png"))
        delete.setPixmap(ico.pixmap(20,20))
        delete.clicked.connect(self.renameFunction)   
        viewLayout.addWidget(self.sessionImg)
        viewLayout.addWidget(self.sessionName)
        viewLayout.addWidget(rename)
        viewLayout.addWidget(delete)
        mainLayout.addWidget(self.view)
       
        self.edit = QtWidgets.QWidget()
        editLayout = QtWidgets.QHBoxLayout(self.edit)
        editLayout.setContentsMargins(0,0,0,0)  
        editLayout.setSpacing(0)      
        self.editLabel = QtWidgets.QLineEdit(self.name)
        oke = fmtClickLabel()
        oke.setMaximumWidth(20)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"ok.png"))
        oke.setPixmap(ico.pixmap(20,20))
        oke.clicked.connect(partial(self.validateClicked, delete = False))
        self.editLabel.returnPressed.connect(partial(self.validateClicked, delete = False))
        koe = fmtClickLabel()
        koe.setMaximumWidth(20)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"ko.png"))
        koe.setPixmap(ico.pixmap(20,20))
        koe.clicked.connect(self.cancelClicked)
        editLayout.addWidget(self.editLabel)
        editLayout.addWidget(oke)
        editLayout.addWidget(koe)   
        mainLayout.addWidget(self.edit)        
        self.edit.hide()
        
        
        self.delete = QtWidgets.QWidget()
        deleteLayout = QtWidgets.QHBoxLayout(self.delete)
        deleteLayout.setContentsMargins(0,0,0,0)  
        self.deleteLabel = QtWidgets.QLabel(f"Supprimer  {self.name} ?")
        font = QtGui.QFont()
        font.setBold(True)
        self.deleteLabel.setFont(font)
        ok = fmtClickLabel()
        ok.setMaximumWidth(20)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"ok.png"))
        ok.setPixmap(ico.pixmap(20,20))
        ok.clicked.connect(self.validateClicked)
        ko = fmtClickLabel()
        ko.setMaximumWidth(20)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"ko.png"))
        ko.setPixmap(ico.pixmap(20,20))
        ko.clicked.connect(self.cancelClicked)
        deleteLayout.addWidget(self.deleteLabel)
        deleteLayout.addWidget(ok)
        deleteLayout.addWidget(ko)   
        mainLayout.addWidget(self.delete)        
        self.delete.hide()
    
    def hoveredEnter(self, ico=None):
        if not ico: ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"upload.png"))
        self.sessionImg.setPixmap(ico.pixmap(18,18))
        font = QtGui.QFont()
        font.setBold(True)
        self.sessionName.setFont(font)
        
    def hoveredLeave(self):
        ico = QtGui.QIcon()
        self.sessionImg.setPixmap(ico.pixmap(15,15))
        font = QtGui.QFont()
        font.setBold(False)
        self.sessionName.setFont(font)
        
    def uploadFunction(self) :
        self.sessionChange.emit(self.name)
        
    def renameFunction(self, delete = True):
        self.view.hide()
        if delete : self.delete.show()
        else  :  self.edit.show()
        
    
    def validateClicked(self, delete = True):
        if delete :         
            self.sessionDelete.emit(self.name)
        else :
            self.sessionRename.emit(self.name, self.editLabel.text())
        self.edit.hide()
        self.delete.hide()
        self.view.show()
        
    def cancelClicked(self):
        self.edit.hide()
        self.delete.hide()
        self.view.show()