from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os

from .branchConnect import BranchConnectProcessingAlgorithm
from .multilineInterpolation import LinearInterpolationProcessingAlgorithm
from .cpheSpatialisation import CpheSpatialisationProcessingAlgorithm
from .mntProjection import MntProjectionProcessingAlgorithm
from .classVectorisation import ClassVectorisationProcessingAlgorithm
from .classRasterisation import ClassRasterisationProcessingAlgorithm
from .classProjection import ClassProjectionProcessingAlgorithm
from .refinePolygon import RefinePolygonProcessingAlgorithm
from .russianDolls import RussianDollsProcessingAlgorithm
from .ringToDisk import RingToDiskProcessingAlgorithm
from .diskToRing import DiskToRingProcessingAlgorithm
from .safePatch import SafePatchProcessingAlgorithm

#ALGO EN TEST
from .TEST.CpheSpatialisation_test import cphespatialisationtest



class ProcessingProvider(QgsProcessingProvider):
    def loadAlgorithms(self):
        # Etapes
        self.addAlgorithm(CpheSpatialisationProcessingAlgorithm())
        self.addAlgorithm(ClassProjectionProcessingAlgorithm())
        self.addAlgorithm(RefinePolygonProcessingAlgorithm())
        self.addAlgorithm(RussianDollsProcessingAlgorithm())
        # Outils
        self.addAlgorithm(BranchConnectProcessingAlgorithm())
        self.addAlgorithm(LinearInterpolationProcessingAlgorithm())
        self.addAlgorithm(MntProjectionProcessingAlgorithm())  
        self.addAlgorithm(ClassVectorisationProcessingAlgorithm())
        self.addAlgorithm(ClassRasterisationProcessingAlgorithm()) 
        self.addAlgorithm(RingToDiskProcessingAlgorithm())  
        self.addAlgorithm(DiskToRingProcessingAlgorithm())  
        self.addAlgorithm(SafePatchProcessingAlgorithm())  

        #TEST
        # self.addAlgorithm(cphespatialisationtest())
        
        
    def icon(self):
        plugin_dir = os.path.dirname(os.path.dirname(__file__))  
        icon_path = os.path.join(plugin_dir, "icon.png")
        return QIcon(icon_path) 
        
    def id(self):
        return "fmt"
     
    def name(self):
        return "FloodMapTools"
        
        
