# -*- coding: utf-8 -*-
import sys
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterBoolean)
from qgis import processing
import time, threading, multiprocessing
multiprocessing.set_start_method("spawn",force = True)


class testAsync(QgsProcessingAlgorithm):


    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return testAsync()

    def name(self):
        return 'testAsync'

    def displayName(self):
        return self.tr('testAsync')




    def initAlgorithm(self, config=None):
        self.addParameter(
            QgsProcessingParameterBoolean(
                'async',
                'Asyncherone',
                defaultValue=True
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                'nb',
                'Nombre',
                defaultValue=3
            )
        )
        

    def processAlgorithm(self, parameters, context, feedback):
        threads = list()
        for i in range(parameters['nb']):
            
            feedback.pushInfo(f"Main    : create and start {i}")
            if parameters['async']:


                t = multiprocessing.Process(target=self.thread_function, args=(i,parameters['nb']))
                print(t)
                # t = ReturnableThread(target=self.thread_function, args=(i,parameters['nb']))
                t.start()
                threads.append(t)
            else:
                self.thread_function(i, parameters['nb'])
            
        if parameters['async']:    
            feedback.pushInfo(f"Tout est lancé et ça dure le temps que ça dure")
            for i,t in enumerate(threads):
                # t.join()
                feedback.pushInfo(f"Main    : thread {i} done")    
        
        feedback.pushInfo(f"Tout est fini et je peux lancer l'assemblage de mes résultats")
        # print(target)
        return {}

    def thread_function(self, i, nb):
        for j in range(nb):
            time.sleep(nb*(i+j))
            print(f"la fonction {i} travaille...")
        




##########################################################
#### Et voilà un bout de code que tu peux utiliser pour faire objet thread qui contiendra tes résultats d'exécution

class ReturnableThread(multiprocessing.Process):
    # This class is a subclass of Thread that allows the thread to return a value.
    def __init__(self, target):
        Process.__init__(self)
        self.target = target
        self.result = None
    
    def run(self) -> None:
        self.result = self.target()


class ReturnableThread2(threading.Thread):
    # This class is a subclass of Thread that allows the thread to return a value.
    def __init__(self, target):
        Thread.__init__(self)
        self.target = target
        self.result = None
    
    def run(self) -> None:
        self.result = self.target()




