# -*- coding: utf-8 -*-
from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterDistance
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsUnitTypes
from qgis.core import QgsVectorLayer
from qgis.core import QgsProcessingUtils
from qgis.core import QgsFeatureSink
from qgis.core import QgsWkbTypes
import processing, time



class findoutliers(QgsProcessingAlgorithm):


 def name(self):
        return 'findoutliers'

    def displayName(self):
        return 'Trouver les valeurs aberrantes '



    def shortHelpString(self):
        return """<html><body><p>Cet algorithme trouve les valeurs de vos fichiers vectoriels qui semblent être incohérantes </p>
<br></body></html>"""

    def createInstance(self):
        return findoutliers()

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('cotes_des_plus_hautes_eau', 'Cotes des Plus Hautes Eau', types=[QgsProcessing.TypeVectorAnyGeometry], defaultValue=None))
        self.addParameter(QgsProcessingParameterField('champCPHE', 'Champ contenant la valeur de la CPHE', type=QgsProcessingParameterField.Numeric, parentLayerParameterName='cotes_des_plus_hautes_eau', allowMultiple=False, defaultValue=None))    
        param = QgsProcessingParameterDistance('buffer', 'Taille du tampon', parentParameterName='cotes_des_plus_hautes_eau', defaultValue=100)
        
        param.setDefaultUnit(QgsUnitTypes.DistanceMeters)
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
     

    def processAlgorithm(self, parameters, context, feedback):
    #l'idée est de faire un tampon d'une couche de points et de bouclé sur chaque entitée du tampon pour voir si les valeurs
    # entre les points issue du même tampon sont très éloigné, si c'est le cas on les garde sinon on supprime les points et on continue 
    # ca donnera une couche de points abérants 
        
        
    # Idée 2 : bosser avec les isocotes, si une geometrie est fermé c'est étrange, modèle sans puits/production
        return {}