from qgis.PyQt import QtCore
from qgis.core import (QgsProject,
                    QgsApplication,
                    QgsMapLayerProxyModel,
                    QgsProcessing,
                    QgsVectorLayer,
                    QgsRasterLayer,
                    QgsField,
                    QgsGeometry,
                    QgsFeature,
                    QgsProcessingParameterRasterDestination,
                    QgsProcessingFeatureSourceDefinition,
                    QgsEditorWidgetSetup,
                    QgsMapLayer,
                    QgsVectorLayerCache,
                    QgsFeatureRequest,
                    QgsProcessingContext,
                    QgsProcessingFeedback,
                    QgsWkbTypes,
                    QgsProcessingAlgRunnerTask,
                    QgsTask,
                    QgsProcessingAlgorithm,
                    QgsProcessingUtils,
                    QgsFeatureSink,
                    Qgis
                    )

from qgis import processing
from qgis.gui import QgsMessageBar
import configparser,time, traceback, processing, os
from functools import partial

class launchMultiprocessing(QtCore.QObject) :
    finished = QtCore.pyqtSignal(str, dict)
    def __init__(self, dock, **kw):
        super().__init__()
        self.dock = dock
        self.iface = dock.iface
        self.crs = QgsProject.instance().crs()
        self.task = {}
        self.idTask = 0
        self.parallele = False
        
        self.noAffichage = kw.get('noAffichage')

    def newId(self):
        self.idTask += 1
        return self.idTask
        
    
    def run (self, alg, params, **kwargs):
        context = kwargs.get('context', QgsProcessingContext())
        context.setProject(QgsProject.instance())
        feedback = kwargs.get('feedback', QgsProcessingFeedback())

        if alg == 'spatialisation':
            self.spatialisation(alg, params, context, feedback)
        elif alg == 'projection' :
            self.projection(alg, params, context, feedback)
        elif alg == 'projectionSensitiveInitiale' :
            self.projectionSensitiveInitiale(alg, params, context, feedback)
        elif alg == 'projectionSensitiveEnchaine' :
            self.projectionSensitiveEnchaine(alg, params, context, feedback)
        elif alg == 'affinage' : 
            self.affinage(alg, params, context, feedback)
        elif alg == 'emboiter':
            self.emboiter(alg, params, context, feedback)
      

    
    def spatialisation(self, name, params, context, feedback):
        results = {}
        dep = []
        id = self.newId()
        self.task[id] = fmtTask(name = name)
        results['res_spat'] =  QgsProcessing.TEMPORARY_OUTPUT
        
        if not params['useZonage']:
            params['masque'] = None 
        
        if params['masque'] is None or not self.parallele:
            # print(params['useChamp'], params['useZonage'])
            if not params['useChamp'] :
                # params['cotes_des_plus_hautes_eau_unitaire'] = params['cotes_des_plus_hautes_eau']
                idtmp = self.newId()
                self.task[idtmp] = fmtAlgRunner('fmt:cphespatialisation', params, context, feedback, results=results, id=idtmp, res_CPHE=f"CPHE_{params['interpolationText']}")
                self.task[idtmp].executed.connect(partial(self.affLayer,  types='raster'))
                self.task[id].addSubTask(self.task[idtmp]) 
                dep.append(self.task[idtmp])
            
            else : 
                results['assemb_CPHE'] = []
                for k,v in self.dock.spatialisationMethod.items():
                    idtmp = self.newId()
                    depi = []
                    
                    e = f"\"{params['champDecoup']}\"='{k}'"
                    
                    self.task[idtmp] = fmtAlgRunner("native:extractbyexpression",
                        {   "INPUT" : params['masque'],
                            "EXPRESSION" : e,
                            "OUTPUT" : QgsProcessing.TEMPORARY_OUTPUT
                        },
                    context, feedback, results=results, id=idtmp, OUTPUT = k)
                    # self.task[idtmp].executed.connect(partial(self.affLayer, types='vector'))
                    self.task[id].addSubTask(self.task[idtmp]) 
                    depi.append(self.task[idtmp])
                    dep.append(self.task[idtmp])
                    
                    paramsi = {p:vv for p,vv in params.items()}
                    paramsi['interpolation'] = v.get('indice')                    
                    paramsi['masque'] = partial(results.get, k)

                    idtmp = self.newId()
                    self.task[idtmp] = fmtAlgRunner('fmt:cphespatialisation', paramsi, context, feedback, results=results, id=idtmp, res_CPHE='assemb_CPHE')
                    # self.task[idtmp].executed.connect(partial(self.affLayer, types='raster'))
                    # self.task[id].addSubTask(self.task[idtmp], depi, QgsTask.ParentDependsOnSubTask)  
                    self.task[id].addSubTask(self.task[idtmp], dep, QgsTask.ParentDependsOnSubTask)  
                    dep.append(self.task[idtmp])
                    # print(results)
                # print(results)
                # return

                
                alg_params = {
                    'INPUT':  partial(results.get,'assemb_CPHE'),
                    'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                    'processingId': params.get('processingId')
                }
                idtmp = self.newId()
                self.task[idtmp] = fmtAlgRunner("fmt:safepatch", alg_params, context, feedback, results=results, id='patch', OUTPUT=f"CPHE_{params['champDecoup']}")
                self.task[idtmp].executed.connect(partial(self.affLayer, types='raster'))
                self.task[id].addSubTask(self.task[idtmp], dep, QgsTask.ParentDependsOnSubTask)        
            
                dep = []
                dep.append(self.task[idtmp])
            
            
        else:        
            id = self.newId()
            self.task[id] = fmtTask()
            
            # if params['useChamp'] : 
                # for i in ['esc','bilinear','bicubic','rst']

            
            source = params['masque']
            results['res_CPHE'] = []
            
            # self.task[id].executed.connect(self.endContours)
            
            for i,f in enumerate(source.getFeatures()):
                
                (sink, dest_id) = QgsProcessingUtils.createFeatureSink(
                    'memory:',
                    context,
                    source.fields(),
                    source.wkbType(),
                    source.sourceCrs()
                )
                sink.addFeature(f, QgsFeatureSink.FastInsert)
                
                
                alg_params = {
                    'INPUT': params['cotes_des_plus_hautes_eau'],
                    'INTERSECT': dest_id,
                    'PREDICATE': [0], 
                    'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                    'processingId': params.get('processingId')
                }
                alg = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                

                # QgsProject.instance().addMapLayer(context.getMapLayer(alg['OUTPUT'])) 
                
                params2 = {p:v for p,v in params.items()}
                
                params2['cotes_des_plus_hautes_eau'] = context.getMapLayer(alg['OUTPUT'])
                params2['masque'] = None
                                
                if context.getMapLayer(alg['OUTPUT']).featureCount()<1:
                    continue
                
               
                idtmp = self.newId()
                self.task[idtmp] = fmtAlgRunner(alg_id, params2, context, feedback, results=results, id=i)
                self.task[id].addSubTask(self.task[idtmp])
                dep.append(self.task[idtmp])
                
                
            alg_params = {
                '-z': False,
                'GRASS_RASTER_FORMAT_META': '',
                'GRASS_RASTER_FORMAT_OPT': '',
                'GRASS_REGION_CELLSIZE_PARAMETER': 0,
                'GRASS_REGION_PARAMETER': None,
                'input':  partial(results.get,'res_CPHE'),
                'output': QgsProcessing.TEMPORARY_OUTPUT,
                'processingId': params.get('processingId')
            }

            
            idtmp = self.newId()
            self.task[idtmp] = fmtAlgRunner("grass7:r.patch", alg_params, context, feedback, results=results, id='patch', output=f"CPHE_{params['interpolationText']}")
            self.task[idtmp].executed.connect(partial(self.affLayer, types='raster'))
            self.task[id].addSubTask(self.task[idtmp], dep, QgsTask.ParentDependsOnSubTask)            
            
            dep = []
            dep.append(self.task[idtmp])
            
        if params['addMnt'] >0: 
            alg_params = { 
                'hmin' : params['hmin'],
                'mnt' : params['mnt'],
                'rasterSize' : params['rasterSize'],
                'output' : QgsProcessing.TEMPORARY_OUTPUT,   
                'processingId': params.get('processingId')
                }
                
            if params['useChamp']:
                alg_params['CPHE'] =  partial(results.get,f"CPHE_{params['champDecoup']}")   
            else :     
                alg_params['CPHE'] = partial(results.get,f"CPHE_{params['interpolationText']}") 
                
            idtmp = self.newId()
            if params['useChamp']:
                outname = f"Hauteurs_{params['champDecoup']}_sup{str(params['hmin'])}"
            else:
                outname = f"Hauteurs_{params['interpolationText']}_sup{str(params['hmin'])}"
            
            self.task[idtmp] = fmtAlgRunner('fmt:mntprojection', alg_params,  context, feedback, id='hauteurs', output=outname, verif='CPHE')
            
            
            
            
            self.task[idtmp].executed.connect(partial(self.affLayer,  types='raster'))
            self.task[id].addSubTask(self.task[idtmp], dep, QgsTask.ParentDependsOnSubTask)
            
        if  params['addContour']>0 :    
            
            alg_params = {
                'BAND': 1,
                'CREATE_3D': False,
                'EXTRA': '',
                'FIELD_NAME': 'ELEV',
                'IGNORE_NODATA': False,
                'INTERVAL': params['INTERVAL'],
                'NODATA': None,
                'OFFSET': 0,
                'OUTPUT':  QgsProcessing.TEMPORARY_OUTPUT,
                'processingId': params.get('processingId')
                }
            
            if params['useChamp']:
                alg_params['INPUT'] =  partial(results.get,f"CPHE_{params['champDecoup']}")   
            else :     
                alg_params['INPUT'] = partial(results.get,f"CPHE_{params['interpolationText']}")
            
                

            idtmp = self.newId()
            
            if params['useChamp']:
                outname = f"Contours_{params['champDecoup']}"
            else :     
                outname = f"Contours_{params['interpolationText']}"
                
            self.task[idtmp] = fmtAlgRunner("gdal:contour", alg_params,  context, feedback, id='contour', OUTPUT=outname, verif='INPUT')

            self.task[idtmp].executed.connect(partial(self.affLayer,  types='vector'))
            self.task[id].addSubTask(self.task[idtmp], dep, QgsTask.ParentDependsOnSubTask)
        self.dock.task_manager.addTask(self.task[id])

    def projection(self, name, params, context, feedback):

        results = {} 
        dep = []
        id = self.newId()
        self.task[id] = fmtTask(name = name) 

        if params['choixInput'] : 
            idtmp = self.newId()
            self.task[idtmp] = fmtAlgRunner('fmt:mntprojection', params,  context, feedback, results=results, id='hauteurs', output=f"Hauteurs_sup{str(params['hmin'])}")
            self.task[id].addSubTask(self.task[idtmp])
            dep.append(self.task[idtmp])
            if params['loadHauteurs'] :
                self.task[idtmp].executed.connect(partial(self.affLayer,  types='raster'))   
            params['hauteurs'] = partial(results.get,f"Hauteurs_sup{str(params['hmin'])}")          
        
        alg_params = {
            'NUMBERS': params['NUMBERS'],
            'hauteurs' : params['hauteurs'],
            'tamisage': params['tamisage'],
            'output': params['output'],
            'processingId': params.get('processingId')
            } 
            
        idtmp = self.newId()      
        self.task[idtmp] = fmtAlgRunner('fmt:classvectorisation', alg_params, context, feedback, results=results, id='classvectorisation', output='Classes_de_Hauteurs')
        self.task[idtmp].executed.connect(partial(self.affLayer,  types='vector'))
        self.task[id].addSubTask(self.task[idtmp], dep, QgsTask.ParentDependsOnSubTask)
        self.dock.task_manager.addTask(self.task[id])   
      

    def projectionSensitiveInitiale(self, name, params, context, feedback):
        results = {} 
        dep = []
        id = self.newId()
        self.task[id] = fmtTask(name = name) 
        if params['choixInput'] : 
            idtmp = self.newId()
            self.task[idtmp] = fmtAlgRunner('fmt:mntprojection', params,  context, feedback, results=results, id='hauteurs', output=f"Hauteurs_sup{str(params['hmin'])}")
            self.task[id].addSubTask(self.task[idtmp])
            dep.append(self.task[idtmp])
            if params['loadHauteurs'] :
                self.task[idtmp].executed.connect(partial(self.affLayer,  types='raster'))   
            params['hauteurs'] = partial(results.get,f"Hauteurs_sup{str(params['hmin'])}")          
        
        alg_params = {
            'NUMBERS': params['NUMBERS'],
            'hauteurs' : params['hauteurs'],
            'tamisage': 0,
            'output': params['output'],
            'processingId': params.get('processingId')
            } 
            
        idtmp = self.newId()      
        self.task[idtmp] = fmtAlgRunner('fmt:classrasterisation', alg_params, context, feedback, results=results, id='classrasterisation', output='Raster_de_classes')
        self.task[id].targetTask = self.task[idtmp]
        self.task[id].executed.connect(partial(self.affLayer,  types='raster'))
        self.task[id].addSubTask(self.task[idtmp], dep, QgsTask.ParentDependsOnSubTask)
        self.dock.task_manager.addTask(self.task[id])  

        
    def projectionSensitiveEnchaine(self, name, params, context, feedback):
        results = {} 
        dep = []
        id = self.newId()
        self.task[id] = fmtTask(name = name)
        
        try: raster = QgsRasterLayer(params['input'])
        except: raster = params['input']
        threshold = int(params['tamisage']/(raster.rasterUnitsPerPixelX()*raster.rasterUnitsPerPixelY()))
        
        alg_params = {
            'EIGHT_CONNECTEDNESS': False,
            'EXTRA': '',
            'INPUT': params['input'],
            'MASK_LAYER': None,
            'NO_MASK': False,
            'THRESHOLD': threshold,
            'OUTPUT':  params['output'],
            'processingId': params.get('processingId')
        }
        idtmp = self.newId()      
        self.task[idtmp] = fmtAlgRunner('gdal:sieve', alg_params, context, feedback, results=results, id='sieve', OUTPUT='Raster_de_classes')
        self.task[idtmp].executed.connect(partial(self.affLayer,  types='raster'))
        self.task[id].addSubTask(self.task[idtmp], dep, QgsTask.ParentDependsOnSubTask)
        self.dock.task_manager.addTask(self.task[id])  
        
        
    
    def affinage(self, name, params, context, feedback):
        results = {} 
        id = self.newId()

        self.task[id] = fmtAlgRunner('fmt:refinepolygon', params, context, feedback, results=results, id='refinepolygon', output=f"Vecteur_Affine{params['affText']}")
        self.task[id].executed.connect(partial(self.affLayer,  types='vector'))
        self.dock.task_manager.addTask(self.task[id])
        
    def emboiter(self, name, params, context, feedback):
        results = {} 
        id = self.newId()
        self.task[id] = fmtAlgRunner('fmt:russiandolls', params, context, feedback, results=results, id='russiandolls', OUTPUT='Classes_de_hauteurs_en_anneaux')
        self.task[id].executed.connect(partial(self.affLayer,  types='vector'))
        self.dock.task_manager.addTask(self.task[id])

    def clearTask(self):
        for id,t in list(self.task.items()):
            try: 
                if t.isActive(): 
                    t.cancel()
            except: pass
    
    def affLayer(self, b, task, types=None):
        
        if isinstance(task, fmtTask):
            task = task.targetTask
        
        for id,t in list(self.task.items()):
            try: 
                if t==task: 
                    del self.task[id]
            except: pass
        if b:
            d = {}
            try: d['processingId'] = task.params['processingId']
            except: pass
            for i,(k,v) in enumerate(task.alg.items()):
                if isinstance(types, dict):
                    t = types.get(k)
                elif isinstance(types, (list,tuple)):    
                    t = types[i]
                else: t = types
                if t in (None,'vector', 'vecteur'):
                    try: 
                        if not self.noAffichage: 
                            layer = self.iface.addVectorLayer(v, task.get(k), 'ogr') 
                        else:
                            layer = QgsVectorLayer(v)
                        d[k] = layer
                    except: 
                        try :
                            v.setName(task.get(k))
                            if not self.noAffichage: QgsProject.instance().addMapLayer(v)
                            d[k] = v
                        except:    
                            print(traceback.format_exc())
                else:
                    try:
                        if not self.noAffichage: 
                            layer = self.iface.addRasterLayer(v, task.get(k), 'gdal') 
                        else:
                            layer = QgsRasterLayer(v)
                        d[k] = layer
                    except:  print(traceback.format_exc())
            self.finished.emit(task.alg_id, d)   
        else:
            msg = self.iface.messageBar().createMessage("Erreur", f" algorithme '{task.id}' : {task.e}")
            self.iface.messageBar().pushWidget(msg, Qgis.Critical)


class fmtAlgRunner(QgsTask):
    executed = QtCore.pyqtSignal(bool, QtCore.QVariant)    
    def __init__(self, alg_id, params, context, feedback, results={}, **kw):
        name = kw.pop('name', alg_id)
        super().__init__(name, QgsTask.CanCancel)
        self.alg_id = alg_id
        self.params = params
        self.context = context
        self.feedback = feedback
        self.results = results
        self.id = kw.pop('id',None)
        self.verif = kw.pop('verif', None)
        self.set(**kw)
  
    def run(self):
        for p,v in self.params.items():
            if callable(v):
                self.params[p] = v()    
        try:            
            if self.verif is not None:
                if self.params.get(self.verif) is None:
                    return True
            self.alg = processing.run(self.alg_id, self.params, context=self.context, feedback=self.feedback)
            for k,v in self.alg.items():
                key = self.get(k)
                if isinstance(self.results.get(key), list):
                    self.results[key].append(self.alg[k])
                else:
                    self.results[key] = self.alg[k]   
            self.executed.emit(True, self) 
            return True
        except Exception as e:
            self.error = traceback.format_exc()
            self.e = e
            self.executed.emit(False, self)  
            return False

    def set(self, **kw):
        self.trad = {}
        for k,v in kw.items():
            self.trad[k] = v
    
    def get(self, k):
        return self.trad.get(k,k)

    def cancel(self):
        super().cancel()
        self.feedback.cancel()
    
class fmtTask(QgsTask):
    executed = QtCore.pyqtSignal(bool, QtCore.QVariant)
    def __init__(self, name = "", function=None):
        super().__init__(name, QgsTask.CanCancel)
        self.function = function
        self.name = name
        self.subTasks = []
  
    def run(self):
        try:            
            if self.function:
                self.function()
            self.executed.emit(True, self)
            return True
        except Exception as e:
            self.error = traceback.format_exc()
            self.executed.emit(False, self)
            return False
    
    def cancel(self):
        super().cancel()          