import os, configparser,time, traceback, processing, random
from functools import partial
from qgis.PyQt import QtWidgets, QtCore, QtGui


class fmtConfigParam():
    def __init__(self, dock, file):  
        self.dock = dock
        self.file = os.path.join(os.path.dirname(__file__), file)
        self.config = configparser.ConfigParser(allow_no_value=True)   
        self.config.optionxform = str
        self.getDefaultparameters()  
        if not os.path.exists(self.file):        
            for section,d in self.params.items():
                for variable,value in d.items():
                    self.save(variable, value, section, write=False)
            self.write()
        self.config.read(self.file)  
        
    def get(self, variable, section=None):
        if section is None:
            section = self.getSectionName(variable)
        if section is None:
            return
        default = self.getDefaultValue(variable, section)
        try: 
            value = self.decode(self.config.get(section, variable))
            if isinstance(default, bool):
                if value in ('false', 'False'):
                    value = False
            value = type(default)(value)
        except : 
            value = default
            self.save(variable, value, section)
        return value
  
    def save(self, variable, value, section=None, write=True):
        if section is None:
            section = self.getSectionName(variable)
        if section is None:
            return  
        if not self.config.has_section(section) and section !='':
            self.config.add_section(section)
        self.setConfig(section, variable, value)
        if section=='DATAS':
            secondSection = self.get('activeSession')
            if secondSection not in (None, ''):
                self.setConfig(secondSection, variable, value)
                
        if write:
            self.write()
        
    def setConfig(self, section, variable, value):
        try:
            self.config.set(section, variable, self.encode(value))
        except:
            pass
            
    def encode(self, value):
        return str(value)
    
    def decode(self, value):
        return value
    
    def write(self):
        f = open(self.file, "w")
        self.config.write(f)
        f.close()
    
    def getSectionName(self, variable):
        for s,d in self.params.items():
            if variable in d: return s
     
    def getSection(self, section):
        return [self.get(p, section) for p in self.config.options(section)]
    
    def getDefaultValue(self, variable, section = None):
        if section is None:
            section = self.getSectionName(variable)
        if section is None:
            return  
        return self.params[section][variable]
    
    def reinitialisePlugin(self):
        for s in ['EXE']:
            for v in self.params.get(s):
                self.save(v, self.getDefaultValue(v))
         
    def getDefaultparameters(self):
        self.params = {
            'DATAS':{
                'datasFile': '',
                'vectCphe' : '',
                'champCphe' : '',
                'vectDecoup' : '',
                'champDecoup' : '',
                'mnt' : '',
                'rCPHE' : '',
                'hauteurs' : '',
                'vectProjeter' : '',
                'champProjeter' : '',
                'vectAffiner' : '',
                'champAffiner' : '',
            },
            
            'EXE':{
                'activeTab' : 0 ,
                'calcHauteurs' : False,
                'hMinimDefault' : 0.0,
                'hMinimMax' : 10.0,
                'hMinimMin' : -10.0,
                'hMinimUnity': 'cm',
                'hMinimDecimals': 0,
                'useZonage' : True,
                'zoneFieldName': "fmtSpatialisation",
                'zoneFieldComment': "fmtCommentaires",
                'spatAffect' : '',
                'spatRadio' : True,
                'spatMethod' : 'qgis.voronoi',
                'bufferDefault' : 50.0,
                'bufferMax' : 99.0,
                'bufferMin' : 0.0,
                'bufferUnity': 'm',
                'bufferDecimals': 0,
                'rasterDefault' : 0.50,
                'rasterMax' : 20.0,
                'rasterMin' : 0.1,
                'rasterUnity': 'm',
                'rasterDecimals': 1,
                'tamponDefault' : 100.0,
                'tamponMax' : 200.0,
                'tamponMin' : 0.0,
                'tamponUnity': 'm',
                'tamponDecimals': 0,
                'addContour' : False,
                'intervalDefault' : 10.0,
                'intervalMax' : 100.0,
                'intervalMin' : 1.0,
                'intervalUnity': 'cm',
                'intervalDecimals': 0,
                'projEntryCPHE': True,
                'autoZoneSymbology': True,
                'autoClassSymbology': True,
                'followSymbology': True,
                'classes' : '0;0.5;1;1.5;2',
                'classesDefault' : 0,
                'classesMemo' : '0;0.5;1;1.5;2',
                'classesMin' : -9.0,
                'classesMax' : 99.0,
                'classesUnity': 'm',
                'classesDecimals': 1,
                'classesFieldName' : "classes",
                'tamDefault' : 400.0,
                'tamMax' : 999.0,
                'tamMin' : 0.0,
                'tamUnity': 'm',
                'tamDecimals': 0,
                'choixMeth' : 'Majorant',
                'tamponAffDefault' : 3.0,
                'tamponAffMax' : 99.0,
                'tamponAffMin' : 0,
                'tamponAffUnity': 'm',
                'tamponAffDecimals': 1,
                'simplAffDefault' : 3.0,
                'simplAffMax' : 9.0,
                'simplAffMin' : 0.0,
                'simplAffUnity': 'm',
                'simplAffDecimals': 0,
                'lissageAffDefault' : 2,
                'lissageAffMax' : 9,
                'lissageAffMin' : 0,
                'tamisageAffDefault' : 400.0,
                'tamisageAffMax' : 9999.0,
                'tamisageAffMin' : 0.0,
                'tamisageAffUnity': 'm',
                'tamisageAffDecimals': 0,
                'emboitDefault' : 0.0,
                'emboitMax' : 9.0,
                'emboitMin' : -9.0,
                'emboitUnity': 'm',
                'emboitDecimals': 1,
                'FIELD_ORDER' : 'up',
                'CUT' : 'cut',
                'RING' : True,
                'activeSession' : '',  
            },
            'REFERENCES':{
                'dictCphe' : 'cphe,value',
                'dictDecoup' : 'spatialisation,fmtspatialisation,affinage',
                'dictProjeter' : 'classes,class',
                'dictAffiner' : 'classes,class',
            },
            'PAINT':{     
                'icoTab': True,
                'classRampType': "Blues",
                'classRampMin': "#000000",
                'classRampMax': "#0000ff",
                'classRampChoice': "type",
                'zoneColor_qgis.voronoi': "#ff0000",
                'zoneColor_vsurf.bilinear': "#00ff00",
                'zoneColor_vsurf.bicubic': "#0000ff",
                'zoneColor_vsurf.rst': "#ffff00",
                'zoneColor_': "#000000",
                'zoneOpacity': 0.1,
                'zoneWidth': 1,
            },
        }