from qgis.PyQt import QtWidgets, QtCore, QtGui
from qgis.core import (QgsProject,
                    QgsApplication,
                    QgsMapLayerProxyModel,
                    QgsProcessing,
                    QgsVectorLayer,
                    QgsRasterLayer,
                    QgsField,
                    QgsGeometry,
                    QgsFeature,
                    QgsProcessingParameterRasterDestination,
                    QgsProcessingFeatureSourceDefinition,
                    QgsEditorWidgetSetup,
                    QgsMapLayer,
                    QgsVectorLayerCache,
                    QgsFeatureRequest,
                    QgsProcessingContext,
                    QgsProcessingFeedback,
                    QgsWkbTypes,
                    QgsProcessingAlgRunnerTask,
                    QgsTask,
                    QgsProcessingAlgorithm,
                    QgsCategorizedSymbolRenderer,
                    QgsRendererCategory,
                    QgsSymbol,
                    QgsSettings,
                    QgsCategorizedSymbolRenderer,
                    QgsSymbol,
                    QgsRendererCategory,
                    QgsColorRamp,
                    QgsStyle,
                    QgsVectorLayerSimpleLabeling,
                    QgsFeatureRequest,
                    QgsProperty
                    )

from .fmt_processing import launchMultiprocessing
from .fmt_params import fmtConfigParam
from .fmt_sessions import fmtSession
from .fmt_tools import *

from qgis.gui import QgsMapLayerComboBox, QgsFieldComboBox, QgsAttributeTableView, QgsAttributeTableModel, QgsMapToolEdit, QgsMapToolCapture
from qgis import processing
import os, configparser,time, traceback, random
from functools import partial


class fmtDockWidget(QtWidgets.QDockWidget):

    algos = {
        "cphespatialisation" : "fmt:cphespatialisation",
        "cphespatialisationtest" : "fmt:cphespatialisationtest",
        "mntprojection" : "fmt:mntprojection",
        "classvectorisation" : "fmt:classvectorisation",
        "classprojection" : "fmt:classprojection",
        "refinepolygon" : "fmt:refinepolygon",
        "russiandolls" : "fmt:russiandolls",
        }
        
    spatialisationMethod = {
        'qgis.voronoi': {'name':'Escalier', 'indice':3},
        'vsurf.bilinear': {'name':'Bilinéaire', 'indice':1},
        'vsurf.bicubic': {'name':'Bicubique', 'indice':2},
        'vsurf.rst': {'name':'RST', 'indice':0},
        }
            
       
    def __init__(self, plugin):
        self.plugin = plugin
        self.iface = plugin.iface
        self.canvas = self.iface.mapCanvas()
        super().__init__(self.iface.mainWindow())           

        self.setWindowTitle(self.plugin.pluginName)
        self.params = fmtConfigParam(self, "parameter.ini")

        mainWidget = QtWidgets.QWidget()
        self.setWidget(mainWidget)
        
        mainLayout=QtWidgets.QVBoxLayout()
        mainLayout.setContentsMargins(0,0,0,0)
        mainWidget.setLayout(mainLayout)
        
        
        w = QtWidgets.QWidget()
        mainLayout.addWidget(w)
        self.topWidget = w
        l = QtWidgets.QVBoxLayout(w)
        l.setContentsMargins(0,0,0,0)
        # h = QtWidgets.QHBoxLayout(w)
        # self.askLoadSessionWidget = w
        # w = QtWidgets.QLabel("Recharger la session ?")
        # h.addWidget(w)
        # w = QtWidgets.QPushButton("Oui")
        # h.addWidget(w)
        # w.clicked.connect(self.loadSession)
        # w = QtWidgets.QPushButton("Non")
        # h.addWidget(w)
        # w.clicked.connect(self.askLoadSessionWidget.hide)
        # self.askLoadSessionWidget.hide()
        
        tabWidget=QtWidgets.QTabWidget()
        mainLayout.addWidget(tabWidget)

        #Tool default de Qgis
        self.prevToggleTool = None
        self.canvas.mapToolSet.connect(self.toolChanged)
        
        # Widgets connectées à plusieurs fonctions
        self.mntSpat = fmtRaster('mnt',"Ajouter un MNT", params = self.params, insertLast=True)
        self.mntProj = fmtRaster('mnt', "MNT : ",  params = self.params, insertLast=True) 
        self.mntSpat.layerChanged.connect(self.mntProj.updateCombo)
        self.mntProj.layerChanged.connect(self.mntSpat.updateCombo)
        
        # Outil de sélection de zone
        self.prevTryTool = None
        self.tryTool = fmtTryTool(self.iface)
        self.tryTool.drawFinished.connect(partial(self.setTryTool, False))

        # makeTabWidget
        self.makeTabWidget(tabWidget, 'Spatialiser', self.makeSpatialiser, tooltip="Construction du découpage en zone du projet et construction de la CPHE", img="densify.png")
        self.makeTabWidget(tabWidget, 'Projeter', self.makeProjeter, tooltip="Projection et vectorisation de la CPHE sur le MNT", img="outline.png")
        self.makeTabWidget(tabWidget, 'Affiner', self.makeAffiner, img="smooth.png", tooltip = "Optimisation des contours pour réduire les précisions inutiles")
        self.makeTabWidget(tabWidget, 'Emboîter', self.makeEmboiter, img="stack.png", tooltip = "Découpage des classes de hauteurs")  
        self.makeTabWidget(tabWidget, 'Maintenance', self.makeParametres, img="wheel.png", tooltip = "Paramétrages divers")
        
        tabWidget.setCurrentIndex(self.params.get('activeTab'))
        tabWidget.currentChanged.connect(partial(self.params.save, 'activeTab'))
        
        self.task_manager = QgsApplication.taskManager()
        self.context = QgsProcessingContext()
        self.feedback = QgsProcessingFeedback()
        
        self.fmtProcessing = launchMultiprocessing(self)
        self.fmtProcessing.finished.connect(self.recupLayers)
        
        self.setMinimumWidth(350)
        QtWidgets.QApplication.processEvents()
        self.timer = QtCore.QTimer()
        self.timer.timeout.connect(self.allowMini)
        self.timer.setSingleShot(True)
        self.timer.start(5000)
        
        
    def allowMini(self):
        self.setMinimumWidth(30)
        
    def setTryTool(self, bool=True):
        if self.canvas.mapTool()!=self.tryTool:
            self.prevTryTool = self.canvas.mapTool()
        if bool: self.canvas.setMapTool(self.tryTool)
        else: 
            if self.prevTryTool: self.canvas.setMapTool(self.prevTryTool)
            else: self.canvas.unsetMapTool(self.tryTool)
        
    def makeTabWidget(self,tabWidgetName, tabName, function=None, tooltip="", img=None) :
        w = QtWidgets.QWidget()
        l = QtWidgets.QVBoxLayout(w)
        l.setAlignment(QtCore.Qt.AlignmentFlag.AlignTop)
        l.setContentsMargins(1,5,1,5)
        name = QtWidgets.QLabel(tabName)
        font = QtGui.QFont()
        font.setBold(True)
        font.setPointSize(10)
        name.setFont(font)
        l.addWidget(name)
        sc = QtWidgets.QScrollArea()
        sc.setWidgetResizable(True)
        sc.setWidget(w)
        w.setObjectName("scrollAreaWidgetContents")
        sc.setStyleSheet("QAbstractScrollArea {background-color: transparent;}  ")
        w.setStyleSheet("QWidget#scrollAreaWidgetContents {background-color: white; } ")
        if img and self.params.get("icoTab"):
            ico = QtGui.QIcon(os.path.join(self.plugin.plugin_dir, "images", img))
            ind = tabWidgetName.addTab(sc, ico, "")
        else:
            ind = tabWidgetName.addTab(sc, tabName)
        tabWidgetName.setTabToolTip(ind, tooltip)
        if function:
            function(l)

    def recupLayers(self, alg_id, d):
        if alg_id == 'fmt:cphespatialisation':
            try: 
                self.rCPHE.setLayer(d['res_CPHE'])
                if not self.radioEntry.cphe.isChecked():
                    self.radioEntry.cphe.click()
            except: pass
        if alg_id == 'fmt:mntprojection':
            try: 
                self.hauteurs.setLayer(d['output']) 
                if not self.radioEntry.hauteur.isChecked():
                    self.radioEntry.hauteur.click()
            except: pass
        if alg_id == 'fmt:classprojection' or alg_id == 'fmt:classvectorisation':
            try: 
                self.vectProjeter.setCurrentLayer(d['output'])
                self.vectProjeter.setField(self.params.get('classesFieldName'))
                self.applyClassSymbology(d['output'])
            except: 
                # print(traceback.format_exc())
                pass
        if alg_id == 'fmt:refinepolygon':
            try: 
                self.vectAffiner.setCurrentLayer(d['output'])
                self.vectAffiner.setField(self.vectProjeter.fieldText())
                self.applyClassSymbology(d['output'], self.vectProjeter)
            except: pass
        if alg_id == 'fmt:russiandolls':
            try: 
                self.applyClassSymbology(d['OUTPUT'], self.vectAffiner)
            except: pass
    
    def selectArea(self, layer):
        self.iface.setActiveLayer(layer)
        self.iface.actionSelectRectangle().trigger()
        
    def makeSpatialiser(self, layout):        
        self.execSelectedLabel= QtWidgets.QLabel(f'Cocher "Sélection" pour exécuter la sélection')
        self.execSelectedLabelVisibility()
        
        boxSpat = fmtGroupBox("Données d'entrée") 
        self.coucheCPHE = fmtAddFeaturesLayer("Cphe", params = self.params, title="Vecteur contenant les CPHE :",  selection=True, numeric=True)   
        self.coucheCPHE.selectionRequired.connect(self.selectArea)
        self.coucheCPHE.execSelected.connect(self.execSelectedLabelVisibility)
        boxSpat.layout().addWidget(self.coucheCPHE)
        
        
        self.coucheDecoup = fmtAddFeaturesLayer("Decoup", self.params, title="Vecteur contenant le zonage :", add=True, polygon=True, selection=True, text=True)   
        self.coucheDecoup.addClicked.connect(partial(self.createVector, self.coucheDecoup))   
        self.coucheDecoup.setApplyLegend(self.applyZoneSymbology)
        boxSpat.layout().addWidget(self.coucheDecoup)
        
        
        addMnt = QtWidgets.QCheckBox("Calculer la hauteur (Projeter)")
        font = QtGui.QFont()
        font.setUnderline(True)
        addMnt.setFont(font)
        addMnt.setChecked(self.params.get('calcHauteurs'))

        self.hMinim = fmtSetValue('hMinim',"Hauteur minimale :  ", params=self.params)  
        self.hCompatibilityLabel = QtWidgets.QLabel(f'Hauteur supérieure à la classe minimale de l\'onglet "Projeter"')
        self.hCompatibilityLabel.setWordWrap(True)
        self.hCompatibilityLabel.setStyleSheet("color:red;")
        self.hCompatibilityLabel.hide()
        self.hMinim.valueChanged.connect(self.hCompatibility)
        
        boxSpat.layout().addWidget(addMnt)
        boxAddMnt = QtWidgets.QWidget()
        boxSpat.layout().addWidget(boxAddMnt)
        l =  QtWidgets.QVBoxLayout(boxAddMnt)
        l.setContentsMargins(20,0,0,0)
        l.setSpacing(0)
        l.addWidget(self.mntSpat)
        l.addWidget(self.hMinim)
        l.addWidget(self.hCompatibilityLabel)
        layout.addWidget(boxSpat)
        
        addMnt.stateChanged.connect(lambda: self.params.save("calcHauteurs", addMnt.isChecked()))
        addMnt.stateChanged.connect(lambda: boxAddMnt.setVisible(addMnt.isChecked()))
        boxAddMnt.setVisible(addMnt.isChecked())
 
        boxDecoup = fmtGroupBox("Construction du Zonage :")         
        w = QtWidgets.QWidget()
        h = QtWidgets.QHBoxLayout(w)
        h.setContentsMargins(0,0,0,0)
        boxDecoup.layout().addWidget(w)
        w = QtWidgets.QLabel("")
        h.addWidget(w)
        self.labelDecoupage = w
        w = QtWidgets.QPushButton("Nouveau")
        w.setToolTip("Créer un vecteur découpage")
        h.addWidget(w)
        w.clicked.connect(partial(self.createVector, self.coucheDecoup))
        self.coucheDecoup.fieldChanged.connect(self.spatialisationChoiceAdaptText)
        # self.coucheDecoup.fieldChanged.connect(lambda: self.updateSymbol(self.coucheDecoup.currentLayer(), self.coucheDecoup.fieldText()))
        self.coucheDecoup.selectionRequired.connect(self.selectArea)
        self.coucheDecoup.execSelected.connect(self.execSelectedLabelVisibility)
        
        self.polygonBuffer = fmtSetValue('buffer', "Tampon : ", params = self.params)       
        self.polygonBuffer.valueChanged.connect(self.changePolygonFromPoint)
        self.noSelectionLabel = QtWidgets.QLabel("Selectionnez des CPHE pour créer une zone")
        
        w = QtWidgets.QWidget()
        v = QtWidgets.QVBoxLayout(w)
        v.setContentsMargins(0,0,0,0)
        v.setSpacing(0)
        boxDecoup.layout().addWidget(w)
        self.blockAddZone = w

        blockButton = QtWidgets.QWidget()
        l = QtWidgets.QHBoxLayout(blockButton)   
        l.setContentsMargins(0,0,0,0)
        # l.setAlignment(QtCore.Qt.AlignmentFlag.AlignLeft)
        w = QtWidgets.QLabel("Ajouter une zone :")
        font = QtGui.QFont()
        font.setUnderline(True)
        w.setFont(font)
        v.addWidget(w)
        w = QtWidgets.QWidget()
        v.addWidget(w)
        v = QtWidgets.QVBoxLayout(w)
        v.setContentsMargins(20,0,0,0)
        v.setSpacing(0)
        
        
        
        self.toolBar = ToogleToolBar() 
        l.addWidget(self.toolBar)        
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"mActionCapturePolygon.png"))
        self.toolBar.addButton("addFeature", ico,"Dessiner un polygone")
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"addpolygon.png"))
        self.toolBar.addButton("addPolygon", ico, "Tampon à partir des CPHE selectionnées")
        
        
        self.toolBar.changed.connect(self.toolBarToggled)
        self.toolBar.beforeChanged.connect(self.setToggleBarTool)
        self.toolBar.selectionRequired.connect(lambda : self.selectArea(self.coucheCPHE.currentLayer()))

        w = QtWidgets.QLabel("   ")
        l.addWidget(w)

        self.btnCancel = fmtClickLabel()
        self.btnCancel.setMaximumWidth(19)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"close.png"))
        self.btnCancel.setPixmap(ico.pixmap(19,19))
        self.btnValid = fmtClickLabel()
        self.btnValid.setMaximumWidth(19)
        ico = QtGui.QIcon(os.path.join(os.path.dirname(__file__), "images", f"ok.png"))
        self.btnValid.setPixmap(ico.pixmap(19,19))
        l.addWidget(self.btnValid)
        l.addWidget(self.btnCancel)
        v.addWidget(blockButton)     

        self.coucheDecoup.layerChanged.connect(self.toolBarVisibility)    
        self.coucheCPHE.layerChanged.connect(self.adaptToolBarButton)    
        v.addWidget(self.polygonBuffer)
        # v.addWidget(self.noSelectionLabel)
        self.btnCancel.clicked.connect(partial(self.cancelEdits,self.coucheDecoup))
        self.btnValid.clicked.connect(partial(self.validateEdits,self.coucheDecoup))
        
        
        w = QtWidgets.QWidget()
        v = QtWidgets.QVBoxLayout(w)
        v.setContentsMargins(0,0,0,0)
        v.setSpacing(0)
        boxDecoup.layout().addWidget(w)
        self.blockAffectZone = w
        w = QtWidgets.QLabel("Affecter une spatialisation :")
        font = QtGui.QFont()
        font.setUnderline(True)
        w.setFont(font)
        v.addWidget(w)
        w = QtWidgets.QWidget()
        v.addWidget(w)
        v = QtWidgets.QVBoxLayout(w)
        v.setContentsMargins(20,0,0,0)
        v.setSpacing(0)
        
        w = QtWidgets.QWidget()
        l = QtWidgets.QHBoxLayout(w)   
        l.setContentsMargins(0,0,0,0)
        v.addWidget(w)
        combo = fmtSpatialisationComboBox(self.spatialisationMethod, 'spatAffect', self.params, empty=True)
        l.addWidget(combo)
        
        w = QtWidgets.QPushButton("Attribuer")
        w.setToolTip("Attribue la spatialisation choisie à toutes les entités sélectionnées")
        l.addWidget(w)
        layout.addWidget(boxDecoup)    
        w.clicked.connect(partial(self.updateAttributeFromCombo, combo))
        

        boxTraitement = fmtGroupBox("Paramètres")   
        layout.addWidget(boxTraitement)
        
        w = QtWidgets.QWidget()
        v = QtWidgets.QVBoxLayout(w)
        v.setContentsMargins(0,0,0,0)
        v.setSpacing(0)
        boxTraitement.layout().addWidget(w)
        w = QtWidgets.QLabel("Choix spatialisation :")
        font = QtGui.QFont()
        font.setUnderline(True)
        w.setFont(font)
        v.addWidget(w)
        w = QtWidgets.QWidget()
        v.addWidget(w)
        v = QtWidgets.QVBoxLayout(w)
        v.setContentsMargins(20,0,0,0)
        v.setSpacing(0)
        
        self.useZonage = QtWidgets.QCheckBox("Utiliser le zonage")  
        
        if self.params.get('useZonage'):
            self.useZonage.setChecked(True)
        self.useZonage.toggled.connect(partial(self.params.save, 'useZonage')) 
        # self.useZonage.stateChanged.connect(partial(self.params.save, 'useZonage')) 
        v.addWidget(self.useZonage)
        choixSpatialisation = fmtSpatialisationComboBox(self.spatialisationMethod, 'spatMethod', self.params)
        self.radioSpat = QtWidgets.QButtonGroup()
        
        r2 = QtWidgets.QRadioButton(f"Selon le champ")
        v.addWidget(r2)

        w = QtWidgets.QWidget()
        v.addWidget(w)
        l = QtWidgets.QHBoxLayout(w)   
        l.setContentsMargins(0,0,0,0)
        l.setAlignment(QtCore.Qt.AlignmentFlag.AlignLeft)
        r1 = QtWidgets.QRadioButton("Tout en ")
        l.addWidget(r1)
        l.addWidget(choixSpatialisation)
        self.radioSpat.addButton(r1)
        self.radioSpat.addButton(r2)
        self.radioSpat.all = r1
        self.radioSpat.champ = r2
        self.useZonage.stateChanged.connect(self.spatialisationChoiceVisibility)

        layerRaster = fmtSetValue('raster',"Définition du Raster :  ", params=self.params, strictPositive=True)      
        layerTampon = fmtSetValue('tampon', "Tampon :  ", params=self.params)     
        addContour = QtWidgets.QCheckBox("Calculer les courbes de niveau")  
        font = QtGui.QFont()
        font.setUnderline(True)
        addContour.setFont(font)       
        layerInterval = fmtSetValue('interval', "Courbes de niveau :  ", params=self.params, strictPositive=True)
        boxTraitement.layout().addWidget(layerRaster)
        boxTraitement.layout().addWidget(layerTampon)
        boxTraitement.layout().addWidget(addContour)
 
        
        boxContour = QtWidgets.QWidget()
        boxTraitement.layout().addWidget(boxContour)
        l =  QtWidgets.QVBoxLayout(boxContour)
        l.setContentsMargins(20,0,0,0)
        l.setSpacing(0)
        l.addWidget(layerInterval)
        addContour.stateChanged.connect(lambda: self.params.save("addContour", addContour.isChecked()))
        addContour.stateChanged.connect(lambda: boxContour.setVisible(addContour.isChecked()))
        addContour.setChecked(self.params.get('addContour'))
        boxContour.setVisible(addContour.isChecked())

        
        self.toolBarVisibility()
        # self.spatialisationChoiceVisibility()
        def isNotPoint():
            layer = self.coucheCPHE.currentIfaceLayer()
            if layer is None: return
            return layer.geometryType() !=  QgsWkbTypes.PointGeometry
        
        params = {
            'champCPHE' : self.coucheCPHE.fieldText,
            'champDecoup' : self.coucheDecoup.fieldText,
            'rasterSize' : layerRaster.value,
            'buffer' : layerTampon.value,
            'interpolation' : choixSpatialisation.getIndice,
            'interpolationText' : choixSpatialisation.currentText,
            'res_CPHE' :  QgsProcessing.TEMPORARY_OUTPUT,
            'force_centroid' : isNotPoint,      
            'INTERVAL' : layerInterval.value,
            'cotes_des_plus_hautes_eau' : self.coucheCPHE.currentLayer,
            'masque' : self.coucheDecoup.currentLayer,
            'mnt' : self.mntSpat.currentLayer,
            'hmin' : self.hMinim.value,
            'addMnt' : addMnt.checkState,
            'addContour' : addContour.checkState,
            'useZonage' : self.useZonage.checkState,
            'useChamp' : self.radioSpat.champ.isChecked
            }  
        w = fmtExecuteButton(self, 'spatialisation', params,
            sensitive=False)
        
        layout.addWidget(w)
        layout.addWidget(self.execSelectedLabel) 
        
    def makeProjeter(self, layout): 
        boxInput = fmtGroupBox("Données d'entrée")  
        self.radioEntry = QtWidgets.QButtonGroup()
        r = QtWidgets.QRadioButton('CPHE et MNT')
        r.setChecked(self.params.get("projEntryCPHE"))
        self.radioEntry.cphe = r
        boxInput.layout().addWidget(r)
        font = QtGui.QFont()
        font.setBold(True)
        r.setFont(font)
        self.radioEntry.addButton(r)
        w1 = QtWidgets.QWidget()
        boxInput.layout().addWidget(w1)
        r.toggled.connect(lambda: w1.setVisible(self.radioEntry.cphe.isChecked()))
        w1.setVisible(r.isChecked())
        l = QtWidgets.QVBoxLayout(w1)
        l.setContentsMargins(15,0,0,5)
        self.rCPHE = fmtRaster('rCPHE', "CPHE Spatialisé : ", params = self.params)       
        l.addWidget(self.rCPHE)         
        l.addWidget(self.mntProj)
        chargeHauteur = QtWidgets.QCheckBox("Charger le raster des Hauteurs")        
        l.addWidget(chargeHauteur)  
        r = QtWidgets.QRadioButton('Hauteurs')
        r.setChecked(not self.params.get("projEntryCPHE"))
        self.radioEntry.hauteur = r
        boxInput.layout().addWidget(r)
        font = QtGui.QFont()
        font.setBold(True)
        r.setFont(font)
        self.radioEntry.addButton(r)
        w2 = QtWidgets.QWidget()
        boxInput.layout().addWidget(w2)
        r.toggled.connect(lambda: w2.setVisible(self.radioEntry.hauteur.isChecked()))
        w2.setVisible(r.isChecked())
        l = QtWidgets.QVBoxLayout(w2)
        l.setContentsMargins(15,0,0,5)     
        self.hauteurs = fmtRaster('hauteurs',  params = self.params)        
        l.addWidget(self.hauteurs)  
        self.radioEntry.cphe.toggled.connect(lambda: self.params.save("projEntryCPHE", self.radioEntry.cphe.isChecked()))
        layout.addWidget(boxInput)
   
        boxProj = fmtGroupBox("Paramètres")
        self.thresholdInput = fmtThresholdInputWidget('classes', params = self.params)
        self.thresholdInput.miniChanged.connect(self.hCompatibility)
        self.hCompatibility()
        boxProj.layout().addWidget(self.thresholdInput)
        layerTamisage = fmtSetValue('tam', "Tamiser : ", tooltip="Supprimer les trous inférieurs à :  ", params=self.params, absoluteMin=0, area=True)    
        boxProj.layout().addWidget(layerTamisage)     
        layout.addWidget(boxProj)
        

        params = {
            'hauteurs' : self.hauteurs.currentLayer,
            'mnt' : self.mntProj.currentLayer,
            'hmin' : self.thresholdInput.getMinim,
            'CPHE' :  self.rCPHE.currentLayer,
            'NUMBERS' : self.thresholdInput.getValues,
            'tamisage' : layerTamisage.value,   
            'loadHauteurs' : chargeHauteur.checkState,
            'choixInput' : self.radioEntry.cphe.isChecked,
            'rHauteurs' : QgsProcessing.TEMPORARY_OUTPUT,
            'output' : QgsProcessing.TEMPORARY_OUTPUT
            }  
        w = fmtExecuteButton(self, 'projection', params,
            signals=[layerTamisage.valueChanged],
            widgets=[boxInput, self.thresholdInput],
            cuts=['hauteurs','mnt','CPHE'])
        layout.addWidget(w)
        
    def makeAffiner(self,layout):
        boxVector = fmtGroupBox("Données d'entrée")  
        self.vectProjeter = fmtAddFeaturesLayer("Projeter", self.params, polygon = True)    
        self.vectProjeter.selectionRequired.connect(self.selectArea)     
        self.vectProjeter.setApplyLegend(self.applyClassSymbology)
        boxVector.layout().addWidget(self.vectProjeter)
        layout.addWidget(boxVector) 
              
        boxAffiner = fmtGroupBox("Paramètres")
        layout.addWidget(boxAffiner)
        boxAffiner.layout().addWidget(QtWidgets.QLabel("Choix de la méthode d'affinage :"))
        h = QtWidgets.QHBoxLayout()
        boxAffiner.layout().addLayout(h)
        choixAff = fmtComboBox('choixMeth', self.params)
        choixAff.addItems(['Majorant', 'Minorant', 'Maj/Min', 'Min/Maj'])
        choixAff.initValue()
        boxAffiner.layout().addWidget(choixAff)
        h.addWidget(choixAff)
        tamponAff = fmtSetValue('tamponAff', "", params=self.params, absoluteMin=0)      
        h.addWidget(tamponAff)
        
        simplAff = fmtSetValue('simplAff', "Simplifier :  ", params=self.params, absoluteMin=0)
        lissageAff = fmtSetValue( 'lissageAff', "Lisser :  ", params=self.params, absoluteMin=0, noUnity=True)      
        TamisageAff = fmtSetValue('tamisageAff', "Tamiser : ", tooltip="Supprimer les surfaces inférieures à :  ", params=self.params, absoluteMin=0, area=True)  
        boxAffiner.layout().addWidget(simplAff)
        boxAffiner.layout().addWidget(lissageAff)        
        boxAffiner.layout().addWidget(TamisageAff)        
        
        params = {'vectAffiner' : self.vectProjeter.currentLayer,
                'champAffiner' : self.vectProjeter.fieldText, 
                'choixAff' : choixAff.currentIndex,
                'affText' : choixAff.currentText,
                'buffer' : tamponAff.value,
                'simp' : simplAff.value,  
                'lissage' : lissageAff.value,   
                'clean' : TamisageAff.value,
                'output' :QgsProcessing.TEMPORARY_OUTPUT,
            }  
        w = fmtExecuteButton(self, 'affinage', params, 
            signals=[choixAff.currentIndexChanged, tamponAff.valueChanged, simplAff.valueChanged, lissageAff.valueChanged, TamisageAff.valueChanged], 
            widgets=[boxVector], 
            cuts=['vectAffiner'])
        layout.addWidget(w)

  
    def makeEmboiter(self, layout):
        boxEmboiter = fmtGroupBox("Données d'entrée")
        self.vectAffiner = fmtAddFeaturesLayer("Affiner", self.params, polygon = True)
        self.vectAffiner.selectionRequired.connect(self.selectArea)    
        self.vectAffiner.setApplyLegend(self.applyClassSymbology)
        boxEmboiter.layout().addWidget(self.vectAffiner)
        layout.addWidget(boxEmboiter)
        
        boxParamEmboiter = fmtGroupBox("Paramètres")
        tamponEmboit = fmtSetValue('emboit', "Distance d'emboitement \n(accrochage si négatif) :  ", params=self.params)      
        boxParamEmboiter.layout().addWidget(tamponEmboit)       

        w = QtWidgets.QWidget()
        l = QtWidgets.QHBoxLayout(w)
        l.setContentsMargins(0,0,0,0)
        label = QtWidgets.QLabel("Ordre d'emboitement :")
        orderEmboit = fmtComboBox('FIELD_ORDER', self.params)
        for k,v in {'up':"Croissant", 'down':"Décroissant"}.items():
            orderEmboit.addItem(v, k)
        orderEmboit.initValue()
        l.addWidget(label)
        l.addWidget(orderEmboit)
        boxParamEmboiter.layout().addWidget(w)
        
        w = QtWidgets.QWidget()
        l = QtWidgets.QHBoxLayout(w)
        l.setContentsMargins(0,0,0,0)
        label = QtWidgets.QLabel("Option d'emboitement :")
        cutListe = fmtComboBox('CUT', self.params)
        for k,v in {'cut':"Rogner", 'merge':"Aggrandir"}.items():
            cutListe.addItem(v, k)
        cutListe.initValue()
        l.addWidget(label)
        l.addWidget(cutListe)
        boxParamEmboiter.layout().addWidget(w)
        
        anneauxDistincts = QtWidgets.QCheckBox("Découper en anneaux distincts")
        anneauxDistincts.setChecked(self.params.get('RING'))
        anneauxDistincts.stateChanged.connect(lambda: self.params.save("RING", anneauxDistincts.isChecked()))
        boxParamEmboiter.layout().addWidget(anneauxDistincts)  

        layout.addWidget(boxParamEmboiter)      
        
        params = {
                'INPUT' : self.vectAffiner.currentLayer, # a connecter au resultats de la dernière
                'FIELD' : self.vectAffiner.fieldText,
                'FIELD_ORDER' : orderEmboit.currentIndex,
                'CUT' : cutListe.currentIndex,
                'RING' : anneauxDistincts.checkState,
                'DISTANCE' : tamponEmboit.value,  
                'OUTPUT' :QgsProcessing.TEMPORARY_OUTPUT,  
            }  
        w = fmtExecuteButton(self, 'emboiter', params, 
            signals=[orderEmboit.currentIndexChanged, cutListe.currentIndexChanged, tamponEmboit.valueChanged, anneauxDistincts.stateChanged], 
            widgets=[boxEmboiter], 
            cuts=['INPUT'])
        layout.addWidget(w)
        

    def makeParametres(self, layout):
        boxSession = fmtGroupBox("Sessions")
        layout.addWidget(boxSession)
        self.session = fmtSession(self)
        boxSession.layout().addWidget(self.session)
        
        boxParam = fmtGroupBox("Paramètres")
        layout.addWidget(boxParam)
        w = QtWidgets.QLabel("Implémentation à venir...")
        w.setWordWrap(True)
        font = QtGui.QFont()
        font.setItalic(True)
        w.setFont(font)
        boxParam.layout().addWidget(w)

   
    def launchReinitialisePlugin(self) :        
        w = QtWidgets.QDialog()
        label = QtWidgets.QLabel("Attention, les valeurs ne pourront pas être rechargé !")
        label.setStyleSheet("color: red; font-weight: bold;")
        ok = QtWidgets.QPushButton("OK")
        ok.clicked.connect(partial(self.params.reinitialisePlugin))
        cancel = QtWidgets.QPushButton("Annuler")
        cancel.clicked.connect(lambda : w.reject())        
        layout = QtWidgets.QVBoxLayout(w)
        layout.addWidget(label)
        layout.addWidget(ok)
        layout.addWidget(cancel)
        w.setLayout(layout)        
        w.exec()
                
    def createPolygonFromPoint(self):
        layerCPHE = self.coucheCPHE.currentIfaceLayer()
        if layerCPHE is None: return
        context = QgsProcessingContext()
        feedback = QgsProcessingFeedback()

        pts = []
        if layerCPHE.geometryType()!=QgsWkbTypes.PointGeometry:
            for f in layerCPHE.getSelectedFeatures():
                try:
                    f.geometry().asPoint() 
                except:
                    print(traceback.format_exc())
        else:
            pts = [f.geometry().asPoint() for f in layerCPHE.getSelectedFeatures()]
        geom = QgsGeometry.fromMultiPointXY(pts)
        geom = geom.concaveHull(0)  
        self.polygonBuffer.hull = geom
        self.changePolygonFromPoint()
               
    def changePolygonFromPoint(self):   
        try: self.coucheDecoup.currentIfaceLayer().deleteFeature(self.polygonBuffer.lastFeature.id())
        except: pass
        geom = self.polygonBuffer.hull.buffer(self.polygonBuffer.value(), 5)
        new_feature = QgsFeature(self.coucheDecoup.currentIfaceLayer().fields())
        new_feature.setGeometry(geom)    
        self.coucheDecoup.currentIfaceLayer().addFeature(new_feature)
        self.polygonBuffer.lastFeature = new_feature        
        return
        
        ##########################################
        try : maxFid = max(f.id() for f in layer.getFeatures())
        except : maxFid = 0    
        maxFid+=1  
    
    def setDrawPolygon(self, check = True):
        if check is False :
            self.unsetTool()
            return
        self.tool = self.canvas.mapTool()
        try : layer = self.coucheDecoup.currentLayer()
        except : pass
        self.iface.setActiveLayer(layer)
        if check and not layer.isEditable() :
            self.start_Editing()
        a = self.iface.actionAddFeature()
        a.blockSignals(True)
        a.trigger()
        a.blockSignals(False)
        
    def unsetTool(self) :
        if not self.toolBar.currentTool():
            self.coucheDecoup.currentIfaceLayer().commitChanges()
            self.canvas.setMapTool(self.tool)

    def toolChanged(self, old, new):
        pass
        # print(old, new)
        # self.toolBar.setFromQgis(new)
        
    def setToggleBarTool(self):
        code = self.toolBar.currentTool()
        if code is None:
            self.prevToggleTool = self.canvas.mapTool()
            try: 
                layer = self.coucheDecoup.currentIfaceLayer()
                layer.inEdition = layer.isEditable()
            except: pass
    
    def toolBarToggled(self):
        layer = self.coucheDecoup.currentIfaceLayer()
        if layer is None:
            self.toolBar.uncheck()
            return        
        
        code = self.toolBar.currentTool()
        self.btnCancel.setVisible(code is not None)
        self.btnValid.setVisible(code is not None)
        if code is None:
            self.canvas.setMapTool(self.prevToggleTool)
        else:
            self.iface.setActiveLayer(layer)
            # if not layer.isEditable(): 
                # self.start_Editing()
            self.start_Editing()
                
        if code=='addFeature':
            self.iface.actionAddFeature().trigger()
            # tool = self.canvas.mapTool()
            # print(tool)
        
        self.polygonBuffer.setVisible(code=='addPolygon')
        if code=='addPolygon':    
            self.iface.actionSelectRectangle().trigger()
            self.createPolygonFromPoint()
            
    def toolBarVisibility(self):
        self.blockAddZone.setVisible(self.coucheDecoup.currentIfaceLayer() is not None)
        self.blockAffectZone.setVisible(self.coucheDecoup.currentIfaceLayer() is not None)
        self.useZonage.setEnabled(self.coucheDecoup.currentIfaceLayer() is not None)
        self.toolBar.setCurrentTool()
        self.adaptToolBarButton()
        self.labelDecoupage.setText(self.coucheDecoup.name())
        self.spatialisationChoiceAdaptText()
        self.spatialisationChoiceVisibility()
    
    def adaptToolBarButton(self):
        self.toolBar.setEnabled('addPolygon', self.coucheCPHE.currentIfaceLayer() is not None)
    
    def spatialisationChoiceAdaptText(self):
        c = " : "+self.coucheDecoup.fieldText() if self.coucheDecoup.fieldText()!="" else ""
        self.radioSpat.champ.setText(f"Selon le champ{c}")
    
    def spatialisationChoiceVisibility(self):  
        b = self.useZonage.isChecked() and self.useZonage.isEnabled()
        self.radioSpat.champ.setEnabled(b)
        if not b:
            self.radioSpat.all.setChecked(True)
    
    
    def update_fields(self, layer, champ):
        if layer:
            champ.setLayer(layer)
        else:
            champ.clear()
         
    def createVector(self, combo):
        project = QgsProject.instance()
        project_crs = project.crs()
        champ = self.params.get('zoneFieldName')
        fields = f"field={champ}:string(255)&field={self.params.get('zoneFieldComment')}:string(255)"
        uri = f"Polygon?crs={project_crs.authid()}&{fields}"
        layer = QgsVectorLayer(uri, "Decoupage", "memory")

        # Set up the attribute table with dropdown values for 'fmtSpatialisation'
        # field_idx = layer.fields().indexFromName(champ)
        # l = []
        # for k,v in self.spatialisationMethod.items():
               # l.append({k : v.get('name',k)})    
        # configuration = { 'map': l }
        # editor_widget = QgsEditorWidgetSetup("ValueMap", configuration)       
        # layer.setEditorWidgetSetup(field_idx, editor_widget)

        project.addMapLayer(layer)
        combo.setCurrentLayer(layer)
        self.applyZoneSymbology(combo.currentIfaceLayer(), combo)
        # print("Temporary vector layer created successfully")
        return layer

    
    def updateAttributeFromCombo(self, combo):
        layer = self.coucheDecoup.currentIfaceLayer()
        att = combo.currentData()
        idx = layer.fields().indexOf(self.coucheDecoup.fieldText())
        out = not layer.isEditable()
        if out: layer.startEditing()
        for f in layer.getSelectedFeatures():
            layer.changeAttributeValue(f.id(), idx, att)
        layer.commitChanges(stopEditing=out)
    
    def getWigetsEdition(self, layer):
        try: return layer.widgetsList
        except: return []
        
    
    def start_Editing(self):
        layer = self.iface.activeLayer()
        # for w in self.getWigetsEdition(layer):
            # w.show()
        # try: layer.startEditing()
        layer.startEditing()
        # except: print(traceback.format_exc())

        self.setDigitizingBehavior()

    def validateEdits(self, combo):
        layer = combo.currentIfaceLayer()
        try: out = not layer.inEdition
        except: out = True
        try: layer.commitChanges(stopEditing=out)
        except: pass
        
        self.toolBar.setCurrentTool()
        
        self.setDigitizingBehavior(False)

    def cancelEdits(self, combo):
        layer = combo.currentIfaceLayer()
        try: layer.rollBack()
        except: pass
        self.toolBar.setCurrentTool()
        self.setDigitizingBehavior(False)
        

    def setDigitizingBehavior(self, on=True):
        d = {'marker-only-for-selected':True,'disable-enter-attribute-values-dialog':True}
        s = QgsSettings()
        s.beginGroup('digitizing')
        try: b = self.memoDigitizingBehavior
        except: self.memoDigitizingBehavior = {p:s.value(p) for p in d.keys()}
        for p,v in d.items():
            b = v if on else self.memoDigitizingBehavior[p]
            s.setValue(p, b)
        # d = {'marker_only_for_selected':True,'disable_enter_attribute_values_dialog':True}
        # s = QgsSettings()    
        # try: b = self.memoDigitizingBehavior2
        # except: self.memoDigitizingBehavior2 = {p:s.value(f'digitizing/{p}') for p in d.keys()}
        # for p,v in d.items():
            # b = v if on else self.memoDigitizingBehavior2[p]
            # s.setValue(f'digitizing/{p}', b)
                

    def applyClassSymbology(self, targetLayer, fromCombo=None, champ=None):
        if fromCombo and self.params.get('followSymbology'):
            memo = self.iface.activeLayer()
            self.iface.setActiveLayer(fromCombo.currentIfaceLayer())
            self.iface.actionCopyLayerStyle().trigger()
            self.iface.setActiveLayer(targetLayer)
            self.iface.actionPasteLayerStyle().trigger()
            if memo and memo!=targetLayer: 
                self.iface.setActiveLayer(memo)
            return
        if self.params.get('autoClassSymbology') or champ:
            if champ is None:
                if fromCombo: champ = fromCombo.fieldText()
                else: champ = self.params.get('classesFieldName')
            style = QgsStyle().defaultStyle()
            colorRamp = style.colorRamp(self.params.get('classRampType'))
            v = sorted(targetLayer.uniqueValues(targetLayer.fields().indexFromName(champ)))
            num_values = len(v)
            categories = []
            for i, val in enumerate(v):
                normal = i / max(1, num_values - 1)
                color = colorRamp.color(normal)
                symbol = QgsSymbol.defaultSymbol(targetLayer.geometryType())
                symbol.setColor(color)
                category = QgsRendererCategory(val, symbol, str(val))
                categories.append(category)
            renderer = QgsCategorizedSymbolRenderer(champ, categories)
            req = QgsFeatureRequest()
            req2 = req.addOrderBy(champ, ascending=True)
            renderer.setOrderBy(req2.orderBy())
            renderer.setOrderByEnabled(True)
            targetLayer.setRenderer(renderer) 
            targetLayer.triggerRepaint()
        
    def applyZoneSymbology(self, targetLayer, fromCombo=None, champ=None):
        def addCategory(l, code, name):
            symbol = QgsSymbol.defaultSymbol(targetLayer.geometryType()) 
            color = QtGui.QColor(self.params.get(f'zoneColor_{code}'))
            symbol.setColor(color)
            sl = symbol.symbolLayer(0)
            sl.setStrokeColor(color)
            sl.setStrokeWidth(self.params.get('zoneWidth'))
            color.setAlpha(int(255*self.params.get('zoneOpacity')))
            sl.setFillColor(color)
            category = QgsRendererCategory(code, symbol, name) 
            l.append(category)
        if self.params.get('autoZoneSymbology') or champ:
            if champ is None:
                if fromCombo: champ = fromCombo.fieldText()
                else: champ = self.params.get('zoneFieldName')
            l = []
            for k,v in self.spatialisationMethod.items() :
                    addCategory(l, k, str(v.get('name',k)))
            addCategory(l, '', "Aucun")
            renderer = QgsCategorizedSymbolRenderer(champ, l)
            targetLayer.setRenderer(renderer)   
            targetLayer.triggerRepaint()
    

    def execSelectedLabelVisibility(self, bool = True):
        self.execSelectedLabel.setVisible(bool == False)

    def hCompatibility(self):
        if self.hMinim.value() > self.thresholdInput.getMinim():
            self.hCompatibilityLabel.show()
        else : 
            self.hCompatibilityLabel.hide()
            



