# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Flood Map Tool
                                 A QGIS plugin
 Easy load raster tiles file from index vector
                             -------------------
        begin                : 2025-02-01
        copyright            : (C) 2024 by DDT67
        email                : ddt-inondation@bas-rhin.gouv.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


from qgis.PyQt import QtCore, QtGui, QtWidgets
from qgis.core import QgsApplication
import os, traceback
from qgis.utils import iface
from .processing import ProcessingProvider
from .fmt_dockwidget import fmtDockWidget


def classFactory(iface):
    return fmtPlugin(iface)



class fmtPlugin(QtCore.QObject):
    def __init__(self, iface):
        super().__init__()
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.dockwidget = None
        self.pluginName = "FloodMapTools"
        self.provider = None
        
    def initGui(self):
        self.actions = []
        icon_path = os.path.join(self.plugin_dir, "icon.png")
        action = QtWidgets.QAction(QtGui.QIcon(icon_path), self.pluginName, self.iface.mainWindow())
        action.triggered.connect(self.run)
        self.actions.append(action)
        self.iface.addToolBarIcon(action)
        
 #Make menu       
        self.iface.addPluginToMenu(self.pluginName, action)
        
        
        
        for txt in ("A propos", "Autres", "..."):
            action = QtWidgets.QAction(txt, self.iface.mainWindow())
            self.iface.addPluginToMenu(self.pluginName, action)
            self.actions.append(action)
            
            
        self.provider = ProcessingProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)
    
        # self.run()
    

            

    def unload(self):

        try: self.iface.removeToolBarIcon(self.actions[0])
        except: print(traceback.format_exc())
        for a in self.actions:
            try: self.iface.removePluginMenu(self.pluginName, a)
            except: print(traceback.format_exc())
        
        try: self.dockwidget.hide()
        except: pass
        
        try: QgsApplication.processingRegistry().removeProvider(self.provider)
        except: pass

    def run(self):
        if self.dockwidget is None:
            self.dockwidget = fmtDockWidget(self)
            self.iface.addDockWidget(QtCore.Qt.DockWidgetArea.RightDockWidgetArea, self.dockwidget)
        else:
            self.dockwidget.show()