"""
/***************************************************************************
 FieldEvaluator
                                 A QGIS plugin
 Calculates field values by evaluating Python expressions.
                              -------------------
        begin                : 2011-02-09
        copyright            : (C) 2011 by Terglobo
        email                : r.nijssen@terglobo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from fieldevaluatordialog import FieldEvaluatorDialog

class FieldEvaluator:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/fieldevaluator/icon.png"), \
            "Field Evaluator...", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Field Evaluator...", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Field Evaluator...",self.action)
        self.iface.removeToolBarIcon(self.action)

    def getActiveVectorLayer(self):
        # returns the active layer if it is vector
        al = self.iface.activeLayer()
        return al
    
    def getFields(self,lyr,addTypeInfo=False):
        #returns fields for layer
        flds = lyr.pendingAllAttributesList()
        dp = lyr.dataProvider()
        fnm = dp.fields()
        lst = []
        for i,fld in fnm.iteritems():
            #print i
            #print fnm[i]
            #fld
            if addTypeInfo:
                lst.append(fld.name() + " (" + fld.typeName() + ")")
            else:
                lst.append(fld.name())
            #print fld
        return lst
        
    def calcField(self,lyr,fieldNum,expression):
        flds = self.getFields(lyr)
        print expression, type(expression)
        # vervang veldnamen door attr
        for i in range(len(flds)):
            fld = str(flds[i])
            replval = 'attr[' + str(i) + ']'
            expression = expression.replace(fld,replval)
        # loop selected records and update values
        for feat in lyr.selectedFeatures():
            geom = feat.geometry()
            #print geom
            #print feat.id()
            attrs = feat.attributeMap()
            #print attrs
            attr = []
            for i,a in attrs.iteritems():
                attr.append(self.qvariant2value(a))
            print attr
            print expression
            result = eval(expression)
            lyr.changeAttributeValue(feat.id(),fieldNum,result)

    def qvariant2value(self,qv):
        # converts qvariants to python types (only works for int, double and string values)
        if qv.type() == 2:
            return qv.toInt()[0]
        if qv.type() == 10:
            return str(qv.toString())
        if qv.type() == 6:
            return qv.toDouble()
        return None


    # run method that performs all the real work
    def run(self):

        # create and show the dialog
        dlg = FieldEvaluatorDialog()
        # show the dialog
        
        #display layer name
        al = self.getActiveVectorLayer()
        if al:
            geomTypeDict = {0:"point",1:"line",2:"polygon"}
            dlg.ui.label_layer.setText(al.name()+' ('+geomTypeDict[al.geometryType()]+')')
            #display field names
            fns = self.getFields(al)
            dlg.ui.listWidget_fields.clear()
            dlg.ui.listWidget_fields.addItems(fns)
            dlg.ui.comboBox_calcField.addItems(fns)
        else:
            dlg.ui.label_layer.setText('no vector layer selected')
        
        
        
        dlg.show()
        result = dlg.exec_()
        # See if OK was pressed
        if result == 1:
            # do something useful (delete the line containing pass and
            # substitute with your code
            print '---'
            fieldNum = dlg.ui.comboBox_calcField.currentIndex()
            expression = str(dlg.ui.textEdit_expression.toPlainText())
            self.calcField(al,fieldNum,expression)
            
