"""
/***************************************************************************
 FastGeoProcessing
                                 A QGIS plugin
 FastGeoprocessing (union, intersection, ...)
                              -------------------
        begin                : 2011-06-29
        copyright            : (C) 2011 by Romain Riviere
        email                : romain.riviere.974@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from fastgeoprocessingdialog import FastGeoProcessingDialog
#import other code
from types import StringType, NoneType, IntType, BooleanType
import os
from pyspatialite import dbapi2 as sqlite

class FastGeoProcessing:

	def __init__(self, iface):
		# Save reference to the QGIS interface
		self.iface = iface

	def initGui(self):
		# Create action that will start plugin configuration
		self.action = QAction(QIcon(":/plugins/fastgeoprocessing/icon.png"), \
			"FastGeoprocessing", self.iface.mainWindow())
		# connect the action to the run method
		QObject.connect(self.action, SIGNAL("triggered()"), self.run)

		# Add toolbar button and menu item
		self.iface.addToolBarIcon(self.action)
		self.iface.addPluginToMenu("&FastGeoprocessing", self.action)

	def unload(self):
		# Remove the plugin menu item and icon
		self.iface.removePluginMenu("&FastGeoprocessing",self.action)
		self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
	def run(self):
		#select operation to perform
		# create and show the dialog
		dlg = FastGeoProcessingDialog()
		self.ui=dlg.ui
		Operations=['Intersection','Difference','Clip','Union','Nearest neigbour']
		self.ui.Operations.clear()
		self.ui.Operations.insertItems(0, Operations)
		#list QGIS Layers
		layerlist=self.get_layers()
		if len(layerlist)<=0:
			QMessageBox.warning(None, 'No layers', "At Least One vector layer is needed for GeoProcessing")
			return
		self.ui.LayerA.clear()
		self.ui.LayerA.insertItems(0, [name for name,layer in layerlist])
		self.ui.LayerB.clear()
		self.ui.LayerB.insertItems(0, [name for name,layer in layerlist])
		# show the dialog
		dlg.show()
		result = dlg.exec_()
		# See if OK was pressed
		if result == 1:
			# do something useful (delete the line containing pass and
			# substitute with your code
			#pass
			layerA=layerlist[self.ui.LayerA.currentIndex()][1] #get layer A
			layerB=layerlist[self.ui.LayerB.currentIndex()][1] #get layer B
			if layerA.srs()!=layerB.srs():
				QMessageBox.warning(None, 'SRID', 'Layer A SRID is not the same as layer B SRID. layer B SRID will automatically be reprojected in layer A SRID')
				layerB.setCrs(layerA.srs())
			srid=int(layerA.srs().postgisSrid())
	
			#create a memoryDB:
			conn=sqlite.connect(":memory:")
			cursor=conn.cursor()
			#create spatialite table
			cursor.execute('Select initspatialmetadata()')
			
			if not self.save_layer(conn,layerA, 'A', srid, selected=self.ui.selectedA.isChecked()):
				QMessageBox.warning(None, 'Invalid Layer', 'unable to upload layer A in DB')
				return
			if not self.save_layer(conn,layerB, 'B', srid, selected=self.ui.selectedA.isChecked()):
				QMessageBox.warning(None, 'Invalid Layer', 'unable to upload layer B in DB')
				return
			if not self.checkgeom(conn,'A') or not self.checkgeom(conn,'B') :
				QMessageBox.warning(None, 'Invalid geometry', "Layer contains unrepairable geometries. Operation cancelled")
				return
			#Create Spatial Index on table a:	
			try:
				cursor=conn.cursor()
				cursor.execute("SELECT CreateSpatialIndex('A', 'Geometry')")
				conn.commit()
			except conn.OperationalError, errorMsg:
				QMessageBox.warning(None, "SpatiaL Index creation failed." ,errorMsg)
				return
			
			colsa="a.'"+"',a.'".join(self.get_columns(conn,'a'))+"'"
			colsb="b.'"+"',b.'".join(self.get_columns(conn,'b'))+"'"
			start_query="CREATE TABLE res AS "
			rtree=""" AND "A".ROWID IN (
			SELECT pkid FROM "idx_A_Geometry" WHERE pkid MATCH RTreeIntersects(
			MBRminX("B".'Geometry'),MBRminY("B".'Geometry'),MBRmaxX("B".'Geometry'),MBRmaxY("B".'Geometry'))) """
			rtreeNot=""" AND "A".ROWID NOT IN (
			SELECT pkid FROM "idx_A_Geometry" WHERE pkid MATCH RTreeIntersects(
			MBRminX("B".'Geometry'),MBRminY("B".'Geometry'),MBRmaxX("B".'Geometry'),MBRmaxY("B".'Geometry'))) """
			querys=dict()
			querys['Intersection']=[start_query+" SELECT St_multi(St_intersection(a.geometry,b.geometry)) as geometry,%s,%s FROM a,b WHERE st_intersects(a.geometry,b.geometry) "%(colsa,colsb)+rtree]
			querys['Clip']=[start_query+" SELECT St_multi(St_intersection(a.geometry,b.geometry)) as geometry,%s FROM a,b WHERE st_intersects(a.geometry,b.geometry) "%(colsa) + rtree]
			#querys['Union']=" SELECT DISTINCT St_union(a.geometry,b.geometry) as geometry,%s,%s FROM a,b"%(colsa,colsb)
			querys['Difference']=[start_query+" SELECT St_multi(St_difference(a.geometry,b.geometry)) as geometry,%s FROM a,b WHERE not st_within(b.geometry,a.geometry) AND not st_equals(b.geometry,a.geometry)"%(colsa)+rtree+" UNION SELECT a.geometry as geometry,%s FROM a,b WHERE not st_within(b.geometry,a.geometry) AND not st_equals(b.geometry,a.geometry) %s"%(colsa,rtreeNot)]
			querys['Union']=[start_query+"SELECT St_union(geo) as Geometry FROM (SELECT St_union(a.geometry,b.geometry) as geo, %s,%s FROM a,b)"%(colsa,colsb)]
			querys['Nearest neigbour']= ["CREATE TABLE distances AS SELECT a.ROWID as nom1, b.ROWID as nom2, st_distance( a.geometry,b.geometry ) as distance FROM a JOIN b ON ( st_distance( a.geometry,b.geometry )<=1000 AND a.rowid IN ( SELECT pkid FROM idx_a_geometry WHERE pkid MATCH RTreeintersects(MBRminX(b.geometry)-1000, MBRminY(b.geometry)-1000, MBRmaxX(b.geometry)+1000, MBRmaxY(b.geometry)+1000 )))", "CREATE TABLE distances_min AS SELECT nom1 as nom1,min( distance ) as 'distance min'FROM distances GROUP BY 1", "CREATE TABLE c AS SELECT * FROM distances JOIN distances_min ON (distances.nom1=distances_min.nom1 AND distances.distance=distances_min.'distance min')",start_query+"SELECT a.geometry as geometry, %s,%s FROM a,b,c WHERE a.rowid=c.nom1 and b.rowid=c.nom2 GROUP BY 2"%(colsa,colsb) ]

			try:
				for query in querys[unicode(self.ui.Operations.currentText())]:
					conn.execute(query) #execute query
					conn.commit()
			except conn.OperationalError, errorMsg:
				QMessageBox.warning(None, "error While processing" ,"%s"%errorMsg)
				return

			#saving result in a persistent dataBase:
			#create and populate temporary SpatiaLite DB
			path=os.path.join(os.getcwd(),"temp.sqlite")
			if os.path.exists(path): #remove file if already exists
				os.remove(path)
			db=open(path,'w')#create file on HDD
			db.close()
			conn2=sqlite.connect(path)
			conn2.execute('Select initspatialmetadata()')
			cursor.execute("""ATTACH "%s" AS save"""%path)
			cursor.execute("CREATE TABLE save.result AS SELECT * FROM res")
			conn2.commit()
			cursor.close()
			#load result in QGIS
			uri = QgsDataSourceURI()
			uri.setDatabase(path)
			uri.setDataSource('', '(select rowid,* from result)', "geometry", '', "rowid")
			newLayer = QgsVectorLayer(uri.uri(), "result", "spatialite")
			if newLayer.isValid():
				QgsMapLayerRegistry.instance().addMapLayer(newLayer)
			else:
				text = """Result could not be load in QGIS"""
				QMessageBox.warning(None, 'Invalid layer', text)
			conn.close()
			conn2.close()
			newLayer=0


# Return list of all layers in QgsMapLayerRegistry
	def get_layers(self):
		layermap = QgsMapLayerRegistry.instance().mapLayers()
		layerlist = []
		for name, layer in layermap.iteritems():
			if layer.type() == QgsMapLayer.VectorLayer:
				layerlist.append( [unicode( layer.name() ),layer] )
		return layerlist

	def save_layer(self, conn, vlayer, table_name, srid, selected=False):
		try:
			cursor=conn.cursor()
			table_name=unicode(table_name).encode('utf-8').replace('"',"'") #avoid " in layer name
			#retrieve geometry srid and type
			geom=['MULTIPOINT','MULTILINESTRING','MULTIPOLYGON','UnknownGeometry']
			geometry=geom[vlayer.geometryType()]
			#get selected values 
			select_ids=[]
			if selected==True:
				if vlayer.selectedFeatureCount()==0:
					print 'No data selected'
					return False
				select_ids=vlayer.selectedFeaturesIds()

			provider = vlayer.dataProvider()

			fld_names = [name.name() for id,name in provider.fields().iteritems()]  #list with fields names
			fld_names2=[unicode(name).encode('utf-8').replace("'"," ").replace('"'," ") for name in fld_names]  # string list for field name  #avoid ' and " in fields names
			# 1/ decode string 2/and encode in utf-8

			feat = QgsFeature()
			allAttrs = provider.attributeIndexes()

			#select every fields except
			provider.select(allAttrs)

			#Create table with all fields:
			fields='","'.join(fld_names2)
			cursor.execute("""CREATE TABLE "%s" (Geometry,"%s")"""%(table_name,fields))
			cursor.execute("SELECT RecoverGeometryColumn(?,'Geometry',?,?,2)",(table_name,srid,geometry,))
			# retreive every feature with its geometry and attributes
			while provider.nextFeature(feat):
				# selected features:
				if selected==True and feat.id()not in select_ids:
					continue 
				# fetch geometry
				geom = feat.geometry()
				#WKB=geom.asWkb()
				WKT=geom.exportToWkt()

				#prepare SQL Query: PKUID and GEOMETRY
				values_auto=['CastToMulti(GeomFromText("%s",%s))'%(WKT,srid)]
				# fetch map of attributes
				attrs = feat.attributeMap()

				# attrs is a dictionary: key = field index, value = QgsFeatureAttribute
				# show all attributes and their values
				values_perso=[]
				for (k,attr) in attrs.iteritems():
					values_perso.append(attr.toString())
				#Finish SQL query
				cursor.execute("""INSERT INTO "%s" VALUES (%s,%s)"""%(table_name,','.join([unicode(value).encode('utf-8') for value in values_auto]),','.join('?'*len(values_perso))),tuple([unicode(value) for value in values_perso]))

			conn.commit()
			return True
		except conn.OperationalError, errorMsg:
			QMessageBox.warning(None, 'Invalid op', "%s"%errorMsg)
		return False

#Check geometries and try to repair
	def checkgeom(self,conn,tableName,geocol="geometry"):
		cursor=conn.cursor()
		query1 = """SELECT rowid FROM "%s" \n WHERE isValid("%s"."%s")<>1 """ % (tableName,tableName,geocol)
		cursor.execute(query1)
		if len(cursor.fetchall())>0:
			print 'incorrect geometries detected'
			query2 = """UPDATE "%s" \nSET "%s"=sanitizegeometry("%s"."%s")\nWHERE isValid("%s"."%s")<>1"""%(tableName,geocol,tableName,geocol,tableName,geocol)
			cursor.execute(query2)
			conn.commit()
			cursor.execute(query1)
			if len(cursor.fetchall())>0:
				print 'Impossible to repair geometry'
				return False

		else: 
			print "Geometry is valid"
		return True

#get a and b cols, without geometry cols
	def get_columns(self, conn, tableName):   #list columns
		cursor=conn.cursor()
		query = 'PRAGMA table_info("%s")' % tableName
		items=[]
		rep=cursor.execute(query)
		try:
			items=[geo_item[1] for geo_item in rep if unicode(geo_item[1]).lower()!="geometry"]
		except conn.OperationalError, errorMsg:
			print "Invalid Operation.\n\n%s" %errorMsg
		cursor.close()
		return items

