# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeodataAPICollection
								 A QGIS plugin
 This plugin allow you to access a series of geodata published via APIs
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
							  -------------------
		begin                : 2019-11-10
		git sha              : $Format:%H$
		copyright            : (C) 2019 by Diego F Malacarne
		email                : diego.malacarne@yahoo.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt import QtCore, QtGui, QtWidgets
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, QgsVectorLayer
import xml.etree.ElementTree as ET
import csv, urllib.request, datetime
from qgis.utils import iface
import requests


# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .FHR_data_dialog import GeodataAPICollectionDialog
import os.path


class GeodataAPICollection:
	"""QGIS Plugin Implementation."""

	def __init__(self, iface):
		"""Constructor.

		:param iface: An interface instance that will be passed to this class
			which provides the hook by which you can manipulate the QGIS
			application at run time.
		:type iface: QgsInterface
		"""
		# Save reference to the QGIS interface
		self.iface = iface
		# initialize plugin directory
		self.plugin_dir = os.path.dirname(__file__)
		# initialize locale
		locale = QSettings().value('locale/userLocale')[0:2]
		locale_path = os.path.join(
			self.plugin_dir,
			'i18n',
			'GeodataAPICollection_{}.qm'.format(locale))

		if os.path.exists(locale_path):
			self.translator = QTranslator()
			self.translator.load(locale_path)
			QCoreApplication.installTranslator(self.translator)

		# Declare instance attributes
		self.actions = []
		self.menu = self.tr(u'&FHR Data')

		# Check if plugin was started the first time in current QGIS session
		# Must be set in initGui() to survive plugin reloads
		self.first_start = None

	# noinspection PyMethodMayBeStatic
	def tr(self, message):
		"""Get the translation for a string using Qt translation API.

		We implement this ourselves since we do not inherit QObject.

		:param message: String for translation.
		:type message: str, QString

		:returns: Translated version of message.
		:rtype: QString
		"""
		# noinspection PyTypeChecker,PyArgumentList,PyCallByClass
		return QCoreApplication.translate('GeodataAPICollection', message)


	def add_action(
		self,
		icon_path,
		text,
		callback,
		enabled_flag=True,
		add_to_menu=True,
		add_to_toolbar=True,
		status_tip=None,
		whats_this=None,
		parent=None):
		"""Add a toolbar icon to the toolbar.

		:param icon_path: Path to the icon for this action. Can be a resource
			path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
		:type icon_path: str

		:param text: Text that should be shown in menu items for this action.
		:type text: str

		:param callback: Function to be called when the action is triggered.
		:type callback: function

		:param enabled_flag: A flag indicating if the action should be enabled
			by default. Defaults to True.
		:type enabled_flag: bool

		:param add_to_menu: Flag indicating whether the action should also
			be added to the menu. Defaults to True.
		:type add_to_menu: bool

		:param add_to_toolbar: Flag indicating whether the action should also
			be added to the toolbar. Defaults to True.
		:type add_to_toolbar: bool

		:param status_tip: Optional text to show in a popup when mouse pointer
			hovers over the action.
		:type status_tip: str

		:param parent: Parent widget for the new action. Defaults None.
		:type parent: QWidget

		:param whats_this: Optional text to show in the status bar when the
			mouse pointer hovers over the action.

		:returns: The action that was created. Note that the action is also
			added to self.actions list.
		:rtype: QAction
		"""

		icon = QIcon(icon_path)
		action = QAction(icon, text, parent)
		action.triggered.connect(callback)
		action.setEnabled(enabled_flag)

		if status_tip is not None:
			action.setStatusTip(status_tip)

		if whats_this is not None:
			action.setWhatsThis(whats_this)

		if add_to_toolbar:
			# Adds plugin icon to Plugins toolbar
			self.iface.addToolBarIcon(action)

		if add_to_menu:
			self.iface.addPluginToWebMenu(
				self.menu,
				action)

		self.actions.append(action)

		return action

	def initGui(self):
		"""Create the menu entries and toolbar icons inside the QGIS GUI."""

		icon_path = ':/plugins/FHR_data/icon.png'
		self.add_action(
			icon_path,
			text=self.tr(u'FHR Data'),
			callback=self.run,
			parent=self.iface.mainWindow())

		# will be set False in run()
		self.first_start = True


	def unload(self):
		"""Removes the plugin menu item and icon from QGIS GUI."""
		for action in self.actions:
			self.iface.removePluginWebMenu(
				self.tr(u'&FHR Data'),
				action)
			self.iface.removeToolBarIcon(action)

	def saveinfo(self):

		tree = ET.parse(urllib.request.urlopen("https://ratings.food.gov.uk/authorities/en-GB/xml"))
		root = tree.getroot()

		# open a file for writing
		if not os.path.exists('C:/FHR_data'):
			os.makedirs('C:/FHR_data')
		path = 'C:/FHR_data/LA_codes.csv'
		test_data = open(path, 'w')

		# create the csv writer object
		cswwriter = csv.writer(test_data, delimiter='|')
		estabilishment_head = []

		count = 0
		for member in root.findall('WebLocalAuthorityAPI'):
			estabilishment = []
			if count == 0:
				estabilishment_head.append('Name')
				estabilishment_head.append('Code')
				estabilishment_head.append('Creation')
				estabilishment_head.append('Updated')
				estabilishment_head.append('Count')
				w = csv.writer(test_data, delimiter='|')
				w.writerow(estabilishment_head)
				count = count + 1

			if member.find('Name') is not None:
				Name = member.find('Name').text
				estabilishment.append(Name)
			else:
				estabilishment.append('')
			if member.find('LocalAuthorityIdCode') is not None:
				LocalAuthorityIdCode = member.find('LocalAuthorityIdCode').text
				estabilishment.append(LocalAuthorityIdCode)
			else:
				estabilishment.append('')
			if member.find('CreationDate') is not None:
				CreationDate = member.find('CreationDate').text
				estabilishment.append(CreationDate)
			else:
				estabilishment.append('')
			if member.find('LastPublishedDate') is not None:
				LastPublishedDate = member.find('LastPublishedDate').text
				estabilishment.append(LastPublishedDate)
			else:
				estabilishment.append('')
			if member.find('EstablishmentCount') is not None:
				EstablishmentCount = member.find('EstablishmentCount').text
				estabilishment.append(EstablishmentCount)
			else:
				estabilishment.append('')
			w = csv.writer(test_data, delimiter='|')
			w.writerow(estabilishment)
		test_data.close()

		uri = "file:///C:/FHR_data/LA_codes.csv?delimiter=|"
		layer_csv = QgsVectorLayer(uri, "LA_codes", "delimitedtext")
		if not layer_csv.isValid():
			print("Layer failed to load!")

		QgsProject.instance().addMapLayer(layer_csv)
		iface.showAttributeTable(iface.activeLayer())


		datafile = open('C:/FHR_data/LA_codes.csv', 'r')
		myreader = csv.reader(datafile)


		'''
		#import table with LA codes
		la_codes = csv.reader(open('C:/FHR_data/LA_codes.csv', 'rb'), delimiter="|", quotechar='~')
		name, code = [], []

		for row in la_codes:
			name.append(row[0])
			code.append(row[1])


		textbr = self.dlg.textBrowser
		textbr.setText(len(name))
		'''

	def getinfo(self):
		# table setup: https://stackoverflow.com/questions/40815730/how-to-add-and-retrieve-items-to-and-from-qtablewidget
		tree = ET.parse(urllib.request.urlopen("https://ratings.food.gov.uk/authorities/en-GB/xml"))
		root = tree.getroot()
		estabilishment_head = []

		count = 0
		count_b = 0
		for member in root.findall('WebLocalAuthorityAPI'):
			estabilishment = []
			if count == 0:
				estabilishment_head.append('SELECT')
				estabilishment_head.append('Name')
				estabilishment_head.append('Code')
				estabilishment_head.append('Creation')
				estabilishment_head.append('Updated')
				estabilishment_head.append('Count')

			self.dlg.tableWidget.setHorizontalHeaderLabels(estabilishment_head)


			chkBoxItem = QtWidgets.QTableWidgetItem()
			chkBoxItem.setFlags(QtCore.Qt.ItemIsUserCheckable | QtCore.Qt.ItemIsEnabled)
			chkBoxItem.setCheckState(QtCore.Qt.Unchecked)
			self.dlg.tableWidget.setItem(count,0,chkBoxItem)

			if (member.find('Name').text == 'All' or member.find('Name').text == 'England' or member.find('Name').text == 'Northern Ireland' or member.find('Name').text == 'Scotland' or member.find('Name').text == 'Wales'):
				count_b = count_b - 1
			else:
				if member.find('Name') is not None:
					self.dlg.tableWidget.setItem(count_b, 1, QtWidgets.QTableWidgetItem(member.find('Name').text))
				else:
					self.dlg.tableWidget.setItem(count_b, 1, QtWidgets.QTableWidgetItem('XX-empty-XX'))

				if member.find('LocalAuthorityIdCode') is not None:
					self.dlg.tableWidget.setItem(count_b, 2, QtWidgets.QTableWidgetItem(member.find('LocalAuthorityIdCode').text))
				else:
					self.dlg.tableWidget.setItem(count_b, 2, QtWidgets.QTableWidgetItem('XX-empty-XX'))

				if member.find('CreationDate') is not None:
					self.dlg.tableWidget.setItem(count_b, 3, QtWidgets.QTableWidgetItem(member.find('CreationDate').text))
				else:
					self.dlg.tableWidget.setItem(count_b, 3, QtWidgets.QTableWidgetItem('XX-empty-XX'))

				if member.find('LastPublishedDate') is not None:
					self.dlg.tableWidget.setItem(count_b, 4, QtWidgets.QTableWidgetItem(member.find('LastPublishedDate').text))
				else:
					self.dlg.tableWidget.setItem(count_b, 4, QtWidgets.QTableWidgetItem('XX-empty-XX'))

				if member.find('EstablishmentCount') is not None:
					self.dlg.tableWidget.setItem(count_b, 5, QtWidgets.QTableWidgetItem(member.find('EstablishmentCount').text))
				else:
					self.dlg.tableWidget.setItem(count_b, 5, QtWidgets.QTableWidgetItem('XX-empty-XX'))

			count = count + 1
			count_b = count_b + 1



	def download(self):
		position = []
		code = []
		name = []
		pos = 0
		count = 0
		for x in range(400):
			if self.dlg.tableWidget.item(count, 0).checkState() == QtCore.Qt.Checked:
				code.append(self.dlg.tableWidget.item(count, 2).text())
				name.append(self.dlg.tableWidget.item(count, 1).text())
				position.append(pos)
				pos = pos + 1
			count = count + 1

		for x in range(len(position)):
			print(position[x])
			print(code[x])
			print(name[x])
		print(code[1])

		for n in position:
			now = datetime.datetime.now()
			tree = ET.parse(urllib.request.urlopen("https://ratings.food.gov.uk/OpenDataFiles/FHRS%sen-GB.xml" % code[n]))
			root = tree.getroot()

			# open a file for writing
			if not os.path.exists('C:/FHR_data'):
				os.makedirs('C:/FHR_data')
			path = 'C:/FHR_data/{}_{}_{}_{}.csv'.format(name[n], now.year, now.month, now.day)
			test_data = open(path, 'w')

			# create the csv writer object
			csvwriter = csv.writer(test_data, delimiter='|')
			estabilishment_head = []

			count = 0
			for member in root.find('EstablishmentCollection').findall('EstablishmentDetail'):
				estabilishment = []
				if count == 0:
					estabilishment_head.append('FHRSID')
					estabilishment_head.append('LocalAuthorityBusinessID')
					estabilishment_head.append('BusinessName')
					estabilishment_head.append('BusinessType')
					estabilishment_head.append('BusinessTypeID')
					estabilishment_head.append('AddressLine1')
					estabilishment_head.append('AddressLine2')
					estabilishment_head.append('AddressLine3')
					estabilishment_head.append('AddressLine4')
					estabilishment_head.append('PostCode')
					estabilishment_head.append('RatingValue')
					estabilishment_head.append('RatingKey')
					estabilishment_head.append('RatingDate')
					estabilishment_head.append('Hygiene')
					estabilishment_head.append('Structural')
					estabilishment_head.append('ConfidenceInManagement')
					estabilishment_head.append('Longitude')
					estabilishment_head.append('Latitude')
					w = csv.writer(test_data, delimiter='|')
					w.writerow(estabilishment_head)
					count = count + 1

				if member.find('FHRSID') is not None:
					FHRSID = member.find('FHRSID').text
					estabilishment.append(FHRSID)
				else:
					estabilishment.append('')
				if member.find('LocalAuthorityBusinessID') is not None:
					LocalAuthorityBusinessID = member.find('LocalAuthorityBusinessID').text
					estabilishment.append(LocalAuthorityBusinessID)
				else:
					estabilishment.append('')
				if member.find('BusinessName') is not None:
					BusinessName = member.find('BusinessName').text
					estabilishment.append(BusinessName)
				else:
					estabilishment.append('')
				if member.find('BusinessType') is not None:
					BusinessType = member.find('BusinessType').text
					estabilishment.append(BusinessType)
				else:
					estabilishment.append('')
				if member.find('BusinessTypeID') is not None:
					BusinessTypeID = member.find('BusinessTypeID').text
					estabilishment.append(BusinessTypeID)
				else:
					estabilishment.append('')
				if member.find('AddressLine1') is not None:
					AddressLine1 = member.find('AddressLine1').text
					estabilishment.append(AddressLine1)
				else:
					estabilishment.append('')
				if member.find('AddressLine2') is not None:
					AddressLine2 = member.find('AddressLine2').text
					estabilishment.append(AddressLine2)
				else:
					estabilishment.append('')
				if member.find('AddressLine3') is not None:
					AddressLine3 = member.find('AddressLine3').text
					estabilishment.append(AddressLine3)
				else:
					estabilishment.append('')
				if member.find('AddressLine4') is not None:
					AddressLine4 = member.find('AddressLine4').text
					estabilishment.append(AddressLine4)
				else:
					estabilishment.append('')
				if member.find('PostCode') is not None:
					PostCode = member.find('PostCode').text
					estabilishment.append(PostCode)
				else:
					estabilishment.append('')
				if member.find('RatingValue') is not None:
					RatingValue = member.find('RatingValue').text
					estabilishment.append(RatingValue)
				else:
					estabilishment.append('')
				if member.find('RatingKey') is not None:
					RatingKey = member.find('RatingKey').text
					estabilishment.append(RatingKey)
				else:
					estabilishment.append('')
				if member.find('RatingDate') is not None:
					RatingDate = member.find('RatingDate').text
					estabilishment.append(RatingDate)
				else:
					estabilishment.append('')
				if member.find('Scores') is not None:
					if member.find('Scores').find('Hygiene') is not None:
						Hygiene = member.find('Scores').find('Hygiene').text
						estabilishment.append(Hygiene)
					else:
						estabilishment.append('')
					if member.find('Scores').find('Structural') is not None:
						Structural = member.find('Scores').find('Structural').text
						estabilishment.append(Structural)
					else:
						estabilishment.append('')
					if member.find('Scores').find('ConfidenceInManagement') is not None:
						ConfidenceInManagement = member.find('Scores').find('ConfidenceInManagement').text
						estabilishment.append(ConfidenceInManagement)
					else:
						estabilishment.append('')
				else:
					estabilishment.append('')
					estabilishment.append('')
					estabilishment.append('')
				if member.find('Geocode') is not None:
					if member.find('Geocode').find('Longitude') is not None:
						Longitude = member.find('Geocode').find('Longitude').text
						estabilishment.append(Longitude)
					else:
						estabilishment.append('')
					if member.find('Geocode').find('Latitude') is not None:
						Latitude = member.find('Geocode').find('Latitude').text
						estabilishment.append(Latitude)
					else:
						estabilishment.append('')
				else:
					estabilishment.append('')
					estabilishment.append('')
				w = csv.writer(test_data, delimiter='|')
				w.writerow(estabilishment)
			test_data.close()


			uri = "file:///C:/FHR_data/{}_{}_{}_{}.csv?crs=EPSG:4326&delimiter={}&xField={}&yField={}".format(name[n], now.year, now.month, now.day, "|", "Longitude", "Latitude")
			layer_csv = QgsVectorLayer(uri, name[n] + "_" + str(now.year) + "_" + str(now.month) + "_" + str(now.day), "delimitedtext")
			if not layer_csv.isValid():
				print("Layer failed to load!")

			QgsProject.instance().addMapLayer(layer_csv)

	def selectall(self):
		for x in range(400):
			if self.dlg.tableWidget.item(x, 1) is not None:
				chkBoxItem = QtWidgets.QTableWidgetItem()
				chkBoxItem.setFlags(QtCore.Qt.ItemIsUserCheckable | QtCore.Qt.ItemIsEnabled)
				chkBoxItem.setCheckState(QtCore.Qt.Checked)
				self.dlg.tableWidget.setItem(x,0,chkBoxItem)


	def unselectall(self):
		for x in range(400):
			chkBoxItem = QtWidgets.QTableWidgetItem()
			chkBoxItem.setFlags(QtCore.Qt.ItemIsUserCheckable | QtCore.Qt.ItemIsEnabled)
			chkBoxItem.setCheckState(QtCore.Qt.Unchecked)
			self.dlg.tableWidget.setItem(x,0,chkBoxItem)


	def run(self):
		"""Run method that performs all the real work"""

		# Create the dialog with elements (after translation) and keep reference
		# Only create GUI ONCE in callback, so that it will only load when the plugin is started
		if self.first_start == True:
			self.first_start = False
			self.dlg = GeodataAPICollectionDialog()
			self.dlg.pushButton_2.clicked.connect(self.saveinfo)
			self.dlg.pushButton.clicked.connect(self.download)
			self.dlg.pushButton_3.clicked.connect(self.getinfo)
			self.dlg.pushButton_4.clicked.connect(self.selectall)
			self.dlg.pushButton_5.clicked.connect(self.unselectall)

		# show the dialog
		self.dlg.show()
		# Run the dialog event loop
		result = self.dlg.exec_()
		# See if OK was pressed
		if result:
			# Do something useful here - delete the line containing pass and
			# substitute with your code.
			pass
