from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction
import os.path
from .EvapoGIS_dialog import EvapoGISDialog

class EvapoGIS:
    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.actions = []
        self.menu = self.tr(u'&EvapoGIS')
        self.toolbar = self.iface.addToolBar(u'EvapoGIS')
        self.toolbar.setObjectName(u'EvapoGIS')

    def tr(self, message):
        return QCoreApplication.translate('EvapoGIS', message)

    def add_action(self, icon_path, text, callback, enabled_flag=True, add_to_menu=True, add_to_toolbar=True, status_tip=None, whats_this=None, parent=None):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)
        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)
        if add_to_toolbar:
            self.toolbar.addAction(action)
        self.actions.append(action)
        return action

    def initGui(self):
        icon_path = ':/plugins/evapogis/icon.png'
        self.add_action(icon_path, text=self.tr(u'EvapoGIS'), callback=self.run, parent=self.iface.mainWindow())

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&EvapoGIS'), action)
            self.iface.removeToolBarIcon(action)
        del self.toolbar

    def run(self):
        dlg = EvapoGISDialog()
        dlg.show()
        result = dlg.exec_()
        if result:
            pass
