# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EA_Slope
                                 A QGIS plugin
 function provides for estimating the equal area slopes
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-09-06
        git sha              : $Format:%H$
        copyright            : (C) 2021 by WSP Global & The University and Queensland
        email                : ray.shi@wsp.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication,QVariant
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import *
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .EA_Slope_dialog import EA_SlopeDialog
import os.path
import math
import numpy as np


class EA_Slope:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'EA_Slope_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&EA_Slope')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('EA_Slope', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/EA_Slope/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u''),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&EA_Slope'),
                action)
            self.iface.removeToolBarIcon(action)


    def samplepoint(self,d, geom, rlayer):
        p = QgsGeometry.fromPointXY(geom.interpolate(d).asPoint())
        c = p.asPoint()
        p1 = rlayer.dataProvider().identify(QgsPointXY(c),
                                            QgsRaster.IdentifyFormatValue)
        return p1.results()[1]

    def traparea(self,Elv, k, L):
        # trapezoidal rule calculation
        a = 0  # Initial area
        j = 0  # Counter
        while j < k:
            s1 = Elv[j].item(0)  # distance at first Point
            s2 = Elv[j + 1].item(0)  # distance at second Point
            ds = abs(s2 - s1)  # change in distance

            z1 = Elv[j].item(1)  # elevation at first point
            z2 = Elv[j + 1].item(1)  # elevation at second point
            az = (z1 + z2) / 2  # average elevation

            a += ds * az  # area for finite steps
            j += 1
        z1 = min(Elv[k].item(1), Elv[0].item(1))
        z2 = ((2 * a) / L) - z1

        eas = 100 * (z2 - z1) / L
        return eas

    def pass_1(self,geom, rlayer, rs):

        L = geom.length()  # Length of the line segment
        Elv = np.empty((0, 2))  # Create a empty matrix
        z = self.samplepoint(0, geom, rlayer)  # Interpolate the point
        Elv = np.append(Elv, np.array([[0, z]]), axis=0)  # Append the matrix
        d = 0  # initial value for the length
        k = 1  # Setup the count
        while d < L:
            # Interpolate the point 1
            p1 = QgsGeometry.fromPointXY(geom.interpolate(d).asPoint())
            x1 = p1.centroid().asPoint().x()  # x coordinate
            y1 = p1.centroid().asPoint().y()  # y coordinate
            # Interpolate the point 2
            p2 = QgsGeometry.fromPointXY(geom.interpolate(d + rs).asPoint())
            x2 = p2.centroid().asPoint().x()  # x coordinate
            y2 = p2.centroid().asPoint().y()  # y coordinate

            dx = abs(x1 - x2)  # change in x
            dy = abs(y1 - y2)  # change in y
            ds = math.sqrt(dx ** 2 + dy ** 2)  # change in distance

            s = rs * ds / max(dx, dy)
            d += s
            if d + s >= L:
                break
            z = self.samplepoint(d, geom, rlayer)
            Elv = np.append(Elv, np.array([[d, z]]), axis=0)
            k += 1
        z = self.samplepoint(L, geom, rlayer)
        Elv = np.append(Elv, np.array([[L, z]]), axis=0)
        # np.savetxt("C:/Users/s4340789/Desktop/QGIS_Plugins/EAS_forward.csv", Elv, delimiter=",")
        return self.traparea(Elv, k, L)

    def pass_2(self,geom, rlayer, rs):

        L = geom.length()  # Length of the line segment
        Elv = np.empty((0, 2))  # Create a empty matrix
        z = self.samplepoint(L, geom, rlayer)  # Interpolate the point
        Elv = np.append(Elv, np.array([[L, z]]), axis=0)  # Append the matrix
        d = L  # initial value for the length
        k = 1  # Setup the count

        while d > 0:
            # Interpolate the point 1

            p1 = QgsGeometry.fromPointXY(geom.interpolate(d).asPoint())

            x1 = p1.centroid().asPoint().x()  # x coordinate
            y1 = p1.centroid().asPoint().y()  # y coordinate
            # Interpolate the point 2
            p2 = QgsGeometry.fromPointXY(geom.interpolate(d - rs).asPoint())
            x2 = p2.centroid().asPoint().x()  # x coordinate
            y2 = p2.centroid().asPoint().y()  # y coordinate

            dx = abs(x1 - x2)  # change in x
            dy = abs(y1 - y2)  # change in y
            ds = math.sqrt(dx ** 2 + dy ** 2)  # change in distance

            s = rs * ds / max(dx, dy)
            d -= s
            if d - s <= 0:
                break

            z = self.samplepoint(d, geom, rlayer)
            Elv = np.append(Elv, np.array([[d, z]]), axis=0)
            k += 1
        z = self.samplepoint(0, geom, rlayer)
        Elv = np.append(Elv, np.array([[0, z]]), axis=0)

        # np.savetxt("C:/Users/s4340789/Desktop/QGIS_Plugins/EAS_backward.csv", Elv, delimiter=",")
        return self.traparea(Elv, k, L)

    def main(self,vlayer,rlayer,filename):

        rx = rlayer.rasterUnitsPerPixelX()
        ry = rlayer.rasterUnitsPerPixelY()
        rs = min(rx, ry)
        feats = vlayer.getFeatures()
        vcrs = vlayer.crs().authid()
        attr = vlayer.dataProvider().fields().toList()

        mem_layer = QgsVectorLayer("LineString?crs=" + vcrs, "duplicated_layer", "memory")
        mem_layer_data = mem_layer.dataProvider()
        mem_layer_data.addAttributes(attr)
        mem_layer_data.addFeatures(feats)
        mem_layer_data.addAttributes([QgsField('EAS', QVariant.String)])

        mem_layer.updateFields()

        with edit(mem_layer):
            for feat in mem_layer.getFeatures():
                geom = feat.geometry()
                pl = geom.asMultiPolyline()
                geomSingleType = QgsWkbTypes.isSingleType(geom.wkbType())
                if geom.type() == QgsWkbTypes.LineGeometry:
                    if geomSingleType:
                        # print('SingleType')
                        pass
                    else:
                        # print('MulitType')
                        pass

                attrs = feat.attributes()
                eas1 = self.pass_1(geom, rlayer, rs)
                eas2 = self.pass_2(geom, rlayer, rs)
                eas = (eas1 + eas2) / 2
                feat['EAS'] = eas
                mem_layer.updateFeature(feat)

        QgsProject.instance().addMapLayer(mem_layer)

        if not filename:
            print('No CSV output')
        else:
            print('No CSV output at '+filename)
            with open(filename, 'w') as f:
                fields = [field.name() for field in mem_layer.fields()]
                row = ','.join(fields) + '\n'
                f.write(row)
                for feature in mem_layer.getFeatures():
                    row = ','.join(str(feature[field]) for field in fields) + '\n'
                    f.write(row)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = EA_SlopeDialog()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            vlayer = self.dlg.vMapLayerComboBox.currentLayer()
            rlayer = self.dlg.rMapLayerComboBox.currentLayer()
            filename = self.dlg.lineEdit.text()
            self.main(vlayer,rlayer,filename)
            pass
