# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EditAnyLayerDialog
                                 A QGIS plugin
 Make any vector layer editable by first converting it to a memory layer (memory provider).
                             -------------------
        begin                : 2012-07-27
        copyright            : (C) 2012 by Rob Nickerson
        email                : rob.j.nickerson AT gmail
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4 import QtCore, QtGui
from ui_editanylayer import Ui_EditAnyLayer
from qgis.core import *
import sys

# create the dialog
class EditAnyLayerDialog(QtGui.QDialog):
    def __init__(self):
        QtGui.QDialog.__init__(self)
        # Set up the user interface from Designer.
        self.ui = Ui_EditAnyLayer()
        self.ui.setupUi(self)
        self.result = 0
        self.ui.inShape.clear()
        # Add layer names to drop down menu
        layermap = QgsMapLayerRegistry.instance().mapLayers()
        for name, layer in layermap.iteritems():
            if layer.type() == QgsMapLayer.VectorLayer:
                print "adding layer:"
                print layer.name()
                print layer.getLayerID()
                self.ui.inShape.addItem( layer.name(),QtCore.QVariant(layer.getLayerID()) )

    def accept(self):
        if self.ui.inShape.currentText() == "":
            QtGui.QMessageBox.information(self, self.tr("Geometry"), self.tr( "Please specify input vector layer" ) )
        elif self.ui.outShape.text() == "":
            QtGui.QMessageBox.information(self, self.tr("Geometry"), self.tr( "Please specify output name" ) )
        else:
            self.result = 1
            self.close()

