# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EditAnyLayer
                                 A QGIS plugin
 Make any vector layer editable by first converting it to a memory layer (memory provider).
                              -------------------
        begin                : 2012-07-27
        copyright            : (C) 2012 by Rob Nickerson
        email                : rob.j.nickerson AT gmail
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources_rc
# Import the code for the dialog
from editanylayerdialog import EditAnyLayerDialog

class EditAnyLayer:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + "/python/plugins/editanylayer"
        # initialize locale
        localePath = ""
        locale = QSettings().value("locale/userLocale").toString()[0:2]
       
        if QFileInfo(self.plugin_dir).exists():
            localePath = self.plugin_dir + "/i18n/editanylayer_" + locale + ".qm"

        if QFileInfo(localePath).exists():
            self.translator = QTranslator()
            self.translator.load(localePath)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
   

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/editanylayer/icon.png"), \
            u"Create Editable Layer...", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"E&dit Any Layer", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&E&dit Any Layer",self.action)
        self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
    def run(self):
        # Create the dialog and keep reference
        dlg = EditAnyLayerDialog()
        # Run the dialog event loop
        dlg.exec_()
        # See if OK was pressed
        if dlg.result == 1:
            # run the actual procedure:
            # 1. Get the selected layer
            uniqueId = dlg.ui.inShape.itemData(dlg.ui.inShape.currentIndex()).toString()
            vlayer = QgsMapLayerRegistry.instance().mapLayer(uniqueId) 
            vprovider = vlayer.dataProvider()
            allAttrs = vprovider.attributeIndexes()
            vprovider.select( allAttrs )
            fields = vprovider.fields()
            if vlayer.geometryType() == 0:
                geomtype = 'Point'
            elif vlayer.geometryType() == 1:
                geomtype = 'LineString'
            elif vlayer.geometryType() == 2:
                geomtype = 'Polygon'
            else:
                #error
                return
            geomtype = geomtype + '?crs=proj4:' + vprovider.crs().toProj4()
                                                  #QgsProject.instance().readEntry("SpatialRefSys","/ProjectCRSProj4String")[0]
            # 2. create new memory layer:
            mlayer = QgsVectorLayer(geomtype, dlg.ui.outShape.text(), "memory")
            mprovider = mlayer.dataProvider()
            # 3. copy attributes to new layer
            for key, value in fields.iteritems():
                mprovider.addAttributes([ value ])
            # 4. copy features to new layer
            inFeat = QgsFeature()
            outFeat = QgsFeature()
            while vprovider.nextFeature( inFeat ):
                outFeat = inFeat
                mprovider.addFeatures( [ outFeat ] )
            # Update and add layer to legend
            mlayer.updateExtents()
            mlayer.updateFieldMap()
            QgsMapLayerRegistry.instance().addMapLayer(mlayer)
























