# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EdgeDensifier
                                 A QGIS plugin
 Densify a selected edge from a polygon
                              -------------------
        begin                : 2012-10-01
        copyright            : (C) 2012 by Alejandro Sierra / UNAM
        email                : algsierra@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
# Initialize Qt resources from file resources.py
import resources_rc
# Import the code for the dialog
from edgedensifierdialog import EdgeDensifierDialog

class EdgeDensifier:

	def __init__(self, iface):
		# Save reference to the QGIS interface
		self.iface = iface
		self.canvas = self.iface.mapCanvas()

		self.QgisVersion = str(QGis.QGIS_VERSION)
		self.undoAvailable = None
		if int(self.QgisVersion[0]) == 1:
			if int(self.QgisVersion[2]) >= 2: 
				self.undoAvailable = True
		else:
			self.undoAvailable = False
		if int(self.QgisVersion[0] > 1):
			self.undoAvailable = True

		self.dlg = EdgeDensifierDialog()
		self.plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + "/python/plugins/edgedensifier"
		# initialize locale
		localePath = ""
		locale = QSettings().value("locale/userLocale").toString()[0:2]
		if QFileInfo(self.plugin_dir).exists():
			localePath = self.plugin_dir + "/i18n/edgedensifier_" + locale + ".qm"
		if QFileInfo(localePath).exists():
			self.translator = QTranslator()
			self.translator.load(localePath)
			if qVersion() > '4.3.3':
				QCoreApplication.installTranslator(self.translator)

	def initGui(self):
		self.action = QAction(QIcon(":/plugins/edgedensifier/icon.png"), \
		u"Edge densifier", self.iface.mainWindow())
		self.action.setEnabled(False)
		self.action.setCheckable(True)
		QObject.connect(self.action, SIGNAL("triggered()"), self.run)
		QObject.connect(self.iface, SIGNAL("currentLayerChanged(QgsMapLayer*)"), self.toggle)
		self.iface.digitizeToolBar().addAction(self.action)
		self.iface.addPluginToMenu(u"&Edge densifier", self.action)

	def unload(self):
		self.iface.removePluginMenu(u"&Edge densifier",self.action)
		self.iface.removeToolBarIcon(self.action)

	def run(self):
		self.canvas = self.iface.mapCanvas()
		layer = self.canvas.currentLayer()
		if layer.type() != 0:
				QMessageBox.information( self.iface.mainWindow(),"Error", "This is not a vector layer "+layer.type())
		elif (layer.geometryType()!=QGis.Polygon):
				QMessageBox.information( self.iface.mainWindow(),"Error", "This is not a polygon "+str(layer.geometryType()))
		else:
			self.dlg.show()
			result = self.dlg.exec_()
			if result == 1:
				feaId = int(self.dlg.ui.lineFea.text())
				idx = int(self.dlg.ui.lineIndex.text())
				num = int(self.dlg.ui.lineNum.text())
				fea = QgsFeature()
				if not layer.featureAtId(feaId, fea):
					QMessageBox.information(self.iface.mainWindow(),"Error", "There is not feature "+str(feaId))
				else:
					geo = fea.geometry()
					#preIdx = postIdx = -1
					preIdx, postIdx =geo.adjacentVertices(idx)
					p1 = geo.vertexAt(idx)
					p2 = geo.vertexAt(preIdx)
					dx = p2.x() - p1.x()
					dy = p2.y() - p1.y()
					if self.undoAvailable:
						layer.beginEditCommand("Added Vertices")
					for i in range(1, num+1):
						t = i/float(num+1)
						x = p1.x() + dx*t
						y = p1.y() + dy*t
						layer.insertVertex(x, y, feaId, idx)
					if self.undoAvailable:
						layer.endEditCommand()
					self.canvas.refresh()

	def toggle(self):
		mc = self.canvas
		layer = mc.currentLayer()

		#Decide whether the plugin button/menu is enabled or disabled
		if layer <> None:
			if layer.isEditable():
				self.action.setEnabled(True)
				QObject.connect(layer,SIGNAL("editingStopped()"),self.toggle)
				QObject.disconnect(layer,SIGNAL("editingStarted()"),self.toggle)
			else:
				self.action.setEnabled(False)
				QObject.connect(layer,SIGNAL("editingStarted()"),self.toggle)
				QObject.disconnect(layer,SIGNAL("editingStopped()"),self.toggle)
