#  The aim of this code is to centralise the production of all wastewater that ends up in the unitary sewage system.
#
#  Author: Miguel José ÁLVAREZ VELÁSQUEZ
#  Created on: 30/04/2023

# pylint: skip-file

from datetime import datetime  # This allows to work with the correct time format

import pandas as pd  # What does pandas do?


def WASTEWATER(wastewater_pattern, ww_time_col_name, ww_flow_col_name, full_study_period, hab, EH):
    ww_flow = []  # Initialization of a list that will store wastewater flow.
    p_ww_flow = []  # Initialization of a list that will store the percentage of wastewater flow.
    ww = pd.read_csv(wastewater_pattern, delimiter=";")  # Reads the wastewater pattern CSV file.
    ww_date = ww[
        ww_time_col_name
    ].values  # Takes the values of the column called as the user indicated for the ww time values.
    ww_flow_pattern = ww[
        ww_flow_col_name
    ].values  # Takes the values of the column called 'Debit (m3/s) autosurveillance'.

    for i in range(len(ww_date)):
        ww_date[i] = datetime.strptime(ww_date[i], "%H:%M:%S")  ##Conversion to datetime.datetime

    total_flow_in_a_day = sum(ww_flow_pattern)  # We add all the flows of the day

    for i in range(len(ww_flow_pattern)):
        p_ww_flow.append(ww_flow_pattern[i] / total_flow_in_a_day)  # We generate the percentage of wastewater flow

    ww_date_hour = []  # We generate a list with the hours of the day. From 0 to 23.
    for i in range(len(ww_date)):
        ww_date_hour.append(ww_date[i].hour)

    # We compare the hours of each time interval in both lists and if they match, we add the flow generated by the inhabitants
    # at the given hour to the "ww_flow" list
    for i in range(len(full_study_period)):
        for j in range(len(ww_date_hour)):
            if full_study_period[i].hour == ww_date_hour[j]:
                ww_flow.append(p_ww_flow[j] * hab * EH * (1 / (1000 * 24 * 3600)))

    # We obtain the wastewater flow in m3/s for each time interval of the studied period

    return ww_flow
