CREATE EXTENSION IF NOT EXISTS "uuid-ossp"#
CREATE EXTENSION IF NOT EXISTS hstore#
CREATE EXTENSION IF NOT EXISTS postgis#
COMMENT ON EXTENSION postgis IS 'PostGIS geometry, geography, and raster spatial types and functions'#
CREATE EXTENSION IF NOT EXISTS postgis_topology#
COMMENT ON EXTENSION postgis_topology IS 'PostGIS topology spatial types and functions'#
CREATE SCHEMA complexos#
ALTER SCHEMA complexos OWNER TO postgres#
CREATE SCHEMA dominios#
ALTER SCHEMA dominios OWNER TO postgres#
CREATE SCHEMA edgv#
ALTER SCHEMA edgv OWNER TO postgres#
CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog#
COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language'#
SET search_path = complexos, pg_catalog#
CREATE TABLE aer_complexo_aeroportuario (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    siglaicao character varying(4),
    siglaiata character varying(3),
    tipocomplexoaero smallint NOT NULL,
    classificacao smallint NOT NULL,
    latoficial character varying(80),
    longoficial character varying(80),
    altitude real
)#
ALTER TABLE aer_complexo_aeroportuario OWNER TO postgres#
CREATE TABLE cbge_assentamento_precario (
    id uuid NOT NULL,
    tipoassprec smallint NOT NULL
)#
ALTER TABLE cbge_assentamento_precario OWNER TO postgres#
CREATE TABLE cbge_complexo_habitacional (
    id uuid NOT NULL,
    nome character varying(80),
    id_localidade uuid,
    id_capital uuid,
    id_cidade uuid,
    id_vila uuid,
    id_aglomerado_rural uuid,
    id_aglomerado_rural_isolado uuid,
    id_aglomerado_rural_de_extensao_urbana uuid
)#
ALTER TABLE cbge_complexo_habitacional OWNER TO postgres#
CREATE TABLE cbge_condominio (
    id uuid NOT NULL,
    nome character varying(80),
    id_localidade uuid,
    id_capital uuid,
    id_cidade uuid,
    id_vila uuid,
    id_aglomerado_rural uuid,
    id_aglomerado_rural_isolado uuid,
    id_aglomerado_rural_de_extensao_urbana uuid
)#
ALTER TABLE cbge_condominio OWNER TO postgres#
CREATE TABLE cbge_conjunto_habitacional (
    id uuid NOT NULL,
    nome character varying(80),
    id_assentamento_precario uuid
)#
ALTER TABLE cbge_conjunto_habitacional OWNER TO postgres#
CREATE TABLE emu_terminal_ferroviario (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipoestrut smallint NOT NULL,
    tipoexposicao smallint NOT NULL
)#
ALTER TABLE emu_terminal_ferroviario OWNER TO postgres#
CREATE TABLE emu_terminal_hidroviario (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipoestrut smallint NOT NULL,
    tipoexposicao smallint NOT NULL
)#
ALTER TABLE emu_terminal_hidroviario OWNER TO postgres#
CREATE TABLE emu_terminal_rodoviario (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipoestrut smallint NOT NULL,
    tipoexposicao smallint NOT NULL
)#
ALTER TABLE emu_terminal_rodoviario OWNER TO postgres#
CREATE TABLE enc_complexo_comunicacao (
    id uuid NOT NULL,
    nome character varying(80),
    classeativecon smallint NOT NULL,
    operacional smallint NOT NULL
)#
ALTER TABLE enc_complexo_comunicacao OWNER TO postgres#
CREATE TABLE enc_complexo_gerador_energia_eletrica (
    id uuid NOT NULL,
    nome character varying(80),
    classeativecon smallint NOT NULL,
    operacional smallint NOT NULL
)#
ALTER TABLE enc_complexo_gerador_energia_eletrica OWNER TO postgres#
CREATE TABLE enc_subest_transm_distrib_energia_eletrica (
    id uuid NOT NULL,
    nome character varying(80),
    idtsub integer,
    classeativecon smallint NOT NULL,
    centrodecarga smallint NOT NULL,
    operacional smallint NOT NULL,
    id_complexo_gerador_energia_eletrica uuid
)#
ALTER TABLE enc_subest_transm_distrib_energia_eletrica OWNER TO postgres#
CREATE TABLE fer_estacao_ferroviaria (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipoestrut smallint NOT NULL,
    tipoexposicao smallint NOT NULL
)#
ALTER TABLE fer_estacao_ferroviaria OWNER TO postgres#
CREATE TABLE fer_estacao_metroviaria (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipoestrut smallint NOT NULL,
    tipoexposicao smallint NOT NULL
)#
ALTER TABLE fer_estacao_metroviaria OWNER TO postgres#
CREATE TABLE hdv_complexo_portuario (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipotransporte smallint NOT NULL,
    tipocomplexoportuario smallint NOT NULL,
    portosempapel smallint NOT NULL,
    id_complexo_portuario uuid
)#
ALTER TABLE hdv_complexo_portuario OWNER TO postgres#
CREATE TABLE laz_complexo_desportivo (
    id uuid NOT NULL,
    nome character varying(80),
    divisaoativecon smallint NOT NULL,
    operacional smallint,
    administracao smallint NOT NULL,
    turistico smallint,
    cultura smallint
)#
ALTER TABLE laz_complexo_desportivo OWNER TO postgres#
CREATE TABLE laz_complexo_desportivo_lazer (
    id uuid NOT NULL,
    nome character varying(80),
    divisaoativecon smallint NOT NULL,
    operacional smallint,
    administracao smallint NOT NULL,
    turistico smallint,
    cultura smallint
)#
ALTER TABLE laz_complexo_desportivo_lazer OWNER TO postgres#
CREATE TABLE laz_complexo_recreativo (
    id uuid NOT NULL,
    nome character varying(80),
    divisaoativecon smallint NOT NULL,
    operacional smallint,
    administracao smallint NOT NULL,
    turistico smallint,
    cultura smallint
)#
ALTER TABLE laz_complexo_recreativo OWNER TO postgres#
CREATE TABLE lml_aglomerado_rural (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geocodigo character varying(80)
)#
ALTER TABLE lml_aglomerado_rural OWNER TO postgres#
CREATE TABLE lml_aglomerado_rural_de_extensao_urbana (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geocodigo character varying(80)
)#
ALTER TABLE lml_aglomerado_rural_de_extensao_urbana OWNER TO postgres#
CREATE TABLE lml_aglomerado_rural_isolado (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geocodigo character varying(80),
    tipoaglomrurisol smallint NOT NULL
)#
ALTER TABLE lml_aglomerado_rural_isolado OWNER TO postgres#
CREATE TABLE lml_aldeia_indigena (
    id uuid NOT NULL,
    nome character varying(80),
    codigofunai character varying(80),
    terraindigena character varying(80),
    etnia character varying(80),
    id_localidade uuid,
    id_capital uuid,
    id_cidade uuid,
    id_vila uuid,
    id_aglomerado_rural uuid,
    id_aglomerado_rural_isolado uuid,
    id_aglomerado_rural_de_extensao_urbana uuid
)#
ALTER TABLE lml_aldeia_indigena OWNER TO postgres#
CREATE TABLE lml_capital (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geocodigo character varying(80),
    tipocapital smallint NOT NULL
)#
ALTER TABLE lml_capital OWNER TO postgres#
CREATE TABLE lml_cidade (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geocodigo character varying(80)
)#
ALTER TABLE lml_cidade OWNER TO postgres#
CREATE TABLE lml_localidade (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geocodigo character varying(80)
)#
ALTER TABLE lml_localidade OWNER TO postgres#
CREATE TABLE lml_vila (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geocodigo character varying(80)
)#
ALTER TABLE lml_vila OWNER TO postgres#
CREATE TABLE pto_est_med_fenomenos (
    id uuid NOT NULL,
    nome character varying(80),
    orgaoenteresp character varying(80),
    id_est_med_fenomenos uuid
)#
ALTER TABLE pto_est_med_fenomenos OWNER TO postgres#
CREATE TABLE rel_arquipelago (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    jurisdicao smallint NOT NULL
)#
ALTER TABLE rel_arquipelago OWNER TO postgres#
CREATE TABLE rod_estacao_rodoviaria (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipoestrut smallint NOT NULL,
    tipoexposicao smallint NOT NULL
)#
ALTER TABLE rod_estacao_rodoviaria OWNER TO postgres#
CREATE TABLE snb_complexo_abast_agua (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    tiposaneamentobasico smallint NOT NULL,
    classeativecon smallint,
    administracao smallint NOT NULL,
    operacional smallint NOT NULL
)#
ALTER TABLE snb_complexo_abast_agua OWNER TO postgres#
CREATE TABLE snb_complexo_saneamento (
    id uuid NOT NULL,
    nome character varying(80) NOT NULL,
    tiposaneamentobasico smallint NOT NULL,
    classeativecon smallint,
    administracao smallint NOT NULL,
    operacional smallint NOT NULL
)#
ALTER TABLE snb_complexo_saneamento OWNER TO postgres#
CREATE TABLE tra_entroncamento (
    id uuid NOT NULL,
    nome character varying(80),
    tipoentroncamento smallint NOT NULL
)#
ALTER TABLE tra_entroncamento OWNER TO postgres#
CREATE TABLE tra_estrut_apoio (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipoestrut smallint NOT NULL,
    tipoexposicao smallint NOT NULL
)#
ALTER TABLE tra_estrut_apoio OWNER TO postgres#
CREATE TABLE tra_estrut_transporte (
    id uuid NOT NULL,
    nome character varying(80),
    modaluso smallint[] NOT NULL,
    administracao smallint,
    jurisdicao smallint,
    concessionaria character varying(100),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL
)#
ALTER TABLE tra_estrut_transporte OWNER TO postgres#
CREATE TABLE ver_area_verde (
    id uuid NOT NULL,
    nome character varying(80),
    paisagismo smallint NOT NULL,
    administracao smallint NOT NULL,
    id_area_verde_urbana uuid
)#
ALTER TABLE ver_area_verde OWNER TO postgres#
CREATE TABLE ver_area_verde_urbana (
    id uuid NOT NULL,
    nome character varying(80)
)#
ALTER TABLE ver_area_verde_urbana OWNER TO postgres#
SET search_path = edgv, pg_catalog#
CREATE TABLE aer_pista_ponto_pouso_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipopista smallint NOT NULL,
    revestimento smallint NOT NULL,
    usopista smallint NOT NULL,
    homologacao smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    largura real,
    extensao real,
    altitude real,
    id_complexo_aeroportuario uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE aer_pista_ponto_pouso_a OWNER TO postgres#
CREATE TABLE aer_pista_ponto_pouso_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipopista smallint NOT NULL,
    revestimento smallint NOT NULL,
    usopista smallint NOT NULL,
    homologacao smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    largura real,
    extensao real,
    altitude real,
    id_complexo_aeroportuario uuid,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE aer_pista_ponto_pouso_l OWNER TO postgres#
CREATE TABLE aer_pista_ponto_pouso_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipopista smallint NOT NULL,
    revestimento smallint NOT NULL,
    usopista smallint NOT NULL,
    homologacao smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    largura real,
    extensao real,
    altitude real,
    id_complexo_aeroportuario uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE aer_pista_ponto_pouso_p OWNER TO postgres#
CREATE TABLE cbge_area_agropec_ext_veg_pesca_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoarea smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    destinadoa smallint NOT NULL
)#
ALTER TABLE cbge_area_agropec_ext_veg_pesca_a OWNER TO postgres#
CREATE TABLE cbge_area_construida_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    id_localidade uuid,
    id_capital uuid,
    id_cidade uuid,
    id_vila uuid,
    id_aglomerado_rural uuid,
    id_aglomerado_rural_isolado uuid,
    id_aglomerado_rural_de_extensao_urbana uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_area_construida_a OWNER TO postgres#
CREATE TABLE cbge_area_de_propriedade_particular_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoarea smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_area_de_propriedade_particular_a OWNER TO postgres#
CREATE TABLE cbge_area_duto_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoarea smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    areavalvulas smallint,
    bombeamento smallint
)#
ALTER TABLE cbge_area_duto_a OWNER TO postgres#
CREATE TABLE cbge_area_habitacional_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoarea smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_complexo_habitacional uuid,     
    id_condominio uuid,
    id_conjunto_habitacional uuid,
    id_assentamento_precario uuid
)#
ALTER TABLE cbge_area_habitacional_a OWNER TO postgres#
CREATE TABLE cbge_area_uso_especifico_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoarea smallint NOT NULL,
    id_complexo_gerador_energia_eletrica uuid,
    id_subest_transm_distrib_energia_eletrica uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_area_uso_especifico_a OWNER TO postgres#
CREATE TABLE cbge_canteiro_central_a (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    situacaoespacial smallint,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_canteiro_central_a OWNER TO postgres#
CREATE TABLE cbge_canteiro_central_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    situacaoespacial smallint,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE cbge_canteiro_central_l OWNER TO postgres#
CREATE TABLE cbge_cemiterio_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipocemiterio smallint NOT NULL,
    denominacaoassociada smallint,
    destinacaocemiterio smallint NOT NULL,
    organizacao character varying(80),
    geom public.geometry(MultiPolygon,[epsg]) NOT NULL
)#
ALTER TABLE cbge_cemiterio_a OWNER TO postgres#
CREATE TABLE cbge_cemiterio_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipocemiterio smallint NOT NULL,
    denominacaoassociada smallint,
    destinacaocemiterio smallint NOT NULL,
    organizacao character varying(80),
    geom public.geometry(MultiPoint,[epsg]) NOT NULL
)#
ALTER TABLE cbge_cemiterio_p OWNER TO postgres#
CREATE TABLE cbge_delimitacao_fisica_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipodelimfis smallint NOT NULL,
    matconstr smallint[],
    eletrificada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE cbge_delimitacao_fisica_l OWNER TO postgres#
CREATE TABLE cbge_deposito_geral_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipodepgeral smallint[] NOT NULL,
    matconstr smallint[],
    tipoexposicao smallint NOT NULL,
    tipoprodutoresiduo smallint[],
    tipoconteudo smallint[],
    unidadevolume smallint,
    valorvolume real,
    tratamento smallint NOT NULL,
    estadofisico smallint,
    finalidadedep smallint NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_deposito_geral_a OWNER TO postgres#
CREATE TABLE cbge_deposito_geral_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipodepgeral smallint[] NOT NULL,
    matconstr smallint[],
    tipoexposicao smallint NOT NULL,
    tipoprodutoresiduo smallint[],
    tipoconteudo smallint[],
    unidadevolume smallint,
    valorvolume real,
    tratamento smallint NOT NULL,
    estadofisico smallint,
    finalidadedep smallint NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE cbge_deposito_geral_p OWNER TO postgres#
CREATE TABLE cbge_entroncamento_area_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoentroncamento smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_entroncamento_area_a OWNER TO postgres#
CREATE TABLE cbge_espelho_dagua_a (
    id serial NOT NULL,
    nome character varying(80),
    codident character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_espelho_dagua_a OWNER TO postgres#
CREATE TABLE cbge_estacionamento_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[],
    administracao smallint[],
    operacional smallint NOT NULL,
    situacaofisica smallint,
    finalidadepatio smallint[] NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    publico smallint NOT NULL
)#
ALTER TABLE cbge_estacionamento_a OWNER TO postgres#
CREATE TABLE cbge_largo_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid
)#
ALTER TABLE cbge_largo_a OWNER TO postgres#
CREATE TABLE cbge_passeio_a (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    largura double precision,
    calcada smallint NOT NULL,
    pavimentacao smallint[] NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_passeio_a OWNER TO postgres#
CREATE TABLE cbge_passeio_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    largura double precision,
    calcada smallint NOT NULL,
    pavimentacao smallint[] NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE cbge_passeio_l OWNER TO postgres#
CREATE TABLE cbge_poste_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    codident character varying(80),
    matconstr smallint,
    tipoposte smallint[] NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE cbge_poste_p OWNER TO postgres#
CREATE TABLE cbge_praca_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    turistica smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid
)#
ALTER TABLE cbge_praca_a OWNER TO postgres#
CREATE TABLE cbge_quadra_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE cbge_quadra_a OWNER TO postgres#
CREATE TABLE cbge_retorno_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE cbge_retorno_l OWNER TO postgres#
CREATE TABLE cbge_retorno_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE cbge_retorno_p OWNER TO postgres#
CREATE TABLE cbge_trecho_arruamento_a (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tipovia smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    administracao smallint NOT NULL,
    concessionaria character varying(100),
    revestimento smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    canteirodivisorio smallint NOT NULL,
    nrpistas integer NOT NULL,
    nrfaixas integer,
    trafego smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    meiofio smallint NOT NULL,
    sargeta smallint NOT NULL
)#
ALTER TABLE cbge_trecho_arruamento_a OWNER TO postgres#
CREATE TABLE cbge_trecho_arruamento_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tipovia smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    administracao smallint NOT NULL,
    concessionaria character varying(100),
    revestimento smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    canteirodivisorio smallint NOT NULL,
    nrpistas integer NOT NULL,
    nrfaixas integer,
    trafego smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    meiofio smallint NOT NULL,
    sargeta smallint NOT NULL
)#
ALTER TABLE cbge_trecho_arruamento_l OWNER TO postgres#
CREATE TABLE dut_galeria_bueiro_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipotrechoduto smallint NOT NULL,
    mattransp smallint[],
    setor smallint NOT NULL,
    posicaorelativa smallint,
    matconstr smallint[],
    nrdutos integer,
    situacaoespacial smallint,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    finalidade smallint,
    pesosuportmaximo real,
    largura real
)#
ALTER TABLE dut_galeria_bueiro_l OWNER TO postgres#
CREATE TABLE dut_trecho_duto_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipotrechoduto smallint NOT NULL,
    mattransp smallint[],
    setor smallint NOT NULL,
    posicaorelativa smallint,
    matconstr smallint[],
    nrdutos integer,
    situacaoespacial smallint,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE dut_trecho_duto_l OWNER TO postgres#
CREATE TABLE eco_equip_agropec_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipoequipagropec smallint NOT NULL,
    matconstr smallint[],
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE eco_equip_agropec_a OWNER TO postgres#
CREATE TABLE eco_equip_agropec_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipoequipagropec smallint NOT NULL,
    matconstr smallint[],
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE eco_equip_agropec_l OWNER TO postgres#
CREATE TABLE eco_equip_agropec_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipoequipagropec smallint NOT NULL,
    matconstr smallint[],
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE eco_equip_agropec_p OWNER TO postgres#
CREATE TABLE eco_ext_mineral_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    secaoativecon smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipoextmin smallint NOT NULL,
    tipoproduto smallint[] NOT NULL,
    tipopocomina smallint NOT NULL,
    procextracao smallint,
    formaextracao smallint NOT NULL,
    atividade smallint NOT NULL
)#
ALTER TABLE eco_ext_mineral_a OWNER TO postgres#
CREATE TABLE eco_ext_mineral_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    secaoativecon smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipoextmin smallint NOT NULL,
    tipoproduto smallint[] NOT NULL,
    tipopocomina smallint NOT NULL,
    procextracao smallint,
    formaextracao smallint NOT NULL,
    atividade smallint NOT NULL
)#
ALTER TABLE eco_ext_mineral_p OWNER TO postgres#
CREATE TABLE eco_plataforma_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoplataforma smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE eco_plataforma_a OWNER TO postgres#
CREATE TABLE eco_plataforma_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoplataforma smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE eco_plataforma_p OWNER TO postgres#
CREATE TABLE edf_banheiro_publico_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_banheiro_publico_a OWNER TO postgres#
CREATE TABLE edf_banheiro_publico_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE edf_banheiro_publico_p OWNER TO postgres#
CREATE TABLE edf_edif_abast_agua_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifabast smallint NOT NULL,
    id_complexo_abast_agua uuid
)#
ALTER TABLE edf_edif_abast_agua_a OWNER TO postgres#
CREATE TABLE edf_edif_abast_agua_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifabast smallint NOT NULL,
    id_complexo_abast_agua uuid
)#
ALTER TABLE edf_edif_abast_agua_p OWNER TO postgres#
CREATE TABLE edf_edif_agropec_ext_veg_pesca_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifagropec smallint[] NOT NULL
)#
ALTER TABLE edf_edif_agropec_ext_veg_pesca_a OWNER TO postgres#
CREATE TABLE edf_edif_agropec_ext_veg_pesca_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifagropec smallint[] NOT NULL
)#
ALTER TABLE edf_edif_agropec_ext_veg_pesca_p OWNER TO postgres#
CREATE TABLE edf_edif_comerc_serv_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifcomercserv smallint[] NOT NULL,
    finalidade smallint[] NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid
)#
ALTER TABLE edf_edif_comerc_serv_a OWNER TO postgres#
CREATE TABLE edf_edif_comerc_serv_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifcomercserv smallint[] NOT NULL,
    finalidade smallint[] NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid
)#
ALTER TABLE edf_edif_comerc_serv_p OWNER TO postgres#
CREATE TABLE edf_edif_comunic_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    tipoedifcomunic smallint[] NOT NULL,
    modalidade smallint[] NOT NULL,
    id_complexo_comunicacao uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_edif_comunic_a OWNER TO postgres#
CREATE TABLE edf_edif_comunic_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    tipoedifcomunic smallint[] NOT NULL,
    modalidade smallint[] NOT NULL,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    id_complexo_comunicacao uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE edf_edif_comunic_p OWNER TO postgres#
CREATE TABLE edf_edif_constr_aeroportuaria_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifaero smallint[] NOT NULL,
    jurisdicao smallint,
    concessionaria character varying(80),
    id_complexo_aeroportuario uuid
)#
ALTER TABLE edf_edif_constr_aeroportuaria_a OWNER TO postgres#
CREATE TABLE edf_edif_constr_aeroportuaria_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifaero smallint[] NOT NULL,
    jurisdicao smallint,
    concessionaria character varying(100),
    id_complexo_aeroportuario uuid
)#
ALTER TABLE edf_edif_constr_aeroportuaria_p OWNER TO postgres#
CREATE TABLE edf_edif_constr_est_med_fen_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    id_est_med_fenomenos uuid
)#
ALTER TABLE edf_edif_constr_est_med_fen_a OWNER TO postgres#
CREATE TABLE edf_edif_constr_est_med_fen_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    id_est_med_fenomenos uuid
)#
ALTER TABLE edf_edif_constr_est_med_fen_p OWNER TO postgres#
CREATE TABLE edf_edif_constr_lazer_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoediflazer smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid
)#
ALTER TABLE edf_edif_constr_lazer_a OWNER TO postgres#
CREATE TABLE edf_edif_constr_lazer_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoediflazer smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid
)#
ALTER TABLE edf_edif_constr_lazer_p OWNER TO postgres#
CREATE TABLE edf_edif_constr_portuaria_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifport smallint[] NOT NULL,
    jurisdicao smallint,
    concessionaria character varying(80),
    id_complexo_portuario uuid
)#
ALTER TABLE edf_edif_constr_portuaria_a OWNER TO postgres#
CREATE TABLE edf_edif_constr_portuaria_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifport smallint[] NOT NULL,
    jurisdicao smallint NOT NULL,
    concessionaria character varying(80),
    id_complexo_portuario uuid
)#
ALTER TABLE edf_edif_constr_portuaria_p OWNER TO postgres#
CREATE TABLE edf_edif_constr_turistica_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifturist smallint NOT NULL,
    ovgd smallint NOT NULL,
    tombada smallint,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid
)#
ALTER TABLE edf_edif_constr_turistica_a OWNER TO postgres#
CREATE TABLE edf_edif_constr_turistica_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifturist smallint NOT NULL,
    ovgd smallint NOT NULL,
    tombada smallint,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid
)#
ALTER TABLE edf_edif_constr_turistica_p OWNER TO postgres#
CREATE TABLE edf_edif_desenv_social_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    sigla character varying(80),
    codequipdesenvsocial character varying(80),
    tipoequipdesenvsocial smallint,
    localizacaoequipdesenvsocial smallint
)#
ALTER TABLE edf_edif_desenv_social_a OWNER TO postgres#
CREATE TABLE edf_edif_desenv_social_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    sigla character varying(80),
    codequipdesenvsocial character varying(80),
    tipoequipdesenvsocial smallint,
    localizacaoequipdesenvsocial smallint
)#
ALTER TABLE edf_edif_desenv_social_p OWNER TO postgres#
CREATE TABLE edf_edif_energia_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifenergia smallint[] NOT NULL,
    id_complexo_gerador_energia_eletrica uuid,
    id_subest_transm_distrib_energia_eletrica uuid
)#
ALTER TABLE edf_edif_energia_a OWNER TO postgres#
CREATE TABLE edf_edif_energia_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifenergia smallint[] NOT NULL,
    id_complexo_gerador_energia_eletrica uuid,
    id_subest_transm_distrib_energia_eletrica uuid
)#
ALTER TABLE edf_edif_energia_p OWNER TO postgres#
CREATE TABLE edf_edif_ensino_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_edif_ensino_a OWNER TO postgres#
CREATE TABLE edf_edif_ensino_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE edf_edif_ensino_p OWNER TO postgres#
CREATE TABLE edf_edif_ext_mineral_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_edif_ext_mineral_a OWNER TO postgres#
CREATE TABLE edf_edif_ext_mineral_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE edf_edif_ext_mineral_p OWNER TO postgres#
CREATE TABLE edf_edif_habitacional_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_edif_habitacional_a OWNER TO postgres#
CREATE TABLE edf_edif_habitacional_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE edf_edif_habitacional_p OWNER TO postgres#
CREATE TABLE edf_edif_industrial_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    chamine smallint
)#
ALTER TABLE edf_edif_industrial_a OWNER TO postgres#
CREATE TABLE edf_edif_industrial_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    chamine smallint
)#
ALTER TABLE edf_edif_industrial_p OWNER TO postgres#
CREATE TABLE edf_edif_metro_ferroviaria_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifmetroferrov smallint[] NOT NULL,
    jurisdicao smallint,
    concessionaria character varying(80),
    id_estrut_apoio uuid,
    id_estacao_ferroviaria uuid
)#
ALTER TABLE edf_edif_metro_ferroviaria_a OWNER TO postgres#
CREATE TABLE edf_edif_metro_ferroviaria_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifmetroferrov smallint[] NOT NULL,
    jurisdicao smallint,
    concessionaria character varying(80),
    id_estrut_apoio uuid
)#
ALTER TABLE edf_edif_metro_ferroviaria_p OWNER TO postgres#
CREATE TABLE edf_edif_policia_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[]
)#
ALTER TABLE edf_edif_policia_a OWNER TO postgres#
CREATE TABLE edf_edif_policia_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[] NOT NULL
)#
ALTER TABLE edf_edif_policia_p OWNER TO postgres#
CREATE TABLE edf_edif_pub_civil_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[]
)#
ALTER TABLE edf_edif_pub_civil_a OWNER TO postgres#
CREATE TABLE edf_edif_pub_civil_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[] NOT NULL
)#
ALTER TABLE edf_edif_pub_civil_p OWNER TO postgres#
CREATE TABLE edf_edif_pub_militar_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoinstalmilitar smallint NOT NULL
)#
ALTER TABLE edf_edif_pub_militar_a OWNER TO postgres#
CREATE TABLE edf_edif_pub_militar_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoinstalmilitar smallint NOT NULL
)#
ALTER TABLE edf_edif_pub_militar_p OWNER TO postgres#
CREATE TABLE edf_edif_religiosa_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifrelig smallint NOT NULL,
    ensino smallint NOT NULL,
    religiao character varying(80),
    crista smallint NOT NULL
)#
ALTER TABLE edf_edif_religiosa_a OWNER TO postgres#
CREATE TABLE edf_edif_religiosa_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifrelig smallint NOT NULL,
    ensino smallint NOT NULL,
    religiao character varying(80),
    crista smallint NOT NULL
)#
ALTER TABLE edf_edif_religiosa_p OWNER TO postgres#
CREATE TABLE edf_edif_residencial_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_edif_residencial_a OWNER TO postgres#
CREATE TABLE edf_edif_residencial_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE edf_edif_residencial_p OWNER TO postgres#
CREATE TABLE edf_edif_rodoviaria_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifrod smallint[] NOT NULL,
    jurisdicao smallint NOT NULL,
    concessionaria character varying(80),
    id_estrut_apoio uuid
)#
ALTER TABLE edf_edif_rodoviaria_a OWNER TO postgres#
CREATE TABLE edf_edif_rodoviaria_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifrod smallint[] NOT NULL,
    jurisdicao smallint,
    concessionaria character varying(80),
    id_estrut_apoio uuid
)#
ALTER TABLE edf_edif_rodoviaria_p OWNER TO postgres#
CREATE TABLE edf_edif_saneamento_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoedifsaneam smallint NOT NULL,
    id_complexo_saneamento uuid
)#
ALTER TABLE edf_edif_saneamento_a OWNER TO postgres#
CREATE TABLE edf_edif_saneamento_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifsaneam smallint NOT NULL,
    id_complexo_saneamento uuid
)#
ALTER TABLE edf_edif_saneamento_p OWNER TO postgres#
CREATE TABLE edf_edif_saude_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    nivelatencao smallint NOT NULL
)#
ALTER TABLE edf_edif_saude_a OWNER TO postgres#
CREATE TABLE edf_edif_saude_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    nivelatencao smallint NOT NULL
)#
ALTER TABLE edf_edif_saude_p OWNER TO postgres#
CREATE TABLE edf_edif_servico_social_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_edif_servico_social_a OWNER TO postgres#
CREATE TABLE edf_edif_servico_social_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE edf_edif_servico_social_p OWNER TO postgres#
CREATE TABLE edf_edificacao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_edificacao_a OWNER TO postgres#
CREATE TABLE edf_edificacao_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE edf_edificacao_p OWNER TO postgres#
CREATE TABLE edf_hab_indigena_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    coletiva smallint NOT NULL,
    isolada smallint NOT NULL,
    id_aldeia_indigena uuid
)#
ALTER TABLE edf_hab_indigena_a OWNER TO postgres#
CREATE TABLE edf_hab_indigena_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    coletiva smallint NOT NULL,
    isolada smallint NOT NULL,
    id_aldeia_indigena uuid
)#
ALTER TABLE edf_hab_indigena_p OWNER TO postgres#
CREATE TABLE edf_posto_combustivel_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    tipoedifcomercserv smallint[] NOT NULL,
    finalidade smallint[] NOT NULL,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE edf_posto_combustivel_a OWNER TO postgres#
CREATE TABLE edf_posto_combustivel_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoedifcomercserv smallint[] NOT NULL,
    finalidade smallint[] NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid
)#
ALTER TABLE edf_posto_combustivel_p OWNER TO postgres#
CREATE TABLE edf_posto_fiscal_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[],
    tipopostofisc smallint NOT NULL,
    concessionaria character varying(80)
)#
ALTER TABLE edf_posto_fiscal_a OWNER TO postgres#
CREATE TABLE edf_posto_fiscal_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[] NOT NULL,
    tipopostofisc smallint NOT NULL,
    concessionaria character varying(80)
)#
ALTER TABLE edf_posto_fiscal_p OWNER TO postgres#
CREATE TABLE edf_posto_guarda_municipal_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[]
)#
ALTER TABLE edf_posto_guarda_municipal_a OWNER TO postgres#
CREATE TABLE edf_posto_guarda_municipal_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[] NOT NULL
)#
ALTER TABLE edf_posto_guarda_municipal_p OWNER TO postgres#
CREATE TABLE edf_posto_policia_militar_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoinstalmilitar smallint NOT NULL
)#
ALTER TABLE edf_posto_policia_militar_a OWNER TO postgres#
CREATE TABLE edf_posto_policia_militar_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoinstalmilitar smallint NOT NULL
)#
ALTER TABLE edf_posto_policia_militar_p OWNER TO postgres#
CREATE TABLE edf_posto_policia_rod_federal_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[]
)#
ALTER TABLE edf_posto_policia_rod_federal_a OWNER TO postgres#
CREATE TABLE edf_posto_policia_rod_federal_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipousoedif smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    tipoedifpubcivil smallint[] NOT NULL
)#
ALTER TABLE edf_posto_policia_rod_federal_p OWNER TO postgres#
CREATE TABLE edf_representacao_diplomatica_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tiporepdiplomatica smallint NOT NULL
)#
ALTER TABLE edf_representacao_diplomatica_a OWNER TO postgres#
CREATE TABLE edf_representacao_diplomatica_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    matconstr smallint,
    alturaaproximada real,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    administracao smallint,
    classeativecon smallint[],
    divisaoativecon smallint[],
    grupoativecon smallint[],
    proprioadm smallint,
    cep character varying(80),
    pais character varying(80),
    unidadefederacao character varying(2),
    municipio character varying(80),
    bairro character varying(80),
    logradouro character varying(200),
    bloco character varying(80),
    numerosequencial integer,
    numerometrico integer,
    numeropavimentos integer,
    id_assentamento_precario uuid,
    id_complexo_habitacional uuid,     
    id_condominio uuid,     
    id_conjunto_habitacional uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tiporepdiplomatica smallint NOT NULL
)#
ALTER TABLE edf_representacao_diplomatica_p OWNER TO postgres#
CREATE TABLE emu_acesso_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE emu_acesso_a OWNER TO postgres#
CREATE TABLE emu_acesso_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE emu_acesso_l OWNER TO postgres#
CREATE TABLE emu_acesso_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE emu_acesso_p OWNER TO postgres#
CREATE TABLE emu_ciclovia_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    revestimento smallint,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE emu_ciclovia_l OWNER TO postgres#
CREATE TABLE emu_elevador_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoelevador smallint
)#
ALTER TABLE emu_elevador_a OWNER TO postgres#
CREATE TABLE emu_elevador_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    tipoelevador smallint
)#
ALTER TABLE emu_elevador_l OWNER TO postgres#
CREATE TABLE emu_elevador_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    tipoelevador smallint
)#
ALTER TABLE emu_elevador_p OWNER TO postgres#
CREATE TABLE emu_escadaria_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE emu_escadaria_a OWNER TO postgres#
CREATE TABLE emu_escadaria_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE emu_escadaria_l OWNER TO postgres#
CREATE TABLE emu_escadaria_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE emu_escadaria_p OWNER TO postgres#
CREATE TABLE emu_poste_sinalizacao_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    codident character varying(80),
    matconstr smallint,
    tipoposte smallint[] NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE emu_poste_sinalizacao_p OWNER TO postgres#
CREATE TABLE emu_rampa_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE emu_rampa_a OWNER TO postgres#
CREATE TABLE emu_rampa_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE emu_rampa_l OWNER TO postgres#
CREATE TABLE emu_rampa_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE emu_rampa_p OWNER TO postgres#
CREATE TABLE enc_aerogerador_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    alturatorreaer real,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE enc_aerogerador_p OWNER TO postgres#
CREATE TABLE enc_antena_comunic_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    posicaoreledific smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    id_complexo_comunicacao uuid
)#
ALTER TABLE enc_antena_comunic_p OWNER TO postgres#
CREATE TABLE enc_casa_de_forca_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE enc_casa_de_forca_p OWNER TO postgres#
CREATE TABLE enc_central_geradora_eolica_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE enc_central_geradora_eolica_a OWNER TO postgres#
CREATE TABLE enc_central_geradora_eolica_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE enc_central_geradora_eolica_l OWNER TO postgres#
CREATE TABLE enc_central_geradora_eolica_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE enc_central_geradora_eolica_p OWNER TO postgres#
CREATE TABLE enc_est_gerad_energia_eletrica_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE enc_est_gerad_energia_eletrica_a OWNER TO postgres#
CREATE TABLE enc_est_gerad_energia_eletrica_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE enc_est_gerad_energia_eletrica_l OWNER TO postgres#
CREATE TABLE enc_est_gerad_energia_eletrica_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE enc_est_gerad_energia_eletrica_p OWNER TO postgres#
CREATE TABLE enc_grupo_transformadores_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    id_subest_transm_distrib_energia_eletrica uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE enc_grupo_transformadores_a OWNER TO postgres#
CREATE TABLE enc_grupo_transformadores_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    id_subest_transm_distrib_energia_eletrica uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE enc_grupo_transformadores_p OWNER TO postgres#
CREATE TABLE enc_hidreletrica_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoahe smallint NOT NULL
)#
ALTER TABLE enc_hidreletrica_a OWNER TO postgres#
CREATE TABLE enc_hidreletrica_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiLineString,[epsg]),
    tipoahe smallint NOT NULL
)#
ALTER TABLE enc_hidreletrica_l OWNER TO postgres#
CREATE TABLE enc_hidreletrica_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipoahe smallint NOT NULL
)#
ALTER TABLE enc_hidreletrica_p OWNER TO postgres#
CREATE TABLE enc_termeletrica_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    tipocombustivel smallint NOT NULL
)#
ALTER TABLE enc_termeletrica_a OWNER TO postgres#
CREATE TABLE enc_termeletrica_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    ceg text,
    tipoestgerad smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    potenciaout real,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPoint,[epsg]),
    tipocombustivel smallint NOT NULL
)#
ALTER TABLE enc_termeletrica_p OWNER TO postgres#
CREATE TABLE enc_torre_comunic_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    posicaoreledific smallint,
    ovgd smallint,
    alturaestimada real,
    modalidade smallint[] NOT NULL,
    id_complexo_comunicacao uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE enc_torre_comunic_p OWNER TO postgres#
CREATE TABLE enc_torre_energia_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    ovgd smallint,
    alturaestimada real,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE enc_torre_energia_p OWNER TO postgres#
CREATE TABLE enc_trecho_comunic_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipotrechocomunic smallint NOT NULL,
    posicaorelativa smallint NOT NULL,
    matcondutor smallint,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    emduto smallint,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE enc_trecho_comunic_l OWNER TO postgres#
CREATE TABLE enc_trecho_energia_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    especie smallint,
    posicaorelativa smallint,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    largurafaixaservidao double precision,
    sin smallint,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE enc_trecho_energia_l OWNER TO postgres#
CREATE TABLE enc_zona_linhas_energia_comunicacao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE enc_zona_linhas_energia_comunicacao_a OWNER TO postgres#
CREATE TABLE fer_cremalheira_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE fer_cremalheira_l OWNER TO postgres#
CREATE TABLE fer_cremalheira_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE fer_cremalheira_p OWNER TO postgres#
CREATE TABLE fer_girador_ferroviario_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    administracao smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    id_estacao_ferroviaria uuid,
    id_estacao_metroviaria uuid
)#
ALTER TABLE fer_girador_ferroviario_p OWNER TO postgres#
CREATE TABLE fer_trecho_ferroviario_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codtrechoferrov character varying(80),
    posicaorelativa smallint NOT NULL,
    tipotrechoferrov smallint NOT NULL,
    bitola smallint NOT NULL,
    eletrificada smallint NOT NULL,
    nrlinhas smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    administracao smallint NOT NULL,
    concessionaria character varying(80),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    cargasuportmaxima double precision,
    emarruamento smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE fer_trecho_ferroviario_l OWNER TO postgres#
CREATE TABLE hdv_atracadouro_terminal_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoatracad smallint NOT NULL,
    administracao smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    aptidaooperacional smallint[],
    id_complexo_portuario uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hdv_atracadouro_terminal_a OWNER TO postgres#
CREATE TABLE hdv_atracadouro_terminal_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoatracad smallint NOT NULL,
    administracao smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    aptidaooperacional smallint[],
    id_complexo_portuario uuid,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hdv_atracadouro_terminal_l OWNER TO postgres#
CREATE TABLE hdv_atracadouro_terminal_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoatracad smallint NOT NULL,
    administracao smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    aptidaooperacional smallint[],
    id_complexo_portuario uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hdv_atracadouro_terminal_p OWNER TO postgres#
CREATE TABLE hdv_eclusa_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    desnivel double precision,
    largura double precision,
    extensao double precision,
    calado double precision,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hdv_eclusa_a OWNER TO postgres#
CREATE TABLE hdv_eclusa_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    desnivel double precision,
    largura double precision,
    extensao double precision,
    calado double precision,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hdv_eclusa_l OWNER TO postgres#
CREATE TABLE hdv_eclusa_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    desnivel double precision,
    largura double precision,
    extensao double precision,
    calado double precision,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hdv_eclusa_p OWNER TO postgres#
CREATE TABLE hdv_fundeadouro_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipofundeadouro smallint NOT NULL,
    administracao smallint NOT NULL,
    id_complexo_portuario uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hdv_fundeadouro_a OWNER TO postgres#
CREATE TABLE hdv_fundeadouro_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipofundeadouro smallint NOT NULL,
    administracao smallint NOT NULL,
    id_complexo_portuario uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hdv_fundeadouro_p OWNER TO postgres#
CREATE TABLE hdv_obstaculo_navegacao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoobst smallint NOT NULL,
    situacaoemagua smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hdv_obstaculo_navegacao_a OWNER TO postgres#
CREATE TABLE hdv_obstaculo_navegacao_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoobst smallint NOT NULL,
    situacaoemagua smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hdv_obstaculo_navegacao_l OWNER TO postgres#
CREATE TABLE hdv_obstaculo_navegacao_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoobst smallint NOT NULL,
    situacaoemagua smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hdv_obstaculo_navegacao_p OWNER TO postgres#
CREATE TABLE hdv_sinalizacao_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tiposinal smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hdv_sinalizacao_p OWNER TO postgres#
CREATE TABLE hdv_trecho_hidroviario_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    regime smallint,
    extensaotrecho real,
    caladomaxseca real,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hdv_trecho_hidroviario_l OWNER TO postgres#
CREATE TABLE hid_area_umida_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoareaumida smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_area_umida_a OWNER TO postgres#
CREATE TABLE hid_banco_areia_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipobanco smallint NOT NULL,
    situacaoemagua smallint,
    materialpredominante smallint,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_banco_areia_a OWNER TO postgres#
CREATE TABLE hid_banco_areia_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipobanco smallint NOT NULL,
    situacaoemagua smallint,
    materialpredominante smallint,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_banco_areia_l OWNER TO postgres#
CREATE TABLE hid_barragem_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    usoprincipal smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_barragem_a OWNER TO postgres#
CREATE TABLE hid_barragem_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    usoprincipal smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_barragem_l OWNER TO postgres#
CREATE TABLE hid_barragem_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    usoprincipal smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    id_complexo_gerador_energia_eletrica uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_barragem_p OWNER TO postgres#
CREATE TABLE hid_canal_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    usoprincipal smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    finalidade smallint
)#
ALTER TABLE hid_canal_a OWNER TO postgres#
CREATE TABLE hid_canal_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    usoprincipal smallint NOT NULL,
    finalidade smallint
)#
ALTER TABLE hid_canal_l OWNER TO postgres#
CREATE TABLE hid_canal_vala_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    usoprincipal smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    finalidade smallint
)#
ALTER TABLE hid_canal_vala_a OWNER TO postgres#
CREATE TABLE hid_canal_vala_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    usoprincipal smallint NOT NULL,
    finalidade smallint
)#
ALTER TABLE hid_canal_vala_l OWNER TO postgres#
CREATE TABLE hid_comporta_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_comporta_l OWNER TO postgres#
CREATE TABLE hid_comporta_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_comporta_p OWNER TO postgres#
CREATE TABLE hid_corredeira_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_corredeira_a OWNER TO postgres#
CREATE TABLE hid_corredeira_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_corredeira_l OWNER TO postgres#
CREATE TABLE hid_corredeira_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_corredeira_p OWNER TO postgres#
CREATE TABLE hid_dique_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_dique_a OWNER TO postgres#
CREATE TABLE hid_dique_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_dique_l OWNER TO postgres#
CREATE TABLE hid_dique_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_dique_p OWNER TO postgres#
CREATE TABLE hid_fonte_dagua_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipofontedagua smallint NOT NULL,
    qualidagua smallint,
    regime smallint,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_fonte_dagua_p OWNER TO postgres#
CREATE TABLE hid_foz_maritima_a (
    id serial NOT NULL,
    nome character(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_foz_maritima_a OWNER TO postgres#
CREATE TABLE hid_foz_maritima_l (
    id serial NOT NULL,
    nome character(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_foz_maritima_l OWNER TO postgres#
CREATE TABLE hid_foz_maritima_p (
    id serial NOT NULL,
    nome character(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_foz_maritima_p OWNER TO postgres#
CREATE TABLE hid_ilha_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    tipoilha smallint[] NOT NULL,
    id_arquipelago uuid
)#
ALTER TABLE hid_ilha_a OWNER TO postgres#
CREATE TABLE hid_ilha_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    tipoilha smallint[] NOT NULL,
    id_arquipelago uuid
)#
ALTER TABLE hid_ilha_l OWNER TO postgres#
CREATE TABLE hid_ilha_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    tipoilha smallint[] NOT NULL,
    id_arquipelago uuid
)#
ALTER TABLE hid_ilha_p OWNER TO postgres#
CREATE TABLE hid_massa_dagua_a (
    id serial NOT NULL,
    nome character(80),
    geometriaaproximada smallint NOT NULL,
    tipomassadagua smallint NOT NULL,
    regime smallint NOT NULL,
    salgada smallint NOT NULL,
    dominialidade smallint,
    artificial smallint NOT NULL,
    possuitrechodrenagem smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_massa_dagua_a OWNER TO postgres#
CREATE TABLE hid_quebramar_molhe_a (
    id serial NOT NULL,
    tipoquebramolhe smallint NOT NULL,
    nome character(80),
    geometriaaproximada smallint NOT NULL,
    situacaoemagua smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_quebramar_molhe_a OWNER TO postgres#
CREATE TABLE hid_quebramar_molhe_l (
    id serial NOT NULL,
    tipoquebramolhe smallint NOT NULL,
    nome character(80),
    geometriaaproximada smallint NOT NULL,
    situacaoemagua smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_quebramar_molhe_l OWNER TO postgres#
CREATE TABLE hid_queda_dagua_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoqueda smallint NOT NULL,
    altura real,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_queda_dagua_a OWNER TO postgres#
CREATE TABLE hid_queda_dagua_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoqueda smallint NOT NULL,
    altura real,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_queda_dagua_l OWNER TO postgres#
CREATE TABLE hid_queda_dagua_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoqueda smallint NOT NULL,
    altura real,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_queda_dagua_p OWNER TO postgres#
CREATE TABLE hid_recife_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tiporecife smallint NOT NULL,
    situacaoemagua smallint NOT NULL,
    situacaocosta smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_recife_a OWNER TO postgres#
CREATE TABLE hid_recife_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tiporecife smallint NOT NULL,
    situacaoemagua smallint NOT NULL,
    situacaocosta smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_recife_l OWNER TO postgres#
CREATE TABLE hid_recife_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tiporecife smallint NOT NULL,
    situacaoemagua smallint NOT NULL,
    situacaocosta smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_recife_p OWNER TO postgres#
CREATE TABLE hid_rocha_em_agua_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    formarocha smallint,
    situacaoemagua smallint NOT NULL,
    alturalamina real
)#
ALTER TABLE hid_rocha_em_agua_a OWNER TO postgres#
CREATE TABLE hid_rocha_em_agua_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    formarocha smallint,
    situacaoemagua smallint NOT NULL,
    alturalamina real
)#
ALTER TABLE hid_rocha_em_agua_p OWNER TO postgres#
CREATE TABLE hid_sumidouro_vertedouro_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tiposumvert smallint NOT NULL,
    causa smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE hid_sumidouro_vertedouro_p OWNER TO postgres#
CREATE TABLE hid_terreno_sujeito_inundacao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    periodicidadeinunda character(20),
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE hid_terreno_sujeito_inundacao_a OWNER TO postgres#
CREATE TABLE hid_trecho_drenagem_l (
    id serial NOT NULL,
    nome character(80),
    geometriaaproximada smallint NOT NULL,
    tipotrechodrenagem smallint NOT NULL,
    navegavel smallint NOT NULL,
    larguramedia real,
    regime smallint NOT NULL,
    encoberto smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE hid_trecho_drenagem_l OWNER TO postgres#
CREATE TABLE hid_vala_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    usoprincipal smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    finalidade smallint
)#
ALTER TABLE hid_vala_a OWNER TO postgres#
CREATE TABLE hid_vala_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    matconstr smallint[] NOT NULL,
    usoprincipal smallint NOT NULL,
    finalidade smallint
)#
ALTER TABLE hid_vala_l OWNER TO postgres#
CREATE TABLE laz_arquibancada_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE laz_arquibancada_a OWNER TO postgres#
CREATE TABLE laz_arquibancada_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE laz_arquibancada_l OWNER TO postgres#
CREATE TABLE laz_campo_quadra_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipocampoquadra smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE laz_campo_quadra_a OWNER TO postgres#
CREATE TABLE laz_campo_quadra_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    tipocampoquadra smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE laz_campo_quadra_p OWNER TO postgres#
CREATE TABLE laz_piscina_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    geom public.geometry(MultiPolygon,[epsg]),
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid
)#
ALTER TABLE laz_piscina_a OWNER TO postgres#
CREATE TABLE laz_pista_competicao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipopistacomp smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE laz_pista_competicao_a OWNER TO postgres#
CREATE TABLE laz_pista_competicao_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipopistacomp smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE laz_pista_competicao_l OWNER TO postgres#
CREATE TABLE laz_pista_competicao_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipopistacomp smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE laz_pista_competicao_p OWNER TO postgres#
CREATE TABLE laz_ruina_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE laz_ruina_a OWNER TO postgres#
CREATE TABLE laz_ruina_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    id_complexo_desportivo_lazer uuid,
    id_complexo_desportivo uuid,
    id_complexo_recreativo uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE laz_ruina_p OWNER TO postgres#
CREATE TABLE laz_sitio_arqueologico_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE laz_sitio_arqueologico_a OWNER TO postgres#
CREATE TABLE laz_sitio_arqueologico_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    turistica smallint NOT NULL,
    cultura smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE laz_sitio_arqueologico_p OWNER TO postgres#
CREATE TABLE lml_area_densamente_edificada_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    id_localidade uuid,
    id_capital uuid,
    id_cidade uuid,
    id_vila uuid,
    id_aglomerado_rural uuid,
    id_aglomerado_rural_isolado uuid,
    id_aglomerado_rural_de_extensao_urbana uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE lml_area_densamente_edificada_a OWNER TO postgres#
CREATE TABLE lml_area_especial_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codidentificadorunico character varying(80),
    arealegal real,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE lml_area_especial_a OWNER TO postgres#
CREATE TABLE lml_area_politico_administrativa_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE lml_area_politico_administrativa_a OWNER TO postgres#
CREATE TABLE lml_area_pub_militar_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codidentificadorunico character varying(80),
    arealegal real,
    geom public.geometry(MultiPolygon,[epsg]),
    classificacao character varying(80),
    administracao smallint NOT NULL,
    jurisdicao smallint NOT NULL
)#
ALTER TABLE lml_area_pub_militar_a OWNER TO postgres#
CREATE TABLE lml_area_urbana_isolada_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoassociado smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_capital uuid,
    id_cidade uuid
)#
ALTER TABLE lml_area_urbana_isolada_a OWNER TO postgres#
CREATE TABLE lml_distrito_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    geocodigo character varying(80),
    anodereferencia character varying(80)
)#
ALTER TABLE lml_distrito_a OWNER TO postgres#
CREATE TABLE lml_municipio_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    geocodigo character varying(80),
    anodereferencia integer
)#
ALTER TABLE lml_municipio_a OWNER TO postgres#
CREATE TABLE lml_nome_local_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE lml_nome_local_p OWNER TO postgres#
CREATE TABLE lml_pais_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    sigla character varying(80),
    codiso3166 character varying(80)
)#
ALTER TABLE lml_pais_a OWNER TO postgres#
CREATE TABLE lml_posic_geo_localidade_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tipolocalidade smallint NOT NULL,
    identificador character varying(80),
    latitude character varying(80),
    latitudegms real,
    longitude character varying(80),
    longitudegms real,
    anodereferencia character varying(80),
    id_localidade uuid,
    id_capital uuid,
    id_cidade uuid,
    id_vila uuid,
    id_aglomerado_rural uuid,
    id_aglomerado_rural_isolado uuid,
    id_aglomerado_rural_de_extensao_urbana uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE lml_posic_geo_localidade_p OWNER TO postgres#
CREATE TABLE lml_terra_indigena_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codidentificadorunico character varying(80),
    arealegal real,
    geom public.geometry(MultiPolygon,[epsg]),
    classificacao character varying(80),
    administracao smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    situacaojuridica smallint NOT NULL,
    datasituacaojuridica character varying(80),
    grupoetnico character varying(80),
    perimetrooficial double precision
)#
ALTER TABLE lml_terra_indigena_a OWNER TO postgres#
CREATE TABLE lml_terra_publica_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codidentificadorunico character varying(80),
    arealegal real,
    geom public.geometry(MultiPolygon,[epsg]),
    classificacao character varying(80),
    administracao smallint NOT NULL,
    jurisdicao smallint NOT NULL
)#
ALTER TABLE lml_terra_publica_a OWNER TO postgres#
CREATE TABLE lml_unidade_conservacao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codidentificadorunico character varying(80),
    arealegal real,
    geom public.geometry(MultiPolygon,[epsg]),
    anocriacao character varying(4),
    historicomodificacoes character varying(255),
    sigla character varying(6),
    atolegal character varying(100),
    areaoficial character varying(15),
    administracao smallint NOT NULL,
    classificacao character varying(100),
    jurisdicao smallint NOT NULL,
    tipounidprotegida smallint NOT NULL
)#
ALTER TABLE lml_unidade_conservacao_a OWNER TO postgres#
CREATE TABLE lml_unidade_federacao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    sigla smallint NOT NULL,
    geocodigo character varying(80)
)#
ALTER TABLE lml_unidade_federacao_a OWNER TO postgres#
CREATE TABLE lml_unidade_protecao_integral_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codidentificadorunico character varying(80),
    arealegal real,
    geom public.geometry(MultiPolygon,[epsg]),
    anocriacao character varying(4),
    historicomodificacoes character varying(255),
    sigla character varying(6),
    atolegal character varying(100),
    areaoficial character varying(15),
    administracao smallint NOT NULL,
    classificacao character varying(100),
    jurisdicao smallint NOT NULL,
    tipounidprotegida smallint NOT NULL,
    tipounidprotinteg smallint NOT NULL
)#
ALTER TABLE lml_unidade_protecao_integral_a OWNER TO postgres#
CREATE TABLE lml_unidade_protegida_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codidentificadorunico character varying(80),
    arealegal real,
    geom public.geometry(MultiPolygon,[epsg]),
    anocriacao character varying(4),
    historicomodificacoes character varying(255),
    sigla character varying(6),
    atolegal character varying(100),
    areaoficial character varying(15),
    administracao smallint NOT NULL,
    classificacao character varying(100),
    jurisdicao smallint NOT NULL,
    tipounidprotegida smallint NOT NULL
)#
ALTER TABLE lml_unidade_protegida_a OWNER TO postgres#
CREATE TABLE lml_unidade_uso_sustentavel_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    codidentificadorunico character varying(80),
    arealegal real,
    geom public.geometry(MultiPolygon,[epsg]),
    anocriacao character varying(4),
    historicomodificacoes character varying(255),
    sigla character varying(6),
    atolegal character varying(100),
    areaoficial character varying(15),
    administracao smallint NOT NULL,
    classificacao character varying(100),
    jurisdicao smallint NOT NULL,
    tipounidprotegida smallint NOT NULL,
    tipounidusosust smallint NOT NULL
)#
ALTER TABLE lml_unidade_uso_sustentavel_a OWNER TO postgres#
CREATE TABLE pto_marco_de_limite_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipomarcolim smallint NOT NULL,
    latitude character varying(15) NOT NULL,
    latitude_gms double precision,
    longitude character varying(15),
    longitude_gms double precision,
    altitudeortometrica double precision,
    sistemageodesico smallint NOT NULL,
    outrarefplan character varying(80),
    referencialaltim smallint,
    outrarefalt character varying(80),
    orgresp character varying(80),
    codigo character varying(80),
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE pto_marco_de_limite_p OWNER TO postgres#
CREATE TABLE pto_pto_est_med_fenomenos_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoptoestmed smallint NOT NULL,
    codestacao character varying(80),
    id_est_med_fenomenos uuid,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE pto_pto_est_med_fenomenos_p OWNER TO postgres#
CREATE TABLE pto_pto_geod_topo_controle_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tiporef smallint NOT NULL,
    latitude character varying(15) NOT NULL,
    longitude character varying(15) NOT NULL,
    altitudeortometrica double precision,
    altitudegeometrica double precision,
    sistemageodesico smallint NOT NULL,
    outrarefplan character varying(80),
    referencialaltim smallint NOT NULL,
    outrarefalt character varying(80),
    orgaoenteresp character varying(80),
    codponto character varying(80),
    obs character varying(80),
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE pto_pto_geod_topo_controle_p OWNER TO postgres#
CREATE TABLE pto_pto_ref_geod_topo_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tiporef smallint NOT NULL,
    latitude character varying(15) NOT NULL,
    longitude character varying(15) NOT NULL,
    altitudeortometrica double precision,
    altitudegeometrica double precision,
    sistemageodesico smallint NOT NULL,
    outrarefplan character varying(80),
    referencialaltim smallint NOT NULL,
    outrarefalt character varying(80),
    orgaoenteresp character varying(80),
    codponto character varying(80),
    obs character varying(80),
    geom public.geometry(MultiPoint,[epsg]),
    nome character varying(80),
    proximidade smallint NOT NULL,
    tipoptorefgeodtopo smallint NOT NULL,
    redereferencia smallint NOT NULL,
    referencialgrav smallint NOT NULL,
    situacaomarco smallint,
    datavisita character varying(80),
    datamedicao character varying(80),
    valorgravidade real
)#
ALTER TABLE pto_pto_ref_geod_topo_p OWNER TO postgres#
CREATE TABLE rel_alteracao_fisiografica_antropica_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE rel_alteracao_fisiografica_antropica_a OWNER TO postgres#
CREATE TABLE rel_alteracao_fisiografica_antropica_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE rel_alteracao_fisiografica_antropica_l OWNER TO postgres#
CREATE TABLE rel_alteracao_fisiografica_antropica_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE rel_alteracao_fisiografica_antropica_p OWNER TO postgres#
CREATE TABLE rel_aterro_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    matconstr smallint[] NOT NULL
)#
ALTER TABLE rel_aterro_a OWNER TO postgres#
CREATE TABLE rel_aterro_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    matconstr smallint[] NOT NULL
)#
ALTER TABLE rel_aterro_l OWNER TO postgres#
CREATE TABLE rel_aterro_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    matconstr smallint[] NOT NULL
)#
ALTER TABLE rel_aterro_p OWNER TO postgres#
CREATE TABLE rel_corte_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    matconstr smallint[] NOT NULL
)#
ALTER TABLE rel_corte_a OWNER TO postgres#
CREATE TABLE rel_corte_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    matconstr smallint[] NOT NULL
)#
ALTER TABLE rel_corte_l OWNER TO postgres#
CREATE TABLE rel_corte_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoalterantrop smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    matconstr smallint[] NOT NULL
)#
ALTER TABLE rel_corte_p OWNER TO postgres#
CREATE TABLE rel_curva_batimetrica_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    profundidade integer NOT NULL
)#
ALTER TABLE rel_curva_batimetrica_l OWNER TO postgres#
CREATE TABLE rel_curva_nivel_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    cota integer NOT NULL,
    depressao smallint DEFAULT 2 NOT NULL,
    tipocurvanivel smallint NOT NULL
)#
ALTER TABLE rel_curva_nivel_l OWNER TO postgres#
CREATE TABLE rel_dolina_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE rel_dolina_a OWNER TO postgres#
CREATE TABLE rel_dolina_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE rel_dolina_p OWNER TO postgres#
CREATE TABLE rel_duna_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    fixa smallint NOT NULL
)#
ALTER TABLE rel_duna_a OWNER TO postgres#
CREATE TABLE rel_duna_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    fixa smallint NOT NULL
)#
ALTER TABLE rel_duna_l OWNER TO postgres#
CREATE TABLE rel_duna_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    fixa smallint NOT NULL
)#
ALTER TABLE rel_duna_p OWNER TO postgres#
CREATE TABLE rel_elemento_fisiografico_natural_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE rel_elemento_fisiografico_natural_a OWNER TO postgres#
CREATE TABLE rel_elemento_fisiografico_natural_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE rel_elemento_fisiografico_natural_l OWNER TO postgres#
CREATE TABLE rel_elemento_fisiografico_natural_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE rel_elemento_fisiografico_natural_p OWNER TO postgres#
CREATE TABLE rel_gruta_caverna_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE rel_gruta_caverna_l OWNER TO postgres#
CREATE TABLE rel_gruta_caverna_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE rel_gruta_caverna_p OWNER TO postgres#
CREATE TABLE rel_isolinha_hipsometrica_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE rel_isolinha_hipsometrica_l OWNER TO postgres#
CREATE TABLE rel_pico_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE rel_pico_p OWNER TO postgres#
CREATE TABLE rel_ponto_cotado_altimetrico_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    cotacomprovada smallint NOT NULL,
    cota double precision NOT NULL
)#
ALTER TABLE rel_ponto_cotado_altimetrico_p OWNER TO postgres#
CREATE TABLE rel_ponto_cotado_batimetrico_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    profundidade double precision NOT NULL
)#
ALTER TABLE rel_ponto_cotado_batimetrico_p OWNER TO postgres#
CREATE TABLE rel_ponto_hipsometrico_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE rel_ponto_hipsometrico_p OWNER TO postgres#
CREATE TABLE rel_rocha_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    formarocha smallint
)#
ALTER TABLE rel_rocha_a OWNER TO postgres#
CREATE TABLE rel_rocha_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    formarocha smallint
)#
ALTER TABLE rel_rocha_l OWNER TO postgres#
CREATE TABLE rel_rocha_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoelemnat smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    formarocha smallint
)#
ALTER TABLE rel_rocha_p OWNER TO postgres#
CREATE TABLE rel_terreno_exposto_a (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tipoterrexp smallint,
    causaexposicao smallint,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE rel_terreno_exposto_a OWNER TO postgres#
CREATE TABLE rod_trecho_rodoviario_a (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tipovia smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    administracao smallint NOT NULL,
    concessionaria character varying(100),
    revestimento smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    canteirodivisorio smallint NOT NULL,
    nrpistas integer NOT NULL,
    nrfaixas integer,
    trafego smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    sigla character varying(6),
    codtrechorod character varying(25),
    limitevelocidade real,
    emperimetrourbano smallint,
    acostamento smallint
)#
ALTER TABLE rod_trecho_rodoviario_a OWNER TO postgres#
CREATE TABLE rod_trecho_rodoviario_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tipovia smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    administracao smallint NOT NULL,
    concessionaria character varying(100),
    revestimento smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    canteirodivisorio smallint NOT NULL,
    nrpistas integer NOT NULL,
    nrfaixas integer,
    trafego smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg]),
    sigla character varying(6),
    codtrechorod character varying(25),
    limitevelocidade real,
    emperimetrourbano smallint,
    acostamento smallint
)#
ALTER TABLE rod_trecho_rodoviario_l OWNER TO postgres#
CREATE TABLE rod_via_deslocamento_a (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tipovia smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    administracao smallint NOT NULL,
    concessionaria character varying(100),
    revestimento smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    canteirodivisorio smallint NOT NULL,
    nrpistas integer NOT NULL,
    nrfaixas integer,
    trafego smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE rod_via_deslocamento_a OWNER TO postgres#
CREATE TABLE rod_via_deslocamento_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    tipovia smallint NOT NULL,
    jurisdicao smallint NOT NULL,
    administracao smallint NOT NULL,
    concessionaria character varying(100),
    revestimento smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    canteirodivisorio smallint NOT NULL,
    nrpistas integer NOT NULL,
    nrfaixas integer,
    trafego smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE rod_via_deslocamento_l OWNER TO postgres#
CREATE TABLE snb_barragem_calcadao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoequipdesenvsocial smallint NOT NULL,
    sigla character varying(80),
    codequipdesenvsocial character varying(80),
    localizacaoequipdesenvsocial smallint,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE snb_barragem_calcadao_a OWNER TO postgres#
CREATE TABLE snb_dep_abast_agua_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipodepgeral smallint[] NOT NULL,
    matconstr smallint[],
    tipoexposicao smallint NOT NULL,
    tipoprodutoresiduo smallint[],
    tipoconteudo smallint[],
    unidadevolume smallint,
    valorvolume real,
    tratamento smallint NOT NULL,
    estadofisico smallint,
    finalidadedep smallint NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid,
    id_complexo_abast_agua uuid,
    geom public.geometry(MultiPolygon,[epsg]),
    situacaoagua smallint NOT NULL
)#
ALTER TABLE snb_dep_abast_agua_a OWNER TO postgres#
CREATE TABLE snb_dep_abast_agua_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint,
    tipodepgeral smallint[] NOT NULL,
    matconstr smallint[],
    tipoexposicao smallint NOT NULL,
    tipoprodutoresiduo smallint[],
    tipoconteudo smallint[],
    unidadevolume smallint,
    valorvolume real,
    tratamento smallint NOT NULL,
    estadofisico smallint,
    finalidadedep smallint NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid,
    id_complexo_abast_agua uuid,
    geom public.geometry(MultiPoint,[epsg]),
    situacaoagua smallint NOT NULL
)#
ALTER TABLE snb_dep_abast_agua_p OWNER TO postgres#
CREATE TABLE snb_dep_saneamento_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint,
    situacaofisica smallint,
    tipodepgeral smallint NOT NULL,
    matconstr smallint[],
    tipoexposicao smallint NOT NULL,
    tipoprodutoresiduo smallint[],
    tipoconteudo smallint[],
    unidadevolume smallint,
    valorvolume double precision,
    tratamento smallint NOT NULL,
    estadofisico smallint NOT NULL,
    finalidadedep smallint NOT NULL,
    id_complexo_saneamento uuid,
    geom public.geometry(MultiPolygon,[epsg]) NOT NULL
)#
ALTER TABLE snb_dep_saneamento_a OWNER TO postgres#
CREATE TABLE snb_dep_saneamento_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint,
    situacaofisica smallint,
    tipodepgeral smallint NOT NULL,
    matconstr smallint[],
    tipoexposicao smallint NOT NULL,
    tipoprodutoresiduo smallint[],
    tipoconteudo smallint[],
    unidadevolume smallint,
    valorvolume double precision,
    tratamento smallint NOT NULL,
    estadofisico smallint NOT NULL,
    finalidadedep smallint NOT NULL,
    id_complexo_saneamento uuid,
    geom public.geometry(MultiPoint,[epsg]) NOT NULL
)#
ALTER TABLE snb_dep_saneamento_p OWNER TO postgres#
CREATE TABLE tra_caminho_aereo_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipocaminhoaereo smallint NOT NULL,
    tipousocaminhoaer smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_caminho_aereo_l OWNER TO postgres#
CREATE TABLE tra_caminho_carrocavel_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_caminho_carrocavel_l OWNER TO postgres#
CREATE TABLE tra_entroncamento_pto_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipoentroncamento smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    id_entroncamento uuid
)#
ALTER TABLE tra_entroncamento_pto_p OWNER TO postgres#
CREATE TABLE tra_funicular_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_funicular_l OWNER TO postgres#
CREATE TABLE tra_passagem_elevada_viaduto_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    tipopassagviad smallint NOT NULL,
    vaolivrehoriz double precision,
    vaovertical double precision,
    gabhorizsup double precision,
    gabvertsup double precision,
    cargasuportmaxima double precision,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE tra_passagem_elevada_viaduto_a OWNER TO postgres#
CREATE TABLE tra_passagem_elevada_viaduto_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    tipopassagviad smallint NOT NULL,
    vaolivrehoriz double precision,
    vaovertical double precision,
    gabhorizsup double precision,
    gabvertsup double precision,
    cargasuportmaxima double precision,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_passagem_elevada_viaduto_l OWNER TO postgres#
CREATE TABLE tra_passagem_elevada_viaduto_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    tipopassagviad smallint NOT NULL,
    vaolivrehoriz double precision,
    vaovertical double precision,
    gabhorizsup double precision,
    gabvertsup double precision,
    cargasuportmaxima double precision,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE tra_passagem_elevada_viaduto_p OWNER TO postgres#
CREATE TABLE tra_passagem_nivel_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE tra_passagem_nivel_p OWNER TO postgres#
CREATE TABLE tra_patio_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[],
    administracao smallint[],
    operacional smallint NOT NULL,
    situacaofisica smallint,
    finalidadepatio smallint[] NOT NULL,
    id_estrut_transporte uuid,
    id_estrut_apoio uuid,
    id_estacao_rodoviaria uuid,
    id_estacao_metroviaria uuid,
    id_estacao_ferroviaria uuid,
    id_terminal_rodoviario uuid,
    id_terminal_ferroviario uuid,
    id_terminal_hidroviario uuid,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE tra_patio_a OWNER TO postgres#
CREATE TABLE tra_obra_de_arte_viaria_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE tra_obra_de_arte_viaria_p OWNER TO postgres#
CREATE TABLE tra_obra_de_arte_viaria_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_obra_de_arte_viaria_l OWNER TO postgres#
CREATE TABLE tra_obra_de_arte_viaria_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE tra_obra_de_arte_viaria_a OWNER TO postgres#
CREATE TABLE tra_ponte_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    tipoponte smallint NOT NULL,
    vaolivrehoriz double precision,
    vaovertical double precision,
    cargasuportmaxima double precision,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE tra_ponte_a OWNER TO postgres#
CREATE TABLE tra_ponte_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    tipoponte smallint NOT NULL,
    vaolivrehoriz double precision,
    vaovertical double precision,
    cargasuportmaxima double precision,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_ponte_l OWNER TO postgres#
CREATE TABLE tra_ponte_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    tipoponte smallint NOT NULL,
    vaolivrehoriz double precision,
    vaovertical double precision,
    cargasuportmaxima double precision,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE tra_ponte_p OWNER TO postgres#
CREATE TABLE tra_travessia_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipotravessia smallint NOT NULL,
    tipouso smallint NOT NULL,
    tipoembarcacao smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_travessia_l OWNER TO postgres#
CREATE TABLE tra_travessia_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    tipotravessia smallint NOT NULL,
    tipouso smallint NOT NULL,
    tipoembarcacao smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE tra_travessia_p OWNER TO postgres#
CREATE TABLE tra_travessia_pedestre_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    tipotravessiaped smallint NOT NULL,
    largura double precision,
    extensao double precision,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_travessia_pedestre_l OWNER TO postgres#
CREATE TABLE tra_travessia_pedestre_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    tipotravessiaped smallint NOT NULL,
    largura double precision,
    extensao double precision,
    geom public.geometry(MultiPoint,[epsg])
)#
ALTER TABLE tra_travessia_pedestre_p OWNER TO postgres#
CREATE TABLE tra_travessia_pedrestre_a (
    id serial NOT NULL,
    nome character varying(80) NOT NULL,
    geometriaaproximada smallint NOT NULL,
    matconstr smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    operacional smallint NOT NULL,
    situacaoespacial smallint NOT NULL,
    tipotravessiaped smallint NOT NULL,
    largura double precision,
    extensao double precision,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE tra_travessia_pedrestre_a OWNER TO postgres#
CREATE TABLE tra_trilha_picada_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiLineString,[epsg])
)#
ALTER TABLE tra_trilha_picada_l OWNER TO postgres#
CREATE TABLE tra_tunel_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    altura double precision,
    tipotunel smallint,
    geom public.geometry(MultiPolygon,[epsg])
)#
ALTER TABLE tra_tunel_a OWNER TO postgres#
CREATE TABLE tra_tunel_l (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    altura double precision,
    tipotunel smallint,
    geom public.geometry(MultiLineString,[epsg]) NOT NULL
)#
ALTER TABLE tra_tunel_l OWNER TO postgres#
CREATE TABLE tra_tunel_p (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    modaluso smallint[] NOT NULL,
    matconstr smallint[] NOT NULL,
    operacional smallint NOT NULL,
    situacaofisica smallint NOT NULL,
    necessitamanutencao smallint NOT NULL,
    largura double precision,
    extensao double precision,
    nrfaixas integer,
    nrpistas integer NOT NULL,
    posicaopista smallint NOT NULL,
    tipopavimentacao smallint NOT NULL,
    altura double precision,
    tipotunel smallint,
    geom public.geometry(MultiPoint,[epsg]) NOT NULL
)#
ALTER TABLE tra_tunel_p OWNER TO postgres#
CREATE TABLE veg_brejo_pantano_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint
)#
ALTER TABLE veg_brejo_pantano_a OWNER TO postgres#
CREATE TABLE veg_caatinga_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint
)#
ALTER TABLE veg_caatinga_a OWNER TO postgres#
CREATE TABLE veg_campinarana_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint
)#
ALTER TABLE veg_campinarana_a OWNER TO postgres#
CREATE TABLE veg_campo_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint,
    tipocampo smallint NOT NULL
)#
ALTER TABLE veg_campo_a OWNER TO postgres#
CREATE TABLE veg_cerrado_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint,
    vereda smallint
)#
ALTER TABLE veg_cerrado_a OWNER TO postgres#
CREATE TABLE veg_floresta_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint,
    especiepredominante smallint
)#
ALTER TABLE veg_floresta_a OWNER TO postgres#
CREATE TABLE veg_mangue_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint,
    tipomanguezal smallint
)#
ALTER TABLE veg_mangue_a OWNER TO postgres#
CREATE TABLE veg_reflorestamento_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    tipolavoura smallint NOT NULL,
    finalidade smallint,
    terreno smallint,
    cultivopredominante smallint[] NOT NULL,
    espacamentoindividuos double precision,
    espessura double precision,
    alturamediaindividuos double precision
)#
ALTER TABLE veg_reflorestamento_a OWNER TO postgres#
CREATE TABLE veg_veg_area_contato_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint,
    tipoveg smallint[]
)#
ALTER TABLE veg_veg_area_contato_a OWNER TO postgres#
CREATE TABLE veg_veg_cultivada_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    tipolavoura smallint NOT NULL,
    finalidade smallint,
    terreno smallint,
    cultivopredominante smallint[] NOT NULL
)#
ALTER TABLE veg_veg_cultivada_a OWNER TO postgres#
CREATE TABLE veg_veg_natural_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint
)#
ALTER TABLE veg_veg_natural_a OWNER TO postgres#
CREATE TABLE veg_veg_restinga_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    antropizada smallint NOT NULL,
    secundaria smallint NOT NULL,
    densidade smallint
)#
ALTER TABLE veg_veg_restinga_a OWNER TO postgres#
CREATE TABLE veg_vegetacao_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid
)#
ALTER TABLE veg_vegetacao_a OWNER TO postgres#
CREATE TABLE ver_arvore_isolada_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    geom public.geometry(MultiPoint,[epsg]),
    id_area_verde uuid
)#
ALTER TABLE ver_arvore_isolada_p OWNER TO postgres#
CREATE TABLE ver_jardim_a (
    id serial NOT NULL,
    nome character varying(80),
    geometriaaproximada smallint NOT NULL,
    classificacaoporte smallint NOT NULL,
    geom public.geometry(MultiPolygon,[epsg]),
    id_area_verde uuid,
    tipolavoura smallint NOT NULL,
    finalidade smallint NOT NULL,
    terreno smallint,
    cultivopredominante smallint[] NOT NULL
)#
ALTER TABLE ver_jardim_a OWNER TO postgres#
SET search_path = public, pg_catalog#
CREATE TABLE aux_area_a (
    id serial NOT NULL,
    classe character varying(80),
    obs text,
    geom geometry(MultiPolygon,[epsg])
)#
ALTER TABLE aux_area_a OWNER TO postgres#
CREATE TABLE aux_descontinuidade_geometrica_l (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    motivodescontinuidade smallint NOT NULL,
    categoria smallint NOT NULL,
    geom geometry(MultiLineString,[epsg])
)#
ALTER TABLE aux_descontinuidade_geometrica_l OWNER TO postgres#
CREATE TABLE aux_descontinuidade_geometrica_p (
    id serial NOT NULL,
    geometriaaproximada smallint NOT NULL,
    motivodescontinuidade smallint NOT NULL,
    categoria smallint NOT NULL,
    geom geometry(MultiPoint,[epsg])
)#
ALTER TABLE aux_descontinuidade_geometrica_p OWNER TO postgres#
CREATE TABLE aux_linha_l (
    id serial NOT NULL,
    classe character varying(80),
    obs text,
    geom geometry(MultiLineString,[epsg])
)#
ALTER TABLE aux_linha_l OWNER TO postgres#
CREATE TABLE aux_moldura_a (
    id serial NOT NULL,
    geom geometry(MultiPolygon,[epsg]),
    mi character varying(80),
    inom character varying(80),
    escala character varying(80),
    nomecarta character varying(80),
    anoaquisicao character varying(80),
    engrespaquisicao character varying(80),
    opaquisicao character varying(80),
    datainicioaquisicao date,
    datafimaquisicao date,
    engresprevisaoaquisicao character varying(80),
    oprevisaoaquisicao character varying(80),
    datainiciorevaquisicao date,
    datafimrevaquisicao date,
    engrespreambulacao character varying(80),
    opreambulacao character varying(80),
    datainicioreambulacao date,
    datafimreambulacao date,
    oprevisaoreambulacao character varying(80),
    engrespvalidacaoedicao character varying(80),
    opvalidacao character varying(80),
    datainiciovalidacao date,
    datafimvalidacao date,
    opedicao character varying(80),
    datainicioedicao date,
    datafimedicao date
)#
ALTER TABLE aux_moldura_a OWNER TO postgres#
CREATE TABLE aux_objeto_desconhecido_a (
    id serial NOT NULL,
    classe character varying(80),
    descricao text,
    geom geometry(MultiPolygon,[epsg])
)#
ALTER TABLE aux_objeto_desconhecido_a OWNER TO postgres#
CREATE TABLE aux_objeto_desconhecido_l (
    id serial NOT NULL,
    classe character varying(80),
    descricao text,
    geom geometry(MultiLineString,[epsg])
)#
ALTER TABLE aux_objeto_desconhecido_l OWNER TO postgres#
CREATE TABLE aux_objeto_desconhecido_p (
    id serial NOT NULL,
    classe character varying(80),
    descricao text,
    geom geometry(MultiPoint,[epsg])
)#
ALTER TABLE aux_objeto_desconhecido_p OWNER TO postgres#
CREATE TABLE aux_ponto_p (
    id serial NOT NULL,
    classe character varying(80),
    obs text,
    geom geometry(MultiPoint,[epsg])
)#
ALTER TABLE aux_ponto_p OWNER TO postgres#
CREATE TABLE public.db_metadata(
	edgvversion varchar(6) NOT NULL DEFAULT '3.0',
	dbimplversion varchar(50) NOT NULL DEFAULT 1,
	CONSTRAINT edgvversioncheck CHECK (edgvversion = '3.0')
)#
INSERT INTO public.db_metadata (edgvversion,dbimplversion) VALUES ('3.0','2')#

SET search_path = complexos, pg_catalog#
ALTER TABLE ONLY aer_complexo_aeroportuario
    ADD CONSTRAINT aer_complexo_aeroportuario_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_assentamento_precario
    ADD CONSTRAINT cbge_assentamento_precario_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_complexo_habitacional
    ADD CONSTRAINT cbge_complexo_habitacional_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY cbge_condominio
    ADD CONSTRAINT cbge_condominio_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_conjunto_habitacional
    ADD CONSTRAINT cbge_conjunto_habitacional_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_terminal_ferroviario
    ADD CONSTRAINT emu_terminal_ferroviario_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_terminal_hidroviario
    ADD CONSTRAINT emu_terminal_hidroviario_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_terminal_rodoviario
    ADD CONSTRAINT emu_terminal_rodoviario_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_complexo_comunicacao
    ADD CONSTRAINT enc_complexo_comunicacao_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY enc_complexo_gerador_energia_eletrica
    ADD CONSTRAINT enc_complexo_gerador_energia_eletrica_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY enc_subest_transm_distrib_energia_eletrica
    ADD CONSTRAINT enc_subest_transm_distrib_energia_eletrica_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY fer_estacao_ferroviaria
    ADD CONSTRAINT fer_estacao_ferroviaria_pk PRIMARY KEY (id)#
ALTER TABLE ONLY fer_estacao_metroviaria
    ADD CONSTRAINT fer_estacao_metroviaria_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_complexo_portuario
    ADD CONSTRAINT hdv_complexo_portuario_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_complexo_desportivo
    ADD CONSTRAINT laz_complexo_desportivo_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_complexo_desportivo_lazer
    ADD CONSTRAINT laz_complexo_desportivo_lazer_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY laz_complexo_recreativo
    ADD CONSTRAINT laz_complexo_recreativo_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_aglomerado_rural
    ADD CONSTRAINT lml_aglomerado_rural_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_aglomerado_rural_de_extensao_urbana
    ADD CONSTRAINT lml_aglomerado_rural_de_extensao_urbana_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_aglomerado_rural_isolado
    ADD CONSTRAINT lml_aglomerado_rural_isolado_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_aldeia_indigena
    ADD CONSTRAINT lml_aldeia_indigena_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_capital
    ADD CONSTRAINT lml_capital_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_cidade
    ADD CONSTRAINT lml_cidade_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_localidade
    ADD CONSTRAINT lml_localidade_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY lml_vila
    ADD CONSTRAINT lml_vila_pk PRIMARY KEY (id)#
ALTER TABLE ONLY pto_est_med_fenomenos
    ADD CONSTRAINT pto_est_med_fenomenos_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY rel_arquipelago
    ADD CONSTRAINT rel_arquipelago_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY rod_estacao_rodoviaria
    ADD CONSTRAINT rod_estacao_rodoviaria_pk PRIMARY KEY (id)#
ALTER TABLE ONLY snb_complexo_abast_agua
    ADD CONSTRAINT snb_complexo_abast_agua_pk PRIMARY KEY (id)#
ALTER TABLE ONLY snb_complexo_saneamento
    ADD CONSTRAINT snb_complexo_saneamento_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY tra_entroncamento
    ADD CONSTRAINT tra_entroncamento_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY tra_estrut_apoio
    ADD CONSTRAINT tra_estrut_apoio_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_estrut_transporte
    ADD CONSTRAINT tra_estrut_transporte_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY ver_area_verde
    ADD CONSTRAINT ver_area_verde_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY ver_area_verde_urbana
    ADD CONSTRAINT ver_area_verde_urbana_pk PRIMARY KEY (id) WITH (fillfactor='10')#
SET search_path = edgv, pg_catalog#
ALTER TABLE ONLY aer_pista_ponto_pouso_a
    ADD CONSTRAINT aer_pista_ponto_pouso_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aer_pista_ponto_pouso_l
    ADD CONSTRAINT aer_pista_ponto_pouso_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aer_pista_ponto_pouso_p
    ADD CONSTRAINT aer_pista_ponto_pouso_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_area_agropec_ext_veg_pesca_a
    ADD CONSTRAINT cbge_area_agropec_ext_veg_pesca_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_area_construida_a
    ADD CONSTRAINT cbge_area_construida_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY cbge_area_de_propriedade_particular_a
    ADD CONSTRAINT cbge_area_de_propriedade_particular_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_area_duto_a
    ADD CONSTRAINT cbge_area_duto_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_area_habitacional_a
    ADD CONSTRAINT cbge_area_habitacional_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_canteiro_central_a
    ADD CONSTRAINT cbge_canteiro_central_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_canteiro_central_l
    ADD CONSTRAINT cbge_canteiro_central_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_cemiterio_a
    ADD CONSTRAINT cbge_cemiterio_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_cemiterio_p
    ADD CONSTRAINT cbge_cemiterio_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_delimitacao_fisica_l
    ADD CONSTRAINT cbge_delimitacao_fisica_l_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY cbge_deposito_geral_a
    ADD CONSTRAINT cbge_deposito_geral_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_deposito_geral_p
    ADD CONSTRAINT cbge_deposito_geral_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_entroncamento_area_a
    ADD CONSTRAINT cbge_entroncamento_area_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY cbge_espelho_dagua_a
    ADD CONSTRAINT cbge_espelho_dagua_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY cbge_estacionamento_a
    ADD CONSTRAINT cbge_estacionamento_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_largo_a
    ADD CONSTRAINT cbge_largo_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY cbge_passeio_a
    ADD CONSTRAINT cbge_passeio_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_passeio_l
    ADD CONSTRAINT cbge_passeio_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_poste_p
    ADD CONSTRAINT cbge_poste_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY cbge_praca_a
    ADD CONSTRAINT cbge_praca_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY cbge_quadra_a
    ADD CONSTRAINT cbge_quadra_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY cbge_retorno_l
    ADD CONSTRAINT cbge_retorno_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_retorno_p
    ADD CONSTRAINT cbge_retorno_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_trecho_arruamento_a
    ADD CONSTRAINT cbge_trecho_arruamento_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY cbge_trecho_arruamento_l
    ADD CONSTRAINT cbge_trecho_arruamento_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY dut_galeria_bueiro_l
    ADD CONSTRAINT dut_galeria_bueiro_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY dut_trecho_duto_l
    ADD CONSTRAINT dut_trecho_duto_l_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY eco_equip_agropec_a
    ADD CONSTRAINT eco_equip_agropec_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY eco_equip_agropec_l
    ADD CONSTRAINT eco_equip_agropec_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY eco_equip_agropec_p
    ADD CONSTRAINT eco_equip_agropec_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY eco_ext_mineral_a
    ADD CONSTRAINT eco_ext_mineral_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY eco_ext_mineral_p
    ADD CONSTRAINT eco_ext_mineral_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY eco_plataforma_a
    ADD CONSTRAINT eco_plataforma_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY eco_plataforma_p
    ADD CONSTRAINT eco_plataforma_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_banheiro_publico_a
    ADD CONSTRAINT edf_banheiro_publico_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_banheiro_publico_p
    ADD CONSTRAINT edf_banheiro_publico_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_abast_agua_a
    ADD CONSTRAINT edf_edif_abast_agua_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_abast_agua_p
    ADD CONSTRAINT edf_edif_abast_agua_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_agropec_ext_veg_pesca_a
    ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_agropec_ext_veg_pesca_p
    ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_comerc_serv_a
    ADD CONSTRAINT edf_edif_comerc_serv_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_comerc_serv_p
    ADD CONSTRAINT edf_edif_comerc_serv_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_comunic_a
    ADD CONSTRAINT edf_edif_comunic_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_comunic_p
    ADD CONSTRAINT edf_edif_comunic_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_aeroportuaria_a
    ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_aeroportuaria_p
    ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_est_med_fen_a
    ADD CONSTRAINT edf_edif_constr_est_med_fen_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_est_med_fen_p
    ADD CONSTRAINT edf_edif_constr_est_med_fen_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_lazer_a
    ADD CONSTRAINT edf_edif_constr_lazer_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_lazer_p
    ADD CONSTRAINT edf_edif_constr_lazer_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_portuaria_a
    ADD CONSTRAINT edf_edif_constr_portuaria_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_portuaria_p
    ADD CONSTRAINT edf_edif_constr_portuaria_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_turistica_a
    ADD CONSTRAINT edf_edif_constr_turistica_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_constr_turistica_p
    ADD CONSTRAINT edf_edif_constr_turistica_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_desenv_social_a
    ADD CONSTRAINT edf_edif_desenv_social_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_desenv_social_p
    ADD CONSTRAINT edf_edif_desenv_social_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_energia_a
    ADD CONSTRAINT edf_edif_energia_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_energia_p
    ADD CONSTRAINT edf_edif_energia_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_ensino_a
    ADD CONSTRAINT edf_edif_ensino_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_ensino_p
    ADD CONSTRAINT edf_edif_ensino_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_ext_mineral_a
    ADD CONSTRAINT edf_edif_ext_mineral_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_ext_mineral_p
    ADD CONSTRAINT edf_edif_ext_mineral_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_habitacional_a
    ADD CONSTRAINT edf_edif_habitacional_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_habitacional_p
    ADD CONSTRAINT edf_edif_habitacional_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_industrial_a
    ADD CONSTRAINT edf_edif_industrial_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_industrial_p
    ADD CONSTRAINT edf_edif_industrial_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_metro_ferroviaria_a
    ADD CONSTRAINT edf_edif_metro_ferroviaria_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_metro_ferroviaria_p
    ADD CONSTRAINT edf_edif_metro_ferroviaria_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_policia_a
    ADD CONSTRAINT edf_edif_policia_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_policia_p
    ADD CONSTRAINT edf_edif_policia_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_pub_civil_a
    ADD CONSTRAINT edf_edif_pub_civil_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_pub_civil_p
    ADD CONSTRAINT edf_edif_pub_civil_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_pub_militar_a
    ADD CONSTRAINT edf_edif_pub_militar_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_pub_militar_p
    ADD CONSTRAINT edf_edif_pub_militar_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_religiosa_a
    ADD CONSTRAINT edf_edif_religiosa_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_religiosa_p
    ADD CONSTRAINT edf_edif_religiosa_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_residencial_a
    ADD CONSTRAINT edf_edif_residencial_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_residencial_p
    ADD CONSTRAINT edf_edif_residencial_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_rodoviaria_a
    ADD CONSTRAINT edf_edif_rodoviaria_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_rodoviaria_p
    ADD CONSTRAINT edf_edif_rodoviaria_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_saneamento_a
    ADD CONSTRAINT edf_edif_saneamento_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_saneamento_p
    ADD CONSTRAINT edf_edif_saneamento_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_saude_a
    ADD CONSTRAINT edf_edif_saude_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_saude_p
    ADD CONSTRAINT edf_edif_saude_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_servico_social_a
    ADD CONSTRAINT edf_edif_servico_social_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edif_servico_social_p
    ADD CONSTRAINT edf_edif_servico_social_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edificacao_a
    ADD CONSTRAINT edf_edificacao_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_edificacao_p
    ADD CONSTRAINT edf_edificacao_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_hab_indigena_a
    ADD CONSTRAINT edf_hab_indigena_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_hab_indigena_p
    ADD CONSTRAINT edf_hab_indigena_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_combustivel_a
    ADD CONSTRAINT edf_posto_combustivel_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_combustivel_p
    ADD CONSTRAINT edf_posto_combustivel_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_fiscal_a
    ADD CONSTRAINT edf_posto_fiscal_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_fiscal_p
    ADD CONSTRAINT edf_posto_fiscal_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_guarda_municipal_a
    ADD CONSTRAINT edf_posto_guarda_municipal_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_guarda_municipal_p
    ADD CONSTRAINT edf_posto_guarda_municipal_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_policia_militar_a
    ADD CONSTRAINT edf_posto_policia_militar_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_policia_militar_p
    ADD CONSTRAINT edf_posto_policia_militar_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_policia_rod_federal_a
    ADD CONSTRAINT edf_posto_policia_rod_federal_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_posto_policia_rod_federal_p
    ADD CONSTRAINT edf_posto_policia_rod_federal_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_representacao_diplomatica_a
    ADD CONSTRAINT edf_representacao_diplomatica_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY edf_representacao_diplomatica_p
    ADD CONSTRAINT edf_representacao_diplomatica_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_acesso_a
    ADD CONSTRAINT emu_acesso_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_acesso_l
    ADD CONSTRAINT emu_acesso_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_acesso_p
    ADD CONSTRAINT emu_acesso_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_ciclovia_l
    ADD CONSTRAINT emu_ciclovia_l_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY emu_elevador_a
    ADD CONSTRAINT emu_elevador_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_elevador_l
    ADD CONSTRAINT emu_elevador_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_elevador_p
    ADD CONSTRAINT emu_elevador_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_escadaria_a
    ADD CONSTRAINT emu_escadaria_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_escadaria_l
    ADD CONSTRAINT emu_escadaria_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_escadaria_p
    ADD CONSTRAINT emu_escadaria_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_poste_sinalizacao_p
    ADD CONSTRAINT emu_poste_sinalizacao_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_rampa_a
    ADD CONSTRAINT emu_rampa_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_rampa_l
    ADD CONSTRAINT emu_rampa_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY emu_rampa_p
    ADD CONSTRAINT emu_rampa_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_aerogerador_p
    ADD CONSTRAINT enc_aerogerador_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_antena_comunic_p
    ADD CONSTRAINT enc_antena_comunic_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY enc_casa_de_forca_p
    ADD CONSTRAINT enc_casa_de_forca_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_central_geradora_eolica_a
    ADD CONSTRAINT enc_central_geradora_eolica_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_central_geradora_eolica_p
    ADD CONSTRAINT enc_central_geradora_eolica_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_est_gerad_energia_eletrica_a
    ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_est_gerad_energia_eletrica_l
    ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_est_gerad_energia_eletrica_p
    ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_grupo_transformadores_a
    ADD CONSTRAINT enc_grupo_transformadores_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_grupo_transformadores_p
    ADD CONSTRAINT enc_grupo_transformadores_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_hidreletrica_a
    ADD CONSTRAINT enc_hidreletrica_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_hidreletrica_l
    ADD CONSTRAINT enc_hidreletrica_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_hidreletrica_p
    ADD CONSTRAINT enc_hidreletrica_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_termeletrica_a
    ADD CONSTRAINT enc_termeletrica_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_termeletrica_p
    ADD CONSTRAINT enc_termeletrica_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY enc_torre_comunic_p
    ADD CONSTRAINT enc_torre_comunic_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY enc_torre_energia_p
    ADD CONSTRAINT enc_torre_energia_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY enc_trecho_comunic_l
    ADD CONSTRAINT enc_trecho_comunic_l_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY enc_trecho_energia_l
    ADD CONSTRAINT enc_trecho_energia_l_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY enc_zona_linhas_energia_comunicacao_a
    ADD CONSTRAINT enc_zona_linhas_energia_comunicacao_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY fer_cremalheira_l
    ADD CONSTRAINT fer_cremalheira_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY fer_cremalheira_p
    ADD CONSTRAINT fer_cremalheira_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY fer_girador_ferroviario_p
    ADD CONSTRAINT fer_girador_ferroviario_p_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY fer_trecho_ferroviario_l
    ADD CONSTRAINT fer_trecho_ferroviario_l_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY hdv_atracadouro_terminal_a
    ADD CONSTRAINT hdv_atracadouro_terminal_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_atracadouro_terminal_l
    ADD CONSTRAINT hdv_atracadouro_terminal_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_atracadouro_terminal_p
    ADD CONSTRAINT hdv_atracadouro_terminal_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_eclusa_a
    ADD CONSTRAINT hdv_eclusa_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_eclusa_l
    ADD CONSTRAINT hdv_eclusa_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_eclusa_p
    ADD CONSTRAINT hdv_eclusa_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_fundeadouro_a
    ADD CONSTRAINT hdv_fundeadouro_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_fundeadouro_p
    ADD CONSTRAINT hdv_fundeadouro_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_obstaculo_navegacao_a
    ADD CONSTRAINT hdv_obstaculo_navegacao_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_obstaculo_navegacao_l
    ADD CONSTRAINT hdv_obstaculo_navegacao_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_obstaculo_navegacao_p
    ADD CONSTRAINT hdv_obstaculo_navegacao_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hdv_sinalizacao_p
    ADD CONSTRAINT hdv_sinalizacao_p_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY hdv_trecho_hidroviario_l
    ADD CONSTRAINT hdv_trecho_hidroviario_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_area_umida_a
    ADD CONSTRAINT hid_area_umida_a_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY hid_banco_areia_a
    ADD CONSTRAINT hid_banco_areia_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_banco_areia_l
    ADD CONSTRAINT hid_banco_areia_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_barragem_a
    ADD CONSTRAINT hid_barragem_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_barragem_l
    ADD CONSTRAINT hid_barragem_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_barragem_p
    ADD CONSTRAINT hid_barragem_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_canal_a
    ADD CONSTRAINT hid_canal_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_canal_l
    ADD CONSTRAINT hid_canal_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_canal_vala_a
    ADD CONSTRAINT hid_canal_vala_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_canal_vala_l
    ADD CONSTRAINT hid_canal_vala_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_comporta_l
    ADD CONSTRAINT hid_comporta_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_comporta_p
    ADD CONSTRAINT hid_comporta_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_corredeira_a
    ADD CONSTRAINT hid_corredeira_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_corredeira_l
    ADD CONSTRAINT hid_corredeira_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_corredeira_p
    ADD CONSTRAINT hid_corredeira_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_dique_a
    ADD CONSTRAINT hid_dique_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_dique_l
    ADD CONSTRAINT hid_dique_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_dique_p
    ADD CONSTRAINT hid_dique_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_fonte_dagua_p
    ADD CONSTRAINT hid_fonte_dagua_p_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY hid_foz_maritima_a
    ADD CONSTRAINT hid_foz_maritima_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_foz_maritima_l
    ADD CONSTRAINT hid_foz_maritima_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_foz_maritima_p
    ADD CONSTRAINT hid_foz_maritima_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_ilha_a
    ADD CONSTRAINT hid_ilha_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_ilha_l
    ADD CONSTRAINT hid_ilha_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_ilha_p
    ADD CONSTRAINT hid_ilha_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_massa_dagua_a
    ADD CONSTRAINT hid_massa_dagua_a_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY hid_quebramar_molhe_a
    ADD CONSTRAINT hid_quebramar_molhe_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_quebramar_molhe_l
    ADD CONSTRAINT hid_quebramar_molhe_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_queda_dagua_a
    ADD CONSTRAINT hid_queda_dagua_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_queda_dagua_l
    ADD CONSTRAINT hid_queda_dagua_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_queda_dagua_p
    ADD CONSTRAINT hid_queda_dagua_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_recife_a
    ADD CONSTRAINT hid_recife_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_recife_l
    ADD CONSTRAINT hid_recife_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_recife_p
    ADD CONSTRAINT hid_recife_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_rocha_em_agua_a
    ADD CONSTRAINT hid_rocha_em_agua_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_rocha_em_agua_p
    ADD CONSTRAINT hid_rocha_em_agua_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_sumidouro_vertedouro_p
    ADD CONSTRAINT hid_sumidouro_vertedouro_p_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY hid_terreno_sujeito_inundacao_a
    ADD CONSTRAINT hid_terreno_sujeito_inundacao_a_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY hid_trecho_drenagem_l
    ADD CONSTRAINT hid_trecho_drenagem_l_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY hid_vala_a
    ADD CONSTRAINT hid_vala_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY hid_vala_l
    ADD CONSTRAINT hid_vala_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_arquibancada_a
    ADD CONSTRAINT laz_arquibancada_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_arquibancada_l
    ADD CONSTRAINT laz_arquibancada_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_campo_quadra_a
    ADD CONSTRAINT laz_campo_quadra_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_campo_quadra_p
    ADD CONSTRAINT laz_campo_quadra_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_piscina_a
    ADD CONSTRAINT laz_piscina_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY laz_pista_competicao_a
    ADD CONSTRAINT laz_pista_competicao_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_pista_competicao_l
    ADD CONSTRAINT laz_pista_competicao_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_pista_competicao_p
    ADD CONSTRAINT laz_pista_competicao_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_ruina_a
    ADD CONSTRAINT laz_ruina_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_ruina_p
    ADD CONSTRAINT laz_ruina_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_sitio_arqueologico_a
    ADD CONSTRAINT laz_sitio_arqueologico_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY laz_sitio_arqueologico_p
    ADD CONSTRAINT laz_sitio_arqueologico_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_area_densamente_edificada_a
    ADD CONSTRAINT lml_area_densamente_edificada_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_area_especial_a
    ADD CONSTRAINT lml_area_especial_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY lml_area_politico_administrativa_a
    ADD CONSTRAINT lml_area_politico_administrativa_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY lml_area_pub_militar_a
    ADD CONSTRAINT lml_area_pub_militar_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_area_urbana_isolada_a
    ADD CONSTRAINT lml_area_urbana_isolada_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_distrito_a
    ADD CONSTRAINT lml_distrito_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_municipio_a
    ADD CONSTRAINT lml_municipio_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_nome_local_p
    ADD CONSTRAINT lml_nome_local_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY lml_pais_a
    ADD CONSTRAINT lml_pais_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_posic_geo_localidade_p
    ADD CONSTRAINT lml_posic_geo_localidade_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_terra_indigena_a
    ADD CONSTRAINT lml_terra_indigena_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_terra_publica_a
    ADD CONSTRAINT lml_terra_publica_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_unidade_conservacao_a
    ADD CONSTRAINT lml_unidade_conservacao_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_unidade_federacao_a
    ADD CONSTRAINT lml_unidade_federacao_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_unidade_protecao_integral_a
    ADD CONSTRAINT lml_unidade_protecao_integral_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_unidade_protegida_a
    ADD CONSTRAINT lml_unidade_protegida_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY lml_unidade_uso_sustentavel_a
    ADD CONSTRAINT lml_unidade_uso_sustentavel_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY pto_marco_de_limite_p
    ADD CONSTRAINT pto_marco_de_limite_p_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY pto_pto_est_med_fenomenos_p
    ADD CONSTRAINT pto_pto_est_med_fenomenos_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY pto_pto_geod_topo_controle_p
    ADD CONSTRAINT pto_pto_geod_topo_controle_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY pto_pto_ref_geod_topo_p
    ADD CONSTRAINT pto_pto_ref_geod_topo_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_alteracao_fisiografica_antropica_a
    ADD CONSTRAINT rel_alteracao_fisiografica_antropica_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_alteracao_fisiografica_antropica_l
    ADD CONSTRAINT rel_alteracao_fisiografica_antropica_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_alteracao_fisiografica_antropica_p
    ADD CONSTRAINT rel_alteracao_fisiografica_antropica_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_aterro_a
    ADD CONSTRAINT rel_aterro_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_aterro_l
    ADD CONSTRAINT rel_aterro_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_aterro_p
    ADD CONSTRAINT rel_aterro_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_corte_a
    ADD CONSTRAINT rel_corte_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_corte_l
    ADD CONSTRAINT rel_corte_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_corte_p
    ADD CONSTRAINT rel_corte_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_curva_batimetrica_l
    ADD CONSTRAINT rel_curva_batimetrica_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_curva_nivel_l
    ADD CONSTRAINT rel_curva_nivel_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_dolina_a
    ADD CONSTRAINT rel_dolina_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_dolina_p
    ADD CONSTRAINT rel_dolina_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_duna_a
    ADD CONSTRAINT rel_duna_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_duna_l
    ADD CONSTRAINT rel_duna_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_duna_p
    ADD CONSTRAINT rel_duna_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_elemento_fisiografico_natural_a
    ADD CONSTRAINT rel_elemento_fisiografico_natural_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_elemento_fisiografico_natural_l
    ADD CONSTRAINT rel_elemento_fisiografico_natural_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_elemento_fisiografico_natural_p
    ADD CONSTRAINT rel_elemento_fisiografico_natural_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_gruta_caverna_l
    ADD CONSTRAINT rel_gruta_caverna_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_gruta_caverna_p
    ADD CONSTRAINT rel_gruta_caverna_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_isolinha_hipsometrica_l
    ADD CONSTRAINT rel_isolinha_hipsometrica_l_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY rel_pico_p
    ADD CONSTRAINT rel_pico_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_ponto_cotado_altimetrico_p
    ADD CONSTRAINT rel_ponto_cotado_altimetrico_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_ponto_cotado_batimetrico_p
    ADD CONSTRAINT rel_ponto_cotado_batimetrico_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_ponto_hipsometrico_p
    ADD CONSTRAINT rel_ponto_hipsometrico_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY rel_rocha_a
    ADD CONSTRAINT rel_rocha_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_rocha_l
    ADD CONSTRAINT rel_rocha_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_rocha_p
    ADD CONSTRAINT rel_rocha_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rel_terreno_exposto_a
    ADD CONSTRAINT rel_terreno_exposto_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rod_trecho_rodoviario_a
    ADD CONSTRAINT rod_trecho_rodoviario_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rod_trecho_rodoviario_l
    ADD CONSTRAINT rod_trecho_rodoviario_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rod_via_deslocamento_a
    ADD CONSTRAINT rod_via_deslocamento_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY rod_via_deslocamento_l
    ADD CONSTRAINT rod_via_deslocamento_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY snb_barragem_calcadao_a
    ADD CONSTRAINT snb_barragem_calcadao_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY snb_dep_abast_agua_a
    ADD CONSTRAINT snb_dep_abast_agua_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY snb_dep_abast_agua_p
    ADD CONSTRAINT snb_dep_abast_agua_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY snb_dep_saneamento_a
    ADD CONSTRAINT snb_dep_saneamento_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY snb_dep_saneamento_p
    ADD CONSTRAINT snb_dep_saneamento_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_caminho_aereo_l
    ADD CONSTRAINT tra_caminho_aereo_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_caminho_carrocavel_l
    ADD CONSTRAINT tra_caminho_carrocavel_l_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY tra_entroncamento_pto_p
    ADD CONSTRAINT tra_entroncamento_pto_p_pk PRIMARY KEY (id) WITH (fillfactor='100')#
ALTER TABLE ONLY tra_funicular_l
    ADD CONSTRAINT tra_funicular_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_passagem_elevada_viaduto_a
    ADD CONSTRAINT tra_passagem_elevada_viaduto_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_passagem_elevada_viaduto_l
    ADD CONSTRAINT tra_passagem_elevada_viaduto_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_passagem_elevada_viaduto_p
    ADD CONSTRAINT tra_passagem_elevada_viaduto_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_passagem_nivel_p
    ADD CONSTRAINT tra_passagem_nivel_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_patio_a
    ADD CONSTRAINT tra_patio_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_obra_de_arte_viaria_p
    ADD CONSTRAINT tra_obra_de_arte_viaria_p_pk PRIMARY KEY (id)#
    ALTER TABLE ONLY tra_obra_de_arte_viaria_l
    ADD CONSTRAINT tra_obra_de_arte_viaria_l_pk PRIMARY KEY (id)#
    ALTER TABLE ONLY tra_obra_de_arte_viaria_a
    ADD CONSTRAINT tra_obra_de_arte_viaria_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_ponte_a
    ADD CONSTRAINT tra_ponte_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_ponte_l
    ADD CONSTRAINT tra_ponte_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_ponte_p
    ADD CONSTRAINT tra_ponte_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_travessia_l
    ADD CONSTRAINT tra_travessia_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_travessia_p
    ADD CONSTRAINT tra_travessia_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_travessia_pedestre_l
    ADD CONSTRAINT tra_travessia_pedestre_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_travessia_pedestre_p
    ADD CONSTRAINT tra_travessia_pedestre_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_travessia_pedrestre_a
    ADD CONSTRAINT tra_travessia_pedrestre_a_pk PRIMARY KEY (nome)#
ALTER TABLE ONLY tra_trilha_picada_l
    ADD CONSTRAINT tra_trilha_picada_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_tunel_a
    ADD CONSTRAINT tra_tunel_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_tunel_l
    ADD CONSTRAINT tra_tunel_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY tra_tunel_p
    ADD CONSTRAINT tra_tunel_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_brejo_pantano_a
    ADD CONSTRAINT veg_brejo_pantano_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_caatinga_a
    ADD CONSTRAINT veg_caatinga_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_campinarana_a
    ADD CONSTRAINT veg_campinarana_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_campo_a
    ADD CONSTRAINT veg_campo_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_cerrado_a
    ADD CONSTRAINT veg_cerrado_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_floresta_a
    ADD CONSTRAINT veg_floresta_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_mangue_a
    ADD CONSTRAINT veg_mangue_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_reflorestamento_a
    ADD CONSTRAINT veg_reflorestamento_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_veg_area_contato_a
    ADD CONSTRAINT veg_veg_area_contato_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_veg_cultivada_a
    ADD CONSTRAINT veg_veg_cultivada_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_veg_natural_a
    ADD CONSTRAINT veg_veg_natural_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_veg_restinga_a
    ADD CONSTRAINT veg_veg_restinga_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY veg_vegetacao_a
    ADD CONSTRAINT veg_vegetacao_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY ver_arvore_isolada_p
    ADD CONSTRAINT ver_arvore_isolada_p_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY ver_jardim_a
    ADD CONSTRAINT ver_jardim_a_pk PRIMARY KEY (id)#
SET search_path = public, pg_catalog#
ALTER TABLE ONLY aux_area_a
    ADD CONSTRAINT aux_area_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aux_descontinuidade_geometrica_l
    ADD CONSTRAINT aux_descontinuidade_geometrica_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aux_descontinuidade_geometrica_p
    ADD CONSTRAINT aux_descontinuidade_geometrica_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aux_linha_l
    ADD CONSTRAINT aux_linha_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aux_moldura_a
    ADD CONSTRAINT aux_moldura_a_pk PRIMARY KEY (id) WITH (fillfactor='10')#
ALTER TABLE ONLY aux_objeto_desconhecido_a
    ADD CONSTRAINT aux_objeto_desconhecido_a_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aux_objeto_desconhecido_l
    ADD CONSTRAINT aux_objeto_desconhecido_l_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aux_objeto_desconhecido_p
    ADD CONSTRAINT aux_objeto_desconhecido_p_pk PRIMARY KEY (id)#
ALTER TABLE ONLY aux_ponto_p
    ADD CONSTRAINT aux_ponto_p_pk PRIMARY KEY (id)#
SET search_path = edgv, public, pg_catalog#CREATE TABLE dominios.situacao_marco
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_marco_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.material_predominante
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT material_predominante_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_travessia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_travessia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_agropec
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_agropec_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_elem_nat
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_elem_nat_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_alter_antrop
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_alter_antrop_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_drenagem
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_drenagem_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_manguezal
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_manguezal_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_fundeadouro
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_fundeadouro_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_poste
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_poste_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.uso_pista
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT uso_pista_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.destinacao_cemiterio
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT destinacao_cemiterio_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_passag_viad
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_passag_viad_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_metro_ferrov
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_metro_ferrov_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.qualid_agua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT qualid_agua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.posicao_relativa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT posicao_relativa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.classificacao_porte
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT classificacao_porte_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.sistema_geodesico
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT sistema_geodesico_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.grupo_ativ_econ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT grupo_ativ_econ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_turist
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_turist_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_banco
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_banco_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_lavoura
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_lavoura_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_localidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_localidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.nivel_atencao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT nivel_atencao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.nr_linhas
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT nr_linhas_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.booleano
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT booleano_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_equip_desenv_social
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_equip_desenv_social_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_sum_vert
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_sum_vert_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.especie
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT especie_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.bitola
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT bitola_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_relig
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_relig_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_aglom_rur_isol
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_aglom_rur_isol_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_campo_quadra
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_campo_quadra_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_energia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_energia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_curva_nivel
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_curva_nivel_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_embarcacao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_embarcacao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_campo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_campo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pto_ref_geod_topo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pto_ref_geod_topo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pista_comp
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pista_comp_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pavimentacao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pavimentacao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ahe
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ahe_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_obst
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_obst_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.finalidade_cultura
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT finalidade_cultura_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_cemiterio
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_cemiterio_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_equip_agropec
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_equip_agropec_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.administracao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT administracao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.forma_rocha
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT forma_rocha_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_dep_geral
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_dep_geral_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ref
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ref_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_posto_fisc
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_posto_fisc_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.rede_referencia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT rede_referencia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.jurisdicao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT jurisdicao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_exposicao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_exposicao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ext_min
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ext_min_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.modal_uso
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT modal_uso_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_estrut
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_estrut_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.causa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT causa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.cultivo_predominante
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT cultivo_predominante_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_poco_mina
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_poco_mina_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.proximidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT proximidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_terreno_exposto
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_terreno_exposto_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_area
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_area_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_fisica
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_fisica_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_espacial
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_espacial_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_rep_diplomatica
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_rep_diplomatica_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.local_equip_desenv_social
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT local_equip_desenv_social_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.sigla_uf
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT sigla_uf_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_delim_fis
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_delim_fis_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.mat_constr
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT mat_constr_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_assentamento_precario
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_assentamento_precario_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.finalidade_patio
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT finalidade_patio_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.unidade_volume
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT unidade_volume_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_produto_residuo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_produto_residuo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_est_gerad
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_est_gerad_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_complexo_portuario
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_complexo_portuario_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_juridica
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_juridica_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_duto
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_duto_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_combustivel
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_combustivel_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_em_agua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_em_agua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.referencial_grav
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT referencial_grav_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_caminho_aereo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_caminho_aereo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_org_civil
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_org_civil_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_instal_militar
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_instal_militar_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_entroncamento
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_entroncamento_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_travessia_ped
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_travessia_ped_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.trafego
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT trafego_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_hierarquia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_hierarquia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_sinal
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_sinal_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.secao_ativ_econ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT secao_ativ_econ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.posicao_rel_edific
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT posicao_rel_edific_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_lazer
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_lazer_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.causa_exposicao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT causa_exposicao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.revestimento
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT revestimento_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_massa_dagua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_massa_dagua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_complexo_aeroportuario
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_complexo_aeroportuario_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.auxiliar
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT auxiliar_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.modalidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT modalidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_aero
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_aero_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.densidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT densidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_transporte
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_transporte_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.referencial_altim
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT referencial_altim_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_plataforma
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_plataforma_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_recife
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_recife_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_comunic
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_comunic_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_queda
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_queda_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ilha
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ilha_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.divisao_ativ_econ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT divisao_ativ_econ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_unid_protegida
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_unid_protegida_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.classificacao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT classificacao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.especie_trecho_energia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT especie_trecho_energia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_tunel
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_tunel_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_elevador
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_elevador_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.categoria
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT categoria_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pista
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pista_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.estado_fisico
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT estado_fisico_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_atracad
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_atracad_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.forma_extracao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT forma_extracao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_area_umida
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_area_umida_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_uso_edif
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_uso_edif_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.mat_transp
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT mat_transp_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_costa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_costa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_via
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_via_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_abast
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_abast_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.regime
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT regime_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.atividade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT atividade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_comerc_serv
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_comerc_serv_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_unid_prot_integ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_unid_prot_integ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.finalidade_deposito
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT finalidade_deposito_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_port
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_port_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ponte
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ponte_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_quebra_molhe
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_quebra_molhe_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.classe_ativ_econ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT classe_ativ_econ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_rod
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_rod_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.aptidao_operacional_atracadouro
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT aptidao_operacional_atracadouro_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pto_est_med
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pto_est_med_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_associado
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_associado_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_fonte_dagua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_fonte_dagua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.uso_principal
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT uso_principal_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_saneam
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_saneam_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_saneamento_basico
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_saneamento_basico_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_unid_uso_sust
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_unid_uso_sust_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_vegetacao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_vegetacao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_conteudo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_conteudo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.proc_extracao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT proc_extracao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_ferrov
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_ferrov_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.denominacao_associada
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT denominacao_associada_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.setor
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT setor_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_capital
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_capital_pk PRIMARY KEY (code)
                                )#
INSERT INTO dominios.situacao_marco (code,code_name) values (1,'Bom')#
INSERT INTO dominios.situacao_marco (code,code_name) values (3,'Destruído sem chapa')#
INSERT INTO dominios.situacao_marco (code,code_name) values (2,'Destruído')#
INSERT INTO dominios.situacao_marco (code,code_name) values (5,'Não encontrado')#
INSERT INTO dominios.situacao_marco (code,code_name) values (4,'Destruído com chapa danificada')#
INSERT INTO dominios.situacao_marco (code,code_name) values (7,'Não construído')#
INSERT INTO dominios.situacao_marco (code,code_name) values (6,'Não visitado')#
INSERT INTO dominios.situacao_marco (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.material_predominante (code,code_name) values (13,'Areia fina')#
INSERT INTO dominios.material_predominante (code,code_name) values (12,'Areia')#
INSERT INTO dominios.material_predominante (code,code_name) values (20,'Coral')#
INSERT INTO dominios.material_predominante (code,code_name) values (22,'Ervas marinhas')#
INSERT INTO dominios.material_predominante (code,code_name) values (17,'Concha')#
INSERT INTO dominios.material_predominante (code,code_name) values (19,'Lodo')#
INSERT INTO dominios.material_predominante (code,code_name) values (18,'Argila')#
INSERT INTO dominios.material_predominante (code,code_name) values (50,'Pedra')#
INSERT INTO dominios.material_predominante (code,code_name) values (99,'Outros')#
INSERT INTO dominios.material_predominante (code,code_name) values (98,'Misto')#
INSERT INTO dominios.material_predominante (code,code_name) values (4,'Rocha')#
INSERT INTO dominios.material_predominante (code,code_name) values (21,'Seixo')#
INSERT INTO dominios.material_predominante (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.material_predominante (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.material_predominante (code,code_name) values (14,'Lama')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (1,'Vau natural')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (3,'Bote transportador')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (2,'Vau construída')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (4,'Balsa')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (13,'Aviário')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (12,'Sede operacional de fazenda')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (15,'Viveiro de plantas')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (14,'Apiário')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (17,'Pocilga')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (16,'Viveiro para aquicultura')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (18,'Curral')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (4,'Administração')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (20,'Gruta')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (21,'Ilha')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (22,'Pico')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (23,'Rocha')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (1,'Serra')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (3,'Montanha')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (2,'Morro')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (5,'Maciço')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (4,'Chapada')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (7,'Planície')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (6,'Planalto')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (9,'Península')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (8,'Escarpa')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (11,'Cabo')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (10,'Ponta')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (13,'Falésia')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (12,'Praia')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (15,'Caverna')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (14,'Talude')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (17,'Duna')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (16,'Dolina')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (19,'Fenda')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (18,'Falha')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (24,'Caixa de empréstimo')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (26,'Corte')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (27,'Aterro')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (32,'Área de extração mineral')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (31,'Vala')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (30,'Canal')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (28,'Resíduo de bota-fora')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (29,'Resíduo sólido em geral')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_drenagem (code,code_name) values (5,'Pluvial')#
INSERT INTO dominios.tipo_trecho_drenagem (code,code_name) values (4,'Curso dágua')#
INSERT INTO dominios.tipo_manguezal (code,code_name) values (3,'Manguezal tipo apicum')#
INSERT INTO dominios.tipo_manguezal (code,code_name) values (2,'Manguezal')#
INSERT INTO dominios.tipo_manguezal (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_manguezal (code,code_name) values (4,'Manguezal tipo salgado')#
INSERT INTO dominios.tipo_fundeadouro (code,code_name) values (1,'Com limite definido')#
INSERT INTO dominios.tipo_fundeadouro (code,code_name) values (2,'Sem limite definido')#
INSERT INTO dominios.tipo_fundeadouro (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_poste (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_poste (code,code_name) values (3,'Ornamental')#
INSERT INTO dominios.tipo_poste (code,code_name) values (2,'Iluminação')#
INSERT INTO dominios.tipo_poste (code,code_name) values (5,'Sinalização')#
INSERT INTO dominios.tipo_poste (code,code_name) values (4,'Rede elétrica')#
INSERT INTO dominios.tipo_poste (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.uso_pista (code,code_name) values (11,'Público')#
INSERT INTO dominios.uso_pista (code,code_name) values (13,'Público compartilhado com uso militar')#
INSERT INTO dominios.uso_pista (code,code_name) values (12,'Militar')#
INSERT INTO dominios.uso_pista (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.uso_pista (code,code_name) values (6,'Particular')#
INSERT INTO dominios.destinacao_cemiterio (code,code_name) values (3,'Animais')#
INSERT INTO dominios.destinacao_cemiterio (code,code_name) values (2,'Humanos')#
INSERT INTO dominios.tipo_passag_viad (code,code_name) values (5,'Passagem elevada')#
INSERT INTO dominios.tipo_passag_viad (code,code_name) values (6,'Viaduto')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (15,'Administrativa')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (17,'Estação metroviária')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (16,'Estação ferroviária de passageiros')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (19,'Terminal ferroviário de passageiros e cargas')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (18,'Terminal ferroviário de cargas')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (20,'Oficina de manutenção')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.qualid_agua (code,code_name) values (1,'Potável')#
INSERT INTO dominios.qualid_agua (code,code_name) values (3,'Mineral')#
INSERT INTO dominios.qualid_agua (code,code_name) values (2,'Não potável')#
INSERT INTO dominios.qualid_agua (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.qualid_agua (code,code_name) values (4,'Salobra')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (3,'Elevada')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (2,'Superfície')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (5,'Submersa')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (4,'Emersa')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (6,'Subterrânea')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (98,'Mista')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (3,'Herbácea')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (2,'Rasteira')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (5,'Arbustiva')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (4,'Arbórea')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (1,'SAD-69')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (3,'WGS-84')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (2,'SIRGAS2000')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (5,'Astro Chuá')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (4,'Córrego Alegre')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (7,'SAD-69 (96)')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (6,'Outra referência')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (20,'Ensino superior')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (23,'Educação profissional e outras atividades de ensino')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (19,'Ensino médio')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (32,'Serviço social')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (31,'Serviços veterinários ')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (30,'Atividades de atenção à saúde')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (99,'Outros')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (98,'Misto')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (16,'Educação infantil e ensino fundamental')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (8,'Serviços coletivos prestados pela administração')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (6,'Administração do estado e da política econômica e social')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (15,'Seguridade social')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (11,'Mirante')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (10,'Estátua')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (13,'Panteão')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (12,'Monumento')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (15,'Chaminé')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (14,'Chafariz')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (17,'Obelisco')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (16,'Escultura')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (19,'Administração')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (18,'Torre')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (9,'Cruzeiro')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_banco (code,code_name) values (1,'Fluvial')#
INSERT INTO dominios.tipo_banco (code,code_name) values (3,'Lacustre')#
INSERT INTO dominios.tipo_banco (code,code_name) values (2,'Marítimo')#
INSERT INTO dominios.tipo_banco (code,code_name) values (4,'Cordão arenoso')#
INSERT INTO dominios.tipo_lavoura (code,code_name) values (1,'Perene')#
INSERT INTO dominios.tipo_lavoura (code,code_name) values (3,'Anual')#
INSERT INTO dominios.tipo_lavoura (code,code_name) values (2,'Semi-perene')#
INSERT INTO dominios.tipo_lavoura (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (1,'Aglomerado rural')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (3,'Aglomerado rural isolado')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (2,'Aglomerado rural de extensão urbana')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (5,'Cidade')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (4,'Capital')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (6,'Vila')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.nivel_atencao (code,code_name) values (5,'Primário')#
INSERT INTO dominios.nivel_atencao (code,code_name) values (7,'Terciário')#
INSERT INTO dominios.nivel_atencao (code,code_name) values (6,'Secundário')#
INSERT INTO dominios.nr_linhas (code,code_name) values (1,'Simples')#
INSERT INTO dominios.nr_linhas (code,code_name) values (3,'Múltipla')#
INSERT INTO dominios.nr_linhas (code,code_name) values (2,'Dupla')#
INSERT INTO dominios.nr_linhas (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.booleano (code,code_name) values (1,'Sim')#
INSERT INTO dominios.booleano (code,code_name) values (0,'Não')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (20,'Unidade de acolhimento para mulheres vitmas de violência')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (21,'Unidade de acolhimento para pessoas em situação de rua')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (1,'Banco de Alimentos')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (3,'Bolsa Verde')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (2,'Barragem Calçadão')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (5,'Centro POP')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (4,'Centro de Convivência')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (7,'Cisterna Subterrânea')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (6,'Centro-dia')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (9,'Cisterna de Placa')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (8,'Cisterna de Polietileno')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (11,'CRAS')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (10,'Cozinha Comunitária')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (13,'PAA')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (12,'CREAS')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (15,'PRONATEC')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (14,'PRONAF')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (17,'Unidade de acolhimento para crianças e adolescentes')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (16,'Restaurante Popular')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (19,'Unidade de acolhimento para idosos')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (18,'Unidade de acolhimento para crianças e adolescentes (casa de passagem)')#
INSERT INTO dominios.tipo_sum_vert (code,code_name) values (1,'Sumidouro')#
INSERT INTO dominios.tipo_sum_vert (code,code_name) values (2,'Vertedouro')#
INSERT INTO dominios.especie (code,code_name) values (11,'Bambu')#
INSERT INTO dominios.especie (code,code_name) values (10,'Cipó')#
INSERT INTO dominios.especie (code,code_name) values (17,'Palmeira')#
INSERT INTO dominios.especie (code,code_name) values (37,'Sem predominância')#
INSERT INTO dominios.especie (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.especie (code,code_name) values (96,'Não identificado')#
INSERT INTO dominios.bitola (code,code_name) values (3,'Internacional')#
INSERT INTO dominios.bitola (code,code_name) values (2,'Métrica')#
INSERT INTO dominios.bitola (code,code_name) values (5,'Mista métrica internacional')#
INSERT INTO dominios.bitola (code,code_name) values (4,'Larga')#
INSERT INTO dominios.bitola (code,code_name) values (7,'Mista internacional larga')#
INSERT INTO dominios.bitola (code,code_name) values (6,'Mista métrica  larga')#
INSERT INTO dominios.bitola (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (10,'Administração')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (1,'Igreja')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (3,'Centro')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (2,'Templo')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (5,'Convento')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (4,'Mosteiro')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (7,'Sinagoga')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (6,'Mesquita')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (9,'Capela mortuária')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (8,'Terreiro ')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_aglom_rur_isol (code,code_name) values (5,'Povoado')#
INSERT INTO dominios.tipo_aglom_rur_isol (code,code_name) values (7,'Outros aglomerados rurais isolados')#
INSERT INTO dominios.tipo_aglom_rur_isol (code,code_name) values (6,'Núcleo')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (1,'Futebol')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (3,'Voleibol')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (2,'Basquetebol')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (5,'Hipismo')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (4,'Pólo')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (7,'Tênis')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (6,'Poliesportiva')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (1,'Administração')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (3,'Segurança')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (2,'Oficinas')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (5,'Chaminé')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (4,'Depósito')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_curva_nivel (code,code_name) values (1,'Mestra')#
INSERT INTO dominios.tipo_curva_nivel (code,code_name) values (3,'Auxiliar')#
INSERT INTO dominios.tipo_curva_nivel (code,code_name) values (2,'Normal')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (3,'Lancha')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (2,'Balsa')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (7,'Embarcação de pequeno porte')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (6,'Empurrador-balsa')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_campo (code,code_name) values (1,'Sujo')#
INSERT INTO dominios.tipo_campo (code,code_name) values (3,'Rupestre')#
INSERT INTO dominios.tipo_campo (code,code_name) values (2,'Limpo')#
INSERT INTO dominios.tipo_campo (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (1,'Vértice de triangulação - VT')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (3,'Estação gravimétrica - EG')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (2,'Referência de nível - RN')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (5,'Ponto astronômico - PA')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (4,'Estação de poligonal - EP')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (7,'Ponto trigonométrico - RV')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (6,'Ponto barométrico - B')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (8,'Ponto de satélite - SAT')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (1,'Atletismo')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (3,'Motociclismo')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (5,'Corrida de cavalos')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (4,'Automobilismo')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (7,'Ciclismo')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (6,'Bicicross')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (8,'Motocross')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (3,'Placa de concreto')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (2,'Asfalto')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (5,'Ladrilho de concreto')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (4,'Pedra regular')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (7,'Pedra irregular')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (6,'Paralelepípedo')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_ahe (code,code_name) values (1,'UHE')#
INSERT INTO dominios.tipo_ahe (code,code_name) values (3,'CGH')#
INSERT INTO dominios.tipo_ahe (code,code_name) values (2,'PCH')#
INSERT INTO dominios.tipo_obst (code,code_name) values (5,'Artificial')#
INSERT INTO dominios.tipo_obst (code,code_name) values (4,'Natural')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (99,'Outros')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (1,'Exploração econômica')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (3,'Conservação ambiental')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (2,'Subsistência')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (4,'Ornamental')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (1,'Crematório')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (3,'Vertical')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (2,'Parque')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (5,'Túmulo isolado')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (4,'Comum')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (6,'Horizontal/vertical')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (1,'Pivô central')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (3,'Elevador de grãos')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (2,'Moinho')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (5,'Secador')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (4,'Moega')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (6,'Tombador')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.administracao (code,code_name) values (3,'Estadual/Distrital')#
INSERT INTO dominios.administracao (code,code_name) values (2,'Federal')#
INSERT INTO dominios.administracao (code,code_name) values (5,'Concessionada')#
INSERT INTO dominios.administracao (code,code_name) values (4,'Municipal')#
INSERT INTO dominios.administracao (code,code_name) values (6,'Privada')#
INSERT INTO dominios.administracao (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.administracao (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.forma_rocha (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.forma_rocha (code,code_name) values (21,'Matacão - pedra')#
INSERT INTO dominios.forma_rocha (code,code_name) values (22,'Penedo isolado')#
INSERT INTO dominios.forma_rocha (code,code_name) values (23,'Área rochosa - lajedo')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (11,'Depósito frigorífico')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (10,'Composteira')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (26,'Barracão industrial')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (19,'Reservatório')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (32,'Armazém')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (3,'Cisterna')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (2,'Caixa d''água')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (5,'Aterro sanitário')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (4,'Depósito de lixo')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (6,'Aterro controlado')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (9,'Silo')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (8,'Galpão')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (1,'Tanque')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_ref (code,code_name) values (1,'Altimétrico')#
INSERT INTO dominios.tipo_ref (code,code_name) values (3,'Planialtimétrico')#
INSERT INTO dominios.tipo_ref (code,code_name) values (2,'Planimétrico')#
INSERT INTO dominios.tipo_ref (code,code_name) values (4,'Gravimétrico')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (10,'Tributação')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (13,'Posto de pesagem')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (12,'Fiscalização sanitária')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.rede_referencia (code,code_name) values (15,'Privada')#
INSERT INTO dominios.rede_referencia (code,code_name) values (3,'Municipal')#
INSERT INTO dominios.rede_referencia (code,code_name) values (2,'Estadual')#
INSERT INTO dominios.rede_referencia (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.rede_referencia (code,code_name) values (14,'Nacional')#
INSERT INTO dominios.jurisdicao (code,code_name) values (1,'Federal')#
INSERT INTO dominios.jurisdicao (code,code_name) values (3,'Municipal')#
INSERT INTO dominios.jurisdicao (code,code_name) values (2,'Estadual/Distrital')#
INSERT INTO dominios.jurisdicao (code,code_name) values (4,'Internacional')#
INSERT INTO dominios.jurisdicao (code,code_name) values (8,'Propriedade particular')#
INSERT INTO dominios.jurisdicao (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (3,'Fechado')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (5,'Céu aberto')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (4,'Coberto')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (1,'Poço para água subterrânea')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (5,'Garimpo')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (4,'Mina')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (6,'Salina')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (8,'Poço de petróleo')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.modal_uso (code,code_name) values (10,'Hidroviário')#
INSERT INTO dominios.modal_uso (code,code_name) values (14,'Portuário')#
INSERT INTO dominios.modal_uso (code,code_name) values (5,'Ferroviário')#
INSERT INTO dominios.modal_uso (code,code_name) values (4,'Rodoviário')#
INSERT INTO dominios.modal_uso (code,code_name) values (7,'Dutos')#
INSERT INTO dominios.modal_uso (code,code_name) values (6,'Metroviário')#
INSERT INTO dominios.modal_uso (code,code_name) values (9,'Aeroportuário')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (1,'Estação')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (3,'Fiscalização')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (2,'Comércio e serviços')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (5,'Terminal')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (4,'Porto seco')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (9,'Parada')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (8,'Integração')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.causa (code,code_name) values (5,'Canalização')#
INSERT INTO dominios.causa (code,code_name) values (2,'Absorção')#
INSERT INTO dominios.causa (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.causa (code,code_name) values (4,'Gruta ou fenda')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (24,'Pastagem cultivada')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (25,'Hortaliças')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (26,'Bracatinga')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (27,'Araucária')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (20,'Eucalipto')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (21,'Acácia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (22,'Algaroba')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (23,'Pinus')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (28,'Carnaúba')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (29,'Pera')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (4,'Trigo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (8,'Fumo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (59,'Caqui')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (58,'Caju')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (55,'Azeitona')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (54,'Aveia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (57,'Batata-doce')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (56,'Azevem')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (51,'Ameixa')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (50,'Alho')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (53,'Amora')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (52,'Amendoim')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (115,'Tungue')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (114,'Triticale')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (117,'Gergelim')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (89,'Melão')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (111,'Sorgo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (110,'Sisal ou agave')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (113,'Tomate')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (112,'Tangerina')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (82,'Malva')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (83,'Mamão')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (80,'Limão')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (81,'Linho')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (119,'Lima')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (118,'Pupunha')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (84,'Mamona')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (85,'Manga')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (3,'Laranja')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (7,'Cana de açúcar')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (108,'Rami')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (102,'Palmito')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (103,'Pepino')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (100,'Nabo forrageiro')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (101,'Noz')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (106,'Plantas ornamentais')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (104,'Piaçava')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (105,'Pimenta do reino')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (33,'Cebola')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (32,'Juta')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (31,'Pêssego')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (30,'Maçã')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (60,'Carambola')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (61,'Centeio')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (62,'Cevada')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (63,'Chá-da-índia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (64,'Cidra')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (65,'Coco-da-baía')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (66,'Cravo da índia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (67,'Cupuaçu')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (68,'Dendê')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (69,'Ervilha')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (2,'Banana')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (6,'Algodão herbáceo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (99,'Outros')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (90,'Milheto')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (96,'Não identificado')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (11,'Mandioca, aipim ou macaxeira')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (10,'Batata inglesa')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (13,'Arroz')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (12,'Feijão')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (15,'Cacau')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (14,'Café')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (17,'Palmeira')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (16,'Erva-mate')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (19,'Seringueira')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (18,'Açaí')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (88,'Melancia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (116,'Urucum')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (48,'Alfafa')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (49,'Algodão arbóreo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (46,'Acerola')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (86,'Maracujá')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (44,'Abacaxi ou ananás')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (45,'Abóbora')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (42,'Uva')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (43,'Abacate')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (87,'Marmelo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (1,'Milho')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (9,'Soja')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (77,'Inhame')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (76,'Guaraná')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (75,'Grão-de-Bico')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (74,'Goiaba')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (73,'Girassol')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (72,'Flores')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (71,'Figo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (70,'Fava')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (79,'Lentilha')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (78,'Kiwi')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (47,'Alcachofra')#
INSERT INTO dominios.tipo_poco_mina (code,code_name) values (3,'Vertical')#
INSERT INTO dominios.tipo_poco_mina (code,code_name) values (2,'Horizontal')#
INSERT INTO dominios.tipo_poco_mina (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_poco_mina (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.proximidade (code,code_name) values (15,'Adjacente')#
INSERT INTO dominios.proximidade (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.proximidade (code,code_name) values (14,'Isolada')#
INSERT INTO dominios.proximidade (code,code_name) values (16,'Coincidente')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (24,'Saibro')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (12,'Areia')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (23,'Terra')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (18,'Cascalho')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (4,'Pedregoso')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_area (code,code_name) values (11,'Área relacionada a equipamentos de desenvolvimento social')#
INSERT INTO dominios.tipo_area (code,code_name) values (10,'Área relacionada a energia eletrica')#
INSERT INTO dominios.tipo_area (code,code_name) values (13,'Área relacionada ao extrativismo mineral')#
INSERT INTO dominios.tipo_area (code,code_name) values (12,'Área relacionada a estação de medição de fenômenos')#
INSERT INTO dominios.tipo_area (code,code_name) values (15,'Área relacionada a instalação de comunicações')#
INSERT INTO dominios.tipo_area (code,code_name) values (14,'Área relacionada a instalação de abastecimento de água')#
INSERT INTO dominios.tipo_area (code,code_name) values (17,'Área relacionada a instalação de saneamento')#
INSERT INTO dominios.tipo_area (code,code_name) values (16,'Área relacionada a instalação de estrutura de transporte')#
INSERT INTO dominios.tipo_area (code,code_name) values (19,'Área relacionada a ruinas de valor histórico')#
INSERT INTO dominios.tipo_area (code,code_name) values (18,'Área relacionada ao lazer')#
INSERT INTO dominios.tipo_area (code,code_name) values (1,'Área de propriedade particular')#
INSERT INTO dominios.tipo_area (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_area (code,code_name) values (3,'Área relacionada a dutos')#
INSERT INTO dominios.tipo_area (code,code_name) values (2,'Área habitacional')#
INSERT INTO dominios.tipo_area (code,code_name) values (5,'Área relacionada a edificação de comércio ou serviços')#
INSERT INTO dominios.tipo_area (code,code_name) values (4,'Área relacionada a edificação agropecuária ou extrativismo vegetal ou pesca')#
INSERT INTO dominios.tipo_area (code,code_name) values (7,'Área relacionada a edificação de saúde')#
INSERT INTO dominios.tipo_area (code,code_name) values (6,'Área relacionada a edificação de ensino')#
INSERT INTO dominios.tipo_area (code,code_name) values (9,'Área relacionada a edificação religiosa')#
INSERT INTO dominios.tipo_area (code,code_name) values (8,'Área relacionada a edificação industrual')#
INSERT INTO dominios.tipo_area (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (1,'Abandonada')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (3,'Em construção')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (2,'Destruída')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (5,'Construída')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (4,'Planejada')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (7,'Construída')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (6,'Construída, mas em obras')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (13,'Superposta nivel 1')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (12,'Adjacente')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (99,'Outra')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (2,'Subterrânea')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (5,'Nivel do solo')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (4,'Superposta nivel 2')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (7,'Superposta nivel 3')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_rep_diplomatica (code,code_name) values (3,'Consulado')#
INSERT INTO dominios.tipo_rep_diplomatica (code,code_name) values (2,'Embaixada')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (1,'Terras Indígena')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (3,'Terras Quilombola')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (2,'Terras de População Ribeirinha')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (5,'Urbano central')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (4,'Rural')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (7,'Outras Comunidades tradicionais')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (6,'Urbana periférica')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.sigla_uf (code,code_name) values (24,'SC')#
INSERT INTO dominios.sigla_uf (code,code_name) values (25,'SE')#
INSERT INTO dominios.sigla_uf (code,code_name) values (26,'SP')#
INSERT INTO dominios.sigla_uf (code,code_name) values (27,'TO')#
INSERT INTO dominios.sigla_uf (code,code_name) values (20,'RN')#
INSERT INTO dominios.sigla_uf (code,code_name) values (21,'RO')#
INSERT INTO dominios.sigla_uf (code,code_name) values (22,'RR')#
INSERT INTO dominios.sigla_uf (code,code_name) values (23,'RS')#
INSERT INTO dominios.sigla_uf (code,code_name) values (1,'AC')#
INSERT INTO dominios.sigla_uf (code,code_name) values (3,'AM')#
INSERT INTO dominios.sigla_uf (code,code_name) values (2,'AL')#
INSERT INTO dominios.sigla_uf (code,code_name) values (5,'BA')#
INSERT INTO dominios.sigla_uf (code,code_name) values (4,'AP')#
INSERT INTO dominios.sigla_uf (code,code_name) values (7,'DF')#
INSERT INTO dominios.sigla_uf (code,code_name) values (6,'CE')#
INSERT INTO dominios.sigla_uf (code,code_name) values (9,'GO')#
INSERT INTO dominios.sigla_uf (code,code_name) values (8,'ES')#
INSERT INTO dominios.sigla_uf (code,code_name) values (11,'MG')#
INSERT INTO dominios.sigla_uf (code,code_name) values (10,'MA')#
INSERT INTO dominios.sigla_uf (code,code_name) values (13,'MT')#
INSERT INTO dominios.sigla_uf (code,code_name) values (12,'MS')#
INSERT INTO dominios.sigla_uf (code,code_name) values (15,'PB')#
INSERT INTO dominios.sigla_uf (code,code_name) values (14,'PA')#
INSERT INTO dominios.sigla_uf (code,code_name) values (17,'PI')#
INSERT INTO dominios.sigla_uf (code,code_name) values (16,'PE')#
INSERT INTO dominios.sigla_uf (code,code_name) values (19,'RJ')#
INSERT INTO dominios.sigla_uf (code,code_name) values (18,'PR')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (1,'Cerca')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (3,'Mureta')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (2,'Muro')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (4,'Gradil')#
INSERT INTO dominios.mat_constr (code,code_name) values (99,'Outros')#
INSERT INTO dominios.mat_constr (code,code_name) values (23,'Terra')#
INSERT INTO dominios.mat_constr (code,code_name) values (1,'Alvenaria')#
INSERT INTO dominios.mat_constr (code,code_name) values (3,'Metal')#
INSERT INTO dominios.mat_constr (code,code_name) values (2,'Concreto')#
INSERT INTO dominios.mat_constr (code,code_name) values (5,'Madeira')#
INSERT INTO dominios.mat_constr (code,code_name) values (4,'Rocha')#
INSERT INTO dominios.mat_constr (code,code_name) values (8,'Fibra')#
INSERT INTO dominios.mat_constr (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.mat_constr (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (1,'Cortiço')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (3,'Favela')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (2,'Conjunto habitacional degradado')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (5,'Mocambos')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (4,'Loteamento irregular da periferia')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (6,'Palafitas')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (99,'Outros')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (3,'Estacionamento de veículos ')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (2,'Deposito temporário de cargas e contêineres')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (5,'Estacionamento de aeronaves')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (4,'Estacionamento de locomotivas')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (7,'Manobra de veículos em geral')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (6,'Manobra de cargas')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (8,'Manutenção')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.unidade_volume (code,code_name) values (1,'Litro')#
INSERT INTO dominios.unidade_volume (code,code_name) values (2,'Metro cúbico')#
INSERT INTO dominios.unidade_volume (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (56,'Carvão vegetal')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (53,'Barita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (42,'Areia')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (22,'Pedra (brita)')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (43,'Saibro/piçarra')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (60,'Citrino')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (61,'Crisoberilo')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (62,'Cristal de rocha')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (63,'Cromo')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (64,'Diatomita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (65,'Dolomito')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (66,'Esgoto')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (67,'Esmeralda')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (68,'Estanho')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (69,'Feldspato')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (80,'Nióbio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (81,'Níquel')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (86,'Titânio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (87,'Topázio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (84,'Sal-gema')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (85,'Terras raras')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (24,'Mármore')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (25,'Bauxita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (26,'Manganês')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (27,'Talco')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (20,'Inseticida')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (21,'Folhagens')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (48,'Água mineral')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (23,'Granito')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (46,'Água')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (47,'Água marinha')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (82,'Opala')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (45,'Ágata')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (28,'Óleo diesel')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (29,'Gasolina')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (40,'Pedra preciosa')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (41,'Forragem')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (3,'Petróleo')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (5,'Gás')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (36,'Escória')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (6,'Grãos')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (18,'Cascalho')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (49,'Alexandrita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (83,'Rocha ornamental')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (34,'Sal')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (77,'Lixo tóxico')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (76,'Lixo séptico')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (75,'Lixo domiciliar e comercial')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (74,'Lítio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (73,'Granada')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (72,'Grafita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (71,'Gipsita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (70,'Fosfato')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (91,'Turmalina')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (90,'Turfa')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (100,'Zircônio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (92,'Urânio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (94,'Zinco')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (79,'Mica')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (78,'Magnesita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (39,'Prata')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (38,'Diamante')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (59,'Chumbo')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (58,'Chorume')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (17,'Estrume')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (16,'Vinhoto')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (33,'Carvão mineral')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (32,'Cobre')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (57,'Caulim')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (30,'Álcool')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (51,'Amianto')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (93,'Vermiculita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (35,'Ferro')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (52,'Argila')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (55,'Calcário')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (89,'Tungstênio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (37,'Ouro')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (88,'Tório')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (54,'Bentonita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (31,'Querosene')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (50,'Ametista')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (5,'Eólica')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (7,'Maré-motriz')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (6,'Solar')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (9,'Termelétrica')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (8,'Hidrelétrica')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_complexo_portuario (code,code_name) values (31,'Porto organizado')#
INSERT INTO dominios.tipo_complexo_portuario (code,code_name) values (30,'Instalação portuária')#
INSERT INTO dominios.tipo_complexo_portuario (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_juridica (code,code_name) values (1,'Delimitada')#
INSERT INTO dominios.situacao_juridica (code,code_name) values (3,'Homologada ou demarcada')#
INSERT INTO dominios.situacao_juridica (code,code_name) values (2,'Declarada')#
INSERT INTO dominios.situacao_juridica (code,code_name) values (4,'Regularizada')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (1,'Duto')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (3,'Correia transportadora')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (2,'Calha')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (5,'Galeria')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (4,'Bueiro')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (1,'Nuclear')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (33,'Carvão')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (3,'Diesel')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (5,'Gás')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_em_agua (code,code_name) values (5,'Submerso')#
INSERT INTO dominios.situacao_em_agua (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_em_agua (code,code_name) values (4,'Emerso')#
INSERT INTO dominios.situacao_em_agua (code,code_name) values (7,'Cobre e descobre')#
INSERT INTO dominios.referencial_grav (code,code_name) values (1,'Potsdam1930')#
INSERT INTO dominios.referencial_grav (code,code_name) values (3,'Absoluto')#
INSERT INTO dominios.referencial_grav (code,code_name) values (2,'IGSN71')#
INSERT INTO dominios.referencial_grav (code,code_name) values (5,'RGFB')#
INSERT INTO dominios.referencial_grav (code,code_name) values (4,'Local')#
INSERT INTO dominios.referencial_grav (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.referencial_grav (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_caminho_aereo (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_caminho_aereo (code,code_name) values (12,'Teleférico')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (11,'Delegacia de policia civil')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (10,'Autarquia')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (13,'Fórum')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (12,'Educação')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (15,'Procuradoria')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (14,'Fundação')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (22,'Prefeitura')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (16,'Secretaria')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (3,'Cartorial')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (2,'Prisional')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (5,'Eleitoral')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (4,'Gestão')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (7,'Seguridade social')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (6,'Produção e/ou pesquisa')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (9,'Assembleia legislativa')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (8,'Câmara municipal')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (1,'Policial')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (11,'Delegacia de  serviço militar')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (10,'Hotel de trânsito')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (13,'Posto de vigilância')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (12,'Quartel general')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (15,'Posto de policiamento rodoviário')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (14,'Posto de policiamento urbano')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (17,'Base naval')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (16,'Capitânia dos portos')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (5,'Aquartelamento')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (7,'Campo de tiro')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (6,'Campo de instruçao')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (9,'Distrito naval')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (8,'Base aérea')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (99,'Outros tipos de entroncamento em nivel')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (1,'Cruzamento ou injunções simples')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (3,'Trevo')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (2,'Círculo ')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (5,'Entroncamento ferroviário')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (4,'Rótula')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (9,'Pinguela')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (8,'Passarela')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (7,'Passagem subterrânea')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (10,'Passarela em Área Úmida')#
INSERT INTO dominios.trafego (code,code_name) values (1,'Permanente')#
INSERT INTO dominios.trafego (code,code_name) values (2,'Periódico')#
INSERT INTO dominios.trafego (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.trafego (code,code_name) values (4,'Temporário')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (24,'Internacional secundário')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (25,'Internacional de referência')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (26,'Internacional principal')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (23,'Estadual')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (3,'Municipal')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (1,'Bóia luminosa')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (3,'Bóia de amarração')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (2,'Bóia cega')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (5,'Barca farol')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (4,'Farol ou farolete')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (6,'Sinalização de margem')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (1,'Indústrias extrativas')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (99,'Outros')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (3,'Construção')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (2,'Indústrias de transformação')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.posicao_rel_edific (code,code_name) values (18,'Sobre edificação')#
INSERT INTO dominios.posicao_rel_edific (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.posicao_rel_edific (code,code_name) values (14,'Isolada')#
INSERT INTO dominios.posicao_rel_edific (code,code_name) values (17,'Adjacente à edificação')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (21,'Quiosque')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (22,'Administração')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (1,'Estádio')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (3,'Museu')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (2,'Ginásio')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (5,'Anfiteatro')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (4,'Teatro')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (7,'Centro cultural')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (6,'Espaço de exibição de filmes')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (9,'Arquivo')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (8,'Plataforma de pesca')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (11,'Centro de documentação')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (10,'Biblioteca')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (13,'Concha acústica')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (12,'Circo')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (15,'Coreto ou tribuna')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (14,'Conservatório')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (17,'Equipamentos culturais diversos')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (19,'Galeria')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (18,'Espaço de eventos e/ ou cultural')#
INSERT INTO dominios.causa_exposicao (code,code_name) values (3,'Artificial')#
INSERT INTO dominios.causa_exposicao (code,code_name) values (2,'Natural')#
INSERT INTO dominios.causa_exposicao (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.revestimento (code,code_name) values (1,'Sem revestimento (leito natural)')#
INSERT INTO dominios.revestimento (code,code_name) values (99,'Outros')#
INSERT INTO dominios.revestimento (code,code_name) values (3,'Pavimentado')#
INSERT INTO dominios.revestimento (code,code_name) values (2,'Revestimento primário (solto)')#
INSERT INTO dominios.revestimento (code,code_name) values (4,'Madeira')#
INSERT INTO dominios.revestimento (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (10,'Represa/açude')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (1,'Rio')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (3,'Oceano')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (5,'Enseada')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (4,'Baía')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (7,'Lago/Lagoa')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (6,'Meandro abandonado')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (9,'Laguna')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_complexo_aeroportuario (code,code_name) values (24,'Aeroporto')#
INSERT INTO dominios.tipo_complexo_aeroportuario (code,code_name) values (25,'Heliporto')#
INSERT INTO dominios.tipo_complexo_aeroportuario (code,code_name) values (23,'Aeródromo')#
INSERT INTO dominios.auxiliar (code,code_name) values (1,'Sim')#
INSERT INTO dominios.auxiliar (code,code_name) values (0,'Não')#
INSERT INTO dominios.auxiliar (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.modalidade (code,code_name) values (99,'Outros')#
INSERT INTO dominios.modalidade (code,code_name) values (1,'Radiocomunicação')#
INSERT INTO dominios.modalidade (code,code_name) values (3,'Telefonia')#
INSERT INTO dominios.modalidade (code,code_name) values (2,'Imagem')#
INSERT INTO dominios.modalidade (code,code_name) values (5,'Som')#
INSERT INTO dominios.modalidade (code,code_name) values (4,'Dados')#
INSERT INTO dominios.modalidade (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (26,'Terminal de passageiros')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (27,'Terminal de cargas')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (15,'Administrativa')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (28,'Torre de controle')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (29,'Hangar')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.densidade (code,code_name) values (1,'Alta')#
INSERT INTO dominios.densidade (code,code_name) values (2,'Baixa')#
INSERT INTO dominios.densidade (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_transporte (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_transporte (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_transporte (code,code_name) values (21,'Passageiro')#
INSERT INTO dominios.tipo_transporte (code,code_name) values (22,'Carga')#
INSERT INTO dominios.referencial_altim (code,code_name) values (99,'Outra referência')#
INSERT INTO dominios.referencial_altim (code,code_name) values (1,'Torres')#
INSERT INTO dominios.referencial_altim (code,code_name) values (3,'Santana')#
INSERT INTO dominios.referencial_altim (code,code_name) values (2,'Imbituba')#
INSERT INTO dominios.tipo_plataforma (code,code_name) values (5,'Gás')#
INSERT INTO dominios.tipo_plataforma (code,code_name) values (3,'Petróleo')#
INSERT INTO dominios.tipo_plataforma (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_plataforma (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_recife (code,code_name) values (1,'Arenito')#
INSERT INTO dominios.tipo_recife (code,code_name) values (20,'Coral')#
INSERT INTO dominios.tipo_recife (code,code_name) values (2,'Rochoso')#
INSERT INTO dominios.tipo_recife (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (3,'Sinal de TV')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (4,'Dados')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (7,'Telefônica')#
INSERT INTO dominios.tipo_queda (code,code_name) values (1,'Cachoeira')#
INSERT INTO dominios.tipo_queda (code,code_name) values (3,'Catarata')#
INSERT INTO dominios.tipo_queda (code,code_name) values (2,'Salto')#
INSERT INTO dominios.tipo_queda (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_ilha (code,code_name) values (1,'Fluvial')#
INSERT INTO dominios.tipo_ilha (code,code_name) values (3,'Lacustre')#
INSERT INTO dominios.tipo_ilha (code,code_name) values (2,'Marítima')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (37,'Reciclagem')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (50,'Comércio e reparação de veiculos automotores e motocicletas e comércio a varejo de combustíveis')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (52,'Comércio varejista e reparação de objetos pessoais e domésticos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (24,'Fabricação de produtos químicos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (25,'Fabricação de artigos de borracha e material plástico')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (27,'Metalurgia básica')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (20,'Fabricação de produtos de madeira e celulose')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (21,'Fabricação de celulose, papel e produtos de papel')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (22,'Edição, impressão e reprodução de gravações')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (23,'Fabricação de coque, refino de petróleo, elaboração de combustíveis nucleares e produção de álcool')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (45,'Construção')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (28,'Fabricação de produtos de metal, exclusive máquinas e equipamentos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (29,'Fabricação de máquinas e equipamentos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (1,'Agricultura, pecuário e serviços relacionados')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (2,'Silvicultura, exploração e serviços relacionados')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (5,'Pesca, agricultura e serviços relacionados')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (99,'Outros')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (74,'Serviços prestados principalmente a empresas (organizações)')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (92,'Atividades recreativas')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (11,'Extração de petróleo e serviços relacionados')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (10,'Extração de carvão mineral')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (13,'Extração de minerais metálicos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (15,'Fabricação alimentícia e bebidas')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (14,'Fabricação de produtos de minerais não metálicos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (17,'Fabricação de produtos têxteis')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (16,'Fabricação de produtos do fumo')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (19,'Preparação de couros e fabricação de artefatos de couro, artigos de viagens e calçados')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (18,'Confecção de artigos do vestuário e acessórios')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (31,'Fabricação de máquinas, aparelhos e materiais elétricos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (30,'Fabricação de máquinas de escritório e equipamentos de informática')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (51,'Comércio por atacado e representantes comerciais e agentes do comércio')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (36,'Fabricação de móveis e indústrias diversas')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (35,'Fabricação de outros equipamentos de transporte')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (34,'Fabricação e montagem de veículos automotores, reboques e carrocerias')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (55,'Alojamento e alimentação')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (32,'Fabricação de material eletrônico, e equipamentos de comunicações')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (33,'Fabricação de equipamentos de instrumentação médico-hospitalares, instrumentos de precisão e ópticos, equipamentos para automação industrial, cronômetro e relógios')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (1,'Unidade de conservação não SNUC')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (3,'Unidade de uso sustentável')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (2,'Unidade de proteção integral')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (5,'Outras unidades protegidas')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (4,'Unidade de conservação')#
INSERT INTO dominios.classificacao (code,code_name) values (3,'Internacional')#
INSERT INTO dominios.classificacao (code,code_name) values (2,'Doméstico')#
INSERT INTO dominios.classificacao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.especie_trecho_energia (code,code_name) values (3,'Transmissão')#
INSERT INTO dominios.especie_trecho_energia (code,code_name) values (2,'Distribuição')#
INSERT INTO dominios.especie_trecho_energia (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_tunel (code,code_name) values (1,'Túnel')#
INSERT INTO dominios.tipo_tunel (code,code_name) values (2,'Passagem subterrânea')#
INSERT INTO dominios.tipo_elevador (code,code_name) values (3,'Vertical')#
INSERT INTO dominios.tipo_elevador (code,code_name) values (2,'Inclinado')#
INSERT INTO dominios.categoria (code,code_name) values (11,'HID')#
INSERT INTO dominios.categoria (code,code_name) values (10,'HDV')#
INSERT INTO dominios.categoria (code,code_name) values (13,'LML')#
INSERT INTO dominios.categoria (code,code_name) values (12,'LAZ')#
INSERT INTO dominios.categoria (code,code_name) values (15,'REL')#
INSERT INTO dominios.categoria (code,code_name) values (14,'PTO')#
INSERT INTO dominios.categoria (code,code_name) values (17,'SNB')#
INSERT INTO dominios.categoria (code,code_name) values (16,'ROD')#
INSERT INTO dominios.categoria (code,code_name) values (19,'VEG')#
INSERT INTO dominios.categoria (code,code_name) values (18,'TRA')#
INSERT INTO dominios.categoria (code,code_name) values (1,'AER')#
INSERT INTO dominios.categoria (code,code_name) values (3,'DUT')#
INSERT INTO dominios.categoria (code,code_name) values (2,'CBGE')#
INSERT INTO dominios.categoria (code,code_name) values (5,'ECO')#
INSERT INTO dominios.categoria (code,code_name) values (4,'EMU')#
INSERT INTO dominios.categoria (code,code_name) values (7,'EMU')#
INSERT INTO dominios.categoria (code,code_name) values (6,'EDF')#
INSERT INTO dominios.categoria (code,code_name) values (9,'FER')#
INSERT INTO dominios.categoria (code,code_name) values (20,'VER')#
INSERT INTO dominios.categoria (code,code_name) values (8,'ENC')#
INSERT INTO dominios.tipo_pista (code,code_name) values (11,'Heliponto')#
INSERT INTO dominios.tipo_pista (code,code_name) values (9,'Pista de Pouso')#
INSERT INTO dominios.tipo_pista (code,code_name) values (10,'Pista de taxiamento')#
INSERT INTO dominios.estado_fisico (code,code_name) values (1,'Líquido')#
INSERT INTO dominios.estado_fisico (code,code_name) values (98,'Misto')#
INSERT INTO dominios.estado_fisico (code,code_name) values (3,'Gasoso')#
INSERT INTO dominios.estado_fisico (code,code_name) values (2,'Sólido')#
INSERT INTO dominios.estado_fisico (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (39,'Cais flutuante')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (38,'Cais')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (44,'Desembarcadouro')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (42,'Píer')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (43,'Dolfim')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (40,'Trapiche')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (41,'Molhe de atracação')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.forma_extracao (code,code_name) values (5,'A céu aberto')#
INSERT INTO dominios.forma_extracao (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.forma_extracao (code,code_name) values (6,'Subterrânea')#
INSERT INTO dominios.tipo_area_umida (code,code_name) values (3,'Lamacento')#
INSERT INTO dominios.tipo_area_umida (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_area_umida (code,code_name) values (4,'Arenoso')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (1,'Próprio nacional')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (2,'Uso da União')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (5,'Uso do município')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (6,'Uso da UF')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.mat_transp (code,code_name) values (99,'Outros')#
INSERT INTO dominios.mat_transp (code,code_name) values (31,'Querosene')#
INSERT INTO dominios.mat_transp (code,code_name) values (30,'Álcool')#
INSERT INTO dominios.mat_transp (code,code_name) values (29,'Gasolina')#
INSERT INTO dominios.mat_transp (code,code_name) values (1,'Água')#
INSERT INTO dominios.mat_transp (code,code_name) values (3,'Petróleo')#
INSERT INTO dominios.mat_transp (code,code_name) values (2,'Óleo')#
INSERT INTO dominios.mat_transp (code,code_name) values (5,'Gás')#
INSERT INTO dominios.mat_transp (code,code_name) values (4,'Nafta')#
INSERT INTO dominios.mat_transp (code,code_name) values (7,'Minério')#
INSERT INTO dominios.mat_transp (code,code_name) values (6,'Grãos')#
INSERT INTO dominios.mat_transp (code,code_name) values (9,'Esgoto')#
INSERT INTO dominios.mat_transp (code,code_name) values (8,'Efluentes')#
INSERT INTO dominios.mat_transp (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_costa (code,code_name) values (11,'Afastada')#
INSERT INTO dominios.situacao_costa (code,code_name) values (10,'Contígua')#
INSERT INTO dominios.tipo_via (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_via (code,code_name) values (1,'Logradouro')#
INSERT INTO dominios.tipo_via (code,code_name) values (3,'Beco')#
INSERT INTO dominios.tipo_via (code,code_name) values (2,'Rodovia')#
INSERT INTO dominios.tipo_via (code,code_name) values (5,'Ligação entre pistas')#
INSERT INTO dominios.tipo_via (code,code_name) values (4,'Autoestrada')#
INSERT INTO dominios.tipo_via (code,code_name) values (7,'Servidão')#
INSERT INTO dominios.tipo_via (code,code_name) values (6,'Trecho de entroncamento')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (1,'Captação')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (3,'Recalque')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (2,'Tratamento')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (4,'Administrativa')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.regime (code,code_name) values (1,'Permanente')#
INSERT INTO dominios.regime (code,code_name) values (3,'Temporário')#
INSERT INTO dominios.regime (code,code_name) values (2,'Permanente com grande variação')#
INSERT INTO dominios.regime (code,code_name) values (5,'Seco')#
INSERT INTO dominios.regime (code,code_name) values (4,'Temporário com leito permanente')#
INSERT INTO dominios.regime (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.atividade (code,code_name) values (9,'Prospecção')#
INSERT INTO dominios.atividade (code,code_name) values (10,'Produção')#
INSERT INTO dominios.atividade (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (24,'Venda de veículos')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (25,'Administração')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (26,'Centro de exposições')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (20,'Pousada')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (21,'Quiosque')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (22,'Quitanda')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (23,'Supermercado')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (3,'Centro comercial')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (5,'Centro de convenções')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (4,'Mercado público')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (7,'Hotel')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (6,'Banca de jornal')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (9,'Comércio de carnes')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (8,'Restaurante')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (99,'Outros serviços')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (11,'Banco')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (10,'Farmácia')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (13,'Loja de materiais de construção e/ou ferragem')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (12,'Loja de conveniência')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (15,'Loja de roupas e/ou tecidos')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (14,'Loja de móveis')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (17,'Oficina mecânica')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (16,'Motel')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (19,'Posto de combustível')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (18,'Outros comércios')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (1,'Estação ecológica - ESEC')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (3,'Monumento natural – MONA')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (2,'Parque PAR')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (5,'Refúgio da vida silvestre – RVS')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (4,'Reserva Biológica – REBIO')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (8,'Armazenamento')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (3,'Recalque')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (2,'Tratamento')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (4,'Distribuição')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (26,'Terminal de passageiros')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (27,'Terminal de cargas')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (15,'Administração')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (33,'Estaleiro')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (32,'Armazém')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (37,'Terminal de uso privativo')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (36,'Carreira')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (35,'Rampa transportadora')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (34,'Dique de estaleiro')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (1,'Móvel')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (3,'Fixa')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (2,'Pênsil')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (7,'Estaiada')#
INSERT INTO dominios.tipo_quebra_molhe (code,code_name) values (1,'Quebramar')#
INSERT INTO dominios.tipo_quebra_molhe (code,code_name) values (2,'Molhe')#
INSERT INTO dominios.tipo_quebra_molhe (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_quebra_molhe (code,code_name) values (4,'Espigão')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (24,'Educação profissional de nível técnico')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (25,'Educação profissional de nível tecnológico')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (26,'Outras atividades de ensino')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (27,'Atendimento hospitalar (hospital)')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (20,'Ensino médio')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (21,'Educação superior-graduação')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (22,'Educação superior-graduação e pós-graduação')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (23,'Educação superior-pós-graduação e extensão')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (28,'Atendimento às urgências e emergências (pronto-socorro)')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (29,'Atenção ambulatorial (posto e centro de saúde)')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (3,'Transmissão de energia elétrica')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (2,'Produção de energia elétrica')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (5,'Captação, tratamento e distribuição de água')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (4,'Distribuição de energia elétrica')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (7,'Administração pública em geral')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (6,'Telecomunicações')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (9,'Regulação das atividades econômicas')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (8,'Seguridade social')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (99,'Outros')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (98,'Mista')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (11,'Relações exteriores')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (10,'Atividades de apoio à administração pública')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (13,'Justiça')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (12,'Defesa')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (15,'Defesa civil')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (14,'Segurança e ordem pública')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (17,'Educação infantil - creche')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (16,'Regulação das atividades sociais e culturais')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (19,'Ensino fundamental')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (18,'Educação infantil-pré-escola')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (31,'Atividades de organizações religiosas')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (30,'Serviços de complementação diagnóstica ou terapêutica')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (36,'Serviços veterinários')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (35,'Limpeza urbana e atividades relacionadas')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (34,'Serviços sociais sem alojamento')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (33,'Serviços sociais com alojamento')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (32,'Outras atividades relacionadas com atenção à saúde (instituto de pesquisa)')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (10,'Parada interestadual')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (13,'Posto de pedágio')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (15,'Administração')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (8,'Terminal interestadual')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (9,'Terminal urbano')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (20,'Garagem')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.aptidao_operacional_atracadouro (code,code_name) values (3,'Transporte oceânico')#
INSERT INTO dominios.aptidao_operacional_atracadouro (code,code_name) values (2,'Transporte de cabotagem')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (11,'Maregráfica - MA')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (10,'Fluviométrica - FL')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (13,'Metero-maregráfica')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (12,'Marés terrestres-crosta')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (14,'Higrológica')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (1,'Climatológica principal - CP')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (3,'Agroclimatológica - AC')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (2,'Climatológica auxiliar- CA')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (5,'Eólica - EO')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (4,'Pluviométrica - PL')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (7,'Solarimétrica - SL')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (6,'Evaporimétrica - EV')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (9,'Radiossonda - RS')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (8,'Radar metereológico - RD')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_associado (code,code_name) values (1,'Cidade')#
INSERT INTO dominios.tipo_associado (code,code_name) values (4,'Vila')#
INSERT INTO dominios.tipo_fonte_dagua (code,code_name) values (1,'Poço')#
INSERT INTO dominios.tipo_fonte_dagua (code,code_name) values (3,'Olho dágua')#
INSERT INTO dominios.tipo_fonte_dagua (code,code_name) values (2,'Poço artesiano')#
INSERT INTO dominios.tipo_fonte_dagua (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.uso_principal (code,code_name) values (99,'Outros')#
INSERT INTO dominios.uso_principal (code,code_name) values (1,'Irrigação')#
INSERT INTO dominios.uso_principal (code,code_name) values (3,'Energia')#
INSERT INTO dominios.uso_principal (code,code_name) values (2,'Abastecimento')#
INSERT INTO dominios.uso_principal (code,code_name) values (5,'Dessedentação animal')#
INSERT INTO dominios.uso_principal (code,code_name) values (4,'Lazer')#
INSERT INTO dominios.uso_principal (code,code_name) values (6,'Drenagem')#
INSERT INTO dominios.uso_principal (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.uso_principal (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (3,'Recalque')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (5,'Tratamento de esgoto')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (7,'Incinerador')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (6,'Usina de reciclagem')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (8,'Administração')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_saneamento_basico (code,code_name) values (1,'Abastecimento de água')#
INSERT INTO dominios.tipo_saneamento_basico (code,code_name) values (3,'Esgotamento sanitário')#
INSERT INTO dominios.tipo_saneamento_basico (code,code_name) values (2,'Drenagem e manejo de águas pluviais')#
INSERT INTO dominios.tipo_saneamento_basico (code,code_name) values (4,'Limpeza urbana e manejo de resíduos sólidos')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (1,'Área de Proteção Ambiental - APA')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (3,'Floresta – FLO')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (2,'Área de Relevante Interesse Ecológico – ARIE')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (5,'Reserva Extrativista – RESEX')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (4,'Reserva de Desenvolvimento sustentável – RDS')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (7,'Reserva Particular de Patrimônio Natural – RPPN')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (6,'Reserva de Fauna – REFAU')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (11,'Caatinga')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (10,'Vegetação de brejo ou pântano')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (3,'Floresta')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (2,'Vegetação cultivada')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (5,'Refúgio ecológico')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (4,'Vegetação de mangue')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (7,'Cerrado')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (6,'Campinarana')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (9,'Estepe')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (8,'Vegetação de restinga')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_conteudo (code,code_name) values (1,'Insumo')#
INSERT INTO dominios.tipo_conteudo (code,code_name) values (3,'Resíduo')#
INSERT INTO dominios.tipo_conteudo (code,code_name) values (2,'Produto')#
INSERT INTO dominios.tipo_conteudo (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.proc_extracao (code,code_name) values (1,'Mecanizado')#
INSERT INTO dominios.proc_extracao (code,code_name) values (2,'Manual')#
INSERT INTO dominios.proc_extracao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (5,'Trecho para bonde')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (6,'Trecho para aeromóvel')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (7,'Trecho para trem')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (8,'Trecho para metrô')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (99,'Outras')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (5,'Cristã')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (7,'Muçulmana')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (6,'Israelita')#
INSERT INTO dominios.setor (code,code_name) values (1,'Energético')#
INSERT INTO dominios.setor (code,code_name) values (3,'Abastecimento de água')#
INSERT INTO dominios.setor (code,code_name) values (2,'Econômico')#
INSERT INTO dominios.setor (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.setor (code,code_name) values (4,'Saneamento básico')#
INSERT INTO dominios.tipo_capital (code,code_name) values (3,'Capital estadual')#
INSERT INTO dominios.tipo_capital (code,code_name) values (2,'Capital federal')#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_tipocombustivel_fk FOREIGN KEY (tipocombustivel) REFERENCES dominios.tipo_combustivel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_casa_de_forca_p ADD CONSTRAINT enc_casa_de_forca_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_chamine_fk FOREIGN KEY (chamine) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_p ADD CONSTRAINT hid_recife_p_tiporecife_fk FOREIGN KEY (tiporecife) REFERENCES dominios.tipo_recife(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_p ADD CONSTRAINT hid_recife_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_p ADD CONSTRAINT hid_recife_p_situacaocosta_fk FOREIGN KEY (situacaocosta) REFERENCES dominios.situacao_costa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_p ADD CONSTRAINT hid_recife_p_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_dique_p ADD CONSTRAINT hid_dique_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_setor_fk FOREIGN KEY (setor) REFERENCES dominios.setor(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_tipotrechoduto_fk FOREIGN KEY (tipotrechoduto) REFERENCES dominios.tipo_trecho_duto(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_pico_p ADD CONSTRAINT rel_pico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_pico_p ADD CONSTRAINT rel_pico_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_chamine_fk FOREIGN KEY (chamine) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protecao_integral_a ADD CONSTRAINT lml_unidade_protecao_integral_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protecao_integral_a ADD CONSTRAINT lml_unidade_protecao_integral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protecao_integral_a ADD CONSTRAINT lml_unidade_protecao_integral_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protecao_integral_a ADD CONSTRAINT lml_unidade_protecao_integral_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protecao_integral_a ADD CONSTRAINT lml_unidade_protecao_integral_a_tipounidprotinteg_fk FOREIGN KEY (tipounidprotinteg) REFERENCES dominios.tipo_unid_prot_integ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_area_densamente_edificada_a ADD CONSTRAINT lml_area_densamente_edificada_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_p ADD CONSTRAINT hid_barragem_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_p ADD CONSTRAINT hid_barragem_p_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_p ADD CONSTRAINT hid_barragem_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_p ADD CONSTRAINT hid_barragem_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_emperimetrourbano_fk FOREIGN KEY (emperimetrourbano) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_tipovia_fk FOREIGN KEY (tipovia) REFERENCES dominios.tipo_via(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_acostamento_fk FOREIGN KEY (acostamento) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_tipoedifturist_fk FOREIGN KEY (tipoedifturist) REFERENCES dominios.tipo_edif_turist(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_tombada_fk FOREIGN KEY (tombada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_ovgd_fk FOREIGN KEY (ovgd) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_curva_batimetrica_l ADD CONSTRAINT rel_curva_batimetrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_a ADD CONSTRAINT hid_barragem_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_a ADD CONSTRAINT hid_barragem_a_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_a ADD CONSTRAINT hid_barragem_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_a ADD CONSTRAINT hid_barragem_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_tipousocaminhoaer_fk FOREIGN KEY (tipousocaminhoaer) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_tipocaminhoaereo_fk FOREIGN KEY (tipocaminhoaereo) REFERENCES dominios.tipo_caminho_aereo(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_l ADD CONSTRAINT hid_barragem_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_l ADD CONSTRAINT hid_barragem_l_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_l ADD CONSTRAINT hid_barragem_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_barragem_l ADD CONSTRAINT hid_barragem_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_situacaoagua_fk FOREIGN KEY (situacaoagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_tipoedifturist_fk FOREIGN KEY (tipoedifturist) REFERENCES dominios.tipo_edif_turist(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_tombada_fk FOREIGN KEY (tombada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_ovgd_fk FOREIGN KEY (ovgd) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_ovgd_fk FOREIGN KEY (ovgd) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_posicaoreledific_fk FOREIGN KEY (posicaoreledific) REFERENCES dominios.posicao_rel_edific(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_nivelatencao_fk FOREIGN KEY (nivelatencao) REFERENCES dominios.nivel_atencao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_causa_fk FOREIGN KEY (causa) REFERENCES dominios.causa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_tiposumvert_fk FOREIGN KEY (tiposumvert) REFERENCES dominios.tipo_sum_vert(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_elemento_fisiografico_natural_p ADD CONSTRAINT rel_elemento_fisiografico_natural_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_elemento_fisiografico_natural_p ADD CONSTRAINT rel_elemento_fisiografico_natural_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_trilha_picada_l ADD CONSTRAINT tra_trilha_picada_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_dolina_a ADD CONSTRAINT rel_dolina_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_dolina_a ADD CONSTRAINT rel_dolina_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_canteiro_central_a ADD CONSTRAINT cbge_canteiro_central_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_canteiro_central_a ADD CONSTRAINT cbge_canteiro_central_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_ponto_cotado_altimetrico_p ADD CONSTRAINT rel_ponto_cotado_altimetrico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_ponto_cotado_altimetrico_p ADD CONSTRAINT rel_ponto_cotado_altimetrico_p_cotacomprovada_fk FOREIGN KEY (cotacomprovada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_nivelatencao_fk FOREIGN KEY (nivelatencao) REFERENCES dominios.nivel_atencao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_l ADD CONSTRAINT rod_via_deslocamento_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_l ADD CONSTRAINT rod_via_deslocamento_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_l ADD CONSTRAINT rod_via_deslocamento_l_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_l ADD CONSTRAINT rod_via_deslocamento_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_l ADD CONSTRAINT rod_via_deslocamento_l_tipovia_fk FOREIGN KEY (tipovia) REFERENCES dominios.tipo_via(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_l ADD CONSTRAINT rod_via_deslocamento_l_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_l ADD CONSTRAINT rod_via_deslocamento_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_l ADD CONSTRAINT rod_via_deslocamento_l_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_municipio_a ADD CONSTRAINT lml_municipio_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_matcondutor_fk FOREIGN KEY (matcondutor) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_emduto_fk FOREIGN KEY (emduto) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_tipotrechocomunic_fk FOREIGN KEY (tipotrechocomunic) REFERENCES dominios.tipo_trecho_comunic(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_cemiterio_a ADD CONSTRAINT cbge_cemiterio_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_cemiterio_a ADD CONSTRAINT cbge_cemiterio_a_destinacaocemiterio_fk FOREIGN KEY (destinacaocemiterio) REFERENCES dominios.destinacao_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_cemiterio_a ADD CONSTRAINT cbge_cemiterio_a_tipocemiterio_fk FOREIGN KEY (tipocemiterio) REFERENCES dominios.tipo_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_cemiterio_a ADD CONSTRAINT cbge_cemiterio_a_denominacaoassociada_fk FOREIGN KEY (denominacaoassociada) REFERENCES dominios.denominacao_associada(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_aerogerador_p ADD CONSTRAINT enc_aerogerador_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_materialpredominante_fk FOREIGN KEY (materialpredominante) REFERENCES dominios.material_predominante(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_tipobanco_fk FOREIGN KEY (tipobanco) REFERENCES dominios.tipo_banco(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_tipoediflazer_fk FOREIGN KEY (tipoediflazer) REFERENCES dominios.tipo_edif_lazer(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_tipopistacomp_fk FOREIGN KEY (tipopistacomp) REFERENCES dominios.tipo_pista_comp(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_materialpredominante_fk FOREIGN KEY (materialpredominante) REFERENCES dominios.material_predominante(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_tipobanco_fk FOREIGN KEY (tipobanco) REFERENCES dominios.tipo_banco(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_habitacional_a ADD CONSTRAINT cbge_area_habitacional_a_tipoarea_fk FOREIGN KEY (tipoarea) REFERENCES dominios.tipo_area(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_habitacional_a ADD CONSTRAINT cbge_area_habitacional_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_foz_maritima_l ADD CONSTRAINT hid_foz_maritima_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_tipopistacomp_fk FOREIGN KEY (tipopistacomp) REFERENCES dominios.tipo_pista_comp(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_tipopistacomp_fk FOREIGN KEY (tipopistacomp) REFERENCES dominios.tipo_pista_comp(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_ponto_hipsometrico_p ADD CONSTRAINT rel_ponto_hipsometrico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_foz_maritima_a ADD CONSTRAINT hid_foz_maritima_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_est_med_fenomenos_p ADD CONSTRAINT pto_pto_est_med_fenomenos_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_est_med_fenomenos_p ADD CONSTRAINT pto_pto_est_med_fenomenos_p_tipoptoestmed_fk FOREIGN KEY (tipoptoestmed) REFERENCES dominios.tipo_pto_est_med(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_ruina_p ADD CONSTRAINT laz_ruina_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_ruina_p ADD CONSTRAINT laz_ruina_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_ruina_p ADD CONSTRAINT laz_ruina_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_tipopostofisc_fk FOREIGN KEY (tipopostofisc) REFERENCES dominios.tipo_posto_fisc(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_corredeira_p ADD CONSTRAINT hid_corredeira_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_area_especial_a ADD CONSTRAINT lml_area_especial_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_corte_p ADD CONSTRAINT rel_corte_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_corte_p ADD CONSTRAINT rel_corte_p_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_tipoponte_fk FOREIGN KEY (tipoponte) REFERENCES dominios.tipo_ponte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_a ADD CONSTRAINT hdv_obstaculo_navegacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_a ADD CONSTRAINT hdv_obstaculo_navegacao_a_tipoobst_fk FOREIGN KEY (tipoobst) REFERENCES dominios.tipo_obst(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_a ADD CONSTRAINT hdv_obstaculo_navegacao_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_aterro_l ADD CONSTRAINT rel_aterro_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_aterro_l ADD CONSTRAINT rel_aterro_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_coletiva_fk FOREIGN KEY (coletiva) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_isolada_fk FOREIGN KEY (isolada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_l ADD CONSTRAINT enc_central_geradora_eolica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_l ADD CONSTRAINT enc_central_geradora_eolica_l_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_l ADD CONSTRAINT enc_central_geradora_eolica_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_l ADD CONSTRAINT enc_central_geradora_eolica_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_setor_fk FOREIGN KEY (setor) REFERENCES dominios.setor(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_tipotrechoduto_fk FOREIGN KEY (tipotrechoduto) REFERENCES dominios.tipo_trecho_duto(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_corredeira_a ADD CONSTRAINT hid_corredeira_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_tipopostofisc_fk FOREIGN KEY (tipopostofisc) REFERENCES dominios.tipo_posto_fisc(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_tipoponte_fk FOREIGN KEY (tipoponte) REFERENCES dominios.tipo_ponte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_tipoequipagropec_fk FOREIGN KEY (tipoequipagropec) REFERENCES dominios.tipo_equip_agropec(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_entroncamento_pto_p ADD CONSTRAINT tra_entroncamento_pto_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_entroncamento_pto_p ADD CONSTRAINT tra_entroncamento_pto_p_tipoentroncamento_fk FOREIGN KEY (tipoentroncamento) REFERENCES dominios.tipo_entroncamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_foz_maritima_p ADD CONSTRAINT hid_foz_maritima_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_comporta_l ADD CONSTRAINT hid_comporta_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_comporta_l ADD CONSTRAINT hid_comporta_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_comporta_l ADD CONSTRAINT hid_comporta_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_corredeira_l ADD CONSTRAINT hid_corredeira_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_ponto_cotado_batimetrico_p ADD CONSTRAINT rel_ponto_cotado_batimetrico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_tipoatracad_fk FOREIGN KEY (tipoatracad) REFERENCES dominios.tipo_atracad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_l ADD CONSTRAINT emu_elevador_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_l ADD CONSTRAINT emu_elevador_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_l ADD CONSTRAINT emu_elevador_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_l ADD CONSTRAINT emu_elevador_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_l ADD CONSTRAINT emu_elevador_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_l ADD CONSTRAINT emu_elevador_l_tipoelevador_fk FOREIGN KEY (tipoelevador) REFERENCES dominios.tipo_elevador(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_ensino_fk FOREIGN KEY (ensino) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_crista_fk FOREIGN KEY (crista) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_tipoedifrelig_fk FOREIGN KEY (tipoedifrelig) REFERENCES dominios.tipo_edif_relig(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_tipotravessiaped_fk FOREIGN KEY (tipotravessiaped) REFERENCES dominios.tipo_travessia_ped(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_tipotrechodrenagem_fk FOREIGN KEY (tipotrechodrenagem) REFERENCES dominios.tipo_trecho_drenagem(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_encoberto_fk FOREIGN KEY (encoberto) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_navegavel_fk FOREIGN KEY (navegavel) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_regime_fk FOREIGN KEY (regime) REFERENCES dominios.regime(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_tipocombustivel_fk FOREIGN KEY (tipocombustivel) REFERENCES dominios.tipo_combustivel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_uso_sustentavel_a ADD CONSTRAINT lml_unidade_uso_sustentavel_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_uso_sustentavel_a ADD CONSTRAINT lml_unidade_uso_sustentavel_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_uso_sustentavel_a ADD CONSTRAINT lml_unidade_uso_sustentavel_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_uso_sustentavel_a ADD CONSTRAINT lml_unidade_uso_sustentavel_a_tipounidusosust_fk FOREIGN KEY (tipounidusosust) REFERENCES dominios.tipo_unid_uso_sust(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_uso_sustentavel_a ADD CONSTRAINT lml_unidade_uso_sustentavel_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_largo_a ADD CONSTRAINT cbge_largo_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_tipoatracad_fk FOREIGN KEY (tipoatracad) REFERENCES dominios.tipo_atracad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_tipoediflazer_fk FOREIGN KEY (tipoediflazer) REFERENCES dominios.tipo_edif_lazer(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_tipotravessiaped_fk FOREIGN KEY (tipotravessiaped) REFERENCES dominios.tipo_travessia_ped(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_nivel_p ADD CONSTRAINT tra_passagem_nivel_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_ensino_fk FOREIGN KEY (ensino) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_crista_fk FOREIGN KEY (crista) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_tipoedifrelig_fk FOREIGN KEY (tipoedifrelig) REFERENCES dominios.tipo_edif_relig(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_sargeta_fk FOREIGN KEY (sargeta) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_tipovia_fk FOREIGN KEY (tipovia) REFERENCES dominios.tipo_via(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_meiofio_fk FOREIGN KEY (meiofio) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_a ADD CONSTRAINT cbge_trecho_arruamento_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_girador_ferroviario_p ADD CONSTRAINT fer_girador_ferroviario_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_girador_ferroviario_p ADD CONSTRAINT fer_girador_ferroviario_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_girador_ferroviario_p ADD CONSTRAINT fer_girador_ferroviario_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_girador_ferroviario_p ADD CONSTRAINT fer_girador_ferroviario_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_tipoatracad_fk FOREIGN KEY (tipoatracad) REFERENCES dominios.tipo_atracad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_pais_a ADD CONSTRAINT lml_pais_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_a ADD CONSTRAINT emu_acesso_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_a ADD CONSTRAINT emu_acesso_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_a ADD CONSTRAINT emu_acesso_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_a ADD CONSTRAINT emu_acesso_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_a ADD CONSTRAINT emu_acesso_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_vereda_fk FOREIGN KEY (vereda) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_usopista_fk FOREIGN KEY (usopista) REFERENCES dominios.uso_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_homologacao_fk FOREIGN KEY (homologacao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_tipopista_fk FOREIGN KEY (tipopista) REFERENCES dominios.tipo_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_l ADD CONSTRAINT hid_canal_l_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_l ADD CONSTRAINT hid_canal_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_l ADD CONSTRAINT hid_canal_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_l ADD CONSTRAINT hid_canal_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_l ADD CONSTRAINT hid_canal_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_l ADD CONSTRAINT hid_canal_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_usopista_fk FOREIGN KEY (usopista) REFERENCES dominios.uso_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_homologacao_fk FOREIGN KEY (homologacao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_tipopista_fk FOREIGN KEY (tipopista) REFERENCES dominios.tipo_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_atividade_fk FOREIGN KEY (atividade) REFERENCES dominios.atividade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_tipoextmin_fk FOREIGN KEY (tipoextmin) REFERENCES dominios.tipo_ext_min(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_procextracao_fk FOREIGN KEY (procextracao) REFERENCES dominios.proc_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_tipopocomina_fk FOREIGN KEY (tipopocomina) REFERENCES dominios.tipo_poco_mina(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_formaextracao_fk FOREIGN KEY (formaextracao) REFERENCES dominios.forma_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_tipoedifabast_fk FOREIGN KEY (tipoedifabast) REFERENCES dominios.tipo_edif_abast(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_usopista_fk FOREIGN KEY (usopista) REFERENCES dominios.uso_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_homologacao_fk FOREIGN KEY (homologacao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_tipopista_fk FOREIGN KEY (tipopista) REFERENCES dominios.tipo_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_p ADD CONSTRAINT tra_travessia_p_tipoembarcacao_fk FOREIGN KEY (tipoembarcacao) REFERENCES dominios.tipo_embarcacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_p ADD CONSTRAINT tra_travessia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_p ADD CONSTRAINT tra_travessia_p_tipouso_fk FOREIGN KEY (tipouso) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_p ADD CONSTRAINT tra_travessia_p_tipotravessia_fk FOREIGN KEY (tipotravessia) REFERENCES dominios.tipo_travessia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_tipoedifabast_fk FOREIGN KEY (tipoedifabast) REFERENCES dominios.tipo_edif_abast(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_aterro_a ADD CONSTRAINT rel_aterro_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_aterro_a ADD CONSTRAINT rel_aterro_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_estacionamento_a ADD CONSTRAINT cbge_estacionamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_estacionamento_a ADD CONSTRAINT cbge_estacionamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_estacionamento_a ADD CONSTRAINT cbge_estacionamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_estacionamento_a ADD CONSTRAINT cbge_estacionamento_a_publico_fk FOREIGN KEY (publico) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_area_umida_a ADD CONSTRAINT hid_area_umida_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_area_umida_a ADD CONSTRAINT hid_area_umida_a_tipoareaumida_fk FOREIGN KEY (tipoareaumida) REFERENCES dominios.tipo_area_umida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_emperimetrourbano_fk FOREIGN KEY (emperimetrourbano) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_tipovia_fk FOREIGN KEY (tipovia) REFERENCES dominios.tipo_via(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_acostamento_fk FOREIGN KEY (acostamento) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_trecho_rodoviario_a ADD CONSTRAINT rod_trecho_rodoviario_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_tipopassagviad_fk FOREIGN KEY (tipopassagviad) REFERENCES dominios.tipo_passag_viad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_ilha_l ADD CONSTRAINT hid_ilha_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_ilha_l ADD CONSTRAINT hid_ilha_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_p ADD CONSTRAINT tra_obra_de_arte_viaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_p ADD CONSTRAINT tra_obra_de_arte_viaria_p_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_p ADD CONSTRAINT tra_obra_de_arte_viaria_p_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_p ADD CONSTRAINT tra_obra_de_arte_viaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_p ADD CONSTRAINT tra_obra_de_arte_viaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_p ADD CONSTRAINT tra_obra_de_arte_viaria_p_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_dique_l ADD CONSTRAINT hid_dique_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_area_pub_militar_a ADD CONSTRAINT lml_area_pub_militar_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_area_pub_militar_a ADD CONSTRAINT lml_area_pub_militar_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_area_pub_militar_a ADD CONSTRAINT lml_area_pub_militar_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_passeio_l ADD CONSTRAINT cbge_passeio_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_passeio_l ADD CONSTRAINT cbge_passeio_l_calcada_fk FOREIGN KEY (calcada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_poste_sinalizacao_p ADD CONSTRAINT emu_poste_sinalizacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_poste_sinalizacao_p ADD CONSTRAINT emu_poste_sinalizacao_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_distrito_a ADD CONSTRAINT lml_distrito_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_l ADD CONSTRAINT tra_obra_de_arte_viaria_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_l ADD CONSTRAINT tra_obra_de_arte_viaria_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_l ADD CONSTRAINT tra_obra_de_arte_viaria_l_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_l ADD CONSTRAINT tra_obra_de_arte_viaria_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_l ADD CONSTRAINT tra_obra_de_arte_viaria_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_l ADD CONSTRAINT tra_obra_de_arte_viaria_l_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_tipotrechoferrov_fk FOREIGN KEY (tipotrechoferrov) REFERENCES dominios.tipo_trecho_ferrov(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_eletrificada_fk FOREIGN KEY (eletrificada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_emarruamento_fk FOREIGN KEY (emarruamento) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_nrlinhas_fk FOREIGN KEY (nrlinhas) REFERENCES dominios.nr_linhas(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_bitola_fk FOREIGN KEY (bitola) REFERENCES dominios.bitola(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_l ADD CONSTRAINT hdv_obstaculo_navegacao_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_l ADD CONSTRAINT hdv_obstaculo_navegacao_l_tipoobst_fk FOREIGN KEY (tipoobst) REFERENCES dominios.tipo_obst(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_l ADD CONSTRAINT hdv_obstaculo_navegacao_l_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_espelho_dagua_a ADD CONSTRAINT cbge_espelho_dagua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_federacao_a ADD CONSTRAINT lml_unidade_federacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_federacao_a ADD CONSTRAINT lml_unidade_federacao_a_sigla_fk FOREIGN KEY (sigla) REFERENCES dominios.sigla_uf(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_a ADD CONSTRAINT tra_obra_de_arte_viaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_a ADD CONSTRAINT tra_obra_de_arte_viaria_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_a ADD CONSTRAINT tra_obra_de_arte_viaria_a_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_a ADD CONSTRAINT tra_obra_de_arte_viaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_a ADD CONSTRAINT tra_obra_de_arte_viaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_obra_de_arte_viaria_a ADD CONSTRAINT tra_obra_de_arte_viaria_a_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_passeio_a ADD CONSTRAINT cbge_passeio_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_passeio_a ADD CONSTRAINT cbge_passeio_a_calcada_fk FOREIGN KEY (calcada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedrestre_a ADD CONSTRAINT tra_travessia_pedrestre_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedrestre_a ADD CONSTRAINT tra_travessia_pedrestre_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedrestre_a ADD CONSTRAINT tra_travessia_pedrestre_a_tipotravessiaped_fk FOREIGN KEY (tipotravessiaped) REFERENCES dominios.tipo_travessia_ped(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedrestre_a ADD CONSTRAINT tra_travessia_pedrestre_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedrestre_a ADD CONSTRAINT tra_travessia_pedrestre_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_pedrestre_a ADD CONSTRAINT tra_travessia_pedrestre_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_tipoahe_fk FOREIGN KEY (tipoahe) REFERENCES dominios.tipo_ahe(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_tipoahe_fk FOREIGN KEY (tipoahe) REFERENCES dominios.tipo_ahe(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_a ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_a ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_a ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_a ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_quadra_a ADD CONSTRAINT cbge_quadra_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.ver_jardim_a ADD CONSTRAINT ver_jardim_a_tipolavoura_fk FOREIGN KEY (tipolavoura) REFERENCES dominios.tipo_lavoura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.ver_jardim_a ADD CONSTRAINT ver_jardim_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.ver_jardim_a ADD CONSTRAINT ver_jardim_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.ver_jardim_a ADD CONSTRAINT ver_jardim_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_l ADD CONSTRAINT rel_rocha_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_l ADD CONSTRAINT rel_rocha_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_l ADD CONSTRAINT rel_rocha_l_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_posic_geo_localidade_p ADD CONSTRAINT lml_posic_geo_localidade_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_posic_geo_localidade_p ADD CONSTRAINT lml_posic_geo_localidade_p_tipolocalidade_fk FOREIGN KEY (tipolocalidade) REFERENCES dominios.tipo_localidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_patio_a ADD CONSTRAINT tra_patio_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_patio_a ADD CONSTRAINT tra_patio_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_patio_a ADD CONSTRAINT tra_patio_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_tipoahe_fk FOREIGN KEY (tipoahe) REFERENCES dominios.tipo_ahe(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_fonte_dagua_p ADD CONSTRAINT hid_fonte_dagua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_fonte_dagua_p ADD CONSTRAINT hid_fonte_dagua_p_qualidagua_fk FOREIGN KEY (qualidagua) REFERENCES dominios.qualid_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_fonte_dagua_p ADD CONSTRAINT hid_fonte_dagua_p_tipofontedagua_fk FOREIGN KEY (tipofontedagua) REFERENCES dominios.tipo_fonte_dagua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_fonte_dagua_p ADD CONSTRAINT hid_fonte_dagua_p_regime_fk FOREIGN KEY (regime) REFERENCES dominios.regime(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_ilha_p ADD CONSTRAINT hid_ilha_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_ilha_p ADD CONSTRAINT hid_ilha_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_dolina_p ADD CONSTRAINT rel_dolina_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_dolina_p ADD CONSTRAINT rel_dolina_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_queda_dagua_p ADD CONSTRAINT hid_queda_dagua_p_tipoqueda_fk FOREIGN KEY (tipoqueda) REFERENCES dominios.tipo_queda(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_queda_dagua_p ADD CONSTRAINT hid_queda_dagua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_marco_de_limite_p ADD CONSTRAINT pto_marco_de_limite_p_sistemageodesico_fk FOREIGN KEY (sistemageodesico) REFERENCES dominios.sistema_geodesico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_marco_de_limite_p ADD CONSTRAINT pto_marco_de_limite_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_marco_de_limite_p ADD CONSTRAINT pto_marco_de_limite_p_tipomarcolim_fk FOREIGN KEY (tipomarcolim) REFERENCES dominios.tipo_hierarquia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_marco_de_limite_p ADD CONSTRAINT pto_marco_de_limite_p_referencialaltim_fk FOREIGN KEY (referencialaltim) REFERENCES dominios.referencial_altim(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_queda_dagua_l ADD CONSTRAINT hid_queda_dagua_l_tipoqueda_fk FOREIGN KEY (tipoqueda) REFERENCES dominios.tipo_queda(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_queda_dagua_l ADD CONSTRAINT hid_queda_dagua_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_tipoedifsaneam_fk FOREIGN KEY (tipoedifsaneam) REFERENCES dominios.tipo_edif_saneam(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_p ADD CONSTRAINT rel_duna_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_p ADD CONSTRAINT rel_duna_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_p ADD CONSTRAINT rel_duna_p_fixa_fk FOREIGN KEY (fixa) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_duto_a ADD CONSTRAINT cbge_area_duto_a_tipoarea_fk FOREIGN KEY (tipoarea) REFERENCES dominios.tipo_area(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_duto_a ADD CONSTRAINT cbge_area_duto_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_duto_a ADD CONSTRAINT cbge_area_duto_a_bombeamento_fk FOREIGN KEY (bombeamento) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_duto_a ADD CONSTRAINT cbge_area_duto_a_areavalvulas_fk FOREIGN KEY (areavalvulas) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_tipocampoquadra_fk FOREIGN KEY (tipocampoquadra) REFERENCES dominios.tipo_campo_quadra(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_sinalizacao_p ADD CONSTRAINT hdv_sinalizacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_sinalizacao_p ADD CONSTRAINT hdv_sinalizacao_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_sinalizacao_p ADD CONSTRAINT hdv_sinalizacao_p_tiposinal_fk FOREIGN KEY (tiposinal) REFERENCES dominios.tipo_sinal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_sinalizacao_p ADD CONSTRAINT hdv_sinalizacao_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_fundeadouro_a ADD CONSTRAINT hdv_fundeadouro_a_tipofundeadouro_fk FOREIGN KEY (tipofundeadouro) REFERENCES dominios.tipo_fundeadouro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_fundeadouro_a ADD CONSTRAINT hdv_fundeadouro_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_fundeadouro_a ADD CONSTRAINT hdv_fundeadouro_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_alteracao_fisiografica_antropica_p ADD CONSTRAINT rel_alteracao_fisiografica_antropica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_alteracao_fisiografica_antropica_p ADD CONSTRAINT rel_alteracao_fisiografica_antropica_p_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_alteracao_fisiografica_antropica_l ADD CONSTRAINT rel_alteracao_fisiografica_antropica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_alteracao_fisiografica_antropica_l ADD CONSTRAINT rel_alteracao_fisiografica_antropica_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_a ADD CONSTRAINT rel_duna_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_a ADD CONSTRAINT rel_duna_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_a ADD CONSTRAINT rel_duna_a_fixa_fk FOREIGN KEY (fixa) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_tipoedifsaneam_fk FOREIGN KEY (tipoedifsaneam) REFERENCES dominios.tipo_edif_saneam(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_tipocampoquadra_fk FOREIGN KEY (tipocampoquadra) REFERENCES dominios.tipo_campo_quadra(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_l ADD CONSTRAINT rel_duna_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_l ADD CONSTRAINT rel_duna_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_duna_l ADD CONSTRAINT rel_duna_l_fixa_fk FOREIGN KEY (fixa) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_tipolavoura_fk FOREIGN KEY (tipolavoura) REFERENCES dominios.tipo_lavoura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_a ADD CONSTRAINT emu_elevador_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_a ADD CONSTRAINT emu_elevador_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_a ADD CONSTRAINT emu_elevador_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_a ADD CONSTRAINT emu_elevador_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_a ADD CONSTRAINT emu_elevador_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_a ADD CONSTRAINT emu_elevador_a_tipoelevador_fk FOREIGN KEY (tipoelevador) REFERENCES dominios.tipo_elevador(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_ilha_a ADD CONSTRAINT hid_ilha_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_ilha_a ADD CONSTRAINT hid_ilha_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_fundeadouro_p ADD CONSTRAINT hdv_fundeadouro_p_tipofundeadouro_fk FOREIGN KEY (tipofundeadouro) REFERENCES dominios.tipo_fundeadouro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_fundeadouro_p ADD CONSTRAINT hdv_fundeadouro_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_fundeadouro_p ADD CONSTRAINT hdv_fundeadouro_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_cremalheira_l ADD CONSTRAINT fer_cremalheira_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_cremalheira_l ADD CONSTRAINT fer_cremalheira_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_cremalheira_l ADD CONSTRAINT fer_cremalheira_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_a ADD CONSTRAINT hid_recife_a_tiporecife_fk FOREIGN KEY (tiporecife) REFERENCES dominios.tipo_recife(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_a ADD CONSTRAINT hid_recife_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_a ADD CONSTRAINT hid_recife_a_situacaocosta_fk FOREIGN KEY (situacaocosta) REFERENCES dominios.situacao_costa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_a ADD CONSTRAINT hid_recife_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_l ADD CONSTRAINT hid_recife_l_tiporecife_fk FOREIGN KEY (tiporecife) REFERENCES dominios.tipo_recife(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_l ADD CONSTRAINT hid_recife_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_l ADD CONSTRAINT hid_recife_l_situacaocosta_fk FOREIGN KEY (situacaocosta) REFERENCES dominios.situacao_costa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_recife_l ADD CONSTRAINT hid_recife_l_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_tiporepdiplomatica_fk FOREIGN KEY (tiporepdiplomatica) REFERENCES dominios.tipo_rep_diplomatica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_l ADD CONSTRAINT tra_travessia_l_tipoembarcacao_fk FOREIGN KEY (tipoembarcacao) REFERENCES dominios.tipo_embarcacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_l ADD CONSTRAINT tra_travessia_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_l ADD CONSTRAINT tra_travessia_l_tipouso_fk FOREIGN KEY (tipouso) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_travessia_l ADD CONSTRAINT tra_travessia_l_tipotravessia_fk FOREIGN KEY (tipotravessia) REFERENCES dominios.tipo_travessia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_funicular_l ADD CONSTRAINT tra_funicular_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_funicular_l ADD CONSTRAINT tra_funicular_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_funicular_l ADD CONSTRAINT tra_funicular_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_p ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_p ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_p ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_p ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_cremalheira_p ADD CONSTRAINT fer_cremalheira_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_cremalheira_p ADD CONSTRAINT fer_cremalheira_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.fer_cremalheira_p ADD CONSTRAINT fer_cremalheira_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_tipotunel_fk FOREIGN KEY (tipotunel) REFERENCES dominios.tipo_tunel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_plataforma_a ADD CONSTRAINT eco_plataforma_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_plataforma_a ADD CONSTRAINT eco_plataforma_a_tipoplataforma_fk FOREIGN KEY (tipoplataforma) REFERENCES dominios.tipo_plataforma(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_ruina_a ADD CONSTRAINT laz_ruina_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_ruina_a ADD CONSTRAINT laz_ruina_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_ruina_a ADD CONSTRAINT laz_ruina_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_floresta_a ADD CONSTRAINT veg_floresta_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_floresta_a ADD CONSTRAINT veg_floresta_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_floresta_a ADD CONSTRAINT veg_floresta_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_floresta_a ADD CONSTRAINT veg_floresta_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_floresta_a ADD CONSTRAINT veg_floresta_a_especiepredominante_fk FOREIGN KEY (especiepredominante) REFERENCES dominios.especie(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_floresta_a ADD CONSTRAINT veg_floresta_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_grupo_transformadores_p ADD CONSTRAINT enc_grupo_transformadores_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_sistemageodesico_fk FOREIGN KEY (sistemageodesico) REFERENCES dominios.sistema_geodesico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_proximidade_fk FOREIGN KEY (proximidade) REFERENCES dominios.proximidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_tipoptorefgeodtopo_fk FOREIGN KEY (tipoptorefgeodtopo) REFERENCES dominios.tipo_pto_ref_geod_topo(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_situacaomarco_fk FOREIGN KEY (situacaomarco) REFERENCES dominios.situacao_marco(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_tiporef_fk FOREIGN KEY (tiporef) REFERENCES dominios.tipo_ref(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_referencialaltim_fk FOREIGN KEY (referencialaltim) REFERENCES dominios.referencial_altim(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_referencialgrav_fk FOREIGN KEY (referencialgrav) REFERENCES dominios.referencial_grav(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_redereferencia_fk FOREIGN KEY (redereferencia) REFERENCES dominios.rede_referencia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_comporta_p ADD CONSTRAINT hid_comporta_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_comporta_p ADD CONSTRAINT hid_comporta_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_comporta_p ADD CONSTRAINT hid_comporta_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_entroncamento_area_a ADD CONSTRAINT cbge_entroncamento_area_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_entroncamento_area_a ADD CONSTRAINT cbge_entroncamento_area_a_tipoentroncamento_fk FOREIGN KEY (tipoentroncamento) REFERENCES dominios.tipo_entroncamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_nome_local_p ADD CONSTRAINT lml_nome_local_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_p ADD CONSTRAINT emu_rampa_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_p ADD CONSTRAINT emu_rampa_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_p ADD CONSTRAINT emu_rampa_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_p ADD CONSTRAINT emu_rampa_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_p ADD CONSTRAINT emu_rampa_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_agropec_ext_veg_pesca_a ADD CONSTRAINT cbge_area_agropec_ext_veg_pesca_a_tipoarea_fk FOREIGN KEY (tipoarea) REFERENCES dominios.tipo_area(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_agropec_ext_veg_pesca_a ADD CONSTRAINT cbge_area_agropec_ext_veg_pesca_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_l ADD CONSTRAINT emu_rampa_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_l ADD CONSTRAINT emu_rampa_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_l ADD CONSTRAINT emu_rampa_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_l ADD CONSTRAINT emu_rampa_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_l ADD CONSTRAINT emu_rampa_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_p ADD CONSTRAINT enc_central_geradora_eolica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_p ADD CONSTRAINT enc_central_geradora_eolica_p_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_p ADD CONSTRAINT enc_central_geradora_eolica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_p ADD CONSTRAINT enc_central_geradora_eolica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_grupo_transformadores_a ADD CONSTRAINT enc_grupo_transformadores_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_alteracao_fisiografica_antropica_a ADD CONSTRAINT rel_alteracao_fisiografica_antropica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_alteracao_fisiografica_antropica_a ADD CONSTRAINT rel_alteracao_fisiografica_antropica_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_a ADD CONSTRAINT hid_canal_a_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_a ADD CONSTRAINT hid_canal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_a ADD CONSTRAINT hid_canal_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_a ADD CONSTRAINT hid_canal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_a ADD CONSTRAINT hid_canal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_canal_a ADD CONSTRAINT hid_canal_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_sargeta_fk FOREIGN KEY (sargeta) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_tipovia_fk FOREIGN KEY (tipovia) REFERENCES dominios.tipo_via(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_meiofio_fk FOREIGN KEY (meiofio) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_trecho_arruamento_l ADD CONSTRAINT cbge_trecho_arruamento_l_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_a ADD CONSTRAINT emu_rampa_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_a ADD CONSTRAINT emu_rampa_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_a ADD CONSTRAINT emu_rampa_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_a ADD CONSTRAINT emu_rampa_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_rampa_a ADD CONSTRAINT emu_rampa_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_geod_topo_controle_p ADD CONSTRAINT pto_pto_geod_topo_controle_p_sistemageodesico_fk FOREIGN KEY (sistemageodesico) REFERENCES dominios.sistema_geodesico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_geod_topo_controle_p ADD CONSTRAINT pto_pto_geod_topo_controle_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_geod_topo_controle_p ADD CONSTRAINT pto_pto_geod_topo_controle_p_tiporef_fk FOREIGN KEY (tiporef) REFERENCES dominios.tipo_ref(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.pto_pto_geod_topo_controle_p ADD CONSTRAINT pto_pto_geod_topo_controle_p_referencialaltim_fk FOREIGN KEY (referencialaltim) REFERENCES dominios.referencial_altim(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_tipoinstalmilitar_fk FOREIGN KEY (tipoinstalmilitar) REFERENCES dominios.tipo_instal_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_terreno_sujeito_inundacao_a ADD CONSTRAINT hid_terreno_sujeito_inundacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_tipopassagviad_fk FOREIGN KEY (tipopassagviad) REFERENCES dominios.tipo_passag_viad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_gruta_caverna_l ADD CONSTRAINT rel_gruta_caverna_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_gruta_caverna_l ADD CONSTRAINT rel_gruta_caverna_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_especie_fk FOREIGN KEY (especie) REFERENCES dominios.especie_trecho_energia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_sin_fk FOREIGN KEY (sin) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_cemiterio_p ADD CONSTRAINT cbge_cemiterio_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_cemiterio_p ADD CONSTRAINT cbge_cemiterio_p_destinacaocemiterio_fk FOREIGN KEY (destinacaocemiterio) REFERENCES dominios.tipo_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_cemiterio_p ADD CONSTRAINT cbge_cemiterio_p_tipocemiterio_fk FOREIGN KEY (tipocemiterio) REFERENCES dominios.tipo_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_cemiterio_p ADD CONSTRAINT cbge_cemiterio_p_denominacaoassociada_fk FOREIGN KEY (denominacaoassociada) REFERENCES dominios.denominacao_associada(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_corte_a ADD CONSTRAINT rel_corte_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_corte_a ADD CONSTRAINT rel_corte_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_tipodepgeral_fk FOREIGN KEY (tipodepgeral) REFERENCES dominios.tipo_dep_geral(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_sitio_arqueologico_p ADD CONSTRAINT laz_sitio_arqueologico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_sitio_arqueologico_p ADD CONSTRAINT laz_sitio_arqueologico_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_sitio_arqueologico_p ADD CONSTRAINT laz_sitio_arqueologico_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_retorno_p ADD CONSTRAINT cbge_retorno_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_tipotunel_fk FOREIGN KEY (tipotunel) REFERENCES dominios.tipo_tunel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_p ADD CONSTRAINT emu_acesso_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_p ADD CONSTRAINT emu_acesso_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_p ADD CONSTRAINT emu_acesso_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_p ADD CONSTRAINT emu_acesso_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_p ADD CONSTRAINT emu_acesso_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_tipolavoura_fk FOREIGN KEY (tipolavoura) REFERENCES dominios.tipo_lavoura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_a ADD CONSTRAINT hid_vala_a_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_a ADD CONSTRAINT hid_vala_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_a ADD CONSTRAINT hid_vala_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_a ADD CONSTRAINT hid_vala_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_a ADD CONSTRAINT hid_vala_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_a ADD CONSTRAINT hid_vala_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_causaexposicao_fk FOREIGN KEY (causaexposicao) REFERENCES dominios.causa_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_tipoterrexp_fk FOREIGN KEY (tipoterrexp) REFERENCES dominios.tipo_terreno_exposto(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_trecho_hidroviario_l ADD CONSTRAINT hdv_trecho_hidroviario_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_trecho_hidroviario_l ADD CONSTRAINT hdv_trecho_hidroviario_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_trecho_hidroviario_l ADD CONSTRAINT hdv_trecho_hidroviario_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_trecho_hidroviario_l ADD CONSTRAINT hdv_trecho_hidroviario_l_regime_fk FOREIGN KEY (regime) REFERENCES dominios.regime(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_retorno_l ADD CONSTRAINT cbge_retorno_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_area_politico_administrativa_a ADD CONSTRAINT lml_area_politico_administrativa_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campo_a ADD CONSTRAINT veg_campo_a_tipocampo_fk FOREIGN KEY (tipocampo) REFERENCES dominios.tipo_campo(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campo_a ADD CONSTRAINT veg_campo_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campo_a ADD CONSTRAINT veg_campo_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campo_a ADD CONSTRAINT veg_campo_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campo_a ADD CONSTRAINT veg_campo_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_campo_a ADD CONSTRAINT veg_campo_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_sitio_arqueologico_a ADD CONSTRAINT laz_sitio_arqueologico_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_sitio_arqueologico_a ADD CONSTRAINT laz_sitio_arqueologico_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_sitio_arqueologico_a ADD CONSTRAINT laz_sitio_arqueologico_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.ver_arvore_isolada_p ADD CONSTRAINT ver_arvore_isolada_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_p ADD CONSTRAINT emu_elevador_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_p ADD CONSTRAINT emu_elevador_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_p ADD CONSTRAINT emu_elevador_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_p ADD CONSTRAINT emu_elevador_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_p ADD CONSTRAINT emu_elevador_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_elevador_p ADD CONSTRAINT emu_elevador_p_tipoelevador_fk FOREIGN KEY (tipoelevador) REFERENCES dominios.tipo_elevador(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_atividade_fk FOREIGN KEY (atividade) REFERENCES dominios.atividade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_tipoextmin_fk FOREIGN KEY (tipoextmin) REFERENCES dominios.tipo_ext_min(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_procextracao_fk FOREIGN KEY (procextracao) REFERENCES dominios.proc_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_tipopocomina_fk FOREIGN KEY (tipopocomina) REFERENCES dominios.tipo_poco_mina(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_formaextracao_fk FOREIGN KEY (formaextracao) REFERENCES dominios.forma_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_l ADD CONSTRAINT emu_acesso_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_l ADD CONSTRAINT emu_acesso_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_l ADD CONSTRAINT emu_acesso_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_l ADD CONSTRAINT emu_acesso_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.emu_acesso_l ADD CONSTRAINT emu_acesso_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_gruta_caverna_p ADD CONSTRAINT rel_gruta_caverna_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_gruta_caverna_p ADD CONSTRAINT rel_gruta_caverna_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_l ADD CONSTRAINT hid_vala_l_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_l ADD CONSTRAINT hid_vala_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_l ADD CONSTRAINT hid_vala_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_l ADD CONSTRAINT hid_vala_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_l ADD CONSTRAINT hid_vala_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_vala_l ADD CONSTRAINT hid_vala_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_conservacao_a ADD CONSTRAINT lml_unidade_conservacao_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_conservacao_a ADD CONSTRAINT lml_unidade_conservacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_conservacao_a ADD CONSTRAINT lml_unidade_conservacao_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_conservacao_a ADD CONSTRAINT lml_unidade_conservacao_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_corte_l ADD CONSTRAINT rel_corte_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_corte_l ADD CONSTRAINT rel_corte_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_terra_indigena_a ADD CONSTRAINT lml_terra_indigena_a_situacaojuridica_fk FOREIGN KEY (situacaojuridica) REFERENCES dominios.situacao_juridica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_terra_indigena_a ADD CONSTRAINT lml_terra_indigena_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_terra_indigena_a ADD CONSTRAINT lml_terra_indigena_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_terra_indigena_a ADD CONSTRAINT lml_terra_indigena_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_tipoquebramolhe_fk FOREIGN KEY (tipoquebramolhe) REFERENCES dominios.tipo_quebra_molhe(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_curva_nivel_l ADD CONSTRAINT rel_curva_nivel_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_curva_nivel_l ADD CONSTRAINT rel_curva_nivel_l_tipocurvanivel_fk FOREIGN KEY (tipocurvanivel) REFERENCES dominios.tipo_curva_nivel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_curva_nivel_l ADD CONSTRAINT rel_curva_nivel_l_depressao_fk FOREIGN KEY (depressao) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_tipoquebramolhe_fk FOREIGN KEY (tipoquebramolhe) REFERENCES dominios.tipo_quebra_molhe(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_piscina_a ADD CONSTRAINT laz_piscina_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_piscina_a ADD CONSTRAINT laz_piscina_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.laz_piscina_a ADD CONSTRAINT laz_piscina_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_a ADD CONSTRAINT enc_central_geradora_eolica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_a ADD CONSTRAINT enc_central_geradora_eolica_a_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_a ADD CONSTRAINT enc_central_geradora_eolica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_central_geradora_eolica_a ADD CONSTRAINT enc_central_geradora_eolica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_vegetacao_a ADD CONSTRAINT veg_vegetacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_vegetacao_a ADD CONSTRAINT veg_vegetacao_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_dominialidade_fk FOREIGN KEY (dominialidade) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_salgada_fk FOREIGN KEY (salgada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_artificial_fk FOREIGN KEY (artificial) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_tipomassadagua_fk FOREIGN KEY (tipomassadagua) REFERENCES dominios.tipo_massa_dagua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_regime_fk FOREIGN KEY (regime) REFERENCES dominios.regime(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_possuitrechodrenagem_fk FOREIGN KEY (possuitrechodrenagem) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_uso_especifico_a ADD CONSTRAINT cbge_area_uso_especifico_a_tipoarea_fk FOREIGN KEY (tipoarea) REFERENCES dominios.tipo_area(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_situacaoagua_fk FOREIGN KEY (situacaoagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_mangue_a ADD CONSTRAINT veg_mangue_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_mangue_a ADD CONSTRAINT veg_mangue_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_mangue_a ADD CONSTRAINT veg_mangue_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_mangue_a ADD CONSTRAINT veg_mangue_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_mangue_a ADD CONSTRAINT veg_mangue_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_mangue_a ADD CONSTRAINT veg_mangue_a_tipomanguezal_fk FOREIGN KEY (tipomanguezal) REFERENCES dominios.tipo_manguezal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_area_urbana_isolada_a ADD CONSTRAINT lml_area_urbana_isolada_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_area_urbana_isolada_a ADD CONSTRAINT lml_area_urbana_isolada_a_tipoassociado_fk FOREIGN KEY (tipoassociado) REFERENCES dominios.tipo_associado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_tipoinstalmilitar_fk FOREIGN KEY (tipoinstalmilitar) REFERENCES dominios.tipo_instal_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_caminho_carrocavel_l ADD CONSTRAINT tra_caminho_carrocavel_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_canteiro_central_l ADD CONSTRAINT cbge_canteiro_central_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_canteiro_central_l ADD CONSTRAINT cbge_canteiro_central_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_tipoponte_fk FOREIGN KEY (tipoponte) REFERENCES dominios.tipo_ponte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_coletiva_fk FOREIGN KEY (coletiva) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_isolada_fk FOREIGN KEY (isolada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protegida_a ADD CONSTRAINT lml_unidade_protegida_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protegida_a ADD CONSTRAINT lml_unidade_protegida_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protegida_a ADD CONSTRAINT lml_unidade_protegida_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_unidade_protegida_a ADD CONSTRAINT lml_unidade_protegida_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_delimitacao_fisica_l ADD CONSTRAINT cbge_delimitacao_fisica_l_eletrificada_fk FOREIGN KEY (eletrificada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_delimitacao_fisica_l ADD CONSTRAINT cbge_delimitacao_fisica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_delimitacao_fisica_l ADD CONSTRAINT cbge_delimitacao_fisica_l_tipodelimfis_fk FOREIGN KEY (tipodelimfis) REFERENCES dominios.tipo_delim_fis(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_a ADD CONSTRAINT rel_rocha_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_a ADD CONSTRAINT rel_rocha_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_a ADD CONSTRAINT rel_rocha_a_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_p ADD CONSTRAINT hdv_obstaculo_navegacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_p ADD CONSTRAINT hdv_obstaculo_navegacao_p_tipoobst_fk FOREIGN KEY (tipoobst) REFERENCES dominios.tipo_obst(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hdv_obstaculo_navegacao_p ADD CONSTRAINT hdv_obstaculo_navegacao_p_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_de_propriedade_particular_a ADD CONSTRAINT cbge_area_de_propriedade_particular_a_tipoarea_fk FOREIGN KEY (tipoarea) REFERENCES dominios.tipo_area(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_de_propriedade_particular_a ADD CONSTRAINT cbge_area_de_propriedade_particular_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_praca_a ADD CONSTRAINT cbge_praca_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_praca_a ADD CONSTRAINT cbge_praca_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_queda_dagua_a ADD CONSTRAINT hid_queda_dagua_a_tipoqueda_fk FOREIGN KEY (tipoqueda) REFERENCES dominios.tipo_queda(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_queda_dagua_a ADD CONSTRAINT hid_queda_dagua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_tiporepdiplomatica_fk FOREIGN KEY (tiporepdiplomatica) REFERENCES dominios.tipo_rep_diplomatica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_plataforma_p ADD CONSTRAINT eco_plataforma_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_plataforma_p ADD CONSTRAINT eco_plataforma_p_tipoplataforma_fk FOREIGN KEY (tipoplataforma) REFERENCES dominios.tipo_plataforma(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_tipopassagviad_fk FOREIGN KEY (tipopassagviad) REFERENCES dominios.tipo_passag_viad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_isolinha_hipsometrica_l ADD CONSTRAINT rel_isolinha_hipsometrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_l ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_l ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_l ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_est_gerad_energia_eletrica_l ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_tipotunel_fk FOREIGN KEY (tipotunel) REFERENCES dominios.tipo_tunel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_antena_comunic_p ADD CONSTRAINT enc_antena_comunic_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_antena_comunic_p ADD CONSTRAINT enc_antena_comunic_p_posicaoreledific_fk FOREIGN KEY (posicaoreledific) REFERENCES dominios.posicao_rel_edific(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_p ADD CONSTRAINT rel_rocha_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_p ADD CONSTRAINT rel_rocha_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_rocha_p ADD CONSTRAINT rel_rocha_p_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_energia_p ADD CONSTRAINT enc_torre_energia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_energia_p ADD CONSTRAINT enc_torre_energia_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_energia_p ADD CONSTRAINT enc_torre_energia_p_ovgd_fk FOREIGN KEY (ovgd) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_torre_energia_p ADD CONSTRAINT enc_torre_energia_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.hid_dique_a ADD CONSTRAINT hid_dique_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_aterro_p ADD CONSTRAINT rel_aterro_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_aterro_p ADD CONSTRAINT rel_aterro_p_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_poste_p ADD CONSTRAINT cbge_poste_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_poste_p ADD CONSTRAINT cbge_poste_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_tipoinstalmilitar_fk FOREIGN KEY (tipoinstalmilitar) REFERENCES dominios.tipo_instal_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.enc_zona_linhas_energia_comunicacao_a ADD CONSTRAINT enc_zona_linhas_energia_comunicacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_tipoequipagropec_fk FOREIGN KEY (tipoequipagropec) REFERENCES dominios.tipo_equip_agropec(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_elemento_fisiografico_natural_l ADD CONSTRAINT rel_elemento_fisiografico_natural_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_elemento_fisiografico_natural_l ADD CONSTRAINT rel_elemento_fisiografico_natural_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_tipoequipagropec_fk FOREIGN KEY (tipoequipagropec) REFERENCES dominios.tipo_equip_agropec(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_tipoinstalmilitar_fk FOREIGN KEY (tipoinstalmilitar) REFERENCES dominios.tipo_instal_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_tipodepgeral_fk FOREIGN KEY (tipodepgeral) REFERENCES dominios.tipo_dep_geral(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_barragem_calcadao_a ADD CONSTRAINT snb_barragem_calcadao_a_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.snb_barragem_calcadao_a ADD CONSTRAINT snb_barragem_calcadao_a_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.cbge_area_construida_a ADD CONSTRAINT cbge_area_construida_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_elemento_fisiografico_natural_a ADD CONSTRAINT rel_elemento_fisiografico_natural_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rel_elemento_fisiografico_natural_a ADD CONSTRAINT rel_elemento_fisiografico_natural_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_terra_publica_a ADD CONSTRAINT lml_terra_publica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_terra_publica_a ADD CONSTRAINT lml_terra_publica_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.lml_terra_publica_a ADD CONSTRAINT lml_terra_publica_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_tipovia_fk FOREIGN KEY (tipovia) REFERENCES dominios.tipo_via(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.rod_via_deslocamento_a ADD CONSTRAINT rod_via_deslocamento_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.snb_complexo_abast_agua ADD CONSTRAINT snb_complexo_abast_agua_tiposaneamentobasico_fk FOREIGN KEY (tiposaneamentobasico) REFERENCES dominios.tipo_saneamento_basico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.snb_complexo_abast_agua ADD CONSTRAINT snb_complexo_abast_agua_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.snb_complexo_abast_agua ADD CONSTRAINT snb_complexo_abast_agua_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.snb_complexo_abast_agua ADD CONSTRAINT snb_complexo_abast_agua_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_complexo_comunicacao ADD CONSTRAINT enc_complexo_comunicacao_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_complexo_comunicacao ADD CONSTRAINT enc_complexo_comunicacao_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lml_aglomerado_rural_de_extensao_urbana ADD CONSTRAINT lml_aglomerado_rural_de_extensao_urbana_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rel_arquipelago ADD CONSTRAINT rel_arquipelago_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.snb_complexo_saneamento ADD CONSTRAINT snb_complexo_saneamento_tiposaneamentobasico_fk FOREIGN KEY (tiposaneamentobasico) REFERENCES dominios.tipo_saneamento_basico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.snb_complexo_saneamento ADD CONSTRAINT snb_complexo_saneamento_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.snb_complexo_saneamento ADD CONSTRAINT snb_complexo_saneamento_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.snb_complexo_saneamento ADD CONSTRAINT snb_complexo_saneamento_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lml_capital ADD CONSTRAINT lml_capital_tipocapital_fk FOREIGN KEY (tipocapital) REFERENCES dominios.tipo_capital(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lml_capital ADD CONSTRAINT lml_capital_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lml_localidade ADD CONSTRAINT lml_localidade_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lml_cidade ADD CONSTRAINT lml_cidade_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_tipocomplexoportuario_fk FOREIGN KEY (tipocomplexoportuario) REFERENCES dominios.tipo_complexo_portuario(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_tipotransporte_fk FOREIGN KEY (tipotransporte) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_portosempapel_fk FOREIGN KEY (portosempapel) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_complexo_gerador_energia_eletrica ADD CONSTRAINT enc_complexo_gerador_energia_eletrica_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_complexo_gerador_energia_eletrica ADD CONSTRAINT enc_complexo_gerador_energia_eletrica_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_entroncamento ADD CONSTRAINT tra_entroncamento_tipoentroncamento_fk FOREIGN KEY (tipoentroncamento) REFERENCES dominios.tipo_entroncamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lml_aglomerado_rural_isolado ADD CONSTRAINT lml_aglomerado_rural_isolado_tipoaglomrurisol_fk FOREIGN KEY (tipoaglomrurisol) REFERENCES dominios.tipo_aglom_rur_isol(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lml_aglomerado_rural_isolado ADD CONSTRAINT lml_aglomerado_rural_isolado_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.cbge_assentamento_precario ADD CONSTRAINT cbge_assentamento_precario_tipoassprec_fk FOREIGN KEY (tipoassprec) REFERENCES dominios.tipo_assentamento_precario(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.ver_area_verde ADD CONSTRAINT ver_area_verde_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.ver_area_verde ADD CONSTRAINT ver_area_verde_paisagismo_fk FOREIGN KEY (paisagismo) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lml_aglomerado_rural ADD CONSTRAINT lml_aglomerado_rural_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_subest_transm_distrib_energia_eletrica ADD CONSTRAINT enc_subest_transm_distrib_energia_eletrica_centrodecarga_fk FOREIGN KEY (centrodecarga) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_subest_transm_distrib_energia_eletrica ADD CONSTRAINT enc_subest_transm_distrib_energia_eletrica_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_subest_transm_distrib_energia_eletrica ADD CONSTRAINT enc_subest_transm_distrib_energia_eletrica_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_tipocomplexoaero_fk FOREIGN KEY (tipocomplexoaero) REFERENCES dominios.tipo_complexo_aeroportuario(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_classificacao_fk FOREIGN KEY (classificacao) REFERENCES dominios.classificacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.auxiliar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_l ADD CONSTRAINT aux_descontinuidade_geometrica_l_categoria_fk FOREIGN KEY (categoria) REFERENCES dominios.categoria(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_l ADD CONSTRAINT aux_descontinuidade_geometrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_p ADD CONSTRAINT aux_descontinuidade_geometrica_p_categoria_fk FOREIGN KEY (categoria) REFERENCES dominios.categoria(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_p ADD CONSTRAINT aux_descontinuidade_geometrica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_dique_p ADD CONSTRAINT hid_dique_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_mattransp_check CHECK (mattransp <@ ARRAY[1::SMALLINT,2::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_tipotrechoduto_check CHECK (tipotrechoduto = ANY(ARRAY[4,5]))#
ALTER TABLE edgv.rel_pico_p ADD CONSTRAINT rel_pico_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[22]))#
ALTER TABLE edgv.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_finalidade_check CHECK (finalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_tipoedifcomercserv_check CHECK (tipoedifcomercserv <@ ARRAY[19::SMALLINT])#
ALTER TABLE edgv.hid_barragem_p ADD CONSTRAINT hid_barragem_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.ver_jardim_a ADD CONSTRAINT ver_jardim_a_finalidade_check CHECK (finalidade = ANY(ARRAY[4]))#
ALTER TABLE edgv.ver_jardim_a ADD CONSTRAINT ver_jardim_a_cultivopredominante_check CHECK (cultivopredominante <@ ARRAY[1::SMALLINT,10::SMALLINT,100::SMALLINT,101::SMALLINT,102::SMALLINT,103::SMALLINT,104::SMALLINT,105::SMALLINT,106::SMALLINT,108::SMALLINT,11::SMALLINT,110::SMALLINT,111::SMALLINT,112::SMALLINT,113::SMALLINT,114::SMALLINT,115::SMALLINT,116::SMALLINT,117::SMALLINT,118::SMALLINT,119::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,4::SMALLINT,42::SMALLINT,43::SMALLINT,44::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,7::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,8::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,9::SMALLINT,90::SMALLINT,96::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_ilha_a ADD CONSTRAINT hid_ilha_a_tipoilha_check CHECK (tipoilha <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT])#
ALTER TABLE edgv.hid_ilha_a ADD CONSTRAINT hid_ilha_a_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[21]))#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_barragem_a ADD CONSTRAINT hid_barragem_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_barragem_l ADD CONSTRAINT hid_barragem_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_tipodepgeral_check CHECK (tipodepgeral <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,19::SMALLINT,2::SMALLINT,26::SMALLINT,3::SMALLINT,32::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_tipoconteudo_check CHECK (tipoconteudo <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT])#
ALTER TABLE edgv.snb_dep_abast_agua_p ADD CONSTRAINT snb_dep_abast_agua_p_tipoprodutoresiduo_check CHECK (tipoprodutoresiduo <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_a ADD CONSTRAINT tra_passagem_elevada_viaduto_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_turistica_check CHECK (turistica = ANY(ARRAY[1]))#
ALTER TABLE edgv.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_modalidade_check CHECK (modalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1]))#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[2]))#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[30]))#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[2]))#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[6]))#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1]))#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[2]))#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_tipoedifagropec_check CHECK (tipoedifagropec <@ ARRAY[12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[3]))#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[5]))#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_area_habitacional_a ADD CONSTRAINT cbge_area_habitacional_a_tipoarea_check CHECK (tipoarea = ANY(ARRAY[2]))#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_tipoedifagropec_check CHECK (tipoedifagropec <@ ARRAY[12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[3]))#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[5]))#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_tipoedifport_check CHECK (tipoedifport <@ ARRAY[15::SMALLINT,26::SMALLINT,27::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.laz_ruina_p ADD CONSTRAINT laz_ruina_p_cultura_check CHECK (cultura = ANY(ARRAY[1]))#
ALTER TABLE edgv.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_tipoveg_check CHECK (tipoveg <@ ARRAY[10::SMALLINT,11::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT])#
ALTER TABLE edgv.rel_corte_p ADD CONSTRAINT rel_corte_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_corte_p ADD CONSTRAINT rel_corte_p_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[26]))#
ALTER TABLE edgv.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[30,31]))#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_ponte_p ADD CONSTRAINT tra_ponte_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.enc_central_geradora_eolica_l ADD CONSTRAINT enc_central_geradora_eolica_l_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[5]))#
ALTER TABLE edgv.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[8]))#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_ponte_l ADD CONSTRAINT tra_ponte_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.enc_central_geradora_eolica_a ADD CONSTRAINT enc_central_geradora_eolica_a_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[5]))#
ALTER TABLE edgv.rel_aterro_l ADD CONSTRAINT rel_aterro_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_aterro_l ADD CONSTRAINT rel_aterro_l_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[27]))#
ALTER TABLE edgv.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_aptidaooperacional_check CHECK (aptidaooperacional <@ ARRAY[2::SMALLINT,3::SMALLINT])#
ALTER TABLE edgv.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.lml_unidade_uso_sustentavel_a ADD CONSTRAINT lml_unidade_uso_sustentavel_a_tipounidprotegida_check CHECK (tipounidprotegida = ANY(ARRAY[3]))#
ALTER TABLE edgv.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_aptidaooperacional_check CHECK (aptidaooperacional <@ ARRAY[2::SMALLINT,3::SMALLINT])#
ALTER TABLE edgv.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_aptidaooperacional_check CHECK (aptidaooperacional <@ ARRAY[2::SMALLINT,3::SMALLINT])#
ALTER TABLE edgv.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_tipoproduto_check CHECK (tipoproduto <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[32]))#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_cultivopredominante_check CHECK (cultivopredominante <@ ARRAY[1::SMALLINT,10::SMALLINT,100::SMALLINT,101::SMALLINT,102::SMALLINT,103::SMALLINT,104::SMALLINT,105::SMALLINT,106::SMALLINT,108::SMALLINT,11::SMALLINT,110::SMALLINT,111::SMALLINT,112::SMALLINT,113::SMALLINT,114::SMALLINT,115::SMALLINT,116::SMALLINT,117::SMALLINT,118::SMALLINT,119::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,4::SMALLINT,42::SMALLINT,43::SMALLINT,44::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,7::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,8::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,9::SMALLINT,90::SMALLINT,96::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_tipoedifmetroferrov_check CHECK (tipoedifmetroferrov <@ ARRAY[15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_estacionamento_a ADD CONSTRAINT cbge_estacionamento_a_modaluso_check CHECK (modaluso <@ ARRAY[4::SMALLINT])#
ALTER TABLE edgv.cbge_estacionamento_a ADD CONSTRAINT cbge_estacionamento_a_finalidadepatio_check CHECK (finalidadepatio <@ ARRAY[3::SMALLINT])#
ALTER TABLE edgv.cbge_estacionamento_a ADD CONSTRAINT cbge_estacionamento_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_tipoedifrod_check CHECK (tipoedifrod <@ ARRAY[10::SMALLINT,13::SMALLINT,15::SMALLINT,20::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[9]))#
ALTER TABLE edgv.tra_obra_de_arte_viaria_p ADD CONSTRAINT tra_obra_de_arte_viaria_p_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_obra_de_arte_viaria_p ADD CONSTRAINT tra_obra_de_arte_viaria_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_passeio_l ADD CONSTRAINT cbge_passeio_l_pavimentacao_check CHECK (pavimentacao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.emu_poste_sinalizacao_p ADD CONSTRAINT emu_poste_sinalizacao_p_tipoposte_check CHECK (tipoposte <@ ARRAY[5::SMALLINT])#
ALTER TABLE edgv.lml_unidade_protecao_integral_a ADD CONSTRAINT lml_unidade_protecao_integral_a_tipounidprotegida_check CHECK (tipounidprotegida = ANY(ARRAY[2]))#
ALTER TABLE edgv.tra_obra_de_arte_viaria_l ADD CONSTRAINT tra_obra_de_arte_viaria_l_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_obra_de_arte_viaria_l ADD CONSTRAINT tra_obra_de_arte_viaria_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[9]))#
ALTER TABLE edgv.tra_obra_de_arte_viaria_a ADD CONSTRAINT tra_obra_de_arte_viaria_a_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_obra_de_arte_viaria_a ADD CONSTRAINT tra_obra_de_arte_viaria_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_passeio_a ADD CONSTRAINT cbge_passeio_a_pavimentacao_check CHECK (pavimentacao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_modalidade_check CHECK (modalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_tipoedifcomunic_check CHECK (tipoedifcomunic <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[8]))#
ALTER TABLE edgv.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[8]))#
ALTER TABLE edgv.rel_dolina_a ADD CONSTRAINT rel_dolina_a_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[16]))#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_turistica_check CHECK (turistica = ANY(ARRAY[1]))#
ALTER TABLE edgv.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_modalidade_check CHECK (modalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_tipoedifcomunic_check CHECK (tipoedifcomunic <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_rocha_l ADD CONSTRAINT rel_rocha_l_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[23]))#
ALTER TABLE edgv.lml_posic_geo_localidade_p ADD CONSTRAINT lml_posic_geo_localidade_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0]))#
ALTER TABLE edgv.tra_patio_a ADD CONSTRAINT tra_patio_a_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_patio_a ADD CONSTRAINT tra_patio_a_finalidadepatio_check CHECK (finalidadepatio <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.tra_patio_a ADD CONSTRAINT tra_patio_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_mattransp_check CHECK (mattransp <@ ARRAY[1::SMALLINT,2::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_dolina_p ADD CONSTRAINT rel_dolina_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[16]))#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_duna_p ADD CONSTRAINT rel_duna_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[17]))#
ALTER TABLE edgv.cbge_area_duto_a ADD CONSTRAINT cbge_area_duto_a_tipoarea_check CHECK (tipoarea = ANY(ARRAY[3]))#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_tipoedifenergia_check CHECK (tipoedifenergia <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_tipoconteudo_check CHECK (tipoconteudo <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT])#
ALTER TABLE edgv.snb_dep_saneamento_a ADD CONSTRAINT snb_dep_saneamento_a_tipoprodutoresiduo_check CHECK (tipoprodutoresiduo <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_ilha_p ADD CONSTRAINT hid_ilha_p_tipoilha_check CHECK (tipoilha <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT])#
ALTER TABLE edgv.hid_ilha_p ADD CONSTRAINT hid_ilha_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[21]))#
ALTER TABLE edgv.hid_ilha_l ADD CONSTRAINT hid_ilha_l_tipoilha_check CHECK (tipoilha <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT])#
ALTER TABLE edgv.hid_ilha_l ADD CONSTRAINT hid_ilha_l_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[21]))#
ALTER TABLE edgv.rel_duna_a ADD CONSTRAINT rel_duna_a_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[17]))#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_cultivopredominante_check CHECK (cultivopredominante <@ ARRAY[1::SMALLINT,10::SMALLINT,100::SMALLINT,101::SMALLINT,102::SMALLINT,103::SMALLINT,104::SMALLINT,105::SMALLINT,106::SMALLINT,108::SMALLINT,11::SMALLINT,110::SMALLINT,111::SMALLINT,112::SMALLINT,113::SMALLINT,114::SMALLINT,115::SMALLINT,116::SMALLINT,117::SMALLINT,118::SMALLINT,119::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,4::SMALLINT,42::SMALLINT,43::SMALLINT,44::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,7::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,8::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,9::SMALLINT,90::SMALLINT,96::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[23]))#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_tipoedifenergia_check CHECK (tipoedifenergia <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[23]))#
ALTER TABLE edgv.rel_duna_l ADD CONSTRAINT rel_duna_l_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[17]))#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_tunel_a ADD CONSTRAINT tra_tunel_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_tunel_p ADD CONSTRAINT tra_tunel_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.laz_ruina_a ADD CONSTRAINT laz_ruina_a_cultura_check CHECK (cultura = ANY(ARRAY[1]))#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_finalidade_check CHECK (finalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_tipoedifcomercserv_check CHECK (tipoedifcomercserv <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_area_agropec_ext_veg_pesca_a ADD CONSTRAINT cbge_area_agropec_ext_veg_pesca_a_tipoarea_check CHECK (tipoarea = ANY(ARRAY[4]))#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.enc_central_geradora_eolica_p ADD CONSTRAINT enc_central_geradora_eolica_p_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[5]))#
ALTER TABLE edgv.hid_canal_l ADD CONSTRAINT hid_canal_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_canal_l ADD CONSTRAINT hid_canal_l_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[30]))#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_finalidade_check CHECK (finalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_tipoedifcomercserv_check CHECK (tipoedifcomercserv <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_canal_a ADD CONSTRAINT hid_canal_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_canal_a ADD CONSTRAINT hid_canal_a_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[30]))#
ALTER TABLE edgv.hid_terreno_sujeito_inundacao_a ADD CONSTRAINT hid_terreno_sujeito_inundacao_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[1]))#
ALTER TABLE edgv.rel_gruta_caverna_l ADD CONSTRAINT rel_gruta_caverna_l_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[15,20]))#
ALTER TABLE edgv.rel_corte_a ADD CONSTRAINT rel_corte_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_corte_a ADD CONSTRAINT rel_corte_a_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[26]))#
ALTER TABLE edgv.laz_sitio_arqueologico_p ADD CONSTRAINT laz_sitio_arqueologico_p_cultura_check CHECK (cultura = ANY(ARRAY[1]))#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_tunel_l ADD CONSTRAINT tra_tunel_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_vala_a ADD CONSTRAINT hid_vala_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_vala_a ADD CONSTRAINT hid_vala_a_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[31]))#
ALTER TABLE edgv.veg_campo_a ADD CONSTRAINT veg_campo_a_densidade_check CHECK (densidade = ANY(ARRAY[2]))#
ALTER TABLE edgv.laz_sitio_arqueologico_a ADD CONSTRAINT laz_sitio_arqueologico_a_cultura_check CHECK (cultura = ANY(ARRAY[1]))#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_tipoproduto_check CHECK (tipoproduto <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[32]))#
ALTER TABLE edgv.rel_gruta_caverna_p ADD CONSTRAINT rel_gruta_caverna_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[15,20]))#
ALTER TABLE edgv.lml_unidade_conservacao_a ADD CONSTRAINT lml_unidade_conservacao_a_tipounidprotegida_check CHECK (tipounidprotegida = ANY(ARRAY[4]))#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_corte_l ADD CONSTRAINT rel_corte_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_corte_l ADD CONSTRAINT rel_corte_l_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[26]))#
ALTER TABLE edgv.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_tipoedifrod_check CHECK (tipoedifrod <@ ARRAY[10::SMALLINT,13::SMALLINT,15::SMALLINT,20::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_vala_l ADD CONSTRAINT hid_vala_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_vala_l ADD CONSTRAINT hid_vala_l_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[31]))#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_tipoedifmetroferrov_check CHECK (tipoedifmetroferrov <@ ARRAY[15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_tipodepgeral_check CHECK (tipodepgeral <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,19::SMALLINT,2::SMALLINT,26::SMALLINT,3::SMALLINT,32::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_tipoconteudo_check CHECK (tipoconteudo <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT])#
ALTER TABLE edgv.snb_dep_abast_agua_a ADD CONSTRAINT snb_dep_abast_agua_a_tipoprodutoresiduo_check CHECK (tipoprodutoresiduo <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_poste_p ADD CONSTRAINT cbge_poste_p_tipoposte_check CHECK (tipoposte <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_tipoconteudo_check CHECK (tipoconteudo <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT])#
ALTER TABLE edgv.cbge_deposito_geral_a ADD CONSTRAINT cbge_deposito_geral_a_tipoprodutoresiduo_check CHECK (tipoprodutoresiduo <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_finalidade_check CHECK (finalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_tipoedifcomercserv_check CHECK (tipoedifcomercserv <@ ARRAY[19::SMALLINT])#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE edgv.tra_ponte_a ADD CONSTRAINT tra_ponte_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_delimitacao_fisica_l ADD CONSTRAINT cbge_delimitacao_fisica_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_rocha_a ADD CONSTRAINT rel_rocha_a_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[23]))#
ALTER TABLE edgv.rel_aterro_a ADD CONSTRAINT rel_aterro_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_aterro_a ADD CONSTRAINT rel_aterro_a_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[27]))#
ALTER TABLE edgv.cbge_area_de_propriedade_particular_a ADD CONSTRAINT cbge_area_de_propriedade_particular_a_tipoarea_check CHECK (tipoarea = ANY(ARRAY[1]))#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_tipodepgeral_check CHECK (tipodepgeral <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,19::SMALLINT,2::SMALLINT,26::SMALLINT,3::SMALLINT,32::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_tipoconteudo_check CHECK (tipoconteudo <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT])#
ALTER TABLE edgv.cbge_deposito_geral_p ADD CONSTRAINT cbge_deposito_geral_p_tipoprodutoresiduo_check CHECK (tipoprodutoresiduo <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_aterro_p ADD CONSTRAINT rel_aterro_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.rel_aterro_p ADD CONSTRAINT rel_aterro_p_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[27]))#
ALTER TABLE edgv.rel_rocha_p ADD CONSTRAINT rel_rocha_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[23]))#
ALTER TABLE edgv.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_dique_a ADD CONSTRAINT hid_dique_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.hid_dique_l ADD CONSTRAINT hid_dique_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_tipoedifaero_check CHECK (tipoedifaero <@ ARRAY[15::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[2]))#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[6]))#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_tipoconteudo_check CHECK (tipoconteudo <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT])#
ALTER TABLE edgv.snb_dep_saneamento_p ADD CONSTRAINT snb_dep_saneamento_p_tipoprodutoresiduo_check CHECK (tipoprodutoresiduo <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.snb_barragem_calcadao_a ADD CONSTRAINT snb_barragem_calcadao_a_tipoequipdesenvsocial_check CHECK (tipoequipdesenvsocial = ANY(ARRAY[2]))#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_tipoedifaero_check CHECK (tipoedifaero <@ ARRAY[15::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE edgv.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE complexos.snb_complexo_abast_agua ADD CONSTRAINT snb_complexo_abast_agua_tiposaneamentobasico_check CHECK (tiposaneamentobasico = ANY(ARRAY[1]))#
ALTER TABLE complexos.enc_complexo_comunicacao ADD CONSTRAINT enc_complexo_comunicacao_classeativecon_check CHECK (classeativecon = ANY(ARRAY[6]))#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92]))#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92]))#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_modaluso_check CHECK (modaluso <@ ARRAY[5::SMALLINT])#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[5]))#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_modaluso_check CHECK (modaluso <@ ARRAY[4::SMALLINT])#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1]))#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_modaluso_check CHECK (modaluso <@ ARRAY[4::SMALLINT])#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[5]))#
ALTER TABLE complexos.lml_localidade ADD CONSTRAINT lml_localidade_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0]))#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_modaluso_check CHECK (modaluso <@ ARRAY[14::SMALLINT])#
ALTER TABLE complexos.enc_complexo_gerador_energia_eletrica ADD CONSTRAINT enc_complexo_gerador_energia_eletrica_classeativecon_check CHECK (classeativecon = ANY(ARRAY[2]))#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT])#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[5]))#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_modaluso_check CHECK (modaluso <@ ARRAY[6::SMALLINT])#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1]))#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92]))#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_modaluso_check CHECK (modaluso <@ ARRAY[5::SMALLINT])#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1]))#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_modaluso_check CHECK (modaluso <@ ARRAY[9::SMALLINT])#
ALTER TABLE ONLY complexos.aer_complexo_aeroportuario ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.cbge_assentamento_precario ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.cbge_complexo_habitacional ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.cbge_condominio ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.cbge_conjunto_habitacional ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.emu_terminal_ferroviario ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.emu_terminal_hidroviario ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.emu_terminal_rodoviario ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.enc_complexo_comunicacao ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.enc_complexo_gerador_energia_eletrica ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.enc_subest_transm_distrib_energia_eletrica ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.fer_estacao_ferroviaria ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.fer_estacao_metroviaria ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.hdv_complexo_portuario ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.laz_complexo_desportivo ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.laz_complexo_desportivo_lazer ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.laz_complexo_recreativo ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.lml_aglomerado_rural ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.lml_aglomerado_rural_de_extensao_urbana ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.lml_aglomerado_rural_isolado ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.lml_aldeia_indigena ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.lml_capital ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.lml_cidade ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.lml_localidade ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.lml_vila ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.pto_est_med_fenomenos ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.rel_arquipelago ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.rod_estacao_rodoviaria ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.snb_complexo_abast_agua ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.snb_complexo_saneamento ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.tra_entroncamento ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.tra_estrut_apoio ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.tra_estrut_transporte ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.ver_area_verde ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
ALTER TABLE ONLY complexos.ver_area_verde_urbana ALTER COLUMN id SET DEFAULT uuid_generate_v4()#
CREATE INDEX aer_pista_ponto_pouso_a_gist ON edgv.aer_pista_ponto_pouso_a USING gist (geom)#
CREATE INDEX aer_pista_ponto_pouso_l_gist ON edgv.aer_pista_ponto_pouso_l USING gist (geom)#
CREATE INDEX aer_pista_ponto_pouso_p_gist ON edgv.aer_pista_ponto_pouso_p USING gist (geom)#
CREATE INDEX cbge_area_agropec_ext_veg_pesca_a_gist ON edgv.cbge_area_agropec_ext_veg_pesca_a USING gist (geom)#
CREATE INDEX cbge_area_construida_a_gist ON edgv.cbge_area_construida_a USING gist (geom)#
CREATE INDEX cbge_area_de_propriedade_particular_a_gist ON edgv.cbge_area_de_propriedade_particular_a USING gist (geom)#
CREATE INDEX cbge_area_duto_a_gist ON edgv.cbge_area_duto_a USING gist (geom)#
CREATE INDEX cbge_area_habitacional_a_gist ON edgv.cbge_area_habitacional_a USING gist (geom)#
CREATE INDEX cbge_area_uso_especifico_a_gist ON edgv.cbge_area_uso_especifico_a USING gist (geom)#
CREATE INDEX cbge_canteiro_central_a_gist ON edgv.cbge_canteiro_central_a USING gist (geom)#
CREATE INDEX cbge_canteiro_central_l_gist ON edgv.cbge_canteiro_central_l USING gist (geom)#
CREATE INDEX cbge_cemiterio_a_gist ON edgv.cbge_cemiterio_a USING gist (geom)#
CREATE INDEX cbge_cemiterio_p_gist ON edgv.cbge_cemiterio_p USING gist (geom)#
CREATE INDEX cbge_delimitacao_fisica_l_gist ON edgv.cbge_delimitacao_fisica_l USING gist (geom)#
CREATE INDEX cbge_deposito_geral_a_gist ON edgv.cbge_deposito_geral_a USING gist (geom)#
CREATE INDEX cbge_deposito_geral_p_gist ON edgv.cbge_deposito_geral_p USING gist (geom)#
CREATE INDEX cbge_entroncamento_area_a_gist ON edgv.cbge_entroncamento_area_a USING gist (geom)#
CREATE INDEX cbge_espelho_dagua_a_gist ON edgv.cbge_espelho_dagua_a USING gist (geom)#
CREATE INDEX cbge_estacionamento_a_gist ON edgv.cbge_estacionamento_a USING gist (geom)#
CREATE INDEX cbge_largo_a_gist ON edgv.cbge_largo_a USING gist (geom)#
CREATE INDEX cbge_passeio_a_gist ON edgv.cbge_passeio_a USING gist (geom)#
CREATE INDEX cbge_passeio_l_gist ON edgv.cbge_passeio_l USING gist (geom)#
CREATE INDEX cbge_poste_p_gist ON edgv.cbge_poste_p USING gist (geom)#
CREATE INDEX cbge_praca_a_gist ON edgv.cbge_praca_a USING gist (geom)#
CREATE INDEX cbge_quadra_a_gist ON edgv.cbge_quadra_a USING gist (geom)#
CREATE INDEX cbge_retorno_l_gist ON edgv.cbge_retorno_l USING gist (geom)#
CREATE INDEX cbge_retorno_p_gist ON edgv.cbge_retorno_p USING gist (geom)#
CREATE INDEX cbge_trecho_arruamento_a_gist ON edgv.cbge_trecho_arruamento_a USING gist (geom)#
CREATE INDEX cbge_trecho_arruamento_l_gist ON edgv.cbge_trecho_arruamento_l USING gist (geom)#
CREATE INDEX dut_galeria_bueiro_l_gist ON edgv.dut_galeria_bueiro_l USING gist (geom)#
CREATE INDEX dut_trecho_duto_l_gist ON edgv.dut_trecho_duto_l USING gist (geom)#
CREATE INDEX eco_equip_agropec_a_gist ON edgv.eco_equip_agropec_a USING gist (geom)#
CREATE INDEX eco_equip_agropec_l_gist ON edgv.eco_equip_agropec_l USING gist (geom)#
CREATE INDEX eco_equip_agropec_p_gist ON edgv.eco_equip_agropec_p USING gist (geom)#
CREATE INDEX eco_ext_mineral_a_gist ON edgv.eco_ext_mineral_a USING gist (geom)#
CREATE INDEX eco_ext_mineral_p_gist ON edgv.eco_ext_mineral_p USING gist (geom)#
CREATE INDEX eco_plataforma_a_gist ON edgv.eco_plataforma_a USING gist (geom)#
CREATE INDEX eco_plataforma_p_gist ON edgv.eco_plataforma_p USING gist (geom)#
CREATE INDEX edf_banheiro_publico_a_gist ON edgv.edf_banheiro_publico_a USING gist (geom)#
CREATE INDEX edf_banheiro_publico_p_gist ON edgv.edf_banheiro_publico_p USING gist (geom)#
CREATE INDEX edf_edif_abast_agua_a_gist ON edgv.edf_edif_abast_agua_a USING gist (geom)#
CREATE INDEX edf_edif_abast_agua_p_gist ON edgv.edf_edif_abast_agua_p USING gist (geom)#
CREATE INDEX edf_edif_agropec_ext_veg_pesca_a_gist ON edgv.edf_edif_agropec_ext_veg_pesca_a USING gist (geom)#
CREATE INDEX edf_edif_agropec_ext_veg_pesca_p_gist ON edgv.edf_edif_agropec_ext_veg_pesca_p USING gist (geom)#
CREATE INDEX edf_edif_comerc_serv_a_gist ON edgv.edf_edif_comerc_serv_a USING gist (geom)#
CREATE INDEX edf_edif_comerc_serv_p_gist ON edgv.edf_edif_comerc_serv_p USING gist (geom)#
CREATE INDEX edf_edif_comunic_a_gist ON edgv.edf_edif_comunic_a USING gist (geom)#
CREATE INDEX edf_edif_comunic_p_gist ON edgv.edf_edif_comunic_p USING gist (geom)#
CREATE INDEX edf_edif_constr_aeroportuaria_a_gist ON edgv.edf_edif_constr_aeroportuaria_a USING gist (geom)#
CREATE INDEX edf_edif_constr_aeroportuaria_p_gist ON edgv.edf_edif_constr_aeroportuaria_p USING gist (geom)#
CREATE INDEX edf_edif_constr_est_med_fen_a_gist ON edgv.edf_edif_constr_est_med_fen_a USING gist (geom)#
CREATE INDEX edf_edif_constr_est_med_fen_p_gist ON edgv.edf_edif_constr_est_med_fen_p USING gist (geom)#
CREATE INDEX edf_edif_constr_lazer_a_gist ON edgv.edf_edif_constr_lazer_a USING gist (geom)#
CREATE INDEX edf_edif_constr_lazer_p_gist ON edgv.edf_edif_constr_lazer_p USING gist (geom)#
CREATE INDEX edf_edif_constr_portuaria_a_gist ON edgv.edf_edif_constr_portuaria_a USING gist (geom)#
CREATE INDEX edf_edif_constr_portuaria_p_gist ON edgv.edf_edif_constr_portuaria_p USING gist (geom)#
CREATE INDEX edf_edif_constr_turistica_a_gist ON edgv.edf_edif_constr_turistica_a USING gist (geom)#
CREATE INDEX edf_edif_constr_turistica_p_gist ON edgv.edf_edif_constr_turistica_p USING gist (geom)#
CREATE INDEX edf_edif_desenv_social_a_gist ON edgv.edf_edif_desenv_social_a USING gist (geom)#
CREATE INDEX edf_edif_desenv_social_p_gist ON edgv.edf_edif_desenv_social_p USING gist (geom)#
CREATE INDEX edf_edif_energia_a_gist ON edgv.edf_edif_energia_a USING gist (geom)#
CREATE INDEX edf_edif_energia_p_gist ON edgv.edf_edif_energia_p USING gist (geom)#
CREATE INDEX edf_edif_ensino_a_gist ON edgv.edf_edif_ensino_a USING gist (geom)#
CREATE INDEX edf_edif_ensino_p_gist ON edgv.edf_edif_ensino_p USING gist (geom)#
CREATE INDEX edf_edif_ext_mineral_a_gist ON edgv.edf_edif_ext_mineral_a USING gist (geom)#
CREATE INDEX edf_edif_ext_mineral_p_gist ON edgv.edf_edif_ext_mineral_p USING gist (geom)#
CREATE INDEX edf_edif_habitacional_a_gist ON edgv.edf_edif_habitacional_a USING gist (geom)#
CREATE INDEX edf_edif_habitacional_p_gist ON edgv.edf_edif_habitacional_p USING gist (geom)#
CREATE INDEX edf_edificacao_a_gist ON edgv.edf_edificacao_a USING gist (geom)#
CREATE INDEX edf_edificacao_p_gist ON edgv.edf_edificacao_p USING gist (geom)#
CREATE INDEX edf_edif_industrial_a_gist ON edgv.edf_edif_industrial_a USING gist (geom)#
CREATE INDEX edf_edif_industrial_p_gist ON edgv.edf_edif_industrial_p USING gist (geom)#
CREATE INDEX edf_edif_metro_ferroviaria_a_gist ON edgv.edf_edif_metro_ferroviaria_a USING gist (geom)#
CREATE INDEX edf_edif_metro_ferroviaria_p_gist ON edgv.edf_edif_metro_ferroviaria_p USING gist (geom)#
CREATE INDEX edf_edif_policia_a_gist ON edgv.edf_edif_policia_a USING gist (geom)#
CREATE INDEX edf_edif_policia_p_gist ON edgv.edf_edif_policia_p USING gist (geom)#
CREATE INDEX edf_edif_pub_civil_a_gist ON edgv.edf_edif_pub_civil_a USING gist (geom)#
CREATE INDEX edf_edif_pub_civil_p_gist ON edgv.edf_edif_pub_civil_p USING gist (geom)#
CREATE INDEX edf_edif_pub_militar_a_gist ON edgv.edf_edif_pub_militar_a USING gist (geom)#
CREATE INDEX edf_edif_pub_militar_p_gist ON edgv.edf_edif_pub_militar_p USING gist (geom)#
CREATE INDEX edf_edif_religiosa_a_gist ON edgv.edf_edif_religiosa_a USING gist (geom)#
CREATE INDEX edf_edif_religiosa_p_gist ON edgv.edf_edif_religiosa_p USING gist (geom)#
CREATE INDEX edf_edif_residencial_a_gist ON edgv.edf_edif_residencial_a USING gist (geom)#
CREATE INDEX edf_edif_residencial_p_gist ON edgv.edf_edif_residencial_p USING gist (geom)#
CREATE INDEX edf_edif_rodoviaria_a_gist ON edgv.edf_edif_rodoviaria_a USING gist (geom)#
CREATE INDEX edf_edif_rodoviaria_p_gist ON edgv.edf_edif_rodoviaria_p USING gist (geom)#
CREATE INDEX edf_edif_saneamento_a_gist ON edgv.edf_edif_saneamento_a USING gist (geom)#
CREATE INDEX edf_edif_saneamento_p_gist ON edgv.edf_edif_saneamento_p USING gist (geom)#
CREATE INDEX edf_edif_saude_a_gist ON edgv.edf_edif_saude_a USING gist (geom)#
CREATE INDEX edf_edif_saude_p_gist ON edgv.edf_edif_saude_p USING gist (geom)#
CREATE INDEX edf_edif_servico_social_a_gist ON edgv.edf_edif_servico_social_a USING gist (geom)#
CREATE INDEX edf_edif_servico_social_p_gist ON edgv.edf_edif_servico_social_p USING gist (geom)#
CREATE INDEX edf_hab_indigena_a_gist ON edgv.edf_hab_indigena_a USING gist (geom)#
CREATE INDEX edf_hab_indigena_p_gist ON edgv.edf_hab_indigena_p USING gist (geom)#
CREATE INDEX edf_posto_combustivel_a_gist ON edgv.edf_posto_combustivel_a USING gist (geom)#
CREATE INDEX edf_posto_combustivel_p_gist ON edgv.edf_posto_combustivel_p USING gist (geom)#
CREATE INDEX edf_posto_fiscal_a_gist ON edgv.edf_posto_fiscal_a USING gist (geom)#
CREATE INDEX edf_posto_fiscal_p_gist ON edgv.edf_posto_fiscal_p USING gist (geom)#
CREATE INDEX edf_posto_guarda_municipal_a_gist ON edgv.edf_posto_guarda_municipal_a USING gist (geom)#
CREATE INDEX edf_posto_guarda_municipal_p_gist ON edgv.edf_posto_guarda_municipal_p USING gist (geom)#
CREATE INDEX edf_posto_policia_militar_a_gist ON edgv.edf_posto_policia_militar_a USING gist (geom)#
CREATE INDEX edf_posto_policia_militar_p_gist ON edgv.edf_posto_policia_militar_p USING gist (geom)#
CREATE INDEX edf_posto_policia_rod_federal_a_gist ON edgv.edf_posto_policia_rod_federal_a USING gist (geom)#
CREATE INDEX edf_posto_policia_rod_federal_p_gist ON edgv.edf_posto_policia_rod_federal_p USING gist (geom)#
CREATE INDEX edf_representacao_diplomatica_a_gist ON edgv.edf_representacao_diplomatica_a USING gist (geom)#
CREATE INDEX edf_representacao_diplomatica_p_gist ON edgv.edf_representacao_diplomatica_p USING gist (geom)#
CREATE INDEX emu_acesso_a_gist ON edgv.emu_acesso_a USING gist (geom)#
CREATE INDEX emu_acesso_l_gist ON edgv.emu_acesso_l USING gist (geom)#
CREATE INDEX emu_acesso_p_gist ON edgv.emu_acesso_p USING gist (geom)#
CREATE INDEX emu_ciclovia_l_gist ON edgv.emu_ciclovia_l USING gist (geom)#
CREATE INDEX emu_elevador_a_gist ON edgv.emu_elevador_a USING gist (geom)#
CREATE INDEX emu_elevador_l_gist ON edgv.emu_elevador_l USING gist (geom)#
CREATE INDEX emu_elevador_p_gist ON edgv.emu_elevador_p USING gist (geom)#
CREATE INDEX emu_escadaria_a_gist ON edgv.emu_escadaria_a USING gist (geom)#
CREATE INDEX emu_escadaria_l_gist ON edgv.emu_escadaria_l USING gist (geom)#
CREATE INDEX emu_escadaria_p_gist ON edgv.emu_escadaria_p USING gist (geom)#
CREATE INDEX emu_poste_sinalizacao_p_gist ON edgv.emu_poste_sinalizacao_p USING gist (geom)#
CREATE INDEX emu_rampa_a_gist ON edgv.emu_rampa_a USING gist (geom)#
CREATE INDEX emu_rampa_l_gist ON edgv.emu_rampa_l USING gist (geom)#
CREATE INDEX emu_rampa_p_gist ON edgv.emu_rampa_p USING gist (geom)#
CREATE INDEX enc_aerogerador_p_gist ON edgv.enc_aerogerador_p USING gist (geom)#
CREATE INDEX enc_antena_comunic_p_gist ON edgv.enc_antena_comunic_p USING gist (geom)#
CREATE INDEX enc_casa_de_forca_p_gist ON edgv.enc_casa_de_forca_p USING gist (geom)#
CREATE INDEX enc_central_geradora_eolica_a_gist ON edgv.enc_central_geradora_eolica_a USING gist (geom)#
CREATE INDEX enc_central_geradora_eolica_l_gist ON edgv.enc_central_geradora_eolica_l USING gist (geom)#
CREATE INDEX enc_central_geradora_eolica_p_gist ON edgv.enc_central_geradora_eolica_p USING gist (geom)#
CREATE INDEX enc_est_gerad_energia_eletrica_a_gist ON edgv.enc_est_gerad_energia_eletrica_a USING gist (geom)#
CREATE INDEX enc_est_gerad_energia_eletrica_l_gist ON edgv.enc_est_gerad_energia_eletrica_l USING gist (geom)#
CREATE INDEX enc_est_gerad_energia_eletrica_p_gist ON edgv.enc_est_gerad_energia_eletrica_p USING gist (geom)#
CREATE INDEX enc_grupo_transformadores_a_gist ON edgv.enc_grupo_transformadores_a USING gist (geom)#
CREATE INDEX enc_grupo_transformadores_p_gist ON edgv.enc_grupo_transformadores_p USING gist (geom)#
CREATE INDEX enc_hidreletrica_a_gist ON edgv.enc_hidreletrica_a USING gist (geom)#
CREATE INDEX enc_hidreletrica_l_gist ON edgv.enc_hidreletrica_l USING gist (geom)#
CREATE INDEX enc_hidreletrica_p_gist ON edgv.enc_hidreletrica_p USING gist (geom)#
CREATE INDEX enc_termeletrica_a_gist ON edgv.enc_termeletrica_a USING gist (geom)#
CREATE INDEX enc_termeletrica_p_gist ON edgv.enc_termeletrica_p USING gist (geom)#
CREATE INDEX enc_torre_comunic_p_gist ON edgv.enc_torre_comunic_p USING gist (geom)#
CREATE INDEX enc_torre_energia_p_gist ON edgv.enc_torre_energia_p USING gist (geom)#
CREATE INDEX enc_trecho_comunic_l_gist ON edgv.enc_trecho_comunic_l USING gist (geom)#
CREATE INDEX enc_trecho_energia_l_gist ON edgv.enc_trecho_energia_l USING gist (geom)#
CREATE INDEX enc_zona_linhas_energia_comunicacao_a_gist ON edgv.enc_zona_linhas_energia_comunicacao_a USING gist (geom)#
CREATE INDEX fer_cremalheira_l_gist ON edgv.fer_cremalheira_l USING gist (geom)#
CREATE INDEX fer_cremalheira_p_gist ON edgv.fer_cremalheira_p USING gist (geom)#
CREATE INDEX fer_girador_ferroviario_p_gist ON edgv.fer_girador_ferroviario_p USING gist (geom)#
CREATE INDEX fer_trecho_ferroviario_l_gist ON edgv.fer_trecho_ferroviario_l USING gist (geom)#
CREATE INDEX hdv_atracadouro_terminal_a_gist ON edgv.hdv_atracadouro_terminal_a USING gist (geom)#
CREATE INDEX hdv_atracadouro_terminal_l_gist ON edgv.hdv_atracadouro_terminal_l USING gist (geom)#
CREATE INDEX hdv_atracadouro_terminal_p_gist ON edgv.hdv_atracadouro_terminal_p USING gist (geom)#
CREATE INDEX hdv_eclusa_a_gist ON edgv.hdv_eclusa_a USING gist (geom)#
CREATE INDEX hdv_eclusa_l_gist ON edgv.hdv_eclusa_l USING gist (geom)#
CREATE INDEX hdv_eclusa_p_gist ON edgv.hdv_eclusa_p USING gist (geom)#
CREATE INDEX hdv_fundeadouro_a_gist ON edgv.hdv_fundeadouro_a USING gist (geom)#
CREATE INDEX hdv_fundeadouro_p_gist ON edgv.hdv_fundeadouro_p USING gist (geom)#
CREATE INDEX hdv_obstaculo_navegacao_a_gist ON edgv.hdv_obstaculo_navegacao_a USING gist (geom)#
CREATE INDEX hdv_obstaculo_navegacao_l_gist ON edgv.hdv_obstaculo_navegacao_l USING gist (geom)#
CREATE INDEX hdv_obstaculo_navegacao_p_gist ON edgv.hdv_obstaculo_navegacao_p USING gist (geom)#
CREATE INDEX hdv_sinalizacao_p_gist ON edgv.hdv_sinalizacao_p USING gist (geom)#
CREATE INDEX hdv_trecho_hidroviario_l_gist ON edgv.hdv_trecho_hidroviario_l USING gist (geom)#
CREATE INDEX hid_area_umida_a_gist ON edgv.hid_area_umida_a USING gist (geom)#
CREATE INDEX hid_banco_areia_a_gist ON edgv.hid_banco_areia_a USING gist (geom)#
CREATE INDEX hid_banco_areia_l_gist ON edgv.hid_banco_areia_l USING gist (geom)#
CREATE INDEX hid_barragem_a_gist ON edgv.hid_barragem_a USING gist (geom)#
CREATE INDEX hid_barragem_l_gist ON edgv.hid_barragem_l USING gist (geom)#
CREATE INDEX hid_barragem_p_gist ON edgv.hid_barragem_p USING gist (geom)#
CREATE INDEX hid_canal_a_gist ON edgv.hid_canal_a USING gist (geom)#
CREATE INDEX hid_canal_l_gist ON edgv.hid_canal_l USING gist (geom)#
CREATE INDEX hid_canal_vala_a_gist ON edgv.hid_canal_vala_a USING gist (geom)#
CREATE INDEX hid_canal_vala_l_gist ON edgv.hid_canal_vala_l USING gist (geom)#
CREATE INDEX hid_comporta_l_gist ON edgv.hid_comporta_l USING gist (geom)#
CREATE INDEX hid_comporta_p_gist ON edgv.hid_comporta_p USING gist (geom)#
CREATE INDEX hid_corredeira_a_gist ON edgv.hid_corredeira_a USING gist (geom)#
CREATE INDEX hid_corredeira_l_gist ON edgv.hid_corredeira_l USING gist (geom)#
CREATE INDEX hid_corredeira_p_gist ON edgv.hid_corredeira_p USING gist (geom)#
CREATE INDEX hid_dique_a_gist ON edgv.hid_dique_a USING gist (geom)#
CREATE INDEX hid_dique_l_gist ON edgv.hid_dique_l USING gist (geom)#
CREATE INDEX hid_dique_p_gist ON edgv.hid_dique_p USING gist (geom)#
CREATE INDEX hid_fonte_dagua_p_gist ON edgv.hid_fonte_dagua_p USING gist (geom)#
CREATE INDEX hid_foz_maritima_a_gist ON edgv.hid_foz_maritima_a USING gist (geom)#
CREATE INDEX hid_foz_maritima_l_gist ON edgv.hid_foz_maritima_l USING gist (geom)#
CREATE INDEX hid_foz_maritima_p_gist ON edgv.hid_foz_maritima_p USING gist (geom)#
CREATE INDEX hid_ilha_a_gist ON edgv.hid_ilha_a USING gist (geom)#
CREATE INDEX hid_ilha_l_gist ON edgv.hid_ilha_l USING gist (geom)#
CREATE INDEX hid_ilha_p_gist ON edgv.hid_ilha_p USING gist (geom)#
CREATE INDEX hid_massa_dagua_a_gist ON edgv.hid_massa_dagua_a USING gist (geom)#
CREATE INDEX hid_quebramar_molhe_a_gist ON edgv.hid_quebramar_molhe_a USING gist (geom)#
CREATE INDEX hid_quebramar_molhe_l_gist ON edgv.hid_quebramar_molhe_l USING gist (geom)#
CREATE INDEX hid_queda_dagua_a_gist ON edgv.hid_queda_dagua_a USING gist (geom)#
CREATE INDEX hid_queda_dagua_l_gist ON edgv.hid_queda_dagua_l USING gist (geom)#
CREATE INDEX hid_queda_dagua_p_gist ON edgv.hid_queda_dagua_p USING gist (geom)#
CREATE INDEX hid_recife_a_gist ON edgv.hid_recife_a USING gist (geom)#
CREATE INDEX hid_recife_l_gist ON edgv.hid_recife_l USING gist (geom)#
CREATE INDEX hid_recife_p_gist ON edgv.hid_recife_p USING gist (geom)#
CREATE INDEX hid_rocha_em_agua_a_gist ON edgv.hid_rocha_em_agua_a USING gist (geom)#
CREATE INDEX hid_rocha_em_agua_p_gist ON edgv.hid_rocha_em_agua_p USING gist (geom)#
CREATE INDEX hid_sumidouro_vertedouro_p_gist ON edgv.hid_sumidouro_vertedouro_p USING gist (geom)#
CREATE INDEX hid_terreno_sujeito_inundacao_a_gist ON edgv.hid_terreno_sujeito_inundacao_a USING gist (geom)#
CREATE INDEX hid_trecho_drenagem_l_gist ON edgv.hid_trecho_drenagem_l USING gist (geom)#
CREATE INDEX hid_vala_a_gist ON edgv.hid_vala_a USING gist (geom)#
CREATE INDEX hid_vala_l_gist ON edgv.hid_vala_l USING gist (geom)#
CREATE INDEX laz_arquibancada_a_gist ON edgv.laz_arquibancada_a USING gist (geom)#
CREATE INDEX laz_arquibancada_l_gist ON edgv.laz_arquibancada_l USING gist (geom)#
CREATE INDEX laz_campo_quadra_a_gist ON edgv.laz_campo_quadra_a USING gist (geom)#
CREATE INDEX laz_campo_quadra_p_gist ON edgv.laz_campo_quadra_p USING gist (geom)#
CREATE INDEX laz_piscina_a_gist ON edgv.laz_piscina_a USING gist (geom)#
CREATE INDEX laz_pista_competicao_a_gist ON edgv.laz_pista_competicao_a USING gist (geom)#
CREATE INDEX laz_pista_competicao_l_gist ON edgv.laz_pista_competicao_l USING gist (geom)#
CREATE INDEX laz_pista_competicao_p_gist ON edgv.laz_pista_competicao_p USING gist (geom)#
CREATE INDEX laz_ruina_a_gist ON edgv.laz_ruina_a USING gist (geom)#
CREATE INDEX laz_ruina_p_gist ON edgv.laz_ruina_p USING gist (geom)#
CREATE INDEX laz_sitio_arqueologico_a_gist ON edgv.laz_sitio_arqueologico_a USING gist (geom)#
CREATE INDEX laz_sitio_arqueologico_p_gist ON edgv.laz_sitio_arqueologico_p USING gist (geom)#
CREATE INDEX lml_area_densamente_edificada_a_gist ON edgv.lml_area_densamente_edificada_a USING gist (geom)#
CREATE INDEX lml_area_especial_a_gist ON edgv.lml_area_especial_a USING gist (geom)#
CREATE INDEX lml_area_politico_administrativa_a_gist ON edgv.lml_area_politico_administrativa_a USING gist (geom)#
CREATE INDEX lml_area_pub_militar_a_gist ON edgv.lml_area_pub_militar_a USING gist (geom)#
CREATE INDEX lml_area_urbana_isolada_a_gist ON edgv.lml_area_urbana_isolada_a USING gist (geom)#
CREATE INDEX lml_distrito_a_gist ON edgv.lml_distrito_a USING gist (geom)#
CREATE INDEX lml_municipio_a_gist ON edgv.lml_municipio_a USING gist (geom)#
CREATE INDEX lml_nome_local_p_gist ON edgv.lml_nome_local_p USING gist (geom)#
CREATE INDEX lml_pais_a_gist ON edgv.lml_pais_a USING gist (geom)#
CREATE INDEX lml_posic_geo_localidade_p_gist ON edgv.lml_posic_geo_localidade_p USING gist (geom)#
CREATE INDEX lml_terra_indigena_a_gist ON edgv.lml_terra_indigena_a USING gist (geom)#
CREATE INDEX lml_terra_publica_a_gist ON edgv.lml_terra_publica_a USING gist (geom)#
CREATE INDEX lml_unidade_conservacao_a_gist ON edgv.lml_unidade_conservacao_a USING gist (geom)#
CREATE INDEX lml_unidade_federacao_a_gist ON edgv.lml_unidade_federacao_a USING gist (geom)#
CREATE INDEX lml_unidade_protecao_integral_a_gist ON edgv.lml_unidade_protecao_integral_a USING gist (geom)#
CREATE INDEX lml_unidade_protegida_a_gist ON edgv.lml_unidade_protegida_a USING gist (geom)#
CREATE INDEX lml_unidade_uso_sustentavel_a_gist ON edgv.lml_unidade_uso_sustentavel_a USING gist (geom)#
CREATE INDEX pto_marco_de_limite_p_gist ON edgv.pto_marco_de_limite_p USING gist (geom)#
CREATE INDEX pto_pto_est_med_fenomenos_p_gist ON edgv.pto_pto_est_med_fenomenos_p USING gist (geom)#
CREATE INDEX pto_pto_geod_topo_controle_p_gist ON edgv.pto_pto_geod_topo_controle_p USING gist (geom)#
CREATE INDEX pto_pto_ref_geod_topo_p_gist ON edgv.pto_pto_ref_geod_topo_p USING gist (geom)#
CREATE INDEX rel_alteracao_fisiografica_antropica_a_gist ON edgv.rel_alteracao_fisiografica_antropica_a USING gist (geom)#
CREATE INDEX rel_alteracao_fisiografica_antropica_l_gist ON edgv.rel_alteracao_fisiografica_antropica_l USING gist (geom)#
CREATE INDEX rel_alteracao_fisiografica_antropica_p_gist ON edgv.rel_alteracao_fisiografica_antropica_p USING gist (geom)#
CREATE INDEX rel_aterro_a_gist ON edgv.rel_aterro_a USING gist (geom)#
CREATE INDEX rel_aterro_l_gist ON edgv.rel_aterro_l USING gist (geom)#
CREATE INDEX rel_aterro_p_gist ON edgv.rel_aterro_p USING gist (geom)#
CREATE INDEX rel_corte_a_gist ON edgv.rel_corte_a USING gist (geom)#
CREATE INDEX rel_corte_l_gist ON edgv.rel_corte_l USING gist (geom)#
CREATE INDEX rel_corte_p_gist ON edgv.rel_corte_p USING gist (geom)#
CREATE INDEX rel_curva_batimetrica_l_gist ON edgv.rel_curva_batimetrica_l USING gist (geom)#
CREATE INDEX rel_curva_nivel_l_gist ON edgv.rel_curva_nivel_l USING gist (geom)#
CREATE INDEX rel_dolina_a_gist ON edgv.rel_dolina_a USING gist (geom)#
CREATE INDEX rel_dolina_p_gist ON edgv.rel_dolina_p USING gist (geom)#
CREATE INDEX rel_duna_a_gist ON edgv.rel_duna_a USING gist (geom)#
CREATE INDEX rel_duna_l_gist ON edgv.rel_duna_l USING gist (geom)#
CREATE INDEX rel_duna_p_gist ON edgv.rel_duna_p USING gist (geom)#
CREATE INDEX rel_elemento_fisiografico_natural_a_gist ON edgv.rel_elemento_fisiografico_natural_a USING gist (geom)#
CREATE INDEX rel_elemento_fisiografico_natural_l_gist ON edgv.rel_elemento_fisiografico_natural_l USING gist (geom)#
CREATE INDEX rel_elemento_fisiografico_natural_p_gist ON edgv.rel_elemento_fisiografico_natural_p USING gist (geom)#
CREATE INDEX rel_gruta_caverna_l_gist ON edgv.rel_gruta_caverna_l USING gist (geom)#
CREATE INDEX rel_gruta_caverna_p_gist ON edgv.rel_gruta_caverna_p USING gist (geom)#
CREATE INDEX rel_isolinha_hipsometrica_l_gist ON edgv.rel_isolinha_hipsometrica_l USING gist (geom)#
CREATE INDEX rel_pico_p_gist ON edgv.rel_pico_p USING gist (geom)#
CREATE INDEX rel_ponto_cotado_altimetrico_p_gist ON edgv.rel_ponto_cotado_altimetrico_p USING gist (geom)#
CREATE INDEX rel_ponto_cotado_batimetrico_p_gist ON edgv.rel_ponto_cotado_batimetrico_p USING gist (geom)#
CREATE INDEX rel_ponto_hipsometrico_p_gist ON edgv.rel_ponto_hipsometrico_p USING gist (geom)#
CREATE INDEX rel_rocha_a_gist ON edgv.rel_rocha_a USING gist (geom)#
CREATE INDEX rel_rocha_l_gist ON edgv.rel_rocha_l USING gist (geom)#
CREATE INDEX rel_rocha_p_gist ON edgv.rel_rocha_p USING gist (geom)#
CREATE INDEX rel_terreno_exposto_a_gist ON edgv.rel_terreno_exposto_a USING gist (geom)#
CREATE INDEX rod_trecho_rodoviario_a_gist ON edgv.rod_trecho_rodoviario_a USING gist (geom)#
CREATE INDEX rod_trecho_rodoviario_l_gist ON edgv.rod_trecho_rodoviario_l USING gist (geom)#
CREATE INDEX rod_via_deslocamento_a_gist ON edgv.rod_via_deslocamento_a USING gist (geom)#
CREATE INDEX rod_via_deslocamento_l_gist ON edgv.rod_via_deslocamento_l USING gist (geom)#
CREATE INDEX snb_barragem_calcadao_a_gist ON edgv.snb_barragem_calcadao_a USING gist (geom)#
CREATE INDEX snb_dep_abast_agua_a_gist ON edgv.snb_dep_abast_agua_a USING gist (geom)#
CREATE INDEX snb_dep_abast_agua_p_gist ON edgv.snb_dep_abast_agua_p USING gist (geom)#
CREATE INDEX snb_dep_saneamento_a_gist ON edgv.snb_dep_saneamento_a USING gist (geom)#
CREATE INDEX snb_dep_saneamento_p_gist ON edgv.snb_dep_saneamento_p USING gist (geom)#
CREATE INDEX tra_caminho_aereo_l_gist ON edgv.tra_caminho_aereo_l USING gist (geom)#
CREATE INDEX tra_caminho_carrocavel_l_gist ON edgv.tra_caminho_carrocavel_l USING gist (geom)#
CREATE INDEX tra_entroncamento_pto_p_gist ON edgv.tra_entroncamento_pto_p USING gist (geom)#
CREATE INDEX tra_funicular_l_gist ON edgv.tra_funicular_l USING gist (geom)#
CREATE INDEX tra_obra_de_arte_viaria_a_gist ON edgv.tra_obra_de_arte_viaria_a USING gist (geom)#
CREATE INDEX tra_obra_de_arte_viaria_l_gist ON edgv.tra_obra_de_arte_viaria_l USING gist (geom)#
CREATE INDEX tra_obra_de_arte_viaria_p_gist ON edgv.tra_obra_de_arte_viaria_p USING gist (geom)#
CREATE INDEX tra_passagem_elevada_viaduto_a_gist ON edgv.tra_passagem_elevada_viaduto_a USING gist (geom)#
CREATE INDEX tra_passagem_elevada_viaduto_l_gist ON edgv.tra_passagem_elevada_viaduto_l USING gist (geom)#
CREATE INDEX tra_passagem_elevada_viaduto_p_gist ON edgv.tra_passagem_elevada_viaduto_p USING gist (geom)#
CREATE INDEX tra_passagem_nivel_p_gist ON edgv.tra_passagem_nivel_p USING gist (geom)#
CREATE INDEX tra_patio_a_gist ON edgv.tra_patio_a USING gist (geom)#
CREATE INDEX tra_ponte_a_gist ON edgv.tra_ponte_a USING gist (geom)#
CREATE INDEX tra_ponte_l_gist ON edgv.tra_ponte_l USING gist (geom)#
CREATE INDEX tra_ponte_p_gist ON edgv.tra_ponte_p USING gist (geom)#
CREATE INDEX tra_travessia_l_gist ON edgv.tra_travessia_l USING gist (geom)#
CREATE INDEX tra_travessia_p_gist ON edgv.tra_travessia_p USING gist (geom)#
CREATE INDEX tra_travessia_pedestre_l_gist ON edgv.tra_travessia_pedestre_l USING gist (geom)#
CREATE INDEX tra_travessia_pedestre_p_gist ON edgv.tra_travessia_pedestre_p USING gist (geom)#
CREATE INDEX tra_travessia_pedrestre_a_gist ON edgv.tra_travessia_pedrestre_a USING gist (geom)#
CREATE INDEX tra_trilha_picada_l_gist ON edgv.tra_trilha_picada_l USING gist (geom)#
CREATE INDEX tra_tunel_a_gist ON edgv.tra_tunel_a USING gist (geom)#
CREATE INDEX tra_tunel_l_gist ON edgv.tra_tunel_l USING gist (geom)#
CREATE INDEX tra_tunel_p_gist ON edgv.tra_tunel_p USING gist (geom)#
CREATE INDEX veg_brejo_pantano_a_gist ON edgv.veg_brejo_pantano_a USING gist (geom)#
CREATE INDEX veg_caatinga_a_gist ON edgv.veg_caatinga_a USING gist (geom)#
CREATE INDEX veg_campinarana_a_gist ON edgv.veg_campinarana_a USING gist (geom)#
CREATE INDEX veg_campo_a_gist ON edgv.veg_campo_a USING gist (geom)#
CREATE INDEX veg_cerrado_a_gist ON edgv.veg_cerrado_a USING gist (geom)#
CREATE INDEX veg_floresta_a_gist ON edgv.veg_floresta_a USING gist (geom)#
CREATE INDEX veg_mangue_a_gist ON edgv.veg_mangue_a USING gist (geom)#
CREATE INDEX veg_reflorestamento_a_gist ON edgv.veg_reflorestamento_a USING gist (geom)#
CREATE INDEX veg_veg_area_contato_a_gist ON edgv.veg_veg_area_contato_a USING gist (geom)#
CREATE INDEX veg_veg_cultivada_a_gist ON edgv.veg_veg_cultivada_a USING gist (geom)#
CREATE INDEX veg_vegetacao_a_gist ON edgv.veg_vegetacao_a USING gist (geom)#
CREATE INDEX veg_veg_natural_a_gist ON edgv.veg_veg_natural_a USING gist (geom)#
CREATE INDEX veg_veg_restinga_a_gist ON edgv.veg_veg_restinga_a USING gist (geom)#
CREATE INDEX ver_arvore_isolada_p_gist ON edgv.ver_arvore_isolada_p USING gist (geom)#
CREATE INDEX ver_jardim_a_gist ON edgv.ver_jardim_a USING gist (geom)#
CREATE INDEX aux_area_a_gist ON public.aux_area_a USING gist (geom)#
CREATE INDEX aux_descontinuidade_geometrica_l_gist ON public.aux_descontinuidade_geometrica_l USING gist (geom)#
CREATE INDEX aux_descontinuidade_geometrica_p_gist ON public.aux_descontinuidade_geometrica_p USING gist (geom)#
CREATE INDEX aux_linha_l_gist ON public.aux_linha_l USING gist (geom)#
CREATE INDEX aux_moldura_a_gist ON public.aux_moldura_a USING gist (geom)#
CREATE INDEX aux_objeto_desconhecido_a_gist ON public.aux_objeto_desconhecido_a USING gist (geom)#
CREATE INDEX aux_objeto_desconhecido_l_gist ON public.aux_objeto_desconhecido_l USING gist (geom)#
CREATE INDEX aux_objeto_desconhecido_p_gist ON public.aux_objeto_desconhecido_p USING gist (geom)#
CREATE INDEX aux_ponto_p_gist ON public.aux_ponto_p USING gist (geom)#
CREATE TABLE public.complex_schema
            (
              complex_schema name,
              complex name,
              aggregated_schema name,
              aggregated_class name,
              column_name name
            )#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_constr_turistica_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','edf_edif_comerc_serv_a','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_residencial_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_abast_agua_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_lazer_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','tra_patio_a','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','snb_dep_abast_agua_a','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_saude_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_religiosa_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_vila','edgv','lml_posic_geo_localidade_p','id_vila')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_metroviaria','edgv','cbge_deposito_geral_p','id_estacao_metroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_comerc_serv_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_constr_portuaria_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_desenv_social_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_constr_portuaria_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural','edgv','lml_area_densamente_edificada_a','id_aglomerado_rural')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_saneamento_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_saneamento_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','hdv_complexo_portuario','complexos','hdv_complexo_portuario','id_complexo_portuario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_pista_competicao_a','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','enc_hidreletrica_l','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_capital','complexos','cbge_complexo_habitacional','id_capital')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','edf_edif_comerc_serv_a','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','cbge_deposito_geral_a','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_rodoviario','edgv','tra_patio_a','id_terminal_rodoviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','cbge_deposito_geral_a','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_veg_cultivada_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_ensino_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_lazer_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_campinarana_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_abast_agua_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_transporte','edgv','snb_dep_abast_agua_a','id_estrut_transporte')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_cerrado_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_saude_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_posto_fiscal_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_saude_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_posto_fiscal_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_saude_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_religiosa_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_comerc_serv_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','cbge_area_uso_especifico_a','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_transporte','edgv','edf_edif_comerc_serv_a','id_estrut_transporte')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_pub_militar_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_hab_indigena_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural','edgv','lml_posic_geo_localidade_p','id_aglomerado_rural')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_turistica_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_policia_militar_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_servico_social_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_servico_social_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_rodoviaria_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_banheiro_publico_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','cbge_deposito_geral_a','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_rodoviaria_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edificacao_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_residencial_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_posto_policia_rod_federal_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_ensino_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_posto_policia_militar_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_comunicacao','edgv','edf_edif_comunic_a','id_complexo_comunicacao')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_brejo_pantano_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_ensino_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_posto_policia_militar_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_lazer_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_pub_civil_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_caatinga_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_desenv_social_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_energia_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_saneamento_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_capital','edgv','lml_area_urbana_isolada_a','id_capital')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_habitacional_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','snb_complexo_saneamento','edgv','snb_dep_saneamento_a','id_complexo_saneamento')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','laz_arquibancada_a','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_capital','edgv','cbge_area_construida_a','id_capital')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','snb_dep_abast_agua_a','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_servico_social_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','laz_pista_competicao_a','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_servico_social_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_pub_militar_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_hab_indigena_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_constr_portuaria_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','edf_edif_comerc_serv_a','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_de_extensao_urbana','complexos','cbge_complexo_habitacional','id_aglomerado_rural_de_extensao_urbana')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_pub_militar_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','cbge_deposito_geral_a','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_constr_portuaria_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_pub_militar_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_banheiro_publico_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edificacao_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_turistica_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_posto_policia_militar_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edificacao_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_banheiro_publico_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edificacao_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_agropec_ext_veg_pesca_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_banheiro_publico_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_agropec_ext_veg_pesca_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_metroviaria','edgv','edf_edif_comerc_serv_p','id_estacao_metroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_arquibancada_a','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_cidade','edgv','lml_area_densamente_edificada_a','id_cidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_policia_rod_federal_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_residencial_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_industrial_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_localidade','complexos','cbge_condominio','id_localidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_pub_civil_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_lazer_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_industrial_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','aer_complexo_aeroportuario','edgv','edf_edif_constr_aeroportuaria_p','id_complexo_aeroportuario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_energia_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_saneamento_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_desenv_social_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','snb_dep_abast_agua_a','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_industrial_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_habitacional_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_industrial_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_comunicacao','edgv','edf_edif_comunic_p','id_complexo_comunicacao')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_vila','edgv','lml_area_densamente_edificada_a','id_vila')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_isolado','complexos','lml_aldeia_indigena','id_aglomerado_rural_isolado')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde_urbana','complexos','ver_area_verde','id_area_verde_urbana')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','edf_edif_comerc_serv_a','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','hid_barragem_p','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_ext_mineral_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_ruina_p','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','edf_edif_energia_a','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_ext_mineral_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_comunicacao','edgv','enc_torre_comunic_p','id_complexo_comunicacao')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','ver_arvore_isolada_p','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','cbge_estacionamento_a','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_metro_ferroviaria_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_aeroportuaria_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_localidade','edgv','cbge_area_construida_a','id_localidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_metro_ferroviaria_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_veg_restinga_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_representacao_diplomatica_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_transporte','edgv','edf_posto_combustivel_a','id_estrut_transporte')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_agropec_ext_veg_pesca_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','hdv_complexo_portuario','edgv','hdv_fundeadouro_a','id_complexo_portuario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_transporte','edgv','snb_dep_abast_agua_p','id_estrut_transporte')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_est_med_fen_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','laz_piscina_a','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_guarda_municipal_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','hdv_complexo_portuario','edgv','hdv_fundeadouro_p','id_complexo_portuario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','edf_edif_constr_lazer_p','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','edf_edif_constr_turistica_a','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_rodoviario','edgv','edf_edif_comerc_serv_p','id_terminal_rodoviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_posto_combustivel_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_cidade','complexos','lml_aldeia_indigena','id_cidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_posto_combustivel_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_piscina_a','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','edf_edif_constr_lazer_a','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_capital','complexos','cbge_condominio','id_capital')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_posto_policia_rod_federal_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_pub_civil_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_posto_policia_rod_federal_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','enc_hidreletrica_a','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','hdv_complexo_portuario','edgv','edf_edif_constr_portuaria_p','id_complexo_portuario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_pub_civil_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','edf_edif_comerc_serv_p','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','edf_edif_constr_lazer_p','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','snb_dep_abast_agua_p','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','edf_edif_constr_turistica_a','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_aeroportuaria_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','edf_posto_combustivel_a','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','cbge_estacionamento_a','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_agropec_ext_veg_pesca_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_metro_ferroviaria_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','edf_posto_combustivel_a','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_representacao_diplomatica_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_metro_ferroviaria_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_est_med_fen_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_religiosa_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','laz_ruina_p','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_isolado','edgv','lml_area_densamente_edificada_a','id_aglomerado_rural_isolado')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','snb_dep_abast_agua_p','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_vila','complexos','lml_aldeia_indigena','id_vila')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_religiosa_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_posto_fiscal_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_veg_area_contato_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_posto_fiscal_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_posto_guarda_municipal_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_ext_mineral_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_ext_mineral_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_transporte','edgv','cbge_estacionamento_a','id_estrut_transporte')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','edf_posto_combustivel_p','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_comerc_serv_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','snb_complexo_abast_agua','edgv','edf_edif_abast_agua_a','id_complexo_abast_agua')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_comerc_serv_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_constr_aeroportuaria_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_abast_agua_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_constr_aeroportuaria_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_abast_agua_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_comunic_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_comunic_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_posto_combustivel_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','cbge_deposito_geral_p','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','snb_dep_abast_agua_p','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_subest_transm_distrib_energia_eletrica','edgv','edf_edif_energia_p','id_subest_transm_distrib_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','edf_edif_constr_turistica_a','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','edf_edif_metro_ferroviaria_a','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_policia_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','edf_posto_combustivel_a','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_hab_indigena_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','hdv_complexo_portuario','edgv','hdv_atracadouro_terminal_p','id_complexo_portuario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_isolado','edgv','lml_posic_geo_localidade_p','id_aglomerado_rural_isolado')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_energia_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_rodoviaria_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_representacao_diplomatica_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_energia_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_metroviaria','edgv','tra_patio_a','id_estacao_metroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','edf_edif_constr_lazer_a','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','laz_piscina_a','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_est_med_fen_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','cbge_area_habitacional_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','cbge_estacionamento_a','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_habitacional_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','edf_edif_constr_lazer_p','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_habitacional_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','hdv_complexo_portuario','edgv','edf_edif_constr_portuaria_a','id_complexo_portuario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_rodoviario','edgv','cbge_deposito_geral_p','id_terminal_rodoviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_de_extensao_urbana','complexos','cbge_condominio','id_aglomerado_rural_de_extensao_urbana')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_floresta_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','snb_complexo_saneamento','edgv','edf_edif_saneamento_a','id_complexo_saneamento')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','edf_edif_rodoviaria_p','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_policia_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural','complexos','lml_aldeia_indigena','id_aglomerado_rural')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_combustivel_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_policia_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','edf_edif_constr_lazer_a','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_posto_guarda_municipal_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_posto_guarda_municipal_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_policia_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_hab_indigena_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_representacao_diplomatica_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_comunic_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','laz_ruina_p','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_localidade','complexos','cbge_complexo_habitacional','id_localidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','snb_dep_abast_agua_p','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_comunic_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_rodoviaria_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_rodoviario','edgv','edf_posto_combustivel_p','id_terminal_rodoviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','enc_hidreletrica_p','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','edf_posto_combustivel_a','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','cbge_area_habitacional_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','cbge_estacionamento_a','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_est_med_fen_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_pub_civil_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_policia_rod_federal_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_veg_natural_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','cbge_deposito_geral_p','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_combustivel_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_ext_mineral_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','edf_edif_metro_ferroviaria_a','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','ver_jardim_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','laz_arquibancada_l','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_metro_ferroviaria_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_constr_aeroportuaria_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_capital','complexos','lml_aldeia_indigena','id_capital')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_constr_aeroportuaria_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_cidade','complexos','cbge_condominio','id_cidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_religiosa_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_constr_est_med_fen_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_rodoviario','edgv','edf_posto_combustivel_a','id_terminal_rodoviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','edf_edif_constr_turistica_p','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_localidade','edgv','lml_area_densamente_edificada_a','id_localidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_constr_est_med_fen_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','hid_barragem_a','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_rodoviario','edgv','snb_dep_abast_agua_p','id_terminal_rodoviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_metro_ferroviaria_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','edf_posto_combustivel_p','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_ext_mineral_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_vila','complexos','cbge_condominio','id_vila')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','snb_complexo_saneamento','edgv','edf_edif_saneamento_p','id_complexo_saneamento')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_fiscal_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_transporte','edgv','edf_edif_comerc_serv_p','id_estrut_transporte')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_posto_policia_rod_federal_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_pub_civil_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','edf_edif_comerc_serv_p','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_ext_mineral_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_posto_combustivel_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','laz_ruina_a','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_campo_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','edf_posto_combustivel_a','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','enc_est_gerad_energia_eletrica_p','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','cbge_deposito_geral_p','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','snb_dep_abast_agua_p','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_recreativo','edgv','laz_pista_competicao_l','id_complexo_recreativo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_isolado','edgv','cbge_area_construida_a','id_aglomerado_rural_isolado')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_metro_ferroviaria_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_religiosa_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_metro_ferroviaria_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_agropec_ext_veg_pesca_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_representacao_diplomatica_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_metroviaria','edgv','edf_edif_comerc_serv_a','id_estacao_metroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_representacao_diplomatica_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_agropec_ext_veg_pesca_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','pto_est_med_fenomenos','edgv','edf_edif_constr_est_med_fen_a','id_est_med_fenomenos')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_ext_mineral_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_posto_guarda_municipal_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_posto_fiscal_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_posto_guarda_municipal_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','edf_edif_comerc_serv_p','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','edf_posto_combustivel_p','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','edf_edif_metro_ferroviaria_p','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_comerc_serv_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','snb_complexo_saneamento','edgv','snb_dep_saneamento_p','id_complexo_saneamento')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','snb_complexo_abast_agua','edgv','snb_dep_abast_agua_p','id_complexo_abast_agua')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_habitacional_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_rodoviario','edgv','cbge_estacionamento_a','id_terminal_rodoviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_subest_transm_distrib_energia_eletrica','edgv','enc_grupo_transformadores_p','id_subest_transm_distrib_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural','complexos','cbge_condominio','id_aglomerado_rural')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_metroviaria','edgv','snb_dep_abast_agua_a','id_estacao_metroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','laz_arquibancada_l','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_de_extensao_urbana','complexos','lml_aldeia_indigena','id_aglomerado_rural_de_extensao_urbana')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','edf_posto_combustivel_p','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_comunic_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','cbge_deposito_geral_p','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_posto_combustivel_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_policia_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_posto_combustivel_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','enc_est_gerad_energia_eletrica_l','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_aeroportuaria_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_abast_agua_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_policia_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_subest_transm_distrib_energia_eletrica','edgv','enc_grupo_transformadores_a','id_subest_transm_distrib_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','fer_girador_ferroviario_p','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_policia_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','cbge_deposito_geral_p','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_pista_competicao_l','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_guarda_municipal_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_constr_est_med_fen_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','cbge_area_habitacional_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rel_arquipelago','edgv','hid_ilha_a','id_arquipelago')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','cbge_area_habitacional_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_constr_est_med_fen_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','edf_posto_combustivel_p','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rod_estacao_rodoviaria','edgv','edf_edif_comerc_serv_p','id_estacao_rodoviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_representacao_diplomatica_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','edf_edif_constr_turistica_p','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_rodoviaria_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_ruina_a','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_isolado','complexos','cbge_complexo_habitacional','id_aglomerado_rural_isolado')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_comunic_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_energia_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_representacao_diplomatica_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_rodoviaria_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_habitacional_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','laz_pista_competicao_l','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_comerc_serv_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_subest_transm_distrib_energia_eletrica','edgv','cbge_area_uso_especifico_a','id_subest_transm_distrib_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_policia_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','edf_edif_constr_turistica_p','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_transporte','edgv','cbge_deposito_geral_p','id_estrut_transporte')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','laz_ruina_a','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_comunic_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_aeroportuaria_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_abast_agua_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_arquibancada_l','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_entroncamento','edgv','tra_entroncamento_pto_p','id_entroncamento')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_hab_indigena_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_localidade','edgv','lml_posic_geo_localidade_p','id_localidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','pto_est_med_fenomenos','edgv','edf_edif_constr_est_med_fen_p','id_est_med_fenomenos')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_hab_indigena_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_apoio','edgv','edf_edif_comerc_serv_p','id_estrut_apoio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_posto_guarda_municipal_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aldeia_indigena','edgv','edf_hab_indigena_p','id_aldeia_indigena')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_metroviaria','edgv','cbge_deposito_geral_a','id_estacao_metroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','cbge_estacionamento_a','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','tra_estrut_transporte','edgv','edf_posto_combustivel_p','id_estrut_transporte')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_energia_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_comunic_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_saneamento_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_portuaria_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_turistica_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','complexos','enc_subest_transm_distrib_energia_eletrica','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_cidade','complexos','cbge_complexo_habitacional','id_cidade')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_aglomerado_rural_de_extensao_urbana','edgv','lml_area_densamente_edificada_a','id_aglomerado_rural_de_extensao_urbana')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','cbge_largo_a','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','ver_area_verde','edgv','veg_mangue_a','id_area_verde')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_rodoviario','edgv','cbge_deposito_geral_a','id_terminal_rodoviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_hidroviario','edgv','tra_patio_a','id_terminal_hidroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','edf_edif_energia_p','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_ferroviaria','edgv','snb_dep_abast_agua_a','id_estacao_ferroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','aer_complexo_aeroportuario','edgv','aer_pista_ponto_pouso_a','id_complexo_aeroportuario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_abast_agua_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','rel_arquipelago','edgv','hid_ilha_l','id_arquipelago')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_abast_agua_p','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','emu_terminal_ferroviario','edgv','tra_patio_a','id_terminal_ferroviario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_pista_competicao_p','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_vila','complexos','cbge_complexo_habitacional','id_vila')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_residencial_a','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','enc_termeletrica_p','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo_lazer','edgv','laz_campo_quadra_p','id_complexo_desportivo_lazer')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_comerc_serv_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_comerc_serv_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_religiosa_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_saude_a','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','fer_estacao_metroviaria','edgv','fer_girador_ferroviario_p','id_estacao_metroviaria')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_posto_fiscal_a','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_saude_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_saude_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_religiosa_a','id_conjunto_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','snb_complexo_abast_agua','edgv','edf_edif_abast_agua_p','id_complexo_abast_agua')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_saneamento_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','enc_complexo_gerador_energia_eletrica','edgv','enc_central_geradora_eolica_p','id_complexo_gerador_energia_eletrica')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','lml_capital','edgv','lml_posic_geo_localidade_p','id_capital')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_assentamento_precario','edgv','edf_edif_constr_turistica_p','id_assentamento_precario')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_complexo_habitacional','edgv','edf_edif_constr_portuaria_p','id_complexo_habitacional')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_condominio','edgv','edf_edif_desenv_social_p','id_condominio')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','laz_complexo_desportivo','edgv','laz_pista_competicao_p','id_complexo_desportivo')#
INSERT INTO public.complex_schema (complex_schema, complex, aggregated_schema, aggregated_class, column_name) VALUES ('complexos','cbge_conjunto_habitacional','edgv','edf_edif_desenv