CREATE EXTENSION IF NOT EXISTS "uuid-ossp"#
CREATE SCHEMA topology#
ALTER SCHEMA topology OWNER TO postgres#
CREATE EXTENSION postgis#
COMMENT ON EXTENSION postgis IS 'PostGIS geometry, geography, and raster spatial types and functions'#
CREATE EXTENSION postgis_topology#
COMMENT ON EXTENSION postgis_topology IS 'PostGIS topology spatial types and functions'#CREATE SCHEMA dominios#
CREATE SCHEMA complexos#
ALTER SCHEMA complexos OWNER TO postgres#
CREATE SCHEMA pe#
CREATE SCHEMA ge#
SET search_path TO pg_catalog,public,topology,dominios,complexos,pe,ge#
CREATE TABLE pe.hid_area_umida_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoareaumida smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_area_umida_a_pkey PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_area_umida_a OWNER TO postgres#
CREATE TABLE pe.hid_banco_areia(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipobanco smallint NOT NULL,
	situacaoemagua smallint,
	materialpredominante smallint,
	CONSTRAINT hid_banco_areia_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_banco_areia OWNER TO postgres#
CREATE TABLE pe.hid_recife(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tiporecife smallint NOT NULL,
	situacaoemagua smallint NOT NULL,
	situacaocosta smallint NOT NULL,
	CONSTRAINT hid_recife_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_recife OWNER TO postgres#
CREATE TABLE pe.hid_barragem(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	matconstr smallint[] NOT NULL,
	usoprincipal smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	id_complexo_gerador_energia_eletrica uuid,
	CONSTRAINT hid_barragem_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_barragem OWNER TO postgres#
CREATE TABLE pe.hid_comporta(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	CONSTRAINT hid_comporta_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)WITH ( OIDS = TRUE )#
ALTER TABLE pe.hid_comporta OWNER TO postgres#
CREATE TABLE pe.hid_queda_dagua(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoqueda smallint NOT NULL,
	altura real,
	CONSTRAINT hid_queda_dagua_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_queda_dagua OWNER TO postgres#
CREATE TABLE pe.hid_corredeira(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	CONSTRAINT hid_corredeira_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_corredeira OWNER TO postgres#
CREATE TABLE pe.hid_dique(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	matconstr smallint[] NOT NULL,
	CONSTRAINT hid_dique_p_pkey PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_dique OWNER TO postgres#
CREATE TABLE pe.hid_dique_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_dique_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_dique)
#
ALTER TABLE pe.hid_dique_a OWNER TO postgres#
CREATE TABLE pe.hid_fonte_dagua_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipofontedagua smallint NOT NULL,
	qualidagua smallint,
	regime smallint,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_fonte_dagua_p_pkey PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_fonte_dagua_p OWNER TO postgres#
CREATE TABLE pe.hid_foz_maritima(
	id serial NOT NULL,
	nome character(80),
	geometriaaproximada smallint NOT NULL DEFAULT 1,
	CONSTRAINT hid_foz_maritima_p_pkey PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_foz_maritima OWNER TO postgres#
CREATE TABLE pe.rel_elemento_fisiografico(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	CONSTRAINT rel_elemento_fisiografico_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.hid_limite_massa_dagua_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipolimmassa smallint NOT NULL,
	materialpredominante smallint,
	revestida smallint,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_limite_massa_dagua_l_pkey PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_limite_massa_dagua_l OWNER TO postgres#
CREATE TABLE pe.hid_massa_dagua_a(
	id serial NOT NULL,
	nome character(80),
	geometriaaproximada smallint NOT NULL,
	tipomassadagua smallint NOT NULL,
	regime smallint NOT NULL,
	salgada smallint NOT NULL,
	dominialidade smallint,
	artificial smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_elemento_hidrografico uuid,
	CONSTRAINT hid_massa_dagua_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_massa_dagua_a OWNER TO postgres#
CREATE TABLE pe.hid_ponto_drenagem_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	relacionado smallint NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_ponto_drenagem_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_ponto_drenagem_p OWNER TO postgres#
CREATE TABLE pe.hid_quebramar_molhe(
	id serial NOT NULL,
	tipoquebramolhe smallint NOT NULL,
	nome character(80),
	geometriaaproximada smallint NOT NULL,
	matconstr smallint[] NOT NULL,
	situacaoemagua smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	CONSTRAINT hid_quebramar_molhe_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_quebramar_molhe OWNER TO postgres#
CREATE TABLE pe.hid_quebramar_molhe_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_quebramar_molhe_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_quebramar_molhe)
#
ALTER TABLE pe.hid_quebramar_molhe_l OWNER TO postgres#
CREATE TABLE pe.hid_queda_dagua_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_queda_dagua_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_queda_dagua)
#
CREATE TABLE pe.hid_recife_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_recife_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_recife)
#
CREATE TABLE pe.rel_elemento_fisiog_natural(
	tipoelemnat smallint NOT NULL DEFAULT 99,
	CONSTRAINT rel_elemento_fisiog_natural_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiografico)
#
CREATE TABLE pe.hid_trecho_massa_dagua_a(
	tipotrechomassadagua smallint NOT NULL,
	id_trecho_curso_dagua uuid,
	CONSTRAINT hid_trecho_massa_dagua_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_massa_dagua_a)
#
ALTER TABLE pe.hid_trecho_massa_dagua_a OWNER TO postgres#
CREATE TABLE pe.hid_barragem_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_barragem_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_barragem)
#
CREATE TABLE pe.hid_sumidouro_vertedouro_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tiposumvert smallint NOT NULL,
	causa smallint NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_sumidouro_vertedouro_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)WITH ( OIDS = TRUE )#
ALTER TABLE pe.hid_sumidouro_vertedouro_p OWNER TO postgres#
CREATE TABLE pe.hid_terreno_suj_inundacao_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	periodicidadeinunda character(20),
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_terreno_sujeito_inundacao_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_terreno_suj_inundacao_a OWNER TO postgres#
CREATE TABLE pe.hid_trecho_drenagem_l(
	id serial NOT NULL,
	nome character(80),
	geometriaaproximada smallint NOT NULL,
	tipotrechodrenagem smallint NOT NULL,
	navegavel smallint,
	larguramedia real,
	regime smallint NOT NULL,
	encoberto smallint NOT NULL,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	id_trecho_curso_dagua uuid,
	CONSTRAINT hid_trecho_drenagem_l_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
ALTER TABLE pe.hid_trecho_drenagem_l OWNER TO postgres#
CREATE TABLE pe.hid_dique_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_dique_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_dique)
#
ALTER TABLE pe.hid_dique_l OWNER TO postgres#
CREATE TABLE pe.hid_dique_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_dique_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_dique)
#
ALTER TABLE pe.hid_dique_p OWNER TO postgres#
CREATE TABLE pe.hid_quebramar_molhe_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_quebramar_molhe_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_quebramar_molhe)
#
ALTER TABLE pe.hid_quebramar_molhe_a OWNER TO postgres#
CREATE TABLE pe.hid_banco_areia_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_banco_areia_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_banco_areia)
#
CREATE TABLE pe.hid_banco_areia_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_banco_areia_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_banco_areia)
#
ALTER TABLE pe.hid_banco_areia_a OWNER TO postgres#
CREATE TABLE pe.hid_barragem_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_barragem_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_barragem)
#
CREATE TABLE pe.hid_recife_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_recife_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_recife)
#
ALTER TABLE pe.hid_recife_l OWNER TO postgres#
CREATE TABLE pe.hid_recife_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_recife_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_recife)
#
ALTER TABLE pe.hid_recife_a OWNER TO postgres#
CREATE TABLE pe.hid_barragem_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_barragem_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_barragem)
#
CREATE TABLE pe.rel_alter_fisiog_antropica(
	tipoalterantrop smallint NOT NULL,
	CONSTRAINT rel_alter_fisiog_antropica_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiografico)
#
CREATE TABLE pe.rel_elemento_fisiog_natural_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT rel_elemento_fisiog_natural_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural)
#
CREATE TABLE pe.hid_comporta_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_comporta_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_comporta)
WITH ( OIDS = TRUE )#
CREATE TABLE pe.hid_queda_dagua_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_queda_dagua_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_queda_dagua)
#
CREATE TABLE pe.hid_queda_dagua_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_queda_dagua_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_queda_dagua)
#
CREATE TABLE pe.hid_corredeira_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_corredeira_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_corredeira)
#
CREATE TABLE pe.hid_corredeira_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_corredeira_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_corredeira)
#
CREATE TABLE pe.hid_comporta_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_comporta_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_comporta)
WITH ( OIDS = TRUE )#
ALTER TABLE pe.hid_comporta_l OWNER TO postgres#
CREATE TABLE pe.hid_corredeira_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_corredeira_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_corredeira)
#
CREATE TABLE pe.hid_ponto_inicio_drenagem_p(
	nascente smallint NOT NULL DEFAULT 0,
	CONSTRAINT hid_ponto_inicio_drenagem_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_ponto_drenagem_p)
#
CREATE TABLE pe.hid_confluencia_p(
	CONSTRAINT hid_confluencia_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_ponto_drenagem_p)
#
CREATE TABLE pe.hid_foz_maritima_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hid_foz_maritima_p_pk PRIMARY KEY (id)
) INHERITS(pe.hid_foz_maritima)
#
CREATE TABLE pe.hid_foz_maritima_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hid_foz_maritima_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_foz_maritima)
#
CREATE TABLE pe.hid_foz_maritima_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hid_foz_maritima_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_foz_maritima)
#
CREATE TABLE pe.veg_vegetacao_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoveg smallint NOT NULL,
	classificacaoporte smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_area_verde uuid,
	CONSTRAINT veg_vegetacao_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.veg_veg_cultivada_a(
	tipolavoura smallint NOT NULL,
	finalidade smallint,
	terreno smallint,
	cultivopredominante smallint[] NOT NULL,
	CONSTRAINT veg_veg_cultivada_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_vegetacao_a)
#
CREATE TABLE pe.veg_reflorestamento_a(
	espacamentoindividuos float,
	espessura float,
	alturamediaindividuos float,
	CONSTRAINT veg_reflorestamento_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_cultivada_a)
#
CREATE TABLE pe.veg_veg_natural_a(
	antropizada smallint,
	secundaria smallint,
	densidade smallint,
	CONSTRAINT veg_veg_natural_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_vegetacao_a)
#
CREATE TABLE pe.veg_veg_area_contato_a(
	tipovegcontato smallint[],
	CONSTRAINT veg_veg_area_contato_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.veg_campo_a(
	tipocampo smallint NOT NULL,
	CONSTRAINT veg_campo_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.veg_cerrado_a(
	vereda smallint,
	CONSTRAINT veg_cerrado_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.veg_caatinga_a(
	CONSTRAINT veg_caatinga_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.veg_campinarana_a(
	CONSTRAINT veg_campinarana_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.veg_veg_restinga_a(
	CONSTRAINT veg_veg_restinga_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.veg_mangue_a(
	tipomanguezal smallint,
	CONSTRAINT veg_mangue_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.veg_brejo_pantano_a(
	CONSTRAINT veg_brejo_pantano_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.veg_floresta_a(
	especiepredominante smallint,
	CONSTRAINT veg_floresta_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
CREATE TABLE pe.rel_isolinha_hipsometrica(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	CONSTRAINT rel_isolinha_hipsometrica_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.rel_curva_nivel_l(
	cota integer NOT NULL,
	depressao smallint NOT NULL DEFAULT 2,
	tipocurvanivel smallint NOT NULL,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT rel_curva_nivel_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_isolinha_hipsometrica)
#
CREATE TABLE pe.rel_curva_batimetrica_l(
	profundidade integer NOT NULL,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT rel_curva_batimetrica_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_isolinha_hipsometrica)
#
CREATE TABLE pe.rel_terreno_exposto_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	tipoterrexp smallint,
	causaexposicao smallint,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT rel_terreno_exposto_a_pk PRIMARY KEY (id)
)#
CREATE TABLE pe.rel_terreno_erodido(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	situacaoterreno smallint,
	tipoerosao smallint,
	CONSTRAINT rel_terreno_erodido_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.rel_terreno_erodido_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT rel_terreno_erodido_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_terreno_erodido)
#
CREATE TABLE pe.rel_terreno_erodido_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT rel_terreno_erodido_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_terreno_erodido)
#
CREATE TABLE pe.rel_terreno_erodido_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT rel_terreno_erodido_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_terreno_erodido)
#
CREATE TABLE pe.rel_ponto_hipsometrico(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	CONSTRAINT rel_ponto_hipsometrico_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.rel_ponto_cotado_batimetrico_p(
	profundidade float NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT rel_ponto_cotado_batimetrico_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_ponto_hipsometrico)
#
CREATE TABLE pe.rel_ponto_cotado_altimetrico_p(
	cotacomprovada smallint NOT NULL,
	cota float,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT rel_ponto_cotado_altimetrico_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_ponto_hipsometrico)
#
CREATE TABLE pe.rel_alter_fisiog_antropica_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT rel_alter_fisiog_antropica_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica)
#
CREATE TABLE pe.rel_elemento_fisiog_natural_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT rel_elemento_fisiog_natural_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural)
#
CREATE TABLE pe.rel_rocha_p(
	formarocha smallint,
	CONSTRAINT rel_rocha_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_p)
#
CREATE TABLE ge.edf_edificacao(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	nome varchar(80),
	numero integer,
	bloco varchar(80),
	operacional smallint,
	situacaofisica smallint,
	matconstr smallint,
	numeropavimentos integer,
	alturaaproximada real,
	turistica smallint,
	cultura smallint,
	administracao smallint[],
	classeativecon smallint[],
	divisaoativecon smallint[],
	grupoativecon smallint[],
	proprioadm smallint,
	numerosequencial integer,
	numerometrico integer,
	cep varchar(80),
	pais varchar(80),
	unidadefederacao varchar(2),
	municipio varchar(80),
	bairro varchar(80),
	logradouro varchar(200),
	id_assentamento_precario uuid,
	id_complexo_habitacional uuid,
	CONSTRAINT edf_edificacao_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.rel_alter_fisiog_antropica_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT rel_alter_fisiog_antropica_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica)
#
CREATE TABLE pe.rel_alter_fisiog_antropica_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT rel_alter_fisiog_antropica_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica)
#
CREATE TABLE pe.eco_ext_mineral_p(
	secaoativecon smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	tipoextmin smallint NOT NULL,
	tipoproduto smallint[] NOT NULL,
	tipopocomina smallint NOT NULL,
	procextracao smallint,
	formaextracao smallint NOT NULL,
	atividade smallint NOT NULL,
	id_org_ext_mineral uuid,
	CONSTRAINT eco_ext_mineral_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_p)
#
CREATE TABLE pe.eco_ext_mineral_l(
	secaoativecon smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	tipoextmin smallint NOT NULL,
	tipoproduto smallint[] NOT NULL,
	tipopocomina smallint NOT NULL,
	procextracao smallint,
	formaextracao smallint NOT NULL,
	atividade smallint NOT NULL,
	id_org_ext_mineral uuid,
	CONSTRAINT eco_ext_mineral_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_l)
#
CREATE TABLE pe.eco_ext_mineral_a(
	secaoativecon smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	tipoextmin smallint NOT NULL,
	tipoproduto smallint[] NOT NULL,
	tipopocomina smallint NOT NULL,
	procextracao smallint,
	formaextracao smallint NOT NULL,
	atividade smallint NOT NULL,
	id_org_ext_mineral uuid,
	CONSTRAINT eco_ext_mineral_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_a)
#
CREATE TABLE pe.rel_corte_p(
	matconstr smallint[] NOT NULL,
	CONSTRAINT rel_corte_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_p)
#
CREATE TABLE ge.edf_edificacao_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT edf_edificacao_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao)
#
CREATE TABLE pe.rel_corte_l(
	matconstr smallint[] NOT NULL,
	CONSTRAINT rel_corte_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_l)
#
CREATE TABLE pe.rel_duna_l(
	fixa smallint NOT NULL,
	CONSTRAINT rel_duna_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_l)
#
CREATE TABLE pe.rel_corte_a(
	matconstr smallint[] NOT NULL,
	CONSTRAINT rel_corte_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_a)
#
CREATE TABLE pe.rel_aterro_p(
	matconstr smallint[] NOT NULL,
	CONSTRAINT rel_aterro_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_p)
#
CREATE TABLE pe.rel_aterro_l(
	matconstr smallint[] NOT NULL,
	CONSTRAINT rel_aterro_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_l)
#
CREATE TABLE pe.rel_aterro_a(
	matconstr smallint[] NOT NULL,
	CONSTRAINT rel_aterro_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_a)
#
CREATE TABLE pe.hid_canal_vala_l(
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	matconstr smallint[] NOT NULL,
	finalidade smallint,
	usoprincipal smallint NOT NULL,
	CONSTRAINT hid_canal_vala_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_l)
#
CREATE TABLE pe.hid_canal_vala_a(
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	usoprincipal smallint NOT NULL,
	matconstr smallint[] NOT NULL,
	finalidade smallint,
	CONSTRAINT hid_canal_vala_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_alter_fisiog_antropica_a)
#
CREATE TABLE pe.hid_vala_l(
	CONSTRAINT hid_vala_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_canal_vala_l)
#
CREATE TABLE pe.hid_vala_a(
	CONSTRAINT hid_vala_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_canal_vala_a)
#
CREATE TABLE complexos.hid_arquipelago(
	id uuid NOT NULL,
	nome varchar(80),
	jurisdicao smallint NOT NULL,
	CONSTRAINT hid_arquipelago_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.rel_duna_p(
	fixa smallint NOT NULL,
	CONSTRAINT rel_duna_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_p)
#
CREATE TABLE ge.edf_edificacao_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT edf_edificacao_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao)
#
CREATE TABLE pe.rel_gruta_caverna_l(
	CONSTRAINT rel_gruta_caverna_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_l)
#
CREATE TABLE pe.rel_elemento_fisiog_natural_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT rel_elemento_fisiog_natural_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural)
#
CREATE TABLE ge.edf_edif_habitacional_p(
	CONSTRAINT edf_edif_habitacional_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
ALTER TABLE ge.edf_edif_habitacional_p OWNER TO postgres#
CREATE TABLE pe.rel_gruta_caverna_p(
	CONSTRAINT rel_gruta_caverna_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_p)
#
CREATE TABLE ge.edf_edif_abast_agua_p(
	tipoedifabast smallint NOT NULL,
	id_complexo_abast_agua uuid,
	CONSTRAINT edf_edif_abast_agua_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_saneamento_p(
	tipoedifsaneam smallint NOT NULL,
	id_complexo_saneamento uuid,
	CONSTRAINT edf_edif_saneamento_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE pe.rel_duna_a(
	fixa smallint NOT NULL,
	CONSTRAINT rel_duna_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_a)
#
CREATE TABLE pe.hid_ilha_l(
	tipoilha smallint NOT NULL,
	id_arquipelago uuid,
	CONSTRAINT hid_ilha_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_l)
#
ALTER TABLE pe.hid_ilha_l OWNER TO postgres#
CREATE TABLE pe.hid_ilha_a(
	tipoilha smallint NOT NULL,
	id_arquipelago uuid,
	CONSTRAINT hid_ilha_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_a)
#
ALTER TABLE pe.hid_ilha_a OWNER TO postgres#
CREATE TABLE pe.rel_dolina_a(
	CONSTRAINT rel_dolina_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_a)
#
CREATE TABLE pe.rel_rocha_l(
	formarocha smallint,
	CONSTRAINT rel_rocha_l_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_l)
#
CREATE TABLE pe.rel_rocha_a(
	formarocha smallint,
	CONSTRAINT rel_rocha_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_a)
#
CREATE TABLE pe.rel_pico_p(
	CONSTRAINT rel_pico_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_p)
#
CREATE TABLE ge.edf_edif_residencial_p(
	id_complexo_habitacional uuid,
	CONSTRAINT edf_edif_residencial_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_habitacional_p)
#
CREATE TABLE ge.edf_edif_habitacional_a(
	CONSTRAINT edf_edif_habitacional_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
ALTER TABLE ge.edf_edif_habitacional_a OWNER TO postgres#
CREATE TABLE ge.edf_edif_saude_p(
	nivelatencao smallint NOT NULL,
	id_org_saude uuid,
	CONSTRAINT edf_edif_saude_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_servico_social_p(
	id_org_servico_social uuid,
	CONSTRAINT edf_edif_servico_social_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE pe.hid_ilha_p(
	tipoilha smallint NOT NULL,
	id_arquipelago uuid,
	CONSTRAINT hid_ilha_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_p)
#
ALTER TABLE pe.hid_ilha_p OWNER TO postgres#
CREATE TABLE pe.rel_dolina_p(
	CONSTRAINT rel_dolina_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_elemento_fisiog_natural_p)
#
CREATE TABLE ge.edf_edif_abast_agua_a(
	tipoedifabast smallint NOT NULL,
	id_complexo_abast_agua uuid,
	CONSTRAINT edf_edif_abast_agua_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_saneamento_a(
	tipoedifsaneam smallint NOT NULL DEFAULT 0,
	id_complexo_saneamento uuid,
	CONSTRAINT edf_edif_saneamento_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_pub_militar_p(
	tipousoedif smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	tipoinstalmilitar smallint NOT NULL DEFAULT 0,
	organizacao varchar(80),
	CONSTRAINT edf_edif_pub_militar_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_pub_militar_a(
	tipousoedif smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	tipoinstalmilitar smallint NOT NULL,
	organizacao varchar(80),
	CONSTRAINT edf_edif_pub_militar_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_servico_social_a(
	id_org_servico_social uuid,
	CONSTRAINT edf_edif_servico_social_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_ensino_a(
	id_org_ensino uuid,
	CONSTRAINT edf_edif_ensino_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_pub_civil_p(
	tipousoedif smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	organizacao varchar(80),
	id_complexo_desportivo_lazer uuid,
	tipoedifpubcivil smallint[] NOT NULL,
	CONSTRAINT edf_edif_pub_civil_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_pub_civil_a(
	tipousoedif smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	organizacao varchar(80),
	id_complexo_desportivo_lazer uuid,
	tipoedifpubcivil smallint[],
	CONSTRAINT edf_edif_pub_civil_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_religiosa_p(
	tipoedifrelig smallint NOT NULL,
	ensino smallint NOT NULL,
	religiao varchar(80),
	id_org_religiosa uuid,
	crista smallint NOT NULL,
	CONSTRAINT edf_edif_religiosa_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_saude_a(
	nivelatencao smallint NOT NULL,
	id_org_saude uuid,
	CONSTRAINT edf_edif_saude_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_residencial_a(
	id_complexo_habitacional uuid,
	CONSTRAINT edf_edif_residencial_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_habitacional_a)
#
CREATE TABLE ge.edf_edif_religiosa_a(
	tipoedifrelig smallint NOT NULL,
	ensino smallint NOT NULL,
	religiao varchar(80),
	id_org_religiosa uuid,
	crista smallint NOT NULL,
	CONSTRAINT edf_edif_religiosa_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_constr_lazer_p(
	tipoediflazer smallint NOT NULL,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT edf_edif_constr_lazer_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_constr_lazer_a(
	tipoediflazer smallint NOT NULL,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT edf_edif_constr_lazer_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE pe.hid_rocha_em_agua_p(
	situacaoemagua smallint NOT NULL,
	alturalamina real,
	CONSTRAINT hid_rocha_em_agua_p_pk PRIMARY KEY (id)
) INHERITS(pe.rel_rocha_p)
#
ALTER TABLE pe.hid_rocha_em_agua_p OWNER TO postgres#
CREATE TABLE pe.hid_rocha_em_agua_a(
	situacaoemagua smallint NOT NULL,
	alturalamina float,
	CONSTRAINT hid_rocha_em_agua_a_pk PRIMARY KEY (id)
) INHERITS(pe.rel_rocha_a)
#
ALTER TABLE pe.hid_rocha_em_agua_a OWNER TO postgres#
CREATE TABLE ge.edf_representacao_diplomatica_p(
	tiporepdiplomatica smallint NOT NULL,
	CONSTRAINT edf_representacao_diplomatica_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_representacao_diplomatica_a(
	tiporepdiplomatica smallint NOT NULL,
	CONSTRAINT edf_representacao_diplomatica_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_constr_turistica_p(
	tipoedifturist smallint NOT NULL,
	ovgd smallint,
	tombada smallint,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT edf_edif_constr_turistica_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_constr_turistica_a(
	tipoedifturist smallint NOT NULL,
	ovgd smallint NOT NULL,
	tombada smallint,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT edf_edif_constr_turistica_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_comerc_serv_p(
	tipoedifcomercserv smallint[] NOT NULL,
	finalidade smallint[] NOT NULL,
	id_estrut_transporte uuid,
	id_org_comerc_serv uuid,
	CONSTRAINT edf_edif_comerc_serv_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_comerc_serv_a(
	tipoedifcomercserv smallint[] NOT NULL,
	finalidade smallint[] NOT NULL,
	id_estrut_transporte uuid,
	id_org_comerc_serv uuid,
	CONSTRAINT edf_edif_comerc_serv_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_constr_est_med_fen_p(
	id_est_med_fenomenos uuid,
	CONSTRAINT edf_edif_constr_est_med_fen_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_constr_est_med_fen_a(
	id_est_med_fenomenos uuid,
	CONSTRAINT edf_edif_constr_est_med_fen_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_policia_p(
	CONSTRAINT edf_edif_policia_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_civil_p)
#
CREATE TABLE ge.edf_edif_policia_a(
	CONSTRAINT edf_edif_policia_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_civil_a)
#
CREATE TABLE pe.sb_dep_abast_agua(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	tipodepgeral smallint NOT NULL,
	matconstr smallint[],
	tipoexposicao smallint NOT NULL,
	unidadevolume smallint,
	valorvolume float,
	situacaoagua smallint NOT NULL,
	tratamento smallint NOT NULL,
	finalidadedep smallint NOT NULL,
	sigla varchar(80),
	codequipdesenvsocial varchar(80),
	tipoequipdesenvsocial smallint,
	localizacaoequipdesenvsocial smallint,
	id_complexo_abast_agua uuid,
	CONSTRAINT sb_dep_abast_agua_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.edf_posto_guarda_municipal_p(
	CONSTRAINT edf_posto_guarda_municipal_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_civil_p)
#
CREATE TABLE pe.sb_dep_abast_agua_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT sb_dep_abast_agua_a_pk PRIMARY KEY (id)
) INHERITS(pe.sb_dep_abast_agua)
#
CREATE TABLE ge.edf_posto_guarda_municipal_a(
	CONSTRAINT edf_posto_guarda_municipal_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_civil_a)
#
CREATE TABLE ge.edf_posto_fiscal_p(
	tipopostofisc smallint NOT NULL,
	concessionaria varchar(80),
	id_estrut_transporte uuid,
	CONSTRAINT edf_posto_fiscal_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_civil_p)
#
CREATE TABLE ge.edf_posto_fiscal_a(
	tipopostofisc smallint NOT NULL,
	concessionaria varchar(80),
	id_estrut_transporte uuid,
	CONSTRAINT edf_posto_fiscal_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_civil_a)
#
CREATE TABLE pe.sb_dep_saneamento(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	tipodepgeral smallint NOT NULL,
	matconstr smallint[],
	tipoexposicao smallint NOT NULL,
	tipoprodutoresiduo smallint[],
	tipoconteudo smallint[],
	unidadevolume smallint,
	valorvolume float,
	tratamento smallint NOT NULL,
	estadofisico smallint NOT NULL,
	finalidadedep smallint NOT NULL,
	id_complexo_saneamento uuid,
	CONSTRAINT sb_dep_saneamento_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.sb_dep_saneamento_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT sb_dep_saneamento_a_pk PRIMARY KEY (id)
) INHERITS(pe.sb_dep_saneamento)
#
CREATE TABLE pe.eco_deposito_geral(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	tipodepgeral smallint[],
	matconstr smallint[],
	tipoexposicao smallint NOT NULL,
	tipoprodutoresiduo smallint[],
	tipoconteudo smallint[],
	unidadevolume smallint,
	valorvolume float,
	id_org_comerc_serv uuid,
	id_org_ext_mineral uuid,
	id_org_agropec_ext_veg_pesca uuid,
	id_complexo_gerador_energia_eletrica uuid,
	id_estrut_transporte uuid,
	id_org_industrial uuid,
	CONSTRAINT eco_deposito_geral_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.eco_deposito_geral_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT eco_deposito_geral_a_pk PRIMARY KEY (id)
) INHERITS(pe.eco_deposito_geral)
#
CREATE TABLE complexos.adm_org_industrial(
	id uuid NOT NULL,
	nome varchar(80),
	secaoativecon smallint NOT NULL DEFAULT 0,
	id_org_pub_civil uuid,
	id_org_pub_militar uuid,
	CONSTRAINT eco_org_industrial_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.eco_madeireira(
	id_org_agropec_ext_veg_pesca uuid,
	CONSTRAINT eco_madeireira_pk PRIMARY KEY (id)
) INHERITS(complexos.adm_org_industrial)
#
CREATE TABLE pe.eco_equip_agropec(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	tipoequipagropec smallint NOT NULL,
	matconstr smallint[],
	id_org_agropec_ext_veg_pesca uuid,
	CONSTRAINT eco_equip_agropec_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.eco_equip_agropec_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT eco_equip_agropec_l_pk PRIMARY KEY (id)
) INHERITS(pe.eco_equip_agropec)
#
CREATE TABLE pe.eco_equip_agropec_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT eco_equip_agropec_a_pk PRIMARY KEY (id)
) INHERITS(pe.eco_equip_agropec)
#
CREATE TABLE pe.eco_plataforma(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoplataforma smallint NOT NULL,
	id_org_ext_mineral uuid,
	CONSTRAINT eco_plataforma_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.eco_plataforma_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT eco_plataforma_a_pk PRIMARY KEY (id)
) INHERITS(pe.eco_plataforma)
#
CREATE TABLE complexos.edu_org_ensino(
	id uuid NOT NULL,
	nome varchar(80),
	administracao smallint NOT NULL,
	grupoativecon smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	CONSTRAINT edu_org_ensino_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.edu_org_ensino_militar(
	id_org_pub_militar uuid,
	CONSTRAINT edu_org_ensino_militar_pk PRIMARY KEY (id)
) INHERITS(complexos.edu_org_ensino)
#
CREATE TABLE complexos.edu_org_ensino_pub(
	id_org_pub_militar uuid,
	id_org_pub_civil uuid,
	CONSTRAINT edu_org_ensino_pub_pk PRIMARY KEY (id)
) INHERITS(complexos.edu_org_ensino)
#
CREATE TABLE complexos.edu_org_ensino_religiosa(
	id_org_religiosa uuid,
	CONSTRAINT edu_org_ensino_religiosa_pk PRIMARY KEY (id)
) INHERITS(complexos.edu_org_ensino)
#
CREATE TABLE pe.enc_grupo_transformadores(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	id_subest_transm_distrib_energia_eletrica uuid,
	CONSTRAINT enc_grupo_transformadores_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.enc_grupo_transformadores_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT enc_grupo_transformadores_a_pk PRIMARY KEY (id)
) INHERITS(pe.enc_grupo_transformadores)
#
CREATE TABLE pe.enc_est_gerad_energia_eletrica(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoestgerad smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	potencia float,
	id_complexo_gerador_energia_eletrica uuid,
	CONSTRAINT enc_est_gerad_energia_eletrica_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.enc_est_gerad_energia_eletrica_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT enc_est_gerad_energia_eletrica_l_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica)
#
CREATE TABLE pe.enc_est_gerad_energia_eletrica_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT enc_est_gerad_energia_eletrica_a_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica)
#
CREATE TABLE pe.enc_termeletrica_l(
	tipocombustivel smallint NOT NULL,
	CONSTRAINT enc_termeletrica_l_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica_l)
#
CREATE TABLE pe.enc_termeletrica_a(
	tipocombustivel smallint NOT NULL,
	CONSTRAINT enc_termeletrica_a_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica_a)
#
CREATE TABLE pe.enc_est_gerad_energia_eletrica_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT enc_est_gerad_energia_eletrica_p_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica)
#
CREATE TABLE pe.enc_hidreletrica_p(
	CONSTRAINT enc_hidreletrica_p_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica_p)
#
CREATE TABLE pe.enc_hidreletrica_l(
	CONSTRAINT enc_hidreletrica_l_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica_l)
#
CREATE TABLE pe.enc_hidreletrica_a(
	CONSTRAINT enc_hidreletrica_a_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica_a)
#
CREATE TABLE ge.edf_edif_energia_p(
	tipoedifenergia smallint[] NOT NULL,
	id_complexo_gerador_energia_eletrica uuid,
	id_subest_transm_distrib_energia_eletrica uuid,
	CONSTRAINT edf_edif_energia_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE pe.pto_pto_geod_topo_controle_p(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	tiporef smallint NOT NULL,
	latitude varchar(15) NOT NULL,
	longitude varchar(15) NOT NULL,
	altitudeortometrica float,
	altitudegeometrica float,
	sistemageodesico smallint NOT NULL,
	outrarefplan varchar(80),
	referencialaltim smallint NOT NULL,
	outrarefalt varchar(80),
	orgaoenteresp varchar(80),
	codponto varchar(80),
	obs varchar(80),
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT pto_pto_geod_topo_controle_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.edf_edif_energia_a(
	tipoedifenergia smallint[] NOT NULL,
	id_complexo_gerador_energia_eletrica uuid,
	id_subest_transm_distrib_energia_eletrica uuid,
	CONSTRAINT edf_edif_energia_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE pe.pto_pto_controle_p(
	tipoptocontrole smallint NOT NULL,
	materializado smallint NOT NULL DEFAULT 0,
	codprojeto varchar(80),
	CONSTRAINT pto_pto_controle_p_pk PRIMARY KEY (id)
) INHERITS(pe.pto_pto_geod_topo_controle_p)
#
CREATE TABLE ge.edf_edif_comunic_p(
	tipoedifcomunic smallint[] NOT NULL,
	modalidade smallint[] NOT NULL,
	id_complexo_comunicacao uuid,
	CONSTRAINT edf_edif_comunic_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE pe.aer_pista_ponto_pouso(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipopista smallint NOT NULL,
	revestimento smallint NOT NULL,
	usopista smallint NOT NULL,
	homologacao smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	largura float,
	extensao float,
	altitude real,
	id_complexo_aeroportuario uuid,
	CONSTRAINT aer_pista_ponto_pouso_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.edf_edif_comunic_a(
	tipoedifcomunic smallint[] NOT NULL,
	modalidade smallint[] NOT NULL,
	id_complexo_comunicacao uuid,
	CONSTRAINT edf_edif_comunic_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE pe.aer_pista_ponto_pouso_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT aer_pista_ponto_pouso_l_pk PRIMARY KEY (id)
) INHERITS(pe.aer_pista_ponto_pouso)
#
CREATE TABLE ge.edf_edif_constr_aeroportuaria_p(
	tipoedifaero smallint[] NOT NULL,
	jurisdicao smallint,
	concessionaria varchar(100),
	id_complexo_aeroportuario uuid,
	CONSTRAINT edf_edif_constr_aeroportuaria_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE pe.aer_pista_ponto_pouso_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT aer_pista_ponto_pouso_a_pk PRIMARY KEY (id)
) INHERITS(pe.aer_pista_ponto_pouso)
#
CREATE TABLE ge.edf_edif_constr_portuaria_a(
	tipoedifport smallint[] NOT NULL,
	jurisdicao smallint,
	concessionaria varchar(80),
	id_complexo_portuario uuid,
	id_org_industrial uuid,
	CONSTRAINT edf_edif_constr_portuaria_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE pe.dut_trecho_duto_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipotrechoduto smallint NOT NULL,
	mattransp smallint[],
	setor smallint NOT NULL,
	posicaorelativa smallint,
	matconstr smallint[],
	nrdutos integer,
	situacaoespacial smallint,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	id_duto uuid,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT dut_trecho_duto_l_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.edf_edif_metro_ferroviaria_p(
	tipoedifmetroferrov smallint[] NOT NULL,
	jurisdicao smallint,
	concessionaria varchar(80),
	id_estrut_apoio uuid,
	CONSTRAINT edf_edif_metro_ferroviaria_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE complexos.tra_estrut_transporte(
	id uuid NOT NULL,
	nome varchar(80),
	modaluso smallint[] NOT NULL,
	administracao smallint,
	jurisdicao smallint,
	concessionaria varchar(100),
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	CONSTRAINT tra_estrut_transporte_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.edf_edif_constr_portuaria_p(
	tipoedifport smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	concessionaria varchar(80),
	id_complexo_portuario uuid,
	id_org_industrial uuid,
	CONSTRAINT edf_edif_constr_portuaria_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE complexos.tra_estrut_apoio(
	tipoestrut smallint NOT NULL,
	tipoexposicao smallint NOT NULL,
	CONSTRAINT tra_estrut_apoio_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_transporte)
#
CREATE TABLE ge.edf_edif_constr_aeroportuaria_a(
	tipoedifaero smallint[] NOT NULL,
	jurisdicao smallint,
	concessionaria varchar(80),
	id_complexo_aeroportuario uuid,
	CONSTRAINT edf_edif_constr_aeroportuaria_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE complexos.fer_estacao_ferroviaria(
	CONSTRAINT fer_estacao_ferroviaria_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_apoio)
#
CREATE TABLE ge.edf_edif_metro_ferroviaria_a(
	tipoedifmetroferrov smallint[] NOT NULL,
	jurisdicao smallint,
	concessionaria varchar(80),
	id_estrut_apoio uuid,
	CONSTRAINT edf_edif_metro_ferroviaria_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_rodoviaria_p(
	tipoedifrod smallint[] NOT NULL,
	jurisdicao smallint,
	concessionaria varchar(80),
	id_estrut_apoio uuid,
	CONSTRAINT edf_edif_rodoviaria_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE complexos.fer_estacao_metroviaria(
	CONSTRAINT fer_estacao_metroviaria_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_apoio)
#
CREATE TABLE ge.edf_edif_rodoviaria_a(
	tipoedifrod smallint[] NOT NULL,
	jurisdicao smallint NOT NULL,
	concessionaria varchar(80),
	id_estrut_apoio uuid,
	CONSTRAINT edf_edif_rodoviaria_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_banheiro_publico_p(
	CONSTRAINT edf_banheiro_publico_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.edf_edif_ext_mineral_p(
	id_org_ext_mineral uuid,
	CONSTRAINT edf_edif_ext_mineral_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE complexos.rod_estacao_rodoviaria(
	CONSTRAINT rod_estacao_rodoviaria_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_apoio)
#
CREATE TABLE ge.edf_edif_ext_mineral_a(
	id_org_ext_mineral uuid,
	CONSTRAINT edf_edif_ext_mineral_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE complexos.aer_complexo_aeroportuario(
	siglaicao varchar(4),
	tipocomplexoaero smallint NOT NULL,
	classificacao smallint NOT NULL,
	latoficial varchar(80),
	altitude integer,
	siglaiata varchar(3),
	longoficial varchar(80),
	CONSTRAINT aer_complexo_aeroportuario_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_transporte)
#
CREATE TABLE ge.edf_edif_agropec_ext_veg_pesca_p(
	tipoedifagropec smallint[] NOT NULL,
	id_org_agropec_ext_veg_pesca uuid,
	CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE pe.sb_dep_abast_agua_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT sb_dep_abast_agua_p_pk PRIMARY KEY (id)
) INHERITS(pe.sb_dep_abast_agua)
#
CREATE TABLE ge.edf_edif_agropec_ext_veg_pesca_a(
	tipoedifagropec smallint[] NOT NULL,
	id_org_agropec_ext_veg_pesca uuid,
	CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE ge.edf_edif_industrial_p(
	chamine smallint,
	id_org_industrial uuid,
	CONSTRAINT edf_edif_industrial_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE pe.sb_dep_saneamento_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT sb_dep_saneamento_p_pk PRIMARY KEY (id)
) INHERITS(pe.sb_dep_saneamento)
#
CREATE TABLE ge.edf_edif_industrial_a(
	chamine smallint,
	id_org_industrial uuid,
	CONSTRAINT edf_edif_industrial_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE pe.eco_deposito_geral_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT eco_deposito_geral_p_pk PRIMARY KEY (id)
) INHERITS(pe.eco_deposito_geral)
#
CREATE TABLE pe.tra_patio(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	modaluso smallint[],
	administracao smallint[],
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	finalidadepatio smallint[] NOT NULL,
	id_estrut_transporte uuid,
	id_org_ext_mineral uuid,
	id_org_comerc_serv uuid,
	id_org_industrial uuid,
	id_org_ensino uuid,
	CONSTRAINT tra_patio_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE ge.edf_banheiro_publico_a(
	CONSTRAINT edf_banheiro_publico_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
CREATE TABLE complexos.eco_frigorifico_matadouro(
	frigorifico smallint NOT NULL,
	id_org_agropec_ext_veg_pesca uuid,
	CONSTRAINT eco_frigorifico_matadouro_pk PRIMARY KEY (id)
) INHERITS(complexos.adm_org_industrial)
#
CREATE TABLE pe.tra_patio_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT tra_patio_a_pk PRIMARY KEY (id)
) INHERITS(pe.tra_patio)
#
CREATE TABLE pe.eco_equip_agropec_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT eco_equip_agropec_p_pk PRIMARY KEY (id)
) INHERITS(pe.eco_equip_agropec)
#
CREATE TABLE pe.tra_patio_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT tra_patio_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_patio)
#
CREATE TABLE complexos.sb_complexo_saneamento(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	classeativecon smallint NOT NULL,
	administracao smallint NOT NULL,
	operacional smallint,
	organizacao varchar(80),
	id_org_comerc_serv uuid,
	id_org_pub_civil uuid,
	CONSTRAINT sb_complexo_saneamento_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.sb_complexo_abast_agua(
	id uuid NOT NULL,
	nome varchar(80),
	classeativecon smallint NOT NULL,
	administracao smallint NOT NULL,
	operacional smallint,
	organizacao varchar(80),
	id_org_comerc_serv uuid,
	id_org_pub_civil uuid,
	CONSTRAINT sb_complexo_abast_agua_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_estacionamento_a(
	publico smallint NOT NULL,
	CONSTRAINT cb_estacionamento_a_pk PRIMARY KEY (id)
) INHERITS(pe.tra_patio_a)
#
CREATE TABLE pe.eco_plataforma_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT eco_plataforma_p_pk PRIMARY KEY (id)
) INHERITS(pe.eco_plataforma)
#
CREATE TABLE pe.tra_funicular(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	operacional smallint NOT NULL DEFAULT 0,
	situacaofisica smallint NOT NULL DEFAULT 0,
	id_org_ext_mineral uuid,
	CONSTRAINT tra_funicular_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE complexos.adm_org_comerc_serv(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	divisaoativecon smallint NOT NULL DEFAULT 0,
	finalidade smallint NOT NULL DEFAULT 0,
	id_org_pub_civil uuid,
	CONSTRAINT adm_org_comerc_serv_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.tra_funicular_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT tra_funicular_l_pk PRIMARY KEY (id)
) INHERITS(pe.tra_funicular)
#
CREATE TABLE complexos.edu_org_ensino_privada(
	id_org_comerc_serv uuid,
	CONSTRAINT edu_org_ensino_privada_pk PRIMARY KEY (id)
) INHERITS(complexos.edu_org_ensino)
#
CREATE TABLE pe.tra_obra_de_arte_viaria(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	modaluso smallint[] NOT NULL,
	matconstr smallint[] NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	necessitamanutencao smallint,
	largura float,
	extensao float,
	nrfaixas integer,
	nrpistas integer,
	posicaopista smallint NOT NULL,
	id_via_ferrea uuid,
	tipopavimentacao smallint NOT NULL,
	CONSTRAINT tra_obra_de_arte_viaria_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.tra_passagem_elevada_viaduto(
	tipopassagviad smallint NOT NULL,
	vaolivrehoriz float,
	vaovertical float,
	gabhorizsup float,
	gabvertsup float,
	cargasuportmaxima float,
	CONSTRAINT tra_passagem_elevada_viaduto_pk PRIMARY KEY (id)
) INHERITS(pe.tra_obra_de_arte_viaria)
#
CREATE TABLE pe.tra_passagem_elevada_viaduto_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT tra_passagem_elevada_viaduto_l_pk PRIMARY KEY (id)
) INHERITS(pe.tra_passagem_elevada_viaduto)
#
CREATE TABLE complexos.adm_org_ext_mineral(
	id uuid NOT NULL,
	nome varchar(80),
	secaoativecon smallint NOT NULL DEFAULT 0,
	CONSTRAINT eco_org_ext_mineral_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.adm_org_agropec_ext_veg_pesca(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	divisaoativecon smallint NOT NULL,
	id_org_industrial uuid,
	CONSTRAINT org_agropec_ext_vegetal_pesca_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_agropec_ext_veg_pesca_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	destinadoa smallint NOT NULL,
	id_org_agropec_ext_veg_pesca uuid,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_agropec_ext_vegetal_pesca_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.tra_ponte(
	tipoponte smallint NOT NULL,
	vaolivrehoriz float,
	vaovertical float,
	cargasuportmaxima float,
	CONSTRAINT tra_ponte_pk PRIMARY KEY (id)
) INHERITS(pe.tra_obra_de_arte_viaria)
#
CREATE TABLE pe.enc_grupo_transformadores_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT enc_grupo_transformadores_p_pk PRIMARY KEY (id)
) INHERITS(pe.enc_grupo_transformadores)
#
CREATE TABLE pe.tra_ponte_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT tra_ponte_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_ponte)
#
CREATE TABLE pe.tra_ponte_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT tra_ponte_l_pk PRIMARY KEY (id)
) INHERITS(pe.tra_ponte)
#
CREATE TABLE pe.tra_tunel(
	altura float,
	tipotunel smallint NOT NULL,
	CONSTRAINT tra_tunel_pk PRIMARY KEY (id)
) INHERITS(pe.tra_obra_de_arte_viaria)
#
CREATE TABLE pe.tra_tunel_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT tra_tunel_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_tunel)
#
CREATE TABLE pe.tra_tunel_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT tra_tunel_l_pk PRIMARY KEY (id)
) INHERITS(pe.tra_tunel)
#
CREATE TABLE ge.emu_acesso(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	matconstr smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaoespacial smallint NOT NULL,
	CONSTRAINT emu_acesso_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE ge.cb_area_ext_mineral_a(
	id serial NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	geometriaaproximada smallint NOT NULL,
	id_org_ext_mineral uuid,
	CONSTRAINT cb_area_ext_mineral_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.emu_acesso_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT emu_acesso_l_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso)
#
CREATE TABLE pe.enc_termeletrica_p(
	tipocombustivel smallint NOT NULL,
	CONSTRAINT enc_termeletrica_p_pk PRIMARY KEY (id)
) INHERITS(pe.enc_est_gerad_energia_eletrica_p)
#
CREATE TABLE ge.emu_acesso_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT emu_acesso_a_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso)
#
CREATE TABLE pe.tra_travessia_pedestre(
	tipotravessiaped smallint NOT NULL,
	largura float,
	extensao float,
	matconstr smallint NOT NULL DEFAULT 0,
	CONSTRAINT tra_travessia_pedestre_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso)
#
CREATE TABLE pe.tra_travessia_pedestre_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT tra_travessia_pedestre_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_travessia_pedestre)
#
CREATE TABLE complexos.enc_complexo_gerador_energia_eletrica(
	id uuid NOT NULL,
	nome varchar(80),
	classeativecon smallint NOT NULL,
	organizacao varchar(80),
	id_org_comerc_serv uuid,
	operacional smallint NOT NULL,
	CONSTRAINT enc_complexo_gerador_energia_eletrica_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.enc_subest_transm_distrib_energia_eletrica(
	id uuid NOT NULL,
	nome varchar(80),
	classeativecon smallint NOT NULL,
	operacional smallint NOT NULL,
	id_complexo_gerador_energia_eletrica uuid,
	CONSTRAINT enc_subest_transm_distrib_energia_eletrica_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.enc_complexo_comunicacao(
	id uuid NOT NULL,
	nome varchar(80),
	classeativecon smallint NOT NULL,
	organizacao varchar(80),
	id_org_comerc_serv uuid,
	CONSTRAINT enc_complexo_comunicacao_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.tra_travessia_pedestre_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT tra_travessia_pedestre_l_pk PRIMARY KEY (id)
) INHERITS(pe.tra_travessia_pedestre)
#
CREATE TABLE pe.pto_pto_ref_geod_topo_p(
	nome varchar(80),
	proximidade smallint NOT NULL DEFAULT 0,
	tipoptorefgeodtopo smallint NOT NULL DEFAULT 0,
	redereferencia smallint NOT NULL DEFAULT 0,
	referencialgrav smallint NOT NULL DEFAULT 0,
	situacaomarco smallint,
	datavisita varchar(80),
	datamedicao varchar(80),
	CONSTRAINT pto_pto_ref_geod_topo_p_pk PRIMARY KEY (id)
) INHERITS(pe.pto_pto_geod_topo_controle_p)
#
CREATE TABLE pe.tra_travessia(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	tipotravessia smallint NOT NULL DEFAULT 0,
	tipouso smallint NOT NULL,
	tipoembarcacao smallint NOT NULL,
	CONSTRAINT tra_travessia_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE ge.cb_area_energia_eletrica_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_subest_transm_distrib_energia_eletrica uuid,
	id_complexo_gerador_energia_eletrica uuid,
	CONSTRAINT cb_area_energia_eletrica_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.enc_zona_linhas_energia_comunicacao_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT enc_zona_linhas_energia_comunicacao_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.enc_torre_energia_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	ovgd smallint,
	alturaestimada float,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT enc_torre_energia_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.enc_antena_comunic_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	posicaoreledific smallint NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	id_complexo_comunicacao uuid,
	CONSTRAINT enc_antena_comunic_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.enc_torre_comunic_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	posicaoreledific smallint,
	ovgd smallint,
	alturaestimada float,
	modalidade smallint[] NOT NULL,
	id_complexo_comunicacao uuid,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT enc_torre_comunic_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.enc_trecho_energia_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	especie smallint,
	posicaorelativa smallint,
	operacional smallint,
	situacaofisica smallint,
	organizacao varchar(80),
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	id_org_comerc_serv uuid,
	CONSTRAINT enc_trecho_comunic_l_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.enc_trecho_comunic_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipotrechocomunic smallint NOT NULL,
	posicaorelativa smallint NOT NULL,
	matcondutor smallint,
	operacional smallint,
	situacaofisica smallint,
	emduto smallint,
	organizacao varchar(200),
	id_org_comerc_serv uuid,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT enc_trecho_comunic_l_pk_1 PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.tra_travessia_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT tra_travessia_l_pk PRIMARY KEY (id)
) INHERITS(pe.tra_travessia)
#
CREATE TABLE pe.aer_pista_ponto_pouso_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT aer_pista_ponto_pouso_p_pk PRIMARY KEY (id)
) INHERITS(pe.aer_pista_ponto_pouso)
#
CREATE TABLE pe.rod_trecho_rodoviario(
	id serial NOT NULL,
	nome varchar(200),
	sigla varchar(200),
	codtrechorodov varchar(200),
	geometriaaproximada smallint NOT NULL,
	tipotrechorod smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	administracao smallint NOT NULL,
	concessionaria varchar(100),
	revestimento smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	canteirodivisorio smallint NOT NULL,
	nrpistas integer,
	nrfaixas integer,
	trafego smallint NOT NULL,
	limitevelocidade float,
	trechoemperimetrourbano smallint NOT NULL,
	acostamento smallint,
	tipopavimentacao smallint NOT NULL,
	CONSTRAINT rod_trecho_rodoviario_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.fer_cremalheira(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	operacional smallint NOT NULL DEFAULT 0,
	situacaofisica smallint NOT NULL DEFAULT 0,
	CONSTRAINT fer_cremalheira_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.fer_cremalheira_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT fer_cremalheira_l_pk PRIMARY KEY (id)
) INHERITS(pe.fer_cremalheira)
#
CREATE TABLE pe.hdv_atracadouro_terminal(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoatracad smallint NOT NULL,
	administracao smallint NOT NULL,
	matconstr smallint[] NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	aptidaooperacional smallint[],
	id_complexo_portuario uuid,
	CONSTRAINT hdv_atracadouro_terminal_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.dut_condutor_hidrico_l(
	id_complexo_gerador_energia_eletrica uuid,
	CONSTRAINT dut_condutor_hidrico_l_pk PRIMARY KEY (id)
) INHERITS(pe.dut_trecho_duto_l)
#
CREATE TABLE complexos.hdv_complexo_portuario(
	tipotransporte smallint NOT NULL,
	tipocomplexoportuario smallint NOT NULL,
	portosempapel smallint NOT NULL,
	id_complexo_portuario uuid,
	CONSTRAINT hdv_complexo_portuario_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_transporte)
#
CREATE TABLE pe.hdv_atracadouro_terminal_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hdv_atracadouro_terminal_l_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_atracadouro_terminal)
#
CREATE TABLE pe.hdv_atracadouro_terminal_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hdv_atracadouro_terminal_a_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_atracadouro_terminal)
#
CREATE TABLE pe.hdv_fundeadouro(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	tipofundeadouro smallint NOT NULL,
	administracao smallint NOT NULL DEFAULT 0,
	id_complexo_portuario uuid,
	CONSTRAINT hdv_fundeadouro_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.hdv_fundeadouro_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hdv_fundeadouro_a_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_fundeadouro)
#
CREATE TABLE pe.hdv_obstaculo_navegacao(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	tipoobst smallint NOT NULL,
	situacaoemagua smallint NOT NULL DEFAULT 0,
	CONSTRAINT hdv_obstaculo_navegacao_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE complexos.pto_est_med_fenomenos(
	id uuid NOT NULL,
	nome varchar(80),
	orgaoenteresp varchar(80),
	id_est_med_fenomenos uuid,
	CONSTRAINT pto_est_med_fenomenos_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.pto_pto_est_med_fenomenos_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoptoestmed smallint NOT NULL,
	codestacao varchar(80),
	id_est_med_fenomenos uuid,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT pto_est_med_fenomenos_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.hdv_obstaculo_navegacao_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hdv_obstaculo_navegacao_l_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_obstaculo_navegacao)
#
CREATE TABLE pe.hdv_obstaculo_navegacao_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hdv_obstaculo_navegacao_a_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_obstaculo_navegacao)
#
CREATE TABLE pe.hdv_eclusa(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	desnivel float,
	largura float,
	extensao float,
	calado float,
	matconstr smallint[] NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	CONSTRAINT hdv_eclusa_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.hdv_eclusa_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT hdv_eclusa_l_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_eclusa)
#
CREATE TABLE complexos.dut_duto(
	id uuid NOT NULL,
	nome varchar(80),
	CONSTRAINT dut_duto_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.hdv_eclusa_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT hdv_eclusa_a_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_eclusa)
#
CREATE TABLE pe.tra_funicular_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT tra_funicular_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_funicular)
#
CREATE TABLE pe.dut_ponto_duto_p(
	id serial NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	id_duto uuid,
	relacionado smallint NOT NULL,
	CONSTRAINT dut_ponto_duto_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.lpal_linha_de_limite_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	referenciallegal smallint NOT NULL,
	obssituacao varchar(80),
	extensao float,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT lpal_linha_de_limite_l_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.tra_passagem_elevada_viaduto_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT tra_passagem_elevada_viaduto_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_passagem_elevada_viaduto)
#
CREATE TABLE pe.lpal_limite_area_especial_l(
	tipolimareaesp smallint NOT NULL,
	CONSTRAINT lpal_limite_area_especial_l_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_linha_de_limite_l)
#
CREATE TABLE pe.lpal_area_politico_adm_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT lpal_area_politico_adm_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.lpal_unidade_federacao_a(
	sigla smallint NOT NULL,
	geocodigo varchar(80),
	CONSTRAINT lpal_unidade_federacao_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_area_politico_adm_a)
#
CREATE TABLE pe.lpal_municipio_a(
	geocodigo varchar(80),
	anodereferencia integer,
	CONSTRAINT lpal_municipio_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_area_politico_adm_a)
#
CREATE TABLE ge.emu_acesso_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT emu_acesso_p_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso)
#
CREATE TABLE pe.tra_caminho_aereo_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipocaminhoaereo smallint NOT NULL,
	tipousocaminhoaer smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	id_org_ext_mineral uuid,
	CONSTRAINT tra_caminho_aereo_l_pk PRIMARY KEY (id)
)#
CREATE TABLE complexos.tra_entroncamento(
	id uuid NOT NULL,
	nome varchar(80),
	tipoentroncamento smallint NOT NULL,
	CONSTRAINT tra_entroncamento_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.tra_entroncamento_pto_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	tipoentroncamento smallint NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	id_entroncamento uuid,
	CONSTRAINT tra_entroncamento_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.lpal_distrito_a(
	geocodigo varchar(80),
	anodereferencia varchar(80),
	CONSTRAINT lpal_distrito_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_area_politico_adm_a)
#
CREATE TABLE pe.lpal_area_especial_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	codidentificadorunico varchar(80),
	arealegal real,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT lpal_area_especial_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.lpal_localidade(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geocodigo varchar(80),
	identificador varchar(80),
	latitude varchar(80),
	latitudegms real,
	longitude varchar(80),
	longitudegms real,
	CONSTRAINT loc_localidade_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.tra_travessia_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT tra_travessia_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_travessia)
#
CREATE TABLE complexos.lpal_vila(
	CONSTRAINT lpal_vila_pk PRIMARY KEY (id)
) INHERITS(complexos.lpal_localidade)
#
CREATE TABLE complexos.lpal_cidade(
	CONSTRAINT lpal_cidade_pk PRIMARY KEY (id)
) INHERITS(complexos.lpal_localidade)
#
CREATE TABLE pe.rod_trecho_rodoviario_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT rod_trecho_rodoviario_l_pk PRIMARY KEY (id)
) INHERITS(pe.rod_trecho_rodoviario)
#
CREATE TABLE complexos.lpal_capital(
	tipocapital smallint NOT NULL,
	CONSTRAINT lpal_capital_pk PRIMARY KEY (id)
) INHERITS(complexos.lpal_cidade)
#
CREATE TABLE pe.fer_cremalheira_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT fer_cremalheira_p_pk PRIMARY KEY (id)
) INHERITS(pe.fer_cremalheira)
#
CREATE TABLE complexos.cb_complexo_habitacional(
	id uuid NOT NULL,
	nome varchar(80),
	id_localidade uuid,
	CONSTRAINT cb_complexo_habitacional_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.ver_jardim_a(
	finalidade smallint NOT NULL,
	CONSTRAINT ver_jardim_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_cultivada_a)
#
CREATE TABLE pe.hdv_atracadouro_terminal_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hdv_atracadouro_terminal_p_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_atracadouro_terminal)
#
CREATE TABLE pe.lpal_terra_publica_a(
	classificacao varchar(80),
	administracao smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	CONSTRAINT lpal_terra_publica_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_area_especial_a)
#
CREATE TABLE pe.lpal_terra_indigena_a(
	situacaojuridica smallint NOT NULL,
	datasituacaojuridica varchar(80),
	grupoetnico varchar(80),
	perimetrooficial float,
	CONSTRAINT lpal_terra_indigena_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_terra_publica_a)
#
CREATE TABLE pe.hdv_fundeadouro_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hdv_fundeadouro_p_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_fundeadouro)
#
CREATE TABLE pe.tra_caminho_carrocavel_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT tra_caminho_carrocavel_l_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.tra_trilha_picada_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT tra_trilha_picada_l_pk PRIMARY KEY (id)
)#
CREATE TABLE pe.hdv_obstaculo_navegacao_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hdv_obstaculo_navegacao_p_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_obstaculo_navegacao)
#
CREATE TABLE pe.tra_ponto_rodoviario_ferrov(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	relacionado smallint NOT NULL,
	CONSTRAINT tra_ponto_rodoviario_ferrov_pk PRIMARY KEY (id)
)#
CREATE TABLE complexos.laz_complexo_desportivo_lazer(
	id uuid NOT NULL,
	nome varchar(80),
	divisaoativecon smallint NOT NULL,
	operacional smallint,
	administracao smallint NOT NULL,
	turistico smallint,
	cultura smallint,
	id_org_religiosa uuid,
	id_org_pub_civil uuid,
	id_org_ensino uuid,
	id_org_comerc_serv uuid,
	id_org_pub_militar uuid,
	CONSTRAINT laz_complexo_desportivo_lazer_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.rod_ponto_rodoviario_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT rod_ponto_rodoviario_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_ponto_rodoviario_ferrov)
#
CREATE TABLE pe.fer_girador_ferroviario_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	administracao smallint NOT NULL DEFAULT 0,
	operacional smallint NOT NULL DEFAULT 0,
	situacaofisica smallint NOT NULL DEFAULT 0,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	id_estacao_ferroviaria uuid,
	id_estacao_metroviaria uuid,
	CONSTRAINT fer_girador_ferroviario_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.fer_trecho_ferroviario_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	codtrechoferrov varchar(80),
	posicaorelativa smallint NOT NULL,
	tipotrechoferrov smallint NOT NULL,
	bitola smallint NOT NULL,
	eletrificada smallint NOT NULL,
	nrlinhas smallint NOT NULL,
	jurisdicao smallint NOT NULL,
	administracao smallint NOT NULL,
	concessionaria varchar(80),
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	cargasuportmaxima float,
	id_via_ferrea uuid,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT fer_trecho_ferroviario_l_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE complexos.laz_complexo_desportivo(
	CONSTRAINT laz_complexo_desportivo_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo_lazer)
#
CREATE TABLE pe.hdv_eclusa_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hdv_eclusa_p_pk PRIMARY KEY (id)
) INHERITS(pe.hdv_eclusa)
#
CREATE TABLE complexos.laz_autodromo(
	CONSTRAINT laz_autodromo_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo)
#
CREATE TABLE complexos.laz_velodromo(
	CONSTRAINT laz_velodromo_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo)
#
CREATE TABLE complexos.laz_kartodromo(
	CONSTRAINT laz_kartodromo_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo)
#
CREATE TABLE pe.lpal_limite_politico_adm_l(
	tipolimpol smallint[] NOT NULL,
	CONSTRAINT lpal_limite_politico_adm_l_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_linha_de_limite_l)
#
CREATE TABLE complexos.laz_hipica(
	CONSTRAINT laz_hipica_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo)
#
CREATE TABLE complexos.laz_hipodromo(
	CONSTRAINT laz_hipodromo_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo)
#
CREATE TABLE complexos.laz_campo_de_golfe(
	CONSTRAINT laz_campo_de_golfe_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo)
#
CREATE TABLE complexos.laz_estande_de_tiro(
	CONSTRAINT laz_estande_de_tiro_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo)
#
CREATE TABLE pe.hdv_sinalizacao_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tiposinal smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT hdv_sinalizacao_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE complexos.laz_complexo_recreativo(
	CONSTRAINT laz_complexo_recreativo_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo_lazer)
#
CREATE TABLE complexos.laz_jardim_botanico(
	CONSTRAINT laz_jardim_botanico_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_recreativo)
#
CREATE TABLE pe.lpal_pais_a(
	sigla varchar(80),
	codiso3166 varchar(80) NOT NULL DEFAULT 'BRA',
	CONSTRAINT lpal_pais_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_area_politico_adm_a)
#
CREATE TABLE complexos.laz_parque_aquatico(
	CONSTRAINT laz_parque_aquatico_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_recreativo)
#
CREATE TABLE complexos.laz_jardim_zoologico(
	CONSTRAINT laz_jardim_zoologico_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_recreativo)
#
CREATE TABLE complexos.laz_parque_tematico(
	CONSTRAINT laz_parque_tematico_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_recreativo)
#
CREATE TABLE complexos.laz_marina(
	CONSTRAINT laz_marina_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_recreativo)
#
CREATE TABLE complexos.laz_pesque_pague(
	CONSTRAINT laz_pesque_pague_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_recreativo)
#
CREATE TABLE complexos.laz_parque_urbano(
	CONSTRAINT laz_parque_urbano_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_recreativo)
#
CREATE TABLE ge.laz_arquibancada(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL DEFAULT 2,
	operacional smallint NOT NULL DEFAULT 0,
	situacaofisica smallint NOT NULL DEFAULT 0,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT laz_arquibancada_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.laz_arquibancada_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT laz_arquibancada_l_pk PRIMARY KEY (id)
) INHERITS(ge.laz_arquibancada)
#
CREATE TABLE ge.laz_arquibancada_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT laz_arquibancada_a_pk PRIMARY KEY (id)
) INHERITS(ge.laz_arquibancada)
#
CREATE TABLE complexos.lpal_aglomerado_rural(
	CONSTRAINT lpal_aglomerado_rural_pk PRIMARY KEY (id)
) INHERITS(complexos.lpal_localidade)
#
CREATE TABLE ge.laz_campo_quadra(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	tipocampoquadra smallint NOT NULL,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT laz_campo_quadra_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_delimitacao_fisica_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipodelimfis smallint NOT NULL,
	matconstr smallint[],
	eletrificada smallint NOT NULL,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT cb_delimitacao_fisica_l_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE pe.pto_marco_de_limite_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipomarcolim smallint NOT NULL,
	latitude_gms float,
	latitude varchar(15) NOT NULL,
	longitude_gms float,
	longitude varchar(15),
	altitudeortometrica float,
	sistemageodesico smallint NOT NULL,
	outrarefplan varchar(80),
	referencialaltim smallint NOT NULL,
	outrarefalt varchar(80),
	orgresp varchar(80),
	codigo varchar(80),
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT lim_marco_de_limite_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE ge.laz_campo_quadra_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT laz_campo_quadra_a_pk PRIMARY KEY (id)
) INHERITS(ge.laz_campo_quadra)
#
CREATE TABLE ge.laz_pista_competicao(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	tipopistacomp smallint NOT NULL,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT laz_pista_competicao_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.laz_pista_competicao_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT laz_pista_competicao_l_pk PRIMARY KEY (id)
) INHERITS(ge.laz_pista_competicao)
#
CREATE TABLE complexos.lpal_aldeia_indigena(
	codigofunai varchar(80),
	terraindigena varchar(80),
	etnia varchar(80),
	CONSTRAINT lpal_aldeia_indigena_pk PRIMARY KEY (id)
) INHERITS(complexos.cb_complexo_habitacional)
#
CREATE TABLE ge.laz_pista_competicao_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT laz_pista_competicao_a_pk PRIMARY KEY (id)
) INHERITS(ge.laz_pista_competicao)
#
CREATE TABLE complexos.laz_clube_social(
	CONSTRAINT laz_clube_social_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_recreativo)
#
CREATE TABLE ge.laz_ruina(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	turistica smallint,
	cultura smallint,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT laz_ruina_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.laz_ruina_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT laz_ruina_a_pk PRIMARY KEY (id)
) INHERITS(ge.laz_ruina)
#
CREATE TABLE ge.laz_sitio_arqueologico(
	id serial NOT NULL,
	nome varchar(80),
	turistica smallint,
	cultura smallint,
	CONSTRAINT laz_sitio_arqueologico_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.laz_sitio_arqueologico_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT laz_sitio_arqueologico_a_pk PRIMARY KEY (id)
) INHERITS(ge.laz_sitio_arqueologico)
#
CREATE TABLE ge.emu_rampa_p(
	CONSTRAINT emu_rampa_p_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_p)
#
CREATE TABLE ge.emu_rampa_l(
	CONSTRAINT emu_rampa_l_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_l)
#
CREATE TABLE ge.emu_rampa_a(
	CONSTRAINT emu_rampa_a_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_a)
#
CREATE TABLE ge.emu_escadaria_p(
	CONSTRAINT emu_escadaria_p_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_p)
#
CREATE TABLE pe.lpal_area_construida_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	id_localidade uuid,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT lpal_area_construida_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.lpal_nome_local_p(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT lpal_nome_local_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.laz_campo_aeromodelismo(
	CONSTRAINT laz_campo_aeromodelismo_pk PRIMARY KEY (id)
) INHERITS(complexos.laz_complexo_desportivo)
#
CREATE TABLE ge.emu_escadaria_a(
	CONSTRAINT emu_escadaria_a_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_a)
#
CREATE TABLE ge.emu_escadaria_l(
	CONSTRAINT emu_escadaria_l_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_l)
#
CREATE TABLE complexos.ver_area_verde(
	id uuid NOT NULL,
	nome varchar(80),
	paisagismo smallint NOT NULL,
	administracao smallint NOT NULL,
	id_area_verde_urbana uuid,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT ver_area_verde_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.ver_area_verde_urbana(
	id uuid NOT NULL,
	nome varchar(80),
	CONSTRAINT ver_area_verde_urbana_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.ver_arvore_isolada_p(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	id_area_verde uuid,
	CONSTRAINT ver_arvore_isolada_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.emu_elevador_p(
	tipoelevador smallint,
	CONSTRAINT emu_elevador_p_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_p)
#
CREATE TABLE ge.emu_elevador_l(
	tipoelevador smallint,
	CONSTRAINT emu_elevador_l_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_l)
#
CREATE TABLE ge.emu_elevador_a(
	tipoelevador smallint,
	CONSTRAINT emu_elevador_a_pk PRIMARY KEY (id)
) INHERITS(ge.emu_acesso_a)
#
CREATE TABLE complexos.emu_terminal_rodoviario(
	CONSTRAINT emu_terminal_rodoviario_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_apoio)
#
CREATE TABLE complexos.emu_terminal_ferroviario(
	CONSTRAINT emu_terminal_ferroviario_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_apoio)
#
CREATE TABLE complexos.emu_terminal_hidroviario(
	CONSTRAINT emu_terminal_hidroviario_pk PRIMARY KEY (id)
) INHERITS(complexos.tra_estrut_apoio)
#
CREATE TABLE complexos.cb_condominio(
	CONSTRAINT cb_condominio_pk PRIMARY KEY (id)
) INHERITS(complexos.cb_complexo_habitacional)
#
CREATE TABLE complexos.cb_conjunto_habitacional(
	id_assentamento_precario uuid,
	CONSTRAINT cb_conjunto_habitacional_pk PRIMARY KEY (id)
) INHERITS(complexos.cb_complexo_habitacional)
#
CREATE TABLE complexos.cb_area_subnormal(
	id uuid NOT NULL,
	nome varchar(80),
	CONSTRAINT cb_area_subnormal_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.cb_favela(
	CONSTRAINT cb_favela_pk PRIMARY KEY (id)
) INHERITS(complexos.cb_area_subnormal)
#
CREATE TABLE ge.cb_trecho_rodoviario_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_trecho_rodoviario_a_pk PRIMARY KEY (id)
) INHERITS(pe.rod_trecho_rodoviario)
#
CREATE TABLE ge.cb_retorno(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	CONSTRAINT cb_retorno_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_retorno_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT cb_retorno_l_pk PRIMARY KEY (id)
) INHERITS(ge.cb_retorno)
#
CREATE TABLE ge.cb_retorno_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_retorno_a_pk PRIMARY KEY (id)
) INHERITS(ge.cb_retorno)
#
CREATE TABLE ge.cb_canteiro_central(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	situacaoespacial smallint,
	CONSTRAINT cb_canteiro_central_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_canteiro_central_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_canteiro_central_a_pk PRIMARY KEY (id)
) INHERITS(ge.cb_canteiro_central)
#
CREATE TABLE ge.cb_passeio(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	largura float,
	calcada smallint NOT NULL,
	pavimentacao smallint[] NOT NULL,
	CONSTRAINT cb_passeio_pk PRIMARY KEY (id)
)#
CREATE TABLE ge.laz_campo_quadra_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT laz_campo_quadra_p_pk PRIMARY KEY (id)
) INHERITS(ge.laz_campo_quadra)
#
CREATE TABLE ge.cb_passeio_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT cb_passeio_l_pk PRIMARY KEY (id)
) INHERITS(ge.cb_passeio)
#
CREATE TABLE ge.cb_trecho_arruamento(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	revestimento smallint,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	nrfaixas integer,
	nrpistas integer,
	trafego smallint NOT NULL,
	canteirodivisorio smallint NOT NULL,
	tipoarruamento smallint NOT NULL,
	tipopavimentacao smallint[],
	meiofio smallint,
	sargeta smallint,
	id_arruamento uuid,
	CONSTRAINT cb_trecho_arruamento_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.laz_pista_competicao_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT laz_pista_competicao_p_pk PRIMARY KEY (id)
) INHERITS(ge.laz_pista_competicao)
#
CREATE TABLE ge.cb_trecho_arruamento_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_trecho_arruamento_a_pk PRIMARY KEY (id)
) INHERITS(ge.cb_trecho_arruamento)
#
CREATE TABLE pe.lpal_area_pub_militar_a(
	id_org_pub_militar uuid,
	CONSTRAINT lpal_area_pub_militar_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_terra_publica_a)
#
CREATE TABLE ge.cb_tunel_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_tunel_a_pk PRIMARY KEY (id)
) INHERITS(pe.tra_tunel)
#
CREATE TABLE ge.cb_ponte_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_ponte_a_pk PRIMARY KEY (id)
) INHERITS(pe.tra_ponte)
#
CREATE TABLE ge.laz_ruina_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT laz_ruina_p_pk PRIMARY KEY (id)
) INHERITS(ge.laz_ruina)
#
CREATE TABLE ge.cb_passagem_elevada_viaduto_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_passagem_elevada_viaduto_a_pk PRIMARY KEY (id)
) INHERITS(pe.tra_passagem_elevada_viaduto)
#
CREATE TABLE ge.cb_travessia_pedrestre_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_travessia_pedrestre_a_pk PRIMARY KEY (id)
) INHERITS(pe.tra_travessia_pedestre)
#
CREATE TABLE ge.laz_sitio_arqueologico_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT laz_sitio_arqueologico_p_pk PRIMARY KEY (id)
) INHERITS(ge.laz_sitio_arqueologico)
#
CREATE TABLE ge.cb_praca_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	turistica smallint NOT NULL,
	id_complexo_desportivo_lazer uuid,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_praca_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_largo_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	id_complexo_desportivo_lazer uuid,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_largo_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_poste_p(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	codident varchar(80),
	matconstr smallint,
	tipoposte smallint[] NOT NULL,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT cb_poste_p_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.sb_cemiterio(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipocemiterio smallint NOT NULL,
	denominacaoassociada smallint,
	destinacaocemiterio smallint NOT NULL,
	organizacao varchar(80),
	id_org_comerc_serv uuid,
	id_org_pub_civil uuid,
	CONSTRAINT sb_cemiterio_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.laz_piscina_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint,
	situacaofisica smallint,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT laz_piscina_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.sb_cemiterio_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT sb_cemiterio_a_pk PRIMARY KEY (id)
) INHERITS(pe.sb_cemiterio)
#
CREATE TABLE pe.dut_galeria_bueiro_l(
	finalidade smallint,
	pesosuportmaximo real,
	id_via_ferrea uuid,
	CONSTRAINT dut_galeria_bueiro_l_pk PRIMARY KEY (id)
) INHERITS(pe.dut_trecho_duto_l)
#
CREATE TABLE pe.dut_galeria_l(
	largura float,
	CONSTRAINT dut_galeria_l_pk PRIMARY KEY (id)
) INHERITS(pe.dut_galeria_bueiro_l)
#
CREATE TABLE complexos.sau_org_saude(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	administracao smallint NOT NULL,
	grupoativecon smallint NOT NULL,
	classeativecon smallint NOT NULL,
	numeroleitos integer,
	numeroleitosuti integer,
	CONSTRAINT sau_org_saude_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE complexos.cb_palafitas(
	CONSTRAINT cb_palafitas_pk PRIMARY KEY (id)
) INHERITS(complexos.cb_area_subnormal)
#
CREATE TABLE complexos.sau_org_saude_privada(
	id_org_comerc_serv uuid,
	CONSTRAINT sau_org_saude_privada_pk PRIMARY KEY (id)
) INHERITS(complexos.sau_org_saude)
#
CREATE TABLE complexos.sau_org_saude_pub(
	id_org_pub_civil uuid,
	CONSTRAINT sau_org_saude_pub_pk PRIMARY KEY (id)
) INHERITS(complexos.sau_org_saude)
#
CREATE TABLE complexos.sau_org_servico_social(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	administracao smallint NOT NULL,
	grupoativecon smallint NOT NULL,
	classeativecon smallint NOT NULL,
	tipoorgsvsocial smallint NOT NULL,
	CONSTRAINT sau_org_servico_social_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE ge.cb_retorno_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT cb_retorno_p_pk PRIMARY KEY (id)
) INHERITS(ge.cb_retorno)
#
CREATE TABLE ge.emu_ciclovia_l(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	operacional smallint NOT NULL,
	situacaofisica smallint NOT NULL,
	revestimento smallint,
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT emu_ciclovia_l_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_canteiro_central_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT cb_canteiro_central_l_pk PRIMARY KEY (id)
) INHERITS(ge.cb_canteiro_central)
#
CREATE TABLE ge.cb_passeio_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_passeio_a_pk PRIMARY KEY (id)
) INHERITS(ge.cb_passeio)
#
CREATE TABLE pe.lpal_unidade_protegida_a(
	anocriacao varchar(4),
	historicomodificacoes varchar(255),
	sigla varchar(6),
	atolegal varchar(100),
	areaoficial varchar(15),
	administracao smallint NOT NULL,
	classificacao varchar(100),
	jurisdicao smallint NOT NULL,
	tipounidprotegida smallint NOT NULL,
	CONSTRAINT lpal_unidade_protegida_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_area_especial_a)
#
CREATE TABLE ge.cb_trecho_arruamento_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT cb_trecho_arruamento_l_pk PRIMARY KEY (id)
) INHERITS(ge.cb_trecho_arruamento)
#
CREATE TABLE pe.lpal_unidade_conservacao_a(
	CONSTRAINT lpal_unidade_conservacao_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_unidade_protegida_a)
#
CREATE TABLE ge.cb_area_habitacional_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_assentamento_precario uuid,
	id_complexo_habitacional uuid,
	CONSTRAINT cb_area_habitacional_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_comunicacao_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_complexo_comunicacao uuid,
	CONSTRAINT cb_area_comunicacao_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_abast_agua_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_complexo_abast_agua uuid,
	CONSTRAINT cb_area_abast_agua_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_saneamento_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	id_complexo_saneamento uuid,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_saneamento_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_duto_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	areavalvulas smallint,
	bombeamento smallint,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_duto_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_de_propriedade_particular_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_de_propriedade_particular_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_saude_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_org_saude uuid,
	CONSTRAINT cb_area_saude_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_ruinas_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT cb_area_ruinas_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_lazer_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL DEFAULT 0,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_complexo_desportivo_lazer uuid,
	CONSTRAINT cb_area_lazer_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_comerc_serv_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_org_comerc_serv uuid,
	CONSTRAINT cb_area_comerc_serv_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_ensino_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL DEFAULT 0,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_org_ensino uuid,
	CONSTRAINT cb_area_ensino_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_religiosa_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL DEFAULT 0,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_religiosa_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_area_urbana_isolada_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoassociado smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_urbana_isolada_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE pe.lpal_unidade_conservacao_nao_snuc_a(
	CONSTRAINT lpal_unidade_conservacao_nao_snuc_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_unidade_conservacao_a)
#
CREATE TABLE pe.lpal_unidade_protecao_integral_a(
	tipounidprotinteg smallint NOT NULL,
	CONSTRAINT lpal_unidade_protecao_integral_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_unidade_conservacao_a)
#
CREATE TABLE pe.lpal_unidade_uso_sustentavel_a(
	tipounidusosust smallint NOT NULL,
	CONSTRAINT lpal_unidade_uso_sustentavel_a_pk PRIMARY KEY (id)
) INHERITS(pe.lpal_unidade_conservacao_a)
#
CREATE TABLE pe.fer_ponto_ferroviario_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT fer_ponto_ferroviario_p_pk PRIMARY KEY (id)
) INHERITS(pe.tra_ponto_rodoviario_ferrov)
#
CREATE TABLE pe.rod_passagem_nivel_p(
	nome varchar(80),
	CONSTRAINT rod_passagem_nivel_p_pk PRIMARY KEY (id)
) INHERITS(pe.rod_ponto_rodoviario_p)
#
CREATE TABLE complexos.rdr_arruamento(
	id uuid NOT NULL,
	CONSTRAINT cb_arruamento_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.cb_entroncamento_area_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoentroncamento smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	id_entroncamento uuid,
	CONSTRAINT cb_entroncamento_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.edf_posto_combustivel_a(
	CONSTRAINT edf_posto_combustivel_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_comerc_serv_a)
#
CREATE TABLE ge.edf_posto_combustivel_p(
	CONSTRAINT edf_posto_combustivel_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_comerc_serv_p)
#
CREATE TABLE pe.sb_cemiterio_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT sb_cemiterio_p_pk PRIMARY KEY (id)
) INHERITS(pe.sb_cemiterio)
#
CREATE TABLE ge.cb_quadra_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_quadra_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE ge.edf_posto_policia_rod_federal_p(
	CONSTRAINT edf_posto_policia_rod_federal_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_civil_p)
#
CREATE TABLE ge.edf_posto_policia_rod_federal_a(
	CONSTRAINT edf_posto_policia_rod_federal_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_civil_a)
#
CREATE TABLE ge.edf_edif_ensino_p(
	id_org_ensino uuid,
	CONSTRAINT edf_edif_ensino_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
CREATE TABLE ge.cb_espelho_dagua_a(
	id serial NOT NULL,
	nome varchar(80),
	codident varchar(80),
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_espelho_dagua_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.sau_org_saude_militar(
	id_org_pub_militar uuid,
	CONSTRAINT sau_org_saude_militar_pk PRIMARY KEY (id)
) INHERITS(complexos.sau_org_saude)
#
CREATE TABLE complexos.adm_org_pub_militar(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	classeativecon smallint NOT NULL,
	tipoorgmilitar smallint NOT NULL,
	administracao smallint NOT NULL,
	id_org_pub_militar uuid,
	id_instituicao_publica uuid,
	CONSTRAINT adm_org_pub_militar_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE complexos.adm_org_pub_civil(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	classeativecon smallint NOT NULL,
	administracao smallint NOT NULL,
	tipoorgcivil smallint NOT NULL,
	poderpublico smallint NOT NULL,
	administracaodireta smallint NOT NULL,
	id_org_pub_civil uuid,
	CONSTRAINT adm_org_pub_civil_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE complexos.sau_org_servico_social_pub(
	id_org_pub_civil uuid,
	CONSTRAINT sau_org_servico_social_pub_pk PRIMARY KEY (id)
) INHERITS(complexos.sau_org_servico_social)
#
CREATE TABLE ge.edf_posto_policia_militar_p(
	CONSTRAINT edf_posto_policia_militar_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_militar_p)
#
CREATE TABLE ge.edf_posto_policia_militar_a(
	CONSTRAINT edf_posto_policia_militar_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_pub_militar_a)
#
CREATE TABLE complexos.adm_org_religiosa(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	classeativecon smallint NOT NULL,
	cultura smallint NOT NULL,
	CONSTRAINT adm_org_religiosa_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.adm_instituicao_publica(
	id uuid NOT NULL,
	nome varchar(80) NOT NULL,
	grupoativecon smallint NOT NULL,
	administracao smallint NOT NULL,
	poderpublico smallint NOT NULL,
	id_instituicao_publica uuid,
	id_org_pub_civil uuid,
	CONSTRAINT adm_instituicao_publica_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.sau_especialidade_medica(
	id uuid NOT NULL,
	nomeespecialidade smallint NOT NULL,
	numeromedicos integer,
	id_org_saude uuid,
	CONSTRAINT sau_especialidade_medica_pk PRIMARY KEY (id)
)#
CREATE TABLE ge.cb_area_industrial_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	id_org_industrial uuid,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_industrial_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 100)
)#
CREATE TABLE ge.cb_area_estrut_transporte_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	id_estrut_transporte uuid,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_estrut_transporte_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE complexos.lpal_aglomerado_rural_isolado(
	tipoaglomrurisol smallint NOT NULL,
	CONSTRAINT lpal_aglomerado_rural_isolado_pk PRIMARY KEY (id)
) INHERITS(complexos.lpal_aglomerado_rural)
#
CREATE TABLE complexos.lpal_aglom_rural_de_ext_urbana(
	CONSTRAINT lpal_aglom_rural_de_ext_urbana_pk PRIMARY KEY (id)
) INHERITS(complexos.lpal_aglomerado_rural)
#
CREATE TABLE ge.cb_area_est_med_fenomenos_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	id_est_med_fenomenos uuid,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_est_med_fenomenos_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE public.aux_geometria(
	id serial NOT NULL,
	classe varchar(80),
	CONSTRAINT aux_geometria_1 PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE public.aux_objeto_desconhecido(
	id serial NOT NULL,
	classe varchar(80),
	descricao varchar(80),
	CONSTRAINT aux_objeto_desconhecido_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE public.aux_objeto_desconhecido_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT aux_objeto_desconhecido_l_pk PRIMARY KEY (id)
) INHERITS(public.aux_objeto_desconhecido)
#
CREATE TABLE public.aux_ponto_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT aux_ponto_p_pk PRIMARY KEY (id)
) INHERITS(public.aux_geometria)
#
CREATE TABLE public.aux_linha_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT aux_linha_l_pk PRIMARY KEY (id)
) INHERITS(public.aux_geometria)
#
CREATE TABLE public.aux_area_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT aux_area_a_pk PRIMARY KEY (id)
) INHERITS(public.aux_geometria)
#
CREATE TABLE public.aux_objeto_desconhecido_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT aux_objeto_desconhecido_p_pk PRIMARY KEY (id)
) INHERITS(public.aux_objeto_desconhecido)
#
CREATE TABLE public.aux_objeto_desconhecido_a(
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT aux_objeto_desconhecido_a_pk PRIMARY KEY (id)
) INHERITS(public.aux_objeto_desconhecido)
#
CREATE TABLE public.aux_moldura_a(
	id serial NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	mi varchar(80),
	inom varchar(80),
	escala varchar(80),
	nomecarta varchar(80),
	anoaquisicao varchar(80),
	engrespaquisicao varchar(80),
	opaquisicao varchar(80),
	datainicioaquisicao date,
	datafimaquisicao date,
	engresprevisaoaquisicao varchar(80),
	oprevisaoaquisicao varchar(80),
	datainiciorevaquisicao date,
	datafimrevaquisicao date,
	engrespreambulacao varchar(80),
	opreambulacao varchar(80),
	datainicioreambulacao date,
	datafimreambulacao date,
	oprevisaoreambulacao varchar(80),
	engrespvalidacaoedicao varchar(80),
	opvalidacao varchar(80),
	datainiciovalidacao date,
	datafimvalidacao date,
	opedicao varchar(80),
	datainicioedicao date,
	datafimedicao date,
	CONSTRAINT aux_moldura_a_pk PRIMARY KEY (id)
	 WITH (FILLFACTOR = 10)
)#
CREATE TABLE public.db_metadata(
	edgvversion varchar(20) NOT NULL DEFAULT 'FTer_2a_Ed',
	implementationversion smallint NOT NULL,
	CONSTRAINT edgvversioncheck CHECK (edgvversion = 'FTer_2a_Ed')
)#
INSERT INTO public.db_metadata (edgvversion,implementationversion) VALUES ('FTer_2a_Ed',1)#
CREATE TABLE pe.hid_canal_l(
	CONSTRAINT hid_canal_l_pk PRIMARY KEY (id)
) INHERITS(pe.hid_canal_vala_l)
#
ALTER TABLE pe.hid_canal_l OWNER TO postgres#
CREATE TABLE pe.hid_canal_a(
	CONSTRAINT hid_canal_a_pk PRIMARY KEY (id)
) INHERITS(pe.hid_canal_vala_a)
#
ALTER TABLE pe.hid_canal_a OWNER TO postgres#
CREATE TABLE complexos.rdr_bacia_hidrografica(
	id uuid NOT NULL,
	CONSTRAINT rdr_bacia_hidrografica_pk PRIMARY KEY (id)
)#
ALTER TABLE complexos.rdr_bacia_hidrografica OWNER TO postgres#
CREATE TABLE complexos.rdr_sub_bacia_hidrografica(
	id uuid NOT NULL,
	id_bacia_hidrografica uuid,
	CONSTRAINT rdr_sub_bacia_hidrografica_pk PRIMARY KEY (id)
)#
ALTER TABLE complexos.rdr_sub_bacia_hidrografica OWNER TO postgres#
CREATE TABLE complexos.rdr_elemento_hidrografico(
	id uuid NOT NULL,
	id_sub_bacia_hidrografica uuid,
	CONSTRAINT rdr_elemento_hidrografico_pk PRIMARY KEY (id)
)#
ALTER TABLE complexos.rdr_elemento_hidrografico OWNER TO postgres#
CREATE TABLE complexos.rdr_trecho_curso_dagua(
	id uuid NOT NULL,
	nome varchar(80),
	id_curso_dagua uuid,
	id_elemento_hidrografico uuid,
	CONSTRAINT rdr_trecho_curso_dagua_pk PRIMARY KEY (id)
)#
ALTER TABLE complexos.rdr_trecho_curso_dagua OWNER TO postgres#
CREATE TABLE complexos.rdr_curso_dagua(
	id uuid NOT NULL,
	nome varchar(80),
	dominialidade smallint,
	CONSTRAINT rdr_curso_dagua_pk PRIMARY KEY (id)
)#
ALTER TABLE complexos.rdr_curso_dagua OWNER TO postgres#
CREATE TABLE pe.sb_barragem_calcadao_a(
	id serial NOT NULL,
	nome varchar(80),
	geometriaaproximada smallint NOT NULL,
	tipoequipdesenvsocial smallint NOT NULL,
	sigla varchar(80),
	codequipdesenvsocial varchar(80),
	localizacaoequipdesenvsocial smallint,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT sb_barragem_calcadao_a_pk PRIMARY KEY (id)
)#
ALTER TABLE pe.sb_barragem_calcadao_a OWNER TO postgres#
CREATE TABLE pe.dut_ramificacao_p(
	CONSTRAINT dut_ramificacao_p_pk PRIMARY KEY (id)
) INHERITS(pe.dut_ponto_duto_p)
#
ALTER TABLE pe.dut_ramificacao_p OWNER TO postgres#
CREATE TABLE pe.dut_ponto_inicio_fim_duto_p(
	CONSTRAINT dut_ponto_inicio_fim_duto_p_pk PRIMARY KEY (id)
) INHERITS(pe.dut_ponto_duto_p)
#
ALTER TABLE pe.dut_ponto_inicio_fim_duto_p OWNER TO postgres#
CREATE TABLE complexos.rtr_via_ferrea(
	id uuid NOT NULL,
	nome varchar(80),
	codviaferrov varchar(80),
	CONSTRAINT rtr_via_ferrea_pk PRIMARY KEY (id)
)#
ALTER TABLE complexos.rtr_via_ferrea OWNER TO postgres#
CREATE TABLE ge.cb_area_desenv_social_a(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	geom geometry(MULTIPOLYGON, [epsg]) NOT NULL,
	CONSTRAINT cb_area_desenv_social_a_pk PRIMARY KEY (id)
)#
ALTER TABLE ge.cb_area_desenv_social_a OWNER TO postgres#
CREATE TABLE complexos.cb_assentamento_precario(
	id uuid NOT NULL,
	tipoassprec smallint NOT NULL,
	CONSTRAINT cb_assentamento_precario_pk PRIMARY KEY (id)
)#
ALTER TABLE complexos.cb_assentamento_precario OWNER TO postgres#
CREATE TABLE ge.edf_edif_desenv_social_p(
	sigla varchar(80),
	codequipdesenvsocial varchar(80),
	tipoequipdesenvsocial smallint,
	localizacaoequipdesenvsocial smallint,
	CONSTRAINT edf_edif_desenv_social_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_p)
#
ALTER TABLE ge.edf_edif_desenv_social_p OWNER TO postgres#
CREATE TABLE ge.edf_edif_desenv_social_a(
	sigla varchar(80),
	codequipdesenvsocial varchar(80),
	tipoequipdesenvsocial smallint,
	localizacaoequipdesenvsocial smallint,
	CONSTRAINT edf_edif_desenv_social_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edificacao_a)
#
ALTER TABLE ge.edf_edif_desenv_social_a OWNER TO postgres#
CREATE TABLE ge.edf_hab_indigena_p(
	coletiva smallint NOT NULL,
	isolada smallint NOT NULL,
	id_aldeia_indigena uuid,
	CONSTRAINT edf_hab_indigena_p_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_habitacional_p)
#
CREATE TABLE ge.edf_hab_indigena_a(
	coletiva smallint NOT NULL,
	isolada smallint NOT NULL,
	id_aldeia_indigena uuid,
	CONSTRAINT edf_hab_indigena_a_pk PRIMARY KEY (id)
) INHERITS(ge.edf_edif_habitacional_a)
#
CREATE TABLE ge.emu_poste_sinalizacao_p(
	CONSTRAINT emu_poste_sinalizacao_p_pk PRIMARY KEY (id)
) INHERITS(ge.cb_poste_p)
#
ALTER TABLE ge.emu_poste_sinalizacao_p OWNER TO postgres#
CREATE TABLE pe.lpal_posic_geo_localidade_p(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	tipolocalidade smallint NOT NULL,
	identificador varchar(80),
	latitude varchar(80),
	latitudegms real,
	longitude varchar(80),
	longitudegms real,
	id_localidade uuid,
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT lpal_posic_geo_localidade_p_pk PRIMARY KEY (id)
)#
ALTER TABLE pe.lpal_posic_geo_localidade_p OWNER TO postgres#
CREATE TABLE pe.veg_refugio_ecologico_a(
	CONSTRAINT veg_refugio_ecologico_a_pk PRIMARY KEY (id)
) INHERITS(pe.veg_veg_natural_a)
#
ALTER TABLE pe.veg_refugio_ecologico_a OWNER TO postgres#
CREATE TABLE public.aux_descontinuidade_geometrica(
	id serial NOT NULL,
	geometriaaproximada smallint NOT NULL,
	motivodescontinuidade smallint NOT NULL,
	categoria smallint NOT NULL,
	CONSTRAINT aux_descontinuidade_geometrica_pk PRIMARY KEY (id)
)#
ALTER TABLE public.aux_descontinuidade_geometrica OWNER TO postgres#
CREATE TABLE public.aux_descontinuidade_geometrica_p(
	geom geometry(MULTIPOINT, [epsg]) NOT NULL,
	CONSTRAINT aux_descontinuidade_geometrica_p_pk PRIMARY KEY (id)
) INHERITS(public.aux_descontinuidade_geometrica)
#
ALTER TABLE public.aux_descontinuidade_geometrica_p OWNER TO postgres#
CREATE TABLE public.aux_descontinuidade_geometrica_l(
	geom geometry(MULTILINESTRING, [epsg]) NOT NULL,
	CONSTRAINT aux_descontinuidade_geometrica_l_pk PRIMARY KEY (id)
) INHERITS(public.aux_descontinuidade_geometrica)
#
ALTER TABLE public.aux_descontinuidade_geometrica_l OWNER TO postgres#
CREATE TABLE dominios.situacao_marco
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_marco_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.material_predominante
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT material_predominante_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_travessia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_travessia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_agropec
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_agropec_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_elem_nat
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_elem_nat_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_alter_antrop
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_alter_antrop_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_aglom_rur_isol
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_aglom_rur_isol_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_manguezal
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_manguezal_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_org_sv_social
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_org_sv_social_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_fundeadouro
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_fundeadouro_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_org_militar
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_org_militar_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_poste
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_poste_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.uso_pista
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT uso_pista_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.destinacao_cemiterio
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT destinacao_cemiterio_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_passag_viad
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_passag_viad_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_metro_ferrov
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_metro_ferrov_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.qualid_agua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT qualid_agua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.posicao_relativa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT posicao_relativa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.destinadoa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT destinadoa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.classificacao_porte
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT classificacao_porte_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.sistema_geodesico
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT sistema_geodesico_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.grupo_ativ_econ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT grupo_ativ_econ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_turist
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_turist_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_banco
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_banco_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_lim_area_esp
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_lim_area_esp_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_localidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_localidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.nivel_atencao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT nivel_atencao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.nr_linhas
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT nr_linhas_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.booleano
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT booleano_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_equip_desenv_social
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_equip_desenv_social_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_sum_vert
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_sum_vert_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.especie
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT especie_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.nome_especialidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT nome_especialidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.bitola
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT bitola_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_relig
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_relig_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_drenagem
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_drenagem_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_agua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_agua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_campo_quadra
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_campo_quadra_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_lavoura
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_lavoura_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_energia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_energia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_curva_nivel
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_curva_nivel_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.divisao_ativ_econ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT divisao_ativ_econ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_embarcacao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_embarcacao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_campo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_campo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pto_ref_geod_topo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pto_ref_geod_topo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pista_comp
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pista_comp_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pavimentacao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pavimentacao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.referencial_altim
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT referencial_altim_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_obst
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_obst_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.finalidade_cultura
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT finalidade_cultura_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_cemiterio
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_cemiterio_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_equip_agropec
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_equip_agropec_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.administracao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT administracao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.forma_rocha
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT forma_rocha_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_comunic
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_comunic_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_dep_geral
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_dep_geral_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ref
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ref_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_posto_fisc
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_posto_fisc_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.rede_referencia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT rede_referencia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.jurisdicao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT jurisdicao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_exposicao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_exposicao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ext_min
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ext_min_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.modal_uso
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT modal_uso_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_estrut
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_estrut_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.causa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT causa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.cultivo_predominante
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT cultivo_predominante_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_poco_mina
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_poco_mina_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.proximidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT proximidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.mat_condutor
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT mat_condutor_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_fisica
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_fisica_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_espacial
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_espacial_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_rep_diplomatica
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_rep_diplomatica_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.local_equip_desenv_social
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT local_equip_desenv_social_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.categoria_edgv
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT categoria_edgv_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.sigla_uf
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT sigla_uf_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_delim_fis
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_delim_fis_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.mat_constr
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT mat_constr_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_assentamento_precario
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_assentamento_precario_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.unidade_volume
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT unidade_volume_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_produto_residuo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_produto_residuo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.relacionado
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT relacionado_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_arruamento
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_arruamento_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_lim_pol
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_lim_pol_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_est_gerad
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_est_gerad_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.motivodescontinuidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT motivodescontinuidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_complexo_portuario
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_complexo_portuario_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_juridica
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_juridica_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_combustivel
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_combustivel_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pto_controle
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pto_controle_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_em_agua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_em_agua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.referencial_grav
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT referencial_grav_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_massa_dagua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_massa_dagua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_caminho_aereo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_caminho_aereo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_instal_militar
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_instal_militar_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_entroncamento
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_entroncamento_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_travessia_ped
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_travessia_ped_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.trafego
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT trafego_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_hierarquia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_hierarquia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.finalidade_galeria_bueiro
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT finalidade_galeria_bueiro_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_sinal
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_sinal_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.secao_ativ_econ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT secao_ativ_econ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.posicao_rel_edific
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT posicao_rel_edific_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_terreno
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_terreno_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_lazer
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_lazer_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.causa_exposicao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT causa_exposicao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.revestimento
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT revestimento_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.referencial_legal
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT referencial_legal_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_duto
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_duto_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_complexo_aeroportuario
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_complexo_aeroportuario_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.modalidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT modalidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_aero
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_aero_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.densidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT densidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_transporte
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_transporte_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_lim_massa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_lim_massa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_plataforma
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_plataforma_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_recife
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_recife_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_comunic
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_comunic_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.poder_publico
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT poder_publico_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_queda
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_queda_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.finalidade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT finalidade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ilha
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ilha_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.booleano_estendido
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT booleano_estendido_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_unid_uso_sust
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_unid_uso_sust_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_unid_protegida
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_unid_protegida_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.condicao_terreno
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT condicao_terreno_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.classificacao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT classificacao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.especie_trecho_energia
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT especie_trecho_energia_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_tunel
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_tunel_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_erosao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_erosao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_elevador
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_elevador_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_rod
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_rod_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pista
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pista_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.estado_fisico
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT estado_fisico_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_atracad
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_atracad_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.forma_extracao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT forma_extracao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_area_umida
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_area_umida_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_uso_edif
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_uso_edif_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.mat_transp
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT mat_transp_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.situacao_costa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT situacao_costa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.finalidade_patio
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT finalidade_patio_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_abast
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_abast_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.regime
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT regime_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.atividade
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT atividade_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_comerc_serv
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_comerc_serv_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_massa
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_massa_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_unid_prot_integ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_unid_prot_integ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.finalidade_deposito
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT finalidade_deposito_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_port
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_port_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_ponte
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_ponte_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_quebra_molhe
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_quebra_molhe_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.classe_ativ_econ
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT classe_ativ_econ_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_rod
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_rod_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.aptidao_operacional_atracadouro
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT aptidao_operacional_atracadouro_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_pto_est_med
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_pto_est_med_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_associado
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_associado_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_fonte_dagua
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_fonte_dagua_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.uso_principal
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT uso_principal_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_edif_saneam
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_edif_saneam_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_org_civil
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_org_civil_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_vegetacao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_vegetacao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_conteudo
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_conteudo_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_terreno_exposto
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_terreno_exposto_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.proc_extracao
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT proc_extracao_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_trecho_ferrov
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_trecho_ferrov_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.denominacao_associada
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT denominacao_associada_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.setor
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT setor_pk PRIMARY KEY (code)
                                )#
CREATE TABLE dominios.tipo_capital
                    (
                    code smallint NOT NULL,
                    code_name text NOT NULL,
                    CONSTRAINT tipo_capital_pk PRIMARY KEY (code)
                                )#
INSERT INTO dominios.situacao_marco (code,code_name) values (1,'Bom')#
INSERT INTO dominios.situacao_marco (code,code_name) values (3,'Destruído sem chapa')#
INSERT INTO dominios.situacao_marco (code,code_name) values (2,'Destruído')#
INSERT INTO dominios.situacao_marco (code,code_name) values (5,'Não encontrado')#
INSERT INTO dominios.situacao_marco (code,code_name) values (4,'Destruído com chapa danificada')#
INSERT INTO dominios.situacao_marco (code,code_name) values (7,'Não construído')#
INSERT INTO dominios.situacao_marco (code,code_name) values (6,'Não visitado')#
INSERT INTO dominios.situacao_marco (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.material_predominante (code,code_name) values (13,'Areia fina')#
INSERT INTO dominios.material_predominante (code,code_name) values (12,'Areia')#
INSERT INTO dominios.material_predominante (code,code_name) values (20,'Coral')#
INSERT INTO dominios.material_predominante (code,code_name) values (14,'Lama')#
INSERT INTO dominios.material_predominante (code,code_name) values (17,'Concha')#
INSERT INTO dominios.material_predominante (code,code_name) values (19,'Lodo')#
INSERT INTO dominios.material_predominante (code,code_name) values (18,'Argila')#
INSERT INTO dominios.material_predominante (code,code_name) values (22,'Ervas marinhas')#
INSERT INTO dominios.material_predominante (code,code_name) values (50,'Pedra')#
INSERT INTO dominios.material_predominante (code,code_name) values (99,'Outros')#
INSERT INTO dominios.material_predominante (code,code_name) values (98,'Misto')#
INSERT INTO dominios.material_predominante (code,code_name) values (4,'Rocha')#
INSERT INTO dominios.material_predominante (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.material_predominante (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.material_predominante (code,code_name) values (21,'Seixo')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (1,'Vau natural')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (3,'Bote transportador')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (2,'Vau construída')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_travessia (code,code_name) values (4,'Balsa')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (13,'Aviário')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (12,'Sede operacional de fazenda')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (15,'Viveiro de plantas')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (14,'Apiário')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (17,'Pocilga')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (16,'Viveiro para aquicultura')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (18,'Curral')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_agropec (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (20,'Gruta')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (21,'Ilha')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (22,'Pico')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (23,'Rocha')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (1,'Serra')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (3,'Montanha')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (2,'Morro')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (5,'Maciço')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (4,'Chapada')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (7,'Planície')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (6,'Planalto')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (9,'Península')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (8,'Escarpa')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (11,'Cabo')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (10,'Ponta')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (13,'Falésia')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (12,'Praia')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (15,'Caverna')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (14,'Talude')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (17,'Duna')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (16,'Dolina')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (19,'Fenda')#
INSERT INTO dominios.tipo_elem_nat (code,code_name) values (18,'Falha')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (24,'Caixa de empréstimo')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (25,'Área Aterrada')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (26,'Corte')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (27,'Aterro')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (32,'Área de extração mineral')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (31,'Vala')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (30,'Canal')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (28,'Resíduo de bota-fora')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (29,'Resíduo sólido em geral')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_alter_antrop (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_aglom_rur_isol (code,code_name) values (5,'Povoado')#
INSERT INTO dominios.tipo_aglom_rur_isol (code,code_name) values (7,'Outros aglomerados rurais isolados')#
INSERT INTO dominios.tipo_aglom_rur_isol (code,code_name) values (6,'Núcleo')#
INSERT INTO dominios.tipo_manguezal (code,code_name) values (3,'Manguezal tipo apicum')#
INSERT INTO dominios.tipo_manguezal (code,code_name) values (2,'Manguezal')#
INSERT INTO dominios.tipo_manguezal (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_manguezal (code,code_name) values (4,'Manguezal tipo salgado')#
INSERT INTO dominios.tipo_org_sv_social (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_org_sv_social (code,code_name) values (3,'Asilo')#
INSERT INTO dominios.tipo_org_sv_social (code,code_name) values (2,'Orfanato')#
INSERT INTO dominios.tipo_org_sv_social (code,code_name) values (5,'Albergue')#
INSERT INTO dominios.tipo_org_sv_social (code,code_name) values (4,'Casa de Repouso')#
INSERT INTO dominios.tipo_org_sv_social (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_fundeadouro (code,code_name) values (1,'Navio/Embarcação')#
INSERT INTO dominios.tipo_fundeadouro (code,code_name) values (2,'Hidroavião')#
INSERT INTO dominios.tipo_org_militar (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_org_militar (code,code_name) values (3,'Exército')#
INSERT INTO dominios.tipo_org_militar (code,code_name) values (2,'Corpo de bombeiros')#
INSERT INTO dominios.tipo_org_militar (code,code_name) values (5,'Marinha')#
INSERT INTO dominios.tipo_org_militar (code,code_name) values (4,'Força Aérea')#
INSERT INTO dominios.tipo_org_militar (code,code_name) values (6,'Polícia Militar')#
INSERT INTO dominios.tipo_org_militar (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_poste (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_poste (code,code_name) values (3,'Ornamental')#
INSERT INTO dominios.tipo_poste (code,code_name) values (2,'Iluminação')#
INSERT INTO dominios.tipo_poste (code,code_name) values (5,'Sinalização')#
INSERT INTO dominios.tipo_poste (code,code_name) values (4,'Rede elétrica')#
INSERT INTO dominios.tipo_poste (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.uso_pista (code,code_name) values (11,'Público')#
INSERT INTO dominios.uso_pista (code,code_name) values (13,'Público compartilhado com uso militar')#
INSERT INTO dominios.uso_pista (code,code_name) values (12,'Militar')#
INSERT INTO dominios.uso_pista (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.uso_pista (code,code_name) values (6,'Particular')#
INSERT INTO dominios.destinacao_cemiterio (code,code_name) values (3,'Animais')#
INSERT INTO dominios.destinacao_cemiterio (code,code_name) values (2,'Humanos')#
INSERT INTO dominios.tipo_passag_viad (code,code_name) values (5,'Passagem elevada')#
INSERT INTO dominios.tipo_passag_viad (code,code_name) values (6,'Viaduto')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (15,'Administrativa')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (17,'Estação metroviária')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (16,'Estação ferroviária de passageiros')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (19,'Terminal ferroviário de passageiros e cargas')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (18,'Terminal ferroviário de cargas')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (20,'Oficina de manutenção')#
INSERT INTO dominios.tipo_edif_metro_ferrov (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.qualid_agua (code,code_name) values (1,'Potável')#
INSERT INTO dominios.qualid_agua (code,code_name) values (3,'Mineral')#
INSERT INTO dominios.qualid_agua (code,code_name) values (2,'Não potável')#
INSERT INTO dominios.qualid_agua (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.qualid_agua (code,code_name) values (4,'Salobra')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (3,'Elevada')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (2,'Superfície')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (5,'Submersa')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (4,'Emersa')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (6,'Subterrânea')#
INSERT INTO dominios.posicao_relativa (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.destinadoa (code,code_name) values (39,'Jaborandi')#
INSERT INTO dominios.destinadoa (code,code_name) values (38,'Coco')#
INSERT INTO dominios.destinadoa (code,code_name) values (18,'Açaí')#
INSERT INTO dominios.destinadoa (code,code_name) values (44,'Pesca')#
INSERT INTO dominios.destinadoa (code,code_name) values (37,'Carnaúba')#
INSERT INTO dominios.destinadoa (code,code_name) values (43,'Pecuária')#
INSERT INTO dominios.destinadoa (code,code_name) values (35,'Látex')#
INSERT INTO dominios.destinadoa (code,code_name) values (41,'Babaçu')#
INSERT INTO dominios.destinadoa (code,code_name) values (99,'Outros')#
INSERT INTO dominios.destinadoa (code,code_name) values (36,'Castanha')#
INSERT INTO dominios.destinadoa (code,code_name) values (5,'Madeira')#
INSERT INTO dominios.destinadoa (code,code_name) values (40,'Palmito')#
INSERT INTO dominios.destinadoa (code,code_name) values (34,'Turfa')#
INSERT INTO dominios.destinadoa (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (98,'Mista')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (3,'Herbácea')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (2,'Rasteira')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (5,'Arbustiva')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (4,'Arbórea')#
INSERT INTO dominios.classificacao_porte (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (1,'SAD-69')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (3,'WGS-84')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (2,'SIRGAS2000')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (5,'Astro Chuá')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (4,'Córrego Alegre')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (7,'SAD-69 (96)')#
INSERT INTO dominios.sistema_geodesico (code,code_name) values (6,'Outra referência')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (20,'Ensino superior')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (23,'Educação profissional e outras atividades de ensino')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (19,'Ensino médio')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (32,'Serviço social')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (31,'Serviços veterinários')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (30,'Atividades de atenção à saúde')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (15,'Seguridade social')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (99,'Outros')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (98,'Misto')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (16,'Educação infantil e ensino fundamental')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (6,'Administração do estado e da política econômica e social')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (8,'Serviços coletivos prestados pela administração')#
INSERT INTO dominios.grupo_ativ_econ (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (11,'Mirante')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (10,'Estátua')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (13,'Panteão')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (12,'Monumento')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (15,'Chaminé')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (14,'Chafariz')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (17,'Obelisco')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (16,'Escultura')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (18,'Torre')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (9,'Cruzeiro')#
INSERT INTO dominios.tipo_edif_turist (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_banco (code,code_name) values (1,'Fluvial')#
INSERT INTO dominios.tipo_banco (code,code_name) values (3,'Lacustre')#
INSERT INTO dominios.tipo_banco (code,code_name) values (2,'Marítimo')#
INSERT INTO dominios.tipo_banco (code,code_name) values (4,'Cordão arenoso')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (24,'Área de proteção ambiental - APA')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (25,'Área de relevante interesse ecológico - ARIE')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (26,'Floresta - FLO')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (27,'Reserva de desenvolvimento sustentável - RDS')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (20,'Horto florestal')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (21,'Estrada parque')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (22,'Floresta de rendimento sustentável')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (23,'Floresta extrativista')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (28,'Reserva extrativista - RESEX')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (29,'Reserva de fauna - REFAU')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (1,'Terra pública')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (3,'Terra de remanescentes quilombolas')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (2,'Terra indígena')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (5,'Amazônia legal')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (4,'Assentamento rural')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (7,'Polígono da seca')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (6,'Faixa de fronteira')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (9,'Reserva legal')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (8,'Área de preservação permanente')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (11,'Distrito florestal sustentável')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (10,'Mosaico')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (13,'Floresta pública')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (12,'Corredor ecológico')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (15,'Sítios do patrimônio')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (14,'Sitios RAMSAR')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (17,'Reserva florestal')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (16,'Reserva da biosfera')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (19,'Estação biológica')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (32,'Parque - PAR')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (31,'Estação ecológica - ESEC')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (30,'Reserva particular do patrimônio natural - RPPN')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (37,'Zoneamento')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (36,'Área militar')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (35,'Refúgio da vida silvestre - RVS')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (34,'Reserva biológica - REBIO')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (33,'Monumento natural - MONA')#
INSERT INTO dominios.tipo_lim_area_esp (code,code_name) values (18,'Reserva ecológica')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (1,'Aglomerado rural')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (3,'Aglomerado rural isolado')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (2,'Aglomerado rural de extensão urbana')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (5,'Cidade')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (4,'Capital')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (6,'Vila')#
INSERT INTO dominios.tipo_localidade (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.nivel_atencao (code,code_name) values (5,'Primário')#
INSERT INTO dominios.nivel_atencao (code,code_name) values (7,'Terciário')#
INSERT INTO dominios.nivel_atencao (code,code_name) values (6,'Secundário')#
INSERT INTO dominios.nr_linhas (code,code_name) values (1,'Simples')#
INSERT INTO dominios.nr_linhas (code,code_name) values (3,'Múltipla')#
INSERT INTO dominios.nr_linhas (code,code_name) values (2,'Dupla')#
INSERT INTO dominios.nr_linhas (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.booleano (code,code_name) values (1,'Sim')#
INSERT INTO dominios.booleano (code,code_name) values (0,'Não')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (20,'Unidade de acolhimento para mulheres vitmas de violência')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (21,'Unidade de acolhimento para pessoas em situação de rua')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (1,'Banco de Alimentos')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (3,'Bolsa Verde')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (2,'Barragem Calçadão')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (5,'Centro POP')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (4,'Centro de Convivência')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (7,'Cisterna Subterrânea')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (6,'Centro-dia')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (9,'Cisterna de Placa')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (8,'Cisterna de Polietileno')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (11,'CRAS')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (10,'Cozinha Comunitária')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (13,'PAA')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (12,'CREAS')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (15,'PRONATEC')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (14,'PRONAF')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (17,'Unidade de acolhimento para crianças e adolescentes')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (16,'Restaurante Popular')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (19,'Unidade de acolhimento para idosos')#
INSERT INTO dominios.tipo_equip_desenv_social (code,code_name) values (18,'Unidade de acolhimento para crianças e adolescentes (casa de passagem)')#
INSERT INTO dominios.tipo_sum_vert (code,code_name) values (1,'Sumidouro')#
INSERT INTO dominios.tipo_sum_vert (code,code_name) values (2,'Vertedouro')#
INSERT INTO dominios.especie (code,code_name) values (11,'Bambu')#
INSERT INTO dominios.especie (code,code_name) values (10,'Cipó')#
INSERT INTO dominios.especie (code,code_name) values (27,'Araucária')#
INSERT INTO dominios.especie (code,code_name) values (17,'Palmeira')#
INSERT INTO dominios.especie (code,code_name) values (37,'Sem predominância')#
INSERT INTO dominios.especie (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.especie (code,code_name) values (96,'Não identificado')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (42,'Nutrologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (48,'Pneumologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (43,'Oftalmologia e Traumatologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (49,'Psiquiatria')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (34,'Medicina Física e Reabilitação')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (53,'Urologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (24,'Geriatria')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (25,'Ginecologia e Obstetrícia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (26,'Hematologia e Hemoterapia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (27,'Homeopatia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (20,'Endocrinologia e Metabologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (21,'Endoscopia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (22,'Gastroenterologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (23,'Genética Médica')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (46,'Patologia Clínica/Medicina Laboratorial')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (47,'Pediatria')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (44,'Otorrinolaringologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (45,'Patologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (28,'Infectologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (29,'Mastologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (40,'Neurocirurgia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (41,'Neurologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (3,'Alergia e Imunologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (2,'Acupuntura')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (5,'Angiologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (4,'Anestesiologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (7,'Cardiologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (6,'Cancerologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (9,'Cirurgia da Mão')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (8,'Cirurgia Cardiovascular')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (39,'Nefrologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (12,'Cirurgia Geral')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (11,'Cirurgia do Aparelho Digestivo')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (10,'Cirurgia de Cabeça e Pescoço')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (13,'Cirurgia Pediátrica')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (38,'Medicina Preventiva e Social')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (15,'Cirurgia Torácica')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (14,'Cirurgia Plástica')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (17,'Clínica Médica')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (16,'Cirurgia Vascular')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (19,'Dermatologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (32,'Medicina de Tráfego')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (31,'Medicina do Trabalho')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (30,'Medicina de Família e Comunidade')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (51,'Radioterapia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (36,'Medicina Legal e Perícia Médica')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (35,'Medicina Intensiva')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (52,'Reumatologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (33,'Medicina Esportiva')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (37,'Medicina Nuclear')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (18,'Coloproctologia')#
INSERT INTO dominios.nome_especialidade (code,code_name) values (50,'Radiologia e Diagnóstico por Imagem')#
INSERT INTO dominios.bitola (code,code_name) values (3,'Internacional')#
INSERT INTO dominios.bitola (code,code_name) values (2,'Métrica')#
INSERT INTO dominios.bitola (code,code_name) values (5,'Mista métrica internacional')#
INSERT INTO dominios.bitola (code,code_name) values (4,'Larga')#
INSERT INTO dominios.bitola (code,code_name) values (7,'Mista internacional larga')#
INSERT INTO dominios.bitola (code,code_name) values (6,'Mista métrica larga')#
INSERT INTO dominios.bitola (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (1,'Igreja')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (3,'Centro')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (2,'Templo')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (5,'Convento')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (4,'Mosteiro')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (7,'Sinagoga')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (6,'Mesquita')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (9,'Capela mortuária')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (8,'Terreiro')#
INSERT INTO dominios.tipo_edif_relig (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_drenagem (code,code_name) values (5,'Pluvial')#
INSERT INTO dominios.tipo_trecho_drenagem (code,code_name) values (4,'Curso dágua')#
INSERT INTO dominios.situacao_agua (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.situacao_agua (code,code_name) values (7,'Não tratada')#
INSERT INTO dominios.situacao_agua (code,code_name) values (6,'Tratada')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (1,'Futebol')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (3,'Voleibol')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (2,'Basquetebol')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (5,'Hipismo')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (4,'Pólo')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (7,'Tênis')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (6,'Poliesportiva')#
INSERT INTO dominios.tipo_campo_quadra (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_lavoura (code,code_name) values (1,'Perene')#
INSERT INTO dominios.tipo_lavoura (code,code_name) values (3,'Anual')#
INSERT INTO dominios.tipo_lavoura (code,code_name) values (2,'Semi-perene')#
INSERT INTO dominios.tipo_lavoura (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (1,'Administrativa')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (3,'Segurança')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (2,'Oficinas')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (5,'Chaminé')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (4,'Depósito')#
INSERT INTO dominios.tipo_edif_energia (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_curva_nivel (code,code_name) values (1,'Mestra')#
INSERT INTO dominios.tipo_curva_nivel (code,code_name) values (3,'Auxiliar')#
INSERT INTO dominios.tipo_curva_nivel (code,code_name) values (2,'Normal')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (51,'Comércio por atacado e representantes comerciais e agentes do comércio')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (36,'Fabricação de móveis e indústrias diversas')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (34,'Fabricação e montagem de veículos automotores')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (24,'Fabricação de produtos químicos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (25,'Fabricação de artigos de borracha e material plástico')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (27,'Metalurgia básica')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (20,'Fabricação de produtos de madeira e celulose')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (21,'Fabricação de celulose')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (22,'Edição')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (23,'Fabricação de coque')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (45,'Construção')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (28,'Fabricação de produtos de metal')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (29,'Fabricação de máquinas e equipamentos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (1,'Agricultura')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (2,'Silvicultura')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (5,'Pesca')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (99,'Outros')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (74,'Serviços prestados principalmente a empresas (organizações)')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (92,'Atividades recreativas')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (11,'Extração de petróleo e serviços relacionados')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (10,'Extração de carvão mineral')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (13,'Extração de minerais metálicos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (15,'Fabricação alimentícia e bebidas')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (14,'Fabricação de produtos de minerais não metálicos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (17,'Fabricação de produtos têxteis')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (16,'Fabricação de produtos do fumo')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (19,'Preparação de couros e fabricação de artefatos de couro')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (18,'Confecção de artigos do vestuário e acessórios')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (31,'Fabricação de máquinas')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (30,'Fabricação de máquinas de escritório e equipamentos de informática')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (37,'Reciclagem')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (50,'Comércio e reparação de veiculos automotores e motocicletas e comércio a varejo de combustíveis')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (35,'Fabricação de outros equipamentos de transporte')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (52,'Comércio varejista e reparação de objetos pessoais e domésticos')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (33,'Fabricação de equipamentos de instrumentação médico-hospitalares')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (55,'Alojamento e alimentação')#
INSERT INTO dominios.divisao_ativ_econ (code,code_name) values (32,'Fabricação de material eletrônico')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (3,'Lancha')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (2,'Balsa')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (7,'Embarcação de pequeno porte')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (6,'Empurrador-balsa')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_embarcacao (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_campo (code,code_name) values (1,'Sujo')#
INSERT INTO dominios.tipo_campo (code,code_name) values (3,'Rupestre')#
INSERT INTO dominios.tipo_campo (code,code_name) values (2,'Limpo')#
INSERT INTO dominios.tipo_campo (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (1,'Vértice de triangulação - VT')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (3,'Estação gravimétrica - EG')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (2,'Referência de nível - RN')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (5,'Ponto astronômico - PA')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (4,'Estação de poligonal - EP')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (7,'Ponto trigonométrico - RV')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (6,'Ponto barométrico - B')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (8,'Ponto de satélite - SAT')#
INSERT INTO dominios.tipo_pto_ref_geod_topo (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (1,'Atletismo')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (3,'Motociclismo')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (5,'Corrida de cavalos')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (4,'Automobilismo')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (7,'Ciclismo')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (6,'Bicicross')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (8,'Motocross')#
INSERT INTO dominios.tipo_pista_comp (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (3,'Placa de concreto')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (2,'Asfalto')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (5,'Ladrilho de concreto')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (4,'Pedra regular')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (7,'Pedra irregular')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (6,'Paralelepípedo')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pavimentacao (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.referencial_altim (code,code_name) values (99,'Outra referência')#
INSERT INTO dominios.referencial_altim (code,code_name) values (1,'Torres')#
INSERT INTO dominios.referencial_altim (code,code_name) values (3,'Santana')#
INSERT INTO dominios.referencial_altim (code,code_name) values (2,'Imbituba')#
INSERT INTO dominios.tipo_obst (code,code_name) values (5,'Artificial')#
INSERT INTO dominios.tipo_obst (code,code_name) values (4,'Natural')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (99,'Outros')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (1,'Exploração econômica')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (3,'Conservação ambiental')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (2,'Subsistência')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (4,'Ornamental')#
INSERT INTO dominios.finalidade_cultura (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (1,'Crematório')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (3,'Vertical')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (2,'Parque')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (5,'Túmulo isolado')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (4,'Comum')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (6,'Horizontal/vertical')#
INSERT INTO dominios.tipo_cemiterio (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (1,'Pivô central')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (2,'Moinho')#
INSERT INTO dominios.tipo_equip_agropec (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.administracao (code,code_name) values (3,'Estadual/Distrital')#
INSERT INTO dominios.administracao (code,code_name) values (2,'Federal')#
INSERT INTO dominios.administracao (code,code_name) values (5,'Concessionada')#
INSERT INTO dominios.administracao (code,code_name) values (4,'Municipal')#
INSERT INTO dominios.administracao (code,code_name) values (6,'Privada')#
INSERT INTO dominios.administracao (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.administracao (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.forma_rocha (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.forma_rocha (code,code_name) values (21,'Matacão - pedra')#
INSERT INTO dominios.forma_rocha (code,code_name) values (22,'Penedo isolado')#
INSERT INTO dominios.forma_rocha (code,code_name) values (23,'Área rochosa - lajedo')#
INSERT INTO dominios.tipo_edif_comunic (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_comunic (code,code_name) values (1,'Centro de operações')#
INSERT INTO dominios.tipo_edif_comunic (code,code_name) values (3,'Estação radio-base')#
INSERT INTO dominios.tipo_edif_comunic (code,code_name) values (2,'Central comutação e transmissão')#
INSERT INTO dominios.tipo_edif_comunic (code,code_name) values (4,'Estação repetidora')#
INSERT INTO dominios.tipo_edif_comunic (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (11,'Depósito frigorífico')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (10,'Composteira')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (26,'Barracão industrial')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (19,'Reservatório')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (32,'Armazém')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (1,'Tanque')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (3,'Cisterna')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (2,'Caixa d''água')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (5,'Aterro sanitário')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (4,'Depósito de lixo')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (6,'Aterro controlado')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (9,'Silo')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (8,'Galpão')#
INSERT INTO dominios.tipo_dep_geral (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_ref (code,code_name) values (1,'Altimétrico')#
INSERT INTO dominios.tipo_ref (code,code_name) values (3,'Planialtimétrico')#
INSERT INTO dominios.tipo_ref (code,code_name) values (2,'Planimétrico')#
INSERT INTO dominios.tipo_ref (code,code_name) values (4,'Gravimétrico')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (10,'Tributação')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (13,'Posto de pesagem')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (12,'Fiscalização sanitária')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_posto_fisc (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.rede_referencia (code,code_name) values (15,'Privada')#
INSERT INTO dominios.rede_referencia (code,code_name) values (3,'Municipal')#
INSERT INTO dominios.rede_referencia (code,code_name) values (2,'Estadual')#
INSERT INTO dominios.rede_referencia (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.rede_referencia (code,code_name) values (14,'Nacional')#
INSERT INTO dominios.jurisdicao (code,code_name) values (1,'Federal')#
INSERT INTO dominios.jurisdicao (code,code_name) values (3,'Municipal')#
INSERT INTO dominios.jurisdicao (code,code_name) values (2,'Estadual/Distrital')#
INSERT INTO dominios.jurisdicao (code,code_name) values (4,'Internacional')#
INSERT INTO dominios.jurisdicao (code,code_name) values (8,'Propriedade particular')#
INSERT INTO dominios.jurisdicao (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (5,'Céu aberto')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (3,'Fechado')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_exposicao (code,code_name) values (4,'Coberto')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (1,'Poço para água subterrânea')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (5,'Garimpo')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (4,'Mina')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (6,'Salina')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (8,'Poço de petróleo')#
INSERT INTO dominios.tipo_ext_min (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.modal_uso (code,code_name) values (10,'Hidroviário')#
INSERT INTO dominios.modal_uso (code,code_name) values (14,'Portuário')#
INSERT INTO dominios.modal_uso (code,code_name) values (5,'Ferroviário')#
INSERT INTO dominios.modal_uso (code,code_name) values (4,'Rodoviário')#
INSERT INTO dominios.modal_uso (code,code_name) values (7,'Dutos')#
INSERT INTO dominios.modal_uso (code,code_name) values (6,'Metroviário')#
INSERT INTO dominios.modal_uso (code,code_name) values (9,'Aeroportuário')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (1,'Estação')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (3,'Fiscalização')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (2,'Comércio e serviços')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (5,'Terminal')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (4,'Porto seco')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (9,'Parada')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (8,'Integração')#
INSERT INTO dominios.tipo_estrut (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.causa (code,code_name) values (5,'Canalização')#
INSERT INTO dominios.causa (code,code_name) values (2,'Absorção')#
INSERT INTO dominios.causa (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.causa (code,code_name) values (4,'Gruta ou fenda')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (24,'Pastagem cultivada')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (25,'Hortaliças')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (26,'Bracatinga')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (27,'Araucária')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (20,'Eucalipto')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (21,'Acácia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (22,'Algaroba')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (23,'Pinus')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (28,'Carnaúba')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (29,'Pera')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (4,'Trigo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (8,'Fumo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (59,'Caqui')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (58,'Caju')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (55,'Azeitona')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (54,'Aveia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (57,'Batata-doce')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (56,'Azevem')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (51,'Ameixa')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (50,'Alho')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (53,'Amora')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (52,'Amendoim')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (115,'Tungue')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (114,'Triticale')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (88,'Melancia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (89,'Melão')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (111,'Sorgo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (110,'Sisal ou agave')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (113,'Tomate')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (112,'Tangerina')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (82,'Malva')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (83,'Mamão')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (80,'Limão')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (81,'Linho')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (86,'Maracujá')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (87,'Marmelo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (84,'Mamona')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (85,'Manga')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (3,'Laranja')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (7,'Cana de açúcar')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (108,'Rami')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (109,'Rotativa')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (102,'Palmito')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (103,'Pepino')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (100,'Nabo forrageiro')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (101,'Noz')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (106,'Plantas ornamentais')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (107,'Policultura')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (104,'Piaçava')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (105,'Pimenta do reino')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (33,'Cebola')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (32,'Juta')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (31,'Pêssego')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (30,'Maçã')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (60,'Carambola')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (61,'Centeio')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (62,'Cevada')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (63,'Chá-da-índia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (64,'Cidra')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (65,'Coco-da-baía')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (66,'Cravo da índia')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (67,'Cupuaçu')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (68,'Dendê')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (69,'Ervilha')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (2,'Banana')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (6,'Algodão herbáceo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (99,'Outros')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (90,'Milheto')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (96,'Não identificado')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (11,'Mandioca')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (10,'Batata inglesa')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (13,'Arroz')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (12,'Feijão')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (15,'Cacau')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (14,'Café')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (17,'Palmeira')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (16,'Erva-mate')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (19,'Seringueira')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (18,'Açaí')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (116,'Urucum')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (48,'Alfafa')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (49,'Algodão arbóreo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (46,'Acerola')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (47,'Alcachofra')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (44,'Abacaxi ou ananás')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (45,'Abóbora')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (42,'Uva')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (43,'Abacate')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (1,'Milho')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (9,'Soja')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (77,'Inhame')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (76,'Guaraná')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (75,'Grão-de-Bico')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (74,'Goiaba')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (73,'Girassol')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (72,'Flores')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (71,'Figo')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (70,'Fava')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (79,'Lentilha')#
INSERT INTO dominios.cultivo_predominante (code,code_name) values (78,'Kiwi')#
INSERT INTO dominios.tipo_poco_mina (code,code_name) values (3,'Vertical')#
INSERT INTO dominios.tipo_poco_mina (code,code_name) values (2,'Horizontal')#
INSERT INTO dominios.tipo_poco_mina (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_poco_mina (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.proximidade (code,code_name) values (15,'Adjacente')#
INSERT INTO dominios.proximidade (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.proximidade (code,code_name) values (14,'Isolada')#
INSERT INTO dominios.proximidade (code,code_name) values (16,'Coincidente')#
INSERT INTO dominios.mat_condutor (code,code_name) values (99,'Outros')#
INSERT INTO dominios.mat_condutor (code,code_name) values (25,'Fibra ótica')#
INSERT INTO dominios.mat_condutor (code,code_name) values (26,'Fio Metálico')#
INSERT INTO dominios.mat_condutor (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (1,'Abandonada')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (3,'Em construção')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (2,'Destruída')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (5,'Construída')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (4,'Planejada')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (7,'Construída, mas em obras')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.situacao_fisica (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (13,'Superposta nivel 1')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (12,'Adjacente')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (99,'Outra')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (2,'Subterrânea')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (5,'Nivel do solo')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (4,'Superposta nivel 2')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (7,'Superposta nivel 3')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.situacao_espacial (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_rep_diplomatica (code,code_name) values (3,'Consulado')#
INSERT INTO dominios.tipo_rep_diplomatica (code,code_name) values (2,'Embaixada')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (1,'Terras Indígena')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (3,'Terras Quilombola')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (2,'Terras de População Ribeirinha')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (5,'Urbano central')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (4,'Rural')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (7,'Outras Comunidades tradicionais')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (6,'Urbana periférica')#
INSERT INTO dominios.local_equip_desenv_social (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (11,'laz')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (10,'hid')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (13,'pto')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (12,'lpal')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (15,'rod')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (14,'rel')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (17,'tra')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (16,'sb')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (19,'ver')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (18,'veg')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (1,'aer')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (3,'dut')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (2,'cb')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (5,'edf')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (4,'eco')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (7,'enc')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (6,'emu')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (9,'hdv')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (8,'fer')#
INSERT INTO dominios.categoria_edgv (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.sigla_uf (code,code_name) values (24,'SC')#
INSERT INTO dominios.sigla_uf (code,code_name) values (25,'SE')#
INSERT INTO dominios.sigla_uf (code,code_name) values (26,'SP')#
INSERT INTO dominios.sigla_uf (code,code_name) values (27,'TO')#
INSERT INTO dominios.sigla_uf (code,code_name) values (20,'RN')#
INSERT INTO dominios.sigla_uf (code,code_name) values (21,'RO')#
INSERT INTO dominios.sigla_uf (code,code_name) values (22,'RR')#
INSERT INTO dominios.sigla_uf (code,code_name) values (23,'RS')#
INSERT INTO dominios.sigla_uf (code,code_name) values (1,'AC')#
INSERT INTO dominios.sigla_uf (code,code_name) values (3,'AM')#
INSERT INTO dominios.sigla_uf (code,code_name) values (2,'AL')#
INSERT INTO dominios.sigla_uf (code,code_name) values (5,'BA')#
INSERT INTO dominios.sigla_uf (code,code_name) values (4,'AP')#
INSERT INTO dominios.sigla_uf (code,code_name) values (7,'DF')#
INSERT INTO dominios.sigla_uf (code,code_name) values (6,'CE')#
INSERT INTO dominios.sigla_uf (code,code_name) values (9,'GO')#
INSERT INTO dominios.sigla_uf (code,code_name) values (8,'ES')#
INSERT INTO dominios.sigla_uf (code,code_name) values (11,'MG')#
INSERT INTO dominios.sigla_uf (code,code_name) values (10,'MA')#
INSERT INTO dominios.sigla_uf (code,code_name) values (13,'MT')#
INSERT INTO dominios.sigla_uf (code,code_name) values (12,'MS')#
INSERT INTO dominios.sigla_uf (code,code_name) values (15,'PB')#
INSERT INTO dominios.sigla_uf (code,code_name) values (14,'PA')#
INSERT INTO dominios.sigla_uf (code,code_name) values (17,'PI')#
INSERT INTO dominios.sigla_uf (code,code_name) values (16,'PE')#
INSERT INTO dominios.sigla_uf (code,code_name) values (19,'RJ')#
INSERT INTO dominios.sigla_uf (code,code_name) values (18,'PR')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (1,'Cerca')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (3,'Mureta')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (2,'Muro')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_delim_fis (code,code_name) values (4,'Gradil')#
INSERT INTO dominios.mat_constr (code,code_name) values (99,'Outros')#
INSERT INTO dominios.mat_constr (code,code_name) values (23,'Terra')#
INSERT INTO dominios.mat_constr (code,code_name) values (1,'Alvenaria')#
INSERT INTO dominios.mat_constr (code,code_name) values (3,'Metal')#
INSERT INTO dominios.mat_constr (code,code_name) values (2,'Concreto')#
INSERT INTO dominios.mat_constr (code,code_name) values (5,'Madeira')#
INSERT INTO dominios.mat_constr (code,code_name) values (4,'Rocha')#
INSERT INTO dominios.mat_constr (code,code_name) values (8,'Fibra')#
INSERT INTO dominios.mat_constr (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.mat_constr (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (1,'Cortiço')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (3,'Favela')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (2,'Conjunto habitacional degradado')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (5,'Mocambos')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (4,'Loteamento irregular da periferia')#
INSERT INTO dominios.tipo_assentamento_precario (code,code_name) values (6,'Palafitas')#
INSERT INTO dominios.unidade_volume (code,code_name) values (1,'Litro')#
INSERT INTO dominios.unidade_volume (code,code_name) values (2,'Metro cúbico')#
INSERT INTO dominios.unidade_volume (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (56,'Carvão vegetal')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (53,'Barita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (42,'Areia')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (22,'Pedra (brita)')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (43,'Saibro/piçarra')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (60,'Citrino')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (61,'Crisoberilo')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (62,'Cristal de rocha')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (63,'Cromo')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (64,'Diatomita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (65,'Dolomito')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (66,'Esgoto')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (67,'Esmeralda')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (68,'Estanho')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (69,'Feldspato')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (80,'Nióbio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (81,'Níquel')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (86,'Titânio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (87,'Topázio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (84,'Sal-gema')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (85,'Terras raras')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (24,'Mármore')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (25,'Bauxita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (26,'Manganês')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (27,'Talco')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (20,'Inseticida')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (21,'Folhagem')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (48,'Água mineral')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (23,'Granito')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (46,'Água')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (47,'Água marinha')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (82,'Opala')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (45,'Ágata')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (28,'Óleo diesel')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (29,'Gasolina')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (40,'Pedra preciosa')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (41,'Forragem')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (3,'Petróleo')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (5,'Gás')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (36,'Escória')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (6,'Grãos')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (18,'Cascalho')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (49,'Alexandrita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (83,'Rocha ornamental')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (34,'Sal')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (77,'Lixo tóxico')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (76,'Lixo séptico')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (75,'Lixo domiciliar e comercial')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (74,'Lítio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (73,'Granada')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (72,'Grafita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (71,'Gipsita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (70,'Fosfato')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (91,'Turmalina')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (90,'Turfa')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (100,'Zircônio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (92,'Urânio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (94,'Zinco')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (79,'Mica')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (78,'Magnesita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (39,'Prata')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (38,'Diamante')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (59,'Chumbo')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (58,'Chorume')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (17,'Estrume')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (16,'Vinhoto')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (33,'Carvão mineral')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (32,'Cobre')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (57,'Caulim')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (30,'Álcool')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (51,'Amianto')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (93,'Vermiculita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (35,'Ferro')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (52,'Argila')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (55,'Calcário')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (89,'Tungstênio')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (37,'Ouro')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (88,'Tório')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (54,'Bentonita')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (31,'Querosene')#
INSERT INTO dominios.tipo_produto_residuo (code,code_name) values (50,'Ametista')#
INSERT INTO dominios.relacionado (code,code_name) values (42,'Estação Rodoviária')#
INSERT INTO dominios.relacionado (code,code_name) values (24,'Travessia')#
INSERT INTO dominios.relacionado (code,code_name) values (25,'Canal ou vala')#
INSERT INTO dominios.relacionado (code,code_name) values (26,'Contato com localidade')#
INSERT INTO dominios.relacionado (code,code_name) values (27,'Edificação rodoviária')#
INSERT INTO dominios.relacionado (code,code_name) values (20,'Túnel')#
INSERT INTO dominios.relacionado (code,code_name) values (21,'Barragem')#
INSERT INTO dominios.relacionado (code,code_name) values (22,'Local crítico')#
INSERT INTO dominios.relacionado (code,code_name) values (23,'Depósito geral')#
INSERT INTO dominios.relacionado (code,code_name) values (28,'Entrocamento')#
INSERT INTO dominios.relacionado (code,code_name) values (29,'Galeria ou bueiro')#
INSERT INTO dominios.relacionado (code,code_name) values (40,'Outra mudança de atributo')#
INSERT INTO dominios.relacionado (code,code_name) values (41,'Desvio Ferroviário')#
INSERT INTO dominios.relacionado (code,code_name) values (3,'Passagem elevada ou viaduto')#
INSERT INTO dominios.relacionado (code,code_name) values (2,'Eclusa')#
INSERT INTO dominios.relacionado (code,code_name) values (5,'Queda dágua')#
INSERT INTO dominios.relacionado (code,code_name) values (4,'Comporta')#
INSERT INTO dominios.relacionado (code,code_name) values (7,'Foz marítima')#
INSERT INTO dominios.relacionado (code,code_name) values (6,'Corredeira')#
INSERT INTO dominios.relacionado (code,code_name) values (9,'Meandro abandonado')#
INSERT INTO dominios.relacionado (code,code_name) values (8,'Sumidouro')#
INSERT INTO dominios.relacionado (code,code_name) values (13,'Represa/açude')#
INSERT INTO dominios.relacionado (code,code_name) values (38,'Mudança do número de pistas')#
INSERT INTO dominios.relacionado (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.relacionado (code,code_name) values (10,'Lago / Lagoa')#
INSERT INTO dominios.relacionado (code,code_name) values (39,'Ponto de início de drenagem')#
INSERT INTO dominios.relacionado (code,code_name) values (12,'Laguna')#
INSERT INTO dominios.relacionado (code,code_name) values (15,'Ponte')#
INSERT INTO dominios.relacionado (code,code_name) values (14,'Entre trechos de drenagem')#
INSERT INTO dominios.relacionado (code,code_name) values (17,'Vertedouro')#
INSERT INTO dominios.relacionado (code,code_name) values (16,'Confluência')#
INSERT INTO dominios.relacionado (code,code_name) values (19,'Passagem de nível')#
INSERT INTO dominios.relacionado (code,code_name) values (18,'Pátio')#
INSERT INTO dominios.relacionado (code,code_name) values (31,'Mudança de UF')#
INSERT INTO dominios.relacionado (code,code_name) values (30,'Início/fim de trecho')#
INSERT INTO dominios.relacionado (code,code_name) values (37,'Ramificação')#
INSERT INTO dominios.relacionado (code,code_name) values (36,'Mudança de tipo de rodovia')#
INSERT INTO dominios.relacionado (code,code_name) values (35,'Mudança de revestimento')#
INSERT INTO dominios.relacionado (code,code_name) values (34,'Mudança de número de faixas')#
INSERT INTO dominios.relacionado (code,code_name) values (33,'Mudança de declividade')#
INSERT INTO dominios.relacionado (code,code_name) values (32,'Mudança de administração')#
INSERT INTO dominios.tipo_arruamento (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_arruamento (code,code_name) values (3,'Entroncamento')#
INSERT INTO dominios.tipo_arruamento (code,code_name) values (2,'Beco')#
INSERT INTO dominios.tipo_arruamento (code,code_name) values (5,'Servidão')#
INSERT INTO dominios.tipo_arruamento (code,code_name) values (4,'Logradouro')#
INSERT INTO dominios.tipo_lim_pol (code,code_name) values (1,'Internacional')#
INSERT INTO dominios.tipo_lim_pol (code,code_name) values (3,'Municipal')#
INSERT INTO dominios.tipo_lim_pol (code,code_name) values (2,'Estadual')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (5,'Eólica')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (7,'Maré-motriz')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (6,'Solar')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (9,'Termelétrica')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (8,'Hidrelétrica')#
INSERT INTO dominios.tipo_est_gerad (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.motivodescontinuidade (code,code_name) values (1,'Descontinuidade Temporal')#
INSERT INTO dominios.motivodescontinuidade (code,code_name) values (3,'Descontinuidade por escala de insumo')#
INSERT INTO dominios.motivodescontinuidade (code,code_name) values (2,'Descontinuidade devido a transformação')#
INSERT INTO dominios.motivodescontinuidade (code,code_name) values (5,'Descontinuidade por diferente interpretação das classes')#
INSERT INTO dominios.motivodescontinuidade (code,code_name) values (4,'Descontinuidade por falta de acurácia')#
INSERT INTO dominios.motivodescontinuidade (code,code_name) values (7,'Descontinuidade por excesso')#
INSERT INTO dominios.motivodescontinuidade (code,code_name) values (6,'Descontinuidade por omissão')#
INSERT INTO dominios.tipo_complexo_portuario (code,code_name) values (31,'Porto organizado')#
INSERT INTO dominios.tipo_complexo_portuario (code,code_name) values (30,'Instalação portuária')#
INSERT INTO dominios.tipo_complexo_portuario (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_juridica (code,code_name) values (1,'Delimitada')#
INSERT INTO dominios.situacao_juridica (code,code_name) values (3,'Homologada ou demarcada')#
INSERT INTO dominios.situacao_juridica (code,code_name) values (2,'Declarada')#
INSERT INTO dominios.situacao_juridica (code,code_name) values (4,'Regularizada')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (33,'Carvão')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (1,'Nuclear')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (3,'Diesel')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (5,'Gás')#
INSERT INTO dominios.tipo_combustivel (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_pto_controle (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_pto_controle (code,code_name) values (9,'Ponto de controle')#
INSERT INTO dominios.tipo_pto_controle (code,code_name) values (13,'Ponto fotogramétrico')#
INSERT INTO dominios.tipo_pto_controle (code,code_name) values (12,'Centro perspectivo')#
INSERT INTO dominios.situacao_em_agua (code,code_name) values (5,'Submerso')#
INSERT INTO dominios.situacao_em_agua (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_em_agua (code,code_name) values (4,'Emerso')#
INSERT INTO dominios.situacao_em_agua (code,code_name) values (7,'Cobre e descobre')#
INSERT INTO dominios.referencial_grav (code,code_name) values (1,'Potsdam1930')#
INSERT INTO dominios.referencial_grav (code,code_name) values (3,'Absoluto')#
INSERT INTO dominios.referencial_grav (code,code_name) values (2,'IGSN71')#
INSERT INTO dominios.referencial_grav (code,code_name) values (5,'RGFB')#
INSERT INTO dominios.referencial_grav (code,code_name) values (4,'Local')#
INSERT INTO dominios.referencial_grav (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.referencial_grav (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (10,'Represa/açude')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (3,'Oceano')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (5,'Enseada')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (4,'Baía')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (7,'Lago/Lagoa')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (6,'Meandro abandonado')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (8,'Trecho massa dágua')#
INSERT INTO dominios.tipo_massa_dagua (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_caminho_aereo (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_caminho_aereo (code,code_name) values (12,'Teleférico')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (11,'Delegacia de serviço militar')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (10,'Hotel de trânsito')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (13,'Posto de vigilância')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (12,'Quartel general')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (15,'Posto de policiamento rodoviário')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (14,'Posto de policiamento urbano')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (17,'Base naval')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (16,'Capitânia dos portos')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (5,'Aquartelamento')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (7,'Campo de tiro')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (6,'Campo de instruçao')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (9,'Distrito naval')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (8,'Base aérea')#
INSERT INTO dominios.tipo_instal_militar (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (99,'Outros tipos de entroncamento em nivel')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (1,'Cruzamento ou injunções simples')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (3,'Trevo')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (2,'Círculo')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (5,'Entroncamento ferroviário')#
INSERT INTO dominios.tipo_entroncamento (code,code_name) values (4,'Rótula')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (9,'Pinguela')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (8,'Passarela')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (7,'Passagem subterrânea')#
INSERT INTO dominios.tipo_travessia_ped (code,code_name) values (10,'Passarela em Área Úmida')#
INSERT INTO dominios.trafego (code,code_name) values (1,'Permanente')#
INSERT INTO dominios.trafego (code,code_name) values (2,'Periódico')#
INSERT INTO dominios.trafego (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.trafego (code,code_name) values (4,'Temporário')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (24,'Internacional secundário')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (25,'Internacional de referência')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (26,'Internacional principal')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (23,'Estadual')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_hierarquia (code,code_name) values (3,'Municipal')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (3,'Canalização de águas pluviais')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (2,'Canalização de efluentes industriais')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (5,'Abastecimento animal')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (4,'Irrigaçao')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (7,'Abastecimento industrial')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (6,'Abastecimento humano')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (9,'Canalização de efluentes domésticos')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (8,'Canalização de curso dágua')#
INSERT INTO dominios.finalidade_galeria_bueiro (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (1,'Bóia luminosa')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (3,'Bóia de amarração')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (2,'Bóia cega')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (5,'Barca farol')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (4,'Farol ou farolete')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (6,'Sinalização de margem')#
INSERT INTO dominios.tipo_sinal (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (1,'Indústrias extrativas')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (99,'Outros')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (3,'Construção')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (2,'Indústrias de transformação')#
INSERT INTO dominios.secao_ativ_econ (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.posicao_rel_edific (code,code_name) values (18,'Sobre edificação')#
INSERT INTO dominios.posicao_rel_edific (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.posicao_rel_edific (code,code_name) values (14,'Isolada')#
INSERT INTO dominios.posicao_rel_edific (code,code_name) values (17,'Adjacente à edificação')#
INSERT INTO dominios.situacao_terreno (code,code_name) values (3,'Estabilizada')#
INSERT INTO dominios.situacao_terreno (code,code_name) values (2,'Em progressão')#
INSERT INTO dominios.situacao_terreno (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.situacao_terreno (code,code_name) values (4,'Em regressão')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (11,'Centro de documentação')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (10,'Biblioteca')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (13,'Concha acústica')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (12,'Circo')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (15,'Coreto ou tribuna')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (14,'Conservatório')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (17,'Equipamentos culturais diversos')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (16,'Desconhecido')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (19,'Galeria')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (18,'Espaço de eventos e/ ou cultural')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (1,'Estádio')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (3,'Museu')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (2,'Ginásio')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (5,'Anfiteatro')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (4,'Teatro')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (7,'Centro cultural')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (6,'Espaço de exibição de filmes')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (9,'Arquivo')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (20,'Outros')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (8,'Plataforma de pesca')#
INSERT INTO dominios.tipo_edif_lazer (code,code_name) values (21,'Quiosque')#
INSERT INTO dominios.causa_exposicao (code,code_name) values (3,'Artificial')#
INSERT INTO dominios.causa_exposicao (code,code_name) values (2,'Natural')#
INSERT INTO dominios.causa_exposicao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.revestimento (code,code_name) values (1,'Sem revestimento (leito natural)')#
INSERT INTO dominios.revestimento (code,code_name) values (99,'Outros')#
INSERT INTO dominios.revestimento (code,code_name) values (3,'Pavimentado')#
INSERT INTO dominios.revestimento (code,code_name) values (2,'Revestimento primário (solto)')#
INSERT INTO dominios.revestimento (code,code_name) values (4,'Madeira')#
INSERT INTO dominios.revestimento (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.referencial_legal (code,code_name) values (10,'Trecho rodoviário')#
INSERT INTO dominios.referencial_legal (code,code_name) values (3,'Costa visível da carta')#
INSERT INTO dominios.referencial_legal (code,code_name) values (2,'Arruamento')#
INSERT INTO dominios.referencial_legal (code,code_name) values (5,'Limite de massa d´água')#
INSERT INTO dominios.referencial_legal (code,code_name) values (4,'Cumeada')#
INSERT INTO dominios.referencial_legal (code,code_name) values (7,'Massa d´água')#
INSERT INTO dominios.referencial_legal (code,code_name) values (6,'Linha seca')#
INSERT INTO dominios.referencial_legal (code,code_name) values (9,'Trecho ferroviário')#
INSERT INTO dominios.referencial_legal (code,code_name) values (8,'Trecho de drenagem')#
INSERT INTO dominios.referencial_legal (code,code_name) values (96,'Não identificado')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (1,'Duto')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (3,'Correia transportadora')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (2,'Calha')#
INSERT INTO dominios.tipo_trecho_duto (code,code_name) values (5,'Galeria ou bueiro')#
INSERT INTO dominios.tipo_complexo_aeroportuario (code,code_name) values (24,'Aeroporto')#
INSERT INTO dominios.tipo_complexo_aeroportuario (code,code_name) values (25,'Heliporto')#
INSERT INTO dominios.tipo_complexo_aeroportuario (code,code_name) values (23,'Aeródromo')#
INSERT INTO dominios.modalidade (code,code_name) values (99,'Outros')#
INSERT INTO dominios.modalidade (code,code_name) values (1,'Radiocomunicação')#
INSERT INTO dominios.modalidade (code,code_name) values (3,'Telefonia')#
INSERT INTO dominios.modalidade (code,code_name) values (2,'Imagem')#
INSERT INTO dominios.modalidade (code,code_name) values (5,'Som')#
INSERT INTO dominios.modalidade (code,code_name) values (4,'Dados')#
INSERT INTO dominios.modalidade (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (26,'Terminal de passageiros')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (27,'Terminal de cargas')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (15,'Administrativa')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (30,'Serviço de Combate à Incêndios (SCI)')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (28,'Torre de controle')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (29,'Hangar')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_aero (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.densidade (code,code_name) values (1,'Alta')#
INSERT INTO dominios.densidade (code,code_name) values (2,'Baixa')#
INSERT INTO dominios.densidade (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_transporte (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_transporte (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_transporte (code,code_name) values (21,'Passageiro')#
INSERT INTO dominios.tipo_transporte (code,code_name) values (22,'Carga')#
INSERT INTO dominios.tipo_lim_massa (code,code_name) values (1,'Costa visível da carta')#
INSERT INTO dominios.tipo_lim_massa (code,code_name) values (3,'Margem esquerda de trechos de massas dágua')#
INSERT INTO dominios.tipo_lim_massa (code,code_name) values (2,'Margem de massa dágua')#
INSERT INTO dominios.tipo_lim_massa (code,code_name) values (5,'Limite interno entre massas e/ou trechos')#
INSERT INTO dominios.tipo_lim_massa (code,code_name) values (4,'Margem direita de trechos de massas dágua')#
INSERT INTO dominios.tipo_lim_massa (code,code_name) values (7,'Limite interno com foz marítima')#
INSERT INTO dominios.tipo_lim_massa (code,code_name) values (6,'Limite com elemento artificial')#
INSERT INTO dominios.tipo_plataforma (code,code_name) values (5,'Gás')#
INSERT INTO dominios.tipo_plataforma (code,code_name) values (3,'Petróleo')#
INSERT INTO dominios.tipo_plataforma (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_plataforma (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_recife (code,code_name) values (1,'Arenito')#
INSERT INTO dominios.tipo_recife (code,code_name) values (20,'Coral')#
INSERT INTO dominios.tipo_recife (code,code_name) values (2,'Rochoso')#
INSERT INTO dominios.tipo_recife (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (3,'Sinal de TV')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (4,'Dados')#
INSERT INTO dominios.tipo_trecho_comunic (code,code_name) values (7,'Telefônica')#
INSERT INTO dominios.poder_publico (code,code_name) values (1,'Executivo')#
INSERT INTO dominios.poder_publico (code,code_name) values (3,'Judiciário')#
INSERT INTO dominios.poder_publico (code,code_name) values (2,'Legislativo')#
INSERT INTO dominios.poder_publico (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_queda (code,code_name) values (1,'Cachoeira')#
INSERT INTO dominios.tipo_queda (code,code_name) values (3,'Catarata')#
INSERT INTO dominios.tipo_queda (code,code_name) values (2,'Salto')#
INSERT INTO dominios.tipo_queda (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.finalidade (code,code_name) values (99,'Outros')#
INSERT INTO dominios.finalidade (code,code_name) values (1,'Comercial')#
INSERT INTO dominios.finalidade (code,code_name) values (3,'Residencial')#
INSERT INTO dominios.finalidade (code,code_name) values (2,'Serviço')#
INSERT INTO dominios.finalidade (code,code_name) values (4,'Uso restrito')#
INSERT INTO dominios.finalidade (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_ilha (code,code_name) values (1,'Fluvial')#
INSERT INTO dominios.tipo_ilha (code,code_name) values (98,'Mista')#
INSERT INTO dominios.tipo_ilha (code,code_name) values (3,'Lacustre')#
INSERT INTO dominios.tipo_ilha (code,code_name) values (2,'Marítima')#
INSERT INTO dominios.booleano_estendido (code,code_name) values (1,'Sim')#
INSERT INTO dominios.booleano_estendido (code,code_name) values (0,'Não')#
INSERT INTO dominios.booleano_estendido (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (1,'Área de proteção ambiental – APA')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (3,'Floresta – FLO')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (2,'Área de relevante interesse ecológico – ARIE')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (5,'Reserva extrativista')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (4,'Reserva de desenvolvimento sustentável – RDS')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (7,'Reserva particular do patrimônio natural - RPPN')#
INSERT INTO dominios.tipo_unid_uso_sust (code,code_name) values (6,'Reserva de fauna - REFAU')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (1,'Unidade de conservação não SNUC')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (3,'Unidade de uso sustentável')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (2,'Unidade de proteção integral')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (5,'Outras unidades protegidas')#
INSERT INTO dominios.tipo_unid_protegida (code,code_name) values (4,'Unidade de conservação')#
INSERT INTO dominios.condicao_terreno (code,code_name) values (3,'Irrigado')#
INSERT INTO dominios.condicao_terreno (code,code_name) values (2,'Seco')#
INSERT INTO dominios.condicao_terreno (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.condicao_terreno (code,code_name) values (4,'Inundado')#
INSERT INTO dominios.classificacao (code,code_name) values (3,'Internacional')#
INSERT INTO dominios.classificacao (code,code_name) values (2,'Doméstico')#
INSERT INTO dominios.classificacao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.especie_trecho_energia (code,code_name) values (3,'Transmissão')#
INSERT INTO dominios.especie_trecho_energia (code,code_name) values (2,'Distribuição')#
INSERT INTO dominios.especie_trecho_energia (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_tunel (code,code_name) values (1,'Túnel')#
INSERT INTO dominios.tipo_tunel (code,code_name) values (2,'Passagem subterrânea')#
INSERT INTO dominios.tipo_erosao (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_erosao (code,code_name) values (3,'Deslizamento')#
INSERT INTO dominios.tipo_erosao (code,code_name) values (2,'Voçoroca')#
INSERT INTO dominios.tipo_erosao (code,code_name) values (5,'Sulco')#
INSERT INTO dominios.tipo_erosao (code,code_name) values (4,'Ravina')#
INSERT INTO dominios.tipo_erosao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_elevador (code,code_name) values (3,'Vertical')#
INSERT INTO dominios.tipo_elevador (code,code_name) values (2,'Inclinado')#
INSERT INTO dominios.tipo_trecho_rod (code,code_name) values (2,'Rodovia')#
INSERT INTO dominios.tipo_trecho_rod (code,code_name) values (5,'Ligação entre pistas')#
INSERT INTO dominios.tipo_trecho_rod (code,code_name) values (4,'Auto-estrada')#
INSERT INTO dominios.tipo_trecho_rod (code,code_name) values (6,'Trecho de Entroncamento')#
INSERT INTO dominios.tipo_pista (code,code_name) values (11,'Heliponto')#
INSERT INTO dominios.tipo_pista (code,code_name) values (9,'Pista de Pouso')#
INSERT INTO dominios.tipo_pista (code,code_name) values (10,'Pista de taxiamento')#
INSERT INTO dominios.estado_fisico (code,code_name) values (1,'Líquido')#
INSERT INTO dominios.estado_fisico (code,code_name) values (98,'Misto')#
INSERT INTO dominios.estado_fisico (code,code_name) values (3,'Gasoso')#
INSERT INTO dominios.estado_fisico (code,code_name) values (2,'Sólido')#
INSERT INTO dominios.estado_fisico (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (39,'Cais flutuante')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (38,'Cais')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (44,'Desembarcadouro')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (42,'Píer')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (43,'Dolfim')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (40,'Trapiche')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (41,'Molhe de atracação')#
INSERT INTO dominios.tipo_atracad (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.forma_extracao (code,code_name) values (5,'A céu aberto')#
INSERT INTO dominios.forma_extracao (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.forma_extracao (code,code_name) values (6,'Subterrânea')#
INSERT INTO dominios.tipo_area_umida (code,code_name) values (3,'Lamacento')#
INSERT INTO dominios.tipo_area_umida (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_area_umida (code,code_name) values (4,'Arenoso')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (1,'Próprio nacional')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (2,'Uso da União')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (5,'Uso do município')#
INSERT INTO dominios.tipo_uso_edif (code,code_name) values (6,'Uso da UF')#
INSERT INTO dominios.mat_transp (code,code_name) values (99,'Outros')#
INSERT INTO dominios.mat_transp (code,code_name) values (31,'Querosene')#
INSERT INTO dominios.mat_transp (code,code_name) values (30,'Álcool')#
INSERT INTO dominios.mat_transp (code,code_name) values (29,'Gasolina')#
INSERT INTO dominios.mat_transp (code,code_name) values (1,'Água')#
INSERT INTO dominios.mat_transp (code,code_name) values (3,'Petróleo')#
INSERT INTO dominios.mat_transp (code,code_name) values (2,'Óleo')#
INSERT INTO dominios.mat_transp (code,code_name) values (5,'Gás')#
INSERT INTO dominios.mat_transp (code,code_name) values (4,'Nafta')#
INSERT INTO dominios.mat_transp (code,code_name) values (7,'Minério')#
INSERT INTO dominios.mat_transp (code,code_name) values (6,'Grãos')#
INSERT INTO dominios.mat_transp (code,code_name) values (9,'Esgoto')#
INSERT INTO dominios.mat_transp (code,code_name) values (8,'Efluentes')#
INSERT INTO dominios.mat_transp (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.situacao_costa (code,code_name) values (11,'Afastada')#
INSERT INTO dominios.situacao_costa (code,code_name) values (10,'Contígua')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (99,'Outros')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (3,'Estacionamento de veículos')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (2,'Deposito temporário de cargas e contêineres')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (5,'Estacionamento de aeronaves')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (4,'Estacionamento de locomotivas')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (7,'Manobra de veículos em geral')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (6,'Manobra de cargas')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (8,'Manutenção')#
INSERT INTO dominios.finalidade_patio (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (1,'Captação, tratamento e distribuição de água')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (98,'Misto')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (3,'Recalque')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (2,'Tratamento')#
INSERT INTO dominios.tipo_edif_abast (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.regime (code,code_name) values (1,'Permanente')#
INSERT INTO dominios.regime (code,code_name) values (3,'Temporário')#
INSERT INTO dominios.regime (code,code_name) values (2,'Permanente com grande variação')#
INSERT INTO dominios.regime (code,code_name) values (5,'Seco')#
INSERT INTO dominios.regime (code,code_name) values (4,'Temporário com leito permanente')#
INSERT INTO dominios.regime (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.atividade (code,code_name) values (9,'Prospecção')#
INSERT INTO dominios.atividade (code,code_name) values (10,'Produção')#
INSERT INTO dominios.atividade (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (24,'Venda de veículos')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (25,'Restaurante')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (20,'Pousada')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (21,'Quiosque')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (22,'Quitanda')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (23,'Supermercado')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (3,'Centro comercial')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (5,'Centro de convenções')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (4,'Mercado público')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (7,'Banco')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (6,'Banca de jornal')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (9,'Comércio de carnes')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (8,'Centro de exposições')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (99,'Outros serviços')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (11,'Hotel')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (10,'Farmácia')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (13,'Loja de materiais de construção e/ou ferragem')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (12,'Loja de conveniência')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (15,'Loja de roupas e/ou tecidos')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (14,'Loja de móveis')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (17,'Oficina mecânica')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (16,'Motel')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (19,'Posto de combustível')#
INSERT INTO dominios.tipo_edif_comerc_serv (code,code_name) values (18,'Outros comércios')#
INSERT INTO dominios.tipo_trecho_massa (code,code_name) values (9,'Laguna')#
INSERT INTO dominios.tipo_trecho_massa (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_trecho_massa (code,code_name) values (1,'Rio')#
INSERT INTO dominios.tipo_trecho_massa (code,code_name) values (10,'Represa/açude')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (1,'Estação ecológica - ESEC')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (3,'Monumento natural – MONA')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (2,'Parque – PAR')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (5,'Refúgio da vida silvestre – RVS')#
INSERT INTO dominios.tipo_unid_prot_integ (code,code_name) values (4,'Reserva biológica – REBIO')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (8,'Armazenamento')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (3,'Recalque')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (2,'Tratamento')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.finalidade_deposito (code,code_name) values (4,'Distribuição')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (26,'Terminal de passageiros')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (27,'Terminal de cargas')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (15,'Administrativa')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (33,'Estaleiro')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (32,'Armazém')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (37,'Terminal de uso privativo')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (36,'Carreira')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (35,'Rampa transportadora')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (34,'Dique de estaleiro')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_port (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (1,'Móvel')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (3,'Fixa')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (2,'Pênsil')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_ponte (code,code_name) values (7,'Estaiada')#
INSERT INTO dominios.tipo_quebra_molhe (code,code_name) values (1,'Quebramar')#
INSERT INTO dominios.tipo_quebra_molhe (code,code_name) values (2,'Molhe')#
INSERT INTO dominios.tipo_quebra_molhe (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_quebra_molhe (code,code_name) values (4,'Espigão')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (24,'Educação profissional de nível técnico')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (25,'Educação profissional de nível tecnológico')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (26,'Outras atividades de ensino')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (27,'Atendimento hospitalar (hospital)')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (20,'Ensino médio')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (21,'Educação superior-graduação')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (22,'Educação superior-graduação e pós-graduação')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (23,'Educação superior-pós-graduação e extensão')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (28,'Atendimento às urgências e emergências (pronto-socorro)')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (29,'Atenção ambulatorial (posto e centro de saúde)')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (3,'Transmissão de energia elétrica')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (2,'Produção de energia elétrica')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (5,'Captação, tratamento e distribuição de água')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (4,'Distribuição de energia elétrica')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (7,'Administração pública em geral')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (6,'Telecomunicações')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (9,'Regulação das atividades econômicas')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (8,'Seguridade social')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (99,'Outros')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (98,'Misto')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (95,'Desconhecida')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (11,'Relações exteriores')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (10,'Atividades de apoio à administração pública')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (13,'Justiça')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (12,'Defesa')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (15,'Defesa civil')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (14,'Segurança e ordem pública')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (17,'Educação infantil - creche')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (16,'Regulação das atividades sociais e culturais')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (19,'Ensino fundamental')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (18,'Educação infantil-pré-escola')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (31,'Atividades de organizações religiosas')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (30,'Serviços de complementação diagnóstica ou terapêutica')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (36,'Serviços veterinários')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (35,'Limpeza urbana e atividades relacionadas')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (34,'Serviços sociais sem alojamento')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (33,'Serviços sociais com alojamento')#
INSERT INTO dominios.classe_ativ_econ (code,code_name) values (32,'Outras atividades relacionadas com atenção à saúde (instituto de pesquisa)')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (10,'Parada interestadual')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (13,'Posto de pedágio')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (15,'Administrativa')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (8,'Terminal interestadual')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (9,'Terminal urbano')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (20,'Garagem')#
INSERT INTO dominios.tipo_edif_rod (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.aptidao_operacional_atracadouro (code,code_name) values (3,'Transporte oceânico')#
INSERT INTO dominios.aptidao_operacional_atracadouro (code,code_name) values (2,'Transporte de cabotagem')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (11,'Maregráfica - MA')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (10,'Fluviométrica - FL')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (13,'Metero-maregráfica')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (12,'Marés terrestres-crosta')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (1,'Climatológica principal - CP')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (3,'Agroclimatológica - AC')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (2,'Climatológica auxiliar- CA')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (5,'Eólica - EO')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (4,'Pluviométrica - PL')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (7,'Solarimétrica - SL')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (6,'Evaporimétrica - EV')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (9,'Radiossonda - RS')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (8,'Radar metereológico - RD')#
INSERT INTO dominios.tipo_pto_est_med (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_associado (code,code_name) values (1,'Cidade')#
INSERT INTO dominios.tipo_associado (code,code_name) values (4,'Vila')#
INSERT INTO dominios.tipo_fonte_dagua (code,code_name) values (1,'Poço')#
INSERT INTO dominios.tipo_fonte_dagua (code,code_name) values (3,'Olho dágua')#
INSERT INTO dominios.tipo_fonte_dagua (code,code_name) values (2,'Poço artesiano')#
INSERT INTO dominios.tipo_fonte_dagua (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.uso_principal (code,code_name) values (1,'Irrigação')#
INSERT INTO dominios.uso_principal (code,code_name) values (99,'Outros')#
INSERT INTO dominios.uso_principal (code,code_name) values (3,'Energia')#
INSERT INTO dominios.uso_principal (code,code_name) values (2,'Abastecimento')#
INSERT INTO dominios.uso_principal (code,code_name) values (5,'Dessedentação animal')#
INSERT INTO dominios.uso_principal (code,code_name) values (4,'Lazer')#
INSERT INTO dominios.uso_principal (code,code_name) values (6,'Drenagem')#
INSERT INTO dominios.uso_principal (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.uso_principal (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (3,'Recalque')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (5,'Tratamento de esgoto')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (7,'Incinerador')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (6,'Usina de reciclagem')#
INSERT INTO dominios.tipo_edif_saneam (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (11,'Delegacia de policia civil')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (10,'Autarquia')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (13,'Fórum')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (12,'Educação')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (15,'Procuradoria')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (14,'Fundação')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (22,'Prefeitura')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (16,'Secretaria')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (99,'Outros')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (3,'Cartorial')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (2,'Prisional')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (5,'Eleitoral')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (4,'Gestão')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (7,'Seguridade social')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (6,'Produção e/ou pesquisa')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (9,'Assembleia legislativa')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (8,'Câmara municipal')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (1,'Policial')#
INSERT INTO dominios.tipo_org_civil (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (11,'Caatinga')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (10,'Vegetação de brejo ou pântano')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (3,'Floresta')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (2,'Vegetação cultivada')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (5,'Refúgio ecológico')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (4,'Vegetação de mangue')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (7,'Cerrado')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (6,'Campinarana')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (9,'Estepe')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (8,'Vegetação de restinga')#
INSERT INTO dominios.tipo_vegetacao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_conteudo (code,code_name) values (1,'Insumo')#
INSERT INTO dominios.tipo_conteudo (code,code_name) values (3,'Resíduo')#
INSERT INTO dominios.tipo_conteudo (code,code_name) values (2,'Produto')#
INSERT INTO dominios.tipo_conteudo (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (24,'Saibro')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (12,'Areia')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (23,'Terra')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (18,'Cascalho')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (4,'Pedregoso')#
INSERT INTO dominios.tipo_terreno_exposto (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.proc_extracao (code,code_name) values (1,'Mecanizado')#
INSERT INTO dominios.proc_extracao (code,code_name) values (2,'Manual')#
INSERT INTO dominios.proc_extracao (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (5,'Trecho para bonde')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (6,'Trecho para aeromóvel')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (7,'Trecho para trem')#
INSERT INTO dominios.tipo_trecho_ferrov (code,code_name) values (8,'Trecho para metrô')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (99,'Outras')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (5,'Cristã')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (7,'Muçulmana')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (97,'Não aplicável')#
INSERT INTO dominios.denominacao_associada (code,code_name) values (6,'Israelita')#
INSERT INTO dominios.setor (code,code_name) values (1,'Energético')#
INSERT INTO dominios.setor (code,code_name) values (3,'Abastecimento de água')#
INSERT INTO dominios.setor (code,code_name) values (2,'Econômico')#
INSERT INTO dominios.setor (code,code_name) values (95,'Desconhecido')#
INSERT INTO dominios.setor (code,code_name) values (4,'Saneamento básico')#
INSERT INTO dominios.tipo_capital (code,code_name) values (3,'Capital estadual')#
INSERT INTO dominios.tipo_capital (code,code_name) values (2,'Capital federal')#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_chamine_fk FOREIGN KEY (chamine) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_desenv_social_a ADD CONSTRAINT cb_area_desenv_social_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_chamine_fk FOREIGN KEY (chamine) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_tipoinstalmilitar_fk FOREIGN KEY (tipoinstalmilitar) REFERENCES dominios.tipo_instal_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_de_propriedade_particular_a ADD CONSTRAINT cb_area_de_propriedade_particular_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_tipoedifturist_fk FOREIGN KEY (tipoedifturist) REFERENCES dominios.tipo_edif_turist(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_tombada_fk FOREIGN KEY (tombada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_ovgd_fk FOREIGN KEY (ovgd) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_ext_mineral_a ADD CONSTRAINT cb_area_ext_mineral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_ensino_a ADD CONSTRAINT cb_area_ensino_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_nivelatencao_fk FOREIGN KEY (nivelatencao) REFERENCES dominios.nivel_atencao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_est_med_fenomenos_a ADD CONSTRAINT cb_area_est_med_fenomenos_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_energia_eletrica_a ADD CONSTRAINT cb_area_energia_eletrica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_nivelatencao_fk FOREIGN KEY (nivelatencao) REFERENCES dominios.nivel_atencao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_tipoediflazer_fk FOREIGN KEY (tipoediflazer) REFERENCES dominios.tipo_edif_lazer(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_tipopistacomp_fk FOREIGN KEY (tipopistacomp) REFERENCES dominios.tipo_pista_comp(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_tipoedifport_fk FOREIGN KEY (tipoedifport) REFERENCES dominios.tipo_edif_port(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_tipopistacomp_fk FOREIGN KEY (tipopistacomp) REFERENCES dominios.tipo_pista_comp(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_sargeta_fk FOREIGN KEY (sargeta) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_meiofio_fk FOREIGN KEY (meiofio) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_tipoarruamento_fk FOREIGN KEY (tipoarruamento) REFERENCES dominios.tipo_arruamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_tipopistacomp_fk FOREIGN KEY (tipopistacomp) REFERENCES dominios.tipo_pista_comp(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_sargeta_fk FOREIGN KEY (sargeta) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_meiofio_fk FOREIGN KEY (meiofio) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_tipoarruamento_fk FOREIGN KEY (tipoarruamento) REFERENCES dominios.tipo_arruamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina_p ADD CONSTRAINT laz_ruina_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina_p ADD CONSTRAINT laz_ruina_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina_p ADD CONSTRAINT laz_ruina_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_tipopostofisc_fk FOREIGN KEY (tipopostofisc) REFERENCES dominios.tipo_posto_fisc(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_sitio_arqueologico ADD CONSTRAINT laz_sitio_arqueologico_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_sitio_arqueologico ADD CONSTRAINT laz_sitio_arqueologico_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passeio ADD CONSTRAINT cb_passeio_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passeio ADD CONSTRAINT cb_passeio_calcada_fk FOREIGN KEY (calcada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina_a ADD CONSTRAINT laz_ruina_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina_a ADD CONSTRAINT laz_ruina_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina_a ADD CONSTRAINT laz_ruina_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_tipopostofisc_fk FOREIGN KEY (tipopostofisc) REFERENCES dominios.tipo_posto_fisc(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_praca_a ADD CONSTRAINT cb_praca_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_praca_a ADD CONSTRAINT cb_praca_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_urbana_isolada_a ADD CONSTRAINT cb_area_urbana_isolada_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_urbana_isolada_a ADD CONSTRAINT cb_area_urbana_isolada_a_tipoassociado_fk FOREIGN KEY (tipoassociado) REFERENCES dominios.tipo_associado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_ensino_fk FOREIGN KEY (ensino) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_crista_fk FOREIGN KEY (crista) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_tipoedifrelig_fk FOREIGN KEY (tipoedifrelig) REFERENCES dominios.tipo_edif_relig(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_retorno_p ADD CONSTRAINT cb_retorno_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_retorno_l ADD CONSTRAINT cb_retorno_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_ensino_fk FOREIGN KEY (ensino) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_crista_fk FOREIGN KEY (crista) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_tipoedifrelig_fk FOREIGN KEY (tipoedifrelig) REFERENCES dominios.tipo_edif_relig(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra ADD CONSTRAINT laz_campo_quadra_tipocampoquadra_fk FOREIGN KEY (tipocampoquadra) REFERENCES dominios.tipo_campo_quadra(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra ADD CONSTRAINT laz_campo_quadra_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra ADD CONSTRAINT laz_campo_quadra_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra ADD CONSTRAINT laz_campo_quadra_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_retorno_a ADD CONSTRAINT cb_retorno_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_largo_a ADD CONSTRAINT cb_largo_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_industrial_a ADD CONSTRAINT cb_area_industrial_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao ADD CONSTRAINT laz_pista_competicao_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao ADD CONSTRAINT laz_pista_competicao_tipopistacomp_fk FOREIGN KEY (tipopistacomp) REFERENCES dominios.tipo_pista_comp(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao ADD CONSTRAINT laz_pista_competicao_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_pista_competicao ADD CONSTRAINT laz_pista_competicao_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_tipoedifabast_fk FOREIGN KEY (tipoedifabast) REFERENCES dominios.tipo_edif_abast(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada ADD CONSTRAINT laz_arquibancada_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada ADD CONSTRAINT laz_arquibancada_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_arquibancada ADD CONSTRAINT laz_arquibancada_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_ruinas_a ADD CONSTRAINT cb_area_ruinas_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_tipotunel_fk FOREIGN KEY (tipotunel) REFERENCES dominios.tipo_tunel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_poste_sinalizacao_p ADD CONSTRAINT emu_poste_sinalizacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_poste_sinalizacao_p ADD CONSTRAINT emu_poste_sinalizacao_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_lazer_a ADD CONSTRAINT cb_area_lazer_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_tipoediflazer_fk FOREIGN KEY (tipoediflazer) REFERENCES dominios.tipo_edif_lazer(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_duto_a ADD CONSTRAINT cb_area_duto_a_areavalvulas_fk FOREIGN KEY (areavalvulas) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_duto_a ADD CONSTRAINT cb_area_duto_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_duto_a ADD CONSTRAINT cb_area_duto_a_bombeamento_fk FOREIGN KEY (bombeamento) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_terreno_fk FOREIGN KEY (terreno) REFERENCES dominios.condicao_terreno(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_tipolavoura_fk FOREIGN KEY (tipolavoura) REFERENCES dominios.tipo_lavoura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_canteiro_central_l ADD CONSTRAINT cb_canteiro_central_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_canteiro_central_l ADD CONSTRAINT cb_canteiro_central_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_canteiro_central_a ADD CONSTRAINT cb_canteiro_central_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_canteiro_central_a ADD CONSTRAINT cb_canteiro_central_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_tipoedifabast_fk FOREIGN KEY (tipoedifabast) REFERENCES dominios.tipo_edif_abast(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_tipoedifsaneam_fk FOREIGN KEY (tipoedifsaneam) REFERENCES dominios.tipo_edif_saneam(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_tipocampoquadra_fk FOREIGN KEY (tipocampoquadra) REFERENCES dominios.tipo_campo_quadra(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_retorno ADD CONSTRAINT cb_retorno_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_sitio_arqueologico_p ADD CONSTRAINT laz_sitio_arqueologico_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_sitio_arqueologico_p ADD CONSTRAINT laz_sitio_arqueologico_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_tipoedifsaneam_fk FOREIGN KEY (tipoedifsaneam) REFERENCES dominios.tipo_edif_saneam(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_tipocampoquadra_fk FOREIGN KEY (tipocampoquadra) REFERENCES dominios.tipo_campo_quadra(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_tipoponte_fk FOREIGN KEY (tipoponte) REFERENCES dominios.tipo_ponte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_abast_agua_a ADD CONSTRAINT cb_area_abast_agua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_habitacional_a ADD CONSTRAINT cb_area_habitacional_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_comerc_serv_a ADD CONSTRAINT cb_area_comerc_serv_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_poste_p ADD CONSTRAINT cb_poste_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_poste_p ADD CONSTRAINT cb_poste_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passeio_l ADD CONSTRAINT cb_passeio_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passeio_l ADD CONSTRAINT cb_passeio_l_calcada_fk FOREIGN KEY (calcada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passeio_a ADD CONSTRAINT cb_passeio_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passeio_a ADD CONSTRAINT cb_passeio_a_calcada_fk FOREIGN KEY (calcada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_tiporepdiplomatica_fk FOREIGN KEY (tiporepdiplomatica) REFERENCES dominios.tipo_rep_diplomatica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_quadra_a ADD CONSTRAINT cb_quadra_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_tiporepdiplomatica_fk FOREIGN KEY (tiporepdiplomatica) REFERENCES dominios.tipo_rep_diplomatica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_tipoedifturist_fk FOREIGN KEY (tipoedifturist) REFERENCES dominios.tipo_edif_turist(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_tombada_fk FOREIGN KEY (tombada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_ovgd_fk FOREIGN KEY (ovgd) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_canteiro_central ADD CONSTRAINT cb_canteiro_central_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_canteiro_central ADD CONSTRAINT cb_canteiro_central_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_delimitacao_fisica_l ADD CONSTRAINT cb_delimitacao_fisica_l_eletrificada_fk FOREIGN KEY (eletrificada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_delimitacao_fisica_l ADD CONSTRAINT cb_delimitacao_fisica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_delimitacao_fisica_l ADD CONSTRAINT cb_delimitacao_fisica_l_tipodelimfis_fk FOREIGN KEY (tipodelimfis) REFERENCES dominios.tipo_delim_fis(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_estrut_transporte_a ADD CONSTRAINT cb_area_estrut_transporte_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_tipoelevador_fk FOREIGN KEY (tipoelevador) REFERENCES dominios.tipo_elevador(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_entroncamento_area_a ADD CONSTRAINT cb_entroncamento_area_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_entroncamento_area_a ADD CONSTRAINT cb_entroncamento_area_a_tipoentroncamento_fk FOREIGN KEY (tipoentroncamento) REFERENCES dominios.tipo_entroncamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_tipoelevador_fk FOREIGN KEY (tipoelevador) REFERENCES dominios.tipo_elevador(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_sitio_arqueologico_a ADD CONSTRAINT laz_sitio_arqueologico_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_sitio_arqueologico_a ADD CONSTRAINT laz_sitio_arqueologico_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.ver_arvore_isolada_p ADD CONSTRAINT ver_arvore_isolada_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_tipoelevador_fk FOREIGN KEY (tipoelevador) REFERENCES dominios.tipo_elevador(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_tipopassagviad_fk FOREIGN KEY (tipopassagviad) REFERENCES dominios.tipo_passag_viad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_religiosa_a ADD CONSTRAINT cb_area_religiosa_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_comunicacao_a ADD CONSTRAINT cb_area_comunicacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_sargeta_fk FOREIGN KEY (sargeta) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_meiofio_fk FOREIGN KEY (meiofio) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_tipoarruamento_fk FOREIGN KEY (tipoarruamento) REFERENCES dominios.tipo_arruamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_piscina_a ADD CONSTRAINT laz_piscina_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_piscina_a ADD CONSTRAINT laz_piscina_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_piscina_a ADD CONSTRAINT laz_piscina_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina ADD CONSTRAINT laz_ruina_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina ADD CONSTRAINT laz_ruina_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.laz_ruina ADD CONSTRAINT laz_ruina_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_tipoinstalmilitar_fk FOREIGN KEY (tipoinstalmilitar) REFERENCES dominios.tipo_instal_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_coletiva_fk FOREIGN KEY (coletiva) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_isolada_fk FOREIGN KEY (isolada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_trechoemperimetrourbano_fk FOREIGN KEY (trechoemperimetrourbano) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_acostamento_fk FOREIGN KEY (acostamento) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_tipotrechorod_fk FOREIGN KEY (tipotrechorod) REFERENCES dominios.tipo_trecho_rod(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_saneamento_a ADD CONSTRAINT cb_area_saneamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_coletiva_fk FOREIGN KEY (coletiva) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_isolada_fk FOREIGN KEY (isolada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_tipotravessiaped_fk FOREIGN KEY (tipotravessiaped) REFERENCES dominios.tipo_travessia_ped(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_agropec_ext_veg_pesca_a ADD CONSTRAINT cb_area_agropec_ext_veg_pesca_a_destinadoa_fk FOREIGN KEY (destinadoa) REFERENCES dominios.destinadoa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_agropec_ext_veg_pesca_a ADD CONSTRAINT cb_area_agropec_ext_veg_pesca_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_tipoinstalmilitar_fk FOREIGN KEY (tipoinstalmilitar) REFERENCES dominios.tipo_instal_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_tipoinstalmilitar_fk FOREIGN KEY (tipoinstalmilitar) REFERENCES dominios.tipo_instal_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_tipousoedif_fk FOREIGN KEY (tipousoedif) REFERENCES dominios.tipo_uso_edif(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_publico_fk FOREIGN KEY (publico) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_espelho_dagua_a ADD CONSTRAINT cb_espelho_dagua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_turistica_fk FOREIGN KEY (turistica) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_proprioadm_fk FOREIGN KEY (proprioadm) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.cb_area_saude_a ADD CONSTRAINT cb_area_saude_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude ADD CONSTRAINT sau_org_saude_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude ADD CONSTRAINT sau_org_saude_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude ADD CONSTRAINT sau_org_saude_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.eco_frigorifico_matadouro ADD CONSTRAINT eco_frigorifico_matadouro_frigorifico_fk FOREIGN KEY (frigorifico) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.eco_frigorifico_matadouro ADD CONSTRAINT eco_frigorifico_matadouro_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.ver_area_verde ADD CONSTRAINT ver_area_verde_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.ver_area_verde ADD CONSTRAINT ver_area_verde_paisagismo_fk FOREIGN KEY (paisagismo) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_religiosa ADD CONSTRAINT edu_org_ensino_religiosa_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_religiosa ADD CONSTRAINT edu_org_ensino_religiosa_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_religiosa ADD CONSTRAINT edu_org_ensino_religiosa_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_localidade ADD CONSTRAINT lpal_localidade_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_comerc_serv ADD CONSTRAINT adm_org_comerc_serv_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_comerc_serv ADD CONSTRAINT adm_org_comerc_serv_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_aglomerado_rural_isolado ADD CONSTRAINT lpal_aglomerado_rural_isolado_tipoaglomrurisol_fk FOREIGN KEY (tipoaglomrurisol) REFERENCES dominios.tipo_aglom_rur_isol(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_aglomerado_rural_isolado ADD CONSTRAINT lpal_aglomerado_rural_isolado_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.cb_assentamento_precario ADD CONSTRAINT cb_assentamento_precario_tipoassprec_fk FOREIGN KEY (tipoassprec) REFERENCES dominios.tipo_assentamento_precario(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_capital ADD CONSTRAINT lpal_capital_tipocapital_fk FOREIGN KEY (tipocapital) REFERENCES dominios.tipo_capital(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_capital ADD CONSTRAINT lpal_capital_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_complexo_comunicacao ADD CONSTRAINT enc_complexo_comunicacao_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_administracaodireta_fk FOREIGN KEY (administracaodireta) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_poderpublico_fk FOREIGN KEY (poderpublico) REFERENCES dominios.poder_publico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_tipoorgcivil_fk FOREIGN KEY (tipoorgcivil) REFERENCES dominios.tipo_org_civil(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_militar ADD CONSTRAINT sau_org_saude_militar_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_militar ADD CONSTRAINT sau_org_saude_militar_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_militar ADD CONSTRAINT sau_org_saude_militar_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_pub_militar ADD CONSTRAINT adm_org_pub_militar_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_pub_militar ADD CONSTRAINT adm_org_pub_militar_tipoorgmilitar_fk FOREIGN KEY (tipoorgmilitar) REFERENCES dominios.tipo_org_militar(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_pub_militar ADD CONSTRAINT adm_org_pub_militar_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_agropec_ext_veg_pesca ADD CONSTRAINT adm_org_agropec_ext_veg_pesca_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_religiosa ADD CONSTRAINT adm_org_religiosa_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_religiosa ADD CONSTRAINT adm_org_religiosa_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_especialidade_medica ADD CONSTRAINT sau_especialidade_medica_nomeespecialidade_fk FOREIGN KEY (nomeespecialidade) REFERENCES dominios.nome_especialidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_servico_social_pub ADD CONSTRAINT sau_org_servico_social_pub_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_servico_social_pub ADD CONSTRAINT sau_org_servico_social_pub_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_servico_social_pub ADD CONSTRAINT sau_org_servico_social_pub_tipoorgsvsocial_fk FOREIGN KEY (tipoorgsvsocial) REFERENCES dominios.tipo_org_sv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_servico_social_pub ADD CONSTRAINT sau_org_servico_social_pub_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_aglom_rural_de_ext_urbana ADD CONSTRAINT lpal_aglom_rural_de_ext_urbana_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hid_arquipelago ADD CONSTRAINT hid_arquipelago_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.rdr_curso_dagua ADD CONSTRAINT rdr_curso_dagua_dominialidade_fk FOREIGN KEY (dominialidade) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_vila ADD CONSTRAINT lpal_vila_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sb_complexo_abast_agua ADD CONSTRAINT sb_complexo_abast_agua_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sb_complexo_abast_agua ADD CONSTRAINT sb_complexo_abast_agua_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sb_complexo_abast_agua ADD CONSTRAINT sb_complexo_abast_agua_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_privada ADD CONSTRAINT edu_org_ensino_privada_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_privada ADD CONSTRAINT edu_org_ensino_privada_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_privada ADD CONSTRAINT edu_org_ensino_privada_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_tipocomplexoportuario_fk FOREIGN KEY (tipocomplexoportuario) REFERENCES dominios.tipo_complexo_portuario(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_tipotransporte_fk FOREIGN KEY (tipotransporte) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_portosempapel_fk FOREIGN KEY (portosempapel) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_instituicao_publica ADD CONSTRAINT adm_instituicao_publica_poderpublico_fk FOREIGN KEY (poderpublico) REFERENCES dominios.poder_publico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_instituicao_publica ADD CONSTRAINT adm_instituicao_publica_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_instituicao_publica ADD CONSTRAINT adm_instituicao_publica_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_complexo_gerador_energia_eletrica ADD CONSTRAINT enc_complexo_gerador_energia_eletrica_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_complexo_gerador_energia_eletrica ADD CONSTRAINT enc_complexo_gerador_energia_eletrica_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_entroncamento ADD CONSTRAINT tra_entroncamento_tipoentroncamento_fk FOREIGN KEY (tipoentroncamento) REFERENCES dominios.tipo_entroncamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.eco_madeireira ADD CONSTRAINT eco_madeireira_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_privada ADD CONSTRAINT sau_org_saude_privada_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_privada ADD CONSTRAINT sau_org_saude_privada_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_privada ADD CONSTRAINT sau_org_saude_privada_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_industrial ADD CONSTRAINT adm_org_industrial_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_aglomerado_rural ADD CONSTRAINT lpal_aglomerado_rural_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sb_complexo_saneamento ADD CONSTRAINT sb_complexo_saneamento_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sb_complexo_saneamento ADD CONSTRAINT sb_complexo_saneamento_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sb_complexo_saneamento ADD CONSTRAINT sb_complexo_saneamento_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_pub ADD CONSTRAINT edu_org_ensino_pub_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_pub ADD CONSTRAINT edu_org_ensino_pub_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_pub ADD CONSTRAINT edu_org_ensino_pub_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_pub ADD CONSTRAINT sau_org_saude_pub_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_pub ADD CONSTRAINT sau_org_saude_pub_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_saude_pub ADD CONSTRAINT sau_org_saude_pub_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_militar ADD CONSTRAINT edu_org_ensino_militar_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_militar ADD CONSTRAINT edu_org_ensino_militar_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino_militar ADD CONSTRAINT edu_org_ensino_militar_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.lpal_cidade ADD CONSTRAINT lpal_cidade_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_divisaoativecon_fk FOREIGN KEY (divisaoativecon) REFERENCES dominios.divisao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_cultura_fk FOREIGN KEY (cultura) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_turistico_fk FOREIGN KEY (turistico) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino ADD CONSTRAINT edu_org_ensino_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino ADD CONSTRAINT edu_org_ensino_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.edu_org_ensino ADD CONSTRAINT edu_org_ensino_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_servico_social ADD CONSTRAINT sau_org_servico_social_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_servico_social ADD CONSTRAINT sau_org_servico_social_grupoativecon_fk FOREIGN KEY (grupoativecon) REFERENCES dominios.grupo_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_servico_social ADD CONSTRAINT sau_org_servico_social_tipoorgsvsocial_fk FOREIGN KEY (tipoorgsvsocial) REFERENCES dominios.tipo_org_sv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.sau_org_servico_social ADD CONSTRAINT sau_org_servico_social_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_tipocomplexoaero_fk FOREIGN KEY (tipocomplexoaero) REFERENCES dominios.tipo_complexo_aeroportuario(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_classificacao_fk FOREIGN KEY (classificacao) REFERENCES dominios.classificacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_subest_transm_distrib_energia_eletrica ADD CONSTRAINT enc_subest_transm_distrib_energia_eletrica_classeativecon_fk FOREIGN KEY (classeativecon) REFERENCES dominios.classe_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.enc_subest_transm_distrib_energia_eletrica ADD CONSTRAINT enc_subest_transm_distrib_energia_eletrica_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_tipoestrut_fk FOREIGN KEY (tipoestrut) REFERENCES dominios.tipo_estrut(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE complexos.adm_org_ext_mineral ADD CONSTRAINT adm_org_ext_mineral_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica ADD CONSTRAINT aux_descontinuidade_geometrica_categoria_fk FOREIGN KEY (categoria) REFERENCES dominios.categoria_edgv(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica ADD CONSTRAINT aux_descontinuidade_geometrica_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica ADD CONSTRAINT aux_descontinuidade_geometrica_motivodescontinuidade_fk FOREIGN KEY (motivodescontinuidade) REFERENCES dominios.motivodescontinuidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_l ADD CONSTRAINT aux_descontinuidade_geometrica_l_categoria_fk FOREIGN KEY (categoria) REFERENCES dominios.categoria_edgv(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_l ADD CONSTRAINT aux_descontinuidade_geometrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_l ADD CONSTRAINT aux_descontinuidade_geometrica_l_motivodescontinuidade_fk FOREIGN KEY (motivodescontinuidade) REFERENCES dominios.motivodescontinuidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_p ADD CONSTRAINT aux_descontinuidade_geometrica_p_categoria_fk FOREIGN KEY (categoria) REFERENCES dominios.categoria_edgv(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_p ADD CONSTRAINT aux_descontinuidade_geometrica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE public.aux_descontinuidade_geometrica_p ADD CONSTRAINT aux_descontinuidade_geometrica_p_motivodescontinuidade_fk FOREIGN KEY (motivodescontinuidade) REFERENCES dominios.motivodescontinuidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_ramificacao_p ADD CONSTRAINT dut_ramificacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_ramificacao_p ADD CONSTRAINT dut_ramificacao_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protegida_a ADD CONSTRAINT lpal_unidade_protegida_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protegida_a ADD CONSTRAINT lpal_unidade_protegida_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protegida_a ADD CONSTRAINT lpal_unidade_protegida_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protegida_a ADD CONSTRAINT lpal_unidade_protegida_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_galeria_bueiro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_setor_fk FOREIGN KEY (setor) REFERENCES dominios.setor(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_tipotrechoduto_fk FOREIGN KEY (tipotrechoduto) REFERENCES dominios.tipo_trecho_duto(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_pico_p ADD CONSTRAINT rel_pico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_pico_p ADD CONSTRAINT rel_pico_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_municipio_a ADD CONSTRAINT lpal_municipio_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_sistemageodesico_fk FOREIGN KEY (sistemageodesico) REFERENCES dominios.sistema_geodesico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_tipoptocontrole_fk FOREIGN KEY (tipoptocontrole) REFERENCES dominios.tipo_pto_controle(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_tiporef_fk FOREIGN KEY (tiporef) REFERENCES dominios.tipo_ref(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_referencialaltim_fk FOREIGN KEY (referencialaltim) REFERENCES dominios.referencial_altim(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_materializado_fk FOREIGN KEY (materializado) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiog_natural_l ADD CONSTRAINT rel_elemento_fisiog_natural_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiog_natural_l ADD CONSTRAINT rel_elemento_fisiog_natural_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_posic_geo_localidade_p ADD CONSTRAINT lpal_posic_geo_localidade_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_posic_geo_localidade_p ADD CONSTRAINT lpal_posic_geo_localidade_p_tipolocalidade_fk FOREIGN KEY (tipolocalidade) REFERENCES dominios.tipo_localidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_trechoemperimetrourbano_fk FOREIGN KEY (trechoemperimetrourbano) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_acostamento_fk FOREIGN KEY (acostamento) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_tipotrechorod_fk FOREIGN KEY (tipotrechorod) REFERENCES dominios.tipo_trecho_rod(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiog_natural_a ADD CONSTRAINT rel_elemento_fisiog_natural_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiog_natural_a ADD CONSTRAINT rel_elemento_fisiog_natural_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_terreno_suj_inundacao_a ADD CONSTRAINT hid_terreno_suj_inundacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_linha_de_limite_l ADD CONSTRAINT lpal_linha_de_limite_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_linha_de_limite_l ADD CONSTRAINT lpal_linha_de_limite_l_referenciallegal_fk FOREIGN KEY (referenciallegal) REFERENCES dominios.referencial_legal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ponto_inicio_drenagem_p ADD CONSTRAINT hid_ponto_inicio_drenagem_p_nascente_fk FOREIGN KEY (nascente) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ponto_inicio_drenagem_p ADD CONSTRAINT hid_ponto_inicio_drenagem_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ponto_inicio_drenagem_p ADD CONSTRAINT hid_ponto_inicio_drenagem_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_tipousocaminhoaer_fk FOREIGN KEY (tipousocaminhoaer) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_tipocaminhoaereo_fk FOREIGN KEY (tipocaminhoaereo) REFERENCES dominios.tipo_caminho_aereo(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiog_natural_p ADD CONSTRAINT rel_elemento_fisiog_natural_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiog_natural_p ADD CONSTRAINT rel_elemento_fisiog_natural_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_ovgd_fk FOREIGN KEY (ovgd) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_posicaoreledific_fk FOREIGN KEY (posicaoreledific) REFERENCES dominios.posicao_rel_edific(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_causaexposicao_fk FOREIGN KEY (causaexposicao) REFERENCES dominios.causa_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_tipoterrexp_fk FOREIGN KEY (tipoterrexp) REFERENCES dominios.tipo_terreno_exposto(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_a ADD CONSTRAINT rel_terreno_erodido_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_a ADD CONSTRAINT rel_terreno_erodido_a_tipoerosao_fk FOREIGN KEY (tipoerosao) REFERENCES dominios.tipo_erosao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_a ADD CONSTRAINT rel_terreno_erodido_a_situacaoterreno_fk FOREIGN KEY (situacaoterreno) REFERENCES dominios.situacao_terreno(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_causa_fk FOREIGN KEY (causa) REFERENCES dominios.causa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_tiposumvert_fk FOREIGN KEY (tiposumvert) REFERENCES dominios.tipo_sum_vert(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_trilha_picada_l ADD CONSTRAINT tra_trilha_picada_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_p ADD CONSTRAINT rel_rocha_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_p ADD CONSTRAINT rel_rocha_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_p ADD CONSTRAINT rel_rocha_p_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_tipotravessiaped_fk FOREIGN KEY (tipotravessiaped) REFERENCES dominios.tipo_travessia_ped(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_ponto_cotado_altimetrico_p ADD CONSTRAINT rel_ponto_cotado_altimetrico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_ponto_cotado_altimetrico_p ADD CONSTRAINT rel_ponto_cotado_altimetrico_p_cotacomprovada_fk FOREIGN KEY (cotacomprovada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_confluencia_p ADD CONSTRAINT hid_confluencia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_confluencia_p ADD CONSTRAINT hid_confluencia_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_dique ADD CONSTRAINT hid_dique_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_matcondutor_fk FOREIGN KEY (matcondutor) REFERENCES dominios.mat_condutor(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_emduto_fk FOREIGN KEY (emduto) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_tipotrechocomunic_fk FOREIGN KEY (tipotrechocomunic) REFERENCES dominios.tipo_trecho_comunic(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_galeria_bueiro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_situacaoagua_fk FOREIGN KEY (situacaoagua) REFERENCES dominios.situacao_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_tipodepgeral_fk FOREIGN KEY (tipodepgeral) REFERENCES dominios.tipo_dep_geral(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_materialpredominante_fk FOREIGN KEY (materialpredominante) REFERENCES dominios.material_predominante(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_tipobanco_fk FOREIGN KEY (tipobanco) REFERENCES dominios.tipo_banco(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica ADD CONSTRAINT enc_est_gerad_energia_eletrica_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica ADD CONSTRAINT enc_est_gerad_energia_eletrica_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica ADD CONSTRAINT enc_est_gerad_energia_eletrica_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica ADD CONSTRAINT enc_est_gerad_energia_eletrica_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_galeria_bueiro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_tipodepgeral_fk FOREIGN KEY (tipodepgeral) REFERENCES dominios.tipo_dep_geral(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_materialpredominante_fk FOREIGN KEY (materialpredominante) REFERENCES dominios.material_predominante(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_tipobanco_fk FOREIGN KEY (tipobanco) REFERENCES dominios.tipo_banco(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_foz_maritima_p ADD CONSTRAINT hid_foz_maritima_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_sistemageodesico_fk FOREIGN KEY (sistemageodesico) REFERENCES dominios.sistema_geodesico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_proximidade_fk FOREIGN KEY (proximidade) REFERENCES dominios.proximidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_tipoptorefgeodtopo_fk FOREIGN KEY (tipoptorefgeodtopo) REFERENCES dominios.tipo_pto_ref_geod_topo(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_situacaomarco_fk FOREIGN KEY (situacaomarco) REFERENCES dominios.situacao_marco(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_tiporef_fk FOREIGN KEY (tiporef) REFERENCES dominios.tipo_ref(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_referencialaltim_fk FOREIGN KEY (referencialaltim) REFERENCES dominios.referencial_altim(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_referencialgrav_fk FOREIGN KEY (referencialgrav) REFERENCES dominios.referencial_grav(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_redereferencia_fk FOREIGN KEY (redereferencia) REFERENCES dominios.rede_referencia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_foz_maritima_l ADD CONSTRAINT hid_foz_maritima_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_area_politico_adm_a ADD CONSTRAINT lpal_area_politico_adm_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_l ADD CONSTRAINT dut_galeria_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_l ADD CONSTRAINT dut_galeria_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_l ADD CONSTRAINT dut_galeria_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_galeria_bueiro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_l ADD CONSTRAINT dut_galeria_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_l ADD CONSTRAINT dut_galeria_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_l ADD CONSTRAINT dut_galeria_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_l ADD CONSTRAINT dut_galeria_l_setor_fk FOREIGN KEY (setor) REFERENCES dominios.setor(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_galeria_l ADD CONSTRAINT dut_galeria_l_tipotrechoduto_fk FOREIGN KEY (tipotrechoduto) REFERENCES dominios.tipo_trecho_duto(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_tipodepgeral_fk FOREIGN KEY (tipodepgeral) REFERENCES dominios.tipo_dep_geral(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento_a ADD CONSTRAINT sb_dep_saneamento_a_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_foz_maritima_a ADD CONSTRAINT hid_foz_maritima_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_est_med_fenomenos_p ADD CONSTRAINT pto_pto_est_med_fenomenos_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_est_med_fenomenos_p ADD CONSTRAINT pto_pto_est_med_fenomenos_p_tipoptoestmed_fk FOREIGN KEY (tipoptoestmed) REFERENCES dominios.tipo_pto_est_med(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_l ADD CONSTRAINT hdv_obstaculo_navegacao_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_l ADD CONSTRAINT hdv_obstaculo_navegacao_l_tipoobst_fk FOREIGN KEY (tipoobst) REFERENCES dominios.tipo_obst(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_l ADD CONSTRAINT hdv_obstaculo_navegacao_l_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta_p ADD CONSTRAINT hid_comporta_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta_p ADD CONSTRAINT hid_comporta_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta_p ADD CONSTRAINT hid_comporta_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_corredeira_p ADD CONSTRAINT hid_corredeira_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio_a ADD CONSTRAINT tra_patio_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio_a ADD CONSTRAINT tra_patio_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio_a ADD CONSTRAINT tra_patio_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_estadofisico_fk FOREIGN KEY (estadofisico) REFERENCES dominios.estado_fisico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_tipodepgeral_fk FOREIGN KEY (tipodepgeral) REFERENCES dominios.tipo_dep_geral(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_saneamento ADD CONSTRAINT sb_dep_saneamento_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_corte_p ADD CONSTRAINT rel_corte_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_corte_p ADD CONSTRAINT rel_corte_p_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio ADD CONSTRAINT sb_cemiterio_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio ADD CONSTRAINT sb_cemiterio_destinacaocemiterio_fk FOREIGN KEY (destinacaocemiterio) REFERENCES dominios.destinacao_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio ADD CONSTRAINT sb_cemiterio_tipocemiterio_fk FOREIGN KEY (tipocemiterio) REFERENCES dominios.tipo_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio ADD CONSTRAINT sb_cemiterio_denominacaoassociada_fk FOREIGN KEY (denominacaoassociada) REFERENCES dominios.denominacao_associada(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_p ADD CONSTRAINT tra_ponte_p_tipoponte_fk FOREIGN KEY (tipoponte) REFERENCES dominios.tipo_ponte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_p ADD CONSTRAINT tra_ponte_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_p ADD CONSTRAINT tra_ponte_p_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_p ADD CONSTRAINT tra_ponte_p_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_p ADD CONSTRAINT tra_ponte_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_p ADD CONSTRAINT tra_ponte_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_p ADD CONSTRAINT tra_ponte_p_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_a ADD CONSTRAINT hdv_obstaculo_navegacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_a ADD CONSTRAINT hdv_obstaculo_navegacao_a_tipoobst_fk FOREIGN KEY (tipoobst) REFERENCES dominios.tipo_obst(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_a ADD CONSTRAINT hdv_obstaculo_navegacao_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_p ADD CONSTRAINT hid_recife_p_tiporecife_fk FOREIGN KEY (tiporecife) REFERENCES dominios.tipo_recife(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_p ADD CONSTRAINT hid_recife_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_p ADD CONSTRAINT hid_recife_p_situacaocosta_fk FOREIGN KEY (situacaocosta) REFERENCES dominios.situacao_costa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_p ADD CONSTRAINT hid_recife_p_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_p ADD CONSTRAINT enc_hidreletrica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_corredeira_a ADD CONSTRAINT hid_corredeira_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_l ADD CONSTRAINT rel_rocha_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_l ADD CONSTRAINT rel_rocha_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_l ADD CONSTRAINT rel_rocha_l_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_corte_a ADD CONSTRAINT rel_corte_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_corte_a ADD CONSTRAINT rel_corte_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_entroncamento_pto_p ADD CONSTRAINT tra_entroncamento_pto_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_entroncamento_pto_p ADD CONSTRAINT tra_entroncamento_pto_p_tipoentroncamento_fk FOREIGN KEY (tipoentroncamento) REFERENCES dominios.tipo_entroncamento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_corte_l ADD CONSTRAINT rel_corte_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_corte_l ADD CONSTRAINT rel_corte_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_p ADD CONSTRAINT hdv_obstaculo_navegacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_p ADD CONSTRAINT hdv_obstaculo_navegacao_p_tipoobst_fk FOREIGN KEY (tipoobst) REFERENCES dominios.tipo_obst(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao_p ADD CONSTRAINT hdv_obstaculo_navegacao_p_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta_l ADD CONSTRAINT hid_comporta_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta_l ADD CONSTRAINT hid_comporta_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta_l ADD CONSTRAINT hid_comporta_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_uso_sustentavel_a ADD CONSTRAINT lpal_unidade_uso_sustentavel_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_uso_sustentavel_a ADD CONSTRAINT lpal_unidade_uso_sustentavel_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_uso_sustentavel_a ADD CONSTRAINT lpal_unidade_uso_sustentavel_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_uso_sustentavel_a ADD CONSTRAINT lpal_unidade_uso_sustentavel_a_tipounidusosust_fk FOREIGN KEY (tipounidusosust) REFERENCES dominios.tipo_unid_uso_sust(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_uso_sustentavel_a ADD CONSTRAINT lpal_unidade_uso_sustentavel_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_tipoatracad_fk FOREIGN KEY (tipoatracad) REFERENCES dominios.tipo_atracad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_p ADD CONSTRAINT hdv_atracadouro_terminal_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular ADD CONSTRAINT tra_funicular_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular ADD CONSTRAINT tra_funicular_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular ADD CONSTRAINT tra_funicular_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_tipotravessiaped_fk FOREIGN KEY (tipotravessiaped) REFERENCES dominios.tipo_travessia_ped(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_l ADD CONSTRAINT tra_travessia_pedestre_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_encoberto_fk FOREIGN KEY (encoberto) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_tipotrechodrenagem_fk FOREIGN KEY (tipotrechodrenagem) REFERENCES dominios.tipo_trecho_drenagem(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_navegavel_fk FOREIGN KEY (navegavel) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_drenagem_l ADD CONSTRAINT hid_trecho_drenagem_l_regime_fk FOREIGN KEY (regime) REFERENCES dominios.regime(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel ADD CONSTRAINT tra_tunel_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel ADD CONSTRAINT tra_tunel_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel ADD CONSTRAINT tra_tunel_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel ADD CONSTRAINT tra_tunel_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel ADD CONSTRAINT tra_tunel_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel ADD CONSTRAINT tra_tunel_tipotunel_fk FOREIGN KEY (tipotunel) REFERENCES dominios.tipo_tunel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel ADD CONSTRAINT tra_tunel_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_ponto_rodoviario_p ADD CONSTRAINT rod_ponto_rodoviario_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_ponto_rodoviario_p ADD CONSTRAINT rod_ponto_rodoviario_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_tipoatracad_fk FOREIGN KEY (tipoatracad) REFERENCES dominios.tipo_atracad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_a ADD CONSTRAINT hdv_atracadouro_terminal_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_p ADD CONSTRAINT eco_deposito_geral_p_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_p ADD CONSTRAINT eco_deposito_geral_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_p ADD CONSTRAINT eco_deposito_geral_p_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_p ADD CONSTRAINT eco_deposito_geral_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_p ADD CONSTRAINT eco_deposito_geral_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_tipotravessiaped_fk FOREIGN KEY (tipotravessiaped) REFERENCES dominios.tipo_travessia_ped(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_matconstr_fk FOREIGN KEY (matconstr) REFERENCES dominios.mat_constr(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_pedestre_p ADD CONSTRAINT tra_travessia_pedestre_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_atividade_fk FOREIGN KEY (atividade) REFERENCES dominios.atividade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_tipoextmin_fk FOREIGN KEY (tipoextmin) REFERENCES dominios.tipo_ext_min(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_tipopocomina_fk FOREIGN KEY (tipopocomina) REFERENCES dominios.tipo_poco_mina(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_procextracao_fk FOREIGN KEY (procextracao) REFERENCES dominios.proc_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_a ADD CONSTRAINT eco_ext_mineral_a_formaextracao_fk FOREIGN KEY (formaextracao) REFERENCES dominios.forma_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_terra_indigena_a ADD CONSTRAINT lpal_terra_indigena_a_situacaojuridica_fk FOREIGN KEY (situacaojuridica) REFERENCES dominios.situacao_juridica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_terra_indigena_a ADD CONSTRAINT lpal_terra_indigena_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_terra_indigena_a ADD CONSTRAINT lpal_terra_indigena_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_terra_indigena_a ADD CONSTRAINT lpal_terra_indigena_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_limite_area_especial_l ADD CONSTRAINT lpal_limite_area_especial_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_limite_area_especial_l ADD CONSTRAINT lpal_limite_area_especial_l_tipolimareaesp_fk FOREIGN KEY (tipolimareaesp) REFERENCES dominios.tipo_lim_area_esp(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_limite_area_especial_l ADD CONSTRAINT lpal_limite_area_especial_l_referenciallegal_fk FOREIGN KEY (referenciallegal) REFERENCES dominios.referencial_legal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_dominialidade_fk FOREIGN KEY (dominialidade) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_salgada_fk FOREIGN KEY (salgada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_artificial_fk FOREIGN KEY (artificial) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_tipomassadagua_fk FOREIGN KEY (tipomassadagua) REFERENCES dominios.tipo_massa_dagua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_massa_dagua_a ADD CONSTRAINT hid_massa_dagua_a_regime_fk FOREIGN KEY (regime) REFERENCES dominios.regime(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiog_natural ADD CONSTRAINT rel_elemento_fisiog_natural_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiog_natural ADD CONSTRAINT rel_elemento_fisiog_natural_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_restinga_a ADD CONSTRAINT veg_veg_restinga_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto ADD CONSTRAINT tra_passagem_elevada_viaduto_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto ADD CONSTRAINT tra_passagem_elevada_viaduto_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto ADD CONSTRAINT tra_passagem_elevada_viaduto_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto ADD CONSTRAINT tra_passagem_elevada_viaduto_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto ADD CONSTRAINT tra_passagem_elevada_viaduto_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto ADD CONSTRAINT tra_passagem_elevada_viaduto_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto ADD CONSTRAINT tra_passagem_elevada_viaduto_tipopassagviad_fk FOREIGN KEY (tipopassagviad) REFERENCES dominios.tipo_passag_viad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_atividade_fk FOREIGN KEY (atividade) REFERENCES dominios.atividade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_tipoextmin_fk FOREIGN KEY (tipoextmin) REFERENCES dominios.tipo_ext_min(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_tipopocomina_fk FOREIGN KEY (tipopocomina) REFERENCES dominios.tipo_poco_mina(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_procextracao_fk FOREIGN KEY (procextracao) REFERENCES dominios.proc_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_l ADD CONSTRAINT eco_ext_mineral_l_formaextracao_fk FOREIGN KEY (formaextracao) REFERENCES dominios.forma_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_usopista_fk FOREIGN KEY (usopista) REFERENCES dominios.uso_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_homologacao_fk FOREIGN KEY (homologacao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_tipopista_fk FOREIGN KEY (tipopista) REFERENCES dominios.tipo_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_a ADD CONSTRAINT aer_pista_ponto_pouso_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_usopista_fk FOREIGN KEY (usopista) REFERENCES dominios.uso_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_homologacao_fk FOREIGN KEY (homologacao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_tipopista_fk FOREIGN KEY (tipopista) REFERENCES dominios.tipo_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_l ADD CONSTRAINT aer_pista_ponto_pouso_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_distrito_a ADD CONSTRAINT lpal_distrito_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponto_rodoviario_ferrov ADD CONSTRAINT tra_ponto_rodoviario_ferrov_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponto_rodoviario_ferrov ADD CONSTRAINT tra_ponto_rodoviario_ferrov_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_area_construida_a ADD CONSTRAINT lpal_area_construida_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_usopista_fk FOREIGN KEY (usopista) REFERENCES dominios.uso_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_homologacao_fk FOREIGN KEY (homologacao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_tipopista_fk FOREIGN KEY (tipopista) REFERENCES dominios.tipo_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso_p ADD CONSTRAINT aer_pista_ponto_pouso_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_a ADD CONSTRAINT rel_rocha_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_a ADD CONSTRAINT rel_rocha_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_rocha_a ADD CONSTRAINT rel_rocha_a_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_p ADD CONSTRAINT tra_travessia_p_tipoembarcacao_fk FOREIGN KEY (tipoembarcacao) REFERENCES dominios.tipo_embarcacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_p ADD CONSTRAINT tra_travessia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_p ADD CONSTRAINT tra_travessia_p_tipouso_fk FOREIGN KEY (tipouso) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_p ADD CONSTRAINT tra_travessia_p_tipotravessia_fk FOREIGN KEY (tipotravessia) REFERENCES dominios.tipo_travessia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_plataforma ADD CONSTRAINT eco_plataforma_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_plataforma ADD CONSTRAINT eco_plataforma_tipoplataforma_fk FOREIGN KEY (tipoplataforma) REFERENCES dominios.tipo_plataforma(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_area_umida_a ADD CONSTRAINT hid_area_umida_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_area_umida_a ADD CONSTRAINT hid_area_umida_a_tipoareaumida_fk FOREIGN KEY (tipoareaumida) REFERENCES dominios.tipo_area_umida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_p ADD CONSTRAINT rel_duna_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_p ADD CONSTRAINT rel_duna_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_p ADD CONSTRAINT rel_duna_p_fixa_fk FOREIGN KEY (fixa) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa ADD CONSTRAINT hdv_eclusa_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa ADD CONSTRAINT hdv_eclusa_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_eclusa ADD CONSTRAINT hdv_eclusa_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_isolinha_hipsometrica ADD CONSTRAINT rel_isolinha_hipsometrica_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_l ADD CONSTRAINT enc_termeletrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_l ADD CONSTRAINT enc_termeletrica_l_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_l ADD CONSTRAINT enc_termeletrica_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_l ADD CONSTRAINT enc_termeletrica_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_l ADD CONSTRAINT enc_termeletrica_l_tipocombustivel_fk FOREIGN KEY (tipocombustivel) REFERENCES dominios.tipo_combustivel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_a ADD CONSTRAINT enc_termeletrica_a_tipocombustivel_fk FOREIGN KEY (tipocombustivel) REFERENCES dominios.tipo_combustivel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe ADD CONSTRAINT hid_quebramar_molhe_tipoquebramolhe_fk FOREIGN KEY (tipoquebramolhe) REFERENCES dominios.tipo_quebra_molhe(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe ADD CONSTRAINT hid_quebramar_molhe_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe ADD CONSTRAINT hid_quebramar_molhe_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe ADD CONSTRAINT hid_quebramar_molhe_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe ADD CONSTRAINT hid_quebramar_molhe_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia ADD CONSTRAINT tra_travessia_tipoembarcacao_fk FOREIGN KEY (tipoembarcacao) REFERENCES dominios.tipo_embarcacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia ADD CONSTRAINT tra_travessia_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia ADD CONSTRAINT tra_travessia_tipouso_fk FOREIGN KEY (tipouso) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia ADD CONSTRAINT tra_travessia_tipotravessia_fk FOREIGN KEY (tipotravessia) REFERENCES dominios.tipo_travessia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira ADD CONSTRAINT fer_cremalheira_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira ADD CONSTRAINT fer_cremalheira_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira ADD CONSTRAINT fer_cremalheira_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_plataforma_p ADD CONSTRAINT eco_plataforma_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_plataforma_p ADD CONSTRAINT eco_plataforma_p_tipoplataforma_fk FOREIGN KEY (tipoplataforma) REFERENCES dominios.tipo_plataforma(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protecao_integral_a ADD CONSTRAINT lpal_unidade_protecao_integral_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protecao_integral_a ADD CONSTRAINT lpal_unidade_protecao_integral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protecao_integral_a ADD CONSTRAINT lpal_unidade_protecao_integral_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protecao_integral_a ADD CONSTRAINT lpal_unidade_protecao_integral_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_protecao_integral_a ADD CONSTRAINT lpal_unidade_protecao_integral_a_tipounidprotinteg_fk FOREIGN KEY (tipounidprotinteg) REFERENCES dominios.tipo_unid_prot_integ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_tipotrechoferrov_fk FOREIGN KEY (tipotrechoferrov) REFERENCES dominios.tipo_trecho_ferrov(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_eletrificada_fk FOREIGN KEY (eletrificada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_nrlinhas_fk FOREIGN KEY (nrlinhas) REFERENCES dominios.nr_linhas(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_bitola_fk FOREIGN KEY (bitola) REFERENCES dominios.bitola(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_trecho_ferroviario_l ADD CONSTRAINT fer_trecho_ferroviario_l_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_termeletrica_p ADD CONSTRAINT enc_termeletrica_p_tipocombustivel_fk FOREIGN KEY (tipocombustivel) REFERENCES dominios.tipo_combustivel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_energia_p ADD CONSTRAINT enc_torre_energia_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_energia_p ADD CONSTRAINT enc_torre_energia_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_energia_p ADD CONSTRAINT enc_torre_energia_p_ovgd_fk FOREIGN KEY (ovgd) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_torre_energia_p ADD CONSTRAINT enc_torre_energia_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec ADD CONSTRAINT eco_equip_agropec_tipoequipagropec_fk FOREIGN KEY (tipoequipagropec) REFERENCES dominios.tipo_equip_agropec(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec ADD CONSTRAINT eco_equip_agropec_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec ADD CONSTRAINT eco_equip_agropec_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec ADD CONSTRAINT eco_equip_agropec_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_alter_fisiog_antropica_p ADD CONSTRAINT rel_alter_fisiog_antropica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_alter_fisiog_antropica_p ADD CONSTRAINT rel_alter_fisiog_antropica_p_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_foz_maritima ADD CONSTRAINT hid_foz_maritima_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_l ADD CONSTRAINT enc_hidreletrica_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio_p ADD CONSTRAINT tra_patio_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio_p ADD CONSTRAINT tra_patio_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_patio_p ADD CONSTRAINT tra_patio_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_hidreletrica_a ADD CONSTRAINT enc_hidreletrica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_dolina_a ADD CONSTRAINT rel_dolina_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_dolina_a ADD CONSTRAINT rel_dolina_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_a ADD CONSTRAINT eco_deposito_geral_a_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_a ADD CONSTRAINT eco_deposito_geral_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_a ADD CONSTRAINT eco_deposito_geral_a_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_a ADD CONSTRAINT eco_deposito_geral_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_deposito_geral_a ADD CONSTRAINT eco_deposito_geral_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_federacao_a ADD CONSTRAINT lpal_unidade_federacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_federacao_a ADD CONSTRAINT lpal_unidade_federacao_a_sigla_fk FOREIGN KEY (sigla) REFERENCES dominios.sigla_uf(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_situacaoagua_fk FOREIGN KEY (situacaoagua) REFERENCES dominios.situacao_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_tipodepgeral_fk FOREIGN KEY (tipodepgeral) REFERENCES dominios.tipo_dep_geral(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua_a ADD CONSTRAINT sb_dep_abast_agua_a_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campo_a ADD CONSTRAINT veg_campo_a_tipocampo_fk FOREIGN KEY (tipocampo) REFERENCES dominios.tipo_campo(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campo_a ADD CONSTRAINT veg_campo_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campo_a ADD CONSTRAINT veg_campo_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campo_a ADD CONSTRAINT veg_campo_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campo_a ADD CONSTRAINT veg_campo_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campo_a ADD CONSTRAINT veg_campo_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_campo_a ADD CONSTRAINT veg_campo_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_setor_fk FOREIGN KEY (setor) REFERENCES dominios.setor(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_trecho_duto_l ADD CONSTRAINT dut_trecho_duto_l_tipotrechoduto_fk FOREIGN KEY (tipotrechoduto) REFERENCES dominios.tipo_trecho_duto(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_fonte_dagua_p ADD CONSTRAINT hid_fonte_dagua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_fonte_dagua_p ADD CONSTRAINT hid_fonte_dagua_p_qualidagua_fk FOREIGN KEY (qualidagua) REFERENCES dominios.qualid_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_fonte_dagua_p ADD CONSTRAINT hid_fonte_dagua_p_tipofontedagua_fk FOREIGN KEY (tipofontedagua) REFERENCES dominios.tipo_fonte_dagua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_fonte_dagua_p ADD CONSTRAINT hid_fonte_dagua_p_regime_fk FOREIGN KEY (regime) REFERENCES dominios.regime(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_dolina_p ADD CONSTRAINT rel_dolina_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_dolina_p ADD CONSTRAINT rel_dolina_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_alter_fisiog_antropica ADD CONSTRAINT rel_alter_fisiog_antropica_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_alter_fisiog_antropica ADD CONSTRAINT rel_alter_fisiog_antropica_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_marco_de_limite_p ADD CONSTRAINT pto_marco_de_limite_p_sistemageodesico_fk FOREIGN KEY (sistemageodesico) REFERENCES dominios.sistema_geodesico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_marco_de_limite_p ADD CONSTRAINT pto_marco_de_limite_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_marco_de_limite_p ADD CONSTRAINT pto_marco_de_limite_p_tipomarcolim_fk FOREIGN KEY (tipomarcolim) REFERENCES dominios.tipo_hierarquia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_marco_de_limite_p ADD CONSTRAINT pto_marco_de_limite_p_referencialaltim_fk FOREIGN KEY (referencialaltim) REFERENCES dominios.referencial_altim(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_vereda_fk FOREIGN KEY (vereda) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_cerrado_a ADD CONSTRAINT veg_cerrado_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular_p ADD CONSTRAINT tra_funicular_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular_p ADD CONSTRAINT tra_funicular_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular_p ADD CONSTRAINT tra_funicular_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro_a ADD CONSTRAINT hdv_fundeadouro_a_tipofundeadouro_fk FOREIGN KEY (tipofundeadouro) REFERENCES dominios.tipo_fundeadouro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro_a ADD CONSTRAINT hdv_fundeadouro_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro_a ADD CONSTRAINT hdv_fundeadouro_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_p ADD CONSTRAINT hid_ilha_p_tipoilha_fk FOREIGN KEY (tipoilha) REFERENCES dominios.tipo_ilha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_p ADD CONSTRAINT hid_ilha_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_p ADD CONSTRAINT hid_ilha_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_alter_fisiog_antropica_a ADD CONSTRAINT rel_alter_fisiog_antropica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_alter_fisiog_antropica_a ADD CONSTRAINT rel_alter_fisiog_antropica_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_l ADD CONSTRAINT hid_ilha_l_tipoilha_fk FOREIGN KEY (tipoilha) REFERENCES dominios.tipo_ilha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_l ADD CONSTRAINT hid_ilha_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_l ADD CONSTRAINT hid_ilha_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_a ADD CONSTRAINT rel_duna_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_a ADD CONSTRAINT rel_duna_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_a ADD CONSTRAINT rel_duna_a_fixa_fk FOREIGN KEY (fixa) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_antena_comunic_p ADD CONSTRAINT enc_antena_comunic_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_antena_comunic_p ADD CONSTRAINT enc_antena_comunic_p_posicaoreledific_fk FOREIGN KEY (posicaoreledific) REFERENCES dominios.posicao_rel_edific(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao ADD CONSTRAINT hdv_obstaculo_navegacao_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao ADD CONSTRAINT hdv_obstaculo_navegacao_tipoobst_fk FOREIGN KEY (tipoobst) REFERENCES dominios.tipo_obst(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_obstaculo_navegacao ADD CONSTRAINT hdv_obstaculo_navegacao_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular_l ADD CONSTRAINT tra_funicular_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular_l ADD CONSTRAINT tra_funicular_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_funicular_l ADD CONSTRAINT tra_funicular_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio_a ADD CONSTRAINT sb_cemiterio_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio_a ADD CONSTRAINT sb_cemiterio_a_destinacaocemiterio_fk FOREIGN KEY (destinacaocemiterio) REFERENCES dominios.destinacao_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio_a ADD CONSTRAINT sb_cemiterio_a_tipocemiterio_fk FOREIGN KEY (tipocemiterio) REFERENCES dominios.tipo_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio_a ADD CONSTRAINT sb_cemiterio_a_denominacaoassociada_fk FOREIGN KEY (denominacaoassociada) REFERENCES dominios.denominacao_associada(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_terreno_fk FOREIGN KEY (terreno) REFERENCES dominios.condicao_terreno(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_tipolavoura_fk FOREIGN KEY (tipolavoura) REFERENCES dominios.tipo_lavoura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_reflorestamento_a ADD CONSTRAINT veg_reflorestamento_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_a ADD CONSTRAINT hid_ilha_a_tipoilha_fk FOREIGN KEY (tipoilha) REFERENCES dominios.tipo_ilha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_a ADD CONSTRAINT hid_ilha_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ilha_a ADD CONSTRAINT hid_ilha_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal ADD CONSTRAINT hdv_atracadouro_terminal_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal ADD CONSTRAINT hdv_atracadouro_terminal_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal ADD CONSTRAINT hdv_atracadouro_terminal_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal ADD CONSTRAINT hdv_atracadouro_terminal_tipoatracad_fk FOREIGN KEY (tipoatracad) REFERENCES dominios.tipo_atracad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal ADD CONSTRAINT hdv_atracadouro_terminal_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_rocha_em_agua_a ADD CONSTRAINT hid_rocha_em_agua_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte ADD CONSTRAINT tra_ponte_tipoponte_fk FOREIGN KEY (tipoponte) REFERENCES dominios.tipo_ponte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte ADD CONSTRAINT tra_ponte_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte ADD CONSTRAINT tra_ponte_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte ADD CONSTRAINT tra_ponte_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte ADD CONSTRAINT tra_ponte_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte ADD CONSTRAINT tra_ponte_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte ADD CONSTRAINT tra_ponte_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_a ADD CONSTRAINT hid_recife_a_tiporecife_fk FOREIGN KEY (tiporecife) REFERENCES dominios.tipo_recife(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_a ADD CONSTRAINT hid_recife_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_a ADD CONSTRAINT hid_recife_a_situacaocosta_fk FOREIGN KEY (situacaocosta) REFERENCES dominios.situacao_costa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_a ADD CONSTRAINT hid_recife_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_barragem_calcadao_a ADD CONSTRAINT sb_barragem_calcadao_a_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_barragem_calcadao_a ADD CONSTRAINT sb_barragem_calcadao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_barragem_calcadao_a ADD CONSTRAINT sb_barragem_calcadao_a_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_l ADD CONSTRAINT hid_recife_l_tiporecife_fk FOREIGN KEY (tiporecife) REFERENCES dominios.tipo_recife(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_l ADD CONSTRAINT hid_recife_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_l ADD CONSTRAINT hid_recife_l_situacaocosta_fk FOREIGN KEY (situacaocosta) REFERENCES dominios.situacao_costa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife_l ADD CONSTRAINT hid_recife_l_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso ADD CONSTRAINT aer_pista_ponto_pouso_usopista_fk FOREIGN KEY (usopista) REFERENCES dominios.uso_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso ADD CONSTRAINT aer_pista_ponto_pouso_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso ADD CONSTRAINT aer_pista_ponto_pouso_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso ADD CONSTRAINT aer_pista_ponto_pouso_homologacao_fk FOREIGN KEY (homologacao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso ADD CONSTRAINT aer_pista_ponto_pouso_tipopista_fk FOREIGN KEY (tipopista) REFERENCES dominios.tipo_pista(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso ADD CONSTRAINT aer_pista_ponto_pouso_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.aer_pista_ponto_pouso ADD CONSTRAINT aer_pista_ponto_pouso_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_formarocha_fk FOREIGN KEY (formarocha) REFERENCES dominios.forma_rocha(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_rocha_em_agua_p ADD CONSTRAINT hid_rocha_em_agua_p_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_ponto_inicio_fim_duto_p ADD CONSTRAINT dut_ponto_inicio_fim_duto_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_ponto_inicio_fim_duto_p ADD CONSTRAINT dut_ponto_inicio_fim_duto_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_l ADD CONSTRAINT rel_duna_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_l ADD CONSTRAINT rel_duna_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_duna_l ADD CONSTRAINT rel_duna_l_fixa_fk FOREIGN KEY (fixa) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira_p ADD CONSTRAINT fer_cremalheira_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira_p ADD CONSTRAINT fer_cremalheira_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira_p ADD CONSTRAINT fer_cremalheira_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_p ADD CONSTRAINT tra_tunel_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_p ADD CONSTRAINT tra_tunel_p_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_p ADD CONSTRAINT tra_tunel_p_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_p ADD CONSTRAINT tra_tunel_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_p ADD CONSTRAINT tra_tunel_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_p ADD CONSTRAINT tra_tunel_p_tipotunel_fk FOREIGN KEY (tipotunel) REFERENCES dominios.tipo_tunel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_p ADD CONSTRAINT tra_tunel_p_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_ponto_ferroviario_p ADD CONSTRAINT fer_ponto_ferroviario_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_ponto_ferroviario_p ADD CONSTRAINT fer_ponto_ferroviario_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_girador_ferroviario_p ADD CONSTRAINT fer_girador_ferroviario_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_girador_ferroviario_p ADD CONSTRAINT fer_girador_ferroviario_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_girador_ferroviario_p ADD CONSTRAINT fer_girador_ferroviario_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_girador_ferroviario_p ADD CONSTRAINT fer_girador_ferroviario_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_floresta_a ADD CONSTRAINT veg_floresta_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_floresta_a ADD CONSTRAINT veg_floresta_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_floresta_a ADD CONSTRAINT veg_floresta_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_floresta_a ADD CONSTRAINT veg_floresta_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_floresta_a ADD CONSTRAINT veg_floresta_a_especiepredominante_fk FOREIGN KEY (especiepredominante) REFERENCES dominios.especie(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_floresta_a ADD CONSTRAINT veg_floresta_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_floresta_a ADD CONSTRAINT veg_floresta_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_corredeira ADD CONSTRAINT hid_corredeira_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_grupo_transformadores_p ADD CONSTRAINT enc_grupo_transformadores_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife ADD CONSTRAINT hid_recife_tiporecife_fk FOREIGN KEY (tiporecife) REFERENCES dominios.tipo_recife(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife ADD CONSTRAINT hid_recife_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife ADD CONSTRAINT hid_recife_situacaocosta_fk FOREIGN KEY (situacaocosta) REFERENCES dominios.situacao_costa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_recife ADD CONSTRAINT hid_recife_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_curva_batimetrica_l ADD CONSTRAINT rel_curva_batimetrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_ponto_duto_p ADD CONSTRAINT dut_ponto_duto_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_ponto_duto_p ADD CONSTRAINT dut_ponto_duto_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_queda_dagua ADD CONSTRAINT hid_queda_dagua_tipoqueda_fk FOREIGN KEY (tipoqueda) REFERENCES dominios.tipo_queda(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_queda_dagua ADD CONSTRAINT hid_queda_dagua_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_terra_publica_a ADD CONSTRAINT lpal_terra_publica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_terra_publica_a ADD CONSTRAINT lpal_terra_publica_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_terra_publica_a ADD CONSTRAINT lpal_terra_publica_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_revestimento_fk FOREIGN KEY (revestimento) REFERENCES dominios.revestimento(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_canteirodivisorio_fk FOREIGN KEY (canteirodivisorio) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_trafego_fk FOREIGN KEY (trafego) REFERENCES dominios.trafego(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_trechoemperimetrourbano_fk FOREIGN KEY (trechoemperimetrourbano) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_acostamento_fk FOREIGN KEY (acostamento) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_trecho_rodoviario ADD CONSTRAINT rod_trecho_rodoviario_tipotrechorod_fk FOREIGN KEY (tipotrechorod) REFERENCES dominios.tipo_trecho_rod(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_ponto_cotado_batimetrico_p ADD CONSTRAINT rel_ponto_cotado_batimetrico_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_p ADD CONSTRAINT tra_passagem_elevada_viaduto_p_tipopassagviad_fk FOREIGN KEY (tipopassagviad) REFERENCES dominios.tipo_passag_viad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_grupo_transformadores_a ADD CONSTRAINT enc_grupo_transformadores_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_l ADD CONSTRAINT hid_canal_l_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_l ADD CONSTRAINT hid_canal_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_l ADD CONSTRAINT hid_canal_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_galeria_bueiro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_l ADD CONSTRAINT hid_canal_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_l ADD CONSTRAINT hid_canal_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_l ADD CONSTRAINT hid_canal_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_nome_local_p ADD CONSTRAINT lpal_nome_local_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_a ADD CONSTRAINT hid_canal_a_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_a ADD CONSTRAINT hid_canal_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_a ADD CONSTRAINT hid_canal_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_galeria_bueiro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_a ADD CONSTRAINT hid_canal_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_a ADD CONSTRAINT hid_canal_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_canal_a ADD CONSTRAINT hid_canal_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_l ADD CONSTRAINT tra_travessia_l_tipoembarcacao_fk FOREIGN KEY (tipoembarcacao) REFERENCES dominios.tipo_embarcacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_l ADD CONSTRAINT tra_travessia_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_l ADD CONSTRAINT tra_travessia_l_tipouso_fk FOREIGN KEY (tipouso) REFERENCES dominios.tipo_transporte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_travessia_l ADD CONSTRAINT tra_travessia_l_tipotravessia_fk FOREIGN KEY (tipotravessia) REFERENCES dominios.tipo_travessia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro_p ADD CONSTRAINT hdv_fundeadouro_p_tipofundeadouro_fk FOREIGN KEY (tipofundeadouro) REFERENCES dominios.tipo_fundeadouro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro_p ADD CONSTRAINT hdv_fundeadouro_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro_p ADD CONSTRAINT hdv_fundeadouro_p_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_gruta_caverna_l ADD CONSTRAINT rel_gruta_caverna_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_gruta_caverna_l ADD CONSTRAINT rel_gruta_caverna_l_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_especie_fk FOREIGN KEY (especie) REFERENCES dominios.especie_trecho_energia(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_trecho_energia_l ADD CONSTRAINT enc_trecho_energia_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_l ADD CONSTRAINT tra_ponte_l_tipoponte_fk FOREIGN KEY (tipoponte) REFERENCES dominios.tipo_ponte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_l ADD CONSTRAINT tra_ponte_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_l ADD CONSTRAINT tra_ponte_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_l ADD CONSTRAINT tra_ponte_l_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_l ADD CONSTRAINT tra_ponte_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_l ADD CONSTRAINT tra_ponte_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_ponte_l ADD CONSTRAINT tra_ponte_l_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_sinalizacao_p ADD CONSTRAINT hdv_sinalizacao_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_sinalizacao_p ADD CONSTRAINT hdv_sinalizacao_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_sinalizacao_p ADD CONSTRAINT hdv_sinalizacao_p_tiposinal_fk FOREIGN KEY (tiposinal) REFERENCES dominios.tipo_sinal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_sinalizacao_p ADD CONSTRAINT hdv_sinalizacao_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_vegetacao_a ADD CONSTRAINT veg_vegetacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_vegetacao_a ADD CONSTRAINT veg_vegetacao_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_vegetacao_a ADD CONSTRAINT veg_vegetacao_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro ADD CONSTRAINT hdv_fundeadouro_tipofundeadouro_fk FOREIGN KEY (tipofundeadouro) REFERENCES dominios.tipo_fundeadouro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro ADD CONSTRAINT hdv_fundeadouro_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_fundeadouro ADD CONSTRAINT hdv_fundeadouro_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_l ADD CONSTRAINT tra_tunel_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_l ADD CONSTRAINT tra_tunel_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_l ADD CONSTRAINT tra_tunel_l_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_l ADD CONSTRAINT tra_tunel_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_l ADD CONSTRAINT tra_tunel_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_l ADD CONSTRAINT tra_tunel_l_tipotunel_fk FOREIGN KEY (tipotunel) REFERENCES dominios.tipo_tunel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_tunel_l ADD CONSTRAINT tra_tunel_l_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_grupo_transformadores ADD CONSTRAINT enc_grupo_transformadores_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_tipoatracad_fk FOREIGN KEY (tipoatracad) REFERENCES dominios.tipo_atracad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hdv_atracadouro_terminal_l ADD CONSTRAINT hdv_atracadouro_terminal_l_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_terreno_fk FOREIGN KEY (terreno) REFERENCES dominios.condicao_terreno(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_cultura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_tipolavoura_fk FOREIGN KEY (tipolavoura) REFERENCES dominios.tipo_lavoura(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_cultivada_a ADD CONSTRAINT veg_veg_cultivada_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_a ADD CONSTRAINT hid_vala_a_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_a ADD CONSTRAINT hid_vala_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_a ADD CONSTRAINT hid_vala_a_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_galeria_bueiro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_a ADD CONSTRAINT hid_vala_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_a ADD CONSTRAINT hid_vala_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_a ADD CONSTRAINT hid_vala_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta ADD CONSTRAINT hid_comporta_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta ADD CONSTRAINT hid_comporta_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_comporta ADD CONSTRAINT hid_comporta_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_refugio_ecologico_a ADD CONSTRAINT veg_refugio_ecologico_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_refugio_ecologico_a ADD CONSTRAINT veg_refugio_ecologico_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_refugio_ecologico_a ADD CONSTRAINT veg_refugio_ecologico_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_refugio_ecologico_a ADD CONSTRAINT veg_refugio_ecologico_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_refugio_ecologico_a ADD CONSTRAINT veg_refugio_ecologico_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_refugio_ecologico_a ADD CONSTRAINT veg_refugio_ecologico_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_atividade_fk FOREIGN KEY (atividade) REFERENCES dominios.atividade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_tipoextmin_fk FOREIGN KEY (tipoextmin) REFERENCES dominios.tipo_ext_min(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_secaoativecon_fk FOREIGN KEY (secaoativecon) REFERENCES dominios.secao_ativ_econ(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_tipopocomina_fk FOREIGN KEY (tipopocomina) REFERENCES dominios.tipo_poco_mina(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_procextracao_fk FOREIGN KEY (procextracao) REFERENCES dominios.proc_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_ext_mineral_p ADD CONSTRAINT eco_ext_mineral_p_formaextracao_fk FOREIGN KEY (formaextracao) REFERENCES dominios.forma_extracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_gruta_caverna_p ADD CONSTRAINT rel_gruta_caverna_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_gruta_caverna_p ADD CONSTRAINT rel_gruta_caverna_p_tipoelemnat_fk FOREIGN KEY (tipoelemnat) REFERENCES dominios.tipo_elem_nat(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_l ADD CONSTRAINT hid_vala_l_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_l ADD CONSTRAINT hid_vala_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_l ADD CONSTRAINT hid_vala_l_finalidade_fk FOREIGN KEY (finalidade) REFERENCES dominios.finalidade_galeria_bueiro(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_l ADD CONSTRAINT hid_vala_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_l ADD CONSTRAINT hid_vala_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_vala_l ADD CONSTRAINT hid_vala_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_passagem_nivel_p ADD CONSTRAINT rod_passagem_nivel_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rod_passagem_nivel_p ADD CONSTRAINT rod_passagem_nivel_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_ponto_hipsometrico ADD CONSTRAINT rel_ponto_hipsometrico_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem ADD CONSTRAINT hid_barragem_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem ADD CONSTRAINT hid_barragem_usoprincipal_fk FOREIGN KEY (usoprincipal) REFERENCES dominios.uso_principal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem ADD CONSTRAINT hid_barragem_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_barragem ADD CONSTRAINT hid_barragem_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_l ADD CONSTRAINT rel_terreno_erodido_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_l ADD CONSTRAINT rel_terreno_erodido_l_tipoerosao_fk FOREIGN KEY (tipoerosao) REFERENCES dominios.tipo_erosao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_l ADD CONSTRAINT rel_terreno_erodido_l_situacaoterreno_fk FOREIGN KEY (situacaoterreno) REFERENCES dominios.situacao_terreno(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_curva_nivel_l ADD CONSTRAINT rel_curva_nivel_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_curva_nivel_l ADD CONSTRAINT rel_curva_nivel_l_tipocurvanivel_fk FOREIGN KEY (tipocurvanivel) REFERENCES dominios.tipo_curva_nivel(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_curva_nivel_l ADD CONSTRAINT rel_curva_nivel_l_depressao_fk FOREIGN KEY (depressao) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_tipoquebramolhe_fk FOREIGN KEY (tipoquebramolhe) REFERENCES dominios.tipo_quebra_molhe(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_l ADD CONSTRAINT hid_quebramar_molhe_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_limite_politico_adm_l ADD CONSTRAINT lpal_limite_politico_adm_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_limite_politico_adm_l ADD CONSTRAINT lpal_limite_politico_adm_l_referenciallegal_fk FOREIGN KEY (referenciallegal) REFERENCES dominios.referencial_legal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_tipoexposicao_fk FOREIGN KEY (tipoexposicao) REFERENCES dominios.tipo_exposicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_tipoequipdesenvsocial_fk FOREIGN KEY (tipoequipdesenvsocial) REFERENCES dominios.tipo_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_unidadevolume_fk FOREIGN KEY (unidadevolume) REFERENCES dominios.unidade_volume(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_situacaoagua_fk FOREIGN KEY (situacaoagua) REFERENCES dominios.situacao_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_tipodepgeral_fk FOREIGN KEY (tipodepgeral) REFERENCES dominios.tipo_dep_geral(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_localizacaoequipdesenvsocial_fk FOREIGN KEY (localizacaoequipdesenvsocial) REFERENCES dominios.local_equip_desenv_social(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_finalidadedep_fk FOREIGN KEY (finalidadedep) REFERENCES dominios.finalidade_deposito(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_dep_abast_agua ADD CONSTRAINT sb_dep_abast_agua_tratamento_fk FOREIGN KEY (tratamento) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_conservacao_a ADD CONSTRAINT lpal_unidade_conservacao_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_conservacao_a ADD CONSTRAINT lpal_unidade_conservacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_conservacao_a ADD CONSTRAINT lpal_unidade_conservacao_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_conservacao_a ADD CONSTRAINT lpal_unidade_conservacao_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ponto_drenagem_p ADD CONSTRAINT hid_ponto_drenagem_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_ponto_drenagem_p ADD CONSTRAINT hid_ponto_drenagem_p_relacionado_fk FOREIGN KEY (relacionado) REFERENCES dominios.relacionado(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia ADD CONSTRAINT hid_banco_areia_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia ADD CONSTRAINT hid_banco_areia_materialpredominante_fk FOREIGN KEY (materialpredominante) REFERENCES dominios.material_predominante(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia ADD CONSTRAINT hid_banco_areia_tipobanco_fk FOREIGN KEY (tipobanco) REFERENCES dominios.tipo_banco(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_banco_areia ADD CONSTRAINT hid_banco_areia_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_tipopavimentacao_fk FOREIGN KEY (tipopavimentacao) REFERENCES dominios.tipo_pavimentacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_necessitamanutencao_fk FOREIGN KEY (necessitamanutencao) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_posicaopista_fk FOREIGN KEY (posicaopista) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_passagem_elevada_viaduto_l ADD CONSTRAINT tra_passagem_elevada_viaduto_l_tipopassagviad_fk FOREIGN KEY (tipopassagviad) REFERENCES dominios.tipo_passag_viad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_condutor_hidrico_l ADD CONSTRAINT dut_condutor_hidrico_l_situacaoespacial_fk FOREIGN KEY (situacaoespacial) REFERENCES dominios.situacao_espacial(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_condutor_hidrico_l ADD CONSTRAINT dut_condutor_hidrico_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_condutor_hidrico_l ADD CONSTRAINT dut_condutor_hidrico_l_posicaorelativa_fk FOREIGN KEY (posicaorelativa) REFERENCES dominios.posicao_relativa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_condutor_hidrico_l ADD CONSTRAINT dut_condutor_hidrico_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_condutor_hidrico_l ADD CONSTRAINT dut_condutor_hidrico_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_condutor_hidrico_l ADD CONSTRAINT dut_condutor_hidrico_l_setor_fk FOREIGN KEY (setor) REFERENCES dominios.setor(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.dut_condutor_hidrico_l ADD CONSTRAINT dut_condutor_hidrico_l_tipotrechoduto_fk FOREIGN KEY (tipotrechoduto) REFERENCES dominios.tipo_trecho_duto(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_corredeira_l ADD CONSTRAINT hid_corredeira_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_mangue_a ADD CONSTRAINT veg_mangue_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_mangue_a ADD CONSTRAINT veg_mangue_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_mangue_a ADD CONSTRAINT veg_mangue_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_mangue_a ADD CONSTRAINT veg_mangue_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_mangue_a ADD CONSTRAINT veg_mangue_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_mangue_a ADD CONSTRAINT veg_mangue_a_tipomanguezal_fk FOREIGN KEY (tipomanguezal) REFERENCES dominios.tipo_manguezal(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_mangue_a ADD CONSTRAINT veg_mangue_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_limite_massa_dagua_l ADD CONSTRAINT hid_limite_massa_dagua_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_limite_massa_dagua_l ADD CONSTRAINT hid_limite_massa_dagua_l_materialpredominante_fk FOREIGN KEY (materialpredominante) REFERENCES dominios.material_predominante(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_limite_massa_dagua_l ADD CONSTRAINT hid_limite_massa_dagua_l_revestida_fk FOREIGN KEY (revestida) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_limite_massa_dagua_l ADD CONSTRAINT hid_limite_massa_dagua_l_tipolimmassa_fk FOREIGN KEY (tipolimmassa) REFERENCES dominios.tipo_lim_massa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_aterro_l ADD CONSTRAINT rel_aterro_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_aterro_l ADD CONSTRAINT rel_aterro_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_queda_dagua_p ADD CONSTRAINT hid_queda_dagua_p_tipoqueda_fk FOREIGN KEY (tipoqueda) REFERENCES dominios.tipo_queda(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_queda_dagua_p ADD CONSTRAINT hid_queda_dagua_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_massa_dagua_a ADD CONSTRAINT hid_trecho_massa_dagua_a_tipotrechomassadagua_fk FOREIGN KEY (tipotrechomassadagua) REFERENCES dominios.tipo_trecho_massa(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_massa_dagua_a ADD CONSTRAINT hid_trecho_massa_dagua_a_dominialidade_fk FOREIGN KEY (dominialidade) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_massa_dagua_a ADD CONSTRAINT hid_trecho_massa_dagua_a_salgada_fk FOREIGN KEY (salgada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_massa_dagua_a ADD CONSTRAINT hid_trecho_massa_dagua_a_artificial_fk FOREIGN KEY (artificial) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_massa_dagua_a ADD CONSTRAINT hid_trecho_massa_dagua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_massa_dagua_a ADD CONSTRAINT hid_trecho_massa_dagua_a_tipomassadagua_fk FOREIGN KEY (tipomassadagua) REFERENCES dominios.tipo_massa_dagua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_trecho_massa_dagua_a ADD CONSTRAINT hid_trecho_massa_dagua_a_regime_fk FOREIGN KEY (regime) REFERENCES dominios.regime(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.tra_caminho_carrocavel_l ADD CONSTRAINT tra_caminho_carrocavel_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_p ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_p ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_p ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_p ADD CONSTRAINT enc_est_gerad_energia_eletrica_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_alter_fisiog_antropica_l ADD CONSTRAINT rel_alter_fisiog_antropica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_alter_fisiog_antropica_l ADD CONSTRAINT rel_alter_fisiog_antropica_l_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio_p ADD CONSTRAINT sb_cemiterio_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio_p ADD CONSTRAINT sb_cemiterio_p_destinacaocemiterio_fk FOREIGN KEY (destinacaocemiterio) REFERENCES dominios.destinacao_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio_p ADD CONSTRAINT sb_cemiterio_p_tipocemiterio_fk FOREIGN KEY (tipocemiterio) REFERENCES dominios.tipo_cemiterio(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.sb_cemiterio_p ADD CONSTRAINT sb_cemiterio_p_denominacaoassociada_fk FOREIGN KEY (denominacaoassociada) REFERENCES dominios.denominacao_associada(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_aterro_a ADD CONSTRAINT rel_aterro_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_aterro_a ADD CONSTRAINT rel_aterro_a_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_queda_dagua_a ADD CONSTRAINT hid_queda_dagua_a_tipoqueda_fk FOREIGN KEY (tipoqueda) REFERENCES dominios.tipo_queda(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_queda_dagua_a ADD CONSTRAINT hid_queda_dagua_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_conservacao_nao_snuc_a ADD CONSTRAINT lpal_unidade_conservacao_nao_snuc_a_tipounidprotegida_fk FOREIGN KEY (tipounidprotegida) REFERENCES dominios.tipo_unid_protegida(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_conservacao_nao_snuc_a ADD CONSTRAINT lpal_unidade_conservacao_nao_snuc_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_conservacao_nao_snuc_a ADD CONSTRAINT lpal_unidade_conservacao_nao_snuc_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_unidade_conservacao_nao_snuc_a ADD CONSTRAINT lpal_unidade_conservacao_nao_snuc_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_a ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_a ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_a ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_a ADD CONSTRAINT enc_est_gerad_energia_eletrica_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_l ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_l ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_tipoestgerad_fk FOREIGN KEY (tipoestgerad) REFERENCES dominios.tipo_est_gerad(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_l ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_est_gerad_energia_eletrica_l ADD CONSTRAINT enc_est_gerad_energia_eletrica_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira_l ADD CONSTRAINT fer_cremalheira_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira_l ADD CONSTRAINT fer_cremalheira_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.fer_cremalheira_l ADD CONSTRAINT fer_cremalheira_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_aterro_p ADD CONSTRAINT rel_aterro_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_aterro_p ADD CONSTRAINT rel_aterro_p_tipoalterantrop_fk FOREIGN KEY (tipoalterantrop) REFERENCES dominios.tipo_alter_antrop(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_queda_dagua_l ADD CONSTRAINT hid_queda_dagua_l_tipoqueda_fk FOREIGN KEY (tipoqueda) REFERENCES dominios.tipo_queda(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_queda_dagua_l ADD CONSTRAINT hid_queda_dagua_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido ADD CONSTRAINT rel_terreno_erodido_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido ADD CONSTRAINT rel_terreno_erodido_tipoerosao_fk FOREIGN KEY (tipoerosao) REFERENCES dominios.tipo_erosao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido ADD CONSTRAINT rel_terreno_erodido_situacaoterreno_fk FOREIGN KEY (situacaoterreno) REFERENCES dominios.situacao_terreno(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_elemento_fisiografico ADD CONSTRAINT rel_elemento_fisiografico_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_tipoequipagropec_fk FOREIGN KEY (tipoequipagropec) REFERENCES dominios.tipo_equip_agropec(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_a ADD CONSTRAINT eco_equip_agropec_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_plataforma_a ADD CONSTRAINT eco_plataforma_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_plataforma_a ADD CONSTRAINT eco_plataforma_a_tipoplataforma_fk FOREIGN KEY (tipoplataforma) REFERENCES dominios.tipo_plataforma(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_dique_a ADD CONSTRAINT hid_dique_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_antropizada_fk FOREIGN KEY (antropizada) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_secundaria_fk FOREIGN KEY (secundaria) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_classificacaoporte_fk FOREIGN KEY (classificacaoporte) REFERENCES dominios.classificacao_porte(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_densidade_fk FOREIGN KEY (densidade) REFERENCES dominios.densidade(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.veg_veg_area_contato_a ADD CONSTRAINT veg_veg_area_contato_a_tipoveg_fk FOREIGN KEY (tipoveg) REFERENCES dominios.tipo_vegetacao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_dique_l ADD CONSTRAINT hid_dique_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_geod_topo_controle_p ADD CONSTRAINT pto_pto_geod_topo_controle_p_sistemageodesico_fk FOREIGN KEY (sistemageodesico) REFERENCES dominios.sistema_geodesico(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_geod_topo_controle_p ADD CONSTRAINT pto_pto_geod_topo_controle_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_geod_topo_controle_p ADD CONSTRAINT pto_pto_geod_topo_controle_p_tiporef_fk FOREIGN KEY (tiporef) REFERENCES dominios.tipo_ref(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.pto_pto_geod_topo_controle_p ADD CONSTRAINT pto_pto_geod_topo_controle_p_referencialaltim_fk FOREIGN KEY (referencialaltim) REFERENCES dominios.referencial_altim(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_tipoquebramolhe_fk FOREIGN KEY (tipoquebramolhe) REFERENCES dominios.tipo_quebra_molhe(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_situacaoemagua_fk FOREIGN KEY (situacaoemagua) REFERENCES dominios.situacao_em_agua(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_quebramar_molhe_a ADD CONSTRAINT hid_quebramar_molhe_a_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_pais_a ADD CONSTRAINT lpal_pais_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.enc_zona_linhas_energia_comunicacao_a ADD CONSTRAINT enc_zona_linhas_energia_comunicacao_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_tipoequipagropec_fk FOREIGN KEY (tipoequipagropec) REFERENCES dominios.tipo_equip_agropec(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_l ADD CONSTRAINT eco_equip_agropec_l_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_tipoequipagropec_fk FOREIGN KEY (tipoequipagropec) REFERENCES dominios.tipo_equip_agropec(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_situacaofisica_fk FOREIGN KEY (situacaofisica) REFERENCES dominios.situacao_fisica(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.eco_equip_agropec_p ADD CONSTRAINT eco_equip_agropec_p_operacional_fk FOREIGN KEY (operacional) REFERENCES dominios.booleano_estendido(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.hid_dique_p ADD CONSTRAINT hid_dique_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_area_especial_a ADD CONSTRAINT lpal_area_especial_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_p ADD CONSTRAINT rel_terreno_erodido_p_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_p ADD CONSTRAINT rel_terreno_erodido_p_tipoerosao_fk FOREIGN KEY (tipoerosao) REFERENCES dominios.tipo_erosao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.rel_terreno_erodido_p ADD CONSTRAINT rel_terreno_erodido_p_situacaoterreno_fk FOREIGN KEY (situacaoterreno) REFERENCES dominios.situacao_terreno(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_area_pub_militar_a ADD CONSTRAINT lpal_area_pub_militar_a_geometriaaproximada_fk FOREIGN KEY (geometriaaproximada) REFERENCES dominios.booleano(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_area_pub_militar_a ADD CONSTRAINT lpal_area_pub_militar_a_jurisdicao_fk FOREIGN KEY (jurisdicao) REFERENCES dominios.jurisdicao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE pe.lpal_area_pub_militar_a ADD CONSTRAINT lpal_area_pub_militar_a_administracao_fk FOREIGN KEY (administracao) REFERENCES dominios.administracao(code) MATCH FULL ON UPDATE NO ACTION ON DELETE NO ACTION#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,5::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_a ADD CONSTRAINT edf_edif_pub_civil_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_chamine_check CHECK (chamine = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_p ADD CONSTRAINT edf_edif_industrial_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_classeativecon_check CHECK (classeativecon <@ ARRAY[33::SMALLINT,34::SMALLINT,8::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,30::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_p ADD CONSTRAINT edf_edif_servico_social_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_desenv_social_a ADD CONSTRAINT cb_area_desenv_social_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_chamine_check CHECK (chamine = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_industrial_a ADD CONSTRAINT edf_edif_industrial_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_classeativecon_check CHECK (classeativecon <@ ARRAY[33::SMALLINT,34::SMALLINT,8::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,30::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_servico_social_a ADD CONSTRAINT edf_edif_servico_social_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_classeativecon_check CHECK (classeativecon <@ ARRAY[12::SMALLINT,14::SMALLINT,15::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_tipoinstalmilitar_check CHECK (tipoinstalmilitar = ANY(ARRAY[13::SMALLINT,14::SMALLINT,15::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[6::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_p ADD CONSTRAINT edf_posto_policia_militar_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_de_propriedade_particular_a ADD CONSTRAINT cb_area_de_propriedade_particular_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_a ADD CONSTRAINT edf_edif_ext_mineral_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_terreno_check CHECK (terreno = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_tipolavoura_check CHECK (tipolavoura = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_finalidade_check CHECK (finalidade = ANY(ARRAY[4::SMALLINT]))#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_cultivopredominante_check CHECK (cultivopredominante <@ ARRAY[106::SMALLINT,72::SMALLINT,96::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_classificacaoporte_check CHECK (classificacaoporte = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,98::SMALLINT]))#
ALTER TABLE ge.ver_jardim_a ADD CONSTRAINT ver_jardim_a_tipoveg_check CHECK (tipoveg = ANY(ARRAY[2::SMALLINT]))#
ALTER TABLE ge.cb_area_ext_mineral_a ADD CONSTRAINT cb_area_ext_mineral_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ext_mineral_p ADD CONSTRAINT edf_edif_ext_mineral_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_ensino_a ADD CONSTRAINT cb_area_ensino_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_classeativecon_check CHECK (classeativecon <@ ARRAY[12::SMALLINT,14::SMALLINT,15::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[2::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_p ADD CONSTRAINT edf_posto_policia_rod_federal_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT])#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_classeativecon_check CHECK (classeativecon <@ ARRAY[27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,98::SMALLINT])#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[30::SMALLINT,31::SMALLINT,6::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_nivelatencao_check CHECK (nivelatencao = ANY(ARRAY[5::SMALLINT,6::SMALLINT,7::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_p ADD CONSTRAINT edf_edif_saude_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_est_med_fenomenos_a ADD CONSTRAINT cb_area_est_med_fenomenos_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_classeativecon_check CHECK (classeativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_finalidade_check CHECK (finalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[52::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_tipoedifcomercserv_check CHECK (tipoedifcomercserv <@ ARRAY[19::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_p ADD CONSTRAINT edf_posto_combustivel_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_energia_eletrica_a ADD CONSTRAINT cb_area_energia_eletrica_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_classeativecon_check CHECK (classeativecon <@ ARRAY[12::SMALLINT,14::SMALLINT,15::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[2::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_rod_federal_a ADD CONSTRAINT edf_posto_policia_rod_federal_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT])#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_classeativecon_check CHECK (classeativecon <@ ARRAY[27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,98::SMALLINT])#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[30::SMALLINT,31::SMALLINT,6::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_nivelatencao_check CHECK (nivelatencao = ANY(ARRAY[5::SMALLINT,6::SMALLINT,7::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_saude_a ADD CONSTRAINT edf_edif_saude_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_classeativecon_check CHECK (classeativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_finalidade_check CHECK (finalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[52::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_tipoedifcomercserv_check CHECK (tipoedifcomercserv <@ ARRAY[19::SMALLINT])#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_combustivel_a ADD CONSTRAINT edf_posto_combustivel_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_tipoedifagropec_check CHECK (tipoedifagropec <@ ARRAY[12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_p ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_arquibancada_l ADD CONSTRAINT laz_arquibancada_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_classeativecon_check CHECK (classeativecon <@ ARRAY[12::SMALLINT,14::SMALLINT,15::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[3::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT])#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[5::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_p ADD CONSTRAINT edf_posto_guarda_municipal_p_administracao_check CHECK (administracao <@ ARRAY[4::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[92::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_tipoediflazer_check CHECK (tipoediflazer = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_p ADD CONSTRAINT edf_edif_constr_lazer_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_arquibancada_a ADD CONSTRAINT laz_arquibancada_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_tipopistacomp_check CHECK (tipopistacomp = ANY(ARRAY[1::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_p ADD CONSTRAINT laz_pista_competicao_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[45::SMALLINT,74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_tipoedifport_check CHECK (tipoedifport = ANY(ARRAY[15::SMALLINT,26::SMALLINT,27::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_p ADD CONSTRAINT edf_edif_constr_portuaria_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_tipoedifagropec_check CHECK (tipoedifagropec <@ ARRAY[12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT])#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_agropec_ext_veg_pesca_a ADD CONSTRAINT edf_edif_agropec_ext_veg_pesca_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_tipopistacomp_check CHECK (tipopistacomp = ANY(ARRAY[1::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_l ADD CONSTRAINT laz_pista_competicao_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_revestimento_check CHECK (revestimento = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_canteirodivisorio_check CHECK (canteirodivisorio = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_tipopavimentacao_check CHECK (tipopavimentacao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_sargeta_check CHECK (sargeta = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_trafego_check CHECK (trafego = ANY(ARRAY[1::SMALLINT,2::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_meiofio_check CHECK (meiofio = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_a ADD CONSTRAINT cb_trecho_arruamento_a_tipoarruamento_check CHECK (tipoarruamento = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_classeativecon_check CHECK (classeativecon <@ ARRAY[12::SMALLINT,14::SMALLINT,15::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[3::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT])#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[5::SMALLINT]))#
ALTER TABLE ge.edf_posto_guarda_municipal_a ADD CONSTRAINT edf_posto_guarda_municipal_a_administracao_check CHECK (administracao <@ ARRAY[4::SMALLINT])#
ALTER TABLE ge.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_tipopistacomp_check CHECK (tipopistacomp = ANY(ARRAY[1::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao_a ADD CONSTRAINT laz_pista_competicao_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_revestimento_check CHECK (revestimento = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_canteirodivisorio_check CHECK (canteirodivisorio = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_tipopavimentacao_check CHECK (tipopavimentacao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_sargeta_check CHECK (sargeta = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_trafego_check CHECK (trafego = ANY(ARRAY[1::SMALLINT,2::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_meiofio_check CHECK (meiofio = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento_l ADD CONSTRAINT cb_trecho_arruamento_l_tipoarruamento_check CHECK (tipoarruamento = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[45::SMALLINT,74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_tipoedifport_check CHECK (tipoedifport <@ ARRAY[15::SMALLINT,26::SMALLINT,27::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_portuaria_a ADD CONSTRAINT edf_edif_constr_portuaria_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_ruina_p ADD CONSTRAINT laz_ruina_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_ruina_p ADD CONSTRAINT laz_ruina_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_ruina_p ADD CONSTRAINT laz_ruina_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_classeativecon_check CHECK (classeativecon <@ ARRAY[9::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,4::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT])#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_tipopostofisc_check CHECK (tipopostofisc = ANY(ARRAY[10::SMALLINT,12::SMALLINT,13::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_a ADD CONSTRAINT edf_posto_fiscal_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_sitio_arqueologico ADD CONSTRAINT laz_sitio_arqueologico_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_sitio_arqueologico ADD CONSTRAINT laz_sitio_arqueologico_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_passeio ADD CONSTRAINT cb_passeio_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_passeio ADD CONSTRAINT cb_passeio_pavimentacao_check CHECK (pavimentacao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_passeio ADD CONSTRAINT cb_passeio_calcada_check CHECK (calcada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_ruina_a ADD CONSTRAINT laz_ruina_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_ruina_a ADD CONSTRAINT laz_ruina_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_ruina_a ADD CONSTRAINT laz_ruina_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_classeativecon_check CHECK (classeativecon <@ ARRAY[9::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,4::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT])#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_tipopostofisc_check CHECK (tipopostofisc = ANY(ARRAY[10::SMALLINT,12::SMALLINT,13::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_fiscal_p ADD CONSTRAINT edf_posto_fiscal_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_praca_a ADD CONSTRAINT cb_praca_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_praca_a ADD CONSTRAINT cb_praca_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_p ADD CONSTRAINT edf_edificacao_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_p ADD CONSTRAINT edf_edif_residencial_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_urbana_isolada_a ADD CONSTRAINT cb_area_urbana_isolada_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_area_urbana_isolada_a ADD CONSTRAINT cb_area_urbana_isolada_a_tipoassociado_check CHECK (tipoassociado = ANY(ARRAY[1::SMALLINT,4::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_classeativecon_check CHECK (classeativecon <@ ARRAY[26::SMALLINT,30::SMALLINT,31::SMALLINT,33::SMALLINT,34::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_ensino_check CHECK (ensino = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_crista_check CHECK (crista = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_tipoedifrelig_check CHECK (tipoedifrelig = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_p ADD CONSTRAINT edf_edif_religiosa_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_retorno_p ADD CONSTRAINT cb_retorno_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edificacao ADD CONSTRAINT edf_edificacao_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_retorno_l ADD CONSTRAINT cb_retorno_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_residencial_a ADD CONSTRAINT edf_edif_residencial_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_classeativecon_check CHECK (classeativecon <@ ARRAY[26::SMALLINT,30::SMALLINT,31::SMALLINT,33::SMALLINT,34::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_ensino_check CHECK (ensino = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_crista_check CHECK (crista = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_tipoedifrelig_check CHECK (tipoedifrelig = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_religiosa_a ADD CONSTRAINT edf_edif_religiosa_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_campo_quadra ADD CONSTRAINT laz_campo_quadra_tipocampoquadra_check CHECK (tipocampoquadra = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra ADD CONSTRAINT laz_campo_quadra_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra ADD CONSTRAINT laz_campo_quadra_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra ADD CONSTRAINT laz_campo_quadra_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_retorno_a ADD CONSTRAINT cb_retorno_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_classeativecon_check CHECK (classeativecon <@ ARRAY[35::SMALLINT,95::SMALLINT])#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_p ADD CONSTRAINT edf_banheiro_publico_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_largo_a ADD CONSTRAINT cb_largo_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_area_industrial_a ADD CONSTRAINT cb_area_industrial_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao ADD CONSTRAINT laz_pista_competicao_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao ADD CONSTRAINT laz_pista_competicao_tipopistacomp_check CHECK (tipopistacomp = ANY(ARRAY[1::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao ADD CONSTRAINT laz_pista_competicao_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_pista_competicao ADD CONSTRAINT laz_pista_competicao_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_classeativecon_check CHECK (classeativecon <@ ARRAY[5::SMALLINT,7::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_tipoedifabast_check CHECK (tipoedifabast = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_p ADD CONSTRAINT edf_edif_abast_agua_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_arquibancada ADD CONSTRAINT laz_arquibancada_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_arquibancada ADD CONSTRAINT laz_arquibancada_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_arquibancada ADD CONSTRAINT laz_arquibancada_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_p ADD CONSTRAINT edf_edif_habitacional_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_classeativecon_check CHECK (classeativecon <@ ARRAY[35::SMALLINT,95::SMALLINT])#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_banheiro_publico_a ADD CONSTRAINT edf_banheiro_publico_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_classeativecon_check CHECK (classeativecon <@ ARRAY[5::SMALLINT,7::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_tipoedifabast_check CHECK (tipoedifabast = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_abast_agua_a ADD CONSTRAINT edf_edif_abast_agua_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_habitacional_a ADD CONSTRAINT edf_edif_habitacional_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_classeativecon_check CHECK (classeativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_tipoedifrod_check CHECK (tipoedifrod <@ ARRAY[10::SMALLINT,13::SMALLINT,15::SMALLINT,20::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_p ADD CONSTRAINT edf_edif_rodoviaria_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_modaluso_check CHECK (modaluso <@ ARRAY[4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_tipopavimentacao_check CHECK (tipopavimentacao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_necessitamanutencao_check CHECK (necessitamanutencao = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_tipotunel_check CHECK (tipotunel = ANY(ARRAY[1::SMALLINT,2::SMALLINT]))#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_posicaopista_check CHECK (posicaopista = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_tunel_a ADD CONSTRAINT cb_tunel_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.emu_poste_sinalizacao_p ADD CONSTRAINT emu_poste_sinalizacao_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_poste_sinalizacao_p ADD CONSTRAINT emu_poste_sinalizacao_p_tipoposte_check CHECK (tipoposte <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.emu_poste_sinalizacao_p ADD CONSTRAINT emu_poste_sinalizacao_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_classeativecon_check CHECK (classeativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_tipoedifrod_check CHECK (tipoedifrod <@ ARRAY[10::SMALLINT,13::SMALLINT,15::SMALLINT,20::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_rodoviaria_a ADD CONSTRAINT edf_edif_rodoviaria_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_revestimento_check CHECK (revestimento = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT]))#
ALTER TABLE ge.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_ciclovia_l ADD CONSTRAINT emu_ciclovia_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_area_lazer_a ADD CONSTRAINT cb_area_lazer_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[92::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_tipoediflazer_check CHECK (tipoediflazer = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_lazer_a ADD CONSTRAINT edf_edif_constr_lazer_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_classeativecon_check CHECK (classeativecon <@ ARRAY[6::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_modalidade_check CHECK (modalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_tipoedifcomunic_check CHECK (tipoedifcomunic <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_a ADD CONSTRAINT edf_edif_comunic_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_duto_a ADD CONSTRAINT cb_area_duto_a_areavalvulas_check CHECK (areavalvulas = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_area_duto_a ADD CONSTRAINT cb_area_duto_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_area_duto_a ADD CONSTRAINT cb_area_duto_a_bombeamento_check CHECK (bombeamento = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_tipoedifturist_check CHECK (tipoedifturist = ANY(ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_classeativecon_check CHECK (classeativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[92::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_tombada_check CHECK (tombada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_ovgd_check CHECK (ovgd = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_p ADD CONSTRAINT edf_edif_constr_turistica_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_classeativecon_check CHECK (classeativecon <@ ARRAY[6::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_modalidade_check CHECK (modalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_tipoedifcomunic_check CHECK (tipoedifcomunic <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comunic_p ADD CONSTRAINT edf_edif_comunic_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,5::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_civil_p ADD CONSTRAINT edf_edif_pub_civil_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_canteiro_central_l ADD CONSTRAINT cb_canteiro_central_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_canteiro_central_l ADD CONSTRAINT cb_canteiro_central_l_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_canteiro_central_a ADD CONSTRAINT cb_canteiro_central_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_canteiro_central_a ADD CONSTRAINT cb_canteiro_central_a_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_area_ruinas_a ADD CONSTRAINT cb_area_ruinas_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[2::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_l ADD CONSTRAINT emu_escadaria_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_classeativecon_check CHECK (classeativecon <@ ARRAY[35::SMALLINT,5::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[37::SMALLINT,74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_tipoedifsaneam_check CHECK (tipoedifsaneam = ANY(ARRAY[3::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_p ADD CONSTRAINT edf_edif_saneamento_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_classeativecon_check CHECK (classeativecon <@ ARRAY[2::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_tipoedifenergia_check CHECK (tipoedifenergia <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_p ADD CONSTRAINT edf_edif_energia_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_tipocampoquadra_check CHECK (tipocampoquadra = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra_a ADD CONSTRAINT laz_campo_quadra_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[2::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_a ADD CONSTRAINT emu_escadaria_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_retorno ADD CONSTRAINT cb_retorno_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_entroncamento_area_a ADD CONSTRAINT cb_entroncamento_area_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_entroncamento_area_a ADD CONSTRAINT cb_entroncamento_area_a_tipoentroncamento_check CHECK (tipoentroncamento = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_classeativecon_check CHECK (classeativecon <@ ARRAY[35::SMALLINT,5::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[37::SMALLINT,74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_tipoedifsaneam_check CHECK (tipoedifsaneam = ANY(ARRAY[3::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_saneamento_a ADD CONSTRAINT edf_edif_saneamento_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_classeativecon_check CHECK (classeativecon <@ ARRAY[2::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_tipoedifenergia_check CHECK (tipoedifenergia <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_energia_a ADD CONSTRAINT edf_edif_energia_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_tipocampoquadra_check CHECK (tipocampoquadra = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_campo_quadra_p ADD CONSTRAINT laz_campo_quadra_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_tipoponte_check CHECK (tipoponte = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,7::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_tipopavimentacao_check CHECK (tipopavimentacao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_necessitamanutencao_check CHECK (necessitamanutencao = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_posicaopista_check CHECK (posicaopista = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_ponte_a ADD CONSTRAINT cb_ponte_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT])#
ALTER TABLE ge.cb_area_abast_agua_a ADD CONSTRAINT cb_area_abast_agua_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_area_habitacional_a ADD CONSTRAINT cb_area_habitacional_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[2::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_escadaria_p ADD CONSTRAINT emu_escadaria_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_area_comerc_serv_a ADD CONSTRAINT cb_area_comerc_serv_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_poste_p ADD CONSTRAINT cb_poste_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_poste_p ADD CONSTRAINT cb_poste_p_tipoposte_check CHECK (tipoposte <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_poste_p ADD CONSTRAINT cb_poste_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_passeio_l ADD CONSTRAINT cb_passeio_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_passeio_l ADD CONSTRAINT cb_passeio_l_pavimentacao_check CHECK (pavimentacao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_passeio_l ADD CONSTRAINT cb_passeio_l_calcada_check CHECK (calcada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,7::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_a ADD CONSTRAINT edf_edif_policia_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,92::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edificacao_a ADD CONSTRAINT edf_edificacao_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_passeio_a ADD CONSTRAINT cb_passeio_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_passeio_a ADD CONSTRAINT cb_passeio_a_pavimentacao_check CHECK (pavimentacao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_passeio_a ADD CONSTRAINT cb_passeio_a_calcada_check CHECK (calcada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_classeativecon_check CHECK (classeativecon <@ ARRAY[11::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_tiporepdiplomatica_check CHECK (tiporepdiplomatica = ANY(ARRAY[2::SMALLINT,3::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_a ADD CONSTRAINT edf_representacao_diplomatica_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT])#
ALTER TABLE ge.cb_quadra_a ADD CONSTRAINT cb_quadra_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,7::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_tipoedifpubcivil_check CHECK (tipoedifpubcivil <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_policia_p ADD CONSTRAINT edf_edif_policia_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_classeativecon_check CHECK (classeativecon <@ ARRAY[11::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_tiporepdiplomatica_check CHECK (tiporepdiplomatica = ANY(ARRAY[2::SMALLINT,3::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_representacao_diplomatica_p ADD CONSTRAINT edf_representacao_diplomatica_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_finalidade_check CHECK (finalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[18::SMALLINT,22::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_tipoedifcomercserv_check CHECK (tipoedifcomercserv <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_p ADD CONSTRAINT edf_edif_comerc_serv_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_a ADD CONSTRAINT edf_edif_constr_est_med_fen_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_tipoedifturist_check CHECK (tipoedifturist = ANY(ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_classeativecon_check CHECK (classeativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[92::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_tombada_check CHECK (tombada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_ovgd_check CHECK (ovgd = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_turistica_a ADD CONSTRAINT edf_edif_constr_turistica_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_rampa_p ADD CONSTRAINT emu_rampa_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_rampa_l ADD CONSTRAINT emu_rampa_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_est_med_fen_p ADD CONSTRAINT edf_edif_constr_est_med_fen_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_finalidade_check CHECK (finalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[18::SMALLINT,22::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_tipoedifcomercserv_check CHECK (tipoedifcomercserv <@ ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_comerc_serv_a ADD CONSTRAINT edf_edif_comerc_serv_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_canteiro_central ADD CONSTRAINT cb_canteiro_central_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_canteiro_central ADD CONSTRAINT cb_canteiro_central_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_rampa_a ADD CONSTRAINT emu_rampa_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_delimitacao_fisica_l ADD CONSTRAINT cb_delimitacao_fisica_l_eletrificada_check CHECK (eletrificada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_delimitacao_fisica_l ADD CONSTRAINT cb_delimitacao_fisica_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_delimitacao_fisica_l ADD CONSTRAINT cb_delimitacao_fisica_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_delimitacao_fisica_l ADD CONSTRAINT cb_delimitacao_fisica_l_tipodelimfis_check CHECK (tipodelimfis = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_area_estrut_transporte_a ADD CONSTRAINT cb_area_estrut_transporte_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso_p ADD CONSTRAINT emu_acesso_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_matconstr_check CHECK (matconstr = ANY(ARRAY[3::SMALLINT,8::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_elevador_l ADD CONSTRAINT emu_elevador_l_tipoelevador_check CHECK (tipoelevador = ANY(ARRAY[2::SMALLINT,3::SMALLINT]))#
ALTER TABLE ge.laz_sitio_arqueologico_p ADD CONSTRAINT laz_sitio_arqueologico_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_sitio_arqueologico_p ADD CONSTRAINT laz_sitio_arqueologico_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_matconstr_check CHECK (matconstr = ANY(ARRAY[3::SMALLINT,8::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_elevador_a ADD CONSTRAINT emu_elevador_a_tipoelevador_check CHECK (tipoelevador = ANY(ARRAY[2::SMALLINT,3::SMALLINT]))#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso_a ADD CONSTRAINT emu_acesso_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_sitio_arqueologico_a ADD CONSTRAINT laz_sitio_arqueologico_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_sitio_arqueologico_a ADD CONSTRAINT laz_sitio_arqueologico_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.ver_arvore_isolada_p ADD CONSTRAINT ver_arvore_isolada_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_matconstr_check CHECK (matconstr = ANY(ARRAY[3::SMALLINT,8::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_elevador_p ADD CONSTRAINT emu_elevador_p_tipoelevador_check CHECK (tipoelevador = ANY(ARRAY[2::SMALLINT,3::SMALLINT]))#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_tipopavimentacao_check CHECK (tipopavimentacao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_necessitamanutencao_check CHECK (necessitamanutencao = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_posicaopista_check CHECK (posicaopista = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_passagem_elevada_viaduto_a ADD CONSTRAINT cb_passagem_elevada_viaduto_a_tipopassagviad_check CHECK (tipopassagviad = ANY(ARRAY[5::SMALLINT,6::SMALLINT]))#
ALTER TABLE ge.cb_area_religiosa_a ADD CONSTRAINT cb_area_religiosa_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_classeativecon_check CHECK (classeativecon <@ ARRAY[17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_a ADD CONSTRAINT edf_edif_ensino_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_comunicacao_a ADD CONSTRAINT cb_area_comunicacao_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_classeativecon_check CHECK (classeativecon <@ ARRAY[15::SMALLINT,30::SMALLINT,33::SMALLINT,34::SMALLINT,7::SMALLINT,8::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_tipoequipdesenvsocial_check CHECK (tipoequipdesenvsocial = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,19::SMALLINT,2::SMALLINT,5::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_localizacaoequipdesenvsocial_check CHECK (localizacaoequipdesenvsocial = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_p ADD CONSTRAINT edf_edif_desenv_social_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_revestimento_check CHECK (revestimento = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_canteirodivisorio_check CHECK (canteirodivisorio = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_tipopavimentacao_check CHECK (tipopavimentacao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_sargeta_check CHECK (sargeta = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_trafego_check CHECK (trafego = ANY(ARRAY[1::SMALLINT,2::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_meiofio_check CHECK (meiofio = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_trecho_arruamento ADD CONSTRAINT cb_trecho_arruamento_tipoarruamento_check CHECK (tipoarruamento = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso ADD CONSTRAINT emu_acesso_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_tipoedifmetroferrov_check CHECK (tipoedifmetroferrov <@ ARRAY[15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_p ADD CONSTRAINT edf_edif_metro_ferroviaria_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_piscina_a ADD CONSTRAINT laz_piscina_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_piscina_a ADD CONSTRAINT laz_piscina_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.laz_piscina_a ADD CONSTRAINT laz_piscina_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.emu_acesso_l ADD CONSTRAINT emu_acesso_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_classeativecon_check CHECK (classeativecon <@ ARRAY[17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_ensino_p ADD CONSTRAINT edf_edif_ensino_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_classeativecon_check CHECK (classeativecon <@ ARRAY[15::SMALLINT,30::SMALLINT,33::SMALLINT,34::SMALLINT,7::SMALLINT,8::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_tipoequipdesenvsocial_check CHECK (tipoequipdesenvsocial = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[1::SMALLINT,19::SMALLINT,2::SMALLINT,5::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_localizacaoequipdesenvsocial_check CHECK (localizacaoequipdesenvsocial = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_desenv_social_a ADD CONSTRAINT edf_edif_desenv_social_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_tipoedifmetroferrov_check CHECK (tipoedifmetroferrov <@ ARRAY[15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_metro_ferroviaria_a ADD CONSTRAINT edf_edif_metro_ferroviaria_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.laz_ruina ADD CONSTRAINT laz_ruina_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.laz_ruina ADD CONSTRAINT laz_ruina_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.laz_ruina ADD CONSTRAINT laz_ruina_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_classeativecon_check CHECK (classeativecon <@ ARRAY[12::SMALLINT,14::SMALLINT,15::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[99::SMALLINT])#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_tipoinstalmilitar_check CHECK (tipoinstalmilitar = ANY(ARRAY[13::SMALLINT,14::SMALLINT,15::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[6::SMALLINT]))#
ALTER TABLE ge.edf_posto_policia_militar_a ADD CONSTRAINT edf_posto_policia_militar_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_coletiva_check CHECK (coletiva = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_isolada_check CHECK (isolada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_p ADD CONSTRAINT edf_hab_indigena_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_revestimento_check CHECK (revestimento = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_canteirodivisorio_check CHECK (canteirodivisorio = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_tipopavimentacao_check CHECK (tipopavimentacao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_trafego_check CHECK (trafego = ANY(ARRAY[1::SMALLINT,2::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_trechoemperimetrourbano_check CHECK (trechoemperimetrourbano = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_acostamento_check CHECK (acostamento = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_trecho_rodoviario_a ADD CONSTRAINT cb_trecho_rodoviario_a_tipotrechorod_check CHECK (tipotrechorod = ANY(ARRAY[2::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT]))#
ALTER TABLE ge.cb_area_saneamento_a ADD CONSTRAINT cb_area_saneamento_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_coletiva_check CHECK (coletiva = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_isolada_check CHECK (isolada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_hab_indigena_a ADD CONSTRAINT edf_hab_indigena_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_tipotravessiaped_check CHECK (tipotravessiaped = ANY(ARRAY[10::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_travessia_pedrestre_a ADD CONSTRAINT cb_travessia_pedrestre_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_area_agropec_ext_veg_pesca_a ADD CONSTRAINT cb_area_agropec_ext_veg_pesca_a_destinadoa_check CHECK (destinadoa = ANY(ARRAY[18::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,43::SMALLINT,44::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.cb_area_agropec_ext_veg_pesca_a ADD CONSTRAINT cb_area_agropec_ext_veg_pesca_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,31::SMALLINT,7::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_tipoinstalmilitar_check CHECK (tipoinstalmilitar = ANY(ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_a ADD CONSTRAINT edf_edif_pub_militar_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_tipoedifaero_check CHECK (tipoedifaero <@ ARRAY[15::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_p ADD CONSTRAINT edf_edif_constr_aeroportuaria_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_classeativecon_check CHECK (classeativecon <@ ARRAY[10::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,31::SMALLINT,7::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_grupoativecon_check CHECK (grupoativecon <@ ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_tipoinstalmilitar_check CHECK (tipoinstalmilitar = ANY(ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_tipousoedif_check CHECK (tipousoedif = ANY(ARRAY[1::SMALLINT,2::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_pub_militar_p ADD CONSTRAINT edf_edif_pub_militar_p_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_modaluso_check CHECK (modaluso <@ ARRAY[4::SMALLINT])#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_finalidadepatio_check CHECK (finalidadepatio <@ ARRAY[3::SMALLINT])#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_publico_check CHECK (publico = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.cb_estacionamento_a ADD CONSTRAINT cb_estacionamento_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_espelho_dagua_a ADD CONSTRAINT cb_espelho_dagua_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_classeativecon_check CHECK (classeativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_grupoativecon_check CHECK (grupoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_tipoedifaero_check CHECK (tipoedifaero <@ ARRAY[15::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,30::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_turistica_check CHECK (turistica = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_divisaoativecon_check CHECK (divisaoativecon <@ ARRAY[95::SMALLINT])#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_proprioadm_check CHECK (proprioadm = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE ge.edf_edif_constr_aeroportuaria_a ADD CONSTRAINT edf_edif_constr_aeroportuaria_a_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE ge.cb_area_saude_a ADD CONSTRAINT cb_area_saude_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_parque_urbano ADD CONSTRAINT laz_parque_urbano_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude ADD CONSTRAINT sau_org_saude_classeativecon_check CHECK (classeativecon = ANY(ARRAY[10::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,32::SMALLINT,36::SMALLINT,7::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude ADD CONSTRAINT sau_org_saude_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[30::SMALLINT,31::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude ADD CONSTRAINT sau_org_saude_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo ADD CONSTRAINT laz_complexo_desportivo_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.eco_frigorifico_matadouro ADD CONSTRAINT eco_frigorifico_matadouro_frigorifico_check CHECK (frigorifico = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.eco_frigorifico_matadouro ADD CONSTRAINT eco_frigorifico_matadouro_secaoativecon_check CHECK (secaoativecon = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_religiosa ADD CONSTRAINT edu_org_ensino_religiosa_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_religiosa ADD CONSTRAINT edu_org_ensino_religiosa_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_religiosa ADD CONSTRAINT edu_org_ensino_religiosa_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.lpal_localidade ADD CONSTRAINT lpal_localidade_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.adm_org_comerc_serv ADD CONSTRAINT adm_org_comerc_serv_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,2::SMALLINT,20::SMALLINT,24::SMALLINT,25::SMALLINT,27::SMALLINT,29::SMALLINT,30::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,45::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,74::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.adm_org_comerc_serv ADD CONSTRAINT adm_org_comerc_serv_finalidade_check CHECK (finalidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_estande_de_tiro ADD CONSTRAINT laz_estande_de_tiro_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.lpal_aglomerado_rural_isolado ADD CONSTRAINT lpal_aglomerado_rural_isolado_tipoaglomrurisol_check CHECK (tipoaglomrurisol = ANY(ARRAY[5::SMALLINT,6::SMALLINT,7::SMALLINT]))#
ALTER TABLE complexos.lpal_aglomerado_rural_isolado ADD CONSTRAINT lpal_aglomerado_rural_isolado_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.cb_assentamento_precario ADD CONSTRAINT cb_assentamento_precario_tipoassprec_check CHECK (tipoassprec = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.lpal_capital ADD CONSTRAINT lpal_capital_tipocapital_check CHECK (tipocapital = ANY(ARRAY[2::SMALLINT,3::SMALLINT]))#
ALTER TABLE complexos.lpal_capital ADD CONSTRAINT lpal_capital_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.enc_complexo_comunicacao ADD CONSTRAINT enc_complexo_comunicacao_classeativecon_check CHECK (classeativecon = ANY(ARRAY[6::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_classeativecon_check CHECK (classeativecon = ANY(ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_administracaodireta_check CHECK (administracaodireta = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_poderpublico_check CHECK (poderpublico = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.adm_org_pub_civil ADD CONSTRAINT adm_org_pub_civil_tipoorgcivil_check CHECK (tipoorgcivil = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,2::SMALLINT,22::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_recreativo ADD CONSTRAINT laz_complexo_recreativo_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_militar ADD CONSTRAINT sau_org_saude_militar_classeativecon_check CHECK (classeativecon = ANY(ARRAY[10::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,32::SMALLINT,36::SMALLINT,7::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_militar ADD CONSTRAINT sau_org_saude_militar_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[30::SMALLINT,31::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_militar ADD CONSTRAINT sau_org_saude_militar_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.adm_org_pub_militar ADD CONSTRAINT adm_org_pub_militar_classeativecon_check CHECK (classeativecon = ANY(ARRAY[12::SMALLINT,13::SMALLINT,14::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,32::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.adm_org_pub_militar ADD CONSTRAINT adm_org_pub_militar_tipoorgmilitar_check CHECK (tipoorgmilitar = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.adm_org_pub_militar ADD CONSTRAINT adm_org_pub_militar_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_modaluso_check CHECK (modaluso <@ ARRAY[5::SMALLINT])#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_ferroviario ADD CONSTRAINT emu_terminal_ferroviario_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_kartodromo ADD CONSTRAINT laz_kartodromo_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.adm_org_agropec_ext_veg_pesca ADD CONSTRAINT adm_org_agropec_ext_veg_pesca_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[1::SMALLINT,14::SMALLINT,2::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,55::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.adm_org_religiosa ADD CONSTRAINT adm_org_religiosa_classeativecon_check CHECK (classeativecon = ANY(ARRAY[16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.adm_org_religiosa ADD CONSTRAINT adm_org_religiosa_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_autodromo ADD CONSTRAINT laz_autodromo_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_modaluso_check CHECK (modaluso <@ ARRAY[4::SMALLINT])#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1::SMALLINT]))#
ALTER TABLE complexos.rod_estacao_rodoviaria ADD CONSTRAINT rod_estacao_rodoviaria_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.sau_especialidade_medica ADD CONSTRAINT sau_especialidade_medica_nomeespecialidade_check CHECK (nomeespecialidade = ANY(ARRAY[10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,4::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,44::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT]))#
ALTER TABLE complexos.sau_org_servico_social_pub ADD CONSTRAINT sau_org_servico_social_pub_classeativecon_check CHECK (classeativecon = ANY(ARRAY[33::SMALLINT,34::SMALLINT,8::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_servico_social_pub ADD CONSTRAINT sau_org_servico_social_pub_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[15::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_servico_social_pub ADD CONSTRAINT sau_org_servico_social_pub_tipoorgsvsocial_check CHECK (tipoorgsvsocial = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_servico_social_pub ADD CONSTRAINT sau_org_servico_social_pub_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.lpal_aglom_rural_de_ext_urbana ADD CONSTRAINT lpal_aglom_rural_de_ext_urbana_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_hipodromo ADD CONSTRAINT laz_hipodromo_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.hid_arquipelago ADD CONSTRAINT hid_arquipelago_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_marina ADD CONSTRAINT laz_marina_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.rdr_curso_dagua ADD CONSTRAINT rdr_curso_dagua_dominialidade_check CHECK (dominialidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_velodromo ADD CONSTRAINT laz_velodromo_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.lpal_vila ADD CONSTRAINT lpal_vila_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_zoologico ADD CONSTRAINT laz_jardim_zoologico_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_modaluso_check CHECK (modaluso <@ ARRAY[14::SMALLINT])#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_tipocomplexoportuario_check CHECK (tipocomplexoportuario = ANY(ARRAY[30::SMALLINT,31::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_tipotransporte_check CHECK (tipotransporte = ANY(ARRAY[21::SMALLINT,22::SMALLINT,95::SMALLINT,98::SMALLINT]))#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_portosempapel_check CHECK (portosempapel = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.hdv_complexo_portuario ADD CONSTRAINT hdv_complexo_portuario_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_modaluso_check CHECK (modaluso <@ ARRAY[4::SMALLINT])#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_rodoviario ADD CONSTRAINT emu_terminal_rodoviario_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_parque_tematico ADD CONSTRAINT laz_parque_tematico_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_campo_aeromodelismo ADD CONSTRAINT laz_campo_aeromodelismo_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_hipica ADD CONSTRAINT laz_hipica_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_privada ADD CONSTRAINT edu_org_ensino_privada_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_privada ADD CONSTRAINT edu_org_ensino_privada_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_privada ADD CONSTRAINT edu_org_ensino_privada_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.sb_complexo_abast_agua ADD CONSTRAINT sb_complexo_abast_agua_classeativecon_check CHECK (classeativecon = ANY(ARRAY[5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sb_complexo_abast_agua ADD CONSTRAINT sb_complexo_abast_agua_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.sb_complexo_abast_agua ADD CONSTRAINT sb_complexo_abast_agua_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_transporte ADD CONSTRAINT tra_estrut_transporte_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.enc_complexo_gerador_energia_eletrica ADD CONSTRAINT enc_complexo_gerador_energia_eletrica_classeativecon_check CHECK (classeativecon = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.enc_complexo_gerador_energia_eletrica ADD CONSTRAINT enc_complexo_gerador_energia_eletrica_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_campo_de_golfe ADD CONSTRAINT laz_campo_de_golfe_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.tra_entroncamento ADD CONSTRAINT tra_entroncamento_tipoentroncamento_check CHECK (tipoentroncamento = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.eco_madeireira ADD CONSTRAINT eco_madeireira_secaoativecon_check CHECK (secaoativecon = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_privada ADD CONSTRAINT sau_org_saude_privada_classeativecon_check CHECK (classeativecon = ANY(ARRAY[10::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,32::SMALLINT,36::SMALLINT,7::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_privada ADD CONSTRAINT sau_org_saude_privada_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[30::SMALLINT,31::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_privada ADD CONSTRAINT sau_org_saude_privada_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_parque_aquatico ADD CONSTRAINT laz_parque_aquatico_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.adm_org_industrial ADD CONSTRAINT adm_org_industrial_secaoativecon_check CHECK (secaoativecon = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.lpal_aglomerado_rural ADD CONSTRAINT lpal_aglomerado_rural_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_jardim_botanico ADD CONSTRAINT laz_jardim_botanico_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_clube_social ADD CONSTRAINT laz_clube_social_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_pesque_pague ADD CONSTRAINT laz_pesque_pague_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.tra_estrut_apoio ADD CONSTRAINT tra_estrut_apoio_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.sb_complexo_saneamento ADD CONSTRAINT sb_complexo_saneamento_classeativecon_check CHECK (classeativecon = ANY(ARRAY[5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sb_complexo_saneamento ADD CONSTRAINT sb_complexo_saneamento_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.sb_complexo_saneamento ADD CONSTRAINT sb_complexo_saneamento_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_modaluso_check CHECK (modaluso <@ ARRAY[6::SMALLINT])#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_metroviaria ADD CONSTRAINT fer_estacao_metroviaria_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_pub ADD CONSTRAINT edu_org_ensino_pub_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_pub ADD CONSTRAINT edu_org_ensino_pub_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_pub ADD CONSTRAINT edu_org_ensino_pub_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_pub ADD CONSTRAINT sau_org_saude_pub_classeativecon_check CHECK (classeativecon = ANY(ARRAY[10::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,32::SMALLINT,36::SMALLINT,7::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_pub ADD CONSTRAINT sau_org_saude_pub_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[30::SMALLINT,31::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_saude_pub ADD CONSTRAINT sau_org_saude_pub_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_militar ADD CONSTRAINT edu_org_ensino_militar_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_militar ADD CONSTRAINT edu_org_ensino_militar_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino_militar ADD CONSTRAINT edu_org_ensino_militar_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.ver_area_verde ADD CONSTRAINT ver_area_verde_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.ver_area_verde ADD CONSTRAINT ver_area_verde_paisagismo_check CHECK (paisagismo = ANY(ARRAY[1::SMALLINT]))#
ALTER TABLE complexos.lpal_cidade ADD CONSTRAINT lpal_cidade_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_divisaoativecon_check CHECK (divisaoativecon = ANY(ARRAY[92::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_cultura_check CHECK (cultura = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.laz_complexo_desportivo_lazer ADD CONSTRAINT laz_complexo_desportivo_lazer_turistico_check CHECK (turistico = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino ADD CONSTRAINT edu_org_ensino_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino ADD CONSTRAINT edu_org_ensino_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.edu_org_ensino ADD CONSTRAINT edu_org_ensino_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_modaluso_check CHECK (modaluso <@ ARRAY[5::SMALLINT])#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1::SMALLINT]))#
ALTER TABLE complexos.fer_estacao_ferroviaria ADD CONSTRAINT fer_estacao_ferroviaria_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.adm_instituicao_publica ADD CONSTRAINT adm_instituicao_publica_poderpublico_check CHECK (poderpublico = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.adm_instituicao_publica ADD CONSTRAINT adm_instituicao_publica_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[15::SMALLINT,16::SMALLINT,19::SMALLINT,20::SMALLINT,23::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.adm_instituicao_publica ADD CONSTRAINT adm_instituicao_publica_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.sau_org_servico_social ADD CONSTRAINT sau_org_servico_social_classeativecon_check CHECK (classeativecon = ANY(ARRAY[33::SMALLINT,34::SMALLINT,8::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_servico_social ADD CONSTRAINT sau_org_servico_social_grupoativecon_check CHECK (grupoativecon = ANY(ARRAY[15::SMALLINT,32::SMALLINT,6::SMALLINT,8::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_servico_social ADD CONSTRAINT sau_org_servico_social_tipoorgsvsocial_check CHECK (tipoorgsvsocial = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.sau_org_servico_social ADD CONSTRAINT sau_org_servico_social_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_modaluso_check CHECK (modaluso <@ ARRAY[9::SMALLINT])#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_tipocomplexoaero_check CHECK (tipocomplexoaero = ANY(ARRAY[23::SMALLINT,24::SMALLINT,25::SMALLINT]))#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_classificacao_check CHECK (classificacao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.aer_complexo_aeroportuario ADD CONSTRAINT aer_complexo_aeroportuario_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.enc_subest_transm_distrib_energia_eletrica ADD CONSTRAINT enc_subest_transm_distrib_energia_eletrica_classeativecon_check CHECK (classeativecon = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.enc_subest_transm_distrib_energia_eletrica ADD CONSTRAINT enc_subest_transm_distrib_energia_eletrica_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT])#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_tipoestrut_check CHECK (tipoestrut = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE complexos.emu_terminal_hidroviario ADD CONSTRAINT emu_terminal_hidroviario_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE complexos.adm_org_ext_mineral ADD CONSTRAINT adm_org_ext_mineral_secaoativecon_check CHECK (secaoativecon = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica ADD CONSTRAINT aux_descontinuidade_geometrica_categoria_check CHECK (categoria = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica ADD CONSTRAINT aux_descontinuidade_geometrica_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica ADD CONSTRAINT aux_descontinuidade_geometrica_motivodescontinuidade_check CHECK (motivodescontinuidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica_l ADD CONSTRAINT aux_descontinuidade_geometrica_l_categoria_check CHECK (categoria = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica_l ADD CONSTRAINT aux_descontinuidade_geometrica_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica_l ADD CONSTRAINT aux_descontinuidade_geometrica_l_motivodescontinuidade_check CHECK (motivodescontinuidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica_p ADD CONSTRAINT aux_descontinuidade_geometrica_p_categoria_check CHECK (categoria = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica_p ADD CONSTRAINT aux_descontinuidade_geometrica_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE public.aux_descontinuidade_geometrica_p ADD CONSTRAINT aux_descontinuidade_geometrica_p_motivodescontinuidade_check CHECK (motivodescontinuidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_matconstr_check CHECK (matconstr <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.hdv_eclusa_p ADD CONSTRAINT hdv_eclusa_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_dique ADD CONSTRAINT hid_dique_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_dique ADD CONSTRAINT hid_dique_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_antropizada_check CHECK (antropizada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_secundaria_check CHECK (secundaria = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_classificacaoporte_check CHECK (classificacaoporte = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,98::SMALLINT]))#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_densidade_check CHECK (densidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_caatinga_a ADD CONSTRAINT veg_caatinga_a_tipoveg_check CHECK (tipoveg = ANY(ARRAY[11::SMALLINT]))#
ALTER TABLE pe.lpal_unidade_protegida_a ADD CONSTRAINT lpal_unidade_protegida_a_tipounidprotegida_check CHECK (tipounidprotegida = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT]))#
ALTER TABLE pe.lpal_unidade_protegida_a ADD CONSTRAINT lpal_unidade_protegida_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.lpal_unidade_protegida_a ADD CONSTRAINT lpal_unidade_protegida_a_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.lpal_unidade_protegida_a ADD CONSTRAINT lpal_unidade_protegida_a_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_mattransp_check CHECK (mattransp <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,31::SMALLINT,5::SMALLINT,6::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_finalidade_check CHECK (finalidade = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_posicaorelativa_check CHECK (posicaorelativa = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_setor_check CHECK (setor = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.dut_galeria_bueiro_l ADD CONSTRAINT dut_galeria_bueiro_l_tipotrechoduto_check CHECK (tipotrechoduto = ANY(ARRAY[5::SMALLINT]))#
ALTER TABLE pe.rel_pico_p ADD CONSTRAINT rel_pico_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rel_pico_p ADD CONSTRAINT rel_pico_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[22::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_matconstr_check CHECK (matconstr <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.hdv_eclusa_l ADD CONSTRAINT hdv_eclusa_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.lpal_municipio_a ADD CONSTRAINT lpal_municipio_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_matconstr_check CHECK (matconstr <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.hdv_eclusa_a ADD CONSTRAINT hdv_eclusa_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_sistemageodesico_check CHECK (sistemageodesico = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT]))#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_tipoptocontrole_check CHECK (tipoptocontrole = ANY(ARRAY[12::SMALLINT,13::SMALLINT,9::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_tiporef_check CHECK (tiporef = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT]))#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_referencialaltim_check CHECK (referencialaltim = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.pto_pto_controle_p ADD CONSTRAINT pto_pto_controle_p_materializado_check CHECK (materializado = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_tipopavimentacao_check CHECK (tipopavimentacao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_necessitamanutencao_check CHECK (necessitamanutencao = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_posicaopista_check CHECK (posicaopista = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.tra_obra_de_arte_viaria ADD CONSTRAINT tra_obra_de_arte_viaria_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.rel_elemento_fisiog_natural_l ADD CONSTRAINT rel_elemento_fisiog_natural_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rel_elemento_fisiog_natural_l ADD CONSTRAINT rel_elemento_fisiog_natural_l_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_usoprincipal_check CHECK (usoprincipal = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.hid_barragem_p ADD CONSTRAINT hid_barragem_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.lpal_posic_geo_localidade_p ADD CONSTRAINT lpal_posic_geo_localidade_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.lpal_posic_geo_localidade_p ADD CONSTRAINT lpal_posic_geo_localidade_p_tipolocalidade_check CHECK (tipolocalidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_revestimento_check CHECK (revestimento = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_canteirodivisorio_check CHECK (canteirodivisorio = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_jurisdicao_check CHECK (jurisdicao = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_tipopavimentacao_check CHECK (tipopavimentacao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_trafego_check CHECK (trafego = ANY(ARRAY[1::SMALLINT,2::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_trechoemperimetrourbano_check CHECK (trechoemperimetrourbano = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_acostamento_check CHECK (acostamento = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_administracao_check CHECK (administracao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.rod_trecho_rodoviario_l ADD CONSTRAINT rod_trecho_rodoviario_l_tipotrechorod_check CHECK (tipotrechorod = ANY(ARRAY[2::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT]))#
ALTER TABLE pe.rel_elemento_fisiog_natural_a ADD CONSTRAINT rel_elemento_fisiog_natural_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rel_elemento_fisiog_natural_a ADD CONSTRAINT rel_elemento_fisiog_natural_a_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_antropizada_check CHECK (antropizada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_secundaria_check CHECK (secundaria = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_classificacaoporte_check CHECK (classificacaoporte = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,98::SMALLINT]))#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_densidade_check CHECK (densidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_veg_natural_a ADD CONSTRAINT veg_veg_natural_a_tipoveg_check CHECK (tipoveg = ANY(ARRAY[10::SMALLINT,11::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_terreno_suj_inundacao_a ADD CONSTRAINT hid_terreno_suj_inundacao_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.lpal_linha_de_limite_l ADD CONSTRAINT lpal_linha_de_limite_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.lpal_linha_de_limite_l ADD CONSTRAINT lpal_linha_de_limite_l_referenciallegal_check CHECK (referenciallegal = ANY(ARRAY[10::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,96::SMALLINT]))#
ALTER TABLE pe.hid_ponto_inicio_drenagem_p ADD CONSTRAINT hid_ponto_inicio_drenagem_p_nascente_check CHECK (nascente = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_ponto_inicio_drenagem_p ADD CONSTRAINT hid_ponto_inicio_drenagem_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_ponto_inicio_drenagem_p ADD CONSTRAINT hid_ponto_inicio_drenagem_p_relacionado_check CHECK (relacionado = ANY(ARRAY[39::SMALLINT]))#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_usoprincipal_check CHECK (usoprincipal = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.hid_barragem_a ADD CONSTRAINT hid_barragem_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_tipousocaminhoaer_check CHECK (tipousocaminhoaer = ANY(ARRAY[21::SMALLINT,22::SMALLINT,95::SMALLINT,98::SMALLINT]))#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.tra_caminho_aereo_l ADD CONSTRAINT tra_caminho_aereo_l_tipocaminhoaereo_check CHECK (tipocaminhoaereo = ANY(ARRAY[12::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_usoprincipal_check CHECK (usoprincipal = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.hid_barragem_l ADD CONSTRAINT hid_barragem_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_antropizada_check CHECK (antropizada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_secundaria_check CHECK (secundaria = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_classificacaoporte_check CHECK (classificacaoporte = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,98::SMALLINT]))#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_densidade_check CHECK (densidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_brejo_pantano_a ADD CONSTRAINT veg_brejo_pantano_a_tipoveg_check CHECK (tipoveg = ANY(ARRAY[10::SMALLINT]))#
ALTER TABLE pe.rel_elemento_fisiog_natural_p ADD CONSTRAINT rel_elemento_fisiog_natural_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rel_elemento_fisiog_natural_p ADD CONSTRAINT rel_elemento_fisiog_natural_p_tipoelemnat_check CHECK (tipoelemnat = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_ovgd_check CHECK (ovgd = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_posicaoreledific_check CHECK (posicaoreledific = ANY(ARRAY[14::SMALLINT,17::SMALLINT,18::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.enc_torre_comunic_p ADD CONSTRAINT enc_torre_comunic_p_modalidade_check CHECK (modalidade <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_causaexposicao_check CHECK (causaexposicao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rel_terreno_exposto_a ADD CONSTRAINT rel_terreno_exposto_a_tipoterrexp_check CHECK (tipoterrexp = ANY(ARRAY[12::SMALLINT,18::SMALLINT,23::SMALLINT,24::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.rel_terreno_erodido_a ADD CONSTRAINT rel_terreno_erodido_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rel_terreno_erodido_a ADD CONSTRAINT rel_terreno_erodido_a_tipoerosao_check CHECK (tipoerosao = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.rel_terreno_erodido_a ADD CONSTRAINT rel_terreno_erodido_a_situacaoterreno_check CHECK (situacaoterreno = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_causa_check CHECK (causa = ANY(ARRAY[2::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_tiposumvert_check CHECK (tiposumvert = ANY(ARRAY[1::SMALLINT,2::SMALLINT]))#
ALTER TABLE pe.hid_sumidouro_vertedouro_p ADD CONSTRAINT hid_sumidouro_vertedouro_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.tra_trilha_picada_l ADD CONSTRAINT tra_trilha_picada_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_situacaoespacial_check CHECK (situacaoespacial = ANY(ARRAY[12::SMALLINT,13::SMALLINT,2::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_tipotravessiaped_check CHECK (tipotravessiaped = ANY(ARRAY[10::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_matconstr_check CHECK (matconstr = ANY(ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.tra_travessia_pedestre ADD CONSTRAINT tra_travessia_pedestre_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.rel_ponto_cotado_altimetrico_p ADD CONSTRAINT rel_ponto_cotado_altimetrico_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.rel_ponto_cotado_altimetrico_p ADD CONSTRAINT rel_ponto_cotado_altimetrico_p_cotacomprovada_check CHECK (cotacomprovada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_confluencia_p ADD CONSTRAINT hid_confluencia_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_confluencia_p ADD CONSTRAINT hid_confluencia_p_relacionado_check CHECK (relacionado = ANY(ARRAY[16::SMALLINT]))#
ALTER TABLE pe.dut_ramificacao_p ADD CONSTRAINT dut_ramificacao_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.dut_ramificacao_p ADD CONSTRAINT dut_ramificacao_p_relacionado_check CHECK (relacionado = ANY(ARRAY[37::SMALLINT]))#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_modaluso_check CHECK (modaluso <@ ARRAY[10::SMALLINT,14::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,9::SMALLINT])#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_finalidadepatio_check CHECK (finalidadepatio <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.tra_patio ADD CONSTRAINT tra_patio_administracao_check CHECK (administracao <@ ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT])#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_unidadevolume_check CHECK (unidadevolume = ANY(ARRAY[1::SMALLINT,2::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_tipodepgeral_check CHECK (tipodepgeral <@ ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,19::SMALLINT,2::SMALLINT,26::SMALLINT,3::SMALLINT,32::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_tipoconteudo_check CHECK (tipoconteudo <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT])#
ALTER TABLE pe.eco_deposito_geral ADD CONSTRAINT eco_deposito_geral_tipoprodutoresiduo_check CHECK (tipoprodutoresiduo <@ ARRAY[100::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,23::SMALLINT,24::SMALLINT,25::SMALLINT,26::SMALLINT,27::SMALLINT,28::SMALLINT,29::SMALLINT,3::SMALLINT,30::SMALLINT,31::SMALLINT,32::SMALLINT,33::SMALLINT,34::SMALLINT,35::SMALLINT,36::SMALLINT,37::SMALLINT,38::SMALLINT,39::SMALLINT,40::SMALLINT,41::SMALLINT,42::SMALLINT,43::SMALLINT,45::SMALLINT,46::SMALLINT,47::SMALLINT,48::SMALLINT,49::SMALLINT,5::SMALLINT,50::SMALLINT,51::SMALLINT,52::SMALLINT,53::SMALLINT,54::SMALLINT,55::SMALLINT,56::SMALLINT,57::SMALLINT,58::SMALLINT,59::SMALLINT,6::SMALLINT,60::SMALLINT,61::SMALLINT,62::SMALLINT,63::SMALLINT,64::SMALLINT,65::SMALLINT,66::SMALLINT,67::SMALLINT,68::SMALLINT,69::SMALLINT,70::SMALLINT,71::SMALLINT,72::SMALLINT,73::SMALLINT,74::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,78::SMALLINT,79::SMALLINT,80::SMALLINT,81::SMALLINT,82::SMALLINT,83::SMALLINT,84::SMALLINT,85::SMALLINT,86::SMALLINT,87::SMALLINT,88::SMALLINT,89::SMALLINT,90::SMALLINT,91::SMALLINT,92::SMALLINT,93::SMALLINT,94::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_matcondutor_check CHECK (matcondutor = ANY(ARRAY[25::SMALLINT,26::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_emduto_check CHECK (emduto = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_posicaorelativa_check CHECK (posicaorelativa = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.enc_trecho_comunic_l ADD CONSTRAINT enc_trecho_comunic_l_tipotrechocomunic_check CHECK (tipotrechocomunic = ANY(ARRAY[3::SMALLINT,4::SMALLINT,7::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_usoprincipal_check CHECK (usoprincipal = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_finalidade_check CHECK (finalidade = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,4::SMALLINT,95::SMALLINT])#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_l ADD CONSTRAINT hid_canal_vala_l_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[30::SMALLINT,31::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_tipoequipdesenvsocial_check CHECK (tipoequipdesenvsocial = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,12::SMALLINT,13::SMALLINT,14::SMALLINT,15::SMALLINT,16::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,2::SMALLINT,20::SMALLINT,21::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_unidadevolume_check CHECK (unidadevolume = ANY(ARRAY[1::SMALLINT,2::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_situacaoagua_check CHECK (situacaoagua = ANY(ARRAY[6::SMALLINT,7::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_tipodepgeral_check CHECK (tipodepgeral = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,19::SMALLINT,2::SMALLINT,26::SMALLINT,3::SMALLINT,32::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_localizacaoequipdesenvsocial_check CHECK (localizacaoequipdesenvsocial = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_finalidadedep_check CHECK (finalidadedep = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_abast_agua_p ADD CONSTRAINT sb_dep_abast_agua_p_tratamento_check CHECK (tratamento = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_materialpredominante_check CHECK (materialpredominante = ANY(ARRAY[12::SMALLINT,13::SMALLINT,14::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,4::SMALLINT,50::SMALLINT,95::SMALLINT,97::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_tipobanco_check CHECK (tipobanco = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT]))#
ALTER TABLE pe.hid_banco_areia_a ADD CONSTRAINT hid_banco_areia_a_situacaoemagua_check CHECK (situacaoemagua = ANY(ARRAY[4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_queda_dagua_l ADD CONSTRAINT hid_queda_dagua_l_tipoqueda_check CHECK (tipoqueda = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_queda_dagua_l ADD CONSTRAINT hid_queda_dagua_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.enc_est_gerad_energia_eletrica ADD CONSTRAINT enc_est_gerad_energia_eletrica_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.enc_est_gerad_energia_eletrica ADD CONSTRAINT enc_est_gerad_energia_eletrica_tipoestgerad_check CHECK (tipoestgerad = ANY(ARRAY[5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.enc_est_gerad_energia_eletrica ADD CONSTRAINT enc_est_gerad_energia_eletrica_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.enc_est_gerad_energia_eletrica ADD CONSTRAINT enc_est_gerad_energia_eletrica_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_antropizada_check CHECK (antropizada = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_secundaria_check CHECK (secundaria = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_classificacaoporte_check CHECK (classificacaoporte = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,98::SMALLINT]))#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_densidade_check CHECK (densidade = ANY(ARRAY[1::SMALLINT,2::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.veg_campinarana_a ADD CONSTRAINT veg_campinarana_a_tipoveg_check CHECK (tipoveg = ANY(ARRAY[6::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_usoprincipal_check CHECK (usoprincipal = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_finalidade_check CHECK (finalidade = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,4::SMALLINT,95::SMALLINT])#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.hid_canal_vala_a ADD CONSTRAINT hid_canal_vala_a_tipoalterantrop_check CHECK (tipoalterantrop = ANY(ARRAY[30::SMALLINT,31::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_tipoexposicao_check CHECK (tipoexposicao = ANY(ARRAY[3::SMALLINT,4::SMALLINT,5::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_operacional_check CHECK (operacional = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_unidadevolume_check CHECK (unidadevolume = ANY(ARRAY[1::SMALLINT,2::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_estadofisico_check CHECK (estadofisico = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT,98::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_matconstr_check CHECK (matconstr <@ ARRAY[1::SMALLINT,2::SMALLINT,23::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,8::SMALLINT,95::SMALLINT,97::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_situacaofisica_check CHECK (situacaofisica = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT,97::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_tipodepgeral_check CHECK (tipodepgeral = ANY(ARRAY[1::SMALLINT,10::SMALLINT,11::SMALLINT,19::SMALLINT,2::SMALLINT,26::SMALLINT,3::SMALLINT,32::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,8::SMALLINT,9::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_tipoconteudo_check CHECK (tipoconteudo <@ ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,95::SMALLINT])#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_tipoprodutoresiduo_check CHECK (tipoprodutoresiduo <@ ARRAY[17::SMALLINT,20::SMALLINT,21::SMALLINT,58::SMALLINT,66::SMALLINT,75::SMALLINT,76::SMALLINT,77::SMALLINT,95::SMALLINT,99::SMALLINT])#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_finalidadedep_check CHECK (finalidadedep = ANY(ARRAY[2::SMALLINT,3::SMALLINT,4::SMALLINT,8::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.sb_dep_saneamento_p ADD CONSTRAINT sb_dep_saneamento_p_tratamento_check CHECK (tratamento = ANY(ARRAY[0::SMALLINT,1::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_materialpredominante_check CHECK (materialpredominante = ANY(ARRAY[12::SMALLINT,13::SMALLINT,14::SMALLINT,17::SMALLINT,18::SMALLINT,19::SMALLINT,20::SMALLINT,21::SMALLINT,22::SMALLINT,4::SMALLINT,50::SMALLINT,95::SMALLINT,97::SMALLINT,98::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_tipobanco_check CHECK (tipobanco = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT]))#
ALTER TABLE pe.hid_banco_areia_l ADD CONSTRAINT hid_banco_areia_l_situacaoemagua_check CHECK (situacaoemagua = ANY(ARRAY[4::SMALLINT,5::SMALLINT,7::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.hid_foz_maritima_p ADD CONSTRAINT hid_foz_maritima_p_geometriaaproximada_check CHECK (geometriaaproximada = ANY(ARRAY[0::SMALLINT,1::SMALLINT]))#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_sistemageodesico_check CHECK (sistemageodesico = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT]))#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_proximidade_check CHECK (proximidade = ANY(ARRAY[14::SMALLINT,15::SMALLINT,16::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_tipoptorefgeodtopo_check CHECK (tipoptorefgeodtopo = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,8::SMALLINT,95::SMALLINT,99::SMALLINT]))#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_situacaomarco_check CHECK (situacaomarco = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT,5::SMALLINT,6::SMALLINT,7::SMALLINT,95::SMALLINT]))#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_tiporef_check CHECK (tiporef = ANY(ARRAY[1::SMALLINT,2::SMALLINT,3::SMALLINT,4::SMALLINT]))#
ALTER TABLE pe.pto_pto_ref_geod_topo_p ADD CONSTRAINT pto_pto_ref_geod_topo_p_referencialaltim_check CHECK (referencialaltim = ANY(ARR