# -*- coding: utf-8 -*-
"""
/***************************************************************************
 DissolveWithStatsDialog
                                 A QGIS plugin
 Group entities with same value for one field, calculate statistics on the other fields
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-02-19
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Julie Pierson, UMR 5319 Passages, CNRS
        email                : julie.pierson@cnrs.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic, QtWidgets, QtCore
#from PyQt5 import QtGui
from qgis.core import QgsMessageLog, Qgis, QgsProviderRegistry
#from qgis.gui import QgsMessageBar
from qgis.utils import iface


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'dissolve_stats_dialog_base.ui'))


class DissolveWithStatsDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(DissolveWithStatsDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        # input layer combobox must show only vector layers
        providers = QgsProviderRegistry.instance().providerList()
        vector_providers = ['ogr', 'memory', 'postgres', 'spatialite', 'virtual']
        providers = [i for i in providers if i not in vector_providers]
        self.mMapLayerComboBox.setExcludedProviders(providers)
        
        # connect changed index signal in comboLayerList
        self.mMapLayerComboBox.currentIndexChanged[int].connect(self.onChangedValueLayer)
        # connect changed index signal in comboFieldList
        self.mFieldComboBox.currentIndexChanged[int].connect(self.onChangedValueField)
        # connect click on browse button for output to display file dialog for output file
        self.outButton.clicked.connect(self.outFile)
        # connect OK button with validation test for input paramaters
        self.buttonBox.accepted.connect(self.validation)

        # populate field combobox and table
        self.onChangedValueLayer(self.mMapLayerComboBox.currentIndex())
        # populate the table header
        listHeaders = ["name", "type", "keep", "stat"]
        self.tableWidget.setHorizontalHeaderLabels(listHeaders)
        # set column widths for table
        self.tableWidget.setColumnWidth(0,120)
        self.tableWidget.setColumnWidth(1,80)
        self.tableWidget.setColumnWidth(2,80)
        self.tableWidget.setColumnWidth(3,100)

    # check if all the dialog parameters are valid
    def validation(self):
        # testing for input layer
        if not self.mMapLayerComboBox.currentLayer():
            iface.messageBar().pushMessage("Error", "Please select a valid vector layer for input", level=Qgis.Critical)
        # testing for output layer
        if not self.outLayerName.text():
            iface.messageBar().pushMessage("Error", "Please choose a path and a name for output layer", level=Qgis.Critical)
        # input layer must have at least one field
        if self.mFieldComboBox.currentIndex() == -1:
            iface.messageBar().pushMessage("Error", "Input layer must have at least one column", level=Qgis.Critical)
        # at least one field must be kept for output layer
    
    # if selected value in comboLayerList changes :
    # actualize the values in comboFieldList and in tableFields
    def onChangedValueLayer(self, index):
        # get selected layer from combobox if one
        if index != -1:
            selectedLayer = self.mMapLayerComboBox.currentLayer()
            # if selected layer is loaded (name selected in combobox from canvas layers)
            if selectedLayer:
                QgsMessageLog.logMessage('selectedLayer : ' + str(selectedLayer.name()))
            # retrieve selected layer fields
            fields = selectedLayer.fields()
            # add as many rows in the field table as fields in the shape, minus one
            self.tableWidget.setRowCount(len(fields))
            # populate columns in field table for each field
            for i in range (self.tableWidget.rowCount()):
                # first column : field names
                nameitem = QtWidgets.QTableWidgetItem(fields[i].name())
                # the names are not editable
                nameitem.setFlags(QtCore.Qt.ItemIsSelectable |  QtCore.Qt.ItemIsEnabled)
                self.tableWidget.setItem(i, 0, nameitem)
                # second column : field types
                typeitem = QtWidgets.QTableWidgetItem(fields[i].typeName())
                # the types are not editable
                typeitem.setFlags(QtCore.Qt.ItemIsSelectable |  QtCore.Qt.ItemIsEnabled)
                self.tableWidget.setItem(i, 1, typeitem)
                # third column : check box
                keepcheckbox = QtWidgets.QCheckBox()
                keepcheckbox.setCheckState(QtCore.Qt.Checked)
                self.tableWidget.setCellWidget(i, 2, keepcheckbox)
                # 4th, 5th and 6th columns : stat
                listOfLists = [QtWidgets.QComboBox() for _ in range(3)]
                # for each statistic column
                for j in range(3):
                    # get available statistics for this field
                    listOfLists[j].addItems(self.availableStatistics(fields[i]))
                    # populate combobox with statistics list
                    self.tableWidget.setCellWidget(i, j+3, listOfLists[j])
            # populate field combobox from selected layer fields
            self.mFieldComboBox.setLayer(selectedLayer)
            # select first field
            if len(fields) > 0:
                self.mFieldComboBox.setField(fields[0].name())

    
    # if selected value in comboFieldList changes :
    # re-enable the stats list for ex-selected value if one, disable it for selected value
    def onChangedValueField(self, index):
        # enable all field lists
        for i in range (self.tableWidget.rowCount()):
            for j in range(2,4):
                self.tableWidget.cellWidget(i, j).setEnabled(True)
        # disable current field list
        if index != -1:
            for j in range(2,4):
                self.tableWidget.cellWidget(index, j).setEnabled(False)
    
    # return available statistics for a given field (i.e mean can only be calculated for a numeric field)
    def availableStatistics(self, field):
        # if field is numeric (works also for PostGIS data, fix by DelazJ, and for int64 and double, fix by A. Ferraton)
        if field.type() in [QtCore.QVariant.Int, QtCore.QVariant.Double, 2, 4, 6]:
            statList = ["Count", "First", "Last", "Max", "Mean", "Median", "Min", "Standard deviation", "Sum"]
        else:
        # if field is not numeric (string)
            statList = ["Count", "Concatenation", "First", "Last", "Uniquification"]
        return statList
    
    # get output file path
    def outFile(self):
        # display file dialog for output file
        outFile = QtWidgets.QFileDialog.getSaveFileName(self, 'Save as', '', "Shapefile (*.shp);;GeoPackage (*.gpkg)")
        # get file format, for example : .shp
        outFileFormat = outFile[1].split('*')[-1][:-1]
        # get file name, for example /path/to/file.shp
        outFileName = outFile[0]
        if not outFileName.endswith(outFileFormat):
            outFileName = outFileName + outFileFormat
        # populate QLineEdit widget with output file path
        self.outLayerName.setText(outFileName)
        return outFileName
        