# coding=utf-8
"""Dialog test.

.. note:: This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

"""

__author__ = 'bojana.n.obrenovic@gmail.com'
__date__ = '2018-05-25'
__copyright__ = 'Copyright 2018, Bojana Obrenović'

import unittest

from PyQt4.QtGui import QDialogButtonBox, QDialog

from direkcioni_ugao_dialog import DirekcioniUgaoDialog

from utilities import get_qgis_app
QGIS_APP = get_qgis_app()


class DirekcioniUgaoDialogTest(unittest.TestCase):
    """Test dialog works."""

    def setUp(self):
        """Runs before each test."""
        self.dialog = DirekcioniUgaoDialog(None)

    def tearDown(self):
        """Runs after each test."""
        self.dialog = None

    def test_dialog_ok(self):
        """Test we can click OK."""

        button = self.dialog.button_box.button(QDialogButtonBox.Ok)
        button.click()
        result = self.dialog.result()
        self.assertEqual(result, QDialog.Accepted)

    def test_dialog_cancel(self):
        """Test we can click cancel."""
        button = self.dialog.button_box.button(QDialogButtonBox.Cancel)
        button.click()
        result = self.dialog.result()
        self.assertEqual(result, QDialog.Rejected)

if __name__ == "__main__":
    suite = unittest.makeSuite(DirekcioniUgaoDialogTest)
    runner = unittest.TextTestRunner(verbosity=2)
    runner.run(suite)

