# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Delete_DuplicateDialog
                                 A QGIS plugin
 Delete duplicate or redundant fields from a vector file
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-06-04
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Blair William Gerald Scriven
        email                : scrivenblair@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os, pandas as pd

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsMapLayerProxyModel, QgsVectorLayer

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'Delete_Duplicates_dialog_base.ui'))


class Delete_DuplicateDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(Delete_DuplicateDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Define the MapLayer_ComboBox and set the "get Duplicate fields" function
        self.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.VectorLayer)
        self.mMapLayerComboBox.setCurrentIndex(-1) #clear the selection
        self.mMapLayerComboBox.layerChanged.connect(self.Get_Dupes)

        # Set appropriate function for button when clicked 
        self.pushButton.clicked.connect(self.delete_fields)

        # Set appropriate function when checkbox is checked or unchecked
        self.checkBox.stateChanged.connect(self.Select_all)

    def Get_Dupes(self):
        self.listWidget.clear() # Clear the list of fields
        self.pushButton.setEnabled(True) # enable the push button only when there is a selected layer
        self.checkBox.setEnabled(True)
        
        Vector_data = self.mMapLayerComboBox.currentLayer()
        if type(Vector_data) is not QgsVectorLayer: # error handling
            self.pushButton.setEnabled(False)
            return

        int_feilds = Vector_data.fields() # Identify attribute fields
        field_names = int_feilds.names() # list of field names

        # Example of a list Comprehension; find each feature (row in table) and find its value for each column; outputs a generator
        datagen = ([f[col] for col in field_names] for f in Vector_data.getFeatures())

        # Following code block will convert attribute data into pandas dataframe, then the Null fields will be identified
        df = pd.DataFrame.from_records(data=datagen, columns=field_names)

        ### START CODE FROM ANKTHON (GEEKSFORGEEKS) - FIND DUPLICATES IN PANDAS DATAFRAME ###
        duplicateColumnNames = set()
        for x in range(df.shape[1]):
            col = df.iloc[:, x]
            for y in range(x + 1, df.shape[1]):
                otherCol = df.iloc[:, y]
                if col.equals(otherCol):
                    duplicateColumnNames.add(df.columns.values[y])
        duplicateCol_Names = list(duplicateColumnNames)
        ### END CODE SECTION - THANKS ANKTHON ###
        
        self.listWidget.addItems(duplicateCol_Names)
    
    def delete_fields(self):
        # Move items in QListWidget into a python list
        QT_items = self.listWidget.selectedItems()
        duplicateCol_Names = []
        for x in range(len(QT_items)):
            duplicateCol_Names.append(str(self.listWidget.selectedItems()[x].text()))

        Vector_data = self.mMapLayerComboBox.currentLayer()
        int_feilds = Vector_data.fields() # Identify attribute fields

        del_index = []
        for field in duplicateCol_Names:
            del_index.append(int_feilds.indexFromName(field)) # create a list of feild indices to delete
        
        # access the real datasource behind your layer, delete the duolicate fields and update the data
        data_provider = Vector_data.dataProvider() 
        data_provider.deleteAttributes(del_index)
        Vector_data.updateFields()
        Vector_data.commitChanges()

        # Clear the selection and return to defaults
        Vector_data.removeSelection()
        self.mMapLayerComboBox.setCurrentIndex(-1) 
        self.listWidget.clear() # Clear the list of fields
        self.checkBox.setChecked(False) # reset the checkbox
        self.pushButton.setEnabled(False)
        self.checkBox.setEnabled(False)
        return

    def Select_all(self):
        check = self.checkBox.isChecked()
        if check is True:
            self.listWidget.selectAll()
        if check is False:
            self.listWidget.clearSelection()
        return


        


