# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DeepLearningTools
                                 A QGIS plugin
 QGIS plugin to aid training Deep Learning Models
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-04-03
        copyright            : (C) 2020 by Philipe Borba
        email                : philipeborba@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QCoreApplication

import os
from collections import defaultdict
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterField,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterBoolean,
                       QgsProcessingException,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterString,
                       QgsProcessingOutputVectorLayer,
                       QgsProcessingParameterExtent,
                       QgsFeatureRequest,
                       QgsProject,
                       QgsRasterLayer,
                       QgsExpression,
                       QgsExpressionContext,
                       QgsExpressionContextUtils,
                       QgsSpatialIndex,
                       QgsProcessingMultiStepFeedback,
                       QgsProcessingFeatureSourceDefinition
                       )
from DeepLearningTools.core.image_processing.image_utils import ImageUtils
from qgis.utils import iface
import processing
import math, random

class CreateTrainTestValidateSamplesAlgorithm(QgsProcessingAlgorithm):
    """
    Algorithm to group layers according to primitive, dataset and a category.
    INPUT_LAYERS: list of QgsVectorLayer
    CATEGORY_TOKEN: token used to split layer name
    CATEGORY_TOKEN_INDEX: index of the split list
    OUTPUT: list of outputs
    """
    INPUT = 'INPUT'
    PK_FIELD = 'PK_FIELD'
    TRAIN_PERCENTAGE = 'TRAIN_PERCENTAGE'
    TEST_PERCENTAGE = 'TEST_PERCENTAGE'
    TRAIN_DATASET = 'TRAIN_DATASET'
    TEST_DATASET = 'TEST_DATASET'
    VALIDATION_DATASET = 'VALIDATION_DATASET'
    def initAlgorithm(self, config):
        """
        Parameter setting.
        """
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('Input layer'),
                [QgsProcessing.TypeVector]
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                self.TRAIN_PERCENTAGE,
                self.tr('Train dataset percentage'),
                minValue=0,
                defaultValue=60,
                maxValue=100
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.TEST_PERCENTAGE,
                self.tr('Test dataset percentage (validate percentage will be the complement of the sum of train and test)'),
                minValue=0,
                defaultValue=20,
                maxValue=100
            )
        )
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.TRAIN_DATASET,
                self.tr('Train dataset')
            )
        )
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.TEST_DATASET,
                self.tr('Test dataset')
            )
        )
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.VALIDATION_DATASET,
                self.tr('Validation dataset')
            )
        )


    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(
            parameters,
            self.INPUT,
            context
        )

        trainPercentage = self.parameterAsDouble(
            parameters,
            self.TRAIN_PERCENTAGE,
            context
        )
        testPercentage = self.parameterAsDouble(
            parameters,
            self.TEST_PERCENTAGE,
            context
        )
        (train_sink, train_dest_id) = self.parameterAsSink(
            parameters,
            self.TRAIN_DATASET,
            context,
            source.fields(),
            source.wkbType(),
            source.sourceCrs()
        )
        (test_sink, test_dest_id) = self.parameterAsSink(
            parameters,
            self.TEST_DATASET,
            context,
            source.fields(),
            source.wkbType(),
            source.sourceCrs()
        )
        (val_sink, val_dest_id) = self.parameterAsSink(
            parameters,
            self.VALIDATION_DATASET,
            context,
            source.fields(),
            source.wkbType(),
            source.sourceCrs()
        )
        inputFeats = set(feat for feat in source.getFeatures())
        #training data
        train_size = math.ceil(len(inputFeats)*trainPercentage/100)
        trainSet = set(random.sample(inputFeats, train_size))
        #test data
        test_size = math.ceil(len(inputFeats)*testPercentage/100)
        complementSet = inputFeats.difference(trainSet)
        testSet = set(random.sample(complementSet, test_size))
        #validation data
        valSet = complementSet.difference(testSet)

        train_sink.addFeatures(
            trainSet,
            QgsFeatureSink.FastInsert
        )

        test_sink.addFeatures(
            testSet,
            QgsFeatureSink.FastInsert
        )

        val_sink.addFeatures(
            valSet,
            QgsFeatureSink.FastInsert
        )
        return {
            self.TRAIN_DATASET: train_dest_id,
            self.TEST_DATASET: test_dest_id,
            self.VALIDATION_DATASET: val_dest_id
        }


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'createtraintestvalidatesamples'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Create train test validate samples')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Dataset Tools')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'datasettools'

    def tr(self, string):
        """
        Translates input string.
        """
        return QCoreApplication.translate('CreateTrainTestValidateSamplesAlgorithm', string)

    def createInstance(self):
        """
        Creates an instance of this class
        """
        return CreateTrainTestValidateSamplesAlgorithm()
